<?php $__env->startSection('content'); ?>
<?php
use App\Models\EmpRatio;
use App\Models\EmpPOSStores;
use App\Models\AllowencesEmp;
use App\Models\DiscountsEmp;
use App\Models\EmpsProducationQuantity;
use App\Models\AttendencePolicyEmp;
use App\Models\DepaarturePolicyEmp;
?>
<title><?php echo e(trans('admin.Emp_Sechdule')); ?></title>


<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.HR')); ?></a></li>
        <li class="breadcrumb-item active"> <?php echo e(trans('admin.Emp_Sechdule')); ?> </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <!-- data entry -->

    <div class="row hide-table">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        <?php echo e(trans('admin.Emp_Sechdule')); ?>

                    </h2>

                    <div class="panel-toolbar">
                        <a href="<?php echo e('ExportAllEmployees'); ?>" class="btn btn-success btn-sm">
                            Export Excel
                        </a>

                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                            Style</button>
                        <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                </div>
                <div class="panel-container show">
                    <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                    <div class="panel-content">

                        <!-- datatable start -->
                        <div style="overflow:auto;">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th><?php echo e(trans('admin.Arabic_Name')); ?></th>
                                        <th><?php echo e(trans('admin.English_Name')); ?></th>
                                        <th><?php echo e(trans('admin.Emp_Type')); ?></th>
                                        <th><?php echo e(trans('admin.Salary')); ?></th>
                                        <th><?php echo e(trans('admin.Job')); ?></th>
                                        <th><?php echo e(trans('admin.Department')); ?></th>
                                        <th><?php echo e(trans('admin.Account_Emp')); ?></th>
                                        <th><?php echo e(trans('admin.Details')); ?></th>
                                        <th><?php echo e(trans('admin.Ratio')); ?></th>
                                        <th><?php echo e(trans('admin.Stores')); ?></th>
                                        <th><?php echo e(trans('admin.Allowances')); ?></th>
                                        <th><?php echo e(trans('admin.production_quantity')); ?></th>
                                        <th><?php echo e(trans('admin.Attendence_Policy')); ?></th>
                                        <th><?php echo e(trans('admin.Departure_Policy')); ?></th>
                                        <th><?php echo e(trans('admin.Discounts')); ?></th>
                                        <th><?php echo e(trans('admin.Data')); ?></th>
                                        <th><?php echo e(trans('admin.Actions')); ?> </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td><?php echo e($item->Code); ?></td>
                                        <td><?php echo e($item->Name); ?></td>
                                        <td><?php echo e($item->NameEn); ?></td>
                                        <td>
                                            <?php if($item->Emp_Type == 'Manager'): ?>
                                            <?php echo e(trans('admin.Manager')); ?>

                                            <?php elseif($item->Emp_Type == 'Production_Manager'): ?>
                                            <?php echo e(trans('admin.Production_Manager')); ?>

                                            <?php elseif($item->Emp_Type == 'Saller'): ?>
                                            <?php echo e(trans('admin.Saller')); ?>

                                            <?php elseif($item->Emp_Type == 'Buyer'): ?>
                                            <?php echo e(trans('admin.Buyer')); ?>

                                            <?php elseif($item->Emp_Type == 'Driver'): ?>
                                            <?php echo e(trans('admin.Driver')); ?>

                                            <?php elseif($item->Emp_Type == 'Engineer'): ?>
                                            <?php echo e(trans('admin.Engineer')); ?>

                                            <?php elseif($item->Emp_Type == 'Techinical'): ?>
                                            <?php echo e(trans('admin.Techinical')); ?>

                                            <?php elseif($item->Emp_Type == 'Delivery'): ?>
                                            <?php echo e(trans('admin.Delivery')); ?>

                                            <?php elseif($item->Emp_Type == 'Designer'): ?>
                                            <?php echo e(trans('admin.Designer')); ?>

                                            <?php elseif($item->Emp_Type == 'Programmer'): ?>
                                            <?php echo e(trans('admin.Programmer')); ?>

                                            <?php elseif($item->Emp_Type == 'Accountant'): ?>
                                            <?php echo e(trans('admin.Accountant')); ?>

                                            <?php elseif($item->Emp_Type == 'StoreKeeper'): ?>
                                            <?php echo e(trans('admin.Store_Keeper')); ?>

                                            <?php elseif($item->Emp_Type == 'ObserverQuality'): ?>
                                            <?php echo e(trans('admin.Observer_Quality')); ?>

                                            <?php elseif($item->Emp_Type == 'Supervisor'): ?>
                                            <?php echo e(trans('admin.Supervisor')); ?>

                                            <?php elseif($item->Emp_Type == 'Doctor'): ?>
                                            <?php echo e(trans('admin.Doctor')); ?>

                                            <?php elseif($item->Emp_Type == 'Teacher'): ?>
                                            <?php echo e(trans('admin.Teacher')); ?>

                                            <?php elseif($item->Emp_Type == 'Worker'): ?>
                                            <?php echo e(trans('admin.Worker')); ?>

                                            <?php elseif($item->Emp_Type == 'Nurse'): ?>
                                            <?php echo e(trans('admin.Nurse')); ?>

                                            <?php elseif($item->Emp_Type == 'Cashier'): ?>
                                            <?php echo e(trans('admin.Cashier')); ?>

                                            <?php elseif($item->Emp_Type == 'Chef'): ?>
                                            <?php echo e(trans('admin.Chef')); ?>

                                            <?php elseif($item->Emp_Type == 'Waiter'): ?>
                                            <?php echo e(trans('admin.Waiter')); ?>

                                            <?php elseif($item->Emp_Type == 'Secuirty'): ?>
                                            <?php echo e(trans('admin.Secuirty')); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->Salary); ?></td>

                                        <td>
                                            <?php if(!empty($item->Job)): ?>


                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Job()->first()->Arabic_Name :$item->Job()->first()->English_Name); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(!empty($item->Department)): ?>


                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Department()->first()->Arabic_Name :$item->Department()->first()->English_Name); ?>

                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo e($item->Account_Emp()->first()->Code); ?></td>


                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Details')); ?>

                                            </button>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#ratio<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Ratio')); ?>

                                            </button>
                                        </td>

                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Stores<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Stores')); ?>

                                            </button>
                                        </td>


                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Allownces<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Allowances')); ?>

                                            </button>
                                        </td>


                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#PrQ<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.production_quantity')); ?>

                                            </button>
                                        </td>


                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Attendence_Policy<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Attendence_Policy')); ?>

                                            </button>
                                        </td>


                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Departure_Policy<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Departure_Policy')); ?>

                                            </button>
                                        </td>


                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Discounts<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Discounts')); ?>

                                            </button>
                                        </td>

                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Data<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Data')); ?>

                                            </button>
                                        </td>

                                        <td class="text-center">



                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('حذف موظف')): ?>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center<?php echo e($item->id); ?>"><i class="fal fa-trash"></i></button>
                                            <?php endif; ?>


                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تعديل موظف')): ?>
                                            <a href="<?php echo e(url('EditEmp/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                            <?php endif; ?>

                                            <a href="<?php echo e(url('PrintEmp/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-print"></i></a>
                                            <a href="<?php echo e(url('PrintCardEmp/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-id-card"></i></a>




                                            <a href="<?php echo e(url( $item->Active->url().'/'.$item->id)); ?>" class="<?php echo e($item->Active->color()); ?>"><i class="<?php echo e($item->Active->icon()); ?>"></i></a>



                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th><?php echo e(trans('admin.Arabic_Name')); ?></th>
                                        <th><?php echo e(trans('admin.English_Name')); ?></th>
                                        <th><?php echo e(trans('admin.Emp_Type')); ?></th>
                                        <th><?php echo e(trans('admin.Salary')); ?></th>
                                        <th><?php echo e(trans('admin.Job')); ?></th>
                                        <th><?php echo e(trans('admin.Department')); ?></th>
                                        <th><?php echo e(trans('admin.Account_Emp')); ?></th>
                                        <th><?php echo e(trans('admin.Details')); ?></th>
                                        <th><?php echo e(trans('admin.Ratio')); ?></th>
                                        <th><?php echo e(trans('admin.Stores')); ?></th>
                                        <th><?php echo e(trans('admin.Allowances')); ?></th>
                                        <th><?php echo e(trans('admin.production_quantity')); ?></th>
                                        <th><?php echo e(trans('admin.Attendence_Policy')); ?></th>
                                        <th><?php echo e(trans('admin.Departure_Policy')); ?></th>
                                        <th><?php echo e(trans('admin.Discounts')); ?></th>
                                        <th><?php echo e(trans('admin.Data')); ?></th>
                                        <th><?php echo e(trans('admin.Actions')); ?> </th>
                                    </tr>
                                </tfoot>

                            </table>
                        </div>


                        <?php echo e($items->Links()); ?>


                        <!-- datatable end -->


                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<!-- Modal Delete -->
<div class="modal fade" id="default-example-modal-center<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.RUSWDT')); ?> <strong><?php echo e($item->Code); ?></strong>
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.No')); ?></button>
                <a href="<?php echo e(url('DeleteEmp/'.$item->id)); ?>" class="btn btn-primary"><?php echo e(trans('admin.Yes')); ?></a>
            </div>
        </div>
    </div>
</div>


<!-- Modal Details -->
<div class="modal fade" id="default-example-modal-center-open<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Details')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12" style="overflow:auto">
                        <table id="" class="table table-bordered table-hover table-striped " style="width:120%">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.Attendence')); ?> </th>
                                    <th><?php echo e(trans('admin.Departure')); ?> </th>
                                    <th><?php echo e(trans('admin.Hours_Numbers')); ?> </th>
                                    <th><?php echo e(trans('admin.Days_Numbers')); ?> </th>
                                    <th><?php echo e(trans('admin.Day_Price')); ?> </th>
                                    <th><?php echo e(trans('admin.Image')); ?> </th>
                                    <th><?php echo e(trans('admin.Notes')); ?> </th>
                                    <th><?php echo e(trans('admin.Bank_Account')); ?> </th>
                                    <th><?php echo e(trans('admin.Qualifications')); ?> </th>
                                    <th><?php echo e(trans('admin.Address')); ?> </th>
                                    <th><?php echo e(trans('admin.Social_Status')); ?> </th>
                                    <th><?php echo e(trans('admin.ID_Number')); ?> </th>
                                    <th><?php echo e(trans('admin.Contract_Start')); ?> </th>
                                    <th><?php echo e(trans('admin.Contract_End')); ?> </th>
                                    <th><?php echo e(trans('admin.Phone')); ?> </th>
                                    <th><?php echo e(trans('admin.Phone2')); ?> </th>
                                    <th><?php echo e(trans('admin.Bill_Numbers')); ?> </th>
                                    <th><?php echo e(trans('admin.NumbersOfBill')); ?> </th>
                                    <th><?php echo e(trans('admin.IDExpireDate')); ?> </th>
                                    <th><?php echo e(trans('admin.LicensExpireDate')); ?> </th>
                                    <th><?php echo e(trans('admin.PassportExpireDate')); ?> </th>
                                    <th><?php echo e(trans('admin.Group')); ?> </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>
                                    <td><?php echo e($item->Attendence); ?></td>
                                    <td><?php echo e($item->Departure); ?></td>
                                    <td><?php echo e($item->Hours_Numbers); ?></td>
                                    <td><?php echo e($item->Days_Numbers); ?></td>
                                    <td><?php echo e($item->Day_Price); ?></td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->Image)); ?>">
                                    </td>
                                    <td><?php echo e($item->Note); ?></td>
                                    <td><?php echo e($item->Bank_Account); ?></td>
                                    <td><?php echo e($item->Qualifications); ?></td>
                                    <td><?php echo e($item->Address); ?></td>
                                    <td><?php echo e($item->Social_Status); ?></td>
                                    <td><?php echo e($item->ID_Number); ?></td>
                                    <td><?php echo e($item->Contract_Start); ?></td>
                                    <td><?php echo e($item->Contract_End); ?></td>
                                    <td><?php echo e($item->Phone); ?></td>
                                    <td><?php echo e($item->Phone2); ?></td>
                                    <td>

                                        <?php if($item->Bill_Num == 1): ?>
                                        <?php echo e(trans('admin.Yes')); ?>

                                        <?php else: ?>
                                        <?php echo e(trans('admin.No')); ?>

                                        <?php endif; ?>

                                    </td>
                                    <td><?php echo e($item->NumbersOfBill); ?></td>
                                    <td><?php echo e($item->IDExpireDate); ?></td>
                                    <td><?php echo e($item->LicensExpireDate); ?></td>
                                    <td><?php echo e($item->PassportExpireDate); ?></td>
                                    <td><?php if(!empty($item->Pro_Group()->first()->Name)): ?>


                                        <?php echo e(app()->getLocale() == 'ar' ?$item->Pro_Group()->first()->Name :$item->Pro_Group()->first()->NameEn); ?>


                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- Modal Ratios -->
<div class="modal fade" id="ratio<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Ratio')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <?php $ratios = EmpRatio::where('Emp',$item->id)->get(); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12">
                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.From')); ?> </th>
                                    <th><?php echo e(trans('admin.To')); ?> </th>
                                    <th><?php echo e(trans('admin.Salary')); ?> </th>
                                    <th><?php echo e(trans('admin.Rate')); ?> </th>
                                    <th><?php echo e(trans('admin.Rate_Type')); ?> </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <?php $__currentLoopData = $ratios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($rate->From); ?></td>
                                    <td><?php echo e($rate->To); ?></td>
                                    <td><?php echo e($rate->Salary); ?></td>
                                    <td><?php echo e($rate->Rate); ?></td>
                                    <td><?php echo e($rate->Type); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th><?php echo e(trans('admin.From')); ?> </th>
                                    <th><?php echo e(trans('admin.To')); ?> </th>
                                    <th><?php echo e(trans('admin.Salary')); ?> </th>
                                    <th><?php echo e(trans('admin.Rate')); ?> </th>
                                    <th><?php echo e(trans('admin.Rate_Type')); ?> </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>


<!-- Modal Stores -->
<div class="modal fade" id="Stores<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Ratio')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <?php $posss = EmpPOSStores::where('Emp',$item->id)->get(); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12">
                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.Store')); ?> </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <?php $__currentLoopData = $posss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if(!empty($rate->Store()->first()->Name)): ?>



                                        <?php echo e(app()->getLocale() == 'ar' ?$rate->Store()->first()->Name :$rate->Store()->first()->NameEn); ?>


                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>



<!-- Modal Data -->
<div class="modal fade" id="Data<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Data')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12" style="overflow:auto">
                        <table id="" class="table table-bordered table-hover table-striped" style="width:120%">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.CV')); ?> </th>
                                    <th><?php echo e(trans('admin.ID_Image')); ?> </th>
                                    <th><?php echo e(trans('admin.Criminal_status')); ?> </th>
                                    <th><?php echo e(trans('admin.Contract')); ?> </th>
                                    <th><?php echo e(trans('admin.health_certificate')); ?> </th>
                                    <th><?php echo e(trans('admin.Search_Card')); ?> </th>
                                    <th><?php echo e(trans('admin.Recruitment_certificate')); ?> </th>
                                    <th><?php echo e(trans('admin.employee_profile')); ?> </th>
                                    <th><?php echo e(trans('admin.duration_criminal_investigation')); ?> </th>
                                    <th><?php echo e(trans('admin.Birthdate')); ?> </th>
                                    <th><?php echo e(trans('admin.Attitude_recruiting')); ?> </th>
                                    <th><?php echo e(trans('admin.Job_Number')); ?> </th>
                                    <th><?php echo e(trans('admin.date_resignation')); ?> </th>
                                    <th><?php echo e(trans('admin.Living')); ?> </th>
                                    <th><?php echo e(trans('admin.Branch')); ?> </th>
                                    <th><?php echo e(trans('admin.Level')); ?> </th>
                                    <th><?php echo e(trans('admin.Nationality')); ?> </th>
                                    <th><?php echo e(trans('admin.Religion')); ?> </th>
                                    <th><?php echo e(trans('admin.Insurance_salary')); ?> </th>
                                    <th><?php echo e(trans('admin.Insurance_companies')); ?> </th>
                                    <th><?php echo e(trans('admin.Previous_experience')); ?> </th>
                                    <th><?php echo e(trans('admin.Account')); ?></th>
                                    <th><?php echo e(trans('admin.User')); ?></th>
                                    <th><?php echo e(trans('admin.MonthlyTarget')); ?></th>
                                    <th><?php echo e(trans('admin.QuarterTarget')); ?></th>
                                    <th><?php echo e(trans('admin.SemiTarget')); ?></th>
                                    <th><?php echo e(trans('admin.YearlyTarget')); ?></th>
                                    <th><?php echo e(trans('admin.SearchCode')); ?></th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->CV)); ?>">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->ID_Image)); ?>">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->Criminal_status)); ?>">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->Contract)); ?>">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->health_certificate)); ?>">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->Search_Card)); ?>">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->Recruitment_certificate)); ?>">
                                    </td>
                                    <td>
                                        <img class="img-fluid" src="<?php echo e(URL::to($item->employee_profile)); ?>">
                                    </td>
                                    <td><?php echo e($item->duration_criminal_investigation); ?></td>
                                    <td><?php echo e($item->Birthdate); ?></td>
                                    <td><?php echo e($item->Attitude_recruiting); ?></td>
                                    <td><?php echo e($item->Job_Number); ?></td>
                                    <td><?php echo e($item->date_resignation); ?></td>
                                    <td><?php echo e($item->Living); ?></td>
                                    <td><?php if(!empty($item->Branch)): ?>

                                        <?php echo e(app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php if(!empty($item->Level)): ?>
                                        <?php echo e(app()->getLocale() == 'ar' ?$item->Level()->first()->Arabic_Name :$item->Level()->first()->English_Name); ?>


                                        <?php endif; ?>
                                    </td>
                                    <td><?php if(!empty($item->Nationality)): ?>
                                        <?php echo e(app()->getLocale() == 'ar' ?$item->Nationality()->first()->Arabic_Name :$item->Nationality()->first()->English_Name); ?>


                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->Religion); ?></td>
                                    <td><?php echo e($item->Insurance_salary); ?></td>
                                    <td><?php if(!empty($item->Insurance_companies)): ?>

                                        <?php echo e(app()->getLocale() == 'ar' ?$item->Insurance_companies()->first()->Arabic_Name :$item->Insurance_companies()->first()->English_Name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->Previous_experience); ?></td>
                                    <td>

                                        <?php echo e(app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn); ?>

                                    </td>
                                    <td>

                                        <?php echo e(app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn); ?>

                                    </td>
                                    <td><?php echo e($item->MonthlyTarget); ?></td>
                                    <td><?php echo e($item->QuarterTarget); ?></td>
                                    <td><?php echo e($item->SemiTarget); ?></td>
                                    <td><?php echo e($item->YearlyTarget); ?></td>
                                    <td><?php echo e($item->SearchCode); ?></td>

                                </tr>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>



<!-- Modal Allownces -->
<div class="modal fade" id="Allownces<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Allowances')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <?php $posss = AllowencesEmp::where('Emp',$item->id)->get(); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12">
                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.Name')); ?> </th>
                                    <th><?php echo e(trans('admin.Amount')); ?> </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <?php $__currentLoopData = $posss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if(!empty($rate->Allow()->first()->Arabic_Name)): ?>


                                        <?php echo e(app()->getLocale() == 'ar' ?$rate->Allow()->first()->Arabic_Name :$rate->Allow()->first()->English_Name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>

                                        <?php echo e($rate->AmountAllow); ?>


                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>



<!-- Modal Discounts -->
<div class="modal fade" id="Discounts<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Discounts')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <?php $posss = DiscountsEmp::where('Emp',$item->id)->get(); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12">
                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.Name')); ?> </th>
                                    <th><?php echo e(trans('admin.Amount')); ?> </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <?php $__currentLoopData = $posss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php if(!empty($rate->Discount()->first()->Arabic_Name)): ?>


                                        <?php echo e(app()->getLocale() == 'ar' ?$rate->Discount()->first()->Arabic_Name :$rate->Discount()->first()->English_Name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>

                                        <?php echo e($rate->AmountDiscount); ?>


                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>



<!-- Modal production_quantity -->
<div class="modal fade" id="PrQ<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.production_quantity')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <?php $posss = EmpsProducationQuantity::where('Emp',$item->id)->get(); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12">
                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.From')); ?> </th>
                                    <th><?php echo e(trans('admin.To')); ?> </th>
                                    <th><?php echo e(trans('admin.Value')); ?> </th>

                                </tr>
                            </thead>
                            <tbody id="">
                                <?php $__currentLoopData = $posss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>

                                        <?php echo e($rate->FromQ); ?>


                                    </td>
                                    <td>

                                        <?php echo e($rate->ToQ); ?>


                                    </td>
                                    <td>

                                        <?php echo e($rate->ValueQ); ?>


                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>


<!-- Modal Attendence_Policy -->
<div class="modal fade" id="Attendence_Policy<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Attendence_Policy')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <?php $posss = AttendencePolicyEmp::where('Emp',$item->id)->get(); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12">
                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.From')); ?> </th>
                                    <th><?php echo e(trans('admin.To')); ?> </th>
                                    <th><?php echo e(trans('admin.Discount')); ?> </th>

                                </tr>
                            </thead>
                            <tbody id="">
                                <?php $__currentLoopData = $posss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>

                                        <?php echo e($rate->From); ?>


                                    </td>
                                    <td>

                                        <?php echo e($rate->To); ?>


                                    </td>
                                    <td>

                                        <?php echo e($rate->Discount); ?>


                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>


<!-- Modal Departure_Policy -->
<div class="modal fade" id="Departure_Policy<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Departure_Policy')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <?php $posss = DepaarturePolicyEmp::where('Emp',$item->id)->get(); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="mt-12">
                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('admin.From')); ?> </th>
                                    <th><?php echo e(trans('admin.To')); ?> </th>
                                    <th><?php echo e(trans('admin.Discount')); ?> </th>

                                </tr>
                            </thead>
                            <tbody id="">
                                <?php $__currentLoopData = $posss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>

                                        <?php echo e($rate->From); ?>


                                    </td>
                                    <td>

                                        <?php echo e($rate->To); ?>


                                    </td>
                                    <td>

                                        <?php echo e($rate->Discount); ?>


                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>


<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">
<style>
    th {
        width: 135px !important;
    }
</style>
<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });
</script>

<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2({
                ajax: {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params) {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination: {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup) {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo) {
                if (repo.loading) {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description) {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo) {
                return repo.full_name || repo.text;
            }
        });
    });
</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });
</script>
<script type="text/javascript">
    $(".show-table").click(function() {
        $(".hide-table").show();
    });
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klarapps/public_html/1.klarapps.com/resources/views/admin/HR/EmployeesSechdule.blade.php ENDPATH**/ ?>