<?php $__env->startSection('content'); ?>
    <?php
        use App\Models\ProductSales;
        use App\Models\ExpireDateQty;
        use App\Models\CompanyData;
        use App\Models\GeneralDaily;
        $Def=CompanyData::orderBy('id','desc')->first();
        use App\Models\DefaultDataShowHide;
        $show=DefaultDataShowHide::orderBy('id','desc')->first();
        use App\Models\SalesDefaultData;
        use App\Models\ReturnSales;
        $Deff=SalesDefaultData::orderBy('id','desc')->first();
    ?>

    <title><?php echo e(trans('admin.SalesSechduleTax')); ?></title>


    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.Sales')); ?></a></li>
            <li class="breadcrumb-item active"> <?php echo e(trans('admin.SalesSechduleTax')); ?> </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>


        <!-- Data -->
        <div class="row hide-table">
            <div class="col-xl-12">
                <div id="panel-1" class="panel second-color">
                    <div class="panel-hdr">
                        <h2>
                            <?php echo e(trans('admin.SalesSechduleTax')); ?>

                        </h2>

                        <div class="panel-toolbar">
                            <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                Style</button>
                            <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">

                            <!-- datatable start -->
                            <div style="overflow:auto;">
                                <table id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                                    <thead class="bg-highlight">
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th><?php echo e(trans('admin.Date')); ?></th>
                                        <th> <?php echo e(trans('admin.Payment_Method')); ?></th>
                                        <th> <?php echo e(trans('admin.Executor')); ?> </th>
                                        <th> <?php echo e(trans('admin.Safe')); ?> </th>
                                        <th> <?php echo e(trans('admin.Client')); ?> </th>
                                        <th> <?php echo e(trans('admin.Delegate')); ?> </th>
                                        <th> <?php echo e(trans('admin.Store')); ?> </th>
                                        <th><?php echo e(trans('admin.Details')); ?></th>
                                        <th><?php echo e(trans('admin.Data')); ?></th>
                                        <th><?php echo e(trans('admin.ProfitPrecent')); ?></th>
                                        <th class="text-center"><?php echo e(trans('admin.Actions')); ?> </th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr <?php if($item->Edit == 1): ?> class="edited" <?php elseif($item->Delete == 1): ?> class="deleted"  <?php endif; ?> >
                                            <td><?php echo e($item->Code); ?></td>

                                            <td><?php echo e($item->Date); ?></td>

                                            <td>

                                                <?php if($item->Payment_Method == 'Cash'): ?>
                                                    <?php echo e(trans('admin.Cash')); ?>

                                                <?php elseif($item->Payment_Method == 'Later'): ?>
                                                    <?php echo e(trans('admin.Later')); ?>

                                                <?php elseif($item->Payment_Method == 'Delivery'): ?>
                                                    <?php echo e(trans('admin.Delivery')); ?>

                                                <?php elseif($item->Payment_Method == 'Cash_Visa'): ?>
                                                    <?php echo e(trans('admin.Cash_Visa')); ?>

                                                <?php elseif($item->Payment_Method == 'Cash_Collection'): ?>
                                                    <?php echo e(trans('admin.Cash_Collection')); ?>


                                                <?php elseif($item->Payment_Method == 'Check'): ?>

                                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Check<?php echo e($item->id); ?>"><?php echo e(trans('admin.Check')); ?> </button>
                                                <?php elseif($item->Payment_Method == 'Installment'): ?>

                                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Installment<?php echo e($item->id); ?>"><?php echo e(trans('admin.Installment')); ?> </button>
                                                <?php elseif($item->Payment_Method == 'InstallmentCompanies'): ?>

                                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#InstallmentCompanies<?php echo e($item->id); ?>"><?php echo e(trans('admin.InstallmentCompanies')); ?> </button>
                                                <?php endif; ?>
                                            </td>

                                            <td>
                                                <?php if(!empty($item->Executor()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>



                                            <td>

                                                <?php if(!empty($item->Safe()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($item->Client()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($item->Delegate()->first()->Name)): ?>

                                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($item->Store()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>






                                            <td>
                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open<?php echo e($item->id); ?>">
                                                    <?php echo e(trans('admin.Details')); ?>

                                                </button>
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data<?php echo e($item->id); ?>">
                                                    <?php echo e(trans('admin.Data')); ?>

                                                </button>
                                            </td>


                                            <td>
                                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ProfitPrecent<?php echo e($item->id); ?>">
                                                    <?php echo e(trans('admin.ProfitPrecent')); ?>

                                                </button>
                                            </td>



                                            <?php
                                                $Total_Return_Qty=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Qty');
                                                $Total_Qty=ProductSales::where('Sales',$item->id)->get()->sum('Original_Qty');
                                            ?>


                                            <?php if($Total_Return_Qty !=$Total_Qty): ?>



                                                <td class="text-center" style="width: 20%;">



                                                    <?php if($item->Edit == 0 and $item->Delete == 0): ?>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ارتجاع فاتوره مبيعات')): ?>
                                                            <a href="<?php echo e(url('ReturnSales/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-arrow-right"></i></a>
                                                        <?php endif; ?>

                                                        <a href="<?php echo e(url('SalesPrint/'.$item->id)); ?>" class="btn btn-default">
                                                            <i class="fal fa-print">A4</i>
                                                        </a>

                                                        <a href="<?php echo e(url('SalesPrint5/'.$item->id)); ?>" class="btn btn-default">
                                                            <i class="fal fa-print">A5</i>
                                                        </a>


                                                        <a href="<?php echo e(url('SalesPrint8/'.$item->id)); ?>" class="btn btn-default">
                                                            <i class="fal fa-print">8CM</i>
                                                        </a>


                                                        <a href="<?php echo e(url('SalesTakeGoods/'.$item->id)); ?>" class="btn btn-default" data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('admin.Premission_To_GoodsOut')); ?>">
                                                            <i class="fal fa-print"></i>
                                                        </a>


                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تعديل فاتوره مبيعات')): ?>
                                                            <a href="<?php echo e(url('ESBill/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                                        <?php endif; ?>

                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('حذف فاتوره مبيعات')): ?>
                                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete<?php echo e($item->id); ?>"><i class="fal fa-trash-alt"></i></button>
                                                        <?php endif; ?>

                                                        <?php if($item->Total_Price != $item->Pay): ?>
                                                            <?php if($item->Payment_Method == 'Later'): ?>
                                                                <?php if($item->Later_Collection == 0): ?>


                                                                    <button type="button" class="btn btn-default pos-icon" data-toggle="modal" data-target="#ReciptTwo<?php echo e($item->id); ?>">
                                                                        <a data-toggle="tooltip" data-placement="top" title="<?php echo e(trans('admin.Later_Collection')); ?>">
                                                                            <i class="fal fa-money-bill-alt"></i>
                                                                        </a>
                                                                    </button>


                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endif; ?>

                                                        <?php if($show->client_delivery == 1): ?>

                                                            <a href="<?php echo e(url('ClientDelivery/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-hands"></i></a>


                                                        <?php endif; ?>

                                                    <?php endif; ?>

                                                    <?php if($item->Edit == 1): ?>
                                                        <span class="btn btn-warning"><?php echo e(trans('admin.Edited_to_New_One')); ?> (<?php echo e($item->Edit_New_Code); ?>)</span>
                                                    <?php elseif($item->Delete == 1): ?>

                                                        <span class="btn btn-danger"><?php echo e(trans('admin.Deleted')); ?></span>
                                                    <?php endif; ?>



                                                </td>

                                            <?php else: ?>
                                                <td>

                                                    <?php echo e(trans('admin.FullReturned')); ?>

                                                </td>

                                            <?php endif; ?>


                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th><?php echo e(trans('admin.Date')); ?></th>
                                        <th> <?php echo e(trans('admin.Payment_Method')); ?></th>
                                        <th> <?php echo e(trans('admin.Executor')); ?> </th>
                                        <th> <?php echo e(trans('admin.Safe')); ?> </th>
                                        <th> <?php echo e(trans('admin.Client')); ?> </th>
                                        <th> <?php echo e(trans('admin.Delegate')); ?> </th>
                                        <th> <?php echo e(trans('admin.Store')); ?> </th>

                                        <th><?php echo e(trans('admin.Details')); ?></th>
                                        <th><?php echo e(trans('admin.Data')); ?></th>
                                        <th><?php echo e(trans('admin.ProfitPrecent')); ?></th>
                                        <th class="text-center"><?php echo e(trans('admin.Actions')); ?> </th>
                                    </tr>
                                    </tfoot>

                                </table>

                                <?php echo e($items->Links()); ?>

                            </div>
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <!-- Modal Details -->
        <div class="modal fade" id="default-example-modal-center-open<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            <?php echo e(trans('admin.Details')); ?>

                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">


                        <?php
                            $details=ProductSales::where('Sales',$item->id)->get();
                        ?>
                        <div class="mt-3">
                            <div style="overflow:auto">
                                <table id="" class="table table-bordered table-hover table-striped ">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?> </th>
                                        <?php if($show->Patch_Number == 1): ?>
                                            <th><?php echo e(trans('admin.Patch_Number')); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo e(trans('admin.Name')); ?> </th>
                                        <th><?php echo e(trans('admin.Group')); ?> </th>
                                        <th><?php echo e(trans('admin.Brand')); ?> </th>
                                        <th><?php echo e(trans('admin.Unit')); ?> </th>
                                        <th><?php echo e(trans('admin.AvQty')); ?> </th>
                                        <th><?php echo e(trans('admin.Qty')); ?> </th>
                                        <th><?php echo e(trans('admin.Price')); ?> </th>
                                        <th><?php echo e(trans('admin.Discount')); ?> </th>
                                        <th><?php echo e(trans('admin.Total_Bf_Tax')); ?> </th>
                                        <th><?php echo e(trans('admin.Total_Tax')); ?> </th>
                                        <th><?php echo e(trans('admin.Total')); ?> </th>
                                        <th><?php echo e(trans('admin.Store')); ?> </th>
                                        <th><?php echo e(trans('admin.Exp_Date')); ?> </th>
                                        <th><?php echo e(trans('admin.Desc')); ?> </th>

                                    </tr>
                                    </thead>
                                    <tbody id="">
                                    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php
                                            $fqty=$detail->Original_Qty - $detail->Qty;
                                        ?>
                                        <tr <?php if($detail->Qty == 0): ?> style="background-color:darkred;color:white" <?php elseif($fqty != 0): ?> style="background-color:#21afe4;color:white"<?php elseif($detail->Discount != 0): ?> style="background-color:darkgreen;color:white" <?php endif; ?>>
                                            <td><?php echo e($detail->Product_Code); ?> </td>
                                            <?php if($show->Patch_Number == 1): ?>
                                                <td><?php echo e($detail->Patch_Number); ?></td>
                                            <?php endif; ?>
                                            <td>

                                                <?php if(!empty($detail->Product()->first()->P_Ar_Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name); ?>

                                                <?php endif; ?>

                                                <?php if(!empty($detail->V1()->first()->Name)): ?> (<?php echo e(app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn); ?> ) <?php endif; ?>
                                                <?php if(!empty($detail->V2()->first()->Name)): ?> ((<?php echo e(app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn); ?> )) <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($detail->Product()->first()->Group()->first()->Name)): ?> <?php echo e(app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn); ?> <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($detail->Product()->first()->Brand()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$detail->Product()->first()->Brand()->first()->Name :$detail->Product()->first()->Brand()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($detail->Unit()->first()->Name )): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($detail->AvQty); ?></td>
                                            <td><?php echo e($detail->Qty); ?> (<?php echo e($detail->Original_Qty - $detail->Qty); ?>)</td>
                                            <td><?php echo e($detail->Price); ?></td>
                                            <td><?php echo e($detail->Discount); ?></td>
                                            <td><?php echo e($detail->Total_Bf_Tax); ?></td>
                                            <td><?php echo e($detail->Total_Tax); ?></td>
                                            <td><?php echo e($detail->Total); ?> (<?php echo e(($detail->Original_Qty - $detail->Qty) * $detail->Price); ?>)</td>
                                            <td>
                                                <?php if(!empty($detail->Store()->first()->Name)): ?>
                                                    <?php echo e(app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>

                                                <?php $qqq=ExpireDateQty::find($detail->Exp_Date); ?>
                                                <?php if(!empty($qqq)): ?>
                                                    <?php echo e($qqq->Exp_Date); ?>

                                                <?php endif; ?>

                                            </td>
                                            <td>

                                                <?php echo e($detail->SalesProDesc); ?>


                                            </td>


                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?> </th>
                                        <?php if($show->Patch_Number == 1): ?>
                                            <th><?php echo e(trans('admin.Patch_Number')); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo e(trans('admin.Name')); ?> </th>
                                        <th><?php echo e(trans('admin.Group')); ?> </th>
                                        <th><?php echo e(trans('admin.Brand')); ?> </th>
                                        <th><?php echo e(trans('admin.Unit')); ?> </th>
                                        <th><?php echo e(trans('admin.AvQty')); ?> </th>
                                        <th><?php echo e(trans('admin.Qty')); ?> </th>
                                        <th><?php echo e(trans('admin.Price')); ?> </th>
                                        <th><?php echo e(trans('admin.Discount')); ?> </th>
                                        <th><?php echo e(trans('admin.Total_Bf_Tax')); ?> </th>
                                        <th><?php echo e(trans('admin.Total_Tax')); ?> </th>
                                        <th><?php echo e(trans('admin.Total')); ?> </th>
                                        <th><?php echo e(trans('admin.Store')); ?> </th>
                                        <th><?php echo e(trans('admin.Exp_Date')); ?> </th>
                                        <th><?php echo e(trans('admin.Desc')); ?> </th>

                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div style="overflow:auto">
                                <table class="table table-bordered table-hover table-striped mt-4">
                                    <tbody>

                                    <tr>
                                        <td><?php echo e(trans('admin.Product_Numbers')); ?></td>
                                        <td><?php echo e($item->Product_Numbers); ?></td>

                                        <td><?php echo e(trans('admin.Total_Qty')); ?></td>
                                        <td><?php echo e($item->Total_Qty); ?></td>


                                        <td><?php echo e(trans('admin.Total_Price')); ?></td>
                                        <td><?php echo e(number_format((float)$item->Total_Price , 2, '.', '')); ?></td>


                                        <td><?php echo e(trans('admin.Total_Discount')); ?></td>
                                        <td><?php echo e($item->Total_Discount); ?></td>

                                        <td><?php echo e(trans('admin.Total_Bf_Taxes')); ?></td>
                                        <td><?php echo e($item->Total_BF_Taxes); ?></td>
                                    </tr>

                                    <tr>
                                        <td><?php echo e(trans('admin.Total_Taxes')); ?></td>
                                        <td><?php echo e($item->Total_Taxes); ?></td>



                                        <?php if($show->TaxOnTotal == 1): ?>

                                            <?php
                                                $TotalReturn=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Value');
                                                $tooot=($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount;
                                            ?>

                                            <td><?php echo e(trans('admin.Total_Net')); ?></td>
                                            <td><?php echo e(($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount); ?></td>

                                        <?php else: ?>


                                            <?php
                                                $TotalReturn=ReturnSales::where('Sales',$item->id)->get()->sum('Total_Return_Value');
                                                $tooot=$item->Total_Price + $item->Total_Taxes  - $item->Total_Discount;
                                            ?>

                                            <td><?php echo e(trans('admin.Total_Net')); ?></td>
                                            <td><?php echo e($item->Total_Price + $item->Total_Taxes  - $item->Total_Discount); ?></td>
                                        <?php endif; ?>



                                        <td><?php echo e(trans('admin.Paid')); ?></td>
                                        <td><?php echo e($item->Pay); ?></td>






                                    </tr>


                                    <?php if($show->TaxOnTotal == 1): ?>
                                        <tr>
                                            <td><?php echo e(trans('admin.TaxOnTotal')); ?></td>
                                            <td><?php echo e($item->TaxOnTotal); ?></td>

                                            <td><?php echo e(trans('admin.TaxOnTotalType')); ?></td>
                                            <td><?php if(!empty($item->TaxOnTotalType)): ?><?php echo e($item->TaxOnTotalType()->first()->Name); ?><?php endif; ?></td>

                                            <td><?php echo e(trans('admin.ProfitTax')); ?></td>
                                            <td><?php echo e($item->ProfitTax); ?></td>

                                        </tr>
                                    <?php endif; ?>

                                    <tr>



                                        <td><?php echo e(trans('admin.Total_Return')); ?></td>

                                        <td><?php echo e($TotalReturn); ?></td>

                                        <td><?php echo e(trans('admin.TotalNetReturn')); ?></td>

                                        <td><?php echo e($tooot - $TotalReturn); ?></td>
                                    </tr>



                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تعديل فاتوره مبيعات')): ?>
                                <a href="<?php echo e(url('ESBill/'.$item->id)); ?>" class="btn btn-default"><i class="fal fa-edit"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

        </div>



        <!-- Modal Installment -->
        <div class="modal fade" id="Installment<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.Presenter')); ?></label>
                                    <span><?php echo e($item->presenter); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.annual_interest')); ?></label>
                                    <span><?php echo e($item->annual_interest); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.monthly_installment')); ?></label>
                                    <span><?php echo e($item->monthly_installment); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.Years_Number')); ?></label>
                                    <span><?php echo e($item->Years_Number); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.total')); ?></label>
                                    <span><?php echo e($item->total); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.installment_Num')); ?></label>
                                    <span><?php echo e($item->installment_Num); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.Date_First_installment')); ?></label>
                                    <span><?php echo e($item->Date_First_installment); ?></span>
                                </div>

                            </div>



                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.No')); ?></button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Check -->
        <div class="modal fade" id="Check<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-4">
                                    <label><?php echo e(trans('admin.Check_Type')); ?></label>
                                    <?php if(!empty($item->Check_Type()->first()->Arabic_Name)): ?>
                                        <span>

                                <?php echo e(app()->getLocale() == 'ar' ?$item->Check_Type()->first()->Arabic_Name :$item->Check_Type()->first()->English_Name); ?>

                            </span>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-4">
                                    <label><?php echo e(trans('admin.Due_Date')); ?></label>
                                    <span><?php echo e($item->Due_Date); ?></span>
                                </div>

                                <div class="col-md-4">
                                    <label><?php echo e(trans('admin.Check_Number')); ?></label>
                                    <span><?php echo e($item->Check_Number); ?></span>
                                </div>


                            </div>



                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.No')); ?></button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal InstallmentCompanies -->
        <div class="modal fade" id="InstallmentCompanies<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">

                            <div class="row">
                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.InstallCompany')); ?></label>
                                    <span><?php if(!empty($item->InstallCompany()->first()->Arabic_Name)): ?>

                                            <?php echo e(app()->getLocale() == 'ar' ?$item->InstallCompany()->first()->Arabic_Name :$item->InstallCompany()->first()->English_Name); ?>

                                        <?php endif; ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.ContractNumber')); ?></label>
                                    <span><?php echo e($item->ContractNumber); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.PayFees')); ?></label>
                                    <span><?php echo e($item->PayFees); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.ServiceFee')); ?></label>
                                    <span><?php echo e($item->ServiceFee); ?></span>
                                </div>

                                <div class="col-md-3">
                                    <label><?php echo e(trans('admin.CompanyPrecent')); ?></label>
                                    <span><?php echo e($item->CompanyPrecent); ?></span>
                                </div>



                            </div>



                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.No')); ?></button>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Delete -->
        <div class="modal fade" id="Delete<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">

            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            <?php echo e(trans('admin.RUSWDT')); ?> <strong><?php echo e($item->Code); ?></strong>
                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.No')); ?></button>
                        <a href="<?php echo e(url('DeleteSalesBill/'.$item->id)); ?>" class="btn btn-primary"> <?php echo e(trans('admin.Yes')); ?></a>
                    </div>
                </div>
            </div>
        </div>


        <!--         Later Collection modal -->
        <div class="modal fade" id="ReciptTwo<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            <?php echo e(trans('admin.Later_Collection')); ?>

                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>

                    <form action="<?php echo e(url('CollectionLaterBill')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="ID" value="<?php echo e($item->id); ?>">
                        <div class="modal-body">
                            <div class="row">
                                <select class="select2 form-control" id="D<?php echo e($item->id); ?>" onchange="SHOWVOUCHER(<?php echo e($item->id); ?>)" name="DO" required>
                                    <option value=""><?php echo e(trans('admin.DUWTMVoucher')); ?></option>
                                    <option value="1"><?php echo e(trans('admin.Yes')); ?></option>
                                    <option value="2"><?php echo e(trans('admin.No')); ?></option>
                                </select>
                            </div>

                            <div class="row" style="display: none" id="SS<?php echo e($item->id); ?>">


                                <div class="col-md-6">
                                    <label><?php echo e(trans('admin.Creditor')); ?></label>
                                    <?php if(!empty($item->Pay)): ?>

                                        <?php if(is_numeric($item->Pay)): ?>
                                            <?php $pay=$item->Pay; ?>
                                        <?php else: ?>
                                            <?php $pay=0; ?>

                                        <?php endif; ?>

                                        <input type="number" step="any" class="form-control" name="Creditor" value="<?php echo e((($item->Total_Price + $item->Total_Taxes) - $item->Total_Discount) - $pay); ?>">




                                    <?php else: ?>
                                        <input type="number" step="any" class="form-control" name="Creditor" value="<?php echo e(($item->Total_Price + $item->Total_Taxes) - $item->Total_Discount); ?>">
                                    <?php endif; ?>

                                </div>

                                <div class="col-md-6">
                                    <label><?php echo e(trans('admin.Account')); ?></label>
                                    <select class="select2 form-control w-100" disabled>
                                        <option value=""> <?php echo e(trans('admin.Account')); ?></option>
                                        <?php $__currentLoopData = $Clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cli): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cli->id); ?>" <?php if($cli->id == $item->Client): ?> selected <?php endif; ?>>

                                                <?php echo e(app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <input type="hidden" name="Account" value="<?php echo e($item->Client); ?>">
                                </div>

                                <div class="form-group col-lg-4">
                                    <label class="form-label" for=""><?php echo e(trans('admin.Currency')); ?></label>
                                    <select class="select2 form-control w-100" name="Coin">
                                        <option value=""><?php echo e(trans('admin.Currency')); ?></option>
                                        <?php $__currentLoopData = $Coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($coin->id); ?>" <?php if($Deff->Coin == $coin->id): ?> selected <?php endif; ?>>
                                                <?php echo e(app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for=""><?php echo e(trans('admin.Collector')); ?></label>
                                    <select class="select2 form-control w-100" name="Collector">
                                        <option value=""><?php echo e(trans('admin.Collector')); ?></option>
                                        <?php $__currentLoopData = $Employess; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($emp->id); ?>">

                                                <?php echo e(app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Draw')); ?></label>
                                    <input type="number" step="any" name="Draw" value="1" class="form-control" />
                                </div>


                                <div class="form-group col-lg-4">

                                    <label class="form-label" for=""><?php echo e(trans('admin.Safe')); ?> </label>
                                    <select class="select2 form-control w-100" name="Safe">
                                        <option value=""> <?php echo e(trans('admin.Safe')); ?></option>
                                        <?php $__currentLoopData = $Safes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $safe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($safe->id); ?>" <?php if($Deff->Safe == $safe->id): ?> selected <?php endif; ?>>

                                                <?php echo e(app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>



                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>
                            <button type="submit" class="btn btn-secondary"> <?php echo e(trans('admin.Save')); ?></button>
                        </div>
                    </form>

                </div>
            </div>
        </div>


        <!-- Modal show data -->
        <div class="modal fade" id="show-data<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            <?php echo e(trans('admin.Data')); ?>

                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto;">
                            <table id="" class="table table-bordered table-hover table-striped ">
                                <thead class="bg-highlight">
                                <tr>

                                    <th><?php echo e(trans('admin.Store_Code')); ?></th>
                                    <th> <?php echo e(trans('admin.Draw')); ?> </th>
                                    <th><?php echo e(trans('admin.Status')); ?> </th>
                                    <th> <?php echo e(trans('admin.Refernce_Number')); ?> </th>
                                    <th> <?php echo e(trans('admin.Notes')); ?> </th>
                                    <th> <?php echo e(trans('admin.Later_Due')); ?> </th>
                                    <th> <?php echo e(trans('admin.Coin')); ?> </th>
                                    <th> <?php echo e(trans('admin.Cost_Center')); ?> </th>
                                    <th> <?php echo e(trans('admin.Shipping_Compaines')); ?> </th>
                                    <th> <?php echo e(trans('admin.User')); ?> </th>

                                    <th> <?php echo e(trans('admin.ResturantOrderType')); ?> </th>
                                    <th> <?php echo e(trans('admin.Table')); ?> </th>
                                    <th> <?php echo e(trans('admin.File')); ?> </th>




                                </tr>
                                </thead>
                                <tbody>

                                <tr>

                                    <td><?php echo e($item->Store_Code); ?></td>
                                    <td><?php echo e($item->Draw); ?></td>

                                    <td>

                                        <?php if($item->Status == 1): ?>
                                            <?php echo e(trans('admin.Recived')); ?>

                                        <?php elseif($item->Status == 0): ?>
                                            <?php echo e(trans('admin.Pending')); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->Refernce_Number); ?></td>
                                    <td><?php echo e($item->Note); ?></td>
                                    <td>

                                        <?php echo e($item->Later_Due); ?>

                                    </td>
                                    <td>

                                        <?php if(!empty($item->Coin()->first()->Arabic_Name)): ?>

                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name); ?>


                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($item->Cost_Center()->first()->Arabic_Name )): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name); ?>

                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if(!empty($item->Ship()->first()->Name)): ?>


                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Ship()->first()->Name :$item->Ship()->first()->NameEn); ?>

                                        <?php endif; ?>
                                    </td>

                                    <td>

                                        <?php if(!empty($item->User()->first()->name)): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn); ?>

                                        <?php endif; ?>
                                    </td>


                                    <td>


                                        <?php echo e(trans('admin.'.$item->ResturantOrderType)); ?>


                                    </td>
                                    <td>
                                        <?php if(!empty($item->Table()->first()->Arabic_Name)): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Table()->first()->Arabic_Name :$item->Table()->first()->English_Name); ?>

                                        <?php endif; ?>
                                    </td>



                                    <td>
                                        <?php if(!empty($item->File)): ?>
                                            <a href="<?php echo e(URL::to($item->File)); ?>" class="btn btn-primary" dowmload><i class="fal fa-download"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>


                                </tbody>


                            </table>

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>

                    </div>
                </div>
            </div>
        </div>


        <!-- Modal ProfitPrecent -->
        <div class="modal fade" id="ProfitPrecent<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            <?php echo e(trans('admin.ProfitPrecent')); ?>

                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="overflow:auto;">



                            <table id="" class="table table-bordered table-hover table-striped ">
                                <thead class="bg-highlight">
                                <tr>

                                    <th><?php echo e(trans('admin.Total_Cost')); ?></th>
                                    <th><?php echo e(trans('admin.Total_Price')); ?></th>
                                    <th> <?php echo e(trans('admin.Profit')); ?> </th>
                                    <th><?php echo e(trans('admin.ProfitPrecent')); ?> </th>


                                </tr>
                                </thead>
                                <tbody>

                                <tr>

                                    <td>
                                        <?php if(is_numeric($item->Total_Cost)): ?>
                                            <?php echo e($item->Total_Cost); ?>

                                        <?php else: ?>
                                            0
                                        <?php endif; ?>
                                    </td>



                                    <?php if($show->TaxOnTotal == 1): ?>


                                        <td><?php echo e(($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount); ?></td>

                                    <?php else: ?>


                                        <td><?php echo e($item->Total_Price + $item->Total_Taxes - $item->Total_Discount); ?></td>
                                    <?php endif; ?>

                                    <td>
                                        <?php if($show->TaxOnTotal == 1): ?>

                                            <?php $rab7=($item->Total_Price + $item->Total_Taxes + $item->ProfitTax) - $item->Total_Discount; ?>


                                            <?php if(is_numeric($item->Total_Cost)): ?>

                                                <?php echo e($rab7 - $item->Total_Cost); ?>

                                            <?php else: ?>
                                                <?php echo e($rab7); ?>


                                            <?php endif; ?>

                                        <?php else: ?>



                                            <?php $rab7=$item->Total_Price + $item->Total_Taxes - $item->Total_Discount; ?>

                                            <?php if(is_numeric($item->Total_Cost)): ?>

                                                <?php echo e($rab7 - $item->Total_Cost); ?>

                                            <?php else: ?>
                                                <?php echo e($rab7); ?>


                                            <?php endif; ?>


                                        <?php endif; ?>

                                    </td>


                                    <?php if(is_numeric($item->Total_Cost)): ?>
                                        <td>

                                            <?php

                                                if($item->Total_Cost != 0){

                                                $Nsbtrab7=(($rab7 - $item->Total_Cost) * 100) / $item->Total_Cost ;
                                                }else{

                                                $Nsbtrab7=(($rab7) * 100) / 1 ;

                                                }

                                            ?>

                                            <?php echo e(round($Nsbtrab7)); ?> %
                                        </td>
                                    <?php else: ?>

                                        <td>

                                            <?php


                                                $Nsbtrab7=(($rab7)) ;



                                            ?>

                                            <?php echo e(round($Nsbtrab7)); ?> %
                                        </td>
                                    <?php endif; ?>

                                </tr>


                                </tbody>


                            </table>


                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>

                    </div>
                </div>
            </div>
        </div>



    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">

    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function() {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function() {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable({
                // responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                lengthChange: true,

                dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                    {
                        extend: 'colvis',
                        text: 'Column Visibility',
                        titleAttr: 'Col visibility',
                        className: 'btn-outline-default'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        titleAttr: 'Generate PDF',
                        className: 'btn-outline-danger btn-sm mr-1'
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        titleAttr: 'Generate Excel',
                        className: 'btn-outline-success btn-sm mr-1'
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        titleAttr: 'Generate CSV',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'copyHtml5',
                        text: 'Copy',
                        titleAttr: 'Copy to clipboard',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        titleAttr: 'Print Table',
                        className: 'btn-outline-primary btn-sm'
                    }
                ],
            });
            $('.js-thead-colors a').on('click', function() {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function() {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

    <!-- Search Selecet -->
    <script>
        $(document).ready(function() {
            $(function() {
                $(".select2").select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State",
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0,
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items",
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true,
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm) {
                        return elm;
                    },
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
                }

                $("#Emp").select2({
                    placeholder: "select...",
                    ajax: {
                        type: "GET",
                        dataType: "json",
                        url: "AllEmps",
                        processResults: function(data) {
                            return {
                                results: $.map(data, function(obj, index) {
                                    return {
                                        id: index,
                                        text: obj
                                    };
                                }),
                            };

                            console.log(data);
                        },
                        data: function(params) {


                            var query = {
                                search: params.term,
                            };


                            $.ajax({
                                url: 'AllEmpsJ/' + params.term,
                                type: "GET",
                                dataType: "json",
                                beforeSend: function() {
                                    $('#loader').css("visibility", "visible");
                                },

                                success: function(data) {
                                    $('#Emp').empty();
                                    $.each(data, function(key, value) {

                                        $('#Emp').append('<option value="' + key + '">' + value + '</option>');

                                    });
                                },
                                complete: function() {
                                    $('#loader').css("visibility", "hidden");
                                }
                            });



                        }
                    },
                });

                $("#Emp").on("select2:select", function(e) {
                    console.log("select done", e.params.data);
                });






            });
        });

    </script>


    <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function() {
            interval = setInterval(function() {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function() {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete
        var removeFromLocal = function() {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function() {
            //init default
            $('.js-summernote').summernote({
                height: 200,
                tabsize: 2,
                placeholder: "Type here...",
                dialogsFade: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['fontname', ['fontname']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                        ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                callbacks: {
                    //restore from localStorage
                    onInit: function(e) {
                        $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                    },
                    onChange: function(contents, $editable) {
                        clearInterval(interval);
                        timer();
                    }
                }
            });

            //load emojis
            $.ajax({
                url: 'https://api.github.com/emojis',
                async: false
            }).then(function(data) {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote({
                height: 100,
                toolbar: false,
                placeholder: 'type starting with : and any alphabet',
                hint: {
                    match: /:([\-+\w]+)$/,
                    search: function(keyword, callback) {
                        callback($.grep(emojis, function(item) {
                            return item.indexOf(keyword) === 0;
                        }));
                    },
                    template: function(item) {
                        var content = emojiUrls[item];
                        return '<img src="' + content + '" width="20" /> :' + item + ':';
                    },
                    content: function(item) {
                        var url = emojiUrls[item];
                        if (url) {
                            return $('<img />').attr('src', url).css('width', 20)[0];
                        }
                        return '';
                    }
                }
            });

            //init mentions example
            $(".js-hint2mention").summernote({
                height: 100,
                toolbar: false,
                placeholder: "type starting with @",
                hint: {
                    mentions: ['jayden', 'sam', 'alvin', 'david'],
                    match: /\B@(\w*)$/,
                    search: function(keyword, callback) {
                        callback($.grep(this.mentions, function(item) {
                            return item.indexOf(keyword) == 0;
                        }));
                    },
                    content: function(item) {
                        return '@' + item;
                    }
                }
            });

        });

    </script>
    <script type="text/javascript">
        $(".show-table").click(function() {
            $(".hide-table").show();
        });

    </script>

    <style>
        @media  print {
            body * {
                visibility: hidden;
            }

            .modal-content * {
                visibility: visible;
                overflow: visible;
            }

            .main-page * {
                display: none;
            }

            .modal {
                position: absolute;
                left: 0;
                top: -220px;
                margin: 0;
                padding: 0;
                min-height: 550px;
                visibility: visible;
                overflow: visible !important;
                /* Remove scrollbar for printing. */
            }

            .modal-dialog {
                visibility: visible !important;
                overflow: visible !important;
                /* Remove scrollbar for printing. */
            }

            .page-content {
                display: none;
            }

            @page  {

                size: a4;

            }

        }

    </style>


    <!-- Account Balance -->
    <script>
        function priiiint() {

            var countryId = $('#Credit').val();
            if (countryId) {
                $.ajax({
                    url: 'AccountBalanceFilter/' + countryId,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {
                        $.each(data, function(key, value) {

                            $('#AccountCredit').text(parseFloat(key).toFixed(2));
                            $('#AccountCredit').text(parseFloat(value).toFixed(2));



                        });
                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });
            } else {

                $('select[name="state"]').empty();
            }

        }

    </script>

    <script>
        function SHOWVOUCHER(r) {

            var d = $('#D' + r).val();

            if (parseFloat(d) == 1) {
                document.getElementById('SS' + r).style.display = 'block';
            } else {
                document.getElementById('SS' + r).style.display = 'none';
            }
        }

    </script>

<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orientlimraerp/public_html/resources/views/admin/Sales/SalesSechduleTax.blade.php ENDPATH**/ ?>