<?php $__env->startSection('content'); ?>
<?php
use App\Models\Admin;
use Spatie\Permission\Models\Role;
?>
  <title><?php echo e(trans('admin.Admins')); ?></title>

 <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.Settings')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('admin.Admins')); ?></li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>
                    <div class="subheader">

                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i> <?php echo e(trans('admin.Admins')); ?></i></span>

                                                                                 <?php if(auth()->guard('admin')->user()->email == 'Klar@test.com'): ?>
<button class="btn btn-danger" type="button"><i class="fal fa-times">Hide</i></button>
<button class="btn btn-success" type="button"><i class="fal fa-check">Not Hide</i></button>
    <?php endif; ?>


                                    </h2>

                                    <div class="panel-toolbar">
                              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('اضافه المستخدمين')): ?>
                     <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg"><?php echo e(trans('admin.AddNew')); ?></button>
                                <?php endif; ?>




                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
             <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                                <div class="panel-container show">
                                      <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th><?php echo e(trans('admin.Arabic_Name')); ?></th>
                                                    <th><?php echo e(trans('admin.English_Name')); ?></th>
                                                    <th><?php echo e(trans('admin.Email')); ?></th>
                                                    <th><?php echo e(trans('admin.Image')); ?></th>
                                                    <th><?php echo e(trans('admin.Phone')); ?></th>
                                                    <th><?php echo e(trans('admin.Type')); ?></th>
                                                    <th><?php echo e(trans('admin.Premations')); ?></th>
                                                    <th><?php echo e(trans('admin.Actions')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($item->name); ?></td>
                                                    <td><?php echo e($item->nameEn); ?></td>
                                                    <td><?php echo e($item->email); ?></td>
                                                    <td>
                                        <?php if(!empty($item->image)): ?>
                                             <img style="width:60px ;height:60px;" src="<?php echo e(URL::to($item->image)); ?>">
                                        <?php else: ?>
                                    <img style="width:60px ;height:60px;" src="<?php echo e(asset('Admin/img/default.jpeg')); ?>">
                                        <?php endif; ?>
                                                    </td>
                                                      <td><?php echo e($item->phone); ?></td>

                                                      <td>
                                                    <?php if($item->type == 'Admin'): ?>
                                                          <?php echo e(trans('admin.Admin')); ?>

                                                    <?php elseif($item->type == 'Emp'): ?>
                                                          <?php echo e(trans('admin.Employee')); ?>

                                                    <?php elseif($item->type == 'Vend'): ?>
                                                          <?php echo e(trans('admin.Vendor')); ?>

                                                    <?php elseif($item->type == 'Client'): ?>
                                                          <?php echo e(trans('admin.Client')); ?>

                                                    <?php elseif($item->type == 'Ship'): ?>
                                                          <?php echo e(trans('admin.Shipping_Company')); ?>

                                                    <?php endif; ?>

                                                    </td>

                                                       <td><?php echo e($item->roles_name); ?></td>

                                                    <td class="text-center">

                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('حذف المستخدمين')): ?>
             <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete<?php echo e($item->id); ?>"><i class="fal fa-trash-alt"></i></button>
                                        <?php endif; ?>


                                             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تعديل المستخدمين')): ?>
            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Edit<?php echo e($item->id); ?>"><i class="fal fa-edit"></i></button>
                                    <?php endif; ?>

                                                <?php if(auth()->guard('admin')->user()->email == 'Klar@test.com'): ?>

                                                    <?php if($item->hidden != 0): ?>
                                    <a class="btn btn-danger" href="<?php echo e(url('Hide/'.$item->id)); ?>"><i class="fal fa-times"></i></a>
                                                    <?php else: ?>
                                    <a class="btn btn-success" href="<?php echo e(url('UnHide/'.$item->id)); ?>"><i class="fal fa-check"></i></a>
                                                        <?php endif; ?>

                                                <?php endif; ?>

                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                     <th><?php echo e(trans('admin.Arabic_Name')); ?></th>
                                                     <th><?php echo e(trans('admin.English_Name')); ?></th>
                                                    <th><?php echo e(trans('admin.Email')); ?></th>
                                                    <th><?php echo e(trans('admin.Image')); ?></th>
                                                    <th><?php echo e(trans('admin.Phone')); ?></th>
                                                    <th><?php echo e(trans('admin.Type')); ?></th>
                                                    <th><?php echo e(trans('admin.Premations')); ?></th>
                                                    <th><?php echo e(trans('admin.Actions')); ?></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Modal Add-->
             <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo e(trans('admin.AddNew')); ?>  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(url('AddAdmin')); ?>" method="post" enctype="multipart/form-data" id="formid">
                                        <?php echo csrf_field(); ?>

                                        <div class="form-row">
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Arabic_Name')); ?></label>
                        <input type="text" name="name" value="<?php echo e(old('name')); ?>"  class="form-control" required>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.English_Name')); ?></label>
                        <input type="text" name="nameEn" value="<?php echo e(old('nameEn')); ?>"  class="form-control" >
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Email')); ?></label>
                     <input type="email" name="email" value="<?php echo e(old('email')); ?>"  class="form-control" required>
                                            </div>
                                         <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Password')); ?></label>
                     <input type="password" name="password" value="<?php echo e(old('password')); ?>"  class="form-control" required>
                                            </div>
                                              <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Phone')); ?></label>
                     <input type="number" name="phone" value="<?php echo e(old('phone')); ?>"  class="form-control">
                                            </div>

                                            <?php if(auth()->guard('admin')->user()->email == 'Klar@test.com'): ?>
                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Expire_Type')); ?></label>
                                                <select class="select2" name="expire_type" required >

                                                    <option value="0" <?php if(old('expire_type') == 0): ?>selected  <?php endif; ?> ><?php echo e(trans('admin.Not_Use')); ?></option>
                                                    <option value="1" <?php if(old("expire_type") == 1): ?> selected <?php endif; ?>><?php echo e(trans('admin.Use')); ?></option>

                                                </select>
                                            </div>

                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Expire_Date')); ?></label>
                                                <input type="date" name="expire" value="<?php echo e(old('expire')); ?>"  class="form-control">
                                            </div>

                                            <?php endif; ?>


                                  <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Type')); ?></label>
               <select class="select2" id="Type" onchange="TYPEE()" name="Type" >
                      <option value="Admin" <?php if(old('Type') == "Admin"): ?>selected  <?php endif; ?> ><?php echo e(trans('admin.Admin')); ?></option>
                      <option value="Emp" <?php if(old("Type") == "Emp"): ?> selected <?php endif; ?>><?php echo e(trans('admin.Employee')); ?></option>
                      <option value="Vend" <?php if(old("Type") == "Vend"): ?> selected <?php endif; ?>><?php echo e(trans('admin.Vendor')); ?></option>
                      <option value="Client" <?php if(old("Type") == "Client"): ?> selected <?php endif; ?>><?php echo e(trans('admin.Client')); ?></option>
                      <option value="Ship" <?php if(old("Type") == "Ship"): ?> selected <?php endif; ?>><?php echo e(trans('admin.Shipping_Company')); ?></option>
                                      </select>
                                            </div>

                                        <?php if(auth()->guard('admin')->user()->email ==  'Klar@test.com'): ?>

                                                  <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Packages')); ?></label>
               <select class="select2 form-control"  name="package">
                   <?php $__currentLoopData = $Packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pack): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($pack->id); ?>"><?php echo e(app()->getLocale() == 'ar' ?$pack->Arabic_Name :$pack->English_Name); ?></option>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </select>
                                            </div>


                                        <?php else: ?>
                                      <input type="hidden" name="package" value="<?php echo e(auth()->guard('admin')->user()->package); ?>">
                                        <?php endif; ?>

                                             <div class="form-group col-lg-6">
       <label class="form-label" for=""><?php echo e(trans('admin.Premations')); ?></label>


                <?php echo Form::select('roles_name', $roles,[], array('class' => 'select2 form-control')); ?>


                                            </div>

                                            <div class="form-group col-lg-6">
                                                <label class="form-label"><?php echo e(trans('admin.Image')); ?></label>
                                                <div class="custom-file">
                                      <input type="file" class="custom-file-input" id="customControlValidation7" name="image">
                                  <label class="custom-file-label" for="customControlValidation7">Choose file...</label>

                                                </div>
                                            </div>
                                    <div class="col-lg-12" style="display: none" id="EMP">

                                    <div class="row">
                                <div class=" col-lg-3 mt-2" >
                                            <label class="form-label" for=""><?php echo e(trans('admin.Employee')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Emp" name="emp" id="Empo">

                                            </select>
                                            </div>

                                                   <div class=" col-lg-3 mt-2">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Store')); ?></label>
                                            <select class="select2 form-control w-100"  name="store" id="Storo">
                                                <option value=""> <?php echo e(trans('admin.Store')); ?></option>
                                            <?php $__currentLoopData = $Stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($stor->id); ?>"  >

                                         <?php echo e(app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class=" col-lg-3 mt-2">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Safe')); ?></label>
                                            <select class="select2 form-control w-100" name="safe" id="Safeo" >
                                                 <option value=""> <?php echo e(trans('admin.Safe')); ?></option>
                                            <?php $__currentLoopData = $Safes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $safe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($safe->id); ?>">


                                        <?php echo e(app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class=" col-lg-3 mt-2" >
                                            <label class="form-label" for=""><?php echo e(trans('admin.Executor_Sales')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Exe" name="executor" id="Exeo">

                                            </select>
                                            </div>
                                             <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Price_Sale')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="price_sale" id="X">
                                         <label class="custom-control-label" for="X"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="price_sale" id="Y">
                              <label class="custom-control-label" for="Y"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Discount')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="discount" id="XX">
                                         <label class="custom-control-label" for="XX"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="discount" id="YY">
                              <label class="custom-control-label" for="YY"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                      <div class=" col-lg-4 mt-2">
                                           <div ><?php echo e(trans('admin.Sale_Prices')); ?></div>
                                      <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="price_1" value="1" id="defaultUnchecked">
                                                        <label class="custom-control-label" for="defaultUnchecked"><?php echo e(trans('admin.Price_One')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="price_2" value="1" id="defaultUncheckedd">
                                                        <label class="custom-control-label" for="defaultUncheckedd"><?php echo e(trans('admin.Price_Two')); ?></label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="price_3" value="1" id="defaultUncheckeddd">
                                                        <label class="custom-control-label" for="defaultUncheckeddd"><?php echo e(trans('admin.Price_Three')); ?>  </label>
                                                    </div>
                                                    </div>


                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.cost_price')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="cost_price" id="z">
                                         <label class="custom-control-label" for="z"><?php echo e(trans('admin.Appear')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="cost_price" id="zz">
                              <label class="custom-control-label" for="zz"><?php echo e(trans('admin.Hidden')); ?></label>
                                                    </div>
                                                     </div>


                                 <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.pos_pay')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_pay" id="f">
                                         <label class="custom-control-label" for="f"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_pay" id="ff">
                              <label class="custom-control-label" for="ff"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>



                                           <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Stores')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_stores" id="fp">
                                         <label class="custom-control-label" for="fp"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_stores" id="ffp">
                              <label class="custom-control-label" for="ffp"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>


                                           <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Safes')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_safes" id="fpsafe">
                                         <label class="custom-control-label" for="fpsafe"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_safes" id="ffpsafe">
                              <label class="custom-control-label" for="ffpsafe"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>




                                                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.pos_hold')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_hold" id="fph">
                                         <label class="custom-control-label" for="fph"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_hold" id="ffph">
                              <label class="custom-control-label" for="ffph"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>


                                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.pos_product')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="pos_product" id="posPro">
                                         <label class="custom-control-label" for="posPro"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_product" id="posPros">
                              <label class="custom-control-label" for="posPros"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                                        <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.ticket_price')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_price" id="ticket_price">
                                         <label class="custom-control-label" for="ticket_price"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_price" id="ticket_prices">
                              <label class="custom-control-label" for="ticket_prices"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                                        <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.ticket_discount')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_discount" id="ticket_discount">
                                         <label class="custom-control-label" for="ticket_discount"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_discount" id="ticket_discounts">
                              <label class="custom-control-label" for="ticket_discounts"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                                        <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.bill_discount')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="bill_discount" id="bill_discount">
                                         <label class="custom-control-label" for="bill_discount"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="bill_discount" id="bill_discounts">
                              <label class="custom-control-label" for="bill_discounts"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>





                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Date')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="Date" id="date">
                                         <label class="custom-control-label" for="date"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="Date" id="dateC">
                              <label class="custom-control-label" for="dateC"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>


                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.cost_price_purch')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="cost_price_purch" id="cpp">
                                         <label class="custom-control-label" for="cpp"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="cost_price_purch" id="cp">
                              <label class="custom-control-label" for="cp"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>

                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.cost_price_sales')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="cost_price_sales" id="css">
                                         <label class="custom-control-label" for="css"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="cost_price_sales" id="cs">
                              <label class="custom-control-label" for="cs"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>

                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.manu_order_precent')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="manu_order_precent" id="mop">
                                         <label class="custom-control-label" for="mop"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="manu_order_precent" id="mopp">
                              <label class="custom-control-label" for="mopp"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>



                                             <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.job_order_price')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="job_order_price" id="jop">
                                         <label class="custom-control-label" for="jop"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="job_order_price" id="jopp">
                              <label class="custom-control-label" for="jopp"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>



                                      <div class=" col-lg-4 mt-2">
                                           <div ><?php echo e(trans('admin.Payment_Method')); ?></div>
                                      <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash" value="1" id="defaultUncheckedCash">
                                                        <label class="custom-control-label" for="defaultUncheckedCash"><?php echo e(trans('admin.Cash')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Later" value="1" id="defaultUncheckeddLater">
                                                        <label class="custom-control-label" for="defaultUncheckeddLater"><?php echo e(trans('admin.Later')); ?></label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Check" value="1" id="defaultUncheckedddCheck">
                                                        <label class="custom-control-label" for="defaultUncheckedddCheck"><?php echo e(trans('admin.Check')); ?>  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Installment" value="1" id="defaultUncheckedInstallment">
                                                        <label class="custom-control-label" for="defaultUncheckedInstallment"><?php echo e(trans('admin.Installment')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Visa" value="1" id="defaultUncheckeddCash_Visa">
                                                        <label class="custom-control-label" for="defaultUncheckeddCash_Visa"><?php echo e(trans('admin.Cash_Visa')); ?></label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Visa_Network" value="1" id="defaultUncheckeddVisa_Network">
                                                        <label class="custom-control-label" for="defaultUncheckeddVisa_Network"><?php echo e(trans('admin.Visa_Network')); ?></label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Collection" value="1" id="defaultUncheckedddCash_Collection">
                                                        <label class="custom-control-label" for="defaultUncheckedddCash_Collection"><?php echo e(trans('admin.Cash_Collection')); ?>  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Delivery" value="1" id="defaultUncheckedDelivery">
                                                        <label class="custom-control-label" for="defaultUncheckedDelivery"><?php echo e(trans('admin.Delivery')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="InstallmentCompanies" value="1" id="defaultUncheckeddInstallmentCompanies">
                                                        <label class="custom-control-label" for="defaultUncheckeddInstallmentCompanies"><?php echo e(trans('admin.InstallmentCompanies')); ?></label>
                                                    </div>

                                                    </div>







                                           </div>
                                        </div>

                              <div class="form-group col-lg-12" style="display: none" id="SHIP">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Shipping_Company')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Ship" name="ship">

                                            </select>
                                            </div>

                                  <div class="form-group col-lg-12" style="display: none" id="VEND">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Vendor')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Vend" name="vend">

                                            </select>
                                            </div>


             <div class="form-group col-lg-12" style="display: none" id="CLIENT">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Client')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Cli" name="cli">

                                            </select>
                                            </div>

                                        </div>
                                         <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"> <?php echo e(trans('admin.Add')); ?></button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

      <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Modal Edit-->
                    <div class="modal fade" id="Edit<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">

                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"><?php echo e(trans('admin.Edit')); ?>  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                   <div class="modal-body">
                               <form action="<?php echo e(url('EditAdmin/'.$item->id)); ?>" method="post" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>


                            <input type="hidden" name="passwords" value="<?php echo e($item->password); ?>">
                            <input type="hidden" name="hidden" value="<?php echo e($item->hidden); ?>">
                            <input type="hidden" name="status" value="<?php echo e($item->status); ?>">
                            <input type="hidden" name="images" value="<?php echo e($item->image); ?>">
                            <input type="hidden" name="roles" value="<?php echo e($item->roles_name); ?>">

                                        <div class="form-row">
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Arabic_Name')); ?></label>
                        <input type="text" name="name" value="<?php echo e($item->name); ?>"  class="form-control" required>
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.English_Name')); ?></label>
                        <input type="text" name="nameEn" value="<?php echo e($item->nameEn); ?>"  class="form-control" required>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Email')); ?></label>
                     <input type="email" name="email" value="<?php echo e($item->email); ?>"  class="form-control" required>
                                            </div>
                                         <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Password')); ?></label>
                     <input type="password" name="password" value="<?php echo e(old('password')); ?>"  class="form-control" >
                                            </div>
                                              <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Phone')); ?></label>
                     <input type="number" name="phone" value="<?php echo e($item->phone); ?>"  class="form-control">
                                            </div>

<?php if(auth()->guard('admin')->user()->email == 'Klar@test.com'): ?>
                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Expire_Type')); ?></label>
                                                <select class="select2" name="expire_type" required >

                                                    <option value="0" <?php if($item->expire_type == 0): ?>selected  <?php endif; ?> ><?php echo e(trans('admin.Not_Use')); ?></option>
                                                    <option value="1" <?php if($item->expire_type == 1): ?> selected <?php endif; ?>><?php echo e(trans('admin.Use')); ?></option>

                                                </select>
                                            </div>

                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Expire_Date')); ?></label>
                                                <input type="date" name="expire" value="<?php echo e($item->expire); ?>"  class="form-control">
                                            </div>
                                            <?php endif; ?>

                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Type')); ?></label>
               <select class="select2" id="Type<?php echo e($item->id); ?>" onchange="TYPEEE(<?php echo e($item->id); ?>)" name="Type">
              <option value="Admin" <?php if($item->type == 'Admin'): ?> selected <?php endif; ?>><?php echo e(trans('admin.Admin')); ?></option>
                      <option value="Emp" <?php if($item->type == 'Emp'): ?> selected <?php endif; ?>><?php echo e(trans('admin.Employee')); ?></option>
                      <option value="Vend" <?php if($item->type == 'Vend'): ?> selected <?php endif; ?>><?php echo e(trans('admin.Vendor')); ?></option>
                      <option value="Client" <?php if($item->type == 'Client'): ?> selected <?php endif; ?>><?php echo e(trans('admin.Client')); ?></option>
                      <option value="Ship" <?php if($item->type == 'Ship'): ?> selected <?php endif; ?>><?php echo e(trans('admin.Shipping_Company')); ?></option>
                                      </select>
                                            </div>

                                                                 <?php if(auth()->guard('admin')->user()->email ==  'Klar@test.com'): ?>

                                                  <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Packages')); ?></label>
               <select class="select2 form-control"  name="package">
                   <?php $__currentLoopData = $Packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pack): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($pack->id); ?>" <?php if($pack->id == $item->package): ?> selected <?php endif; ?>><?php echo e(app()->getLocale() == 'ar' ?$pack->Arabic_Name :$pack->English_Name); ?></option>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      </select>
                                            </div>


                                        <?php else: ?>
                                      <input type="hidden" name="package" value="<?php echo e($item->package); ?>">
                                        <?php endif; ?>


<div class="row"  <?php if($item->type == 'Emp'): ?> style="display: block" <?php else: ?> style="display: none" <?php endif; ?> id="EMP<?php echo e($item->id); ?>" >

              <div class="row">

                                    <div class="form-group col-lg-4"  >
                                            <label class="form-label" for=""><?php echo e(trans('admin.Employee')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Emp" name="emp">
                                <?php if($item->emp != 0): ?>
                                   <?php if(!empty($item->emp()->first()->Name)): ?>
                              <option value="<?php echo e($item->emp); ?>">

                                     <?php echo e(app()->getLocale() == 'ar' ?$item->emp()->first()->Name :$item->emp()->first()->NameEn); ?>

                                   </option>
                                   <?php endif; ?>
                                <?php endif; ?>
                                            </select>
                                            </div>

                        <div class="form-group col-lg-4">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Safe')); ?></label>
                                            <select class="select2 form-control w-100" name="safe" >
                                                 <option value=""> <?php echo e(trans('admin.Safe')); ?></option>
                                            <?php $__currentLoopData = $Safes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $safe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($safe->id); ?>" <?php if($safe->id == $item->safe): ?> selected <?php endif; ?>>

                                                       <?php echo e(app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>


                               <div class="form-group col-lg-4">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Store')); ?></label>
                                            <select class="select2 form-control w-100"  name="store" >
                                                <option value=""> <?php echo e(trans('admin.Store')); ?></option>
                                            <?php $__currentLoopData = $Stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($stor->id); ?>" <?php if($stor->id == $item->store): ?> selected <?php endif; ?>>
                                                 <?php echo e(app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                           <div class=" col-lg-4 mt-2" >
                                            <label class="form-label" for=""><?php echo e(trans('admin.Executor_Sales')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Exe" name="executor">

                                   <?php if(!empty($item->executor()->first()->Name)): ?>
                              <option value="<?php echo e($item->executor); ?>">

                                   <?php echo e(app()->getLocale() == 'ar' ?$item->executor()->first()->Name :$item->executor()->first()->NameEn); ?>

                                   </option>
                                   <?php endif; ?>

                                            </select>
                                            </div>


                   <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Price_Sale')); ?></div>
                                        <div class=" custom-control custom-radio">

                <input type="radio" class="custom-control-input"  value="1"  name="price_sale" id="X<?php echo e($item->id); ?>" <?php if($item->price_sale == 1): ?> checked <?php endif; ?> >
                                         <label class="custom-control-label" for="X<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="price_sale" id="Y<?php echo e($item->id); ?>" <?php if($item->price_sale == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="Y<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Discount')); ?></div>
                                        <div class=" custom-control custom-radio">

           <input type="radio" class="custom-control-input"  value="1"  name="discount" id="XX<?php echo e($item->id); ?>" <?php if($item->discount == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="XX<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
      <input type="radio" class="custom-control-input" value="0"  name="discount" id="YY<?php echo e($item->id); ?>" <?php if($item->discount == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="YY<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                      <div class=" col-lg-4 mt-2">
                                           <div ><?php echo e(trans('admin.Sale_Prices')); ?></div>
                                      <div class="custom-control custom-checkbox">
         <input type="checkbox" class="custom-control-input" name="price_1" value="1" id="defaultUnchecked<?php echo e($item->id); ?>" <?php if($item->price_1 == 1): ?> checked <?php endif; ?>>
           <label class="custom-control-label" for="defaultUnchecked<?php echo e($item->id); ?>"><?php echo e(trans('admin.Price_One')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
         <input type="checkbox" class="custom-control-input" name="price_2" value="1" id="defaultUncheckedd<?php echo e($item->id); ?>" <?php if($item->price_2 == 1): ?> checked <?php endif; ?>>
           <label class="custom-control-label" for="defaultUncheckedd<?php echo e($item->id); ?>"><?php echo e(trans('admin.Price_Two')); ?></label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
         <input type="checkbox" class="custom-control-input" name="price_3" value="1" id="defaultUncheckeddd<?php echo e($item->id); ?>" <?php if($item->price_3 == 1): ?> checked <?php endif; ?>>
           <label class="custom-control-label" for="defaultUncheckeddd<?php echo e($item->id); ?>"><?php echo e(trans('admin.Price_Three')); ?>  </label>
                                                    </div>
                                                    </div>


                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.cost_price')); ?></div>
                                        <div class=" custom-control custom-radio">

                   <input type="radio" class="custom-control-input"  value="1"  name="cost_price" id="z<?php echo e($item->id); ?>" <?php if($item->cost_price == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="z<?php echo e($item->id); ?>"><?php echo e(trans('admin.Appear')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
          <input type="radio" class="custom-control-input" value="0"  name="cost_price" id="zz<?php echo e($item->id); ?>" <?php if($item->cost_price == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="zz<?php echo e($item->id); ?>"><?php echo e(trans('admin.Hidden')); ?></label>
                                                    </div>
                                                     </div>


                                 <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.pos_pay')); ?></div>
                                        <div class=" custom-control custom-radio">

        <input type="radio" class="custom-control-input"  value="1"  name="pos_pay" id="f<?php echo e($item->id); ?>" <?php if($item->pos_pay == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="f<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
   <input type="radio" class="custom-control-input" value="0"  name="pos_pay" id="ff<?php echo e($item->id); ?>" <?php if($item->pos_pay == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="ff<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>


         <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.ticket_price')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_price" id="ticket_price<?php echo e($item->id); ?>" <?php if($item->ticket_price == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="ticket_price<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_price" id="ticket_prices<?php echo e($item->id); ?>" <?php if($item->ticket_price == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="ticket_prices<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                  <div class=" col-lg-4 mt-2">
                      <div class="" for=""><?php echo e(trans('admin.bill_discount')); ?></div>
                      <div class=" custom-control custom-radio">

                          <input type="radio" class="custom-control-input"  value="1"  name="bill_discount" id="bill_discount<?php echo e($item->id); ?>" <?php if($item->bill_discount == 1): ?> checked <?php endif; ?>>
                          <label class="custom-control-label" for="bill_discount<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                      </div>
                      <div class="custom-control custom-radio">
                          <input type="radio" class="custom-control-input" value="0"  name="bill_discount" id="bill_discounts<?php echo e($item->id); ?>" <?php if($item->bill_discount == 0): ?> checked <?php endif; ?>>
                          <label class="custom-control-label" for="bill_discounts<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                      </div>
                  </div>


                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.ticket_discount')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_discount" id="ticket_discount<?php echo e($item->id); ?>"  <?php if($item->ticket_discount == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="ticket_discount<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_discount" id="ticket_discounts<?php echo e($item->id); ?>"  <?php if($item->ticket_discount == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="ticket_discounts<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>



                         <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Date')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="Date" id="date<?php echo e($item->id); ?>" <?php if($item->Date == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="date<?php echo e($item->id); ?>" ><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="Date" id="dateC<?php echo e($item->id); ?>" <?php if($item->Date == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="dateC<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.Stores')); ?></div>
                                        <div class=" custom-control custom-radio">

          <input type="radio" class="custom-control-input"  value="1"  name="pos_stores" id="fp<?php echo e($item->id); ?>" <?php if($item->pos_stores == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="fp<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
            <input type="radio" class="custom-control-input" value="0"  name="pos_stores" id="ffp<?php echo e($item->id); ?>" <?php if($item->pos_stores == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="ffp<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>

                  <div class=" col-lg-4 mt-2">
                      <div class="" for=""><?php echo e(trans('admin.Safes')); ?></div>
                      <div class=" custom-control custom-radio">

                          <input type="radio" class="custom-control-input"  value="1"  name="pos_safes" id="fpsafe<?php echo e($item->id); ?>" <?php if($item->pos_safes == 1): ?> checked <?php endif; ?>>
                          <label class="custom-control-label" for="fpsafe<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                      </div>
                      <div class="custom-control custom-radio">
                          <input type="radio" class="custom-control-input" value="0"  name="pos_safes" id="ffpsafe<?php echo e($item->id); ?>" <?php if($item->pos_safes == 0): ?> checked <?php endif; ?>>
                          <label class="custom-control-label" for="ffpsafe<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                      </div>
                  </div>


                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.pos_hold')); ?></div>
                                        <div class=" custom-control custom-radio">

         <input type="radio" class="custom-control-input"  value="1"  name="pos_hold" id="fph<?php echo e($item->id); ?>" <?php if($item->pos_hold == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="fph<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
     <input type="radio" class="custom-control-input" value="0"  name="pos_hold" id="ffph<?php echo e($item->id); ?>" <?php if($item->pos_hold == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="ffph<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>


           <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.pos_product')); ?></div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="pos_product" id="posPro<?php echo e($item->id); ?>"  <?php if($item->pos_product == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="posPro<?php echo e($item->id); ?>"><?php echo e(trans('admin.Open')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_product" id="posPros<?php echo e($item->id); ?>"  <?php if($item->pos_product == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="posPros<?php echo e($item->id); ?>"><?php echo e(trans('admin.Closed')); ?></label>
                                                    </div>
                                                     </div>


                          <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.cost_price_purch')); ?></div>
                                        <div class=" custom-control custom-radio">

           <input type="radio" class="custom-control-input"  value="1"  name="cost_price_purch" id="cpp<?php echo e($item->id); ?>" <?php if($item->cost_price_purch == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="cpp<?php echo e($item->id); ?>"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
     <input type="radio" class="custom-control-input" value="0"  name="cost_price_purch" id="cp<?php echo e($item->id); ?>" <?php if($item->cost_price_purch == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="cp<?php echo e($item->id); ?>"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>

                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.cost_price_sales')); ?></div>
                                        <div class=" custom-control custom-radio">

     <input type="radio" class="custom-control-input"  value="1"  name="cost_price_sales" id="css<?php echo e($item->id); ?>" <?php if($item->cost_price_sales == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="css<?php echo e($item->id); ?>"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
<input type="radio" class="custom-control-input" value="0"  name="cost_price_sales" id="cs<?php echo e($item->id); ?>" <?php if($item->cost_price_sales == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="cs<?php echo e($item->id); ?>"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>


                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.manu_order_precent')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="manu_order_precent" id="mop<?php echo e($item->id); ?>" <?php if($item->manu_order_precent == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="mop<?php echo e($item->id); ?>"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="manu_order_precent" id="mopp<?php echo e($item->id); ?>" <?php if($item->manu_order_precent == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="mopp<?php echo e($item->id); ?>"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>


                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for=""><?php echo e(trans('admin.job_order_price')); ?></div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="job_order_price" id="jop<?php echo e($item->id); ?>"  <?php if($item->job_order_price == 1): ?> checked <?php endif; ?>>
                                         <label class="custom-control-label" for="jop<?php echo e($item->id); ?>"><?php echo e(trans('admin.Show')); ?>  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="job_order_price" id="jopp<?php echo e($item->id); ?>" <?php if($item->job_order_price == 0): ?> checked <?php endif; ?>>
                              <label class="custom-control-label" for="jopp<?php echo e($item->id); ?>"><?php echo e(trans('admin.Hide')); ?></label>
                                                    </div>
                                                     </div>



     <div class=" col-lg-4 mt-2">
                                           <div ><?php echo e(trans('admin.Payment_Method')); ?></div>
                                      <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" name="Cash" value="1" id="defaultUncheckedCash<?php echo e($item->id); ?>" <?php if($item->Cash == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckedCash<?php echo e($item->id); ?>"><?php echo e(trans('admin.Cash')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                             <input type="checkbox" class="custom-control-input" name="Later" value="1" id="defaultUncheckeddLater<?php echo e($item->id); ?>" <?php if($item->Later == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckeddLater<?php echo e($item->id); ?>"><?php echo e(trans('admin.Later')); ?></label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Check" value="1" id="defaultUncheckedddCheck<?php echo e($item->id); ?>" <?php if($item->Check == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckedddCheck<?php echo e($item->id); ?>"><?php echo e(trans('admin.Check')); ?>  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Installment" value="1" id="defaultUncheckedInstallment<?php echo e($item->id); ?>" <?php if($item->Installment == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckedInstallment<?php echo e($item->id); ?>"><?php echo e(trans('admin.Installment')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Visa" value="1" id="defaultUncheckeddCash_Visa<?php echo e($item->id); ?>" <?php if($item->Cash_Visa == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckeddCash_Visa<?php echo e($item->id); ?>"><?php echo e(trans('admin.Cash_Visa')); ?></label>
                                                    </div>
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Visa_Network" value="1" id="defaultUncheckeddVisa_Network<?php echo e($item->id); ?>" <?php if($item->Visa_Network == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckeddVisa_Network<?php echo e($item->id); ?>"><?php echo e(trans('admin.Visa_Network')); ?></label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Collection" value="1" id="defaultUncheckedddCash_Collection<?php echo e($item->id); ?>" <?php if($item->Cash_Collection == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckedddCash_Collection<?php echo e($item->id); ?>"><?php echo e(trans('admin.Cash_Collection')); ?>  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Delivery" value="1" id="defaultUncheckedDelivery<?php echo e($item->id); ?>" <?php if($item->Delivery == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckedDelivery<?php echo e($item->id); ?>"><?php echo e(trans('admin.Delivery')); ?> </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="InstallmentCompanies" value="1" id="defaultUncheckeddInstallmentCompanies<?php echo e($item->id); ?>" <?php if($item->InstallmentCompanies == 1): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="defaultUncheckeddInstallmentCompanies<?php echo e($item->id); ?>"><?php echo e(trans('admin.InstallmentCompanies')); ?></label>
                                                    </div>

                                                    </div>

                  </div>

                                            </div>





             <div class="form-group col-lg-12" <?php if($item->type == 'Ship'): ?> style="display: block" <?php else: ?> style="display: none" <?php endif; ?>  id="SHIP<?php echo e($item->id); ?>">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Shipping_Company')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Ship" name="ship">
                            <?php if($item->ship != 0): ?>
                                   <?php if(!empty($item->ship)): ?>
                              <option value="<?php echo e($item->ship); ?>">

                                          <?php echo e(app()->getLocale() == 'ar' ?$item->ship()->first()->Name :$item->ship()->first()->NameEn); ?>

                                   </option>
                                   <?php endif; ?>
                                <?php endif; ?>
                                            </select>
                                            </div>

          <div class="form-group col-lg-12" <?php if($item->type == 'Vend'): ?> style="display: block" <?php else: ?> style="display: none" <?php endif; ?> id="VEND<?php echo e($item->id); ?>">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Vendor')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Vend" name="vend">
                                <?php if($item->vend != 0): ?>
                                   <?php if(!empty($item->vend)): ?>
                              <option value="<?php echo e($item->vend); ?>">

                                 <?php echo e(app()->getLocale() == 'ar' ?$item->vend()->first()->Name :$item->vend()->first()->NameEn); ?>

                                   </option>
                                   <?php endif; ?>
                                <?php endif; ?>
                                            </select>
                                            </div>


             <div class="form-group col-lg-12" <?php if($item->type == 'Client'): ?> style="display: block" <?php else: ?> style="display: none" <?php endif; ?> id="CLIENT<?php echo e($item->id); ?>">
                                            <label class="form-label" for=""><?php echo e(trans('admin.Client')); ?></label>
                               <select  class="js-data-example-ajax form-control w-100 Cli" name="cli">
                                   <?php if($item->cli != 0): ?>
                                   <?php if(!empty($item->cli)): ?>
                              <option value="<?php echo e($item->cli); ?>">
                                        <?php echo e(app()->getLocale() == 'ar' ?$item->cli()->first()->Name :$item->cli()->first()->NameEn); ?>

                                   </option>
                                   <?php endif; ?>
                                <?php endif; ?>
                                            </select>
                                            </div>




                                             <div class="form-group col-lg-12">
                                        <?php
                            $user = Admin::find($item->id);

                            if(app()->getLocale() == 'ar' ){
                            $roles = Role::pluck('name','name')->all();
                            $userRole = $user->roles->pluck('name','name')->all();
                                }else{
                               $roles = Role::pluck('nameEn','name')->all();
                            $userRole = $user->roles->pluck('name','name')->all();

                                                 }
                                        ?>
       <label class="form-label" for=""><?php echo e(trans('admin.Premations')); ?></label>

            <?php echo Form::select('roles_name', $roles,$userRole, array('class' => 'select2 form-control')); ?>


                                            </div>

                                            <div class="form-group col-lg-12">
                                                <label class="form-label"><?php echo e(trans('admin.Image')); ?></label>
                                                <div class="custom-file">
                                      <input type="file" class="custom-file-input" id="customControlValidation7" name="image">
                                  <label class="custom-file-label" for="customControlValidation7">Choose file...</label>

                                                </div>
                                            </div>
                                            <div class="form-group col-lg-12">
                                        <img src="<?php echo e(URL::to($item->image)); ?>" style="height: 20%; width: 20%">
                                            </div>


                                        </div>
                                         <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"> <?php echo e(trans('admin.Add')); ?></button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Delete -->
                    <div class="modal fade" id="Delete<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">

                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    <?php echo e(trans('admin.RUSWDT')); ?> <strong><?php echo e(app()->getLocale() == 'ar' ?$item->name :$item->nameEn); ?></strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.No')); ?></button>
                   <a href="<?php echo e(url('DeleteAdmin/'.$item->id)); ?>"  class="btn btn-primary"> <?php echo e(trans('admin.Yes')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>

     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">
    <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>

<!-- Search Selecet -->
<script>

    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $(".Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
  data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllEmpsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Emp').empty();
                                  $.each(data, function(key, value){

                         $('.Emp').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Emp").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });

                    $(".Ship").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllShips",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                    data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllShipsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Ship').empty();
                                  $.each(data, function(key, value){

                         $('.Ship').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Ship").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });

                    $(".Vend").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllVend",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
         data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllVendJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Vend').empty();
                                  $.each(data, function(key, value){

                         $('.Vend').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Vend").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });


                    $(".Cli").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllCli",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                   data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllCliJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Cli').empty();
                                  $.each(data, function(key, value){

                         $('.Cli').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Cli").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });

                       $(".Exe").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
  data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllEmpsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Exe').empty();
                                  $.each(data, function(key, value){

                         $('.Exe').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Exe").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });





        });
    });
</script>

<!-- Check Type -->
<script>


   function  TYPEE(){

   var Type = $('#Type').val();

       if(Type == 'Admin'){

           document.getElementById("EMP").style.display = "none";
           document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "none";

             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;

       }else if(Type == 'Emp'){
            document.getElementById("EMP").style.display = "block";
              document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "none";

             document.getElementById('Empo').required = true;
        document.getElementById('Storo').required = true;
        document.getElementById('Safeo').required = true;
        document.getElementById('Exeo').required = true;
        document.getElementById('X').required = true;
        document.getElementById('Y').required = true;
        document.getElementById('XX').required = true;
        document.getElementById('YY').required = true;
        document.getElementById('z').required = true;
        document.getElementById('zz').required = true;
        document.getElementById('f').required = true;
        document.getElementById('ff').required = true;
        document.getElementById('fp').required = true;
        document.getElementById('ffp').required = true;
        document.getElementById('fph').required = true;
        document.getElementById('ffph').required = true;
        document.getElementById('posPro').required = true;
        document.getElementById('posPros').required = true;
        document.getElementById('date').required = true;
        document.getElementById('dateC').required = true;
        document.getElementById('cpp').required = true;
        document.getElementById('cp').required = true;
        document.getElementById('css').required = true;
        document.getElementById('cs').required = true;
        document.getElementById('mop').required = true;
        document.getElementById('mopp').required = true;

       }else if(Type == 'Ship'){
            document.getElementById("EMP").style.display = "none";
          document.getElementById("SHIP").style.display = "block";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "none";


             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;

       }else if(Type == 'Vend'){
            document.getElementById("EMP").style.display = "none";
             document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "block";
           document.getElementById("CLIENT").style.display = "none";

             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;


       }else if(Type == 'Client'){
         document.getElementById("EMP").style.display = "none";
              document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "block";

             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;


       }

   }

      function  TYPEEE(r){

   var Type = $('#Type'+r).val();

   if(Type == 'Admin'){

           document.getElementById("EMP"+r).style.display = "none";
           document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Emp'){
            document.getElementById("EMP"+r).style.display = "block";
              document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Ship'){
            document.getElementById("EMP"+r).style.display = "none";
          document.getElementById("SHIP"+r).style.display = "block";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Vend'){
            document.getElementById("EMP"+r).style.display = "none";
             document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "block";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Client'){
         document.getElementById("EMP"+r).style.display = "none";
              document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "block";


       }
   }

</script>


<script>

        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klarapps/public_html/star2.klarapps.com/resources/views/admin/Admins.blade.php ENDPATH**/ ?>