<?php use App\Models\CommentsClients;use App\Models\Customers;use App\Models\Sales; ?>

<?php $__env->startSection('content'); ?>

    <title><?php echo e(trans('admin.CustomerPeriodReports')); ?></title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.CRM')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.CustomerPeriodReports')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i><?php echo e(trans('admin.CustomerPeriodReports')); ?></i></span>
                        </h2>

                        <div class="panel-toolbar">

                        </div>
                        <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th><?php echo e(trans('admin.Clients_Count')); ?></th>
                                    <th><?php echo e(trans('admin.Comments_Count')); ?></th>
                                    <th><?php echo e(trans('admin.Sales_Bill_Count')); ?></th>
                                    <th><?php echo e(trans('admin.Total_Sales_Bill')); ?></th>

                                </tr>
                                </thead>
                                <tbody>


                                <tr>

                                    <td>
                                        <button type="button" class="btn btn-primary" data-toggle="modal"
                                                data-target="#details"><?php echo e($CustmersCount); ?></button>
                                    </td>
                                    <td><?php echo e($CommentsCount); ?></td>
                                    <td><?php echo e($SalesCount); ?></td>
                                    <td><?php echo e($SalesTotal); ?></td>


                                </tr>

                                </tbody>
                                <tfoot>
                                <tr>
                                    <th><?php echo e(trans('admin.Clients_Count')); ?></th>
                                    <th><?php echo e(trans('admin.Comments_Count')); ?></th>
                                    <th><?php echo e(trans('admin.Sales_Bill_Count')); ?></th>
                                    <th><?php echo e(trans('admin.Total_Sales_Bill')); ?></th>
                                </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal Details -->
        <div class="modal fade" id="details" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            <?php echo e(trans('admin.details')); ?>

                        </h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <table
                            class="table table-bordered table-hover table-striped w-100">
                            <thead class="bg-highlight">
                            <tr>
                                <th><?php echo e(trans('admin.Governrate')); ?></th>
                                <th><?php echo e(trans('admin.Count')); ?></th>


                            </tr>
                            </thead>
                            <tbody>

                            <?php $__currentLoopData = $Governrates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gov): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php    $Count=Customers::whereBetween('Date',[request('From'),request('To')])->where('Governrate',$gov->id)->count();  ?>
                                <tr>


                                    <td><?php echo e(app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name); ?></td>

                                    <td><?php echo e($Count); ?></td>


                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?></button>

                    </div>
                </div>
            </div>
        </div>

    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print"
          href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klarapps/public_html/1.klarapps.com/resources/views/admin/CRM/CustomerPeriodReportFilter.blade.php ENDPATH**/ ?>