<!DOCTYPE>
<?php
use App\Models\CompanyData;
$Def=CompanyData::orderBy('id','desc')->first();
?>
<html>
   <head>
      <meta charset="utf-8">
      <meta name="description" content="Basic">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no, minimal-ui">
      <!-- Call App Mode on ios devices -->
      <meta name="apple-mobile-web-app-capable" content="yes" />
      <!-- Remove Tap Highlight on Windows Phone IE -->
      <meta name="msapplication-tap-highlight" content="no">
           <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests" />
      <!-- base css -->
      <link id="vendorsbundle" rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/vendors.bundle.css')); ?>">
      <link id="appbundle" rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/app.bundle.css')); ?>">
      <link id="mytheme" rel="stylesheet" media="screen, print" href="#">
      <link id="myskin" rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/skins/skin-master.css')); ?>">
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/style.css')); ?>">
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/style-ar.css')); ?>">
      <!-- Place favicon.ico in the root directory -->
      <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('Admin/img/favicon/apple-touch-icon.png')); ?>">
      <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(URL::to($Def->Icon_Store)); ?>">
      <link rel="mask-icon" href="<?php echo e(URL::to($Def->Icon_Store)); ?>" color="#5bbad5">
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">
      <style>
         .carousel-item img{
         height: 100vh;
         }
         .menu{
         /*margin-top:50px;*/
         }
         .head-menu{
         text-align: center;
         }
         .head-menu img{
         height: 90px;
          position: relative;
          animation: mymove 5s infinite;
           animation-direction: alternate-reverse;
         }
         @keyframes  mymove {
  0%   {left:0px; top:0px;}
  50%  {left:200px; top:0px;}
  100% {left:-200px; top:0px;}
         }
         .head-menu h1{
         color: #886ab5;
         font-size: 30px;
         padding-bottom: 20px;
         }
         .product{
         margin-top: 10px;
         border: 1px solid #ccc;
         border-radius: 5px;
         padding: 5px;
         background: #deebf559;
         }
         .product img{
         height: 70px;
         width:70px;
         /*max-width:100%;*/
         }
         .product p{
         /*color: #646464;*/
         margin-bottom: 0;
         }
         .product .padding-item{
         padding-right: 0;
         }
         .filter{
         background: #359bca40;
         padding:10px 15px 0 15px;
         border: 1px solid #ccc;
         border-radius: 5px;
         }
         .numbers{
         margin-top: 34px;
         color:#046787;
         font-size:140%;
         }
         
          .numbers p{
              margin-bottom:0;
          }
          .numbers p i{
            margin: 0 5px
          }
         .price{
             color:#046785;
             text-align: center;
             font-size:19px;
             position: absolute;
             bottom: 0;
         }
         .btn-primary ,.btn-primary:hover ,.btn-primary:active ,.btn-primary:focus {
          color: #fff;
          background-color: #0aa5d3;
          border-color: #0aa5d3;
        }
        
        
        
        .product img {
    border-radius: 5px;
    cursor: pointer;
    transition: 0.3s;
}

.product img:hover {opacity: 0.7;}

/* The Modal (background) */
.modal-img {
    display: none; /* Hidden by default */
    position: fixed; /* Stay in place */
    z-index: 1; /* Sit on top */
    padding-top: 100px; /* Location of the box */
    left: 0;
    top: 0;
    width: 100%; /* Full width */
    height: 100%; /* Full height */
    overflow: auto; /* Enable scroll if needed */
    background-color: rgb(0,0,0); /* Fallback color */
    background-color: rgba(0,0,0,0.9); /* Black w/ opacity */
}

/* Modal Content (image) */
.product .modal-content {
    margin: auto;
    display: block;
    width: 80%;
    max-width: 700px;
    height:auto;
}

/* Caption of Modal Image */
#caption {
    margin: auto;
    display: block;
    width: 80%;
    max-width: 700px;
    text-align: center;
    color: #ccc;
    padding: 10px 0;
    height: 150px;
}

/* Add Animation */
.modal-content, #caption {    
    -webkit-animation-name: zoom;
    -webkit-animation-duration: 0.6s;
    animation-name: zoom;
    animation-duration: 0.6s;
}

@-webkit-keyframes zoom {
    from {-webkit-transform:scale(0)} 
    to {-webkit-transform:scale(1)}
}

@keyframes  zoom {
    from {transform:scale(0)} 
    to {transform:scale(1)}
}

/* The Close Button */
.modal-img .close-img {
    position: absolute;
    top: 15px;
    right: 35px;
    color: #f1f1f1;
    font-size: 40px;
    font-weight: bold;
    transition: 0.3s;
}

.modal-img .close-img:hover,
.modal-img .close-img:focus {
    color: #bbb;
    text-decoration: none;
    cursor: pointer;
}

/* 100% Image Width on Smaller Screens */
@media  only screen and (max-width: 700px){
    .modal-content {
        width: 100%;
    }
}

.head-menu img{
    
}
       
        @media(max-width:600px){
            .filter{
                padding-bottom:13px;
            }
        }
      </style>
   </head>
   <body>
      <title><?php echo e(trans('admin.Price_List')); ?></title>
      <!-- Start Menu -->
      <section class="menu">
         <div class="row">
            <div class="col-md-5">
               <div class="numbers text-center">
                  <p><i class="fal fa-phone"></i><?php echo e($Def->Phone1); ?></p>
                  <p><i class="fal fa-phone"></i><?php echo e($Def->Phone2); ?></p>
               </div>
            </div>
            <div class="col-md-2">
               <div class=" head-menu">
                  <img src="<?php echo e(URL::to($company->Logo_Store)); ?>" alt="">
               </div>
            </div>
            <div class="col-md-5">
               <div class="numbers text-center">
                  <p> <?php echo e($Def->Phone3); ?> <i class="fal fa-phone-alt"></i></p>
                  <p> <?php echo e($Def->Phone4); ?> <i class="fal fa-phone-alt"></i></p>
               </div>
            </div>
         </div>
         <!-- Start Filter -->
         <div class="container-fluid">
            <div class="filter">
               <div class="row">
                  <div class="form-group col-md-4">
                     <label class="form-label" for="">  <?php echo e(trans('admin.Brands')); ?> </label>
                     <select class="select2 form-control w-100" id="Brand">
                        <option value=""><?php echo e(trans('admin.Brands')); ?></option>
                        <?php $__currentLoopData = $Brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($brand->id); ?>"><?php echo e(app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </select>
                  </div>
                  <div class="form-group col-md-4">
                     <label class="form-label" for="">  <?php echo e(trans('admin.Groups')); ?> </label>
                     <select class="select2 form-control w-100" id="Group">
                        <option value=""><?php echo e(trans('admin.Groups')); ?></option>
                        <?php $__currentLoopData = $Groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($group->id); ?>"><?php echo e(app()->getLocale() == 'ar' ?$group->Name :$group->NameEn); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </select>
                  </div>
                  <div class="form-group col-md-4">
                     <label class="form-label" for="">  <?php echo e(trans('admin.Search')); ?> </label>
                     <input type="text" id="Search" class="form-control">
                  </div>
               </div>
            </div>
         </div>
         <!-- End Filter -->
         <div class="container-fluid">
            <div class="row Data">
               <?php $__currentLoopData = $Products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <?php if($pro->Product()->first()->Store_Show == 2 or $pro->Product()->first()->Store_Show == 3): ?>
               <div class="col-md-2">
                  <div class="product">
                     <div class="row">
                        <div class="col-md-6 col-6 text-center">
                           <?php if(!empty($pro->Product()->first()->Image)): ?>
                           <img id="myImg<?php echo e($pro->id); ?>" onclick="OPEN(<?php echo e($pro->id); ?>)" src="<?php echo e(URL::to($pro->Product()->first()->Image)); ?>" alt=""> 
                           <?php else: ?>
                           <img id="myImg<?php echo e($pro->id); ?>" onclick="OPEN(<?php echo e($pro->id); ?>)" src="<?php echo e(asset('Admin/img/demo/gallery/5.jpg')); ?>" alt="">
                           <?php endif; ?>
                          <!-- The Modal -->
<div id="myModal<?php echo e($pro->id); ?>" class="modal-img">
  <span class="close-img" id="close<?php echo e($pro->id); ?>">&times;</span>
  <img class="modal-content" id="img<?php echo e($pro->id); ?>">
  <div id="caption<?php echo e($pro->id); ?>"></div>
</div>
                           <h6 style="color:#82b0ee;text-align: center;font-size:140%;margin: 5px 0 0 0;">   <?php echo e(app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn); ?>  </h6>
                           <p style="color:blue; text-align: center;font-size:140%;"> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description<?php echo e($pro->id); ?>"> <?php echo e(trans('admin.Desc')); ?></button></p>
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                           <h5>  <?php echo e(app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name); ?></h5>
                           <br>
                           <p class="price"><?php echo e(trans('admin.Price')); ?>: <span><?php echo e($pro->Price); ?></span></p>
                           
                        </div>
                     </div>
                  </div>
               </div>
               <!-- description modal  -->
               <div class="modal fade" id="description<?php echo e($pro->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                  <div class="modal-dialog" role="document">
                     <div class="modal-content">
                        <div class="modal-header">
                           <h4 class="modal-title">
                              <?php echo e(trans('admin.Desc')); ?>

                           </h4>
                           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                           <span aria-hidden="true"><i class="fal fa-times"></i></span>
                           </button>
                        </div>
                        <div class="modal-body">
                           <?php if(!empty($pro->Product()->first()->Ar_Desc)): ?>
                      <?php echo e(app()->getLocale() == 'ar' ?$pro->Product()->first()->Ar_Desc :$pro->StProductoProductre()->first()->En_Desc); ?>     
                           <?php endif; ?>
                        </div>
                        <div class="modal-footer">
                        </div>
                     </div>
                  </div>
               </div>
               <!-- End Menu -->
               <?php endif; ?>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
         </div>
      </section>
      <script src="<?php echo e(asset('Admin/js/vendors.bundle.js')); ?>"></script>
      <script src="<?php echo e(asset('Admin/js/app.bundle.js')); ?>"></script>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/holder/2.9.7/holder.min.js"></script>
      <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
      <script>
         $(document).ready(function()
         {
             $(function()
             {
                 $('.select2').select2();
         
                 $(".select2-placeholder-multiple").select2(
                 {
                     placeholder: "Select State"
                 });
                 $(".js-hide-search").select2(
                 {
                     minimumResultsForSearch: 1 / 0
                 });
                 $(".js-max-length").select2(
                 {
                     maximumSelectionLength: 2,
                     placeholder: "Select maximum 2 items"
                 });
                 $(".select2-placeholder").select2(
                 {
                     placeholder: "Select a state",
                     allowClear: true
                 });
         
                 $(".js-select2-icons").select2(
                 {
                     minimumResultsForSearch: 1 / 0,
                     templateResult: icon,
                     templateSelection: icon,
                     escapeMarkup: function(elm)
                     {
                         return elm
                     }
                 });
         
                 function icon(elm)
                 {
                     elm.element;
                     return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                 }
         
                 $(".js-data-example-ajax").select2(
                 {
                     ajax:
                     {
                         url: "https://api.github.com/search/repositories",
                         dataType: 'json',
                         delay: 250,
                         data: function(params)
                         {
                             return {
                                 q: params.term, // search term
                                 page: params.page
                             };
                         },
                         processResults: function(data, params)
                         {
                             // parse the results into the format expected by Select2
                             // since we are using custom formatting functions we do not need to
                             // alter the remote JSON data, except to indicate that infinite
                             // scrolling can be used
                             params.page = params.page || 1;
         
                             return {
                                 results: data.items,
                                 pagination:
                                 {
                                     more: (params.page * 30) < data.total_count
                                 }
                             };
                         },
                         cache: true
                     },
                     placeholder: 'Search for a repository',
                     escapeMarkup: function(markup)
                     {
                         return markup;
                     }, // let our custom formatter work
                     minimumInputLength: 1,
                     templateResult: formatRepo,
                     templateSelection: formatRepoSelection
                 });
         
                 function formatRepo(repo)
                 {
                     if (repo.loading)
                     {
                         return repo.text;
                     }
         
                     var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                         "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                         "<div class='select2-result-repository__meta'>" +
                         "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";
         
                     if (repo.description)
                     {
                         markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                     }
         
                     markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                         "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                         "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                         "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                         "</div>" +
                         "</div></div>";
         
                     return markup;
                 }
         
                 function formatRepoSelection(repo)
                 {
                     return repo.full_name || repo.text;
                 }
             });
         });
         
      </script>
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
      <link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">
      <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
      <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
      <script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
      <script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
      <script>
         var autoSave = $('#autoSave');
         var interval;
         var timer = function()
         {
             interval = setInterval(function()
             {
                 //start slide...
                 if (autoSave.prop('checked'))
                     saveToLocal();
         
                 clearInterval(interval);
             }, 3000);
         };
         
         //save
         var saveToLocal = function()
         {
             localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
             console.log("saved");
         }
         
         //delete 
         var removeFromLocal = function()
         {
             localStorage.removeItem("summernoteData");
             $('#saveToLocal').summernote('reset');
         }
         
         $(document).ready(function()
         {
             //init default
             $('.js-summernote').summernote(
             {
                 height: 200,
                 tabsize: 2,
                 placeholder: "Type here...",
                 dialogsFade: true,
                 toolbar: [
                     ['style', ['style']],
                     ['font', ['strikethrough', 'superscript', 'subscript']],
                     ['font', ['bold', 'italic', 'underline', 'clear']],
                     ['fontsize', ['fontsize']],
                     ['fontname', ['fontname']],
                     ['color', ['color']],
                     ['para', ['ul', 'ol', 'paragraph']],
                     ['height', ['height']]
                     ['table', ['table']],
                     ['insert', ['link', 'picture', 'video']],
                     ['view', ['fullscreen', 'codeview', 'help']]
                 ],
                 callbacks:
                 {
                     //restore from localStorage
                     onInit: function(e)
                     {
                         $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                     },
                     onChange: function(contents, $editable)
                     {
                         clearInterval(interval);
                         timer();
                     }
                 }
             });
         
             //load emojis
             $.ajax(
             {
                 url: 'https://api.github.com/emojis',
                 async: false
             }).then(function(data)
             {
                 window.emojis = Object.keys(data);
                 window.emojiUrls = data;
             });
         
             //init emoji example
             $(".js-hint2emoji").summernote(
             {
                 height: 100,
                 toolbar: false,
                 placeholder: 'type starting with : and any alphabet',
                 hint:
                 {
                     match: /:([\-+\w]+)$/,
                     search: function(keyword, callback)
                     {
                         callback($.grep(emojis, function(item)
                         {
                             return item.indexOf(keyword) === 0;
                         }));
                     },
                     template: function(item)
                     {
                         var content = emojiUrls[item];
                         return '<img src="' + content + '" width="20" /> :' + item + ':';
                     },
                     content: function(item)
                     {
                         var url = emojiUrls[item];
                         if (url)
                         {
                             return $('<img />').attr('src', url).css('width', 20)[0];
                         }
                         return '';
                     }
                 }
             });
         
             //init mentions example
             $(".js-hint2mention").summernote(
             {
                 height: 100,
                 toolbar: false,
                 placeholder: "type starting with @",
                 hint:
                 {
                     mentions: ['jayden', 'sam', 'alvin', 'david'],
                     match: /\B@(\w*)$/,
                     search: function(keyword, callback)
                     {
                         callback($.grep(this.mentions, function(item)
                         {
                             return item.indexOf(keyword) == 0;
                         }));
                     },
                     content: function(item)
                     {
                         return '@' + item;
                     }
                 }
             });
         
         });
         
      </script>
      <!--  Filter Products -->
      <script>
         $(document).ready(function(){
         
          fetch_customer_data();
         
          function fetch_customer_data(Brand = '',Group='',HP='',LP='',Search='')
          {  
           $.ajax({
            url:'GUESTLISTFilter',
            method:'GET',
            data:{Brand:Brand,Group:Group,HP:HP,LP:LP,Search:Search},
            dataType:'json',
            success:function(data)
            {
             $('.Data').html(data.table_data);
         
            }
           })
          }
          
              $(document).on('change', '#Brand', function(){
           var Brand = $(this).val();     
           var Group = $('#Group').val();     
           var HP = $('#HP').val();     
           var LP = $('#LP').val();     
             var Search = $('#Search').val();     
           fetch_customer_data(Brand,Group,HP,LP,Search);
          });
             
                $(document).on('change', '#Group', function(){
           var Group = $(this).val();     
           var Brand = $('#Brand').val();     
           var HP = $('#HP').val();     
           var LP = $('#LP').val();     
              var Search = $('#Search').val();     
           fetch_customer_data(Brand,Group,HP,LP,Search);
          });
             
                $(document).on('change', '#HP', function(){
           var HP = $(this).val();     
           var Group = $('#Group').val();     
           var Brand = $('#Brand').val();     
           var LP = $('#LP').val();     
             var Search = $('#Search').val();     
           fetch_customer_data(Brand,Group,HP,LP,Search);
          });
             
                $(document).on('change', '#LP', function(){
           var LP = $(this).val();     
           var Group = $('#Group').val();     
           var HP = $('#HP').val();     
           var Brand = $('#Brand').val();     
               var Search = $('#Search').val();     
           fetch_customer_data(Brand,Group,HP,LP,Search);
          });
             
                 $(document).on('keyup', '#Search', function(){
           var Search = $(this).val();     
           var Group = $('#Group').val();     
           var HP = $('#HP').val();     
           var Brand = $('#Brand').val();     
               var LP = $('#LP').val();     
           fetch_customer_data(Brand,Group,HP,LP,Search);
          });
              
         });
      </script>
       
     
      <script>
          
function OPEN(R){          
          // Get the modal
var modal = document.getElementById('myModal'+R);

// Get the image and insert it inside the modal - use its "alt" text as a caption
var img = document.getElementById('myImg'+R);
var modalImg = document.getElementById("img"+R);
var captionText = document.getElementById("caption"+R);

    modal.style.display = "block";
    modalImg.src = img.src;
    captionText.innerHTML = img.alt;



       $(document).on('click', '#close'+R, function(){
            modal.style.display = "none";
 });
}
      </script>

       
   </body>
</html><?php /**PATH /home/klarapps/public_html/test.klarapps.com/resources/views/GUESTLIST.blade.php ENDPATH**/ ?>