<?php use App\Models\CommentsClients;use App\Models\Sales; ?>

<?php $__env->startSection('content'); ?>

    <title><?php echo e(trans('admin.Customerـfollowـup_Reports')); ?></title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> <?php echo e(trans('admin.CRM')); ?></a></li>
            <li class="breadcrumb-item active"><?php echo e(trans('admin.Customerـfollowـup_Reports')); ?></li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                    class="js-get-date"></span></li>
        </ol>

        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i><?php echo e(trans('admin.Customerـfollowـup_Reports')); ?></i></span>
                        </h2>

                        <div class="panel-toolbar">

                        </div>
                        <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="panel-container show">
                        <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <div class="panel-content">
                            <!-- datatable start -->
                            <table id="dt-basic-example"
                                   class="table table-bordered table-hover table-striped w-100">
                                <thead class="bg-highlight">
                                <tr>
                                    <th><?php echo e(trans('admin.Client')); ?></th>
                                    <th><?php echo e(trans('admin.Addation_Date')); ?></th>
                                    <th><?php echo e(trans('admin.Date_First_Comment')); ?></th>
                                    <th><?php echo e(trans('admin.Date_First_Bill')); ?></th>
                                    <th><?php echo e(trans('admin.Operation_Date')); ?></th>
                                    <th><?php echo e(trans('admin.Dif_Days_Addation_Date_First_Comment')); ?></th>
                                    <th><?php echo e(trans('admin.Dif_Days_Addation_Date_First_Bill')); ?></th>
                                    <th><?php echo e(trans('admin.Dif_Days_Addation_Date_Operation_Date')); ?></th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $firstComment = CommentsClients::where('Customer', $item->id)->orderBy('Date')->first();
                                                  $firstBill = Sales::where('Client', $item->Account)->oldest('Date')->first();
                                                  if (!empty($firstComment)) {
                                                      $firstComment = $firstComment->Date;
                                                  } else {
                                                      $firstComment = 0;
                                                  }
                                                  if (!empty($firstBill)) {
                                                      $firstBill = $firstBill->Date;
                                                  } else {
                                                      $firstBill = 0;
                                                  }


                                                  $datetime1 = new DateTime($item->Date);
                                                  if ($firstComment != 0) {
                                                      $datetime2 = new DateTime($firstComment);
                                                      $interval = $datetime1->diff($datetime2);
                                                      $daysComment = $interval->format('%a');
                                                  } else {
                                                      $daysComment = 0;
                                                  }

                                                  if ($firstBill != 0) {
                                                      $datetimeBill = new DateTime($firstBill);
                                                      $intervalBill = $datetime1->diff($datetimeBill);
                                                      $daysBill = $intervalBill->format('%a');
                                                  } else {
                                                      $daysBill = 0;
                                                  }

                                                  if (!empty($item->Operation_Date)) {
                                                      $datetimeOp = new DateTime($item->Operating_Date);
                                                      $intervalOp = $datetime1->diff($datetimeOp);
                                                      $daysOp = $intervalOp->format('%a');
                                                  } else {
                                                      $daysOp = 0;
                                                  }
                                    ?>

                                    <tr>
                                        <td>
                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Name :$item->NameEn); ?>

                                        </td>
                                        <td><?php echo e($item->Date); ?></td>
                                        <td><?php echo e($firstComment); ?></td>
                                        <td><?php echo e($firstBill); ?></td>
                                        <td><?php echo e($item->Operating_Date); ?></td>
                                        <td><?php echo e($daysComment); ?></td>
                                        <td><?php echo e($daysBill); ?></td>
                                        <td><?php echo e($daysOp); ?></td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <th><?php echo e(trans('admin.Client')); ?></th>
                                    <th><?php echo e(trans('admin.Addation_Date')); ?></th>
                                    <th><?php echo e(trans('admin.Date_First_Comment')); ?></th>
                                    <th><?php echo e(trans('admin.Date_First_Bill')); ?></th>
                                    <th><?php echo e(trans('admin.Operation_Date')); ?></th>
                                    <th><?php echo e(trans('admin.Dif_Days_Addation_Date_First_Comment')); ?></th>
                                    <th><?php echo e(trans('admin.Dif_Days_Addation_Date_First_Bill')); ?></th>
                                    <th><?php echo e(trans('admin.Dif_Days_Addation_Date_Operation_Date')); ?></th>
                                </tr>
                                </tfoot>
                            </table>
                            <!-- datatable end -->
                            <?php echo e($items->Links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>


    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <link rel="stylesheet" media="screen, print"
          href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
    <script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/klarapps/public_html/test.klarapps.com/resources/views/admin/CRM/Customerـfollowـup_ReportsFilter.blade.php ENDPATH**/ ?>