<?php $__env->startSection('content'); ?>
<?php
use App\Models\AccountsDefaultData;
use App\Models\DefaultDataShowHide;
$Def=AccountsDefaultData::orderBy('id','desc')->first();
$show=DefaultDataShowHide::orderBy('id','desc')->first();
?>
<title><?php echo e(trans('admin.Incoming_checks')); ?></title>

<!-- the #js-page-content id is needed for some plugins to initialize -->
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e(trans('admin.Accounts')); ?></a></li>
        <li class="breadcrumb-item active"> <?php echo e(trans('admin.Incoming_checks')); ?></li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <!-- Filter -->
    <div class="panel-container show">
        <div class="panel-content">


            <form action="<?php echo e(url('IncomingchecksSechduleFilter')); ?>" method="get">

                <div class="form-row">
                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput"><?php echo e(trans('admin.From')); ?></label>
                        <input type="date" id="from" value="<?php echo e(date('Y-m-d')); ?>" name="From" class="form-control">
                    </div>
                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput"><?php echo e(trans('admin.To')); ?></label>
                        <input type="date" id="to" value="<?php echo e(date('Y-m-d')); ?>" name="To" class="form-control">
                    </div>

                    <div class="form-group col-lg-3">
                        <label class="form-label" for=""> <?php echo e(trans('admin.Account_Name')); ?> </label>
                        <select class="js-data-example-ajax form-control w-100 Acc" name="Account">
                        </select>
                    </div>


                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Due_Date')); ?></label>
                        <input type="date" id="Due_Date" name="Due_Date" class="form-control">
                    </div>


                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Code')); ?></label>
                        <input type="text" id="Code" name="Code" class="form-control">
                    </div>
                    <div class="buttons m-2">
                        <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">

                <div class="panel-hdr">
                    <h2>
                        <?php echo e(trans('admin.Incoming_checks')); ?>

                    </h2>

                    <div class="panel-toolbar">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('اضافه شيك وارد')): ?>
                        <button type="button" class="btn btn-default btn-sm margin-btn" data-toggle="modal" data-target="#default-example-modal-center-add">
                            <?php echo e(trans('admin.AddNew')); ?></button>
                        <?php endif; ?>

                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                            Style</button>

                        <?php echo $__env->make('admin.layouts.toolbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>


                </div>
                <div class="panel-container show">
                    <span id="ex"> <?php echo $__env->make('admin.layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                    <div class="panel-content">

                        <!-- datatable start -->
                        <div style="overflow:auto;">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th><?php echo e(trans('admin.Date')); ?></th>
                                        <th> <?php echo e(trans('admin.Account_Name')); ?></th>
                                        <th> <?php echo e(trans('admin.Bank')); ?></th>
                                        <th> <?php echo e(trans('admin.Check_Num')); ?></th>
                                        <th> <?php echo e(trans('admin.Due_Date')); ?></th>
                                        <th> <?php echo e(trans('admin.Amount')); ?></th>
                                        <th> <?php echo e(trans('admin.Data')); ?></th>
                                        <th> <?php echo e(trans('admin.File')); ?></th>
                                        <th style="padding: 13px 75px;"> <?php echo e(trans('admin.Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr <?php if($item->Edit == 1): ?> class="edited" <?php elseif($item->Delete == 1): ?> class="deleted" <?php elseif($item->Transfer == 1): ?> class="transfered" <?php endif; ?>>
                                        <td><?php echo e($item->Code); ?></td>
                                        <td><?php echo e($item->Date); ?></td>
                                        <td>

                                            <?php if(!empty($item->Account()->first()->Name)): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn); ?>

                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <?php if(!empty($item->Bank()->first()->Name)): ?>
                                            <?php echo e(app()->getLocale() == 'ar' ?$item->Bank()->first()->Name :$item->Bank()->first()->NameEn); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->Check_Num); ?></td>
                                        <td><?php echo e($item->Due_Date); ?></td>

                                        <td><?php echo e($item->Amount); ?></td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#show-data<?php echo e($item->id); ?>">
                                                <?php echo e(trans('admin.Data')); ?>

                                            </button>
                                        </td>

                                        <td>
                                            <?php if(!empty($item->File)): ?>
                                            <a href="<?php echo e(URL::to($item->File)); ?>" class="btn btn-primary" dowmload><i class="fal fa-download"></i></a>
                                            <?php endif; ?>
                                        </td>
                                        <td>

                                            <?php if($item->Edit == 0 and $item->Delete == 0 and $item->Transfer == 0): ?>

                                            <?php if($item->Status == 0): ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تعديل شيك صادر')): ?>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Edit<?php echo e($item->id); ?>">
                                                <i class="fal fa-edit"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('تحويل الي شيك وارد')): ?>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Trans<?php echo e($item->id); ?>">
                                                <i class="fal fa-money-check-alt"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('رفض شيك صادر')): ?>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Ref<?php echo e($item->id); ?>">
                                                <i class="fal fa-ban"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('صرف شيك صادر')): ?>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Pay<?php echo e($item->id); ?>">
                                                <i class="fal fa-money-check"></i>
                                            </button>
                                            <?php endif; ?>

                                            <a type="button" class="btn btn-default" href="<?php echo e(url('PrintIncomChecks/'.$item->id)); ?>">
                                                <i class="fal fa-print"></i>
                                            </a>


                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('حذف شيك صادر')): ?>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete<?php echo e($item->id); ?>">
                                                <i class="fal fa-trash"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>

                                            <?php endif; ?>


                                            <?php if($item->Edit == 1): ?>
                                            <span class="btn btn-warning"><?php echo e(trans('admin.Edited_to_New_One')); ?> (<?php echo e($item->Edit_New_Code); ?>)</span>
                                            <?php elseif($item->Delete == 1): ?>

                                            <span class="btn btn-danger"><?php echo e(trans('admin.Deleted')); ?></span>

                                            <?php elseif($item->Transfer == 1): ?>

                                            <span class="btn btn-primary"><?php echo e(trans('admin.Transfer_to')); ?> (<?php echo e($item->Edit_New_Code); ?>)</span>
                                            <?php endif; ?>



                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th><?php echo e(trans('admin.Code')); ?></th>
                                        <th><?php echo e(trans('admin.Date')); ?></th>
                                        <th> <?php echo e(trans('admin.Account_Name')); ?></th>
                                        <th> <?php echo e(trans('admin.Bank')); ?></th>
                                        <th> <?php echo e(trans('admin.Check_Num')); ?></th>
                                        <th> <?php echo e(trans('admin.Due_Date')); ?></th>
                                        <th> <?php echo e(trans('admin.Amount')); ?></th>
                                        <th> <?php echo e(trans('admin.Data')); ?></th>
                                        <th> <?php echo e(trans('admin.File')); ?></th>
                                        <th> <?php echo e(trans('admin.Actions')); ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php echo e($items->Links()); ?>

                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<!-- Modal Add -->
<div class="modal fade" id="default-example-modal-center-add" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.AddNew')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="<?php echo e(url('AddIncoming_checks')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <?php echo view('honeypot::honeypotFormFields'); ?>
                <div class="modal-body">

                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Code')); ?></label>
                            <input type="text" value="<?php echo e($Code); ?>" disabled class="form-control">
                            <input type="hidden" name="Code" value="<?php echo e($Code); ?>">
                        </div>
                        <?php if(auth()->guard('admin')->user()->emp == 0): ?>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                            <input type="date" name="Date" value="<?php echo e(date('Y-m-d')); ?>" class="form-control" required>
                        </div>
                        <?php else: ?>

                        <?php if(auth()->guard('admin')->user()->Date == 1): ?>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                            <input type="date" name="Date" value="<?php echo e(date('Y-m-d')); ?>" class="form-control" required>
                        </div>
                        <?php else: ?>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                            <input type="date" name="Date" value="<?php echo e(date('Y-m-d')); ?>" class="form-control" required readonly>
                        </div>
                        <?php endif; ?>

                        <?php endif; ?>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Account_Name')); ?> </label>
                            <select class="js-data-example-ajax form-control w-100" name="Account" id="AccountCode" required>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Check_Type')); ?> </label>
                            <select class="select2 form-control w-100" name="Check_Type" required>
                                <option value=""><?php echo e(trans('admin.Check_Type')); ?> </option>
                                <?php $__currentLoopData = $ChecksTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>">
                                    <?php echo e(app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Bank')); ?> </label>
                            <select class="js-data-example-ajax form-control w-100" name="Bank" id="Bank" required>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Check_Num')); ?></label>
                            <input type="text" name="Check_Num" value="<?php echo e(old('Check_Num')); ?>" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Due_Date')); ?></label>
                            <input type="date" name="Due_Date" value="<?php echo e(old('Due_Date')); ?>" class="form-control" required>
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Coin')); ?> </label>
                            <select class="select2 form-control w-100" name="Coin" required>
                                <option value=""><?php echo e(trans('admin.Coin')); ?></option>
                                <?php $__currentLoopData = $Coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($coin->id); ?>" <?php if($coin->id == $Def->Coin): ?> selected <?php endif; ?>>
                                    <?php echo e(app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Draw')); ?></label>
                            <input type="number" step="any" name="Draw" value="<?php echo e($Def->Draw); ?>" class="form-control" required />
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Cost_Center')); ?> </label>
                            <select class="select2 form-control w-100" name="Cost_Center">
                                <option value=""><?php echo e(trans('admin.Cost_Center')); ?> </option>
                                <?php $__currentLoopData = $CostCenters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cost->id); ?>">
                                    <?php echo e(app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Amount')); ?></label>
                            <input type="number" step="any" value="<?php echo e(old('Amount')); ?>" name="Amount" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Notes')); ?></label>
                            <input type="text" name="Note" value="<?php echo e(old('Note')); ?>" class="form-control">
                        </div>




                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Signture_Name')); ?></label>
                            <input type="text" name="Signture_Name" value="<?php echo e(old('Signture_Name')); ?>" class="form-control">
                        </div>


                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Bank_Branch')); ?></label>
                            <input type="text" name="Bank_Branch" value="<?php echo e(old('Bank_Branch')); ?>" class="form-control">
                        </div>

                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Image')); ?></label>
                            <input type="file" name="Image">
                        </div>


                        <?php if($show->Show_File_Checks == 1): ?>
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.File')); ?></label>
                            <input type="file" name="File" class="form-control">
                        </div>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(trans('admin.Save')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>


<?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

<!-- Modal Edit-->
<div class="modal fade" id="Edit<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Edit')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="<?php echo e(url('EditIncoming_checks/'.$item->id)); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <?php echo view('honeypot::honeypotFormFields'); ?>
                <div class="modal-body">

                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Code')); ?></label>
                            <input type="text" name="Old_Code" value="<?php echo e($item->Code); ?>" readonly class="form-control">
                            <input type="hidden" name="Code" value="<?php echo e($Code); ?>">
                        </div>
                        <?php if(auth()->guard('admin')->user()->emp == 0): ?>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                            <input type="date" name="Date" value="<?php echo e($item->Date); ?>" class="form-control" required>
                        </div>
                        <?php else: ?>

                        <?php if(auth()->guard('admin')->user()->Date == 1): ?>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                            <input type="date" name="Date" value="<?php echo e($item->Date); ?>" class="form-control" required>
                        </div>
                        <?php else: ?>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                            <input type="date" name="Date" value="<?php echo e($item->Date); ?>" class="form-control" required readonly>
                        </div>
                        <?php endif; ?>

                        <?php endif; ?>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Account_Name')); ?> </label>
                            <select class="js-data-example-ajax form-control w-100 Acc" name="Account" required>
                                <option value="<?php echo e($item->Account); ?>" selected>
                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn); ?>

                                </option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Check_Type')); ?> </label>
                            <select class="select2 form-control w-100" name="Check_Type" required>
                                <option value=""><?php echo e(trans('admin.Check_Type')); ?> </option>
                                <?php $__currentLoopData = $ChecksTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>" <?php if($item->Check_Type == $type->id): ?> selected <?php endif; ?>>
                                    <?php echo e(app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">

                            <label class="form-label" for=""><?php echo e(trans('admin.Bank')); ?> </label>
                            <select class="js-data-example-ajax form-control w-100 Bn" name="Bank" required>
                                <option value="<?php echo e($item->Bank); ?>" selected>
                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Bank()->first()->Name :$item->Bank()->first()->NameEn); ?>

                                </option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Check_Num')); ?></label>
                            <input type="text" name="Check_Num" value="<?php echo e($item->Check_Num); ?>" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Due_Date')); ?></label>
                            <input type="date" name="Due_Date" value="<?php echo e($item->Due_Date); ?>" class="form-control" required>
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Coin')); ?> </label>
                            <select class="select2 form-control w-100" name="Coin" required>
                                <option value=""><?php echo e(trans('admin.Coin')); ?></option>
                                <?php $__currentLoopData = $Coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($coin->id); ?>" <?php if($item->Coin == $coin->id): ?> selected <?php endif; ?>>
                                    <?php echo e(app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Draw')); ?></label>
                            <input type="text" name="Draw" value="<?php echo e($item->Draw); ?>" required class="form-control">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Cost_Center')); ?> </label>
                            <select class="select2 form-control w-100" name="Cost_Center">
                                <option value=""><?php echo e(trans('admin.Cost_Center')); ?> </option>
                                <?php $__currentLoopData = $CostCenters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cost->id); ?>" <?php if($item->Cost_Center == $cost->id): ?> selected <?php endif; ?>>
                                    <?php echo e(app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Amount')); ?></label>
                            <input type="number" step="any" value="<?php echo e($item->Amount); ?>" name="Amount" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Notes')); ?></label>
                            <input type="text" name="Note" value="<?php echo e($item->Note); ?>" class="form-control">
                        </div>





                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Signture_Name')); ?></label>
                            <input type="text" name="Signture_Name" value="<?php echo e($item->Signture_Name); ?>" class="form-control">
                        </div>


                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Bank_Branch')); ?></label>
                            <input type="text" name="Bank_Branch" value="<?php echo e($item->Bank_Branch); ?>" class="form-control">
                        </div>

                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Image')); ?></label>
                            <input type="file" name="Image">
                        </div>


                        <input type="hidden" name="Files" value="<?php echo e($item->File); ?>">
                        <input type="hidden" name="Images" value="<?php echo e($item->Image); ?>">
                        <?php if($show->Show_File_Checks == 1): ?>
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.File')); ?></label>
                            <input type="file" name="File" class="form-control">
                        </div>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(trans('admin.SaveChanges')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Transfer to Incom Check-->
<div class="modal fade" id="Trans<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Transfer_to_ExportCheck')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <form action="<?php echo e(url('TransIncoming_checks')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <?php echo view('honeypot::honeypotFormFields'); ?>
                <div class="modal-body">

                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Code')); ?></label>
                            <input type="text" value="<?php echo e($item->Code); ?>" disabled class="form-control">
                            <input type="hidden" name="Code" value="<?php echo e($item->Code); ?>">
                            <input type="hidden" name="ID" value="<?php echo e($item->id); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Date')); ?></label>
                            <input type="date" value="<?php echo e($item->Date); ?>" class="form-control" disabled>
                            <input type="hidden" name="Date" value="<?php echo e($item->Date); ?>">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Account_Name')); ?> </label>
                            <select class="js-data-example-ajax form-control w-100" disabled>
                                <option value="<?php echo e($item->Account); ?>" selected>

                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn); ?>


                                </option>
                            </select>
                            <input type="hidden" name="Account" value="<?php echo e($item->Account); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Check_Type')); ?> </label>
                            <select class="select2 form-control w-100" name="Check_Type" disabled>
                                <option value=""><?php echo e(trans('admin.Check_Type')); ?> </option>
                                <?php $__currentLoopData = $ChecksTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>" <?php if($item->Check_Type == $type->id): ?> selected <?php endif; ?>>
                                    <?php echo e(app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="Check_Type" value="<?php echo e($item->Check_Type); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Bank')); ?> </label>
                            <select class="js-data-example-ajax form-control w-100" disabled>
                                <option value="<?php echo e($item->Bank); ?>" selected>

                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Bank()->first()->Name :$item->Bank()->first()->NameEn); ?>

                                </option>
                            </select>
                            <input type="hidden" name="Bank" value="<?php echo e($item->Bank); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> <?php echo e(trans('admin.Check_Num')); ?></label>
                            <input type="text" value="<?php echo e($item->Check_Num); ?>" class="form-control" disabled>
                            <input type="hidden" name="Check_Num" value="<?php echo e($item->Check_Num); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Due_Date')); ?></label>
                            <input type="date" value="<?php echo e($item->Due_Date); ?>" class="form-control" disabled>
                            <input type="hidden" name="Due_Date" value="<?php echo e($item->Due_Date); ?>">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Coin')); ?> </label>
                            <select class="select2 form-control w-100" disabled>
                                <option value=""><?php echo e(trans('admin.Coin')); ?></option>
                                <?php $__currentLoopData = $Coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($coin->id); ?>" <?php if($item->Coin == $coin->id): ?> selected <?php endif; ?>>
                                    <?php echo e(app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="Coin" value="<?php echo e($item->Coin); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Draw')); ?></label>
                            <input type="text" value="<?php echo e($item->Draw); ?>" class="form-control" disabled>
                            <input type="hidden" name="Draw" value="<?php echo e($item->Draw); ?>">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""><?php echo e(trans('admin.Cost_Center')); ?> </label>
                            <select class="select2 form-control w-100" disabled>
                                <option value=""><?php echo e(trans('admin.Cost_Center')); ?> </option>
                                <?php $__currentLoopData = $CostCenters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cost->id); ?>" <?php if($item->Cost_Center == $cost->id): ?> selected <?php endif; ?>>
                                    <?php echo e(app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="Cost_Center" value="<?php echo e($item->Cost_Center); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Amount')); ?></label>
                            <input type="number" step="any" value="<?php echo e($item->Amount); ?>" class="form-control" disabled>
                            <input type="hidden" name="Amount" value="<?php echo e($item->Amount); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"><?php echo e(trans('admin.Notes')); ?></label>
                            <input type="text" value="<?php echo e($item->Note); ?>" class="form-control" disabled>
                            <input type="hidden" name="Note" value="<?php echo e($item->Note); ?>">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Bene_Account')); ?></label>
                            <select class="js-data-example-ajax form-control w-100 Acc" name="Bene_Account">
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(trans('admin.Save')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Refuse -->
<div class="modal fade" id="Ref<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Refuse')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="<?php echo e(url('ReasonIncoming_checks')); ?>" method="post">
                <?php echo csrf_field(); ?>

                <?php echo view('honeypot::honeypotFormFields'); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput">
                                <?php echo e(trans('admin.Reason_Refuse')); ?>

                            </label>
                            <input type="text" name="Reason" value="<?php echo e(old('Reason')); ?>" class="form-control" required>
                            <input type="hidden" name="ID" value="<?php echo e($item->id); ?>">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.Close')); ?> </button>
                    <button type="submit" class="btn btn-primary"> <?php echo e(trans('admin.Save')); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Delete -->
<div class="modal fade" id="Delete<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Delete')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <?php echo e(trans('admin.RUSWDT')); ?> <strong><?php echo e($item->Code); ?></strong>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.No')); ?></button>
                <a href="<?php echo e(url('DeleteIncoming_checks/'.$item->id)); ?>" class="btn btn-primary"> <?php echo e(trans('admin.Yes')); ?></a>
            </div>
        </div>
    </div>
</div>

<!--Modal show data-->
<div class="modal fade" id="show-data<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Data')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div style="overflow:auto">
                    <table class="table table-bordered table-hover table-striped">
                        <thead class="bg-highlight">
                            <tr>
                                <th> <?php echo e(trans('admin.Check_Type')); ?></th>
                                <th> <?php echo e(trans('admin.Pay_Account')); ?></th>
                                <th> <?php echo e(trans('admin.Amount')); ?></th>
                                <th> <?php echo e(trans('admin.Coin')); ?></th>
                                <th> <?php echo e(trans('admin.Draw')); ?></th>
                                <th> <?php echo e(trans('admin.Coin_Amount')); ?></th>
                                <th> <?php echo e(trans('admin.Cost_Center')); ?></th>
                                <th> <?php echo e(trans('admin.Notes')); ?></th>
                                <th> <?php echo e(trans('admin.Status')); ?></th>
                                <th> <?php echo e(trans('admin.Image')); ?></th>
                                <th> <?php echo e(trans('admin.Signture_Name')); ?></th>
                                <th> <?php echo e(trans('admin.Bank_Branch')); ?></th>
                                <th> <?php echo e(trans('admin.User')); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                            <tr>
                                <td>

                                    <?php if(!empty($item->Check_Type()->first()->Arabic_Name)): ?>
                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Check_Type()->first()->Arabic_Name :$item->Check_Type()->first()->English_Name); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(!empty($item->Arrest_Account()->first()->Name)): ?>

                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Arrest_Account()->first()->Name :$item->Arrest_Account()->first()->NameEn); ?>


                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($item->Amount); ?></td>

                                <td>
                                    <?php if(!empty($item->Coin()->first()->Arabic_Name)): ?>
                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($item->Draw); ?></td>
                                <td><?php echo e($item->Draw * $item->Amount); ?></td>
                                <td>


                                    <?php if(!empty($item->Cost_Center()->first()->Arabic_Name)): ?>
                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name); ?>

                                    <?php endif; ?>
                                </td>

                                <td><?php echo e($item->Note); ?></td>
                                <td>
                                    <?php if($item->Status == 0): ?>
                                    <?php echo e(trans('admin.Waiting')); ?>


                                    <?php elseif($item->Status == 1): ?>

                                    <?php echo e(trans('admin.Refused')); ?> <br>

                                    <?php echo e($item->Reason); ?>




                                    <?php elseif($item->Status == 2): ?>

                                    <?php echo e(trans('admin.Transfered')); ?> <br>
                                    <?php if(!empty($item->Bene_Account)): ?>

                                    <?php echo e(app()->getLocale() == 'ar' ?$item->Bene_Account()->first()->Name :$item->Bene_Account()->first()->NameEn); ?>

                                    <?php endif; ?>

                                    <?php elseif($item->Status == 3): ?>


                                    <?php echo e(trans('admin.Check_Payed')); ?>



                                    <?php endif; ?>
                                </td>

                                <td><img src="<?php echo e(URL::to($item->Image)); ?>" style="width: 50%"></td>
                                <td><?php echo e($item->Signture_Name); ?></td>
                                <td><?php echo e($item->Bank_Branch); ?></td>

                                <td>

                                    <?php if(!empty($item->User()->first()->name)): ?>
                                    <?php echo e(app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn); ?>

                                    <?php endif; ?>
                                </td>

                            </tr>

                        </tbody>

                    </table>
                </div>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-secondary" data-dismiss="modal"> <?php echo e(trans('admin.close')); ?></button>

            </div>
        </div>
    </div>
</div>



<!-- Modal Pay -->
<div class="modal fade" id="Pay<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <?php echo e(trans('admin.Pay')); ?>

                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <form action="<?php echo e(url('PayIncomingChecks')); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <?php echo view('honeypot::honeypotFormFields'); ?>
                <div class="modal-body">

                    <div class="row">

                        <input type="hidden" name="ID" value="<?php echo e($item->id); ?>">

                        <div class="form-group col-lg-12">
                            <label class="form-label" for=""> <?php echo e(trans('admin.Account')); ?></label>
                            <select class="js-data-example-ajax form-control w-100 Safe" name="BankSafe_Account">
                            </select>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(trans('admin.Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(trans('admin.Pay')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>



<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/datagrid/datatables/datatables.bundle.css')); ?>">
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/summernote/summernote.css')); ?>">
<link rel="stylesheet" media="screen, print" href="<?php echo e(asset('Admin/css/formplugins/select2/select2.bundle.css')); ?>">

<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.export.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/datagrid/datatables/datatables.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/formplugins/summernote/summernote.js')); ?>"></script>
<script src="<?php echo e(asset('Admin/js/formplugins/select2/select2.bundle.js')); ?>"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>


<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }


            $('#AccountCode').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSubAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSubAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#AccountCode').empty();
                                $.each(data, function(key, value) {

                                    $('#AccountCode').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#AccountCode').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('#Bank').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllBanksAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllBanksAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Bank').empty();
                                $.each(data, function(key, value) {

                                    $('#Bank').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Bank').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });



            $('#Bene_Account').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSubAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSubAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Bene_Account').empty();
                                $.each(data, function(key, value) {

                                    $('#Bene_Account').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Bene_Account').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('.Acc').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSubAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSubAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.Acc').empty();
                                $.each(data, function(key, value) {

                                    $('.Acc').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.Acc').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('.Bn').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllBanksAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllBanksAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.Bn').empty();
                                $.each(data, function(key, value) {

                                    $('.Bn').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.Bn').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('.Safe').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSafes',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSafesJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.Safe').empty();
                                $.each(data, function(key, value) {

                                    $('.Safe').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.Safe').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });





        });
    });

</script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/limraerp/public_html/orient.limraerp.com/resources/views/admin/Accounts/IncomChecks.blade.php ENDPATH**/ ?>