<?php


use Illuminate\Support\Facades\Route;
use App\Services\ViewType;

use App\Http\Controllers\AccountReportsController;
use App\Http\Controllers\HRReportsController;
use App\Http\Controllers\NewReportController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\OwnerController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ResturantController;
use App\Http\Controllers\AccountsController;
use App\Http\Controllers\ImportExportController;
use App\Http\Controllers\FilterController;
use App\Http\Controllers\StoresController;
use App\Http\Controllers\PurchasesController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\WebsiteController;
use App\Http\Controllers\SecretariatController;
use App\Http\Controllers\CRMController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\HRController;
use App\Http\Controllers\ElectronicBillController;
use App\Http\Controllers\ManufacturingController;
use App\Http\Controllers\RoleController;
use Spatie\Permission\Models\Permission;

Route::group(['middleware' => 'firewall.all'], function () { });

Route::get('test', function () {


//    $data['name']='تقرير الفواتير المعدلة و المحذوفة';
//    $data['nameEn']='Edit and Delete Bills Report';
//    $data['guard_name']='admin';
//    $data['Main']=0;
//    $data['Parent']=3;
//   Permission::create($data);

    return back();
});


Route::get('SEED', function () {
    Artisan::call('db:seed');
    return back();
});


Route::get('CLEAR', function () {

    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    return back();

});


//
Route::get('HASHING', 'App\Http\Controllers\ElectronicBillController@HASHING');


//Welcome Page
$p= new ViewType ;
Route::get('/', [$p->controll(), $p->type()]);


//View  E-Commerce  =============================================
Route::group(['middleware' => 'ViewAuthECom'], function () {

    Route::controller(WebsiteController:: class)->group( function () {

        //ChangeCountrySession
        Route::get('ChangeCountrySession/{id}', 'ChangeCountrySession');
        Route::get('ChangeCountrySession', 'ChangeCountrySession');

        //About
        Route::get('AboutSite', 'AboutSite');

        //ContactSite
        Route::get('ContactSite', 'ContactSite');

        //PrivacyPolicySite
        Route::get('PrivacyPolicySite', 'PrivacyPolicySite');


        //TermsSite
        Route::get('TermsSite', 'TermsSite');

        //FAQSite
        Route::get('FAQSite', 'FAQSite');


        //BlogsSite
        Route::get('BlogsSite', 'BlogsSite');
        Route::get('BlogDetails/{id}', 'BlogDetails');

        //Shop Site
        Route::get('ShopSite', 'ShopSite');
        Route::get('ProductDetails/{id}', 'ProductDetails');
        Route::get('FilterShopCat/{id}', 'FilterShopCat');
        Route::get('ShopFilterBrand/{id}', 'ShopFilterBrand');
        Route::get('ShopFilterName', 'ShopFilterName');

        //PostMsgRqst
        Route::post('PostMsgRqst', 'PostMsgRqst');

        //Qty Filter
        Route::get('ProductDetails/{id}/SiteProQty', 'SiteProQty');
        Route::get('ProductDetails/{id}/SiteProQtyV', 'SiteProQtyV');
        Route::get('ProductDetails/{id}/SiteProQtyVV', 'SiteProQtyVV');

        //Cart
        Route::get('CartSite', 'CartSite');
        Route::post('AddToCart', 'AddToCart');
        Route::post('UpdateCart', 'UpdateCart');
        Route::get('DeleteCart', 'DeleteCart');

        //Cupon Code
        Route::post('UpdateCuponCode', 'UpdateCuponCode');

        //Checkout
        Route::group(['middleware' => 'CartCount:client'], function() {
            Route::get('Checkout', 'Checkout');
            Route::get('ChangeAddressSite', 'ChangeAddressSite');
        });


        //Place Order
        Route::post('PlaceOrder', 'PlaceOrder');

        //Auth Users
        Route::group(['middleware' => 'IFNotAuth:client'], function() {

            Route::get('LoginSite', 'LoginSite');
            Route::post('PostLoginSite', 'PostLoginSite');
            Route::get('ForgotSite', 'ForgotSite');
            Route::post('PostForgotSite', 'PostForgotSite');
            Route::get('RegisterSite', 'RegisterSite');
            Route::post('PostRegister', 'PostRegister');
            Route::post('PostCodeSite', 'PostCodeSite');
            Route::post('PostResetPassword', 'PostResetPassword');

        });


        //logout
        Route::get('LogoutSite', 'LogoutSite');

        // Gov and City Filter
        Route::get('GovernrateFilterr/{id}', 'GovernrateFilter');
        Route::get('CityFilterr/{id}', 'CityFilter');
        Route::get('CityShip/{id}', 'CityShip');

        //Profile
        Route::group(['middleware' => 'IFAuth:client'], function() {

            //My Account
            Route::get('MyAccountSite', 'MyAccountSite');
            Route::post('UpdateAccount', 'UpdateAccount');
            Route::post('UpdatePassword', 'UpdatePassword');
            Route::post('UpdateAddress', 'UpdateAddress');
            Route::get('DeleteMyAddress/{id}', 'DeleteMyAddress');
            Route::post('EditMyAddress', 'EditMyAddress');

            //Wishlist
            Route::get('WishlistPage', 'WishlistPage');
            Route::get('AddWish/{id}', 'AddWish');
            Route::get('DeleteWish/{id}', 'DeleteWish');

            //Compare
            Route::get('ComparePage', 'ComparePage');
            Route::get('AddCompare/{id}', 'AddCompare');
            Route::get('DeleteCompare/{id}', 'DeleteCompare');

            // Comment
            Route::post('AddComment', 'AddComment');
            Route::post('EditComment', 'EditComment');
            Route::get('DeleteComment/{id}', 'DeleteComment');

            //Rate
            Route::post('AddRate', 'AddRate');
            Route::post('EditRate', 'EditRate');

        });

// End View E-Commerce ===========================================================
    });
});



//View  Resturant  =============================================
Route::group(['middleware' => 'ViewAuthResturant'], function () {


    Route::controller(ResturantController:: class)->group( function () {
//  View Resturant ===========================================================

        // For Resturant Table
        Route::get('ScanQR', 'ScanQR');

//Post Reservations
        Route::post('AddRReservations', 'AddRReservations');

        //MenuSite
        Route::get('MenuSite', 'MenuSite');

//MenuFilter
        Route::get('MenuFilter/{id}', 'MenuFilter');


//Auth
        Route::group(['middleware' => 'IFNotAuth:client'], function() {

            Route::get('LoginResturantSite', 'LoginResturantSite');
            Route::post('PostLoginResturantSite', 'PostLoginResturantSite');
            Route::post('ForgotResturantSite', 'ForgotResturantSite');
            Route::post('PostForgoResturanttSite', 'PostForgoResturanttSite');
            Route::post('PostRegisterResturant', 'PostRegisterResturant');
            Route::post('PostResturantCodeSite', 'PostResturantCodeSite');
            Route::post('PostResturantResetPassword', 'PostResturantResetPassword');

        });


//Profile
        Route::group(['middleware' => 'IFAuth:client'], function() {

            //My Account
            Route::get('MyAccountResturantSite', 'MyAccountResturantSite');
            Route::post('UpdateAccountResturant', 'UpdateAccountResturant');
            Route::post('UpdatePasswordResturant', 'UpdatePasswordResturant');
            Route::post('UpdateAddressResturant', 'UpdateAddressResturant');
            Route::get('DeleteMyAddressResturant', 'DeleteMyAddressResturant');
            Route::post('EditMyAddressResturant', 'EditMyAddressResturant');

            //Logout
            Route::get('LogoutResturantSite', 'LogoutResturantSite');

        });


//Blogs
        Route::group(['middleware' => 'BlogsResurantUse:client'], function() {

//BlogsResturantSite
            Route::get('BlogsResturantSite', 'BlogsResturantSite');

//BlogsResturantSiteDetails
            Route::get('BlogsResturantSiteDetails/{id}', 'BlogsResturantSiteDetails');

        });


        //Reviews
        Route::group(['middleware' => 'ReviewsResurantUse:client'], function() {

//ReviewsResturantSite
            Route::get('ReviewsResturantSite', 'ReviewsResturantSite');

        });


//Gallery
        Route::group(['middleware' => 'GalleryResurantUse:client'], function() {

//GalleryResturantSite
            Route::get('GalleryResturantSite', 'GalleryResturantSite');

        });


        //Terms
        Route::group(['middleware' => 'TermsResurantUse:client'], function() {

//TermsResturantSite
            Route::get('TermsResturantSite', 'TermsResturantSite');

        });


        //Privacy
        Route::group(['middleware' => 'PrivacyResurantUse:client'], function() {

//Privacy Resturant Site
            Route::get('PrivacyResturantSite', 'PrivacyResturantSite');


        });


        //Cart
        Route::group(['middleware' => 'CartResurantUse:client'], function() {

//CartResturantSite
            Route::get('CartResturantSite', 'CartResturantSite');


//UpdateCartResturant
            Route::post('UpdateCartResturant', 'UpdateCartResturant');

//DeleteCartResturant
            Route::get('DeleteCartResturant/{id}', 'DeleteCartResturant');


//UpdateCuponCodeResturant
            Route::post('UpdateCuponCodeResturant', 'UpdateCuponCodeResturant');


//CheckoutResturantSite
            Route::get('CheckoutResturantSite', 'CheckoutResturantSite');
            Route::post('PlaceOrderResturant', 'PlaceOrderResturant');


//AddCartResturant
            Route::get('AddCartResturant', 'AddCartResturant');
            Route::get('MenuFilter/{id}/AddCartResturant', 'AddCartResturant');

//RemoveCartResturant
            Route::get('RemoveCartResturant', 'RemoveCartResturant');
            Route::get('MenuFilter/{id}/RemoveCartResturant', 'RemoveCartResturant');



        });

//  End View Resturant ===========================================================


    });


});



// === Admin Panel ===

//Language
Route::get('lang/{x}', 'App\Http\Controllers\LangController@Lang');
Route::get('ChangeLang', 'App\Http\Controllers\LangController@ChangeLang');

//Auth
Route::controller(AdminController:: class)->group( function () {

    //Guest
    Route:: get('GUESTLIST', 'GUESTLIST');
    Route:: get('GUESTLISTFilter', 'GUESTLISTFilter');


    //Re Subscribtion
    Route:: get('ReSubscribtion', 'ReSubscribtion');


    //Login and Register
    Route:: get('AdminLogin', 'LoginPage');
    Route:: post('Login', 'Login');
    Route:: get('Logout', 'Logout');
    Route:: get('forgotpassword', 'forgotpasswordPage');
    Route:: post('forgotpassword', 'forgotpassword');
    Route:: get('reset/password/{token}', 'reset_password');
    Route:: post('reset/password/{token}', 'reset_password_final');

});

Config::set('auth.defines','admin');
Route::group(['middleware' =>'Admin:admin'], function () {
    Route::group(['middleware' =>'auth:admin'], function() {




//===== Settings =========================================================================================================

        Route::group(['middleware' =>'EXPIRED:admin'], function () {
            Route::group(['middleware' => 'IFGuest:admin'], function() {



                Route::controller(SettingsController:: class)->group( function () {

                    //Truncate
                    Route:: get('Truncate', 'Truncate');



                    //Notifications
                    Route:: get('AllNotifucations', 'AllNotifucations');
                    Route:: get('ReadAllNotifucations', 'ReadAllNotifucations');
                    Route:: get('ReadNoti/{id}', 'ReadNoti');
                    Route:: get('UnReadNoti/{id}', 'UnReadNoti');
                    Route:: get('DeletNoti/{id}', 'DeletNoti');

                    //Rabih / رابح
                    Route:: get('RabihEducation', 'RabihEducation');
                    Route:: post('AddRabihEdu', 'AddRabihEdu');
                    Route:: post('EditRabihEdu/{id}', 'EditRabihEdu');
                    Route:: get('DeleteRabihEdu/{id}', 'DeleteRabihEdu');

                    Route:: get('IntroView', 'IntroView');
                    Route:: get('TermsView', 'TermsView');

                    Route:: get('ReportIssue', 'ReportIssue');
                    Route:: get('CreateNewChat', 'CreateNewChat');
                    Route:: get('SolveIssue/{id}', 'SolveIssue');
                    Route:: get('ChatIssue/{id}', 'ChatIssue');
                    Route:: post('UploadChatImg', 'UploadChatImg');
                    Route:: get('SendIssue', 'SendIssue');
                    Route:: get('ChatIssue/1/SendIssue', 'SendIssue');
                    Route:: get('ChatIssue/1/RefreshSendIssue', 'RefreshSendIssue');


                    //EmpMail
                    Route:: get('EmpMail', 'EmpMail');
                    Route:: get('EmpMailInbox', 'EmpMailInbox');
                    Route:: post('AddEmpMail', 'AddEmpMail');
                    Route:: get('DeleteEmpMail/{id}', 'DeleteEmpMail');
                    Route:: get('ReadMailInbox/{id}', 'ReadMailInbox');
                    Route:: get('UnReadMailInbox/{id}', 'UnReadMailInbox');


                    //Qr
                    Route:: get('QR', 'QRPage');
                    Route:: get('QRUpdate', 'QRUpdate');


                    //Backup  ===========================================

                    Route:: get('Backup', 'BackupPage');
                    Route:: get('GetBackup', 'GetBackup');
                    Route:: get('DeleteBackup', 'DeleteBackup');


                    //DeleteMoves
                    Route:: get('DeleteMoves', 'DeleteMoves');
                    Route:: post('PostDeleteMoves', 'PostDeleteMoves');


                    //Default_Data
                    Route:: get('Default_Data', 'Default_DataPage');
                    Route:: post('AddDefaultCompany', 'AddDefaultCompany');
                    Route:: get('AddDefaultCompanyFirst', 'AddDefaultCompanyFirst');
                    Route:: post('AddDefaultAccount', 'AddDefaultAccount');
                    Route:: get('AddDefaultAccountsFirst', 'AddDefaultAccountsFirst');
                    Route:: post('AddDefaultStore', 'AddDefaultStore');
                    Route:: get('AddDefaultStoreFirst', 'AddDefaultStoreFirst');
                    Route:: post('AddDefaultCrm', 'AddDefaultCrm');
                    Route:: get('AddDefaultCrmFirst', 'AddDefaultCrmFirst');
                    Route:: post('AddDefaultPurchases', 'AddDefaultPurchases');
                    Route:: get('AddDefaultPurchasesFirst', 'AddDefaultPurchasesFirst');
                    Route:: post('AddDefaultSales', 'AddDefaultSales');
                    Route:: get('AddDefaultSalesFirst', 'AddDefaultSalesFirst');
                    Route:: post('AddDefaultShowHide', 'AddDefaultShowHide');
                    Route:: get('AddDefaultShowHideFirst', 'AddDefaultShowHideFirst');
                    Route:: post('AddDefaultMaintaince', 'AddDefaultMaintaince');
                    Route:: get('AddDefaultMaintainceFirst', 'AddDefaultMaintainceFirst');
                    Route:: post('AddDefaultManufacture', 'AddDefaultManufacture');
                    Route:: get('AddDefaultManufactureFirst', 'AddDefaultManufactureFirst');
                    Route:: post('AddDefaultShipping', 'AddDefaultShipping');
                    Route:: get('AddDefaultShippingFirst', 'AddDefaultShippingFirst');
                    Route:: post('AddDefaultCustomPrint', 'AddDefaultCustomPrint');
                    Route:: get('AddDefaultCustomPrintFirst', 'AddDefaultCustomPrintFirst');


                    //Modules_Settings
                    Route:: get('Modules_Settings', 'Modules_SettingsPage');
                    Route:: get('AddDefaultModulesFirst', 'AddDefaultModulesFirst');
                    Route:: get('AddDefaultModulesNumFirst', 'AddDefaultModulesNumFirst');
                    Route:: post('AddDefaultIntro', 'AddDefaultIntro');
                    Route:: get('AddDefaultIntroFirst', 'AddDefaultIntroFirst');
                    Route:: post('AddDefaultModules', 'AddDefaultModules');
                    Route:: post('AddDefaultModulesNum', 'AddDefaultModulesNum');
                    Route:: post('AddDefaultReportSettings', 'AddDefaultReportSettings');
                    Route:: get('AddDefaultReportSettingsFirst', 'AddDefaultReportSettingsFirst');
                    Route:: post('AddDefaultPackagesSettings', 'AddDefaultPackagesSettings');
                    Route:: get('DeletePackage/{id}', 'DeletePackage');


                    //Translate
                    Route:: get('Translate', 'TranslatePage');
                    Route:: post('AddTranslate', 'AddTranslate');
                    Route:: post('EditTranslate/{id}', 'EditTranslate');
                    Route:: get('DeleteTranslate/{id}', 'DeleteTranslate');


                    //LoginSlider
                    Route:: get('LoginSlider', 'LoginSlider');
                    Route:: post('AddLoginSlider', 'AddLoginSlider');
                    Route:: post('EditLoginSlider/{id}', 'EditLoginSlider');
                    Route:: get('DeleteLoginSlider/{id}', 'DeleteLoginSlider');


                    //Domain_Regstration
                    Route:: get('Domain_Regstration', 'Domain_Regstration');
                    Route:: get('Updates', 'Updates');
                    Route:: post('NewUpdateMigration', 'NewUpdateMigration');
                    Route:: post('NewUpdateSeeders', 'NewUpdateSeeders');
                    Route:: post('AddDomain_Regstration', 'AddDomain_Regstration');
                    Route:: get('DeleteDomain_Regstration/{id}', 'DeleteDomain_Regstration');



                    //StoresQty
                    Route:: get('StoresQty', 'StoresQtyPage');
                    Route:: get('StoresQtyFilter', 'StoresQtyFilter');
                    Route:: get('ChangeStroeQty', 'ChangeStroeQty');
                    Route:: get('DeleteStoreQty/{id}', 'DeleteStoreQty');


                });



                Route::controller(AdminController:: class)->group( function () {

                    //Guest List
                    Route:: get('GUESTLIST', 'GUESTLIST');


                    //Top Menu
                    Route:: get('KlarAdmin', 'KlarAdmin');
                    Route:: get('BriefsAdmin', 'BriefsAdmin');
                    Route:: get('StatisticsTotal', 'StatisticsTotal');
                    Route:: get('StatisticsGraph', 'StatisticsGraph');
                    Route:: get('CalendarMeet', 'CalendarMeet');
                    Route:: get('SendMails', 'SendMails');
                    Route:: post('PostSendMails', 'PostSendMails');


                    //Profile
                    Route:: get('Profile', 'Profile');
                    Route:: post('UpdateAdminProfile/{id?}', 'UpdateAdminProfile');

                    //Admins
                    Route:: get('Admins', 'AdminsPage');
                    Route:: post('AddAdmin', 'AddAdmin');
                    Route:: post('EditAdmin/{id}', 'EditAdmin');
                    Route:: get('DeleteAdmin/{id}', 'DeleteAdmin');
                    Route:: get('UnHide/{id}', 'UnHide');
                    Route:: get('Hide/{id}', 'Hide');


                    Route::group(['middleware' => 'IFNotGuest:admin'], function() {

                        //GusetListPrice
                        Route:: get('GusetListPrice', 'GusetListPrice');
                        Route:: get('PriceListFilter', 'PriceListFilter');

                    });



                });



                Route::controller(RoleController:: class)->group( function () {

                    //User Premations
                    Route:: get('AdminsPremations', 'AdminsPremationsPage');
                    Route:: post('AddPrem', 'AddPrem');
                    Route:: post('EditPrem/{id}', 'EditPrem');
                    Route:: get('DeletePrem/{id}', 'DeletePrem');


                });



                // === Owner Reports ========================================================================================================

                Route::controller(OwnerController:: class)->group( function () {



                    //User Log
                    Route:: get('UserLog', 'UserLogPage');
                    Route:: get('UserLogFilter', 'UserLogFilter');


                    //EmpLocations
                    Route:: get('EmpLocations', 'EmpLocationsPage');

                    //Orders
                    Route:: get('Orders', 'OrdersPage');
                    Route:: get('PendingSales/{id}', 'PendingSales');
                    Route:: get('RecivedShipCompSales/{id}', 'RecivedShipCompSales');
                    Route:: get('RecivedClientSales/{id}', 'RecivedClientSales');
                    Route:: get('PendingPurch/{id}', 'PendingPurch');
                    Route:: get('RecivedShipCompPurch/{id}', 'RecivedShipCompPurch');
                    Route:: get('RecivedClientPurch/{id}', 'RecivedClientPurch');

                });
// === End Owner Reports ===================================================================================================




                //Filters ====================================================================================

                Route::controller(FilterController:: class)->group( function () {



                    // ============ . Customers ==================
                    Route:: get('AllCustomers', 'AllCustomers');
                    Route:: get('AllCustomersJ/{id}', 'AllCustomersJ');
                    Route:: get('AllCustomersJPhone/{id}', 'AllCustomersJPhone');

                    //==
                    Route:: get('AllClientsFilter', 'AllClientsFilter');

                    Route:: get('TicketEdit/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('EditReciptMaintaince/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('HoldSale/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('ESBill/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('TransferToSalesSO/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('TransferToSalesExchange/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('EditQuote/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('TransferToSalesExchange/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('EditSalesOrder/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('EditSalesGifts/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('EditQuoteImages/AllClientsFilter', 'AllClientsFilter');


                    Route:: get('FollowListSat/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('FollowListSun/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('FollowListMon/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('FollowListTue/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('FollowListWed/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('FollowListThr/AllClientsFilter', 'AllClientsFilter');
                    Route:: get('FollowListFri/AllClientsFilter', 'AllClientsFilter');

                    //==


                    Route:: get('AllClientsJ/{id}', 'AllClientsJ');
                    Route:: get('TicketEdit/1/AllClientsJ/{id}', 'AllClientsJ');

                    //===

                    Route:: get('AllClientsJPhone/{id}', 'AllClientsJPhone');
                    Route:: get('TicketEdit/1/AllClientsJPhone/{id}', 'AllClientsJPhone');

                    //==
                    Route:: get('AllClientsFilterJ/{id}', 'AllClientsFilterJ');

                    //===
                    Route:: get('AllClientsFilterJS/{id}', 'AllClientsFilterJS');

                    Route:: get('EditReciptMaintaince/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('TransferToSalesSO/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('TransferToSalesExchange/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('HoldSale/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('EditQuote/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('EditSalesOrder/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('ESBill/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('TransferToSalesExchange/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('TicketEdit/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('EditQuoteImages/AllClientsFilterJS/{id}', 'AllClientsFilterJS');


                    Route:: get('FollowListSat/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('FollowListSun/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('FollowListMon/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('FollowListTue/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('FollowListWed/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('FollowListThr/AllClientsFilterJS/{id}', 'AllClientsFilterJS');
                    Route:: get('FollowListFri/AllClientsFilterJS/{id}', 'AllClientsFilterJS');


                    //==
                    Route:: get('AllCli', 'AllCli');
                    Route:: get('AllCliJ/{id}', 'AllCliJ');


                    // ========== Vendors ================
                    Route:: get('AllVendors', 'AllVendors');

                    Route:: get('EditPurchasesOrder/AllVendors', 'AllVendors');
                    Route:: get('TransferToPurchases/AllVendors', 'AllVendors');
                    Route:: get('TransferToPurchasesRecived/AllVendors', 'AllVendors');
                    Route:: get('EditPuechasesBill/AllVendors', 'AllVendors');

                    //==
                    Route:: get('AllVend', 'AllVend');
                    Route:: get('AllVendJ/{id}', 'AllVendJ');


                    //===
                    Route:: get('AllVendorsJ/{id}', 'AllVendorsJ');

                    Route:: get('TransferToPurchases/AllVendorsJ/{id}', 'AllVendorsJ');
                    Route:: get('TransferToPurchasesRecived/AllVendorsJ/{id}', 'AllVendorsJ');
                    //===

                    Route:: get('AllVendorsJS/{id}', 'AllVendorsJS');

                    Route:: get('TransferToPurchases/AllVendorsJS/{id}', 'AllVendorsJS');
                    Route:: get('TransferToPurchasesRecived/AllVendorsJS/{id}', 'AllVendorsJS');
                    Route:: get('EditPurchasesOrder/AllVendorsJS/{id}', 'AllVendorsJS');
                    Route:: get('EditPuechasesBill/AllVendorsJS/{id}', 'AllVendorsJS');
                    //===
                    Route:: get('AllSubAccountsMwrden', 'AllSubAccountsMwrden');
                    Route:: get('HoldSale/AllSubAccountsMwrden', 'AllSubAccountsMwrden');

                    Route:: get('AllSubAccountsMwrdenJ/{id}', 'AllSubAccountsMwrdenJ');
                    Route:: get('HoldSale/AllSubAccountsMwrdenJ/{id}', 'AllSubAccountsMwrdenJ');

                    //===



                    // ========== Coins ================
                    Route:: get('AllCoins', 'AllCoins');
                    Route:: get('AllCoinsJ/{id}', 'AllCoinsJ');

                    // ========== Costs Center ================
                    Route:: get('AllCostss', 'AllCostss');
                    Route:: get('AllCostssJ/{id}', 'AllCostssJ');


                    // ========== Accounts ================

                    //All
                    Route:: get('AllAccounts', 'AllAccounts');

                    //Main
                    Route:: get('AllMainAccounts', 'AllMainAccounts');
                    Route:: get('MainAccountss/{id}', 'MainAccountss');



                    //Safes and Banks

                    Route:: get('AllBanksAccounts', 'AllBanksAccounts');
                    Route:: get('AllBanksAccountsJ/{id}', 'AllBanksAccountsJ');

                    Route:: get('AllSafes', 'AllSafes');

                    Route:: get('TransferSureSafe/AllSafes', 'AllSafes');
                    Route:: get('EditSafeTransfer/AllSafes', 'AllSafes');
                    Route:: get('EditPayment_Voucher/AllSafes', 'AllSafes');
                    Route:: get('EditReceipt_Voucher/AllSafes', 'AllSafes');
                    //==
                    Route:: get('AllSafesJ/{id}', 'AllSafesJ');

                    Route:: get('TransferSureSafe/AllSafesJ/{id}', 'AllSafesJ');
                    Route:: get('EditSafeTransfer/AllSafesJ/{id}', 'AllSafesJ');
                    Route:: get('EditPayment_Voucher/AllSafesJ/{id}', 'AllSafesJ');
                    Route:: get('EditReceipt_Voucher/AllSafesJ/{id}', 'AllSafesJ');


                    //Sup Accounts
                    Route:: get('AllSubAccounts', 'AllSubAccounts');

                    Route:: get('HoldSale/AllSubAccounts', 'AllSubAccounts');
                    Route:: get('EditInvntory/AllSubAccounts', 'AllSubAccounts');
                    Route:: get('SettlementInvntory/AllSubAccounts', 'AllSubAccounts');
                    Route:: get('EditJournalizing/AllSubAccounts', 'AllSubAccounts');
                    Route:: get('EditPayment_Voucher/AllSubAccounts', 'AllSubAccounts');
                    Route:: get('EditReceipt_Voucher/AllSubAccounts', 'AllSubAccounts');
                    Route:: get('EditOpening_Entries/AllSubAccounts', 'AllSubAccounts');
                    //===
                    Route:: get('AllSubAccountsJ/{id}', 'AllSubAccountsJ');

                    Route:: get('HoldSale/AllSubAccountsJ/{id}', 'AllSubAccountsJ');
                    Route:: get('EditJournalizing/AllSubAccountsJ/{id}', 'AllSubAccountsJ');
                    Route:: get('EditPayment_Voucher/AllSubAccountsJ/{id}', 'AllSubAccountsJ');
                    Route:: get('EditReceipt_Voucher/AllSubAccountsJ/{id}', 'AllSubAccountsJ');
                    Route:: get('EditOpening_Entries/AllSubAccountsJ/{id}', 'AllSubAccountsJ');
                    Route:: get('EditInvntory/AllSubAccountsJ/{id}', 'AllSubAccountsJ');
                    Route:: get('SettlementInvntory/AllSubAccountsJ/{id}', 'AllSubAccountsJ');
                    //==

                    //Masrofat
                    Route:: get('AllSubAccountsMsrofat', 'AllSubAccountsMsrofat');
                    Route:: get('AllSubAccountsMsrofatJ/{id}', 'AllSubAccountsMsrofatJ');
                    Route:: get('HoldSale/AllSubAccountsMsrofat/{id}', 'AllSubAccountsMsrofat');
                    Route:: get('HoldSale/AllSubAccountsMsrofatJ/{id}', 'AllSubAccountsMsrofatJ');
                    //======

                    //Admins or Users
                    Route:: get('AllUsers', 'AllUsers');
                    Route:: get('AllUsersJ/{id}', 'AllUsersJ');


                    //Safe Balance and Credit

                    Route:: get('SafeBalanceFilter/{id}', 'SafeBalanceFilter');

                    Route:: get('TransferToPurchases/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('TransferToPurchasesRecived/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('ReturnSales/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('EditPayment_Voucher/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('EditReceipt_Voucher/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('TransferSureSafe/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('EditSafeTransfer/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('SurePayment_Voucher/SafeBalanceFilter/{id}', 'SafeBalanceFilter');
                    Route:: get('SureReceipt_Voucher/SafeBalanceFilter/{id}', 'SafeBalanceFilter');


                    //Account Name
                    Route:: get('AccountNameFilter/{id}', 'AccountNameFilter');

                    Route:: get('EditPayment_Voucher/AccountNameFilter/{id}', 'AccountNameFilter');
                    Route:: get('EditReceipt_Voucher/AccountNameFilter/{id}', 'AccountNameFilter');
                    Route:: get('EditJournalizing/AccountNameFilter/{id}', 'AccountNameFilter');
                    Route:: get('EditOpening_Entries/AccountNameFilter/{id}', 'AccountNameFilter');


                    // ========= . Employees ===============

                    Route:: get('AllEmps', 'AllEmps');

                    Route:: get('EditAttendance/AllEmps', 'AllEmps');
                    Route:: get('HoldSale/AllEmps', 'AllEmps');
                    Route:: get('ESBill/AllEmps', 'AllEmps');
                    Route:: get('EditQuote/AllEmps', 'AllEmps');
                    Route:: get('EditSalesOrder/AllEmps', 'AllEmps');
                    //===

                    Route:: get('AllEmpsJ/{id}', 'AllEmpsJ');

                    Route:: get('EditAttendance/AllEmpsJ/{id}', 'AllEmpsJ');
                    Route:: get('HoldSale/AllEmpsJ/{id}', 'AllEmpsJ');
                    Route:: get('ESBill/AllEmpsJ/{id}', 'AllEmpsJ');
                    Route:: get('EditQuote/AllEmpsJ/{id}', 'AllEmpsJ');
                    Route:: get('EditSalesOrder/AllEmpsJ/{id}', 'AllEmpsJ');

                    //===


                    // ========= . Ships ===============

                    Route:: get('AllShips', 'AllShips');
                    Route:: get('AllShipsJ/{id}', 'AllShipsJ');


                    // ========= . Account Balance ===============

                    Route:: get('AccountBalanceFilter/{id}', 'AccountBalanceFilter');

                    Route:: get('PurchPrint/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('TransferToPurchases/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('TransferToPurchasesRecived/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('PurchOrdPrint/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('QuotePrint/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('SalesOrderPrint/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('SalesPrint/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('SalesPrint8/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('SalesPrint5/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('HoldSale/AccountBalanceFilter/{id}', 'AccountBalanceFilter');


                    // Assets  Account ==========

                    Route:: get('AllMainAssetsAccounts', 'AllMainAssetsAccounts');
                    Route:: get('AllMainAssetsAccountsJ/{id}', 'AllMainAssetsAccountsJ');
                    Route:: get('AllAccountsExpenses', 'AllAccountsExpenses');
                    Route:: get('AllAccountsExpensesJ/{id}', 'AllAccountsExpensesJ');
                    Route:: get('AllAccountsComplex', 'AllAccountsComplex');
                    Route:: get('AllAccountsComplexJ/{id}', 'AllAccountsComplexJ');



                });


                //End Filters ====================================================================================



//==== End Settings =======================================================================================================


//=====  Accounts ==========================================================================================================

                Route::controller(AccountsController:: class)->group( function () {

                    //Accounting Manual
                    Route:: get('AccountingManual', 'AccountingManualPage');
                    Route:: post('AddAccount', 'AddAccount');
                    Route:: post('EditAccount', 'EditAccount');
                    Route:: get('DeleteAccount', 'DeleteAccount');
                    Route:: get('SupAccountFilter', 'SupAccountFilter');
                    Route:: get('EditAccountFilter', 'EditAccountFilter');


                    //Cost Centers
                    Route:: get('CostCenters', 'CostCentersPage');
                    Route:: post('AddCostCenters', 'AddCostCenters');
                    Route:: post('EditCostCenters/{id}', 'EditCostCenters');
                    Route:: get('DeleteCostCenters/{id}', 'DeleteCostCenters');

                    //Coins
                    Route:: get('Coins', 'CoinsPage');
                    Route:: post('AddCoins', 'AddCoins');
                    Route:: post('EditCoins/{id}', 'EditCoins');
                    Route:: get('DeleteCoins/{id}', 'DeleteCoins');

                    //Checks_Type
                    Route:: get('Checks_Type', 'Checks_TypePage');
                    Route:: post('AddChecks_Type', 'AddChecks_Type');
                    Route:: post('EditChecks_Type/{id}', 'EditChecks_Type');
                    Route:: get('DeleteChecks_Type/{id}', 'DeleteChecks_Type');

                    //Branches
                    Route:: get('Branches', 'BranchesPage');
                    Route:: post('AddBranches', 'AddBranches');
                    Route:: post('EditBranches/{id}', 'EditBranches');
                    Route:: get('DeleteBranches/{id}', 'DeleteBranches');

                    //Safes and Banks
                    Route:: get('Safes_Banks', 'Safes_BanksPage');
                    Route:: post('AddSafes_Banks', 'AddSafes_Banks');
                    Route:: post('EditSafes_Banks/{id}', 'EditSafes_Banks');
                    Route:: get('DeleteSafes_Banks/{id}', 'DeleteSafes_Banks');

                    //Taxes
                    Route:: get('Taxes', 'TaxesPage');
                    Route:: post('AddTaxes', 'AddTaxes');
                    Route:: post('EditTaxes/{id}', 'EditTaxes');
                    Route:: get('DeleteTaxes/{id}', 'DeleteTaxes');


                    //Journalizing
                    Route:: get('Journalizing', 'JournalizingPage');
                    Route:: get('JournalizingSechdule', 'JournalizingSechdule');
                    Route:: get('JournalizingSechduleFilter', 'JournalizingSechduleFilter');
                    Route:: post('AddJournalizing', 'AddJournalizing');
                    Route:: get('EditJournalizing/{id}', 'EditJournalizing');
                    Route:: get('DeleteJournalizing/{id}', 'DeleteJournalizing');
                    Route:: get('JournalizingPrint/{id}', 'JournalizingPrint');
                    Route:: get('SureJournalizing/{id}', 'SureJournalizing');
                    Route:: post('PostSureJournalizing', 'PostSureJournalizing');
                    Route:: post('PostEditJournalizing', 'PostEditJournalizing');

                    //Opening Entries
                    Route:: get('OpeningEntries', 'OpeningEntriesPage');
                    Route:: get('Opening_EntriesSechdule', 'Opening_EntriesSechdule');
                    Route:: get('OpeningEntriesSechduleFilter', 'OpeningEntriesSechduleFilter');
                    Route:: get('EditOpening_Entries/{id}', 'EditOpening_Entries');
                    Route:: get('DeleteOpening_Entries/{id}', 'DeleteOpening_Entries');
                    Route:: post('AddOpeningEntries', 'AddOpeningEntries');
                    Route:: get('Opening_EntriesPrint/{id}', 'Opening_EntriesPrint');
                    Route:: get('SureOpening_Entries/{id}', 'SureOpening_Entries');
                    Route:: post('PostSureOpeningEntries', 'PostSureOpeningEntries');
                    Route:: post('PostEditOpeningEntries', 'PostEditOpeningEntries');


                    //Receipt Voucher
                    Route:: get('Receipt_Voucher', 'Receipt_VoucherPage');
                    Route:: get('ReceiptVoucherSechduleFilter', 'ReceiptVoucherSechduleFilter');
                    Route:: get('Receipt_VoucherPrint/{id}', 'Receipt_VoucherPrint');
                    Route:: get('SureReceipt_Voucher/{id}', 'SureReceipt_Voucher');
                    Route:: get('Receipt_VoucherSechdule', 'Receipt_VoucherSechdule');
                    Route:: get('EditReceipt_Voucher/{id}', 'EditReceipt_Voucher');
                    Route:: get('DeleteReceipt_Voucher/{id}', 'DeleteReceipt_Voucher');
                    Route:: post('PostEditReceipt_Voucher', 'PostEditReceipt_Voucher');
                    Route:: post('AddReceipt_Voucher', 'AddReceipt_Voucher');
                    Route:: post('PostSureReceipt_Voucher', 'PostSureReceipt_Voucher');


                    //Payment Voucher
                    Route:: get('Payment_Voucher', 'Payment_VoucherPage');
                    Route:: get('PaymentVoucherSechduleFilter', 'PaymentVoucherSechduleFilter');
                    Route:: get('Payment_VoucherPrint/{id}', 'Payment_VoucherPrint');
                    Route:: get('SurePayment_Voucher/{id}', 'SurePayment_Voucher');
                    Route:: get('Payment_VoucherSechdule', 'Payment_VoucherSechdule');
                    Route:: get('EditPayment_Voucher/{id}', 'EditPayment_Voucher');
                    Route:: get('DeletePayment_Voucher/{id}', 'DeletePayment_Voucher');
                    Route:: post('PostEditPayment_Voucher', 'PostEditPayment_Voucher');
                    Route:: post('AddPayment_Voucher', 'AddPayment_Voucher');
                    Route:: post('PostSurePayment_Voucher', 'PostSurePayment_Voucher');


                    //Exporting Checks
                    Route:: get('Exporting_Checks', 'Exporting_ChecksPage');
                    Route:: get('ExportingChecksSechduleFilter', 'ExportingChecksSechduleFilter');
                    Route:: post('AddExporting_Checks', 'AddExporting_Checks');
                    Route:: post('EditExporting_Checks/{id}', 'EditExporting_Checks');
                    Route:: post('ReasonExportChecks', 'ReasonExportChecks');
                    Route:: post('TransExportingChecks', 'TransExportingChecks');
                    Route:: get('DeleteExportingChecks/{id}', 'DeleteExportingChecks');
                    Route:: get('PrintOutcomChecks/{id}', 'PrintOutcomChecks');
                    Route:: post('PayExportingChecks', 'PayExportingChecks');

                    //Incoming Checks
                    Route:: get('Incoming_checks', 'Incoming_checksPage');
                    Route:: get('IncomingchecksSechduleFilter', 'IncomingchecksSechduleFilter');
                    Route:: post('AddIncoming_checks', 'AddIncoming_checks');
                    Route:: post('EditIncoming_checks/{id}', 'EditIncoming_checks');
                    Route:: post('ReasonIncoming_checks', 'ReasonIncoming_checks');
                    Route:: post('TransIncoming_checks', 'TransIncoming_checks');
                    Route:: get('DeleteIncoming_checks/{id}', 'DeleteIncoming_checks');
                    Route:: get('PrintIncomChecks/{id}', 'PrintIncomChecks');
                    Route:: post('PayIncomingChecks', 'PayIncomingChecks');

                    //Insurance Paper
                    Route:: get('Insurance_Paper', 'Insurance_PaperPage');
                    Route:: get('InsurancePaperSechduleFilter', 'InsurancePaperSechduleFilter');
                    Route:: post('AddInsurancePaper', 'AddInsurancePaper');
                    Route:: get('DeleteInsurancePaper/{id}', 'DeleteInsurancePaper');
                    Route:: post('RecivedInurance/{id}', 'RecivedInurance');

                    //Insurance Paper
                    Route:: get('SafesTransfer', 'SafesTransferPage');
                    Route:: get('TransferSureSafe/{id}', 'TransferSureSafe');
                    Route:: get('RefusedSafeTransfer/{id}', 'RefusedSafeTransfer');
                    Route:: get('EditSafeTransfer/{id}', 'EditSafeTransfer');
                    Route:: post('AddSafeTransfer', 'AddSafeTransfer');
                    Route:: post('SureSafeTransfer/{id}', 'SureSafeTransfer');
                    Route:: post('PostEditSafeTransfer/{id}', 'PostEditSafeTransfer');
                    Route:: get('SafesTransferSechdule', 'SafesTransferSechdulePage');
                    Route:: get('TransSafePrint/{id}', 'TransSafePrint');

                    //Assets
                    Route:: get('Assets', 'AssetsPage');
                    Route:: get('AssetsSechduleFilter', 'AssetsSechduleFilter');
                    Route:: post('AddAssets', 'AddAssets');
                    Route:: post('AssetSale', 'AssetSale');
                    Route:: get('DeleteAssets/{id}', 'DeleteAssets');

                    //Assets Expenses
                    Route:: get('AssetExpenses', 'AssetExpensesPage');
                    Route:: post('AddAssetsExpenses', 'AddAssetsExpenses');



                    //Investors
                    Route:: get('Investors', 'Investors');
                    Route:: post('AddInvestors', 'AddInvestors');
                    Route:: get('DeleteInvestors/{id}', 'DeleteInvestors');
                    Route:: get('EndInvestors/{id}', 'EndInvestors');
                    Route:: post('MoreValueInvestors/{id}', 'MoreValueInvestors');



                    //Partners
                    Route:: get('Partners', 'PartnersPage');
                    Route:: post('AddPartner', 'AddPartner');
                    Route:: get('DeletePartner/{id}', 'DeletePartner');

                    //Capital
                    Route:: get('Capital', 'CapitalPage');
                    Route:: post('AddCapital', 'AddCapital');
                    Route:: post('AddCapitalIncrease', 'AddCapitalIncrease');
                    Route:: get('DeleteCapitalIncrease/{id}', 'DeleteCapitalIncrease');

                    //OrderPay
                    Route:: get('Order_PaySechdule', 'Order_PaySechdule');
                    Route:: get('Order_Pay', 'Order_Pay');
                    Route:: post('AddOrder_Pay', 'AddOrder_Pay');
                    Route:: get('EditOrder_Pay/{id}', 'EditOrder_Pay');
                    Route:: post('PostEditOrder_Pay/{id}', 'PostEditOrder_Pay');
                    Route:: get('DeleteOrder_Pay/{id}', 'DeleteOrder_Pay');
                    Route:: get('DoneOrder_Pay/{id}', 'DoneOrder_Pay');
                    Route:: get('PrintOrder_Pay/{id}', 'PrintOrder_Pay');


                    //Spend_Profits
                    Route:: get('Spend_Profits', 'Spend_ProfitsPage');
                    Route:: get('PartnerFilter/{id}', 'PartnerFilter');
                    Route:: get('PrintSpendProfits/{id}', 'PrintSpendProfits');
                    Route:: post('AddSpendProfit', 'AddSpendProfit');

                    //CapitalReport
                    Route:: get('CapitalReport', 'CapitalReport');


                });


//==== End Accounts ==========================================================================================================


//=====  Accounts Reports  =================================================================================================

                Route::controller(AccountReportsController:: class)->group( function () {

                    //General_Daily
                    Route:: get('General_Daily', 'General_DailyPage');
                    Route:: get('GenralDailyFilter', 'GenralDailyFilter');
                    Route:: get('GenralDailyFilterBond', 'GenralDailyFilterBond');
                    Route:: get('GeneralDailyFilterTwo', 'GeneralDailyFilterTwo');


                    //Trial_Balance
                    Route:: get('Trial_Balance', 'Trial_BalancePage');
                    Route:: get('FilterTrial_Balance', 'FilterTrial_Balance');
                    Route:: get('TrialBalanceFilterTwo', 'TrialBalanceFilterTwo');

                    //Account_Balances
                    Route:: get('Account_Balances', 'Account_BalancesPage');
                    Route:: get('FilterAccount_Balances', 'FilterAccount_Balances');
                    Route:: get('AccountBalancesFilterTwo', 'AccountBalancesFilterTwo');


                    //Ledger
                    Route:: get('Ledger', 'LedgerPage');
                    Route:: get('FilterLedger', 'FilterLedger');
                    Route:: post('FilterPrintLedger', 'FilterPrintLedger');
                    Route:: get('LedgerFilterTwo', 'LedgerFilterTwo');

                    //Safe_Bank_Statement
                    Route:: get('Safe_Bank_Statement', 'Safe_Bank_StatementPage');
                    Route:: get('FilterSafe_Bank_Statement', 'FilterSafe_Bank_Statement');
                    Route:: get('SafeBankStatementFilterTwo', 'SafeBankStatementFilterTwo');

                    //Customer_Balances
                    Route:: get('Customer_Balances', 'Customer_BalancesPage');
                    Route:: get('FilterCustomer_Balances', 'FilterCustomer_Balances');
                    Route:: get('CustomerBalancesFilterTwo', 'CustomerBalancesFilterTwo');

                    //Vendor_Account_Statement
                    Route:: get('Vendor_Account_Statement', 'Vendor_Account_StatementPage');
                    Route:: get('FilterVendor_Account_Statement', 'FilterVendor_Account_Statement');
                    Route:: get('VendorAccountStatementFilterTwo', 'VendorAccountStatementFilterTwo');

                    //Customer_Account_Statement
                    Route:: get('Customer_Account_Statement', 'Customer_Account_StatementPage');
                    Route:: get('FilterCustomer_Account_Statement', 'FilterCustomer_Account_Statement');
                    Route:: get('CustomerAccountStatementFilterTwo', 'CustomerAccountStatementFilterTwo');

                    //Cost_Centers_Report
                    Route:: get('Cost_Centers_Report', 'Cost_Centers_ReportPage');
                    Route:: get('Cost_Centers_ReportFilter', 'Cost_Centers_ReportFilter');


                    //Checks_Reports
                    Route:: get('Checks_Reports', 'Checks_ReportsPage');
                    Route:: get('Checks_ReportsFilter', 'Checks_ReportsFilter');
                    Route:: get('ChecksReportsFilterTwo', 'ChecksReportsFilterTwo');

                    //InsurancePaperReport
                    Route:: get('InsurancePaperReport', 'InsurancePaperReport');
                    Route:: get('InsurancePaperReportFilter', 'InsurancePaperReportFilter');


                    //Incom_List
                    Route:: get('Incom_List', 'Incom_ListPage');
                    Route:: get('FilterIncom_ListNew', 'FilterIncom_ListNew');
                    Route:: get('FilterIncom_ListErydat', 'FilterIncom_ListErydat');
                    Route:: get('FilterIncom_ListTaklfa', 'FilterIncom_ListTaklfa');
                    Route:: get('FilterIncom_ListMasrofat', 'FilterIncom_ListMasrofat');

                    //Financial_Center
                    Route:: get('Financial_Center', 'Financial_CenterPage');
                    Route:: get('FilterFinancial_CenterNew', 'FilterFinancial_CenterNew');
                    Route:: get('FilterFinancial_CenterAsoul', 'FilterFinancial_CenterAsoul');
                    Route:: get('FilterFinancial_CenterKhsoum', 'FilterFinancial_CenterKhsoum');
                    Route:: get('FilterFinancial_CenterHkook', 'FilterFinancial_CenterHkook');

                    //Safes_Balances
                    Route:: get('Safes_Balances', 'Safes_BalancesPage');
                    Route:: get('FilterSafes_Balances', 'FilterSafes_Balances');

//Fixed_Assets_Report
                    Route:: get('Fixed_Assets_Report', 'Fixed_Assets_Report');
                    Route:: get('Fixed_Assets_ReportFilterTwo', 'Fixed_Assets_ReportFilterTwo');

//TotalCollectorDepaitor
                    Route:: get('TotalCollectorDepaitor', 'TotalCollectorDepaitor');
                    Route:: get('TotalCollectorDepaitorFilterTwo', 'TotalCollectorDepaitorFilterTwo');


//CustomerDebtRestructuring
                    Route:: get('CustomerDebtRestructuring', 'CustomerDebtRestructuring');
                    Route:: get('CustomerDebtRestructuringFilter', 'CustomerDebtRestructuringFilter');
//VendorDebtRestructuring
                    Route:: get('VendorDebtRestructuring', 'VendorDebtRestructuring');
                    Route:: get('VendorDebtRestructuringFilter', 'VendorDebtRestructuringFilter');
//VendorsBalancesReport
                    Route:: get('VendorsBalancesReport', 'VendorsBalancesReport');
                    Route:: get('VendorsBalancesReportFilterTwo', 'VendorsBalancesReportFilterTwo');


                });


//==== End Accounts Reports=================================================================================================


// === Stores (Supplay Chain) ========================================================================================================

                Route::controller(StoresController:: class)->group( function () {

                    //Stores
                    Route:: get('Stores', 'StoresPage');
                    Route:: post('AddStores', 'AddStores');
                    Route:: post('EditStores/{id}', 'EditStores');
                    Route:: get('DeleteStores/{id}', 'DeleteStores');

                    //Measurement_Units
                    Route:: get('Measurement_Units', 'Measurement_UnitsPage');
                    Route:: post('AddMeasurement_Units', 'AddMeasurement_Units');
                    Route:: post('EditMeasurement_Units/{id}', 'EditMeasurement_Units');
                    Route:: get('DeleteMeasurement_Units/{id}', 'DeleteMeasurement_Units');

                    //Manufacture
                    Route:: get('Manufacture', 'ManufacturePage');
                    Route:: post('AddManufacture', 'AddManufacture');
                    Route:: post('EditManufacture/{id}', 'EditManufacture');
                    Route:: get('DeleteManufacture/{id}', 'DeleteManufacture');

                    //Virables
                    Route:: get('Virables', 'VirablesPage');
                    Route:: post('AddVirables', 'AddVirables');
                    Route:: post('EditVirables/{id}', 'EditVirables');
                    Route:: get('DeleteVirables/{id}', 'DeleteVirables');

                    //Sub_Virables
                    Route:: get('Sub_Virables/{id}', 'Sub_VirablesPage');
                    Route:: post('AddSub_Virables', 'AddSub_Virables');
                    Route:: post('EditSub_Virables/{id}', 'EditSub_Virables');
                    Route:: get('DeleteSub_Virables/{id}', 'DeleteSub_Virables');


                    //SubscribeTypes
                    Route:: get('SubscribeTypes', 'SubscribeTypesPage');
                    Route:: post('AddSubscribeTypes', 'AddSubscribeTypes');
                    Route:: post('EditSubscribeTypes/{id}', 'EditSubscribeTypes');
                    Route:: get('DeleteSubscribeTypes/{id}', 'DeleteSubscribeTypes');

                    //Items_Groups
                    Route:: get('Items_Groups', 'Items_GroupsPage');
                    Route:: get('SupGroubsFilter', 'SupGroubsFilter');
                    Route:: post('AddItems_Groups', 'AddItems_Groups');
                    Route:: post('EditItems_Groups', 'EditItems_Groups');
                    Route:: get('DeleteItems_Groups', 'DeleteItems_Groups');
                    Route:: get('EditGroubsFilter', 'EditGroubsFilter');

                    //barcode settings
                    Route:: get('BarcodeـPrinting_Settings', 'BarcodeـPrinting_SettingsPage');
                    Route:: post('AddBaPriSett', 'AddBaPriSett');
                    Route:: post('EditBaPriSett/{id}', 'EditBaPriSett');
                    Route:: get('DeleteBaPriSett/{id}', 'DeleteBaPriSett');

                    //ShippingCompany
                    Route:: get('ShippingCompany', 'ShippingCompanyPage');
                    Route:: post('AddShippingCompany', 'AddShippingCompany');
                    Route:: post('EditShippingCompany/{id}', 'EditShippingCompany');
                    Route:: get('DeleteShippingCompany/{id}', 'DeleteShippingCompany');

                    //ShippingCompany
                    Route:: get('NewChangePrice', 'NewChangePrice');
                    Route:: get('NewTypeGuideFilter', 'NewTypeGuideFilter');
                    Route:: get('NewNameGuideilter', 'NewNameGuideilter');
                    Route:: get('NewCodeGuideFilter', 'NewCodeGuideFilter');
                    Route:: get('NewGroupGuideFilter', 'NewGroupGuideFilter');
                    Route:: post('PostChangePrice', 'PostChangePrice');


                    //Barcode Printing
                    Route:: get('BarcodeـPrinting', 'BarcodeـPrintingPage');
                    Route:: post('UpdateBarcodePrint', 'UpdateBarcodePrint');
                    Route:: get('BarcodeFilter', 'BarcodeFilter');

                    //QR Printing
                    Route:: get('QRـPrinting', 'QRـPrinting');
                    Route:: post('UpdateQRـPrinting', 'UpdateQRـPrinting');

                    //Items Guide
                    Route:: get('ItemsGuide', 'ItemsGuidePage');
                    Route:: get('ItemsGuide2', 'ItemsGuide2');
                    Route:: get('TypeGuideFilter', 'TypeGuideFilter');
                    Route:: get('GroupGuideFilter', 'GroupGuideFilter');
                    Route:: get('BrandsGuideFilter', 'BrandsGuideFilter');
                    Route:: get('NameGuideilter', 'NameGuideilter');
                    Route:: get('CodeGuideFilter', 'CodeGuideFilter');
                    Route:: post('ChangeProductPrice', 'ChangeProductPrice');

                    //from   Route::get('UpdatePrice/{id}/{P}/{PP}/{PPP}/{Code}', 'App\Http\Controllers\StoresController@UpdatePrice');

                    //to
                    Route:: get('UpdatePrice', 'UpdatePrice');


                    // ==================  Products  ===========================

                    Route:: get('Add_Items', 'Add_ItemsPage');
                    Route:: post('PostAddProduct', 'PostAddProduct');
                    Route:: get('Products_Sechdule', 'Products_SechdulePage');
                    Route:: get('FilterPSechdule', 'FilterPSechdule');
                    Route:: get('EditItems/{id}', 'EditItems');
                    Route:: post('PostEditProduct/{id}', 'PostEditProduct');
                    Route:: get('UnActiveItem/{id}', 'UnActiveItem');
                    Route:: get('ActiveItem/{id}', 'ActiveItem');

                    //===
                    Route:: post('PostEditAV', 'PostEditAV');
                    Route:: post('PostEditAddittionAV', 'PostEditAddittionAV');
                    Route:: post('PostEditQTYPriceAV', 'PostEditQTYPriceAV');

                    //==
                    Route:: get('DeleteItem/{id}', 'DeleteItem');
                    Route:: get('DelSubImage/{id}', 'DelSubImage');
                    Route:: get('DeleteVAPro/{id}', 'DeleteVAPro');
                    Route:: get('DeleteVAProQty/{id}', 'DeleteVAProQty');
                    Route:: get('DeleteVAPrice/{id}', 'DeleteVAPrice');
                    Route:: get('DeleteSerialQty/{id}', 'DeleteSerialQty');
                    Route:: get('MultiDeleteVira', 'MultiDeleteVira');


                    //== Filter
                    Route:: get('UnitNameFilter/{id}', 'UnitNameFilter');
                    Route:: get('AssemblyFilter', 'AssemblyFilter');
                    Route:: get('VariableAggregateFilter', 'VariableAggregateFilter');
                    Route:: get('VASelectFilterr', 'VASelectFilterr');
                    Route:: get('VASubSelectFilterr', 'VASubSelectFilterr');
                    Route:: get('UnitNameCodeFilter/{id}/{Pro}', 'UnitNameCodeFilter');
                    Route:: get('UnitNameCodeFilterr/{id}/{Pro}', 'UnitNameCodeFilterr');
                    Route:: get('VOneFilter', 'VOneFilter');
                    Route:: get('VTwoFilter', 'VTwoFilter');
                    Route:: get('TaxPriceFilter', 'TaxPriceFilter');
                    Route:: get('SerialProductsQtyFilter', 'SerialProductsQtyFilter');


                    Route:: get('EditItems/UnitNameFilter/{id}', 'UnitNameFilter');
                    Route:: get('EditItems/AssemblyFilter', 'AssemblyFilter');
                    Route:: get('EditItems/{id}/AssemblyFilter', 'AssemblyFilter');
                    Route:: get('EditItems/VariableAggregateFilter', 'VariableAggregateFilter');
                    Route:: get('EditItems/VASelectFilterr', 'VASelectFilterr');
                    Route:: get('EditItems/VASubSelectFilterr', 'VASubSelectFilterr');
                    Route:: get('EditItems/UnitNameCodeFilter/{id}/{Pro}', 'UnitNameCodeFilter');
                    Route:: get('EditItems/UnitNameCodeFilterr/{id}/{Pro}', 'UnitNameCodeFilterr');
                    Route:: get('EditItems/{id}/VOneFilter', 'VOneFilter');
                    Route:: get('EditItems/{id}/VTwoFilter', 'VTwoFilter');
                    Route:: get('EditItems/TaxPriceFilter', 'TaxPriceFilter');
                    Route:: get('EditItems/SerialProductsQtyFilter', 'SerialProductsQtyFilter');


                    //==
                    Route:: get('EditSerialQty', 'EditSerialQty');
                    Route:: get('AddCheckName', 'AddCheckName');


                    //to
                    Route:: get('AddNewProduct', 'AddNewProduct');
                    Route:: get('EditPuechasesBill/AddNewProduct', 'AddNewProduct');
                    Route:: get('EditPurchasesOrder/AddNewProduct', 'AddNewProduct');

                    //=================================


                    //Start Period Products
                    Route:: get('StartPeriodSechdule', 'StartPeriodSechdulePage');
                    Route:: get('StartPeriodProducts', 'StartPeriodProductsPage');
                    Route:: get('EditStartPeriod/{id}', 'EditStartPeriod');
                    Route:: get('DeleteStartPeriod/{id}', 'DeleteStartPeriod');
                    Route:: get('StartPeriodPrint/{id}', 'StartPeriodPrint');
                    Route:: get('MoreProDetailsStart', 'MoreProDetailsStart');
                    Route:: post('AddStartPeriod', 'AddStartPeriod');
                    Route:: post('PostEditStartPeriod/{id}', 'PostEditStartPeriod');

                    //==
                    Route:: get('StartProductsFilter/{store}', 'StartProductsFilter');
                    Route:: get('ViraFilter/{id}', 'ViraFilter');
                    Route:: get('ViraTwoFilter/{id}', 'ViraTwoFilter');
                    Route:: get('ViraName/{id}', 'ViraName');

                    Route:: get('EditStartPeriod/StartProductsFilter/{store}', 'StartProductsFilter');
                    Route:: get('EditStartPeriod/ViraFilter/{id}', 'ViraFilter');
                    Route:: get('EditStartPeriod/ViraTwoFilter/{id}', 'ViraTwoFilter');
                    Route:: get('EditStartPeriod/ViraName/{id}', 'ViraName');

                    Route:: get('EditStartPeriod/UnitNameCodeFilter/{id}/{Pro}', 'UnitNameCodeFilter');
                    Route:: get('EditStartPeriod/UnitNameCodeFilterr/{id}/{Pro}', 'UnitNameCodeFilterr');
                    //=============== Inventory  ===================

                    Route:: get('Inventory', 'InventoryPage');
                    Route:: get('Inventory_Sechdule', 'Inventory_SechdulePage');
                    Route:: get('DeleteInventory/{id}', 'DeleteInventory');
                    Route:: get('EditInvntory/{id}', 'EditInvntory');
                    Route:: get('InventoryPrint/{id}', 'InventoryPrint');
                    Route:: post('AddInventory', 'AddInventory');
                    Route:: post('PostEditInventory/{id}', 'PostEditInventory');



                    //Settlement
                    Route:: get('Settlement_Sechdule', 'Settlement_SechdulePage');
                    Route:: get('SettlementInvntory/{id}', 'SettlementInvntory');
                    Route:: post('PostSettlement/{id}', 'PostSettlement');


                    //Inventory Filters

                    Route:: get('InventoryFilter', 'InventoryFilter');
                    Route:: get('UnitNameCodeInventoryFilterTWO', 'UnitNameCodeInventoryFilterTWO');
                    Route:: get('UnitNameCodeInventoryFilter', 'UnitNameCodeInventoryFilter');
                    Route:: get('UnitNameCodeInventoryFilterSalePrice', 'UnitNameCodeInventoryFilterSalePrice');

                    Route:: get('EditInvntory/{id}/InventoryFilter', 'InventoryFilter');
                    Route:: get('EditInvntory/UnitNameCodeInventoryFilterTWO', 'UnitNameCodeInventoryFilterTWO');
                    Route:: get('EditInvntory/UnitNameCodeInventoryFilter', 'UnitNameCodeInventoryFilter');
                    Route:: get('EditInvntory/UnitNameCodeInventoryFilterSalePrice', 'UnitNameCodeInventoryFilterSalePrice');

                    //==================================================================


                    //Consists
                    Route:: get('Consists', 'ConsistsPage');
                    Route:: get('ConsistFilter', 'ConsistFilter');
                    Route:: post('AddConsists', 'AddConsists');
                    Route:: get('ConsistsSechdule', 'ConsistsSechdule');
                    Route:: get('DeleteConsist/{id}', 'DeleteConsist');

                    //Samples
                    Route:: get('Samples', 'Samples');
                    Route:: get('SamplesFilter', 'SamplesFilter');
                    Route:: post('AddSamples', 'AddSamples');
                    Route:: get('SamplesSechdule', 'SamplesSechdule');


                    //StoresTransfers ===========================================

                    Route:: get('StoresTransfersSechdule', 'StoresTransfersSechdulePage');
                    Route:: get('StoresTransfers', 'StoresTransfersPage');
                    Route:: get('EditStoreTransfer/{id}', 'EditStoreTransfer');
                    Route:: get('StoresTransferPrint/{id}', 'StoresTransferPrint');
                    Route:: get('DeleteStoresTransfer/{id}', 'DeleteStoresTransfer');
                    Route:: get('TransferSure/{id}', 'TransferSure');
                    Route:: get('RefusedStoreTransfer/{id}', 'RefusedStoreTransfer');
                    Route:: get('ShippingTransferRecived/{id}', 'ShippingTransferRecived');

                    Route:: post('AddStoresTransfers', 'AddStoresTransfers');
                    Route:: post('SureStoresTransfers/{id}', 'SureStoresTransfers');
                    Route:: post('PostEditStoresTransfers/{id}', 'PostEditStoresTransfers');
                    Route:: post('SureRecivedShipStoresTransfers/{id}', 'SureRecivedShipStoresTransfers');



                    //Filters
                    Route:: get('UnitNameCodeStoresTransferFilterTWO', 'UnitNameCodeStoresTransferFilterTWO');
                    Route:: get('UnitNameCodeStoresTransferFilter', 'UnitNameCodeStoresTransferFilter');
                    Route:: get('UnitNameCodeInventoryFilterSalePrice', 'UnitNameCodeInventoryFilterSalePrice');
                    Route:: get('StoreClientAccount', 'StoreClientAccount');
                    Route:: get('TarnsferStoresFilter', 'TarnsferStoresFilter');


                    //Return Stores Transfer
                    Route:: get('ReturnStoresTransfersSechdule', 'ReturnStoresTransfersSechdule');
                    Route:: get('Stores_Sales_Transfers_Sechdule', 'Stores_Sales_Transfers_Sechdule');
                    Route:: get('ReturnStoresTransfer/{id}', 'ReturnStoresTransfer');
                    Route:: get('ApproveReturnStoresTransfer/{id}', 'ApproveReturnStoresTransfer');
                    Route:: post('ReturnSaleStoresTransfers', 'ReturnSaleStoresTransfers');
                    Route:: post('PostApproveReturnSaleStoresTransfers', 'PostApproveReturnSaleStoresTransfers');


                    //====================================================================


                    //Permission_to_exchange_goods
                    Route:: get('Permission_to_exchange_goods', 'Permission_to_exchange_goods');
                    Route:: get('ExchangePrint/{id}', 'ExchangePrintPage');
                    Route:: get('DeletePremissionExchange/{id}', 'DeletePremissionExchange');
                    Route:: get('ExchangeGoodsSechdule', 'ExchangeGoodsSechdulePage');
                    Route:: get('EditPremissionExchange/{id}', 'EditPremissionExchange');
                    Route:: get('TransferToSalesExchange/{id}', 'TransferToSalesExchange');
                    Route:: post('AddExchangeGoods', 'AddExchangeGoods');
                    Route:: post('PostEditExchangeGoods/{id}', 'PostEditExchangeGoods');
                    Route:: post('PostTransSalesExchange/{id}', 'PostTransSalesExchange');


                    //Permission_to_receive_goods
                    Route:: get('Permission_to_receive_goods', 'Permission_to_receive_goods');
                    Route:: get('RecivedPrint/{id}', 'RecivedPrint');
                    Route:: get('ReceiveGoodsSechdule', 'ReceiveGoodsSechdule');
                    Route:: get('DeletePremissionRercived/{id}', 'DeletePremissionRercived');
                    Route:: get('EditPremissionRercived/{id}', 'EditPremissionRercived');
                    Route:: get('TransferToPurchasesRecived/{id}', 'TransferToPurchasesRecived');
                    Route:: post('AddRecivedGoods', 'AddRecivedGoods');
                    Route:: post('PostEditRecivedGoods/{id}', 'PostEditRecivedGoods');
                    Route:: post('PostTransferPurchasesRecived', 'PostTransferPurchasesRecived');

                    //Filters
                    Route:: get('ExchangeProductsFilter', 'ExchangeProductsFilter');
                    Route:: get('RecivedProductsFilter', 'RecivedProductsFilter');

                    Route:: get('EditPremissionExchange/{id}/ExchangeProductsFilter', 'ExchangeProductsFilter');
                    Route:: get('EditPremissionRercived/{id}/RecivedProductsFilter', 'RecivedProductsFilter');


                });



// ===  End Stores  ========================================================================================================

// === HR ========================================================================================================

                Route::controller(HRController:: class)->group( function () {

                    //Work Departments
                    Route:: get('WorkDepartments', 'WorkDepartmentsPage');
                    Route:: post('AddWorkDepartments', 'AddWorkDepartments');
                    Route:: post('EditWorkDepartments', 'EditWorkDepartments');
                    Route:: get('DeleteWorkDepartments', 'DeleteWorkDepartments');
                    Route:: get('EditDepartment', 'EditDepartment');


                    //Employment_levels
                    Route:: get('Employment_levels', 'Employment_levels');
                    Route:: post('AddEmployment_levels', 'AddEmployment_levels');
                    Route:: post('EditEmployment_levels', 'EditEmployment_levels');
                    Route:: get('DeleteEmployment_levels', 'DeleteEmployment_levels');

                    //Insurance_companies
                    Route:: get('Insurance_companies', 'Insurance_companies');
                    Route:: post('AddInsurance_companies', 'AddInsurance_companies');
                    Route:: post('EditInsurance_companies', 'EditInsurance_companies');
                    Route:: get('DeleteInsurance_companies', 'DeleteInsurance_companies');


                    //Jobs_Type
                    Route:: get('Jobs_Type', 'Jobs_TypePage');
                    Route:: post('AddJobs_Type', 'AddJobs_Type');
                    Route:: post('EditJobs_Type/{id}', 'EditJobs_Type');
                    Route:: get('DeleteJobs_Type/{id}', 'DeleteJobs_Type');

                    //Benefits_Types
                    Route:: get('Benefits_Types', 'Benefits_TypesPage');
                    Route:: post('AddBenefits_Types', 'AddBenefits_Types');
                    Route:: post('EditBenefits_Types/{id}', 'EditBenefits_Types');
                    Route:: get('DeleteBenefits_Types/{id}', 'DeleteBenefits_Types');

                    //Deductions_Types
                    Route:: get('Deductions_Types', 'Deductions_TypesPage');
                    Route:: post('AddDeductions_Types', 'AddDeductions_Types');
                    Route:: post('EditDeductions_Types/{id}', 'EditDeductions_Types');
                    Route:: get('DeleteDeductions_Types/{id}', 'DeleteDeductions_Types');

                    //Holidays_Types
                    Route:: get('Holidays_Types', 'Holidays_TypesPage');
                    Route:: post('AddHolidays_Types', 'AddHolidays_Types');
                    Route:: post('EditHolidays_Types/{id}', 'EditHolidays_Types');
                    Route:: get('DeleteHolidays_Types/{id}', 'DeleteHolidays_Types');


                    //Overtime
                    Route:: get('Overtime', 'OvertimePage');
                    Route:: post('AddOvertime', 'AddOvertime');
                    Route:: post('EditOvertime/{id}', 'EditOvertime');
                    Route:: get('DeleteOvertime/{id}', 'DeleteOvertime');

                    //ProducationPoints
                    Route:: get('ProducationPoints', 'ProducationPoints');
                    Route:: post('AddProducationPoints', 'AddProducationPoints');
                    Route:: post('EditProducationPoints/{id}', 'EditProducationPoints');
                    Route:: get('DeleteProducationPoints/{id}', 'DeleteProducationPoints');

                    //Loan_Types
                    Route:: get('Loan_Types', 'Loan_TypesPage');
                    Route:: post('AddLoan_Types', 'AddLoan_Types');
                    Route:: post('EditLoan_Types/{id}', 'EditLoan_Types');
                    Route:: get('DeleteLoan_Types/{id}', 'DeleteLoan_Types');

                    //Borrows
                    Route:: get('Borrow', 'BorrowPage');
                    Route:: get('AddBorrow', 'AddBorrowPage');
                    Route:: get('EmpCheck/{Emp}/{Month}', 'EmpCheck');
                    Route:: post('PostAddBorrow', 'PostAddBorrow');
                    Route:: get('DeleteBorrow/{id}', 'DeleteBorrow');

                    //Entitlements
                    Route:: get('Entitlements', 'EntitlementsPage');
                    Route:: post('AddEntitlements', 'AddEntitlements');
                    Route:: post('EditEntitlements/{id}', 'EditEntitlements');
                    Route:: get('DeleteEntitlements/{id}', 'DeleteEntitlements');

                    //Deducation
                    Route:: get('Deducation', 'DeducationPage');
                    Route:: post('AddDeducation', 'AddDeducation');
                    Route:: post('EditDeducation/{id}', 'EditDeducation');
                    Route:: get('DeleteDeducation/{id}', 'DeleteDeducation');

                    //Holidays
                    Route:: get('Holidays', 'HolidaysPage');
                    Route:: post('AddHolidays', 'AddHolidays');
                    Route:: post('EditHolidays/{id}', 'EditHolidays');
                    Route:: get('DeleteHolidays/{id}', 'DeleteHolidays');
                    Route:: get('HolidaysTypeFilter/{type}', 'HolidaysTypeFilter');

                    //RegOverTime
                    Route:: get('RegOverTime', 'RegOverTimePage');
                    Route:: post('AddRegOverTime', 'AddRegOverTime');
                    Route:: post('EditRegOverTime/{id}', 'EditRegOverTime');
                    Route:: get('DeleteRegOverTime/{id}', 'DeleteRegOverTime');
                    Route:: get('OverTimeTypeFilter/{type}/{emp}', 'OverTimeTypeFilter');

                    //Disclaimer
                    Route:: get('Disclaimer', 'Disclaimer');
                    Route:: post('AddDisclaimer', 'AddDisclaimer');
                    Route:: post('EditDisclaimer/{id}', 'EditDisclaimer');
                    Route:: get('DeleteDisclaimer/{id}', 'DeleteDisclaimer');
                    Route:: get('PrintDisclaimer/{id}', 'PrintDisclaimer');

                    //HolidaysOrder
                    Route:: get('HolidaysOrder', 'HolidaysOrderPage');
                    Route:: post('AddHolidaysOrder', 'AddHolidaysOrder');
                    Route:: post('EditHolidaysOrder/{id}', 'EditHolidaysOrder');
                    Route:: get('DeleteHolidaysOrder/{id}', 'DeleteHolidaysOrder');
                    Route:: get('TransToHoilday/{id}', 'TransToHoilday');
                    Route:: get('HolidaysOrderTypeFilter/{type}', 'HolidaysOrderTypeFilter');


                    //Employee
                    Route:: get('AddEmp', 'AddEmpPage');
                    Route:: get('EmpSechdule', 'EmpSechdulePage');
                    Route:: get('JobRequestsSechdule', 'JobRequestsSechdule');
                    Route:: get('EditEmp/{id}', 'EditEmp');
                    Route:: get('DeleteEmp/{id}', 'DeleteEmp');
                    Route:: post('PostAddEmp', 'PostAddEmp');
                    Route:: post('PostEditEmp/{id}', 'PostEditEmp');
                    Route:: get('TransToEmp/{id}', 'TransToEmp');
                    Route:: get('PrintEmp/{id}', 'PrintEmp');
                    Route:: get('PrintCardEmp/{id}', 'PrintCardEmp');
                    Route:: get('UnActiveEmp/{id}', 'UnActiveEmp');
                    Route:: get('ActiveEmp/{id}', 'ActiveEmp');

                    //EmpInstallment
                    Route:: get('EmpInstallment', 'EmpInstallmentPage');
                    Route:: get('EmpInstallBillDone/{id}', 'EmpInstallBillDone');
                    Route:: get('EmpUnInstallBill/{id}', 'EmpUnInstallBill');
                    Route:: post('EmpInstallDone', 'EmpInstallDone');
                    Route:: get('EmpUnInstall/{id}', 'EmpUnInstall');
                    Route:: get('InstallEmpPrint/{id}/{inst}', 'InstallEmpPrint');

                    //Attendance
                    Route:: get('Attendance', 'AttendancePage');
                    Route:: get('AttendanceSechdule', 'AttendanceSechdulePage');
                    Route:: get('EmpNameFilter/{Emp}', 'EmpNameFilter');
                    Route:: get('EditAttendance/EmpNameFilter/{Emp}', 'EmpNameFilter');
                    Route:: post('AddAttendance', 'AddAttendance');
                    Route:: post('PostEditAttendance/{id}', 'PostEditAttendance');
                    Route:: get('EditAttendance/{id}', 'EditAttendancePage');
                    Route:: get('DeleteAttendance/{id}', 'DeleteAttendance');

                    //Departure
                    Route:: get('Departure/{id}', 'DeparturePage');
                    Route:: post('AddDeparture/{id}', 'AddDeparture');
                    Route:: get('DepartureSechdule', 'DepartureSechdulePage');
                    Route:: get('EditDeparture/{id}', 'EditDeparturePage');
                    Route:: post('PostEditDeparture/{id}', 'PostEditDeparture');

                    //Loan
                    Route:: get('AddLoan', 'AddLoanPage');
                    Route:: post('PostAddLoan', 'PostAddLoan');
                    Route:: get('Loan', 'LoanPage');
                    Route:: get('DeleteLoan/{id}', 'DeleteLoan');

                    //Salary
                    Route:: get('AddSalary', 'AddSalaryPage');
                    Route:: get('SalarySechdules', 'SalarySechdulesPage');
                    Route:: get('EmpCheckSalary/{Emp}/{Month}', 'EmpCheckSalary');
                    Route:: post('PostAddSalary', 'PostAddSalary');
                    Route:: get('DeletePaySalary/{id}', 'DeletePaySalary');


                    //ExchangeCommissions
                    Route:: get('ExchangeCommissions', 'ExchangeCommissionsPage');
                    Route:: get('EmpCheckCommision/{Emp}', 'EmpCheckCommision');
                    Route:: post('PostExchangeCommissions', 'PostExchangeCommissions');
                    Route:: get('ExchangeCommissionsSechdule', 'ExchangeCommissionsSechdule');
                    Route:: get('DeleteCommission/{id}', 'DeleteCommission');


                    //ResignationRequest
                    Route:: get('ResignationRequestSechdule', 'ResignationRequestSechdule');
                    Route:: get('ResignationRequest', 'ResignationRequest');
                    Route:: post('AddResignationRequest', 'AddResignationRequest');
                    Route:: post('EditResignationRequest/{id}', 'EditResignationRequest');
                    Route:: get('DeleteResignationRequest/{id}', 'DeleteResignationRequest');
                    Route:: get('AcceptResignation/{id}', 'AcceptResignation');
                    Route:: get('RefuseResignation', 'RefuseResignation');


                    //MyGoals
                    Route:: get('MyGoals', 'MyGoals');

                    //EmpCovenant
                    Route:: get('EmpCovenant', 'EmpCovenant');
                    Route:: post('AddEmpCovenant', 'AddEmpCovenant');
                    Route:: post('EditEmpCovenant/{id}', 'EditEmpCovenant');
                    Route:: get('DeleteEmpCovenant/{id}', 'DeleteEmpCovenant');




                });

// === End HR ===================================================================================================

// ===  HR Reports  ===================================================================================================

                Route::controller(HRReportsController:: class)->group( function () {


                    //AttendenceAndDepartureReport
                    Route:: get('AttendenceAndDepartureReport', 'AttendenceAndDepartureReport');
                    Route:: get('AttendenceAndDepartureReportFilterTwo', 'AttendenceAndDepartureReportFilterTwo');


                    //AttendenceValueReport
                    Route:: get('AttendenceValueReport', 'AttendenceValueReport');
                    Route:: get('AttendenceValueReportFilterTwo', 'AttendenceValueReportFilterTwo');

                    //SalaryPayed
                    Route:: get('SalaryPayed', 'SalaryPayed');
                    Route:: get('SalaryPayedFilterTwo', 'SalaryPayedFilterTwo');

                    //PaySalaryReport
                    Route:: get('PaySalaryReport', 'PaySalaryReport');
                    Route:: get('NewEmpCheckSalary/{Emp}/{Month}', 'NewEmpCheckSalary');


                    //EmpSalaries
                    Route:: get('EmpSalaries', 'EmpSalaries');


                });

// === End HR  Reports  ===================================================================================================



// === Purchases ===================================================================================================


                Route::controller(PurchasesController:: class)->group( function () {

                    //Vendors
                    Route:: get('Vendors', 'VendorsPage');
                    Route:: post('AddVendors', 'AddVendors');
                    Route:: post('EditVendors/{id}', 'EditVendors');
                    Route:: get('DeleteVendors/{id}', 'DeleteVendors');

                    Route:: get('AddNewVendor', 'AddNewVendor');
                    Route:: get('EditPuechasesBill/AddNewVendor', 'AddNewVendor');
                    Route:: get('EditPurchasesOrder/AddNewVendor', 'AddNewVendor');


                    //Filters
                    Route:: get('PurchacesProductsFilter', 'PurchacesProductsFilter');
                    Route:: get('PurchacesProductsSearchCodeFilter', 'PurchacesProductsSearchCodeFilter');
                    Route:: get('UnitPurchasesFilter', 'UnitPurchasesFilter');
                    Route:: get('AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('NewAccountBalanceSOFilter/{id}', 'NewAccountBalanceFilter');
                    Route:: get('AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('StoreNamePurchasesFilter/{id}', 'StoreNamePurchasesFilter');
                    Route:: get('TaxNamePurchasesFilter/{id}', 'TaxNamePurchasesFilter');
                    Route:: get('ViraFilterPurchases/{id}', 'ViraFilterPurchases');
                    Route:: get('ViraNamePurchases/{id}', 'ViraNamePurchases');
                    Route:: get('StorePricePurchasesFilter', 'StorePricePurchasesFilter');
                    Route:: get('AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');




                    //====

                    Route:: get('EditPurchasesOrder/{id}/PurchacesProductsFilter', 'PurchacesProductsFilter');
                    Route:: get('EditPurchasesOrder/{id}/PurchacesProductsSearchCodeFilter', 'PurchacesProductsSearchCodeFilter');
                    Route:: get('EditPurchasesOrder/UnitPurchasesFilter', 'UnitPurchasesFilter');
                    Route:: get('EditPurchasesOrder/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('EditPurchasesOrder/StoreNamePurchasesFilter/{id}', 'StoreNamePurchasesFilter');
                    Route:: get('EditPurchasesOrder/TaxNamePurchasesFilter/{id}', 'TaxNamePurchasesFilter');
                    Route:: get('EditQuoteImages/TaxNamePurchasesFilter/{id}', 'TaxNamePurchasesFilter');
                    Route:: get('EditPurchasesOrder/ViraFilterPurchases/{id}', 'ViraFilterPurchases');
                    Route:: get('EditPurchasesOrder/ViraNamePurchases/{id}', 'ViraNamePurchases');
                    Route:: get('EditPurchasesOrder/StorePricePurchasesFilter', 'StorePricePurchasesFilter');

                    Route:: get('TransferToSalesExchange/AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');
                    Route:: get('EditQuote/AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');
                    Route:: get('HoldSale/AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');
                    Route:: get('ReturnSales/AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');
                    Route:: get('EditSalesOrder/AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');
                    Route:: get('ESBill/AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');
                    Route:: get('TicketEdit/AccountBalanceSFilter/{id}', 'AccountBalanceSFilter');


                    Route:: get('TransferToSalesExchange/AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('EditQuote/AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('HoldSale/AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('ReturnSales/AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('EditSalesOrder/AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('ESBill/AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('TicketEdit/AccountBalanceSOFilter/{id}', 'AccountBalanceFilter');


                    Route:: get('EditQuote/NewAccountBalanceSOFilter/{id}', 'NewAccountBalanceFilter');
                    Route:: get('EditSalesOrder/NewAccountBalanceSOFilter/{id}', 'NewAccountBalanceFilter');
                    Route:: get('ESBill/NewAccountBalanceSOFilter/{id}', 'NewAccountBalanceFilter');
                    Route:: get('EditQuoteImages/NewAccountBalanceSOFilter/{id}', 'NewAccountBalanceFilter');
                    Route:: get('EditQuoteImages/AccountBalanceSFilter/{id}', 'NewAccountBalanceFilter');


                    //===
                    Route:: get('EditPuechasesBill/{id}/PurchacesProductsFilter', 'PurchacesProductsFilter');
                    Route:: get('EditPuechasesBill/{id}/PurchacesProductsSearchCodeFilter', 'PurchacesProductsSearchCodeFilter');
                    Route:: get('EditPuechasesBill/UnitPurchasesFilter', 'UnitPurchasesFilter');
                    Route:: get('EditPuechasesBill/AccountBalanceFilter/{id}', 'AccountBalanceFilter');
                    Route:: get('EditPuechasesBill/StoreNamePurchasesFilter/{id}', 'StoreNamePurchasesFilter');
                    Route:: get('EditPuechasesBill/TaxNamePurchasesFilter/{id}', 'TaxNamePurchasesFilter');
                    Route:: get('EditPuechasesBill/ViraFilterPurchases/{id}', 'ViraFilterPurchases');
                    Route:: get('EditPuechasesBill/ViraNamePurchases/{id}', 'ViraNamePurchases');
                    Route:: get('EditPuechasesBill/StorePricePurchasesFilter', 'StorePricePurchasesFilter');

                    //===
                    Route:: get('EditManufacturingModel/UnitPurchasesFilter', 'UnitPurchasesFilter');
                    Route:: get('EditManufacturingModel/StoreNamePurchasesFilter/{id}', 'StoreNamePurchasesFilter');
                    Route:: get('HoldSale/TaxNamePurchasesFilter/{id}', 'TaxNamePurchasesFilter');

                    //  ====  Purchases Order ====
                    Route:: get('PurchasesOrderSechdule', 'PurchasesOrderSechdule');
                    Route:: get('FilterBillPurchasesOrder', 'FilterBillPurchasesOrder');
                    Route:: get('PurchasesOrder', 'PurchasesOrderPage');
                    Route:: get('EditPurchasesOrder/{id}', 'EditPurchasesOrder');
                    Route:: get('DeletePurchasesOrder/{id}', 'DeletePurchasesOrder');
                    Route:: get('PurchOrdPrint/{id}', 'PurchOrdPrint');
                    Route:: post('AddPurchasesOrder', 'AddPurchasesOrder');
                    Route:: post('PostEditPurchasesOrder/{id}', 'PostEditPurchasesOrder');
                    Route:: post('PostTransferPurchases', 'PostTransferPurchases');
                    Route:: get('TransferToPurchases/{id}', 'TransferToPurchases');
                    Route:: post('PostQuality/{id}', 'PostQuality');
                    Route:: get('RefusedQualityPurchOrder/{id}', 'RefusedQualityPurchOrder');
                    Route:: get('PurchOrderQty/{id}', 'PurchOrderQtyPage');
                    Route:: post('RenewalPurchasesOrder/{id}', 'RenewalPurchasesOrder');


                    //  ====  Purchases  ====
                    Route:: get('PurchasesSechdule', 'PurchasesSechdulePage');
                    Route:: get('FilterBillPurchases', 'FilterBillPurchases');
                    Route:: get('Purchases', 'PurchasesPage');
                    Route:: get('Barcode/{id}', 'BarcodePage');
                    Route:: get('EditPuechasesBill/{id}', 'EditPuechasesBillPage');
                    Route:: get('DeletePurchaseBill/{id}', 'DeletePurchaseBill');
                    Route:: post('AddPurchases', 'AddPurchases');
                    Route:: post('PostEditPurchasesBill', 'PostEditPurchasesBill');
                    Route:: get('PurchPrint/{id}', 'PurchPrint');

                    //Returns
                    Route:: get('ReturnPurch/{id}', 'ReturnPurchPage');
                    Route:: get('ReturnPurchPrint/{id}', 'ReturnPurchPrint');
                    Route:: get('ReturnPurchasesSechdule', 'ReturnPurchasesSechdulePage');
                    Route:: post('PostReturnPurchases/{id}', 'PostReturnPurchases');

                    //PurchasesHold
                    Route:: get('PurchasesHold', 'PurchasesHoldPage');
                    Route:: get('FilterBillPurchasesHold', 'FilterBillPurchasesHold');
                    Route:: get('RecivedPurch/{id}', 'RecivedPurchPage');
                    Route:: post('PostRecivedPurchases/{id}', 'PostRecivedPurchases');

                    //Recived_Products
                    Route:: get('Recived_Products', 'Recived_ProductsPage');
                    Route:: get('DeleteRecivedProducts/{id}', 'DeleteRecivedProducts');


                    //Change Price Unit Ajax
                    Route:: get('ChangePriceUnit', 'ChangePriceUnit');
                    Route:: get('EditPurchasesOrder/ChangePriceUnit', 'ChangePriceUnit');
                    Route:: get('EditPuechasesBill/ChangePriceUnit', 'ChangePriceUnit');

                    //Shortcomings
                    Route:: get('Shortcomings', 'ShortcomingsPage');
                    Route:: get('ShortcomingsProductsFilter', 'ShortcomingsProductsFilter');
                    Route:: get('ShortcomingsProductsSearchCodeFilter', 'ShortcomingsProductsSearchCodeFilter');
                    Route:: get('EditShortcomings/1/ShortcomingsProductsFilter', 'ShortcomingsProductsFilter');
                    Route:: get('EditShortcomings/1/ShortcomingsProductsSearchCodeFilter', 'ShortcomingsProductsSearchCodeFilter');
                    Route:: get('ManuProdsFilter', 'ManuProdsFilter');
                    Route:: get('ShortcomingsSechdule', 'ShortcomingsSechdulePage');
                    Route:: get('EditShortcomings', 'EditShortcomingsPage');
                    Route:: get('DeleteShortcomings/{id}', 'DeleteShortcomings');
                    Route:: get('ShortcomingsPrint/{id}', 'ShortcomingsPrint');
                    Route:: get('TransferToPurchasesShortcomings/{id}', 'TransferToPurchasesShortcomings');
                    Route:: post('AddShortcomings', 'AddShortcomings');
                    Route:: post('PostEditShortcomings', 'PostEditShortcomings');
                    Route:: post('PostTransferPurchasesShortcomings/{id}', 'PostTransferPurchasesShortcomings');



                });

// === End Purchases ===================================================================================================


//==== Sales ==============================================================================================================


                Route::controller(SalesController:: class)->group( function () {

                    //Clients_Group
                    Route:: get('Clients_Group', 'Clients_GroupPage');
                    Route:: post('AddClients_Group', 'AddClients_Group');
                    Route:: post('EditClients_Group/{id}', 'EditClients_Group');
                    Route:: get('DeleteClients_Group/{id}', 'DeleteClients_Group');



                    //InstallmentCompanies
                    Route:: get('InstallmentCompanies', 'InstallmentCompanies');
                    Route:: get('AddInstallmentCompanies', 'AddInstallmentCompanies');
                    Route:: get('EditInstallmentCompanies/{id}', 'EditInstallmentCompanies');
                    Route:: get('DeleteInstallmentCompanies/{id}', 'DeleteInstallmentCompanies');


                    //========== Clients ============
                    //Add
                    Route:: get('Clients', 'ClientsPage');
                    Route:: get('AddClients', 'AddClientsPage');
                    Route:: get('EditClients/{id}', 'EditClientsPage');
                    Route:: get('ProfileCustomer/{id}', 'ProfileCustomer');
                    Route:: get('CoooMCustomer/{id}', 'CoooMCustomer');
                    Route:: get('DeleteClientFile/{id}', 'DeleteClientFile');
                    Route:: get('FilterClientSechdule', 'FilterClientSechdule');

                    Route:: post('PostAddClients', 'PostAddClients');
                    Route:: post('PostEditClients/{id}', 'PostEditClients');
                    Route:: get('DeleteClients/{id}', 'DeleteClients');

                    //===
                    Route:: get('AllProClientFilter', 'AllProClientFilter');
                    Route:: get('AllProClientFilterJs/{id}', 'AllProClientFilterJs');
                    Route:: get('GovernrateFilter/{id}', 'GovernrateFilter');
                    Route:: get('CityFilter/{id}', 'CityFilter');
                    Route:: get('PlatformFilter/{id}', 'PlatformFilter');

                    Route:: get('EditClients/GovernrateFilter/{id}', 'GovernrateFilter');
                    Route:: get('EditClients/CityFilter/{id}', 'CityFilter');
                    Route:: get('EditClients/PlatformFilter/{id}', 'PlatformFilter');

                    Route:: get('EditTeacher/GovernrateFilter/{id}', 'GovernrateFilter');
                    Route:: get('EditTeacher/CityFilter/{id}', 'CityFilter');
                    Route:: get('EditStudent/GovernrateFilter/{id}', 'GovernrateFilter');
                    Route:: get('EditStudent/CityFilter/{id}', 'CityFilter');

                    Route:: get('EditClients/AllProClientFilter', 'AllProClientFilter');
                    Route:: get('EditClients/AllProClientFilterJs/{id}', 'AllProClientFilterJs');

                    //TicketsClient
                    Route:: get('TicketsClient/{id}', 'TicketsClient');
                    Route:: post('AddTicketsClient', 'AddTicketsClient');
                    Route:: post('EditTicketsClient/{id}', 'EditTicketsClient');
                    Route:: get('DeleteTicketsClient/{id}', 'DeleteTicketsClient');
                    Route:: get('SolveTicketsClient/{id}', 'SolveTicketsClient');
                    Route:: get('UnSolveTicketsClient/{id}', 'UnSolveTicketsClient');


                    //CommentsClient
                    Route:: get('CommentsClient/{id}', 'CommentsClient');
                    Route:: post('AddCommentsClient', 'AddCommentsClient');
                    Route:: post('EditCommentsClient/{id}', 'EditCommentsClient');
                    Route:: get('DeleteCommentsClient/{id}', 'DeleteCommentsClient');


                    // ======== Filters =============

                    Route:: get('SalesProductsFilter', 'SalesProductsFilter');
                    Route:: get('QuoteImagesProductsFilter', 'QuoteImagesProductsFilter');
                    Route:: get('SalesProductsSearchCodeFilter', 'SalesProductsSearchCodeFilter');
                    //==
                    Route:: get('EditQuote/1/SalesProductsFilter', 'SalesProductsFilter');
                    Route:: get('EditQuote/1/SalesProductsSearchCodeFilter', 'SalesProductsSearchCodeFilter');
                    Route:: get('EditSalesOrder/1/SalesProductsSearchCodeFilter', 'SalesProductsSearchCodeFilter');
                    Route:: get('EditSalesOrder/1/SalesProductsFilter', 'SalesProductsFilter');
                    Route:: get('ESBill/SalesProductsSearchCodeFilter', 'SalesProductsSearchCodeFilter');
                    Route:: get('ESBill/1/SalesProductsSearchCodeFilter', 'SalesProductsSearchCodeFilter');
                    Route:: get('ESBill/1/SalesProductsFilter', 'SalesProductsFilter');
                    Route:: get('ESBill/SalesProductsFilter', 'SalesProductsFilter');
                    Route:: get('EditQuoteImages/1/SalesProductsSearchCodeFilter', 'SalesProductsSearchCodeFilter');
                    Route:: get('EditQuoteImages/1/SalesProductsFilter', 'SalesProductsFilter');
                    Route:: get('EditQuoteImages/1/QuoteImagesProductsFilter', 'QuoteImagesProductsFilter');

                    //===

                    Route:: get('UnitSalesRateFilter', 'UnitSalesRateFilter');

                    Route:: get('HoldSale/UnitSalesRateFilter', 'UnitSalesRateFilter');
                    Route:: get('EditQuote/UnitSalesRateFilter', 'UnitSalesRateFilter');
                    Route:: get('EditSalesOrder/UnitSalesRateFilter', 'UnitSalesRateFilter');
                    Route:: get('ESBill/UnitSalesRateFilter', 'UnitSalesRateFilter');
                    Route:: get('EditQuoteImages/UnitSalesRateFilter', 'UnitSalesRateFilter');



                    //===
                    Route:: get('UnitSalesFilter', 'UnitSalesFilter');


                    Route:: get('ESBill/UnitSalesFilter', 'UnitSalesFilter');
                    Route:: get('EditSalesOrder/UnitSalesFilter', 'UnitSalesFilter');
                    Route:: get('EditQuote/UnitSalesFilter', 'UnitSalesFilter');
                    Route:: get('HoldSale/UnitSalesFilter', 'UnitSalesFilter');
                    Route:: get('EditQuoteImages/UnitSalesFilter', 'UnitSalesFilter');
                    Route:: get('EditSalesGifts/UnitSalesFilter', 'UnitSalesFilter');
                    Route:: get('EditPremissionExchange/{id}/UnitSalesFilter', 'UnitSalesFilter');
                    Route:: get('EditPremissionRercived/{id}/UnitSalesFilter', 'UnitSalesFilter');

                    //==
                    Route:: get('StoreNameSalesFilter', 'StoreNameSalesFilter');

                    Route:: get('ESBill/StoreNameSalesFilter', 'StoreNameSalesFilter');
                    Route:: get('EditSalesOrder/StoreNameSalesFilter', 'StoreNameSalesFilter');
                    Route:: get('EditQuote/StoreNameSalesFilter', 'StoreNameSalesFilter');
                    Route:: get('HoldSale/StoreNameSalesFilter', 'StoreNameSalesFilter');
                    Route:: get('EditQuoteImages/StoreNameSalesFilter', 'StoreNameSalesFilter');
                    Route:: get('EditPremissionExchange/{id}/StoreNameSalesFilter', 'StoreNameSalesFilter');
                    Route:: get('EditPremissionRercived/{id}/StoreNameSalesFilter', 'StoreNameSalesFilter');

                    //==
                    Route:: get('ExpDateQtySalesFilter/{id}', 'ExpDateQtySalesFilter');

                    Route:: get('ESBill/ExpDateQtySalesFilter/{id}', 'ExpDateQtySalesFilter');
                    Route:: get('EditSalesOrder/ExpDateQtySalesFilter/{id}', 'ExpDateQtySalesFilter');
                    Route:: get('EditQuote/ExpDateQtySalesFilter/{id}', 'ExpDateQtySalesFilter');
                    Route:: get('HoldSale/ExpDateQtySalesFilter/{id}', 'ExpDateQtySalesFilter');
                    Route:: get('EditQuoteImages/ExpDateQtySalesFilter/{id}', 'ExpDateQtySalesFilter');


                    //===
                    Route:: get('NewCostProductFilter', 'UnitSalesFilter');


                    Route:: get('ESBill/NewCostProductFilter', 'NewCostProductFilter');
                    Route:: get('EditSalesOrder/NewCostProductFilter', 'NewCostProductFilter');
                    Route:: get('EditQuote/NewCostProductFilter', 'NewCostProductFilter');
                    Route:: get('HoldSale/NewCostProductFilter', 'NewCostProductFilter');
                    Route:: get('EditQuoteImages/NewCostProductFilter', 'NewCostProductFilter');


                    //=====

                    //Add New Client By Ajax
                    Route:: get('AddNewClient', 'AddNewClient');
                    Route:: get('AddNewClientPOS', 'AddNewClientPOS');

                    Route:: get('ESBill/AddNewClient', 'AddNewClient');
                    Route:: get('EditSalesOrder/AddNewClient', 'AddNewClient');
                    Route:: get('EditQuote/AddNewClient', 'AddNewClient');
                    Route:: get('HoldSale/AddNewClientPOS', 'AddNewClientPOS');
                    Route:: get('EditQuoteImages/AddNewClient', 'AddNewClient');

                    //=======

                    //POS Filters

                    Route:: get('POSOtherQtyFilter', 'POSOtherQtyFilter');
                    Route:: get('SalesProductsPOSFilter', 'SalesProductsPOSFilter');
                    Route:: get('SalesProductsPOSSearchCodeFilter', 'SalesProductsPOSSearchCodeFilter');
                    Route:: get('SalesHoldBillsPOSFilter', 'SalesHoldBillsPOSFilter');
                    Route:: get('GroupPosFilter', 'GroupPosFilter');
                    Route:: get('BrandsPosFilter', 'BrandsPosFilter');
                    Route:: get('UnitsOfProducts/{id}', 'UnitsOfProducts');
                    Route:: get('AllProsPosFilter', 'AllProsPosFilter');
                    Route:: get('AllClientsAddressFilter', 'AllClientsAddressFilter');

                    Route:: get('HoldSale/POSOtherQtyFilter', 'POSOtherQtyFilter');
                    Route:: get('HoldSale/SalesProductsPOSFilter', 'SalesProductsPOSFilter');
                    Route:: get('HoldSale/SalesProductsPOSSearchCodeFilter', 'SalesProductsPOSSearchCodeFilter');
                    Route:: get('HoldSale/SalesHoldBillsPOSFilter', 'SalesHoldBillsPOSFilter');
                    Route:: get('HoldSale/GroupPosFilter', 'GroupPosFilter');
                    Route:: get('HoldSale/BrandsPosFilter', 'BrandsPosFilter');
                    Route:: get('HoldSale/UnitsOfProducts/{id}', 'UnitsOfProducts');
                    Route:: get('HoldSale/AllProsPosFilter', 'AllProsPosFilter');
                    Route:: get('HoldSale/AllClientsAddressFilter', 'AllClientsAddressFilter');
                    Route:: get('HoldSale/{id}/AllClientsAddressFilter', 'AllClientsAddressFilter');

                    //==
                    Route:: get('AddReciptVoucherAjax', 'AddReciptVoucherAjax');
                    Route:: get('AddPaymentVoucherAjax', 'AddPaymentVoucherAjax');

                    Route:: get('HoldSale/{id}/AddReciptVoucherAjax', 'AddReciptVoucherAjax');
                    Route:: get('HoldSale/{id}/AddPaymentVoucherAjax', 'AddPaymentVoucherAjax');


                    //========

                    //TaxOnTotalTypeFilter
                    Route:: get('TaxOnTotalTypeFilter', 'TaxOnTotalTypeFilter');
                    Route:: get('EndRecivedOrderHall/TaxOnTotalTypeFilter', 'TaxOnTotalTypeFilter');
                    Route:: get('InstallCompanyFilter', 'InstallCompanyFilter');



                    //========================================================================





                    //Quote
                    Route:: get('Quote', 'QuotePage');
                    Route:: post('AddQuote', 'AddQuote');
                    Route:: get('QuotePrint/{id}', 'QuotePrintPage');
                    Route:: get('Quote_Sechdule', 'Quote_Sechdule');
                    Route:: get('DeleteQuote/{id}', 'DeleteQuote');
                    Route:: get('EditQuote/{id}', 'EditQuote');
                    Route:: get('TransferToSalesOrder/{id}', 'TransferToSalesOrder');
                    Route:: post('PostEditQuote/{id}', 'PostEditQuote');
                    Route:: post('PostTransSalesOrder/{id}', 'PostTransSalesOrder');
                    Route:: get('FilterBillQuote', 'FilterBillQuote');




                    //Quote Images
                    Route:: get('QuoteImagesSechdule', 'QuoteImagesSechdule');
                    Route:: get('QuoteImagesSechduleAccepted', 'QuoteImagesSechduleAccepted');
                    Route:: get('QuoteImages', 'QuoteImagesPage');
                    Route:: post('AddQuoteImages', 'AddQuoteImages');
                    Route:: get('QuoteImagePrint/{id}', 'QuoteImagePrintPages');
                    Route:: get('DeleteQuoteImages/{id}', 'DeleteQuoteImages');
                    Route:: get('EditQuoteImages/{id}', 'EditQuoteImages');
                    Route:: post('PostEditQuoteImages/{id}', 'PostEditQuoteImages');
                    Route:: post('ClientAcceptQuoteImages/{id}', 'ClientAcceptQuoteImages');
                    Route:: get('DoneQuoteImages/{id}', 'DoneQuoteImages');




                    //Sales Order

                    Route:: get('SalesOrderSechdule', 'SalesOrderSechdule');
                    Route:: get('SalesOrderHoldSechdule', 'SalesOrderHoldSechdule');
                    Route:: get('SalesOrder', 'SalesOrderPage');
                    Route:: post('AddSalesOrder', 'AddSalesOrder');
                    Route:: get('SalesOrderPrint/{id}', 'SalesOrderPrintPage');
                    Route:: get('DeleteSalesOrder/{id}', 'DeleteSalesOrder');
                    Route:: get('EditSalesOrder/{id}', 'EditSalesOrder');
                    Route:: post('PostEditSalesOrder/{id}', 'PostEditSalesOrder');
                    Route:: get('FilterBillSalesOrder', 'FilterBillSalesOrder');
                    Route:: get('DelegateRecivedAccept/{id}', 'DelegateRecivedAccept');
                    Route:: get('CancelSalesOrder/{id}', 'CancelSalesOrder');
                    Route:: get('TransferToSales/{id}', 'TransferToSales');
                    Route:: post('PostTransSales/{id}', 'PostTransSales');


                    // ========= Sales ==============

                    Route:: get('SalesSechdule', 'SalesSechdule');
                    Route:: get('SalesSechduleTax', 'SalesSechduleTax');
                    Route:: get('FilterBillSales', 'FilterBillSales');
                    Route:: get('Sales', 'SalesPage');
                    Route:: post('AddSales', 'AddSales');
                    Route:: get('ESBill/{id}', 'ESBillPage');
                    Route:: get('DeleteSalesBill/{id}', 'DeleteSalesBill');
                    Route:: post('CollectionLaterBill', 'CollectionLaterBill');
                    Route:: post('PostEditSalesBill', 'PostEditSalesBill');
                    Route:: get('SalesTakeGoods/{id}', 'SalesTakeGoods');
                    Route:: get('SalesPrint/{id}', 'SalesPrintPage');
                    Route:: get('SalesPrint8/{id}', 'SalesPrint8Page');
                    Route:: get('SalesPrint5/{id}', 'SalesPrint5Page');

                    //POS

                    Route:: get('POS', 'POSPage');
                    Route:: post('NewShift', 'NewShift');
                    Route:: post('CloseShift', 'CloseShift');
                    Route:: post('PostPOS', 'PostPOS');
                    Route:: post('HoldPostPOS', 'HoldPostPOS');
                    Route:: get('HoldSale/{id}', 'HoldSale');
                    Route:: get('DeleteHoldBill/{id}', 'DeleteHoldBill');
                    Route:: get('ESBillPOS/{id}', 'ESBillPOS');
                    Route:: post('PostEditPOS/{id}', 'PostEditPOS');
                    Route:: get('DeleteSalesBillPOS/{id}', 'DeleteSalesBillPOS');

                    //== Delivery
                    Route:: get('SalesDeliverySechdule', 'SalesDeliverySechdule');
                    Route:: get('FilterSalesDelivery', 'FilterSalesDelivery');
                    Route:: get('MyRequestDelivery', 'MyRequestDelivery');
                    Route:: get('FilterSalesMyRequestDelivery', 'FilterSalesMyRequestDelivery');
                    Route:: get('DeliveryCollectionFilter', 'DeliveryCollectionFilter');
                    Route:: post('PostCollectDelivery', 'PostCollectDelivery');
                    Route:: post('ChangeDelivery', 'ChangeDelivery');
                    Route:: get('RecivedDelivery/{id}', 'RecivedDelivery');
                    Route:: post('CollectionDeliveryBill', 'CollectionDeliveryBill');
                    Route:: get('ClientDelivery/{id}', 'ClientDelivery');

                    //========================================================================

                    //Installment Sechdule
                    Route:: get('InstallmentSechdule', 'InstallmentSechdule');
                    Route:: get('InstallBillDone/{id}', 'InstallBillDone');
                    Route:: get('UnInstallBill/{id}', 'UnInstallBill');
                    Route:: post('InstallDone', 'InstallDone');
                    Route:: get('UnInstall/{id}', 'UnInstall');
                    Route:: get('InstallClientPrint/{id}/{inst}', 'InstallClientPrint');


                    //Sales Hold
                    Route:: get('SalesHoldSechdule', 'SalesHoldSechdule');
                    Route:: get('RecivedSales/{id}', 'RecivedSales');
                    Route:: get('RecivedSalesProductsPrint/{id}', 'RecivedSalesProductsPrint');
                    Route:: post('PostRecivedSales/{id}', 'PostRecivedSales');
                    Route:: get('RecivedProductsSales', 'RecivedProductsSales');
                    Route:: get('FilterBillSalesHold', 'FilterBillSalesHold');


                    //Return Sales
                    Route:: get('ReturnSales/{id}', 'ReturnSales');
                    Route:: post('PostReturn_Sales/{id}', 'PostReturn_Sales');
                    Route:: get('ReturnSalesSechdule', 'ReturnSalesSechdulePage');
                    Route:: get('FilterReturnSalesSechdule', 'FilterReturnSalesSechdule');
                    Route:: get('ReturnSalesSechduleTaxPage', 'ReturnSalesSechduleTaxPage');
                    Route:: get('ReturnSalesPrint/{id}', 'ReturnSalesPrint');
                    Route:: get('ReturnSalesPrint8/{id}', 'ReturnSalesPrint8');



                    //SalesSubscribes
                    Route:: get('SalesSubscribes', 'SalesSubscribesPage');
                    Route:: get('SalesSubscribeFilter', 'SalesSubscribeFilter');
                    Route:: get('EditSalesSubscribes/SalesSubscribeFilter', 'SalesSubscribeFilter');
                    Route:: post('AddSalesSubscribes', 'AddSalesSubscribes');
                    Route:: get('SalesSubscribesSechdule', 'SalesSubscribesSechdule');
                    Route:: get('SalesSubscribesPrint/{id}', 'SalesSubscribesPrint');
                    Route:: get('DeleteSalesSubscribes/{id}', 'DeleteSalesSubscribes');
                    Route:: get('EditSalesSubscribes/{id}', 'EditSalesSubscribes');
                    Route:: post('PostEditSalesSubscribes/{id}', 'PostEditSalesSubscribes');


                    // ============= JobOrder ==================

                    //job order
                    Route:: get('JobOrder', 'JobOrder');
                    Route:: get('JobOrderProductsFilter', 'JobOrderProductsFilter');
                    Route:: post('AddJobOrder', 'AddJobOrder');
                    Route:: get('JobOrderPrint/{id}', 'JobOrderPrint');
                    Route:: get('JobOrderPrint8/{id}', 'JobOrderPrint8');
                    Route:: get('JobOrderPrint5/{id}', 'JobOrderPrint5');
                    Route:: get('DeleteJobOrder/{id}', 'DeleteJobOrder');
                    Route:: get('JobOrderPrintEmp8/{id}', 'JobOrderPrintEmp8');
                    Route:: get('JobOrderPrintEmp/{id}', 'JobOrderPrintEmp');
                    Route:: get('JobOrderSechdule', 'JobOrderSechdule');
                    Route:: post('EditJobOrder', 'EditJobOrder');
                    Route:: post('PostEditJobOrder', 'PostEditJobOrder');

                    //ExecuteJobOrder
                    Route:: post('ExecuteJobOrder', 'ExecuteJobOrder');
                    Route:: get('ExecuteJobOrderFilter', 'ExecuteJobOrderFilter');
                    Route:: post('PostExecuteJobOrder', 'PostExecuteJobOrder');
                    Route:: get('DeleteExecuteJobOrder/{id}', 'DeleteExecuteJobOrder');
                    Route:: get('ExecuteJobOrderPrint/{id}', 'ExecuteJobOrderPrint');
                    Route:: get('ExecuteJobOrderPrint8/{id}', 'ExecuteJobOrderPrint8');
                    Route:: get('ExecuteJobOrderSechdule', 'ExecuteJobOrderSechdule');
                    Route:: post('ExecuteJobOrderExe', 'ExecuteJobOrderExe');
                    Route:: post('PostExecuteJobOrderExe', 'PostExecuteJobOrderExe');
                    Route:: get('ExecuteJobOrderTransfer', 'ExecuteJobOrderTransfer');
                    Route:: post('PostTransExcuteSales', 'PostTransExcuteSales');




                    //==========================================


                    //ReturnWithoutBill
                    Route:: get('SechduleReturnWithoutBill', 'SechduleReturnWithoutBill');
                    Route:: get('ReturnWithoutBill', 'ReturnWithoutBill');
                    Route:: post('AddReturnWithoutBill', 'AddReturnWithoutBill');
                    Route:: get('ReturnWithoutBillFilter', 'ReturnWithoutBillFilter');
                    Route:: get('DeleteReturnWithoutBill/{id}', 'DeleteReturnWithoutBill');
                    Route:: get('ReturnWithoutPrint/{id}', 'ReturnWithoutPrint');

                    //TransferWithoutBill
                    Route:: get('TransferWithoutBill', 'TransferWithoutBill');
                    Route:: post('AddTransferWithoutBill', 'AddTransferWithoutBill');



                    //StorePriceList
                    Route:: get('StorePriceList', 'StorePriceList');
                    Route:: post('PriceListFilter', 'PriceListFilter');


                    //Gifts
                    Route:: get('SalesGiftsSechdule', 'SalesGiftsSechdule');
                    Route:: get('SalesGiftPrint/{id}', 'SalesGiftPrint');
                    Route:: get('SalesGifts', 'SalesGifts');
                    Route:: get('SalesGiftsFilter', 'SalesGiftsFilter');
                    Route:: get('EditSalesGifts/SalesGiftsFilter', 'SalesGiftsFilter');
                    Route:: get('DeleteSalesGifts/{id}', 'DeleteSalesGifts');
                    Route:: get('EditSalesGifts/{id}', 'EditSalesGifts');
                    Route:: post('PostEditSalesGifts', 'PostEditSalesGifts');
                    Route:: post('AddSalesGift', 'AddSalesGift');



                });


//======== End Sales ======================================================================================================


//======== Resturant ======================================================================================================

                Route::controller(ResturantController:: class)->group( function () {

                    //Tables
                    Route:: get('Tables', 'Tables');
                    Route:: post('AddTables', 'AddTables');
                    Route:: post('EditTables/{id}', 'EditTables');
                    Route:: get('DeleteTables/{id}', 'DeleteTables');


                    //  =============  View  ===================

                    //Resturant WebSlider
                    Route:: get('RWebSlider', 'RWebSlider');
                    Route:: post('AddRWebSlider', 'AddRWebSlider');
                    Route:: post('EditRWebSlider/{id}', 'EditRWebSlider');
                    Route:: get('DeleteRWebSlider/{id}', 'DeleteRWebSlider');
                    Route:: get('UnActiveRSlider/{id}', 'UnActiveRSlider');
                    Route:: get('ActiveRSlider/{id}', 'ActiveRSlider');

                    //Resturant SocialMedia
                    Route:: get('RSocialMedia', 'RSocialMedia');
                    Route:: post('RSocialMediaUpdate/{id}', 'RSocialMediaUpdate');

                    //Resturant Articles
                    Route:: get('RArticles', 'RArticles');
                    Route:: post('AddRArticles', 'AddRArticles');
                    Route:: post('EditRArticles/{id}', 'EditRArticles');
                    Route:: get('DeleteRArticles/{id}', 'DeleteRArticles');

                    //Resturant Polices
                    Route:: get('RPolices', 'RPolices');
                    Route:: post('UpdateRPolices/{id}', 'UpdateRPolices');

                    //Resturant Terms
                    Route:: get('RTerms', 'RTerms');
                    Route:: post('UpdateRTerms/{id}', 'UpdateRTerms');


                    //Resturant CouponCode
                    Route:: get('RCouponCode', 'RCouponCode');
                    Route:: post('AddRCouponCode', 'AddRCouponCode');
                    Route:: post('EditRCouponCode/{id}', 'EditRCouponCode');
                    Route:: get('DeleteRCouponCode/{id}', 'DeleteRCouponCode');

                    //Resturant Gallery
                    Route:: get('RGallery', 'RGallery');
                    Route:: post('AddRGallery', 'AddRGallery');
                    Route:: post('EditRGallery/{id}', 'EditRGallery');
                    Route:: get('DeleteRGallery/{id}', 'DeleteRGallery');

                    //Resturant Reviews
                    Route:: get('RReviews', 'RReviews');
                    Route:: post('AddRReviews', 'AddRReviews');
                    Route:: post('EditRReviews/{id}', 'EditRReviews');
                    Route:: get('DeleteRReviews/{id}', 'DeleteRReviews');

                    //Reservations
                    Route:: get('RReservations', 'RReservations');
                    Route:: get('DeleteRReservations/{id}', 'DeleteRReservations');
                    Route:: get('UnApproveResrvations/{id}', 'UnApproveResrvations');
                    Route:: get('ApproveResrvations/{id}', 'ApproveResrvations');


                    //ResturantHome
                    Route:: get('ResturantHome', 'ResturantHome');
                    Route:: post('UpdateResturantHome/{id}', 'UpdateResturantHome');

                    //RAbout
                    Route:: get('RAbout', 'RAbout');
                    Route:: post('UpdateRAbout/{id}', 'UpdateRAbout');

                    //VideoSection
                    Route:: get('VideoSection', 'VideoSection');
                    Route:: post('UpdateVideoSection/{id}', 'UpdateVideoSection');

                    //ResturantStyle
                    Route:: get('ResturantStyle', 'ResturantStyle');
                    Route:: post('UpdateResturantStyle/{id}', 'UpdateResturantStyle');
                    Route:: post('UpdateResturantStyleIndexI/{id}', 'UpdateResturantStyleIndexI');
                    Route:: post('UpdateResturantStyleIndexII/{id}', 'UpdateResturantStyleIndexII');
                    Route:: post('UpdateResturantStyleNavbar/{id}', 'UpdateResturantStyleNavbar');
                    Route:: post('UpdateResturantStyleSupPage/{id}', 'UpdateResturantStyleSupPage');
                    Route:: post('UpdateResturantStyleCart/{id}', 'UpdateResturantStyleCart');
                    Route:: post('UpdateResturantStyleMenu/{id}', 'UpdateResturantStyleMenu');

                    //  ============= End  View  ===================



                    // --------------------  Resturant Orders -------------------

                    //ResturantSales
                    Route:: get('ResturantSales', 'ResturantSales');
                    Route:: post('PostResturantOrder', 'PostResturantOrder');
                    Route:: get('ResturantSalesSechdule', 'ResturantSalesSechdule');
                    Route:: get('ResturantSalesHoldSechdule', 'ResturantSalesHoldSechdule');
                    Route:: post('PostEditResturant', 'PostEditResturant');



                    //Filters
                    Route:: get('SalesProductsResturantFilter', 'SalesProductsResturantFilter');
                    Route:: get('SalesProductsResturantSearchCodeFilter', 'SalesProductsResturantSearchCodeFilter');
                    Route:: get('SalesHoldBillsResturantFilter', 'SalesHoldBillsResturantFilter');
                    Route:: get('GroupResturantFilter', 'GroupResturantFilter');
                    Route:: get('BrandsResturantFilter', 'BrandsResturantFilter');
                    Route:: get('AllProsResturantFilter', 'AllProsResturantFilter');
                    Route:: get('AdditonsProsFilter', 'AdditonsProsFilter');
                    Route:: get('NoteProsFilter', 'NoteProsFilter');
                    Route:: get('AddNewNoteAjax', 'AddNewNoteAjax');
                    Route:: get('AVFilter', 'AVFilter');
                    Route:: get('CheckQtyAVFilter', 'CheckQtyAVFilter');
                    Route:: get('NewAddAVFilter', 'NewAddAVFilter');
                    Route:: get('DeleteCheckQtyAVFilter', 'DeleteCheckQtyAVFilter');

                    //Tables AJax
                    Route:: get('AllTables', 'AllTables');
                    Route:: get('AllTablesJ/{id}', 'AllTablesJ');
                    Route:: get('AddNewTableAjax', 'AddNewTableAjax');
                    Route:: get('AllReservedTables', 'AllReservedTables');
                    Route:: get('MergeDataTables', 'MergeDataTables');
                    Route:: get('SeparatingDataTables', 'SeparatingDataTables');
                    Route:: get('MovingDataTables', 'MovingDataTables');
                    Route:: get('PostMerge', 'PostMerge');
                    Route:: get('PostMoving', 'PostMoving');
                    Route:: get('PostSeparating', 'PostSeparating');


                    //Hold Sales Hall
                    Route:: get('HoldSaleHall', 'HoldSaleHall');
                    Route:: post('PostResturantHoldHall', 'PostResturantHoldHall');
                    Route:: get('CheckEmailPasstoDelete', 'CheckEmailPasstoDelete');


                    //Hold Sales Resturant
                    Route:: get('HoldSaleResturant', 'HoldSaleResturant');
                    Route:: post('PostResturantHold', 'PostResturantHold');

                    //Kitchen Screen
                    Route:: get('KitchenScreen', 'KitchenScreen');
                    Route:: get('EndKitchenOrder/{id}', 'EndKitchenOrder');
                    Route:: get('PrintKitchen/{id}', 'PrintKitchen');
                    Route:: get('EndKitchenOrderHall/{id}', 'EndKitchenOrderHall');
                    Route:: get('PrintKitchenHall/{id}', 'PrintKitchenHall');
                    Route:: get('EndKitchenOrderHallMore/{id}', 'EndKitchenOrderHallMore');
                    Route:: get('PrintKitchenHallMore/{id}', 'PrintKitchenHallMore');
                    Route:: get('EndKitchenOrderHallRemove/{id}', 'EndKitchenOrderHallRemove');
                    Route:: get('PrintKitchenHallRemove/{id}', 'PrintKitchenHallRemove');

                    //Recived Screen
                    Route:: get('RecivedScreen', 'RecivedScreen');
                    Route:: get('EndRecivedOrder/{id}', 'EndRecivedOrder');
                    Route:: get('PrintRecived/{id}', 'PrintRecived');
                    Route:: get('EndRecivedOrderHall/{id}', 'EndRecivedOrderHall');
                    Route:: get('PrintRecivedHall/{id}', 'PrintRecivedHall');
                    Route:: get('SalesPrintHall/{id}', 'SalesPrintHall');
                    Route:: get('SalesPrintHall8/{id}', 'SalesPrintHall8');
                    Route:: post('PostEndRecivedOrderHall', 'PostEndRecivedOrderHall');

                    //Resturant Orders
                    Route:: get('ResturantOrders', 'ResturantOrders');
                    Route:: get('EditSalesOrderResturant', 'EditSalesOrderResturant');


                });



//======== End Resturant ======================================================================================================

//========== CRM  =========================================================================================================

                Route::controller(CRMController:: class)->group( function () {

                    //Countris
                    Route:: get('Countris', 'CountrisPage');
                    Route:: post('AddCountris', 'AddCountris');
                    Route:: post('EditCountris/{id}', 'EditCountris');
                    Route:: get('DeleteCountris/{id}', 'DeleteCountris');


                    //Governrate
                    Route:: get('Governrate', 'GovernratePage');
                    Route:: post('AddGovernrate', 'AddGovernrate');
                    Route:: post('EditGovernrate/{id}', 'EditGovernrate');
                    Route:: get('DeleteGovernrate/{id}', 'DeleteGovernrate');

                    //City
                    Route:: get('City/{id}', 'CityPage');
                    Route:: post('AddCity', 'AddCity');
                    Route:: post('EditCity/{id}', 'EditCity');
                    Route:: get('DeleteCity/{id}', 'DeleteCity');

                    //Places
                    Route:: get('Places/{id}', 'PlacesPage');
                    Route:: post('AddPlaces', 'AddPlaces');
                    Route:: post('EditPlaces/{id}', 'EditPlaces');
                    Route:: get('DeletePlaces/{id}', 'DeletePlaces');

                    //Activites
                    Route:: get('Activites', 'ActivitesPage');
                    Route:: post('AddActivites', 'AddActivites');
                    Route:: post('EditActivites/{id}', 'EditActivites');
                    Route:: get('DeleteActivites/{id}', 'DeleteActivites');

                    //Clients_Status
                    Route:: get('Clients_Status', 'Clients_StatusPage');
                    Route:: post('AddClients_Status', 'AddClients_Status');
                    Route:: post('EditClients_Status/{id}', 'EditClients_Status');
                    Route:: get('DeleteClients_Status/{id}', 'DeleteClients_Status');

                    //Platforms
                    Route:: get('Platforms', 'PlatformsPage');
                    Route:: post('AddPlatforms', 'AddPlatforms');
                    Route:: post('EditPlatforms/{id}', 'EditPlatforms');
                    Route:: get('DeletePlatforms/{id}', 'DeletePlatforms');

                    //Campaigns
                    Route:: get('Campaigns/{id}', 'CampaignsPage');
                    Route:: post('AddCampaigns', 'AddCampaigns');
                    Route:: post('EditCampaigns/{id}', 'EditCampaigns');
                    Route:: get('DeleteCampaigns/{id}', 'DeleteCampaigns');

                    //Interviews_Types
                    Route:: get('Interviews_Types', 'Interviews_TypesPage');
                    Route:: post('AddInterviews_Types', 'AddInterviews_Types');
                    Route:: post('EditInterviews_Types/{id}', 'EditInterviews_Types');
                    Route:: get('DeleteInterviews_Types/{id}', 'DeleteInterviews_Types');

                    //Customers Rate Types
                    Route:: get('CustomersRateTypes', 'CustomersRateTypes');
                    Route:: post('AddCustomersRateTypes', 'AddCustomersRateTypes');
                    Route:: post('EditCustomersRateTypes/{id}', 'EditCustomersRateTypes');
                    Route:: get('DeleteCustomersRateTypes/{id}', 'DeleteCustomersRateTypes');


                    //Interviews
                    Route:: get('Interviews', 'InterviewsPage');
                    Route:: post('AddInterviews', 'AddInterviews');
                    Route:: post('EditInterviews/{id}', 'EditInterviews');
                    Route:: get('DeleteInterviews/{id}', 'DeleteInterviews');
                    Route:: get('NotDone/{id}', 'NotDone');
                    Route:: get('Done/{id}', 'Done');
                    Route:: get('AllClients', 'AllClients');
                    Route:: get('Rate/{id}', 'Rate');
                    Route:: get('FilterInterviews', 'FilterInterviews');
                    Route:: get('AddNewClientAjax', 'AddNewClientAjax');

                    //Projects
                    Route:: get('Projects', 'ProjectsPage');
                    Route:: post('AddProjects', 'AddProjects');
                    Route:: post('EditProjects/{id}', 'EditProjects');
                    Route:: get('DeleteProjects/{id}', 'DeleteProjects');
                    Route:: get('EndProject/{id}', 'EndProject');

                    //Missions
                    Route:: get('MyMissions', 'MyMissions');
                    Route:: get('Missions', 'MissionsPage');
                    Route:: post('AddMissions', 'AddMissions');
                    Route:: post('EditMissions/{id}', 'EditMissions');
                    Route:: get('DeleteMissions/{id}', 'DeleteMissions');
                    Route:: get('SureMission/{id}', 'SureMission');
                    Route:: get('SureMissionByEmp/{id}', 'SureMissionByEmp');
                    Route:: post('AcceptMission', 'AcceptMission');

                    //PerivousMettings
                    Route:: get('PerivousMettings', 'PerivousMettings');
                    Route:: post('AddNEWInterviews', 'AddNEWInterviews');


                    //Competitors
                    Route:: get('Competitors', 'Competitors');
                    Route:: post('AddCompetitors', 'AddCompetitors');
                    Route:: post('EditCompetitors/{id}', 'EditCompetitors');
                    Route:: get('DeleteCompetitors/{id}', 'DeleteCompetitors');

                    //MyMettings
                    Route:: get('MyMettings', 'MyMettingsPage');

                    //Customerـfollowـup
                    Route:: get('Customerـfollowـup', 'Customerـfollowـup');
                    Route:: get('FilterCustomerـfollowـup', 'FilterCustomerـfollowـup');
                    Route:: post('AddCustomerـfollowـup', 'AddCustomerـfollowـup');
                    Route:: post('EditCustomerـfollowـup/{id}', 'EditCustomerـfollowـup');
                    Route:: get('DeleteCustomerـfollowـup/{id}', 'DeleteCustomerـfollowـup');


                    //Customerـfollowـup_Reports
                    Route:: get('Customerـfollowـup_Reports', 'Customerـfollowـup_Reports');
                    Route:: get('Customerـfollowـup_ReportsFilter', 'Customerـfollowـup_ReportsFilter');

                    //Customerـfollowـup
                    Route:: get('AddCommentCustomer', 'AddCommentCustomer');
                    Route:: post('PostAddCommentCustomer', 'PostAddCommentCustomer');


                    //Customer Period Report
                    Route:: get('CustomerPeriodReports', 'CustomerPeriodReport');
                    Route:: get('CustomerPeriodReportFilter', 'CustomerPeriodReportFilter');

                    //Comments  Reports
                    Route:: get('CommentsReports', 'CommentsReports');
                    Route:: get('CommentsReportsFilter', 'CommentsReportsFilter');

                    //Itinerary
                    Route:: get('Itinerary', 'Itinerary');
                    Route:: get('ItineraryEmp/{id}', 'ItineraryEmp');
                    Route:: post('AddItinerary', 'AddItinerary');
                    Route:: post('EditItinerary/{id}', 'EditItinerary');
                    Route:: get('DeleteItinerary/{id}', 'DeleteItinerary');
                    Route:: get('MyItinerary', 'MyItinerary');

                    //FollowList
                    Route:: get('FollowList', 'FollowList');
                    Route:: get('FollowListEmp/{id}', 'FollowListEmp');
                    Route:: get('FollowListSat/{id}', 'FollowListSat');
                    Route:: get('FollowListSun/{id}', 'FollowListSun');
                    Route:: get('FollowListMon/{id}', 'FollowListMon');
                    Route:: get('FollowListTue/{id}', 'FollowListTue');
                    Route:: get('FollowListWed/{id}', 'FollowListWed');
                    Route:: get('FollowListThr/{id}', 'FollowListThr');
                    Route:: get('FollowListFri/{id}', 'FollowListFri');



                    Route:: post('AddFollowList', 'AddFollowList');
                    Route:: post('EditFollowList/{id}', 'EditFollowList');
                    Route:: get('DeleteFollowList/{id}', 'DeleteFollowList');
                    Route:: get('MyFollowList', 'MyFollowList');
                    Route:: get('AddCommentFollow/{id}', 'AddCommentFollow');
                    Route:: post('AddCommentToClientFollow', 'AddCommentToClientFollow');

                    //DelegateVistsReport
                    Route:: get('DelegateVistsReport', 'DelegateVistsReport');
                    Route:: get('DelegateVistsReportFilter', 'DelegateVistsReportFilter');


                });

//=====  End CRM ==========================================================================================================


//=============== Reports =================================================================================================


                Route::controller(ReportController:: class)->group( function () {


                    //Product Informations
                    Route:: get('Product_Info', 'Product_InfoPage');
                    Route:: get('ProductInfoFilter', 'ProductInfoFilter');

                    //ProductOrderLimit
                    Route:: get('ProductOrderLimit', 'ProductOrderLimitPage');
                    Route:: get('ProductOrderLimitFilter', 'ProductOrderLimitFilter');
                    Route:: get('ProductOrderLimitFilterTwo', 'ProductOrderLimitFilterTwo');


                    //Report Start Period
                    Route:: get('ReportStartPeriod', 'ReportStartPeriodPage');
                    Route:: get('ReportProductStartFilter', 'ReportProductStartFilter');
                    Route:: get('ReportStartPeriodProductsFilterTwo', 'ReportStartPeriodProductsFilterTwo');


                    //AssemblyProQties
                    Route:: get('AssemblyProQties', 'AssemblyProQties');
                    Route:: get('AssemblyProQtiesFilterTwo', 'AssemblyProQtiesFilterTwo');


                    //SettlementsReports
                    Route:: get('SettlementsReports', 'SettlementsReportsPage');
                    Route:: get('ReportProductSettlementFilter', 'ReportProductSettlementFilter');
                    Route:: get('SettlementsReportsFilterTwo', 'SettlementsReportsFilterTwo');


                    //StoresCost
                    Route:: get('StoresCost', 'StoresCostPage');
                    Route:: get('StoresCostFilter', 'StoresCostFilter');
                    Route:: get('StoresCostFilterTwo', 'StoresCostFilterTwo');


                    //CreditStores
                    Route:: get('CreditStores', 'CreditStores');
                    Route:: get('CreditStoresFilterTwo', 'CreditStoresFilterTwo');


                    //StoresInventory
                    Route:: get('StoresInventory', 'StoresInventoryPage');
                    Route:: get('StoresInventoryFilter', 'StoresInventoryFilter');
                    Route:: get('StoresInventoryFilterTwo', 'StoresInventoryFilterTwo');
                    Route:: get('StoresInventoryFilterTwoo', 'StoresInventoryFilterTwoo');


                    //StagnantItems
                    Route:: get('StagnantItems', 'StagnantItemsPage');
                    Route:: get('StegnantProductsFilter', 'StegnantProductsFilter');
                    Route:: get('StagnantItemsFilterTwo', 'StagnantItemsFilterTwo');

                    //ItemsMoves
                    Route:: get('ItemsMoves', 'ItemsMovesPage');
                    Route:: get('ProductsMovesFilter', 'ProductsMovesFilter');
                    Route:: get('ItemsMovesFilterTwo', 'ItemsMovesFilterTwo');


                    //TotalExpensesSafes
                    Route:: get('TotalExpensesSafes', 'TotalExpensesSafes');
                    Route:: get('TotalExpensesSafesFilter', 'TotalExpensesSafesFilter');


                    //StoresBalances
                    Route:: get('StoresBalances', 'StoresBalancesPage');
                    Route:: get('StoresBalanceFilter', 'StoresBalanceFilter');
                    Route:: get('StoresBalancesFilterTwo', 'StoresBalancesFilterTwo');

                    //NetPurchases
                    Route:: get('NetPurchases', 'NetPurchasesPage');
                    Route:: get('NetPurchasesFilter', 'NetPurchasesFilter');
                    Route:: get('NetPurchasesFilterTwo', 'NetPurchasesFilterTwo');


                    //NetSales
                    Route:: get('NetSales', 'NetSalesPage');
                    Route:: get('NetSalesFilter', 'NetSalesFilter');
                    Route:: get('NetSalesFilterTwo', 'NetSalesFilterTwo');

                    //TotalNetPurchases
                    Route:: get('TotalNetPurchases', 'TotalNetPurchasesPage');
                    Route:: get('TotalNetPurchasesFilter', 'TotalNetPurchasesFilter');
                    Route:: get('TotalNetPurchasesFilterTwo', 'TotalNetPurchasesFilterTwo');


                    //TotalNetSales
                    Route:: get('TotalNetSales', 'TotalNetSalesPage');
                    Route:: get('TotalNetSalesFilter', 'TotalNetSalesFilter');
                    Route:: get('TotalNetSalesFilterTwo', 'TotalNetSalesFilterTwo');


                    //Profits
                    Route:: get('Profits', 'ProfitsPage');
                    Route:: get('ProfitsFilterrr', 'ProfitsFilter');
                    Route:: get('ProfitsFilterTwo', 'ProfitsFilterTwo');


                    //ProductProfits
                    Route:: get('ProductProfits', 'ProductProfits');
                    Route:: get('ProductProfitsFilter', 'ProductProfitsFilter');
                    Route:: get('ProductsFilterTwo', 'ProductsFilterTwo');

                    //ProductProfitsNew
                    Route:: get('ProductProfitsNew', 'ProductProfitsNew');
                    Route:: get('ProductProfitsNewFilter', 'ProductProfitsNewFilter');
                    Route:: get('ExceptProductProfitsNewFilterTwo', 'ExceptProductProfitsNewFilterTwo');


                    //ShiftsReport
                    Route:: get('ShiftsReport', 'ShiftsReportPage');
                    Route:: get('ShiftReportFilter', 'ShiftReportFilter');


                    //ShiftsDetailsReport
                    Route:: get('ShiftsDetailsReport', 'ShiftsDetailsReportPage');
                    Route:: get('FilterShiftDetails', 'FilterShiftDetails');

                    //ProductsReports
                    Route:: get('ProductsReports', 'ProductsReportsPage');
                    Route:: get('ProductsReportFilter', 'ProductsReportFilter');
                    Route:: get('ExpensesReportFilterTwo', 'ExpensesReportFilterTwo');
                    Route:: get('EmployeeCommissionDiscountsFilterTwo', 'EmployeeCommissionDiscountsFilterTwo');
                    Route:: get('ExceptProfitsFilterTwo', 'ExceptProfitsFilterTwo');
                    Route:: get('ExceptProductProfitsFilterTwo', 'ExceptProductProfitsFilterTwo');


                    //DailyShifts
                    Route:: get('DailyShifts', 'DailyShiftsPage');
                    Route:: get('DailyShiftsFilter', 'DailyShiftsFilter');

                    //ExpensesReport
                    Route:: get('ExpensesReport', 'ExpensesReportPage');
                    Route:: get('FilterExpensesReport', 'FilterExpensesReport');

                    //DailyProducts
                    Route:: get('DailyProducts', 'DailyProductsPage');
                    Route:: get('DailyProductsFilter', 'DailyProductsFilter');

                    //EmployeeCommissionDiscounts
                    Route:: get('EmployeeCommissionDiscounts', 'EmployeeCommissionDiscountsPage');
                    Route:: get('EmpCommisionFilter', 'EmpCommisionFilter');


                    //VendorPricesReport
                    Route:: get('VendorPricesReport', 'VendorPricesReportPage');
                    Route:: get('VendorPricesReportFilter', 'VendorPricesReportFilter');


                    //GroupsSales
                    Route:: get('GroupsSales', 'GroupsSalesPage');
                    Route:: get('GroupsSalesFilter', 'GroupsSalesFilter');


                    //BrandsSales
                    Route:: get('BrandsSales', 'BrandsSales');
                    Route:: get('BrandsSalesFilter', 'BrandsSalesFilter');


                    //Collection_Delegates
                    Route:: get('Collection_Delegates', 'Collection_DelegatesPage');
                    Route:: get('FilterCollection_Delegates', 'FilterCollection_Delegates');

                    //Sales_Delegates
                    Route:: get('Sales_Delegates', 'Sales_DelegatesPage');
                    Route:: get('FilterSales_Delegates', 'FilterSales_Delegates');
                    Route:: get('Sales_DelegatesFilterTwo', 'Sales_DelegatesFilterTwo');

                    //ClientSales
                    Route:: get('ClientSales', 'ClientSalesPage');
                    Route:: get('ClientSalesFilter', 'ClientSalesFilter');
                    Route:: get('ClientSalesFilterTwo', 'ClientSalesFilterTwo');


                    //DelegateSalesDetails
                    Route:: get('DelegateSalesDetails', 'DelegateSalesDetails');
                    Route:: get('DelegateSalesDetailsFilter', 'DelegateSalesDetailsFilter');


                    //StoresSalesDetails
                    Route:: get('StoresSalesDetails', 'StoresSalesDetails');
                    Route:: get('StoresSalesDetailsFilter', 'StoresSalesDetailsFilter');


                    //DailyMoves
                    Route:: get('DailyMoves', 'DailyMovesPage');
                    Route:: get('DailyMovesFilter', 'DailyMovesFilter');

                    //VendorPurchases
                    Route:: get('VendorPurchases', 'VendorPurchasesPage');
                    Route:: get('VendorPurchasesFilter', 'VendorPurchasesFilter');

                    //ExecutorSales
                    Route:: get('ExecutorSales', 'ExecutorSales');
                    Route:: get('ExecutorSalesFilter', 'ExecutorSalesFilter');


                    //InstallmentReport
                    Route:: get('InstallmentReport', 'InstallmentReport');
                    Route:: get('InstallmentReportFilter', 'InstallmentReportFilter');
                    Route:: get('InstallmentReportFilterTwo', 'InstallmentReportFilterTwo');

                    //ExceptProfits
                    Route:: get('ExceptProfits', 'ExceptProfits');
                    Route:: get('ExceptProfitsFilter', 'ExceptProfitsFilter');


                    //ExpiredProucts
                    Route:: get('ExpiredProucts', 'ExpiredProucts');
                    Route:: get('ExpiredProuctsFilter', 'ExpiredProuctsFilter');
                    Route:: get('ExpiredProuctsFilterTwo', 'ExpiredProuctsFilterTwo');

                    //TotalDailyMoves
                    Route:: get('TotalDailyMoves', 'TotalDailyMoves');
                    Route:: get('TotalDailyMovesFilter', 'TotalDailyMovesFilter');


                    //ProfitGroupsReport
                    Route:: get('ProfitGroupsReport', 'ProfitGroupsReport');
                    Route:: get('ProfitGroupsReportFilter', 'ProfitGroupsReportFilter');


                    //DailyClosing
                    Route:: get('DailyClosing', 'DailyClosingPage');
                    Route:: get('FilterDailyClosing', 'FilterDailyClosing');
                    Route:: get('FilterSalesDetailsDailyClosing', 'FilterSalesDetailsDailyClosing');
                    Route:: get('FilterRSalesDetailsDailyClosing', 'FilterRSalesDetailsDailyClosing');
                    Route:: get('FilterReciptDetailsDailyClosing', 'FilterReciptDetailsDailyClosing');
                    Route:: get('FilterTransferTotDetailsDailyClosing', 'FilterTransferTotDetailsDailyClosing');
                    Route:: get('FilterPaymenttDetailsDailyClosing', 'FilterPaymenttDetailsDailyClosing');
                    Route:: get('FilterPurchasesDetailsDailyClosing', 'FilterPurchasesDetailsDailyClosing');
                    Route:: get('FilterRPurchasesDetailsDailyClosing', 'FilterRPurchasesDetailsDailyClosing');
                    Route:: get('FilterTransferFromDetailsDailyClosing', 'FilterTransferFromDetailsDailyClosing');
                    Route:: get('FilterImportChecksDetailsDailyClosing', 'FilterImportChecksDetailsDailyClosing');
                    Route:: get('FilterSettlement3agzDetailsDailyClosing', 'FilterSettlement3agzDetailsDailyClosing');
                    Route:: get('FilterWaslDetailsDailyClosing', 'FilterWaslDetailsDailyClosing');
                    Route:: get('FilterPetrolDetailsDailyClosing', 'FilterPetrolDetailsDailyClosing');
                    Route:: get('FilterShippingDetailsDailyClosing', 'FilterShippingDetailsDailyClosing');
                    Route:: get('FilterMaintainceDetailsDailyClosing', 'FilterMaintainceDetailsDailyClosing');
                    Route:: get('FilterExportChecksDetailsDailyClosing', 'FilterExportChecksDetailsDailyClosing');
                    Route:: get('FilterSettlementZyadaDetailsDailyClosing', 'FilterSettlementZyadaDetailsDailyClosing');
                    Route:: get('FilterRMaintainceDetailsDailyClosing', 'FilterRMaintainceDetailsDailyClosing');
                    Route:: get('FilterSalaryDetailsDailyClosing', 'FilterSalaryDetailsDailyClosing');
                    Route:: get('FilterBorrowDetailsDailyClosing', 'FilterBorrowDetailsDailyClosing');
                    Route:: get('FilterLoanDetailsDailyClosing', 'FilterLoanDetailsDailyClosing');
                    Route:: get('FilterExchangeDetailsDailyClosing', 'FilterExchangeDetailsDailyClosing');
                    Route:: get('FilterAssetsDetailsDailyClosing', 'FilterAssetsDetailsDailyClosing');
                    Route:: get('FilterDailyClosingForm', 'FilterDailyClosingForm');


                    //Pages
                    Route:: get('ItemBalances', 'ItemBalances');
                    Route:: get('ItemsCostsReportGroup', 'ItemsCostsReportGroup');
                    Route:: get('ItemsMovesReportGroup', 'ItemsMovesReportGroup');
                    Route:: get('ProfitsReportGroup', 'ProfitsReportGroup');
                    Route:: get('SalesReportGroup', 'SalesReportGroup');
                    Route:: get('PurchasesReportGroup', 'PurchasesReportGroup');
                    Route:: get('ShiftsReportGroup', 'ShiftsReportGroup');
                    Route:: get('StoresReportGroup', 'StoresReportGroup');
                    Route:: get('DelegatesReportGroup', 'DelegatesReportGroup');
                    Route:: get('ReviewReportGroup', 'ReviewReportGroup');



                });



                //New Reports =========================================


                Route::controller(NewReportController:: class)->group( function () {



                    //SalesBills
                    Route:: get('SalesBills', 'SalesBills');
                    Route:: post('SalesBillFilter', 'SalesBillFilter');
                    Route:: get('SalesBillFilterNeww', 'SalesBillFilterNeww');
                    Route:: get('SaveDefaultColumnsSalesBills', 'SaveDefaultColumnsSalesBills');
                    Route:: get('SalesBillsReportPrint/{type}', 'SalesBillsReportPrint');

                    //MaintanceSalesReport
                    Route:: get('MaintanceSalesReport', 'MaintanceSalesReport');
                    Route:: get('MaintanceSalesReportFilterTwo', 'MaintanceSalesReportFilterTwo');

                    //Maintenance_Tune
                    Route:: get('Maintenance_Tune', 'Maintenance_Tune');
                    Route:: get('Maintenance_TuneFilterTwo', 'Maintenance_TuneFilterTwo');


                    //PurchasesBills
                    Route:: get('PurchasesBills', 'PurchasesBills');
                    Route:: post('PurchasesBillsFilter', 'PurchasesBillsFilter');
                    Route:: get('PurchasesBillsFilterNeww', 'PurchasesBillsFilterNeww');
                    Route:: get('SaveDefaultColumnsPurchasesBills', 'SaveDefaultColumnsPurchasesBills');
                    Route:: get('PurchasesBillsReportPrint/{type}', 'PurchasesBillsReportPrint');

                    //StoresTransferReport
                    Route:: get('StoresTransferReport', 'StoresTransferReport');
                    Route:: post('StoresTransferReportFilter', 'StoresTransferReportFilter');
                    Route:: get('StoresTransferReportFilterNeww', 'StoresTransferReportFilterNeww');
                    Route:: get('SaveDefaultColumnsStoresTransferReport', 'SaveDefaultColumnsStoresTransferReport');
                    Route:: get('StoresTransferReportPrint', 'StoresTransferReportPrint');

                    //SafesTransferReport
                    Route:: get('SafesTransferReport', 'SafesTransferReport');
                    Route:: post('SafesTransferReportFilter', 'SafesTransferReportFilter');
                    Route:: get('SafesTransferReportFilterNeww', 'SafesTransferReportFilterNeww');
                    Route:: get('SaveDefaultColumnsSafesTransferReport', 'SaveDefaultColumnsSafesTransferReport');
                    Route:: get('SafesTransferReportPrint', 'SafesTransferReportPrint');


                    //StoresMovesReport
                    Route:: get('StoresMovesReport', 'StoresMovesReport');
                    Route:: post('StoresMovesReportFilter', 'StoresMovesReportFilter');
                    Route:: get('StoresMovesReportFilterNeww', 'StoresMovesReportFilterNeww');
                    Route:: get('SaveDefaultColumnsStoresMovesReport', 'SaveDefaultColumnsStoresMovesReport');
                    Route:: get('StoresMovesReportPrint', 'StoresMovesReportPrint');


                    //ProductMoveDetails
                    Route:: get('ProductMoveDetails', 'ProductMoveDetails');
                    Route:: post('ProductMoveDetailsFilter', 'ProductMoveDetailsFilter');
                    Route:: get('ProductMoveDetailsFilterNeww', 'ProductMoveDetailsFilterNeww');
                    Route:: get('SaveDefaultColumnsProductMoveDetails', 'SaveDefaultColumnsProductMoveDetails');
                    Route:: get('ProductMoveDetailsPrint', 'ProductMoveDetailsPrint');



                    //CompareSalesPrice
                    Route:: get('CompareSalesPrice', 'CompareSalesPrice');
                    Route:: post('CompareSalesPriceFilter', 'CompareSalesPriceFilter');
                    Route:: get('CompareSalesPriceFilterNeww', 'CompareSalesPriceFilterNeww');
                    Route:: get('SaveDefaultColumnsCompareSalesPrice', 'SaveDefaultColumnsCompareSalesPrice');
                    Route:: get('CompareSalesPricePrint', 'CompareSalesPricePrint');


                    //ProfitSalesProduct
                    Route:: get('ProfitSalesProduct', 'ProfitSalesProduct');
                    Route:: post('ProfitSalesProductFilter', 'ProfitSalesProductFilter');
                    Route:: get('ProfitSalesProductFilterNeww', 'ProfitSalesProductFilterNeww');
                    Route:: get('SaveDefaultColumnsProfitSalesProduct', 'SaveDefaultColumnsProfitSalesProduct');
                    Route:: get('ProfitSalesProductPrint', 'ProfitSalesProductPrint');


                    //ClientAccountStatement
                    Route:: get('ClientAccountStatement', 'ClientAccountStatement');
                    Route:: post('ClientAccountStatementFilter', 'ClientAccountStatementFilter');
                    Route:: get('ClientAccountStatementFilterNeww', 'ClientAccountStatementFilterNeww');
                    Route:: get('SaveDefaultClientStatement', 'SaveDefaultClientStatement');
                    Route:: get('ClientAccountStatementPrint', 'ClientAccountStatementPrint');


                    //MostSalesProducts
                    Route:: get('MostSalesProducts', 'MostSalesProducts');
                    Route:: post('MostSalesProductsFilter', 'MostSalesProductsFilter');
                    Route:: get('MostSalesProductsFilterNeww', 'MostSalesProductsFilterNeww');
                    Route:: get('SaveDefaultColumnsMostSalesProducts', 'SaveDefaultColumnsMostSalesProducts');
                    Route:: get('MostSalesProductsPrint', 'MostSalesProductsPrint');


                    //VendorAccountStatement
                    Route:: get('VendorAccountStatement', 'VendorAccountStatement');
                    Route:: post('VendorAccountStatementFilter', 'VendorAccountStatementFilter');
                    Route:: get('VendorAccountStatementFilterNeww', 'VendorAccountStatementFilterNeww');
                    Route:: get('SaveDefaultColumnsVendorAccountStatement', 'SaveDefaultColumnsVendorAccountStatement');
                    Route:: get('VendorAccountStatementPrint', 'VendorAccountStatementPrint');



                    //ClientsStatement
                    Route:: get('ClientsStatement', 'ClientsStatement');
                    Route:: post('ClientsStatementFilter', 'ClientsStatementFilter');
                    Route:: get('ClientsStatementFilterNew', 'ClientsStatementFilterNew');
                    Route:: get('SaveDefaultColumnsClientsStatement', 'SaveDefaultColumnsClientsStatement');
                    Route:: get('ClientsStatementPrint', 'ClientsStatementPrint');


                    //VendorsStatement
                    Route:: get('VendorsStatement', 'VendorsStatement');
                    Route:: post('VendorsStatementFilter', 'VendorsStatementFilter');
                    Route:: get('VendorsStatementFilterNeww', 'VendorsStatementFilterNeww');
                    Route:: get('SaveDefaultColumnsVendorsStatement', 'SaveDefaultColumnsVendorsStatement');
                    Route:: get('VendorsStatementPrint', 'VendorsStatementPrint');


                    //ExpensesList
                    Route:: get('ExpensesList', 'ExpensesList');
                    Route:: post('ExpensesListFilter', 'ExpensesListFilter');
                    Route:: get('ExpensesListFilterNeww', 'ExpensesListFilterNeww');
                    Route:: get('ExpensesListFilterNewwPrint', 'ExpensesListFilterNewwPrint');
                    Route:: get('SaveDefaultColumnsExpensesList', 'SaveDefaultColumnsExpensesList');
                    Route:: get('ExpensesListPrint', 'ExpensesListPrint');


                    //IncomListReport
                    Route:: get('IncomListReport', 'IncomListReport');
                    Route:: post('IncomListReportFilter', 'IncomListReportFilter');
                    Route:: get('IncomListReportFilterNeww', 'IncomListReportFilterNeww');
                    Route:: get('IncomListReportPrint', 'IncomListReportPrint');


                    //StoresCostNew
                    Route:: get('StoresCostNew', 'StoresCostNew');
                    Route:: get('StoresCostNewFilter', 'StoresCostNewFilter');
                    Route:: get('StoresCostNewPrint', 'StoresCostNewPrint');

                    //SubIncomList
                    Route:: get('SubIncomList', 'SubIncomList');
                    Route:: get('SubIncomListFilter', 'SubIncomListFilter');

                    //EmpGoals
                    Route:: get('EmpGoals', 'EmpGoals');
                    Route:: post('EmpGoalsFilter', 'EmpGoalsFilter');
                    Route:: get('EmpGoalsFilterNeww', 'EmpGoalsFilterNeww');


                    //InventorySerial
                    Route:: get('InventorySerial', 'InventorySerial');
                    Route:: post('InventorySerialFilter', 'InventorySerialFilter');
                    Route:: get('InventorySerialFilterNeww', 'InventorySerialFilterNeww');


                    //StoresBalancesNew
                    Route:: get('StoresBalancesNew', 'StoresBalancesNew');
                    Route:: post('StoresBalancesNewFilter', 'StoresBalancesNewFilter');
                    Route:: get('StoresBalancesNewFilterNeww', 'StoresBalancesNewFilterNeww');
                    Route:: get('StoresBalancesNewPrint', 'StoresBalancesNewPrint');


                    //StoresBalancesCat
                    Route:: get('StoresBalancesCatNew', 'StoresBalancesCat');
                    Route:: post('StoresBalancesCatFilter', 'StoresBalancesCatFilter');
                    Route:: get('StoresBalancesCatFilterNeww', 'StoresBalancesCatFilterNeww');
                    Route:: get('StoresBalancesCatPrint', 'StoresBalancesCatPrint');


                    //StoresInventoryNew
                    Route:: get('StoresInventoryNew', 'StoresInventoryNew');
                    Route:: post('StoresInventoryNewFilter', 'StoresInventoryNewFilter');
                    Route:: get('StoresInventoryNewFilterNeww', 'StoresInventoryNewFilterNeww');
                    Route:: get('StoresInventoryNewPrint', 'StoresInventoryNewPrint');


                    //ItemCost
                    Route:: get('ItemCost', 'ItemCost');
                    Route:: post('ItemCostNewFilter', 'ItemCostNewFilter');
                    Route:: get('ItemCostNewFilterNeww', 'ItemCostNewFilterNeww');


                    //DelegateSalesDetails
                    Route:: get('DelegateSalesDetailss', 'DelegateSalesDetailss');
                    Route:: post('DelegateSalesDetailssFilter', 'DelegateSalesDetailssFilter');
                    Route:: get('DelegateSalesDetailssFilterNeww', 'DelegateSalesDetailssFilterNeww');
                    Route:: get('DelegateSalesDetailssFilterPrint', 'DelegateSalesDetailssFilterPrint');

                    //ProfitDelegateSalesDetails
                    Route:: get('ProfitDelegateSalesDetails', 'ProfitDelegateSalesDetails');
                    Route:: post('ProfitDelegateSalesDetailsFilter', 'ProfitDelegateSalesDetailsFilter');
                    Route:: get('ProfitDelegateSalesDetailsFilterNeww', 'ProfitDelegateSalesDetailsFilterNeww');

                    //StoresCosts
                    Route:: get('StoresCosts', 'StoresCosts');
                    Route:: post('StoresCostsFilter', 'StoresCostsFilter');
                    Route:: get('StoresCostsFilterNeww', 'StoresCostsFilterNeww');


                    //InstallmentCompaniesSales
                    Route:: get('InstallmentCompaniesSales', 'InstallmentCompaniesSales');
                    Route:: post('InstallmentCompaniesSalesFilter', 'InstallmentCompaniesSalesFilter');
                    Route:: get('InstallmentCompaniesSalesFilterNeww', 'InstallmentCompaniesSalesFilterNeww');
                    Route:: get('SaveDefaultColumnsInstallmentCompaniesSales', 'SaveDefaultColumnsInstallmentCompaniesSales');


                    //Customer_Debts
                    Route:: get('Customer_Debts', 'Customer_Debts');
                    Route:: get('Customer_DebtsFilterTwo', 'Customer_DebtsFilterTwo');


                    //Vendor_Debts
                    Route:: get('Vendor_Debts', 'Vendor_Debts');
                    Route:: get('Vendor_DebtsFilterTwo', 'Vendor_DebtsFilterTwo');


                    //SalesProsMoreDetails
                    Route:: get('SalesProsMoreDetails', 'SalesProsMoreDetails');
                    Route:: get('SalesProsMoreDetailsFilter', 'SalesProsMoreDetailsFilter');

                    //Sales Brands in Details
                    Route:: get('SalesProsBrandsMoreDetails', 'SalesProsBrandsMoreDetails');
                    Route:: get('SalesProsBrandsMoreDetailsFilter', 'SalesProsBrandsMoreDetailsFilter');

                    //StagnantItemsTwo
                    Route:: get('StagnantItemsTwo', 'StagnantItemsTwo');
                    Route:: get('StagnantItemsTwoFilter', 'StagnantItemsTwoFilter');


                    //SalesCustomersGroups
                    Route:: get('SalesCustomersGroups', 'SalesCustomersGroups');
                    Route:: post('SalesCustomersGroupsFilter', 'SalesCustomersGroupsFilter');
                    Route:: get('SalesCustomersGroupsFilterNeww', 'SalesCustomersGroupsFilterNeww');


                    //Filters
                    Route:: get('BranchReportStoresFilter', 'BranchReportStoresFilter');
                    Route:: get('BranchReportSafesFilter', 'BranchReportSafesFilter');
                    Route:: get('ClientGroupsFilter', 'ClientGroupsFilter');
                    Route:: get('GroupSingleFilter', 'GroupSingleFilter');



//EditDeleteBillReport
                    Route:: get('EditDeleteBillReport', 'EditDeleteBillReport');
                    Route:: get('EditDeleteBillReportFilter', 'EditDeleteBillReportFilter');

//HoldQtiesReport
                    Route:: get('HoldQtiesReport', 'HoldQtiesReport');
                    Route:: get('HoldQtiesReportFilter', 'HoldQtiesReportFilter');

//ReturnWithoutBillReport
                    Route:: get('ReturnWithoutBillReport', 'ReturnWithoutBillReport');
                    Route:: get('ReturnWithoutBillReportFilter', 'ReturnWithoutBillReportFilter');


//StoresQtiesReport
                    Route:: get('StoresQtiesReport', 'StoresQtiesReport');
                    Route:: get('StoresQtiesReportFilter', 'StoresQtiesReportFilter');


//ProductSalesGroupsReport
                    Route:: get('ProductSalesGroupsReport', 'ProductSalesGroupsReport');
                    Route:: get('ProductSalesGroupsReportFilter', 'ProductSalesGroupsReportFilter');


//ProductSalesBrandsReport
                    Route:: get('ProductSalesBrandsReport', 'ProductSalesBrandsReport');
                    Route:: get('ProductSalesBrandsReportFilter', 'ProductSalesBrandsReportFilter');

                    //EmpPrecentsBrandsGroupsReport
                    Route:: get('EmpPrecentsBrandsGroupsReport', 'EmpPrecentsBrandsGroupsReport');
                    Route:: get('EmpPrecentsBrandsGroupsReportFilter', 'EmpPrecentsBrandsGroupsReportFilter');


                    //DailyClosingDetails
                    Route:: get('DailyClosingDetails', 'DailyClosingDetails');
                    Route:: get('DailyClosingDetailsFilter', 'DailyClosingDetailsFilter');
                    Route:: get('FilterSalesDailyClosingDetails', 'FilterSalesDailyClosingDetails');
                    Route:: get('FilterRSalesDailyClosingDetails', 'FilterRSalesDailyClosingDetails');
                    Route:: get('FilterSettlement3agzDailyClosingDetails', 'FilterSettlement3agzDailyClosingDetails');
                    Route:: get('FilterPetrolDailyClosingDetails', 'FilterPetrolDailyClosingDetails');
                    Route:: get('FilterShippingDailyClosingDetails', 'FilterShippingDailyClosingDetails');
                    Route:: get('FilterMaintainceDailyClosingDetails', 'FilterMaintainceDailyClosingDetails');
                    Route:: get('FilterSettlementZyadaDailyClosingDetails', 'FilterSettlementZyadaDailyClosingDetails');
                    Route:: get('FilterRMaintainceDailyClosingDetails', 'FilterRMaintainceDailyClosingDetails');
                    Route:: get('FilterPurchasesDailyClosingDetails', 'FilterPurchasesDailyClosingDetails');
                    Route:: get('FilterRPurchasesDailyClosingDetails', 'FilterRPurchasesDailyClosingDetails');
                    Route:: get('DailyClosingDetailsFilterPrint', 'DailyClosingDetailsFilterPrint');



                });


                //=================== End New Reports  =============================================================


//===== End Reports =======================================================================================================




//=====  Manufacturing ===================================================================================================


                Route::controller(ManufacturingController:: class)->group( function () {

                    //Manufacturing Halls
                    Route:: get('ManufacturingHalls', 'ManufacturingHallsPage');
                    Route:: post('AddManufacturingHalls', 'AddManufacturingHalls');
                    Route:: post('EditManufacturingHalls/{id}', 'EditManufacturingHalls');
                    Route:: get('DeleteManufacturingHalls/{id}', 'DeleteManufacturingHalls');

                    // =========   Manufacturing Model ===========================
                    Route:: get('ManufacturingModel', 'ManufacturingModelPage');
                    Route:: post('AddManufacturingModel', 'AddManufacturingModel');
                    Route:: get('EditManufacturingModel/{id}', 'EditManufacturingModel');
                    Route:: post('PostEditManufacturingModel/{id}', 'PostEditManufacturingModel');
                    Route:: get('ManuExecution/{id}', 'ManuExecutionPage');
                    Route:: get('PrintManufacturingModel/{id}', 'PrintManufacturingModel');
                    Route:: get('DeleteManufacturingModel/{id}', 'DeleteManufacturingModel');

                    //Manufacturing Model Precent
                    Route:: get('ManufacturingModelPrecent', 'ManufacturingModelPrecentPage');
                    Route:: get('EditManufacturingModelPrecent/{id}', 'EditManufacturingModelPrecent');
                    Route:: post('AddManufacturingModelPrecent', 'AddManufacturingModelPrecent');
                    Route:: post('PostEditManufacturingModelPrecent/{id}', 'PostEditManufacturingModelPrecent');


                    //Filters
                    Route:: get('IncomManufacturingProductsFilter', 'IncomManufacturingProductsFilter');
                    Route:: get('OutcomManufacturingProductsFilter', 'OutcomManufacturingProductsFilter');
                    Route:: get('OutcomManufacturingProductsFilterPrecent', 'OutcomManufacturingProductsFilterPrecent');
                    Route:: get('IncomManufacturingProductsFilterPrecent', 'IncomManufacturingProductsFilterPrecent');


                    Route:: get('EditManufacturingModelPrecent/{id}/OutcomManufacturingProductsFilterPrecent', 'OutcomManufacturingProductsFilterPrecent');
                    Route:: get('EditManufacturingModelPrecent/{id}/IncomManufacturingProductsFilterPrecent', 'IncomManufacturingProductsFilterPrecent');
                    Route:: get('EditManufacturingModel/{id}/IncomManufacturingProductsFilter', 'IncomManufacturingProductsFilter');
                    Route:: get('EditManufacturingModel/{id}/OutcomManufacturingProductsFilter', 'OutcomManufacturingProductsFilter');


                    //Sechdule
                    Route:: get('ManufacturingModelSechdule', 'ManufacturingModelSechdule');


                    // =========   End Manufacturing Model ===========================


                    //Executing and Receiving
                    Route:: get('ExecutingandReceiving', 'ExecutingandReceiving');
                    Route:: get('ModelExecutingFilter', 'ModelExecutingFilter');
                    Route:: get('ManuExecution/{id}/ModelExecutingFilter', 'ModelExecutingFilter');
                    Route:: post('AddExecutingReceiving', 'AddExecutingReceiving');

                });



                //=====  End Manufacturing ==================================================================================================



// === Secretariat ========================================================================================================

                Route::controller(SecretariatController:: class)->group( function () {

                    //Secretariat Stores
                    Route:: get('Secretariat_Stores', 'Secretariat_StoresPage');
                    Route:: post('AddSecretariat_Stores', 'AddSecretariat_Stores');
                    Route:: post('EditSecretariat_Stores/{id}', 'EditSecretariat_Stores');
                    Route:: get('DeleteSecretariat_Stores/{id}', 'DeleteSecretariat_Stores');

                    //Secretariat_Import_goods
                    Route:: get('Secretariat_Import_goods', 'Secretariat_Import_goodsPage');
                    Route:: get('ImportGoodsProductsFilter', 'ImportGoodsProductsFilter');
                    Route:: post('AddSecretariat_Import_goods', 'AddSecretariat_Import_goods');
                    Route:: get('Secretariat_Import_goodsPrint/{id}', 'Secretariat_Import_goodsPrint');
                    Route:: get('Secretariat_Import_goods_Sechdule', 'Secretariat_Import_goods_Sechdule');
                    Route:: get('EditSecretariat_Import_goods', 'EditSecretariat_Import_goods');
                    Route:: get('DeleteSecretariat_Import_goods/{id}', 'DeleteSecretariat_Import_goods');
                    Route:: post('PostEditSecretariat_Import_goods', 'PostEditSecretariat_Import_goods');

                    //Secretariat_Export_goods
                    Route:: get('Secretariat_Export_goods', 'Secretariat_Export_goodsPage');
                    Route:: get('ExportProductsFilter', 'ExportProductsFilter');
                    Route:: post('AddSecretariatExportGoods', 'AddSecretariatExportGoods');
                    Route:: get('Secretariat_Export_goodsPrint/{id}', 'Secretariat_Export_goodsPrint');
                    Route:: get('Secretariat_Export_goods_Sechdule', 'Secretariat_Export_goods_Sechdule');
                    Route:: get('EditSecretariat_Export_goods', 'EditSecretariat_Export_goods');
                    Route:: get('DeleteSecretariat_Export_goods/{id}', 'DeleteSecretariat_Export_goods');
                    Route:: post('PostEditSecretariatExportGoods', 'PostEditSecretariatExportGoods');

                    //RecivedSecretariat_Export_goods
                    Route:: get('RecivedSecretariat_Export_goods', 'RecivedSecretariat_Export_goods');
                    Route:: get('PostRecivedSecretariatExportGoods', 'PostRecivedSecretariatExportGoods');
                    Route:: get('Secretariat_Recived_Export_goodsPrint/{id}', 'Secretariat_Recived_Export_goodsPrint');


                    //Secretariat_Stores_Qty
                    Route:: get('Secretariat_Stores_Qty', 'Secretariat_Stores_Qty');
                    Route:: get('Secretariat_Stores_QtyFilter', 'Secretariat_Stores_QtyFilter');


                    //ManufacturingModelSecretariat
                    Route:: get('ManufacturingModelSecretariatSechdule', 'ManufacturingModelSecretariatSechdule');
                    Route:: get('ManufacturingModelSecretariat', 'ManufacturingModelSecretariat');
                    Route:: post('AddManufacturingModelSecretariat', 'AddManufacturingModelSecretariat');
                    Route:: get('IncomManufacturingModelSecretariatFilter', 'IncomManufacturingModelSecretariatFilter');
                    Route:: get('OutcomManufacturingModelSecretariatFilter', 'OutcomManufacturingModelSecretariatFilter');
                    Route:: get('DeleteManufacturingModelSecretariat/{id}', 'DeleteManufacturingModelSecretariat');
                    Route:: get('EditManufacturingSecretariatModel/{id}', 'EditManufacturingSecretariatModel');
                    Route:: post('PostEditManufacturingModelSecretariat', 'PostEditManufacturingModelSecretariat');
                    Route:: get('ManuSecrtaritExecution/{id}', 'ManuSecrtaritExecution');
                    Route:: get('EditManufacturingSecretariatModel/IncomManufacturingModelSecretariatFilter', 'IncomManufacturingModelSecretariatFilter');
                    Route:: get('EditManufacturingSecretariatModel/OutcomManufacturingModelSecretariatFilter', 'OutcomManufacturingModelSecretariatFilter');

                    //ManufacturingModelSecretariatPrecent
                    Route:: get('ManufacturingModelSecretariatPrecent', 'ManufacturingModelSecretariatPrecent');
                    Route:: post('AddManufacturingModelSecretariatPrecent', 'AddManufacturingModelSecretariatPrecent');
                    Route:: get('IncomManufacturingModelSecretariatFilterPrecent', 'IncomManufacturingModelSecretariatFilterPrecent');
                    Route:: get('OutcomManufacturingModelSecretariatFilterPrecent', 'OutcomManufacturingModelSecretariatFilterPrecent');
                    Route:: get('EditManufacturingModelSecretariatPrecent/{id}', 'EditManufacturingModelSecretariatPrecent');
                    Route:: post('PostEditManufacturingModelSecretariatPrecent', 'PostEditManufacturingModelSecretariatPrecent');
                    Route:: get('EditManufacturingModelSecretariatPrecent/IncomManufacturingModelSecretariatFilterPrecent', 'IncomManufacturingModelSecretariatFilterPrecent');
                    Route:: get('EditManufacturingModelSecretariatPrecent/OutcomManufacturingModelSecretariatFilterPrecent', 'OutcomManufacturingModelSecretariatFilterPrecent');


                    //ExecutingReceivingSecretariat
                    Route:: get('ExecutingReceivingSecretariat', 'ExecutingReceivingSecretariat');
                    Route:: get('ModelExecutingReceivingSecretariatFilter', 'ModelExecutingReceivingSecretariatFilter');
                    Route:: post('AddExecutingReceivingSecretariat', 'AddExecutingReceivingSecretariat');
                    Route:: get('ManuSecrtaritExecution/{id}/ModelExecutingReceivingSecretariatFilter', 'ModelExecutingReceivingSecretariatFilter');

                });



                // === End Secretariat ======================================================================================================


// === Website =========================================================================================================


                Route::controller(WebsiteController:: class)->group( function () {

                    //WebSlider
                    Route:: get('WebSlider', 'WebSliderPage');
                    Route:: post('AddWebSlider', 'AddWebSlider');
                    Route:: post('EditWebSlider/{id}', 'EditWebSlider');
                    Route:: get('DeleteWebSlider/{id}', 'DeleteWebSlider');
                    Route:: get('UnActiveSlider/{id}', 'UnActiveSlider');
                    Route:: get('ActiveSlider/{id}', 'ActiveSlider');

                    //About
                    Route:: get('About', 'AboutPage');
                    Route:: post('UpdateAbout/{id}', 'UpdateAbout');

                    //SocialMedia
                    Route:: get('SocialMedia', 'SocialMediaPage');
                    Route:: post('SocialMediaUpdate/{id}', 'SocialMediaUpdate');

                    //MsgRqst
                    Route:: get('MsgRqst', 'MsgRqstPage');
                    Route:: get('DeleteMsgRqst/{id}', 'DeleteMsgRqst');

                    //ContactUS
                    Route:: get('ContactUS', 'ContactUSPage');
                    Route:: post('ContactUSUpdate/{id}', 'ContactUSUpdate');


                    //Articles
                    Route:: get('Articles', 'ArticlesPage');
                    Route:: get('DeleteArticles/{id}', 'DeleteArticles');
                    Route:: post('AddArticles', 'AddArticles');
                    Route:: post('EditArticles/{id}', 'EditArticles');

                    //Polices
                    Route:: get('Polices', 'PolicesPage');
                    Route:: post('UpdatePolices/{id}', 'UpdatePolices');

                    //Terms
                    Route:: get('Terms', 'TermsPage');
                    Route:: post('UpdateTerms/{id}', 'UpdateTerms');

                    //CouponCode
                    Route:: get('CouponCode', 'CouponCodePage');
                    Route:: post('AddCouponCode', 'AddCouponCode');
                    Route:: post('EditCouponCode/{id}', 'EditCouponCode');
                    Route:: get('DeleteCouponCode/{id}', 'DeleteCouponCode');

                    //FAQ
                    Route:: get('FAQ', 'FAQPage');
                    Route:: post('AddFAQ', 'AddFAQ');
                    Route:: post('EditFAQ/{id}', 'EditFAQ');
                    Route:: get('DeleteFAQ/{id}', 'DeleteFAQ');




                    //Terms
                    Route:: get('ProDetailsImg', 'ProDetailsImg');
                    Route:: post('EditProDetailsImg/{id}', 'EditProDetailsImg');

                    //BefroeFooter
                    Route:: get('BefroeFooter', 'BefroeFooter');
                    Route:: post('EditBefroeFooter/{id}', 'EditBefroeFooter');

                    //ShopOrders
                    Route:: get('ShopOrders', 'ShopOrders');
                    Route:: post('ChangeStatusShop', 'ChangeStatusShop');


                    //EComDesign
                    Route:: get('EComDesign', 'EComDesign');
                    Route:: post('AddMainEComDesign', 'AddMainEComDesign');
                    Route:: get('AddMainEComDesignFirst', 'AddMainEComDesignFirst');
                    Route:: post('AddHomeEComDesign', 'AddHomeEComDesign');
                    Route:: get('AddHomeEComDesignFirst', 'AddHomeEComDesignFirst');
                    Route:: post('AddHomeProductEComDesign', 'AddHomeProductEComDesign');
                    Route:: get('AddHomeProductEComDesignFirst', 'AddHomeProductEComDesignFirst');
                    Route:: post('AddSupPagesEComDesign', 'AddSupPagesEComDesign');
                    Route:: get('AddSupPagesEComDesignFirst', 'AddSupPagesEComDesignFirst');
                    Route:: post('AddSupPagesPartTwoEComDesign', 'AddSupPagesPartTwoEComDesign');
                    Route:: get('AddSupPagesPartTwoEComDesignFirst', 'AddSupPagesPartTwoEComDesignFirst');
                    Route:: post('AddProductDetailsEComDesign', 'AddProductDetailsEComDesign');
                    Route:: get('AddProductDetailsEComDesignFirst', 'AddProductDetailsEComDesignFirst');
                    Route:: post('AddSupPagesWishCompEComDesign', 'AddSupPagesWishCompEComDesign');
                    Route:: get('AddPagesWishCompEComDesignFirst', 'AddPagesWishCompEComDesignFirst');



                });


                // === End Website =========================================================================================================



                // === Electonic Bill =========================================================================================================


                Route::controller(ElectronicBillController:: class)->group( function () {

                    //Send_Bill_Sales
                    Route:: get('Send_Bill_Sales', 'Send_Bill_Sales');
                    Route:: get('Send_Bill_ReturnSales', 'Send_Bill_ReturnSales');
                    Route:: get('Send_Bill_SalesFilter', 'Send_Bill_SalesFilter');
                    Route:: get('ReturnSend_Bill_SalesFilter', 'ReturnSend_Bill_SalesFilter');

                    //Bill_Sales_Sent
                    Route:: get('Bill_Sales_Sent', 'Bill_Sales_Sent');
                    Route:: get('Bill_ReturnSales_Sent', 'Bill_ReturnSales_Sent');
                    Route:: get('Bill_Sales_SentFilter', 'Bill_Sales_SentFilter');
                    Route:: get('Bill_ReturnSales_SentFilter', 'Bill_ReturnSales_SentFilter');
                    Route:: get('Bill_Sales_Sent_Web', 'Bill_Sales_Sent_Web');
                    Route:: get('FilterBill_Sales_Sent_Web', 'FilterBill_Sales_Sent_Web');
                    Route:: get('printPDFSalesElectronic/{uuid}', 'printPDFSalesElectronic');
                    Route:: get('FilterprintPDFSalesElectronic/{uuid}/{longid}', 'FilterprintPDFSalesElectronic');
                    Route:: get('printPDFSalesElectronic/FilterprintPDFSalesElectronic/{uuid}', 'FilterprintPDFSalesElectronic');
                    Route:: get('CancelSalesElectronic/{uuid}', 'CancelSalesElectronic');
                    Route:: get('RejectSalesElectronic/{uuid}', 'RejectSalesElectronic');

                    //SendElectronicBill
                    Route:: get('postSendSales', 'postSendSales');
                    Route:: get('postSendSalesEXP', 'postSendSalesEXP');
                    Route:: get('SendSalesBill/{id}', 'SendSalesBill');
                    Route:: get('ReturnSendSalesBill/{id}', 'ReturnSendSalesBill');

                    //Recipt
                    Route:: get('Send_Recipt_Sales', 'Send_Recipt_Sales');
                    Route:: get('SendSalesRecipt/{id}', 'SendSalesRecipt');
                    Route:: get('Recipt_Sales_Sent', 'Recipt_Sales_Sent');
                    Route:: get('FilterRecipt_Sales_Sent_Web', 'FilterRecipt_Sales_Sent_Web');

                    //ReturnSend_Recipt_Sales
                    Route:: get('ReturnSend_Recipt_Sales', 'ReturnSend_Recipt_Sales');
                    Route:: get('ReturnSend_Recipt_SalesFilter', 'ReturnSend_Recipt_SalesFilter');
                    Route:: get('ReturnSendSalesRecipt/{id}', 'ReturnSendSalesRecipt');

                    //Bill_Purchases_Sent
                    Route:: get('Bill_Purchases_Sent', 'Bill_Purchases_Sent');



                });
                // === End Electronic Bill  =========================================================================================================


//Imports and Exports ===============================================================================================================

                Route::controller(ImportExportController:: class)->group( function () {

                    //Imports

                    //Page
                    Route:: get('ExportProducts', 'ExportProductsPage');


                    Route:: post('ImportProducts', 'ImportProducts');
                    Route:: post('ImportProductsWithStart', 'ImportProductsWithStart');
                    Route:: post('ImportProductsUnits', 'ImportProductsUnits');
                    Route:: post('ImportGroups', 'ImportGroups');
                    Route:: post('ImportMoves', 'ImportMoves');
                    Route:: post('ImportStartPeriod', 'ImportStartPeriod');
                    Route:: post('ImportProStartPeriod', 'ImportProStartPeriod');
                    Route:: post('ImportClients', 'ImportClients');
                    Route:: post('ImportVendors', 'ImportVendors');
                    Route:: post('ImportEmployees', 'ImportEmployees');
                    Route:: post('ImportReceipt_Voucher', 'ImportReceipt_Voucher');
                    Route:: post('ImportPayment_Voucher', 'ImportPayment_Voucher');
                    Route:: post('ImportProductRepeat', 'ImportProductRepeat');
                    Route:: post('ImportCustomersGroup', 'ImportCustomersGroup');
                    Route:: post('ImportBrands', 'ImportBrands');
                    Route:: post('ImportAccountingManual', 'ImportAccountingManual');
                    Route:: post('ImportAssets', 'ImportAssets');
                    Route:: post('ImportExporting_Checks', 'ImportExporting_Checks');
                    Route:: post('ImportIncoming_checks', 'ImportIncoming_checks');
                    Route:: post('ImportInsurance_Paper', 'ImportInsurance_Paper');
                    Route:: post('ImportCustomerFollowUp', 'ImportCustomerFollowUp');
                    Route:: post('ImportAttendance', 'ImportAttendance');
                    Route:: post('ImportGovernrate', 'ImportGovernrate');
                    Route:: post('ImportCity', 'ImportCity');
                    Route:: post('ImportPlace', 'ImportPlace');
                    Route:: post('ImportTest', 'ImportTest');


                    //Export


                    Route:: get('ExportStoresQtyyy', 'ExportStoresQtyyy');
                    Route:: get('ExportStoresQtyyyRased', 'ExportStoresQtyyyRased');
                    Route:: get('ExportStoresQtyyyRasedSerial', 'ExportStoresQtyyyRasedSerial');
                    Route:: get('ExportStoresBalancesNew', 'ExportStoresBalancesNew');
                    Route:: get('ExportStoresBalancesCat', 'ExportStoresBalancesCat');
                    Route:: get('ExportDelegateSalesDetails', 'ExportDelegateSalesDetails');
                    Route:: get('ExportProfitDelegateSalesDetails', 'ExportProfitDelegateSalesDetails');
                    Route:: get('ExportStoresCosts', 'ExportStoresCosts');
                    Route:: get('ExportInstallmentCompaniesSales', 'ExportInstallmentCompaniesSales');
                    Route:: get('ExportPurchasesBillsReport', 'ExportPurchasesBillsReport');
                    Route:: get('ExportSalesBillsReport', 'ExportSalesBillsReport');
                    Route:: get('ExportSalesDetailsBillsReport', 'ExportSalesDetailsBillsReport');
                    Route:: get('ExportPurchasesDetailsBillsReport', 'ExportPurchasesDetailsBillsReport');
                    Route:: get('ExportStoresMovesReport', 'ExportStoresMovesReport');
                    Route:: get('ExportStoresTransferReport', 'ExportStoresTransferReport');
                    Route:: get('ExportSafesTransferReport', 'ExportSafesTransferReport');
                    Route:: get('ExportProductMoveDetails', 'ExportProductMoveDetails');
                    Route:: get('ExportCompareSalesPrice', 'ExportCompareSalesPrice');
                    Route:: get('ExportMostSalesProducts', 'ExportMostSalesProducts');
                    Route:: get('ExportProfitSalesProduct', 'ExportProfitSalesProduct');
                    Route:: get('ExportClientsStatement', 'ExportClientsStatement');
                    Route:: get('ExportClientAccountStatement', 'ExportClientAccountStatement');
                    Route:: get('ExportVendorAccountStatement', 'ExportVendorAccountStatement');
                    Route:: get('ExportVendorsStatement', 'ExportVendorsStatement');
                    Route:: get('ExportInventorySerial', 'ExportInventorySerial');
                    Route:: post('ExportSalesCustomersGroupsFilter', 'ExportSalesCustomersGroupsFilter');
                    Route:: post('ExportMaintenance_Tune', 'ExportMaintenance_Tune');
                    Route:: post('ExportMaintanceSalesReport', 'ExportMaintanceSalesReport');
                    Route:: get('ExportReturnPurchasesBillsReport', 'ExportReturnPurchasesBillsReport');
                    Route:: get('ExportReturnSalesBillsReport', 'ExportReturnSalesBillsReport');
                    Route:: get('ExportGeneralDailyFilter', 'ExportGeneralDailyFilter');
                    Route:: get('ExpensesListExport', 'ExpensesListExport');
                    Route:: get('ExpensesListExportDetails', 'ExpensesListExportDetails');
                    Route:: get('IncomListExport', 'IncomListExport');
                    Route:: get('IncomListExportDetails', 'IncomListExportDetails');

                    //Export Sechdule
                    Route:: get('ExportAllProducts', 'ExportAllProducts');
                    Route:: get('ExportAllVendors', 'ExportAllVendors');
                    Route:: get('ExportAllPaymentVoucher', 'ExportAllPaymentVoucher');
                    Route:: get('ExportAllJournalizing', 'ExportAllJournalizing');
                    Route:: get('ExportAllOpeningEntries', 'ExportAllOpeningEntries');
                    Route:: get('ExportAllReceiptVoucher', 'ExportAllReceiptVoucher');
                    Route:: get('ExportAllSettlement', 'ExportAllSettlement');
                    Route:: get('ExportAllClients', 'ExportAllClients');
                    Route:: get('ExportAllEmployees', 'ExportAllEmployees');

                });


                //End Imports and Exports ============================================================================================================


            });



        });

    });

});
