@extends('admin.index')
@section('content')

<title>{{trans('admin.Stores')}}</title>

<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Stores')}}</a></li>
        <li class="breadcrumb-item active">{{trans('admin.Stores')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        <span class="fw-300"><i> {{trans('admin.Stores')}}</i></span>
                    </h2>

                    <div class="panel-toolbar">

                        @can('اضافه المخازن')
                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                        @endcan

                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
                        @include('admin.layouts.toolbar')
                    </div>
                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">
                        <!-- datatable start -->
                        <div id="mobile-overflow">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Time')}}</th>
                                        <th>{{trans('admin.Arabic_Name')}}</th>
                                        <th>{{trans('admin.English_Name')}}</th>
                                        <th>{{trans('admin.Phone')}}</th>
                                        <th>{{trans('admin.Address')}}</th>
                                        <th>{{trans('admin.Account_Code')}}</th>
                                        <th>{{trans('admin.Account_Client_Code')}}</th>
                                        <th>{{trans('admin.Branch')}}</th>
                                        <th>{{trans('admin.Letter_Bill')}}</th>
                                        <th>{{trans('admin.User')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Date}}</td>
                                        <td>{{$item->Time}}</td>
                                        <td>{{$item->Name}}</td>
                                        <td>{{$item->NameEn}}</td>
                                        <td>{{$item->Phone}}</td>
                                        <td>{{$item->Address}}</td>
                                        <td>
                                            @if(!empty($item->Account()->first()->Code))
                                            {{$item->Account()->first()->Code}}
                                            @endif

                                        </td>
                                        <td>
                                            @if(!empty($item->Account_Client()->first()->Code))
                                            {{$item->Account_Client()->first()->Code}}
                                            @endif
                                        </td>
                                        <td>
                                            @if(!empty($item->Branch()->first()->Arabic_Name))

                                            {{app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name}}
                                            @endif
                                        </td>

                                        <td>{{$item->Letter}}</td>
                                        <td>
                                            @if(!empty($item->User()->first()->name))
                                            {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                            @endif
                                        </td>

                                        <td class="text-center">

                                            @if($item->id != 20)

                                            @can('تعديل المخازن')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Edit{{$item->id}}"><i class="fal fa-edit"></i></button>
                                            @endcan


                                            @can('حذف المخازن')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}"><i class="fal fa-trash-alt"></i></button>
                                            @endcan

                                            @endif

                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th>{{trans('admin.Time')}}</th>
                                        <th>{{trans('admin.Arabic_Name')}}</th>
                                        <th>{{trans('admin.English_Name')}}</th>
                                        <th>{{trans('admin.Phone')}}</th>
                                        <th>{{trans('admin.Address')}}</th>
                                        <th>{{trans('admin.Account_Code')}}</th>
                                        <th>{{trans('admin.Account_Client_Code')}}</th>
                                        <th>{{trans('admin.Branch')}}</th>
                                        <th>{{trans('admin.Letter_Bill')}}</th>
                                        <th>{{trans('admin.User')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal Add-->
    <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.AddNew')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{url('AddStores')}}" method="post" enctype="multipart/form-data">
                        {!! csrf_field() !!}
                        @honeypot
                        <div class="form-row">

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                                <input type="text" value="{{$Code}}" class="form-control" disabled>
                                <input type="hidden" name="Code" value="{{$Code}}">
                            </div>

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}}</label>
                                <input type="text" name="Name" value="{{old('Name')}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                                <input type="text" name="NameEn" value="{{old('NameEn')}}" class="form-control">
                            </div>


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Address')}}</label>
                                <input type="text" name="Address" value="{{old('Address')}}" class="form-control">
                            </div>


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}</label>
                                <input type="number" name="Phone" value="{{old('Phone')}}" class="form-control">
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="">{{trans('admin.Branch')}}</label>
                                <select class="select2 form-control w-100" name="Branch" required>
                                    <option value=""> {{trans('admin.Branch')}}</option>
                                    @foreach($Branchs as $branch)
                                    <option value="{{$branch->id}}">
                                        {{app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name}}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Letter_Bill')}}</label>
                                <input type="text" name="Letter" value="{{old('Letter')}}" class="form-control">
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-primary"> {{trans('admin.Add')}}</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

    @foreach($items as $item)
    <!-- Modal Edit-->
    <div class="modal fade" id="Edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{trans('admin.Edit')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{url('EditStores/'.$item->id)}}" method="post" enctype="multipart/form-data">
                        {!! csrf_field() !!}
                        @honeypot
                        <div class="form-row">

                            <input type="hidden" name="Date" value="{{$item->Date}}">
                            <input type="hidden" name="Time" value="{{$item->Time}}">
                            <input type="hidden" name="Account" value="{{$item->Account}}">
                            <input type="hidden" name="User" value="{{$item->User}}">

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                                <input type="text" value="{{$item->Code}}" class="form-control" disabled>
                                <input type="hidden" name="Code" value="{{$item->Code}}">
                            </div>

                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}}</label>
                                <input type="text" name="Name" value="{{$item->Name}}" class="form-control" required>
                            </div>
                            <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                                <input type="text" name="NameEn" value="{{$item->NameEn}}" class="form-control" required>
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Address')}}</label>
                                <input type="text" name="Address" value="{{$item->Address}}" class="form-control">
                            </div>


                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}</label>
                                <input type="number" name="Phone" value="{{$item->Phone}}" class="form-control">
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="">{{trans('admin.Branch')}}</label>
                                <select class="select2 form-control w-100" name="Branch" required>
                                    <option value=""> {{trans('admin.Branch')}}</option>
                                    @foreach($Branchs as $branch)
                                    <option value="{{$branch->id}}" @if($item->Branch == $branch->id) selected @endif>


                                        {{app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name}}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Letter_Bill')}}</label>
                                <input type="text" name="Letter" value="{{$item->Letter}}" class="form-control">
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <button type="submit" class="btn btn-primary"> {{trans('admin.SaveChanges')}}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Delete -->
    <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.RUSWDT')}} <strong> {{app()->getLocale() == 'ar' ?$item->Name :$item->NameEn}}</strong>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                    <a href="{{url('DeleteStores/'.$item->id)}}" class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                </div>
            </div>
        </div>
    </div>

    @endforeach

</main>
@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>
<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }


            $('#AccountCode').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSubAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {
                        var query = {
                            search: params.term
                        };
                        if (params.term == "*") query.items = [];
                        return {
                            json: JSON.stringify(query)
                        }
                    }
                }
            });


            $('#AccountCode').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


        });
    });

</script>


@endpush
