@extends('admin.index')
@section('content')
@php
use App\Models\ProductUnits;
use App\Models\AssemblyProducts;
use App\Models\SubImages;
use App\Models\AdditionalProducts;
use App\Models\ProductsVira;
use App\Models\VAProducts;
use App\Models\VAPrice;
use App\Models\VAQty;
@endphp
<style>
    .long-barcode {
        max-width: 300px !important;
    }

</style>
<title>{{trans('admin.Products_Sechdule')}}</title>


<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Stores')}}</a></li>
        <li class="breadcrumb-item active"> {{trans('admin.Products_Sechdule')}} </li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>
    <style>
        .Hei {
            background: #886ab5;
            color: WHITE;

            padding: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 6px 0 rgba(136, 106, 181, 0.5);
        }

        .wei {
            background: #886ab5;
            color: WHITE;

            padding: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 6px 0 rgba(136, 106, 181, 0.5);
        }

        .BlogsH {
            display: flex;
            text-align: center;
            flex-direction: column;
        }

    </style>


    <p class="container text-center " style="margin-bottom:10px;">
        <a class="btn btn-primary" data-toggle="collapse" href="#multiCollapseExample1" role="button" aria-expanded="true" aria-controls="multiCollapseExample1"> Size Of Special Offers</a>
        <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#multiCollapseExample2" aria-expanded="false" aria-controls="multiCollapseExample2"> Size Of New Arrival</button>
        <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#multiCollapseExample3" aria-expanded="false" aria-controls="multiCollapseExample3"> Size Of Best Sellers</button>
    </p>
    <div class="row">
        <div class="col">
            <div class="collapse " id="multiCollapseExample1">
                <div class="card card-body">
                    <div class="col-lg-12 text-center Hei">
                        <h2 class="BlogsH"> Special Offers</h2>width:355px^Height:250px
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="collapse " id="multiCollapseExample2">
                <div class="card card-body">
                    <div class="col-lg-12 text-center wei">
                        <h2 class="BlogsH">New Arrival</h2>width:450px^Height:450px
                    </div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="collapse " id="multiCollapseExample3">
                <div class="card card-body">
                    <div class="col-lg-12 text-center wei">
                        <h2 class="BlogsH">Best Sellers</h2>width:306px^Height:306px
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter -->
    <form action="{{url('FilterPSechdule')}}" method="get">
        <div class="row">

            <div class="form-group col-md-2">
                <label>{{trans('admin.Name')}}</label>
                <input type="text" class="form-control" name="Name">
            </div>

            <div class="form-group col-md-2">
                <label>{{trans('admin.Code')}}</label>
                <input type="text" class="form-control" name="Code">
            </div>

            <div class="form-group col-md-2">
                <label class="form-label" for=""> {{trans('admin.Brand')}} </label>
                <select class="select2 form-control w-100" name="Brand">
                    <option value="">{{trans('admin.Brand')}}</option>
                    @foreach($Brands as $brand)
                    <option value="{{$brand->id}}">
                        {{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-md-3">
                <label class="form-label" for=""> {{trans('admin.Group')}} </label>
                <select class="select2 form-control w-100" name="Group">
                    <option value="">{{trans('admin.Group')}}</option>
                    @foreach($ItemsGroups as $group)
                    <option value="{{$group->id}}">
                        {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-md-2">
                <label class="form-label" for="">
                    {{trans('admin.Product_Type')}}
                </label><span class="strick">*</span>
                <select class="select2 form-control w-100" name="P_Type">
                    <option value="">{{trans('admin.Product_Type')}} </option>
                    @foreach($Types as $type)
                    <option value="{{$type->Type}}">
                        @if($type->Type == "Completed")
                        {{trans('admin.Completed')}}
                        @elseif($type->Type == "Raw")
                        {{trans('admin.Raw')}}
                        @elseif($type->Type == "Service")
                        {{trans('admin.Service')}}
                        @elseif($type->Type == "Assembly")
                        {{trans('admin.Assembly')}}
                        @elseif($type->Type == "Industrial")
                        {{trans('admin.Industrial')}}
                        @elseif($type->Type == "Single_Variable")
                        {{trans('admin.Single_Variable')}}
                        @elseif($type->Type == "Duble_Variable")
                        {{trans('admin.Duble_Variable')}}
                        @elseif($type->Type == "Subscribe")
                        {{trans('admin.Subscribe')}}
                        @elseif($type->Type == "Serial")
                        {{trans('admin.Serial')}}
                        @elseif($type->Type == "Petrol")
                        {{trans('admin.Petrol')}}
                        @elseif($type->Type == "Variable_Aggregate")
                        {{trans('admin.Variable_Aggregate')}}
                        @elseif($type->Type == "Additions")
                        {{trans('admin.Additions')}}
                        @endif


                    </option>
                    @endforeach
                </select>
            </div>

            <div class="form-group col-md-1">
                <button type="submit" class="btn btn-default" style="margin-top: 25px;"><i class="fal fa-search"></i></button>
            </div>

        </div>
    </form>


    <div class="row hide-table">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>
                        {{trans('admin.Products_Sechdule')}}
                    </h2>

                    <div class="panel-toolbar">

                        <a href="{{'ExportAllProducts'}}" class="btn btn-success btn-sm">
                            Export Excel
                        </a>


                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                            Style</button>

                        @include('admin.layouts.toolbar')
                    </div>

                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">

                        <!-- datatable start -->
                        <div id="mobile-overflow">
                            <table class="table table-bordered table-hover table-striped mobile-width w-100">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.P_Type')}}</th>
                                        <th>{{trans('admin.Name')}}</th>
                                        <th>{{trans('admin.Units')}}</th>
                                        <th>{{trans('admin.Group')}}</th>
                                        <th>{{trans('admin.Image')}}</th>
                                        <th>{{trans('admin.Image2')}}</th>
                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Additions')}}</th>
                                        <th>{{trans('admin.Status')}}</th>
                                        <th>{{trans('admin.Actions')}} </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $item)
                                    <tr @if($item->Delete == 1) class="deleted" @endif>


                                        <td>
                                            @if($item->P_Type == "Completed")
                                            {{trans('admin.Completed')}}
                                            @elseif($item->P_Type == "Raw")
                                            {{trans('admin.Raw')}}
                                            @elseif($item->P_Type == "Service")
                                            {{trans('admin.Service')}}
                                            @elseif($item->P_Type == "Assembly")



                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Assembly{{$item->id}}">
                                                {{trans('admin.Assembly')}}
                                            </button>


                                            @elseif($item->P_Type == "Industrial")
                                            {{trans('admin.Industrial')}}
                                            @elseif($item->P_Type == "Single_Variable")
                                            {{trans('admin.Single_Variable')}}
                                            @elseif($item->P_Type == "Duble_Variable")
                                            {{trans('admin.Duble_Variable')}}
                                            @elseif($item->P_Type == "Subscribe")
                                            {{trans('admin.Subscribe')}}
                                            @elseif($item->P_Type == "Serial")
                                            {{trans('admin.Serial')}}
                                            @elseif($item->P_Type == "Petroll")
                                            {{trans('admin.Petroll')}}
                                            @elseif($item->P_Type == "Variable_Aggregate")


                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Variable_Aggregate{{$item->id}}">
                                                {{trans('admin.Variable_Aggregate')}}
                                            </button>


                                            @elseif($item->P_Type == "Additions")
                                            {{trans('admin.Additions')}}
                                            @endif
                                        </td>
                                        {{--
                                        <td>


                                            {{ $item->P_Type->type() }}


                                        @if($item->P_Type->name == "Assembly")

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Assembly{{$item->id}}">
                                            {{trans('admin.Details')}}
                                        </button>

                                        @elseif($item->P_Type->name == "Variable_Aggregate")


                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Variable_Aggregate{{$item->id}}">
                                            {{trans('admin.Details')}}
                                        </button>


                                        @endif

                                        </td>
                                        --}}

                                        <td>
                                            {{app()->getLocale() == 'ar' ?$item->P_Ar_Name :$item->P_En_Name}}
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Units{{$item->id}}">
                                                {{trans('admin.Units')}}
                                            </button>
                                        </td>
                                        <td>
                                            @if(!empty($item->GroupX->Name))
                                            {{app()->getLocale() == 'ar' ?$item->GroupX->Name :$item->GroupX->Name}}
                                            @endif
                                        </td>

                                        <td>
                                            @if(!empty($item->Image))
                                            <img src="{{URL::to($item->Image)}}" class="img-table">
                                            @else
                                            <img src="{{asset('Admin/img/default.jpeg')}}" class="img-table">
                                            @endif
                                        </td>
                                        <td>
                                            @if(!empty($item->Image2))
                                            <img src="{{URL::to($item->Image2)}}" class="img-table">
                                            @else
                                            <img src="{{asset('Admin/img/default.jpeg')}}" class="img-table">
                                            @endif
                                        </td>

                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details{{$item->id}}">
                                                {{trans('admin.Details')}}
                                            </button>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Additions{{$item->id}}">
                                                {{trans('admin.Additions')}}
                                            </button>
                                        </td>
                                        <td>
                                            @if($item->Delete == 0)
                                            @if($item->Status == 0)
                                            <a href="{{url('UnActiveItem/'.$item->id)}}" class="btn btn-default"><i class="fal fa-check"></i></a>
                                            @elseif($item->Status == 1)

                                            <a href="{{url('ActiveItem/'.$item->id)}}" class="btn btn-default"><i class="fal fa-times"></i></a>
                                            @endif
                                            @endif

                                        </td>

                                        <td class="text-center">

                                            @if($item->Delete == 0)
                                            @can('حذف صنف')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                            @endcan

                                            @if($item->P_Type != "Variable_Aggregate")

                                            @can('تعديل صنف')
                                            <a href="{{url('EditItems/'.$item->id)}}" class="btn btn-default"><i class="fal fa-edit"></i></a>
                                            @endcan

                                            @else


                                            @can('تعديل صنف')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#EDITAV{{$item->id}}"><i class="fal fa-edit"></i></button>
                                            @endcan

                                            @endif

                                            @endif




                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.P_Type')}}</th>
                                        <th>{{trans('admin.Name')}}</th>
                                        <th>{{trans('admin.Units')}}</th>
                                        <th>{{trans('admin.Group')}}</th>
                                        <th>{{trans('admin.Image')}}</th>
                                        <th>{{trans('admin.Image2')}}</th>
                                        <th>{{trans('admin.Details')}}</th>
                                        <th>{{trans('admin.Status')}}</th>
                                        <th>{{trans('admin.Actions')}} </th>
                                    </tr>
                                </tfoot>
                            </table>
                            {{$items->Links()}}
                        </div>
                        <!-- datatable end -->

                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

@foreach($items as $item)

<!-- Modal Delete -->
<div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.RUSWDT')}} <strong>

                        {{app()->getLocale() == 'ar' ?$item->P_Ar_Name :$item->P_En_Name}}
                    </strong>
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                <a href="{{url('DeleteItem/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
            </div>
        </div>
    </div>
</div>

<!-- Modal Details -->
<div class="modal fade" id="Details{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Details')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="mt-3">
                    <div style="overflow:auto">
                        <table id="" class="table table-bordered table-hover table-striped ">
                            <thead>
                                <tr>



                                    <th>{{trans('admin.Brand')}} </th>
                                    <th>{{trans('admin.Minimum')}} </th>
                                    <th>{{trans('admin.Maximum')}} </th>
                                    <th>{{trans('admin.If_Offer')}} </th>
                                    <th>{{trans('admin.OfferPrice')}} </th>
                                    <th>{{trans('admin.Length')}} </th>
                                    <th>{{trans('admin.Width')}} </th>
                                    <th>{{trans('admin.Height')}} </th>
                                    <th>{{trans('admin.Weight')}} </th>
                                    <th>{{trans('admin.Saller_Point')}} </th>
                                    <th>{{trans('admin.Customer_Point')}} </th>
                                    <th>{{trans('admin.Sub_Cost')}} </th>
                                    <th>{{trans('admin.Subscribe_Type')}} </th>
                                    <th>{{trans('admin.Validity')}} </th>
                                    <th>{{trans('admin.Days_Notify')}} </th>
                                    <th>{{trans('admin.Store_Show')}} </th>
                                    <th>{{trans('admin.Show_Other_Store')}} </th>
                                    <th>{{trans('admin.Store_Type')}} </th>
                                    <th>{{trans('admin.Brief_Desc')}} </th>
                                    <th>{{trans('admin.Desc')}} </th>
                                    <th>{{trans('admin.Spec')}} </th>
                                    <th>{{trans('admin.Sub_Images')}} </th>
                                    <th>{{trans('admin.P_Type_Details')}}</th>
                                    <th>{{trans('admin.Tax')}}</th>
                                    <th>{{trans('admin.Code_Typeee')}}</th>
                                    <th>{{trans('admin.World_Code')}}</th>
                                    <th>{{trans('admin.Origin_Number')}}</th>
                                    <th>{{trans('admin.Origin_Country')}}</th>
                                    <th>{{trans('admin.SearchCode1')}}</th>
                                    <th>{{trans('admin.SearchCode2')}}</th>
                                    <th>{{trans('admin.Space')}}</th>
                                    <th>{{trans('admin.Storage')}}</th>
                                    <th>{{trans('admin.Processor')}}</th>
                                    <th>{{trans('admin.Camera')}}</th>
                                    <th>{{trans('admin.Screen')}}</th>
                                    <th>{{trans('admin.OS')}}</th>
                                    <th>{{trans('admin.Battery')}}</th>
                                    <th>{{trans('admin.Warranty')}}</th>
                                    <th>{{trans('admin.Color')}}</th>
                                    <th>{{trans('admin.Category')}}</th>
                                    <th>{{trans('admin.Model')}}</th>
                                    <th>{{trans('admin.Guess_Price')}}</th>
                                    <th>{{trans('admin.Offer_Start_Date')}}</th>
                                    <th>{{trans('admin.Offer_End_Date')}}</th>
                                    <th>{{trans('admin.Maximum_Sales_Qty')}}</th>
                                    <th>Cas No </th>
                                    <th>HSN </th>
                                    <th>Uni Code</th>

                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                    <td>


                                        @if(!empty($item->BrandX->Name))

                                        {{app()->getLocale() == 'ar' ?$item->BrandX->Name :$item->BrandX->NameEn}}
                                        @endif



                                    </td>
                                    <td>{{$item->Minimum}}</td>
                                    <td>{{$item->Maximum}}</td>
                                    <td>
                                        @if($item->Offer == 1)
                                        {{trans('admin.Yes')}}
                                        @else
                                        {{trans('admin.No')}}
                                        @endif
                                    </td>
                                    <td>{{$item->OfferPrice}}</td>
                                    <td>{{$item->Length}}</td>
                                    <td>{{$item->Width}}</td>
                                    <td>{{$item->Height}}</td>
                                    <td>{{$item->Weight}}</td>

                                    <td>{{$item->Saller_Point}}</td>
                                    <td>{{$item->Customer_Point}}</td>
                                    <td>{{$item->Sub_Cost}}</td>
                                    <td>
                                        @if(!empty($item->subscribe_typeX->Name))

                                        {{app()->getLocale() == 'ar' ?$item->subscribe_typeX->Name :$item->subscribe_typeX->NameEn}}
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->Validity == 0)
                                        {{trans('admin.NO')}}
                                        @else
                                        {{trans('admin.Yes')}}
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->Validity == 0)
                                        {{trans('admin.No_Found')}}
                                        @else
                                        {{$item->Days_Notify}}
                                        @endif

                                    </td>
                                    <td>
                                        @if($item->Store_Show == 0)
                                        {{trans('admin.NO')}}
                                        @else
                                        {{trans('admin.Yes')}}
                                        @endif

                                    </td>
                                    <td>
                                        @if($item->Show_Other_Store == 0)
                                        {{trans('admin.NO')}}
                                        @else
                                        {{trans('admin.Yes')}}
                                        @endif

                                    </td>
                                    <td>
                                        @if($item->Store_Show == 0)
                                        {{trans('admin.No_Found')}}
                                        @else
                                        @if($item->Store_Type == 0)
                                        {{trans('admin.Recently')}}
                                        @elseif($item->Store_Type == 1)
                                        {{trans('admin.Special')}}
                                        @elseif($item->Store_Type == 2)
                                        {{trans('admin.Finaly')}}
                                        @endif

                                        @endif
                                    </td>
                                    <td>

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Brief_Desc{{$item->id}}">
                                            {{trans('admin.Brief_Desc')}}
                                        </button>
                                    </td>
                                    <td>

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Desc{{$item->id}}">
                                            {{trans('admin.Desc')}}
                                        </button>
                                    </td>
                                    <td>

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Spec{{$item->id}}">
                                            {{trans('admin.Spec')}}
                                        </button>
                                    </td>

                                    <td>

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Sub_Images{{$item->id}}">
                                            {{trans('admin.Sub_Images')}}
                                        </button>
                                    </td>
                                    <td>

                                        @if($item->P_Type == "Assembly")
                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Assembly{{$item->id}}">
                                            {{trans('admin.P_Type_Details')}}
                                        </button>
                                        @elseif($item->P_Type == "Single_Variable" or $item->P_Type == "Duble_Variable" )
                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Virable{{$item->id}}">
                                            {{trans('admin.P_Type_Details')}}
                                        </button>
                                        @elseif($item->P_Type == "Serial")
                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Serial{{$item->id}}">
                                            {{trans('admin.P_Type_Details')}}
                                        </button>

                                        @else
                                        {{trans('admin.No_Found')}}
                                        @endif
                                    </td>
                                    <td>

                                        @if(!empty($item->TaxX->Name))

                                        {{app()->getLocale() == 'ar' ?$item->TaxX->Name :$item->TaxX->NameEn}}
                                        @endif
                                    </td>
                                    <td>{{$item->Code_Type}}</td>
                                    <td>{{$item->World_Code}}</td>
                                    <td>{{$item->Origin_Number}}</td>
                                    <td>{{$item->Origin_Country}}</td>
                                    <td>{{$item->SearchCode1}}</td>
                                    <td>{{$item->SearchCode2}}</td>
                                    <td>{{$item->Space}}</td>
                                    <td>{{$item->Storage}}</td>
                                    <td>{{$item->Processor}}</td>
                                    <td>{{$item->Camera}}</td>
                                    <td>{{$item->Screen}}</td>
                                    <td>{{$item->OS}}</td>
                                    <td>{{$item->Battery}}</td>
                                    <td>{{$item->Warranty}}</td>
                                    <td>{{$item->Color}}</td>
                                    <td>{{$item->Category}}</td>
                                    <td>{{$item->Model}}</td>
                                    <td>{{$item->Guess_Price}}</td>
                                    <td>{{$item->Offer_Start_Date}}</td>
                                    <td>{{$item->Offer_End_Date}}</td>
                                    <td>{{$item->Maximum_Sales_Qty}}</td>

                                    <td>{{$item->Cas_No}}</td>
                                    <td>{{$item->HSN}}</td>
                                    <td>{{$item->Uni_Code}}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal Brief_Desc -->
<div class="modal fade" id="Brief_Desc{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">

                    @php
                    if(app()->getLocale() == 'ar'){

                    echo html_entity_decode($item->Arabic_Brief_Desc);
                    }else{
                    echo html_entity_decode($item->English_Brief_Desc) ;

                    }

                    @endphp


                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal Desc -->
<div class="modal fade" id="Desc{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">

                    @php
                    if(app()->getLocale() == 'ar'){

                    echo html_entity_decode($item->Ar_Desc);
                    }else{
                    echo html_entity_decode($item->En_Desc) ;

                    }

                    @endphp


                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal Spec -->
<div class="modal fade" id="Spec{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">

                    @php
                    if(app()->getLocale() == 'ar'){

                    echo html_entity_decode($item->Ar_Spec);
                    }else{
                    echo html_entity_decode($item->En_Spec) ;

                    }

                    @endphp


                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal Sub_Images -->
<div class="modal fade" id="Sub_Images{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">

                    @php
                    $subs=SubImages::where('Product',$item->id)->get();
                    @endphp

                    <div class="row">
                        @foreach($subs as $sub)
                        <div class="col-md-12">
                            <img src="{{Storage::url($sub->Image)}}" class="img-fluid">
                        </div>
                        @endforeach
                    </div>
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal Units -->
<div class="modal fade" id="Units{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Units')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div id="mobile-overflow" class="mt-3">
                    <table id="" class="table table-bordered table-hover table-striped mobile-width">
                        <thead>
                            <tr>
                                <th>{{trans('admin.Unit')}} </th>
                                <th>{{trans('admin.Rate')}} </th>
                                <th>{{trans('admin.Barcode')}} </th>
                                <th>{{trans('admin.Price')}} </th>
                                <th>{{trans('admin.Price_Two')}} </th>
                                <th>{{trans('admin.Price_Three')}} </th>
                                <th>{{trans('admin.Barcode')}} </th>
                                <th>{{trans('admin.QrCode')}} </th>
                            </tr>
                        </thead>
                        @php

                        $Units=ProductUnits::with('UnitX')->where('Product',$item->id)->get();
                        @endphp
                        <tbody id="">

                            @foreach($Units as $uni)
                            @php





                            $is_arabic =preg_match("/^[\x ٍِ]/i", $uni->Barcode);

                            if($is_arabic == 0){
                            $x=$uni->Barcode;
                            }else{
                            $x=1;
                            }

                            $y=DNS1D::getBarcodePNG($x, 'C39');
                            $z=DNS2D::getBarcodePNG("$x", 'QRCODE',100,100);


                            @endphp
                            <tr>


                                <td>
                                    @if(!empty($uni->UnitX->Name)) {{app()->getLocale() == 'ar' ?$uni->UnitX->Name :$uni->UnitX->NameEn}} @endif
                                </td>
                                <td>{{$uni->Rate}}</td>
                                <td>{{$uni->Barcode}}</td>
                                <td>{{$uni->Price}}</td>
                                <td>{{$uni->Price_Two}}</td>
                                <td>{{$uni->Price_Three}}</td>

                                <td>
                                    <a href="data:image/png;base64,{{$y}}" download> <img src="data:image/png;base64,{{$y}}" alt="barcode" class="long-barcode" /> </a>
                                </td>
                                <td>
                                    <a href="data:image/png;base64,{{$z}}" download> <img src="data:image/png;base64,{{$z}}" width="100%" height="100%" alt="QR" /> </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>{{trans('admin.Unit')}} </th>
                                <th>{{trans('admin.Rate')}} </th>
                                <th>{{trans('admin.Barcode')}} </th>
                                <th>{{trans('admin.Price')}} </th>
                                <th>{{trans('admin.Price_Two')}} </th>
                                <th>{{trans('admin.Price_Three')}} </th>
                                <th>{{trans('admin.Barcode')}} </th>
                                <th>{{trans('admin.QrCode')}} </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal Assembly -->
<div class="modal fade" id="Assembly{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Assembly')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="mt-3">
                    <table id="" class="table table-bordered table-hover table-striped ">
                        <thead>
                            <tr>
                                <th>{{trans('admin.P_Ar_Name')}} </th>
                                <th>{{trans('admin.P_En_Name')}} </th>
                                <th>{{trans('admin.P_Code')}} </th>
                                <th>{{trans('admin.Unit')}} </th>
                                <th>{{trans('admin.Qty')}} </th>
                                <th>{{trans('admin.Price')}} </th>
                                <th>{{trans('admin.Total')}} </th>
                            </tr>
                        </thead>
                        @php

                        $Assembls=AssemblyProducts::with('UnitX')->where('p_id',$item->id)->get();
                        @endphp
                        <tbody id="">

                            @foreach($Assembls as $asi)
                            <tr>
                                <td>{{$asi->P_Ar_Name}}</td>
                                <td>{{$asi->P_En_Name}}</td>
                                <td>{{$asi->P_Code}}</td>
                                <td>
                                    @if(!empty($asi->UnitX->Name)) {{app()->getLocale() == 'ar' ?$asi->UnitX->Name :$asi->UnitX->NameEn}} @endif
                                </td>
                                <td>{{$asi->Qty}}</td>
                                <td>{{$asi->Price}}</td>
                                <td>{{$asi->Total}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>{{trans('admin.P_Ar_Name')}} </th>
                                <th>{{trans('admin.P_En_Name')}} </th>
                                <th>{{trans('admin.P_Code')}} </th>
                                <th>{{trans('admin.Unit')}} </th>
                                <th>{{trans('admin.Qty')}} </th>
                                <th>{{trans('admin.Price')}} </th>
                                <th>{{trans('admin.Total')}} </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal Virable -->
<div class="modal fade" id="Virable{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Duble_Variable')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div class="mt-3">
                    <form action="{{url('MultiDeleteVira')}}" method="post">
                        {!! csrf_field() !!}
                        <table id="" class="table table-bordered table-hover table-striped">
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Virable')}} </th>
                                    @if($item->P_Type == "Duble_Variable")
                                    <th>{{trans('admin.Virable')}} </th>
                                    @endif
                                    <th>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fal fa-trash"></i>
                                        </button>
                                    </th>
                                </tr>
                            </thead>
                            @php
                            $Viraas=ProductsVira::with('V1X','V2X')->where('Product',$item->id)->get();
                            @endphp
                            <tbody id="">

                                @foreach($Viraas as $v)
                                <tr>
                                    <td>

                                        @if(!empty($v->V1X->Name))

                                        {{app()->getLocale() == 'ar' ?$v->V1X->Name :$v->V1X->NameEn}}
                                        @endif
                                    </td>
                                    @if($item->P_Type == "Duble_Variable")
                                    <td>
                                        @if(!empty($v->V2X->Name))
                                        {{app()->getLocale() == 'ar' ?$v->V2X->Name :$v->V2X->NameEn}}

                                        @endif
                                    </td>
                                    @endif
                                    <td>
                                        <input type="checkbox" name="Vira[]" value="{{$v->id}}">
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>{{trans('admin.Virable')}} </th>
                                    @if($item->P_Type == "Duble_Variable")
                                    <th>{{trans('admin.Virable')}} </th>
                                    @endif
                                </tr>
                            </tfoot>
                        </table>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Serial -->
<div class="modal fade" id="Serial{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Serial')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">

                <div class="row">
                    <select class="select2 form-control" id="store">
                        <option value="">{{trans('admin.Store')}}</option>
                        @foreach($Stores as $store)
                        <option value="{{$store->id}}">
                            {{app()->getLocale() == 'ar' ?$store->Name :$store->NameEn}}
                        </option>
                        @endforeach
                    </select>
                    <input type="hidden" id="product" value="{{$item->id}}">
                </div>

                <form action="{{url('EditSerialQty')}}" method="get">
                    <div class="row mt-3">

                        <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Code')}}
                                        <button type="submit" class="btn btn-success">
                                            <i class="fal fa-edit"></i>
                                        </button>
                                    </th>
                                    <th>
                                        {{trans('admin.Actions')}}
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="SERIAL">

                            </tbody>
                        </table>
                    </div>
                </form>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Additions -->
<div class="modal fade" id="Additions{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Additions')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            @php $Additions=AdditionalProducts::with('AdditionalProductX')->where('Product',$item->id)->get(); @endphp
            <div class="modal-body">
                @if($item->P_Type != "Variable_Aggregate")



                <div class="row">

                    @foreach($Additions as $add)
                    <div class="col-md-12">
                        @if(!empty($add->AdditionalProductX->P_Ar_Name))
                        {{app()->getLocale() == 'ar' ?$add->AdditionalProductX->P_Ar_Name :$add->AdditionalProductX->P_En_Name}}
                        @endif
                    </div>
                    @endforeach

                </div>


                @else

                <form action="{{url('PostEditAddittionAV')}}" method="post">
                    @csrf

                    <input type="hidden" name="ID" value="{{$item->id}}">
                    <div class="form-row">

                        <div class="form-group col-md-8">
                            <label class="form-label" for=""> {{trans('admin.Product')}} </label>
                            <select class="select2 form-control w-100" id="AdditionProduct{{$item->id}}" onchange="AdditionPlus({{$item->id}})">
                                <option value="">{{trans('admin.Product')}}</option>

                                @foreach($AdditionsProducts as $addd)

                                <option value="{{$addd->id}}">{{app()->getLocale() == 'ar' ?$addd->P_Ar_Name :$addd->P_En_Name}}</option>
                                @endforeach
                            </select>
                        </div>



                        <div class="form-group col-md-4">
                            <button type="button" onclick="InsertAddition({{$item->id}})" class="btn btn-default" id="addAdditionP{{$item->id}}" style="display: none"><i class="fal fa-plus"></i></button>
                        </div>


                        <!-- datatable start -->
                        <div id="mobile-overflow">
                            <table id="" class="table table-bordered table-hover table-striped w-100 mobile-width">
                                <thead>
                                    <tr>
                                        <th>{{trans('admin.Product')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody id="dataAddition{{$item->id}}">

                                    @foreach($Additions as $de)

                                    <tr>
                                        <td>

                                            @if(!empty($de->AdditionalProductX->P_Ar_Name))
                                            {{app()->getLocale() == 'ar' ?$de->AdditionalProductX->P_Ar_Name :$de->AdditionalProductX->P_En_Name}}


                                            <input type="hidden" name="Additional_Product[]" value="{{$de->Additional_Product}}">
                                            @endif


                                        </td>
                                        <td>
                                            <button onclick="dleoAV({{$item->id}})" id="DelAV{{$item->id}}" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                        <!-- datatable end -->



                    </div>
                    <div class="form-row">
                        <button type="submit" class="btn btn-success"><i class="fal fa-edit"></i></button>
                    </div>
                </form>
                @endif








                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal Variable_Aggregate -->
<div class="modal fade" id="Variable_Aggregate{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Units')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div id="mobile-overflow" class="mt-3">
                    <table id="" class="table table-bordered table-hover table-striped mobile-width">
                        <thead>
                            <tr>
                                <th>{{trans('admin.Product_Code')}} </th>
                                <th>{{trans('admin.P_Ar_Name')}} </th>
                                <th>{{trans('admin.P_En_Name')}} </th>
                                <th>{{trans('admin.Unit')}} </th>
                                <th>{{trans('admin.Actions')}} </th>

                            </tr>
                        </thead>
                        @php

                        $VAs=VAProducts::with('UnitX')->where('Product',$item->id)->get();
                        @endphp
                        <tbody id="">

                            @foreach($VAs as $va)
                            @php $VAQtys=VAQty::with('MainVX','SubVX')->where('Product',$item->id)->where('VAProductID',$va->id)->get(); @endphp
                            <tr>
                                <td>{{$va->Product_Code}}</td>
                                <td>{{$va->P_Ar_Name}}</td>
                                <td>{{$va->P_En_Name}}</td>
                                <td>
                                    @if(!empty($va->UnitX->Name))
                                    {{app()->getLocale() == 'ar' ?$va->UnitX->Name :$va->UnitX()->NameEn}}
                                    @endif
                                </td>

                                <td> <a class="btn btn-danger" href="{{url('DeleteVAPro/'.$va->id)}}"><i class="fal fa-trash"></i></a></td>
                            </tr>
                            @foreach($VAQtys as $Qva)
                            <tr>
                                <td>
                                    @if(!empty($Qva->MainVX->Name))
                                    {{app()->getLocale() == 'ar' ?$Qva->MainVX->Name :$Qva->MainVX->Name}}
                                    @endif
                                </td>

                                <td>
                                    @if(!empty($Qva->SubVX->Name))
                                    {{app()->getLocale() == 'ar' ?$Qva->SubVX->Name :$Qva->SubVX->Name}}
                                    @endif
                                </td>
                                <td>{{$Qva->Qty}}</td>

                                <td> <a class="btn btn-danger" href="{{url('DeleteVAProQty/'.$Qva->id)}}"><i class="fal fa-trash"></i></a></td>
                            </tr>
                            @endforeach
                            @endforeach
                        </tbody>
                    </table>

                    <table id="" class="table table-bordered table-hover table-striped mobile-width">
                        <thead>
                            <tr>
                                <th>{{trans('admin.Virable')}} </th>
                                <th>{{trans('admin.Virable')}} </th>
                                <th>{{trans('admin.Price')}} </th>
                                <th>{{trans('admin.OfferPrice')}} </th>
                                <th>{{trans('admin.Actions')}} </th>
                            </tr>
                        </thead>
                        @php

                        $VAPrices=VAPrice::with('MainVX','SubVX')->where('Product',$item->id)->get();
                        @endphp
                        <tbody id="">

                            @foreach($VAPrices as $vaPrice)

                            <tr>

                                <td>


                                    @if(!empty($vaPrice->MainVX->Name))
                                    {{app()->getLocale() == 'ar' ?$vaPrice->MainVX->Name :$vaPrice->MainVX->Name}}
                                    @endif
                                </td>

                                <td>

                                    @if(!empty($vaPrice->SubVX->Name))
                                    {{app()->getLocale() == 'ar' ?$vaPrice->SubVX->Name :$vaPrice->SubVX->Name}}
                                    @endif
                                </td>
                                <td>{{$vaPrice->Price}}</td>
                                <td>{{$vaPrice->Offer_Price}}</td>
                                <td>

                                    <a class="btn btn-danger" href="{{url('DeleteVAPrice/'.$vaPrice->id)}}"><i class="fal fa-trash"></i></a>
                                </td>

                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <h2>{{trans('admin.AddNew')}}</h2>
                    <hr style="background: red">


                    <form action="{{url('PostEditQTYPriceAV')}}" method="post">
                        @csrf

                        <input type="hidden" name="ID" value="{{$item->id}}">
                        <!-- Variable_Aggregate -->
                        <div id="HideVariable_Aggregate" class="col-md-12 mb-12">
                            <div class="form-group col-md-12 mb-12">
                                <div class="input-items">
                                    <input style="background: brown;color: white;" type="text" id="searchVariableAggregate{{$item->id}}" onkeypress="SearchProAv({{$item->id}})" onkeyup="SearchProAv({{$item->id}})" class="form-control" placeholder="{{trans('admin.Search_For_Products')}} ">
                                </div>
                            </div>
                            <table class="table table-bordered table-hover table-striped w-100 hide-products-table">
                                <thead>
                                    <tr>
                                        <th>{{trans('admin.Product_Name')}}</th>
                                        <th>{{trans('admin.Product_Code')}}</th>
                                        <th>{{trans('admin.Unit')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody id="dataVariableAggregate{{$item->id}}">
                                </tbody>
                            </table>
                            <table class="table table-bordered table-hover table-striped w-100 hide-products-table">
                                <thead>
                                    <tr>
                                        <th>{{trans('admin.Product_Name')}}</th>
                                        <th>{{trans('admin.Product_Code')}}</th>
                                        <th>{{trans('admin.Unit')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody id="data-dt-VariableAggregate{{$item->id}}">


                                </tbody>
                            </table>

                            <div class="row" style="background: darkgray;padding: 15px;">
                                <div class="col-md-3">
                                    <label>{{trans('admin.Virable')}}</label>
                                    <select class=" form-control" id="PriceVASelect{{$item->id}}" onclick="SayPrice({{$item->id}})" onchange="SubSayPrice({{$item->id}})">

                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.Virable')}}</label>
                                    <select class="select2 form-control" id="PriceSubVASelect{{$item->id}}">

                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.Price')}}</label>
                                    <input type="number" step="any" class="form-control" id="PriceVA{{$item->id}}">
                                </div>

                                <div class="col-md-3">
                                    <label>{{trans('admin.Offer_Price')}}</label>
                                    <input type="number" step="any" class="form-control" id="OfferPriceVA{{$item->id}}">
                                </div>

                                <div class="col-md-3">
                                    <button class="btn btn-primary" onclick="AddPriceVA({{$item->id}})" type="button"><i class="fal fa-plus"></i></button>
                                </div>

                            </div>

                            <table class="table table-bordered table-hover table-striped w-100 hide-products-table" style="background: bisque;">
                                <thead>
                                    <tr>
                                        <th>{{trans('admin.Virable')}}</th>
                                        <th>{{trans('admin.Virable')}}</th>
                                        <th>{{trans('admin.Price')}}</th>
                                        <th>{{trans('admin.Offer_Price')}}</th>
                                        <th>{{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody id="data-price-VariableAggregate{{$item->id}}">
                                </tbody>
                            </table>


                        </div>

                        <div class="row">
                            <button type="submit" class="btn btn-success"><i class="fal fa-check"></i></button>
                        </div>
                    </form>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit -->
<div class="modal fade" id="EDITAV{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Edit')}} <strong>

                        {{app()->getLocale() == 'ar' ?$item->P_Ar_Name :$item->P_En_Name}}
                    </strong>
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="{{url('PostEditAV')}}" method="post">
                @csrf
                <input type="hidden" name="ID" value="{{$item->id}}">
                <div class="modal-body">
                    <div class="row">

                        <div class="form-group col-md-6">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Product_Ar_Name')}}
                            </label><span class="strick">*</span>
                            <input type="text" name="P_Ar_Name" value="{{$item->P_Ar_Name}}" placeholder="{{trans('admin.Product_Ar_Name')}} " class="form-control" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Product_En_Name')}}</label>
                            <input type="text" name="P_En_Name" value="{{$item->P_En_Name}}" placeholder="{{trans('admin.Product_En_Name')}} " class="form-control">
                        </div>

                        <div class="form-group col-md-6">
                            <label class="form-label" for=""> {{trans('admin.Brand')}} </label>
                            <select class="select2 form-control w-100" name="Brand">
                                <option value="">{{trans('admin.Brand')}}</option>
                                @foreach($Brands as $brand)
                                <option value="{{$brand->id}}" @if($item->Brand == $brand->id) selected @endif>

                                    {{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="form-group col-md-6">
                            <label class="form-label" for=""> {{trans('admin.Group')}} </label><span class="strick">*</span>
                            <select class="select2 form-control w-100" name="Group" required>
                                <option value="">{{trans('admin.Group')}}</option>
                                @foreach($ItemsGroups as $group)
                                <option value="{{$group->id}}" @if($item->Group == $group->id) selected @endif>

                                    {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}
                                </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="form-group col-md-2 mb-12">
                            <label class="form-label customize-input" for="imgInp"><i class="fal fa-image"></i> {{trans('admin.Image')}} </label>
                            <input type="file" name="Image">


                            @if(!empty($item->Image))
                            <img src="{{URL::to($item->Image)}}" class="control-img">
                            @endif
                        </div>



                        <div class="form-group col-md-12">
                            <label class="form-label" for="">{{trans('admin.Store_Show')}} </label>
                            <select class="select2 form-control w-100" name="Store_Show" id="Store_Show" onchange="Show()">
                                <option value="0" @if($item->Store_Show == 0) selected @endif >{{trans('admin.NO')}}</option>
                                <option value="1" @if($item->Store_Show == 1) selected @endif>{{trans('admin.Storee')}}</option>
                                <option value="2" @if($item->Store_Show == 2) selected @endif>{{trans('admin.Price_List')}}</option>
                                <option value="3" @if($item->Store_Show == 3) selected @endif>{{trans('admin.Both')}}</option>
                            </select>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="form-label" for="simpleinput">{{trans('admin.Ar_Desc')}} </label>
                            <textarea class="js-summernote" id="saveToLocal" name="Ar_Desc">
                            {{$item->Ar_Desc}}
                            </textarea>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="form-label" for="simpleinput"> {{trans('admin.En_Desc')}} </label>
                            <textarea class="js-summernote" id="saveToLocal" name="En_Desc">
                            {{$item->En_Desc}}
                            </textarea>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Ar_Spec')}} </label>
                            <textarea class="js-summernote" id="saveToLocal" name="Ar_Spec">
                            {{$item->Ar_Spec}}
                            </textarea>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="form-label" for="simpleinput"> {{trans('admin.En_Spec')}} </label>
                            <textarea class="js-summernote" id="saveToLocal" name="En_Spec">
                            {{$item->En_Spec}}
                            </textarea>
                        </div>



                        <div class="row">
                            <div class="form-group col-md-3 mb-3">
                                <label class="form-label" for=""> {{trans('admin.Sub_Images')}}</label>

                                <input type="file" name="SubImage[]" multiple>
                            </div>
                            @php $subs=SubImages::where('Product',$item->id)->get(); @endphp

                            @foreach($subs as $sub)
                            <div class="col-md-10">
                                <img src="../{{Storage::url($sub->Image)}}" class="control-img">
                            </div>
                            <div class="col-md-2">
                                <a href="{{url('DelSubImage/'.$sub->id)}}" class="btn btn-default"><i class="fal fa-times"></i></a>
                            </div>
                            @endforeach
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                    <button type="submit" class="btn btn-secondary">{{trans('admin.Edit')}}</button>

                </div>
            </form>
        </div>
    </div>
</div>



@endforeach

@endsection


@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


<style>
    th {
        width: 135px !important;
    }

</style>

<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>

<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2({
                ajax: {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params) {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination: {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup) {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo) {
                if (repo.loading) {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description) {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo) {
                return repo.full_name || repo.text;
            }
        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">
    $(".show-table").click(function() {
        $(".hide-table").show();
    });

</script>

<!-- Seria Scripts -->
<script>
    $(document).ready(function() {

        fetch_customer_data();

        function fetch_customer_data(store = '', product = '') {
            $.ajax({
                url: 'SerialProductsQtyFilter',
                method: 'GET',
                data: {
                    store: store,
                    product: product
                },
                dataType: 'json',
                success: function(data) {
                    $('.SERIAL').html(data.table_data);
                }
            })
        }


        $(document).on('change', '#store', function() {
            var store = $(this).val();
            var product = $('#product').val();
            fetch_customer_data(store, product);
        });


    });

</script>

<!-- Addition Product Table -->
<script>
    function InsertAddition(r) {
        var AdditionProduct = $('#AdditionProduct' + r).val();
        var AdditionProductName = $('#AdditionProduct' + r + ' option:selected').text();




        var table = ` <tr> 
                                <td>
                            ${AdditionProductName}
          <input type="hidden" name="Additional_Product[]" value="${AdditionProduct}">
                                </td>
         

                                <td>
                    <button id="DelDepP${r}" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("dataAddition" + r).innerHTML += table;
        document.getElementById("addAdditionP" + r).style.display = "none";

        $("#dataAddition" + r).on("click", "#DelDepP" + r, function(e) {
            $(this).closest("tr").remove();

        });
    }

    function AdditionPlus(r) {
        var AdditionProduct = $('#AdditionProduct' + r).val();

        if (AdditionProduct != "") {
            document.getElementById("addAdditionP" + r).style.display = "block";
        }


        if (AdditionProduct == "") {
            document.getElementById("addAdditionP" + r).style.display = "none";
        }

    }

    function dleoAV(r) {

        $("#dataAddition" + r).on("click", "#DelAV" + r, function(e) {
            $(this).closest("tr").remove();

        });



    }

</script>


<!-- Variable_Aggregate -->
<script>
    function SearchProAv(r) {

        var searchVariableAggregate = $('#searchVariableAggregate' + r).val();
        $.ajax({
            url: 'VariableAggregateFilter',
            method: 'GET',
            data: {
                searchVariableAggregate: searchVariableAggregate,
                r: r
            },
            dataType: 'json',
            success: function(data) {
                $('#dataVariableAggregate' + r).html(data.table_data);
            }
        })




    }

</script>

<!-- Add Variable_Aggregate -->
<script>
    function FunVA(r) {

        var P_Ar_Name = $("#P_Ar_Name" + r).val();
        var P_En_Name = $("#P_En_Name" + r).val();
        var Product = $("#Product" + r).val();
        var UnitID = $("#UnitAssem" + r).val();
        var UnitName = $("#UnitNameAssem" + r).val();
        var Barcode = $("#CodeAssem" + r).val();
        var LANG = $("#LANG").val();
        var RR = $("#RR" + r).val();


        document.getElementById("AddVA" + r).style.display = "none";
        document.getElementById("RowVA" + r).style.display = "none";
        var LANG = $("#LANG").val();
        if (LANG == 'ar') {
            var Nemo = P_Ar_Name;
        } else {
            var Nemo = P_En_Name;
        }

        var markup = "<tr><td><input type='hidden' name='P_Ar_NameVA[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_NameVA[]' value='" + P_En_Name + "'>" + Nemo + "</td><td><input type='hidden' name='P_CodeVA[]' value='" + Barcode + "'>" + Barcode + "</td><td><input type='hidden' name='UnitVA[]' value='" + UnitID + "'>" + UnitName + "</td><td>  <button id='DelVA" + r + "' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input id='Product_IDVA" + r + "' type='hidden' name='ProductVA[]' value='" + Product + "'></td></tr>";


        if (LANG == 'ar') {
            var VAName = 'المتغير';
            var VAQty = 'الكميه';
        } else {
            var VAName = 'Virable';
            var VAQty = 'Qty';

        }
        markup += "<tr id='rowVA" + r + "' style='background: cadetblue;'><td><lable>" + VAName + "</label><select onclick='Say(" + r + ")' onchange='SubSay(" + r + ")' class='select2 form-control' id='VASelect" + r + "'></select></td><td><lable>" + VAName + "</label><select  class='select2 form-control' id='VASubSelect" + r + "'></select></td><td><lable>" + VAQty + "</label><input type='number' step='any' id='VAQty" + r + "' class='form-control' value='1'></td><td><button class='btn btn-primary' onclick='AddToVA(" + r + ")' type='button'><i class='fal fa-plus'></i></button></td></tr><tr id='BodyVA" + r + "'></tr>";






        var Product_IDInp = $("#Product_IDVA" + r).val();

        if (Product != Product_IDInp) {
            $("#data-dt-VariableAggregate" + RR).append(markup);
        }


        $('#data-dt-VariableAggregate').on('click', '#DelVA' + r, function(e) {
            $(this).closest('tr').remove();
            $('#rowVA' + r).remove();
            $('#BodyVA' + r).remove();
        })


    }

    function Say(r) {
        $.ajax({
            url: 'VASelectFilterr',
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#VASelect' + r).empty();

                $.each(data, function(key, value) {

                    $('#VASelect' + r).append('<option value="' + key + '">' + value + '</option>');

                });



                var VA = $('#VASelect' + r).val();
                $.ajax({
                    url: 'VASubSelectFilterr',
                    type: "GET",
                    data: {
                        VA: VA
                    },
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('#VASubSelect' + r).empty();

                        $.each(data, function(key, value) {

                            $('#VASubSelect' + r).append('<option value="' + key + '">' + value + '</option>');

                        });





                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });





            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    }

    function SubSay(r) {

        var VA = $('#VASelect' + r).val();
        $.ajax({
            url: 'VASubSelectFilterr',
            type: "GET",
            data: {
                VA: VA
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#VASubSelect' + r).empty();

                $.each(data, function(key, value) {

                    $('#VASubSelect' + r).append('<option value="' + key + '">' + value + '</option>');

                });





            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    }

    function AddToVA(r) {

        var VA = $('#VASelect' + r).val();
        var VASub = $('#VASubSelect' + r).val();
        var VAName = $('#VASelect' + r + ' option:selected').text();
        var VASubName = $('#VASubSelect' + r + ' option:selected').text();
        var VAQty = $('#VAQty' + r).val();


        var markup = "<tr style='background: bisque;'><td><input type='hidden' name='ViraVA[]' value='" + VA + "'>" + VAName + "</td><td><input type='hidden' name='SubViraVA[]' value='" + VASub + "'>" + VASubName + "</td><td><input type='hidden' name='QtyVA[]' value='" + VAQty + "'><input type='hidden' name='ProductVAQty[]' value='" + r + "'>" + VAQty + "</td><td><i id='delVA" + r + "' class='fal fa-trash'></i></td></tr>";

        $("#BodyVA" + r).append(markup);



        $("#BodyVA" + r).on("click", "#delVA" + r, function(e) {
            $(this).closest("tr").remove();

        });



    }


    function AddPriceVA(r) {


        var PriceVASelect = $('#PriceVASelect' + r).val();
        var PriceSubVASelect = $('#PriceSubVASelect' + r).val();
        var PriceVASelectName = $('#PriceVASelect' + r + ' option:selected').text();
        var PriceSubVASelectName = $('#PriceSubVASelect' + r + ' option:selected').text();

        var PriceVA = $('#PriceVA' + r).val();
        var OfferPriceVA = $('#OfferPriceVA' + r).val();


        var table = ` <tr> 
                                <td>
                            ${PriceVASelectName}
          <input type="hidden" name="PriceVAMainV[]" value="${PriceVASelect}">
                                </td>

                    <td>
                            ${PriceSubVASelectName}
          <input type="hidden" name="PriceVASubV[]" value="${PriceSubVASelect}">
                                </td>


                    <td>
                            ${PriceVA}
          <input type="hidden" name="PriceVA[]" value="${PriceVA}">
                                </td>   

                          <td>
                            ${OfferPriceVA}
          <input type="hidden" name="OfferPriceVA[]" value="${PriceVA}">
                                </td>
         

                                <td>
                    <button id="DelPriceVA${r}" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-price-VariableAggregate" + r).innerHTML += table;


        $("#data-price-VariableAggregate" + r).on("click", "#DelPriceVA" + r, function(e) {
            $(this).closest("tr").remove();

        });

    }

    function SayPrice(r) {
        $.ajax({
            url: 'VASelectFilterr',
            type: "GET",
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#PriceVASelect' + r).empty();

                $.each(data, function(key, value) {

                    $('#PriceVASelect' + r).append('<option value="' + key + '">' + value + '</option>');

                });



                var VA = $('#PriceVASelect' + r).val();
                $.ajax({
                    url: 'VASubSelectFilterr',
                    type: "GET",
                    data: {
                        VA: VA
                    },
                    dataType: "json",
                    beforeSend: function() {
                        $('#loader').css("visibility", "visible");
                    },

                    success: function(data) {

                        $('#PriceSubVASelect' + r).empty();

                        $.each(data, function(key, value) {

                            $('#PriceSubVASelect' + r).append('<option value="' + key + '">' + value + '</option>');

                        });





                    },
                    complete: function() {
                        $('#loader').css("visibility", "hidden");
                    }
                });





            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });


    }

    function SubSayPrice(r) {

        var VA = $('#PriceVASelect' + r).val();
        $.ajax({
            url: 'VASubSelectFilterr',
            type: "GET",
            data: {
                VA: VA
            },
            dataType: "json",
            beforeSend: function() {
                $('#loader').css("visibility", "visible");
            },

            success: function(data) {

                $('#PriceSubVASelect' + r).empty();

                $.each(data, function(key, value) {

                    $('#PriceSubVASelect' + r).append('<option value="' + key + '">' + value + '</option>');

                });





            },
            complete: function() {
                $('#loader').css("visibility", "hidden");
            }
        });



    }

</script>


@endpush
