@extends('admin.index')
@section('content')
    @php
        use App\Services\Average;
        $average = new Average() ;
    @endphp



    <title>{{trans('admin.Items_Guide')}}</title>
    <style>
        @media (max-width: 600px) {
            .mt {
                margin-top: 10px;
            }
        }


    </style>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Stores')}} </a></li>
            <li class="breadcrumb-item active">{{trans('admin.Items_Guide')}} </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>
        <div class="subheader">

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i> {{trans('admin.Items_Guide')}}</i></span>
                        </h2>

                        <div class="panel-toolbar">
                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>


                            @include('admin.layouts.toolbar')
                        </div>

                        <div class="panel-toolbar">
                            <button class="btn btn-panel" data-action="panel-collapse" data-toggle="tooltip"
                                    data-offset="0,10" data-original-title="Collapse"></button>
                            <button class="btn btn-panel" data-action="panel-fullscreen" data-toggle="tooltip"
                                    data-offset="0,10" data-original-title="Fullscreen"></button>
                        </div>
                    </div>
                    <div class="panel-container show">
                        <div class="panel-content">
                            <div class="form-row" style="display: none">
                                <form class="col-md-3" action="{{url('TypeGuideFilter')}}" method="get">
                                    <div class="form-group ">
                                        <label class="form-label" for=""> {{trans('admin.Product_Type')}} </label>
                                        <select class="select2 form-control w-100" name="P_Type"
                                                onchange="this.form.submit()">
                                            <option value="">{{trans('admin.Product_Type')}} </option>
                                            <option value="Completed">{{trans('admin.Completed')}} </option>
                                            <option value="Raw">{{trans('admin.Raw')}} </option>
                                            <option value="Service">{{trans('admin.Service')}}</option>
                                            <option value="Subscribe">{{trans('admin.Subscribe')}}</option>
                                            <option value="Assembly">{{trans('admin.Assembly')}}</option>
                                            <option value="Industrial">{{trans('admin.Industrial')}}</option>
                                            <option value="Single_Variable">{{trans('admin.Single_Variable')}}</option>
                                            <option value="Duble_Variable">{{trans('admin.Duble_Variable')}}</option>
                                            <option value="Serial">{{trans('admin.Serial')}}</option>
                                        </select>
                                    </div>
                                </form>
                                <form class="col-md-3 mt" action="{{url('GroupGuideFilter')}}" method="get">
                                    <div class="form-group">
                                        <label class="form-label" for=""> {{trans('admin.Group')}} </label><span
                                            class="strick">*</span>
                                        <select class="select2 form-control w-100" name="Group"
                                                onchange="this.form.submit()">
                                            <option value="">{{trans('admin.Group')}}</option>
                                            @foreach($ItemsGroups as $group)
                                                <option value="{{$group->id}}">
                                                    {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </form>

                                <form class="col-md-3 mt" action="{{url('NameGuideilter')}}" method="get">
                                    <div class="row">
                                        <div class="form-group col-lg-10 col-10">
                                            <label class="form-label">{{trans('admin.Name')}}</label>
                                            <input type="text" class="form-control" name="Name" required>
                                        </div>
                                        <div class="form-group col-lg-2 col-2">
                                            <button type="submit" class="btn btn-default"
                                                    style="position: absolute;margin-top: 24px;margin-right: -24px;"><i
                                                    class="fal fa-search" onclick="this.form.submit()"></i>
                                            </button>

                                        </div>
                                    </div>
                                </form>
                                <form class="col-md-3" action="{{url('CodeGuideFilter')}}" method="get">
                                    <div class="row">
                                        <div class="form-group col-lg-10 col-10">
                                            <label class="form-label">{{trans('admin.Code')}}</label>
                                            <input type="text" class="form-control" name="Code" required>
                                        </div>
                                        <div class="form-group col-lg-2 col-2">
                                            <button class="btn btn-default" type="submit"
                                                    style="position: absolute;margin-top: 24px;margin-right: -24px;">
                                                <i class="fal fa-search" onclick="this.form.submit()"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- datatable start -->
                            <div id="mobile-overflow">
                                <table id="dt-basic-example"
                                       class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                    <thead class="bg-highlight">
                                    <tr>

                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Group')}} </th>
                                        <th>{{trans('admin.Brand')}} </th>
                                        <th>{{trans('admin.Unit')}} </th>
                                        <th>{{trans('admin.Rate')}} </th>
                                        <th>{{trans('admin.Code')}} </th>

                                        @if($Def->Guide_Product_Cost == 1)
                                            <th>{{trans('admin.Cost')}} </th>
                                        @endif

                                        @if(auth()->guard('admin')->user()->emp != 0)

                                            @if(auth()->guard('admin')->user()->price_1 == 1)
                                                <th>{{trans('admin.Price_One')}} </th>
                                            @endif

                                            @if(auth()->guard('admin')->user()->price_2 == 1)
                                                <th>{{trans('admin.Price_Two')}} </th>
                                            @endif

                                            @if(auth()->guard('admin')->user()->price_3 == 1)
                                                <th>{{trans('admin.Price_Three')}} </th>
                                            @endif
                                        @else
                                            <th>{{trans('admin.Price_One')}} </th>
                                            <th>{{trans('admin.Price_Two')}} </th>
                                            <th>{{trans('admin.Price_Three')}} </th>
                                        @endif

                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($items as $item)

                                        @php    $ty=$average->AverageCostGetUnit($item->Product,$item->P_Code,$Def->Store,$item->Unit); @endphp
                                        <tr>
                                            <td>

                                                {{app()->getLocale() == 'ar' ?$item->P_Ar_Name :$item->P_En_Name}}
                                            </td>
                                            <td>
                                                @if(!empty($item->Product()->first()->Group()->first()->Name))

                                                    {{app()->getLocale() == 'ar' ?$item->Product()->first()->Group()->first()->Name :$item->Product()->first()->Group()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>
                                                @if(!empty($item->Product()->first()->Brand()->first()->Name))

                                                    {{app()->getLocale() == 'ar' ?$item->Product()->first()->Brand()->first()->Name :$item->Product()->first()->Brand()->first()->NameEn}}
                                                @endif
                                            </td>
                                            <td>

                                                {{app()->getLocale() == 'ar' ?$item->Unit()->first()->Name :$item->Unit()->first()->NameEn}}
                                            </td>
                                            <td>
                                                {{$item->Rate}}
                                            </td>

                                            <td>
                                                {{$item->Barcode}}
                                            </td>

                                            @if($Def->Guide_Product_Cost == 1)
                                            <td>{{number_format((float)abs($ty), 2, '.', '')}}</td>
                                            @endif

                                            @if(auth()->guard('admin')->user()->emp != 0)

                                                @if(auth()->guard('admin')->user()->price_1 == 1)
                                                    <td>
                                                        <div class="form-group fill">

                                                            @if(!empty($item->Price))
                                                                {{$item->Price}}

                                                            @else
                                                                0
                                                            @endif
                                                        </div>
                                                    </td>
                                                @endif

                                                @if(auth()->guard('admin')->user()->price_2 == 1)
                                                    <td>
                                                        <div class="form-group fill">
                                                            @if(!empty($item->Price_Two))
                                                                {{$item->Price_Two}}

                                                            @else
                                                                0
                                                            @endif

                                                        </div>
                                                    </td>
                                                @endif

                                                @if(auth()->guard('admin')->user()->price_3 == 1)
                                                    <td>
                                                        <div class="form-group fill">
                                                            @if(!empty($item->Price_Three))
                                                                {{$item->Price_Three}}
                                                            @else
                                                                0
                                                            @endif
                                                        </div>
                                                    </td>
                                                @endif
                                            @else
                                                <td>
                                                    <div class="form-group fill">

                                                        @if(!empty($item->Price))
                                                            {{$item->Price}}

                                                        @else
                                                            0
                                                        @endif
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="form-group fill">
                                                        @if(!empty($item->Price_Two))
                                                            {{$item->Price_Two}}

                                                        @else
                                                            0
                                                        @endif

                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group fill">
                                                        @if(!empty($item->Price_Three))
                                                            {{$item->Price_Three}}
                                                        @else
                                                            0
                                                        @endif
                                                    </div>
                                                </td>


                                            @endif


                                        </tr>
                                    @endforeach

                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Name')}} </th>
                                        <th>{{trans('admin.Group')}} </th>
                                        <th>{{trans('admin.Brand')}} </th>
                                        <th>{{trans('admin.Unit')}} </th>
                                        <th>{{trans('admin.Rate')}} </th>
                                        <th>{{trans('admin.Code')}} </th>

                                        @if($Def->Guide_Product_Cost == 1)
                                            <th>{{trans('admin.Cost')}} </th>
                                        @endif

                                        @if(auth()->guard('admin')->user()->emp != 0)

                                            @if(auth()->guard('admin')->user()->price_1 == 1)
                                                <th>{{trans('admin.Price_One')}} </th>
                                            @endif

                                            @if(auth()->guard('admin')->user()->price_2 == 1)
                                                <th>{{trans('admin.Price_Two')}} </th>
                                            @endif

                                            @if(auth()->guard('admin')->user()->price_3 == 1)
                                                <th>{{trans('admin.Price_Three')}} </th>
                                            @endif
                                        @else
                                            <th>{{trans('admin.Price_One')}} </th>
                                            <th>{{trans('admin.Price_Two')}} </th>
                                            <th>{{trans('admin.Price_Three')}} </th>
                                        @endif

                                    </tr>
                                    </tfoot>
                                </table>
                            </div>

                            {{$items->Links()}}
                            <!-- datatable end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection

@push('js')
    <link rel="stylesheet" media="screen, print"
          href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        $(document).ready(function () {
            $(function () {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2({
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2({
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2({
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2({
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2({
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function (elm) {
                        return elm
                    }
                });

                function icon(elm) {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }

                $(".js-data-example-ajax").select2({
                    ajax: {
                        url: "https://api.github.com/search/repositories",
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return {
                                q: params.term, // search term
                                page: params.page
                            };
                        },
                        processResults: function (data, params) {
                            // parse the results into the format expected by Select2
                            // since we are using custom formatting functions we do not need to
                            // alter the remote JSON data, except to indicate that infinite
                            // scrolling can be used
                            params.page = params.page || 1;

                            return {
                                results: data.items,
                                pagination: {
                                    more: (params.page * 30) < data.total_count
                                }
                            };
                        },
                        cache: true
                    },
                    placeholder: 'Search for a repository',
                    escapeMarkup: function (markup) {
                        return markup;
                    }, // let our custom formatter work
                    minimumInputLength: 1,
                    templateResult: formatRepo,
                    templateSelection: formatRepoSelection
                });

                function formatRepo(repo) {
                    if (repo.loading) {
                        return repo.text;
                    }

                    var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                        "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                        "<div class='select2-result-repository__meta'>" +
                        "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                    if (repo.description) {
                        markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                    }

                    markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                        "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                        "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                        "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                        "</div>" +
                        "</div></div>";

                    return markup;
                }

                function formatRepoSelection(repo) {
                    return repo.full_name || repo.text;
                }
            });
        });

    </script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');


                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable({
                // responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                lengthChange: true,

                dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                    {
                        extend: 'colvis',
                        text: 'Column Visibility',
                        titleAttr: 'Col visibility',
                        className: 'btn-outline-default'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        titleAttr: 'Generate PDF',
                        className: 'btn-outline-danger btn-sm mr-1'
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        titleAttr: 'Generate Excel',
                        className: 'btn-outline-success btn-sm mr-1'
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        titleAttr: 'Generate CSV',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'copyHtml5',
                        text: 'Copy',
                        titleAttr: 'Copy to clipboard',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        titleAttr: 'Print Table',
                        className: 'btn-outline-primary btn-sm'
                    }
                ],
            });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


    <script>
        function Update(r) {
            var P = $('#Price_One' + r).val();
            var PP = $('#Price_Two' + r).val();
            var PPP = $('#Price_Three' + r).val();
            var Code = $('#Code' + r).val();
            var Show_Other_Store = $('#Show_Other_Store' + r).val();
            var Store_Show = $('#Store_Show' + r).val();

            $.ajax({
                url: 'UpdatePrice',
                method: 'GET',
                data: {
                    r: r,
                    P: P,
                    PP: PP,
                    PPP: PPP,
                    Code: Code,
                    Show_Other_Store: Show_Other_Store,
                    Store_Show: Store_Show
                },
                dataType: 'json',
                success: function (data) {

                    alert('Updated');

                }
            })
        }

    </script>

@endpush
