@extends('admin.index')
@section('content')
@php
use App\Models\ProductsPermissionToExchangeGoods;
@endphp
  <title>{{trans('admin.ExchangeGoodsSechdule')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Stores')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.ExchangeGoodsSechdule')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block">
                            <span class="js-get-date"></span></li>
                    </ol>


            <!-- Data -->
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.ExchangeGoodsSechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                       @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                              <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
        <table id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th> {{trans('admin.Account')}} </th>
                                                    <th> {{trans('admin.Store')}} </th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr @if($item->Edit == 1) class="edited" @elseif($item->Delete == 1) class="deleted"  @endif >
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                      <td>
                                     {{app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn}}
                                                       </td>

                                                        <td>
                                                          {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                    </td>

                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                           {{trans('admin.Data')}}
                                                        </button>
                                                    </td>
                                                    <td class="text-center">

                                                        @if($item->Edit == 0 and $item->Delete == 0)
             <a href="{{url('ExchangePrint/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print"></i>
                                                    </a>
                                                          @if($item->Status  == 0)

                                          <a href="{{url('DeletePremissionExchange/'.$item->id)}}" class="btn btn-danger" >
                                                    <i class="fal fa-trash"></i>
                                                    </a>


                                       <a href="{{url('EditPremissionExchange/'.$item->id)}}" class="btn btn-success" >
                                                    <i class="fal fa-edit"></i>
                                                    </a>



                                       <a href="{{url('TransferToSalesExchange/'.$item->id)}}" class="btn btn-default" data-toggle="tooltip" data-placement="top" title="" data-original-title="{{trans('admin.Trans_To_Sales_Bill')}}"><i class="fal fa-repeat"></i></a>

                                                        @endif

                                                        @endif

                                                            @if($item->Edit == 1)
                                                                <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                                            @elseif($item->Delete == 1)

                                                                <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>
                                                            @endif



                                                    </td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                   <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>

                                                    <th> {{trans('admin.Account')}} </th>

                                                    <th> {{trans('admin.Store')}} </th>

                                                    <th>{{trans('admin.Details')}}</th>
                                                     <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </tfoot>

                                        </table>

                                        {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>

  @foreach($items as $item)



                   <!-- Modal Show data -->
    <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                              {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div style="overflow:auto;">
        <table  class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>

                                                    <th> {{trans('admin.Draw')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>


                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                    <th> {{trans('admin.User')}} </th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr>

                                                      <td>{{$item->Draw}}</td>

                                                        <td>{{$item->Note}}</td>


                                                        <td>




                                     {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                    </td>
                                                            <td>
                                                     @if(!empty($item->Cost_Center))

                                    {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                                    @endif
                                                    </td>
                                                    <td>

                          {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                    </td>


                                                </tr>
                                                @endforeach

                                            </tbody>
                                            <tfoot>
                                                <tr>

                                                    <th> {{trans('admin.Draw')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>

                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                    <th> {{trans('admin.User')}} </th>

                                                </tr>
                                            </tfoot>

                                        </table>

                                        {{$items->Links()}}
                                        </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>


                        <!-- Modal Details -->
    <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=ProductsPermissionToExchangeGoods::where('Exchange',$item->id)->get();
                @endphp
                        <div class="mt-3">
                            <div style="overflow:auto">
                            <table id=""
                            class="table table-bordered table-hover table-striped " >
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.AvQty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>

                          {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
      @if(!empty($detail->V1))    (      {{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
        @if(!empty($detail->V2))    (      {{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  )  @endif
                                    </td>
                                    <td>
                     {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}
                                    </td>
                                    <td>{{$detail->AvQty}}</td>
                                    <td>{{$detail->Qty}}</td>




                                    <td>

                    {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}
                                    </td>

                                    <td>{{$detail->Exp_Date}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                  <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.AvQty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>

                                    <th>{{trans('admin.Store')}} </th>

                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                            </tfoot>
                        </table>
                        </div>
                        <table class="table table-bordered table-hover table-striped w-100 mt-4">
                            <tbody>
                                <tr>
                                    <td>{{trans('admin.Product_Numbers')}}</td>
                                    <td>{{$item->Product_Numbers}}</td>

                                    <td>{{trans('admin.Total_Qty')}}</td>
                                    <td>{{$item->Total_Qty}}</td>




                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>

            </div>

@endforeach



@endsection


@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

	<style>
	@media print {
		body * {
			visibility: hidden;
		}
		.modal-content * {
			visibility: visible;
			overflow: visible;
		}
		.main-page * {
			display: none;
		}
		.modal {
			position: absolute;
			left: 0;
			top: -220px;
			margin: 0;
			padding: 0;
			min-height: 550px;
			visibility: visible;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}
		.modal-dialog {
			visibility: visible !important;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}

        .page-content{
            display:none;
        }
        @page {

		size: a4;

    }

	}
	</style>

    <!-- Search Selecet -->
<script>
    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                    data: function (params) {
                        var query = {
                            search: params.term,
                        };
                        if (params.term == "*") query.items = [];
                        return { json: JSON.stringify(query) };
                    },
                },
            });

            $("#Emp").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });
        });
    });
</script>

@endpush
