@extends('admin.index')
@section('content')
@php
use App\Models\SalesDefaultData;
$Def=SalesDefaultData::orderBy('id','desc')->first();
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp

<title>{{trans('admin.TransferWithoutBill')}}</title>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
      <li class="breadcrumb-item active">{{trans('admin.TransferWithoutBill')}} </li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
   </ol>
   <form id="form" action="{{url('AddReturnWithoutBill')}}" method="post" enctype="multipart/form-data">
      {!! csrf_field() !!}
      @honeypot
      <div class="row">
         <div class="col-lg-12">
            <div id="panel-2" class="panel" style="background: #ccbed59e;">
               <div class="panel-hdr">
                  <h2>
                     <span class="fw-300"><i>   {{trans('admin.TransferWithoutBill')}}  </i></span>
                  </h2>
               </div>
               <div class="panel-container show">
                  <span id="ex"> @include('admin.layouts.messages')</span> 
                  <div class="panel-content">
                     <div class="form-row">
                         
                        <div class="form-group col-lg-1">
                           <label class="form-label" for="simpleinput">{{trans('admin.Sales_Code')}} </label>
                           <input type="text" value="{{$Code}}" class="form-control " disabled>
                           <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                        </div>
                         
                         
                                           <div class="form-group col-lg-1">
                           <label class="form-label" for="simpleinput">{{trans('admin.Purchases_Code')}} </label>
                           <input type="text" value="{{$CodeP}}" class="form-control " disabled>
                           <input type="hidden" name="CodeP" value="{{$CodeP}}" class="form-control">
                        </div>
                         
            
                      <div class="form-group col-lg-2">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                </div>
                                

                         
                        <div class="form-group col-lg-2">
                           <label class="form-label" for="">{{trans('admin.Store')}}</label>
                           <select class="select2 form-control w-100" id="store" name="Store" required>
                           @foreach($Stores as $stor)    
                           <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>
                            {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}     
                           </option>
                           @endforeach    
                           </select>
                        </div>
                         
                         
                        <div class="form-group col-lg-2">
                           <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                           <select class="select2 form-control w-100" id="SSAFE" name="Safe" required>
                           @foreach($Safes as $safe)    
                           <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                  {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}      
                           </option>
                           @endforeach    
                           </select>
                        </div>
             
                        <div class="form-group col-lg-2" style="display: none">
                           <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                           <select class="select2 form-control w-100" name="Coin" required>
                              <option value=""> {{trans('admin.Coin')}}</option>
                              @foreach($Coins as $coin)    
                              <option value="{{$coin->id}}" @if($Def->Coin == $coin->id) selected @endif>
                       {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}    
                              </option>
                              @endforeach  
                           </select>
                        </div>
                     
                 
                        <div class="form-group col-lg-2" style="display: none">
                           <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                           <input type="text" name="Draw" value="1" class="form-control" required>
                        </div>
                     
                    
                          <div class="form-group col-lg-2">
                           <label class="form-label" for=""> {{trans('admin.Payment_Method')}}</label>
                           <select class="select2 form-control w-100" name="Payment_Method" id="Payment_Method" onchange="Statuss()" required>
                   
                          <option value="Cash">{{trans('admin.Cash')}} </option>
            
                           </select>
                        </div>
                         <input type="hidden" name="Status" value="1">
            
            
                       
                        <div class="form-group col-lg-2" style="display: none">
                           <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                           <select class="select2 form-control w-100" name="Cost_Center">
                              <option value=""> {{trans('admin.Cost_Center')}}</option>
                              @foreach($CostCenters as $cost)    
                              <option value="{{$cost->id}}">
                           {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}  
                              </option>
                              @endforeach  
                           </select>
                        </div>
                       
                        <div class="form-group col-lg-2">
                           <label class="form-label" for="">{{trans('admin.Account')}} ({{trans('admin.Client')}})</label>
                           <select  class="select2 form-control w-100" id="client" name="Client" required>
                          @if(!empty($Def->Client()->first()->Name))    <option value="{{$Def->Client}}">     
                               {{app()->getLocale() == 'ar' ?$Def->Client()->first()->Name :$Def->Client()->first()->NameEn}}   </option>  @endif
                           </select>
                        </div>

        
        
                        <div class="form-group col-lg-3" style="display: none">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Account_Credit')}} </label>
                           <input type="text" id="AccountCredit" value="0" class="form-control " disabled>
                        </div>
               
                       
                     </div>
                  </div>
               </div>
            </div>
         </div>
          
          
                  <!-- Purchases -->
             <div class="col-xl-12">
            <div id="panel-1" class="panel">
               <div class="panel-container show">
                  <div class="panel-content" style="background: #fad2f796;">
                     <div class="row">
                         <h2>{{trans('admin.Purchases')}}</h2>
                              <div class="form-group col-lg-12">
                           <label class="form-label" for="simpleinput">  </label>
                           <div class="input-items" style="position:relative;">
                              <input type="text" id="searchP" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                              <i class="fal fa-barcode-alt" style="position:absolute;top:5px;left:3px;"></i>
                           </div>
                        </div>

                     </div>
                     <div id="mobile-overflow">
                        <table 
                           class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color1 mt-2">
                           <thead>
                              <tr>
                                 <th>{{trans('admin.Name')}}</th>
                                 <th style="padding:12px 20px;">{{trans('admin.Unit')}}</th>
                                 <th>{{trans('admin.Code')}}</th>
                                 <th>{{trans('admin.Qty')}}</th>
                                 <th>{{trans('admin.Price')}}</th>
                                  
                                     @if($show->Disc == 1)
                                 <th>{{trans('admin.Discount')}}</th>
                                  @endif
                                     @if($show->Tax == 1)
                                 <th>{{trans('admin.Tax')}}</th>
                                  @endif
                                     @if($show->Store == 1)
                                 <th style="padding:12px 20px;">{{trans('admin.Store')}}</th>
                                  @endif
                                  

                                 @if($show->Expire_Date == 1) 
                                 <th>{{trans('admin.Exp_Date')}}</th>
                                 @endif
                                 <th>{{trans('admin.Actions')}}</th>
                              </tr>
                           </thead>
                           <tbody class="DataP" id="DataP">
                           </tbody>
                        </table>
                     </div>
                     <!-- datatable start -->
                     <div id="mobile-overflow">
                        <table id="dtP"
                           class="table table-bordered table-hover table-striped w-100 mobile-width table-color2">
                           <thead>
                              <tr>
                                 <th>{{trans('admin.Name')}}</th>
                                 <th>{{trans('admin.Unit')}}</th>
                                 <th>{{trans('admin.Code')}}</th>
                                 <th>{{trans('admin.Qty')}}</th>
                                 <th>{{trans('admin.Price')}}</th>
                                     @if($show->Disc == 1)
                                 <th>{{trans('admin.Discount')}}</th>
                                  @endif
                                    @if($show->TotalBfTax == 1)
                                 <th>{{trans('admin.Total_Bf_Taxes')}}</th>
                                         @endif
                                        @if($show->Tax == 1)
                                 <th>{{trans('admin.Tax')}}</th>
                                  @endif
                                 <th>{{trans('admin.Total')}}</th>
                                  
                                        @if($show->Store == 1)
                                 <th>{{trans('admin.Store')}}</th>
                                  @endif
     
                                 @if($show->Expire_Date == 1) 
                                 <th>{{trans('admin.Exp_Date')}}</th>
                                 @endif
                                 <th>{{trans('admin.Actions')}}</th>
                              </tr>
                           </thead>
                           <tbody id="data-dtP">
                           </tbody>
                        </table>
                     </div>
                     <!-- datatable end -->
                     <div class="form-row">
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Product_Numbers')}} </label>
                           <input type="text" id="Product_NumbersP" disabled  class="form-control">
                           <input type="hidden" id="Product_NumbersHideP" name="Product_NumbersP">
                        </div>
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_Qty')}} </label>
                           <input type="text" id="Total_QtyP" disabled  class="form-control">
                           <input type="hidden" id="Total_QtyHideP" name="Total_QtyP">
                           <input type="hidden" id="Total_DiscountP" disabled  class="form-control">
                           <input type="hidden" id="Total_DiscountHideP" name="Total_DiscountP">   
                           <input type="hidden" id="Total_Bf_TaxesP" disabled  class="form-control">
                           <input type="hidden" id="Total_Bf_TaxesHideP" name="Total_BF_TaxesP">    
                        </div>
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput">  {{trans('admin.Total_Price')}}</label>
                           <input type="text" id="Total_PriceP" disabled  class="form-control">
                           <input type="hidden" id="Total_PriceHideP" name="Total_PriceP">
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_Discount')}}  </label>
                           <input type="text" id="Total_DiscountTTP" disabled  class="form-control">
                           <input type="hidden" id="Total_DiscountHideTTP" name="Total_DiscountP">
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_af_Discount')}} </label>
                           <input type="text" class="form-control" id="TAFterDP"  disabled>
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput">   {{trans('admin.Total_Taxes')}}</label>
                           <input type="text" id="Total_TaxesP" disabled  class="form-control">
                           <input type="hidden" id="Total_TaxesHideP" name="Total_TaxesP">
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_Bill')}} </label>
                           <input type="text" id="Total_BillP" disabled  class="form-control">
                        </div>
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                           <input type="text" class="form-control" id="resdiualP" name="DiscountBillP" value="0" onkeyup="Statuss()">
                        </div>
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_Net')}} </label>
                           <input type="text" id="Total_PriceWP" disabled  class="form-control">
                        </div>
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Paid')}} </label>
                           <input type="text" name="PayP" id="paidP"   class="form-control">
                        </div>
                         
                         
                
                     </div>
                  </div>
               </div>
            </div>
         </div>
          
          
          
          
          <!-- Sales -->
         <div class="col-xl-12">
            <div id="panel-1" class="panel">
               <div class="panel-container show">
                  <div class="panel-content" style="background: #fad2f796;">
                     <div class="row">
            <h2>{{trans('admin.Sales')}}</h2>
                              <div class="form-group col-lg-12">
                           <label class="form-label" for="simpleinput">  </label>
                           <div class="input-items" style="position:relative;">
                              <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                              <i class="fal fa-barcode-alt" style="position:absolute;top:5px;left:3px;"></i>
                           </div>
                        </div>
                     </div>
                     <div id="mobile-overflow">
                        <table
                           class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color1 mt-2">
                           <thead>
                              <tr>
                                 <th>{{trans('admin.Name')}}</th>
                                 <th>{{trans('admin.Unit')}}</th>
                                 <th>{{trans('admin.Code')}}</th>
                                 @if($show->Patch_Number == 1)  
                                 <th>{{trans('admin.Patch_Number')}}</th>
                                 @endif   
                                  @if($show->AvQty == 1)
                                <th>{{trans('admin.AvQty')}}</th>
                                  @endif  
                                 <th>{{trans('admin.Qty')}}</th>
                                 <th>{{trans('admin.Price')}}</th>
                                  @if($show->Disc == 1)
                                 <th>{{trans('admin.Discount')}}</th>
                                  @endif
                                     @if($show->Tax == 1)
                                 <th>{{trans('admin.Tax')}}</th>
                                  @endif
                                     @if($show->Store == 1)
                                 <th style="padding:12px 20px;">{{trans('admin.Store')}}</th>
                                  @endif
                                 @if($show->Expire_Date == 1)  
                                 <th>{{trans('admin.Exp_Date')}}</th>
                                 @endif
                                 <th>{{trans('admin.Actions')}}</th>
                              </tr>
                           </thead>
                           <tbody class="Data" id="Data">
                           </tbody>
                        </table>
                     </div>
                     <!-- datatable start -->
                     <div id="mobile-overflow">
                        <table id="dt"
                           class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color2">
                           <thead>
                              <tr>
                                 <th>{{trans('admin.Name')}}</th>
                                 <th>{{trans('admin.Unit')}}</th>
                                 <th>{{trans('admin.Code')}}</th>
                                 @if($show->Patch_Number == 1)  
                                 <th>{{trans('admin.Patch_Number')}}</th>
                                 @endif    
                                    @if($show->AvQty == 1)
                                <th>{{trans('admin.AvQty')}}</th>
                                  @endif  
                                 <th>{{trans('admin.Qty')}}</th>
                                 <th>{{trans('admin.Price')}}</th>
                                @if($show->Disc == 1)
                                 <th>{{trans('admin.Discount')}}</th>
                                  @endif
                                    @if($show->TotalBfTax == 1)
                                 <th>{{trans('admin.Total_Bf_Taxes')}}</th>
                                         @endif
                                        @if($show->Tax == 1)
                                 <th>{{trans('admin.Tax')}}</th>
                                  @endif
                                 <th>{{trans('admin.Total')}}</th>
                                  
                                        @if($show->Store == 1)
                                 <th>{{trans('admin.Store')}}</th>
                                  @endif
                                 @if($show->Expire_Date == 1)  
                                 <th>{{trans('admin.Exp_Date')}}</th>
                                 @endif
                                 <th>{{trans('admin.Actions')}}</th>
                              </tr>
                           </thead>
                           <tbody id="data-dt">
                           </tbody>
                        </table>
                     </div>
                     <!-- datatable end -->
                     <div class="form-row">
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Product_Numbers')}} </label>
                           <input type="text" id="Product_Numbers" disabled  class="form-control">
                           <input type="hidden" id="Product_NumbersHide" name="Product_Numbers">
                        </div>
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_Qty')}} </label>
                           <input type="text" id="Total_Qty" disabled  class="form-control">
                           <input type="hidden" id="Total_QtyHide" name="Total_Qty">
                        </div>
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput">  {{trans('admin.Total_Price')}}</label>
                           <input type="text" id="Total_Price" disabled  class="form-control">
                           <input type="hidden" id="Total_PriceHide" name="Total_Price">
                           <input type="hidden" id="Total_Bf_Taxes" disabled  class="form-control">
                           <input type="hidden" id="Total_Bf_TaxesHide" name="Total_BF_Taxes">
                           <input type="hidden" id="Total_Discount" disabled  class="form-control">
                           <input type="hidden" id="Total_DiscountHide" name="Total_Discount"> 
                              <input type="hidden" id="TotalCost" name="Total_Cost"> 
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput">   {{trans('admin.Total_Discount')}} </label>
                           <input type="text" id="Total_DiscountTT" disabled  class="form-control">
                           <input type="hidden" id="Total_DiscountHideTT" name="Total_Discount">           
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_af_Discount')}} </label>
                           <input type="text" class="form-control" id="TAFterD"  disabled>
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput">   {{trans('admin.Total_Taxes')}}</label>
                           <input type="text" id="Total_Taxes" disabled  class="form-control">
                           <input type="hidden" id="Total_TaxesHide" name="Total_Taxes">
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_Bill')}} </label>
                           <input type="text" id="Total_Bill" disabled  class="form-control">
                        </div>
                         
                            @if($show->TaxOnTotal == 1)
                                  <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.TaxOnTotal')}} </label>
                           <select class="select2 form-control" name="TaxOnTotal">
                                <option value="No">{{trans('admin.No')}}</option>      
                                <option value="Yes">{{trans('admin.Yes')}}</option>      
                                      </select>
                        </div>
                         
                                      <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.TaxOnTotalType')}} </label>
                           <select class="select2 form-control" name="TaxOnTotalType" id="TaxOnTotalType" onchange="TaxOn()">
                                <option value="">{{trans('admin.TaxOnTotalType')}}</option>    
                               @foreach($Taxes as $tax)
                                <option value="{{$tax->id}}">{{$tax->Name}}</option> 
                               @endforeach
                                      </select>
                        </div>
                         
                         
                            <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput"> {{trans('admin.ProfitTax')}} </label>
                           <input type="text" class="form-control" id="ProfitTax" name="ProfitTax" value="0" readonly>
                        </div>
                         @endcan
                         
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Discount_Bill')}} </label>
                           <input type="text" class="form-control" id="resdiual" name="DiscountBill" value="0" onkeyup="Statuss()">
                        </div>
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Total_Net')}} </label>
                           <input type="text" class="form-control" id="Total_PriceW"  disabled>
                        </div>
                                 <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Paid')}} </label>
                                    <input type="number" step="any" name="Pay" id="paid" onkeyup="PayInstall()" onclick="PayInstall()"   class="form-control">

                                        </div>
                         @can('نسبه الربح')
                        <div class="form-group col-lg-3">
                           <label class="form-label" for="simpleinput"> {{trans('admin.ProfitPrecent')}} </label>
                           <input type="number" step="any" name="ProfitPrecent" id="ProfitPrecent"   class="form-control" value="0" readonly>
                                <span style="color: red" id="proPrecent"></span>%
                        </div>
                         @endcan
                         
                                        <div class="form-group col-lg-12">
                           <label class="form-label" for="simpleinput"> {{trans('admin.Dif')}} </label>
                           <input type="text" name="Dif" id="Dif"   class="form-control" readonly>
                        </div>
                     </div>
                     <div class="buttons mt-3" id="Submit" style="display: none">
                        <input type="hidden" id="sp" name="SP">                 
                        <button type="button"  class="btn btn-primary" onclick="SPS()"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                        @if($show->A4 == 1)                
                        <button type="button"  class="btn btn-primary" onclick="SPP()"><i class="fal fa-save"></i>  {{trans('admin.SaveandPrint')}} </button>
                        @endif
                        @if($show->CM8 == 1)           
                        <button type="button"  class="btn btn-primary" onclick="SPP8()"><i class="fal fa-save"></i>  {{trans('admin.SaveandPrint8')}} </button>    
                        @endif
                        @if($show->A5 == 1) 
                        <button type="button"  class="btn btn-primary" onclick="SPP5()"><i class="fal fa-save"></i>  {{trans('admin.SaveandPrintA5')}} </button>                            
                        @endif
                     </div>
                  </div>
               </div>
            </div>
         </div>
          
          
  
          
      </div>
   </form>
   <input type="hidden" id="ED" value="{{$show->Expire_Date}}">   
       <input type="hidden" id="DISCSHOW" value="{{$show->Disc}}">
   <input type="hidden" id="TOTBFSHOW" value="{{$show->TotalBfTax}}">
   <input type="hidden" id="TAXSHOW" value="{{$show->Tax}}">
   <input type="hidden" id="STORESHOW" value="{{$show->Store}}">
   <input type="hidden" id="AVQTYSHOW" value="{{$show->AvQty}}">
   <input type="hidden" id="SHW"  value="0"> 
   @if($Def->Price_Sale == 0)
   @if(auth()->guard('admin')->user()->emp != 0)
   @if(auth()->guard('admin')->user()->price_sale == 1)
   <input type="hidden" id="PRICEOPEN" value="1">  
   @else
   <input type="hidden" id="PRICEOPEN" value="0">    
   @endif
   @else
   <input type="hidden" id="PRICEOPEN" value="0">    
   @endif
   @else
   @if(auth()->guard('admin')->user()->emp != 0)
   @if(auth()->guard('admin')->user()->price_sale == 1)
   <input type="hidden" id="PRICEOPEN" value="1">  
   @else
   <input type="hidden" id="PRICEOPEN" value="0">    
   @endif
   @else
   <input type="hidden" id="PRICEOPEN" value="1">    
   @endif
   @endif
   @if(auth()->guard('admin')->user()->emp != 0)
   @if(auth()->guard('admin')->user()->discount == 1)
   <input type="hidden" id="DISCOPEN" value="1">  
   @else
   <input type="hidden" id="DISCOPEN" value="0">    
   @endif
   @else
   <input type="hidden" id="DISCOPEN" value="1">    
   @endif
   @if($show->Patch_Number == 1)
   <input type="hidden" id="Patch" value="1">
   @else
   <input type="hidden" id="Patch" value="0">
   @endif
   @if($Def->Discount == 0)
   <input type="hidden" id="DIS" value="0">  <!-- Number -->
   @else
   <input type="hidden" id="DIS" value="1">  <!-- Precent -->
   @endif
    
    @if(app()->getLocale() == 'ar' ) 
<input type="hidden" id="LANG" value="ar">
@else
<input type="hidden" id="LANG" value="en">
@endif


</main>


@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
   var autoSave = $('#autoSave');
   var interval;
   var timer = function()
   {
       interval = setInterval(function()
       {
           //start slide...
           if (autoSave.prop('checked'))
               saveToLocal();
   
           clearInterval(interval);
       }, 3000);
   };
   
   //save
   var saveToLocal = function()
   {
       localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
       console.log("saved");
   }
   
   //delete 
   var removeFromLocal = function()
   {
       localStorage.removeItem("summernoteData");
       $('#saveToLocal').summernote('reset');
   }
   
   $(document).ready(function()
   {
       //init default
       $('.js-summernote').summernote(
       {
           height: 200,
           tabsize: 2,
           placeholder: "Type here...",
           dialogsFade: true,
           toolbar: [
               ['style', ['style']],
               ['font', ['strikethrough', 'superscript', 'subscript']],
               ['font', ['bold', 'italic', 'underline', 'clear']],
               ['fontsize', ['fontsize']],
               ['fontname', ['fontname']],
               ['color', ['color']],
               ['para', ['ul', 'ol', 'paragraph']],
               ['height', ['height']]
               ['table', ['table']],
               ['insert', ['link', 'picture', 'video']],
               ['view', ['fullscreen', 'codeview', 'help']]
           ],
           callbacks:
           {
               //restore from localStorage
               onInit: function(e)
               {
                   $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
               },
               onChange: function(contents, $editable)
               {
                   clearInterval(interval);
                   timer();
               }
           }
       });
   
       //load emojis
       $.ajax(
       {
           url: 'https://api.github.com/emojis',
           async: false
       }).then(function(data)
       {
           window.emojis = Object.keys(data);
           window.emojiUrls = data;
       });
   
       //init emoji example
       $(".js-hint2emoji").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: 'type starting with : and any alphabet',
           hint:
           {
               match: /:([\-+\w]+)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(emojis, function(item)
                   {
                       return item.indexOf(keyword) === 0;
                   }));
               },
               template: function(item)
               {
                   var content = emojiUrls[item];
                   return '<img src="' + content + '" width="20" /> :' + item + ':';
               },
               content: function(item)
               {
                   var url = emojiUrls[item];
                   if (url)
                   {
                       return $('<img />').attr('src', url).css('width', 20)[0];
                   }
                   return '';
               }
           }
       });
   
       //init mentions example
       $(".js-hint2mention").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: "type starting with @",
           hint:
           {
               mentions: ['jayden', 'sam', 'alvin', 'david'],
               match: /\B@(\w*)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(this.mentions, function(item)
                   {
                       return item.indexOf(keyword) == 0;
                   }));
               },
               content: function(item)
               {
                   return '@' + item;
               }
           }
       });
   
   });
   
</script>
<!-- Search Selecet -->
<script>
   $(document).ready(function () {
       $(function () {
           $(".select2").select2();
   
           $(".select2-placeholder-multiple").select2({
               placeholder: "Select State",
           });
           $(".js-hide-search").select2({
               minimumResultsForSearch: 1 / 0,
           });
           $(".js-max-length").select2({
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items",
           });
           $(".select2-placeholder").select2({
               placeholder: "Select a state",
               allowClear: true,
           });
   
           $(".js-select2-icons").select2({
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function (elm) {
                   return elm;
               },
           });
   
           function icon(elm) {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
           }
   
           $("#Emp").select2({
               placeholder: "select...",
               ajax: {
                   type: "GET",
                   dataType: "json",
                   url: "AllEmps",
                   processResults: function (data) {
                       return {
                           results: $.map(data, function (obj, index) {
                               return { id: index, text: obj };
                           }),
                       };
   
                       console.log(data);
                   },
                  data: function (params) {  
   
           
                  var query = {
                           search: params.term,
                       };
                               
           
             $.ajax({
                             url: 'AllEmpsJ/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                         $('#Emp').empty();  
                                 $.each(data, function(key, value){
   
                        $('#Emp').append('<option value="'+ key +'">' + value + '</option>');
                  
                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
           
           
           
       }
               },
           });
   
           $("#Emp").on("select2:select", function (e) {
               console.log("select done", e.params.data);
           });
           
             $("#client").select2({
               placeholder: "select...",
               ajax: {
                   type: "GET",
                   dataType: "json",
                   url: "AllClientsFilter",
                   processResults: function (data) {
                       return {
                           results: $.map(data, function (obj, index) {
   
                               return { id: index, text: obj };
                           }),
                       };
   
                       console.log(data);
                   },
                 data: function (params) {  
   
           
                  var query = {
                           search: params.term,
                       };
                               
           
             $.ajax({
                             url: 'AllClientsFilterJS/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                         $('#client').empty();  
                                 $.each(data, function(key, value){
   
                        $('#client').append('<option value="'+ key +'">' + value + '</option>');
                  
                                 });
                                 
                               var countryId = $('#client').val();
                     if(countryId) {
                         $.ajax({
                             url: 'AccountBalanceSOFilter/'+countryId,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
   
       
                   $('#AccountCredit').val(key); 
                   $('#AccountCredit').val(value); 
                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }          
                                
                                 
                                 
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
           
           
           
       }
               },
           });
   
           $("#client").on("select2:select", function (e) {
               console.log("select done", e.params.data);
           });
    
           
                         $('#AccountCodeF').select2({
   placeholder: "select...",
   ajax: {
       type: "GET",
       dataType: 'json',
       url: 'AllClientsFilter',
       processResults: function (data) {
         return {
           results: $.map(data, function(obj, index) {
             return { id: index, text: obj };
           })
         };
           
           	console.log(data);
           
       },
        data: function (params) {  
   
           
                  var query = {
                           search: params.term,
                       };
                               
           
             $.ajax({
                             url: 'AllClientsFilterJS/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                         $('#AccountCodeF').empty();  
                                 $.each(data, function(key, value){
   
                        $('#AccountCodeF').append('<option value="'+ key +'">' + value + '</option>');
                  
                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
           
           
           
       }
   }
   });
   
   
   $('#AccountCodeF').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });
     
           
           
           
                         $('#AccountCodee').select2({
   placeholder: "select...",
   ajax: {
       type: "GET",
       dataType: 'json',
       url: 'AllClientsFilter',
       processResults: function (data) {
         return {
           results: $.map(data, function(obj, index) {
             return { id: index, text: obj };
           })
         };
           
           	console.log(data);
           
       },
        data: function (params) {  
   
           
                  var query = {
                           search: params.term,
                       };
                               
           
             $.ajax({
                             url: 'AllClientsFilterJS/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                         $('#AccountCodee').empty();  
                                 $.each(data, function(key, value){
   
                        $('#AccountCodee').append('<option value="'+ key +'">' + value + '</option>');
                  
                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
           
           
           
       }
   }
   });
   
   
   $('#AccountCodee').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });
     
           $(".EmpDele").select2({
               placeholder: "select...",
               ajax: {
                   type: "GET",
                   dataType: "json",
                   url: "AllEmps",
                   processResults: function (data) {
                       return {
                           results: $.map(data, function (obj, index) {
                               return { id: index, text: obj };
                           }),
                       };
   
                       console.log(data);
                   },
                  data: function (params) {  
   
           
                  var query = {
                           search: params.term,
                       };
                               
           
             $.ajax({
                             url: 'AllEmpsJ/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                         $('.EmpDele').empty();  
                                 $.each(data, function(key, value){
   
                        $('.EmpDele').append('<option value="'+ key +'">' + value + '</option>');
                  
                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
           
           
           
       }
               },
           });
   
           $(".EmpDele").on("select2:select", function (e) {
               console.log("select done", e.params.data);
           });
                
           
           
           
           
           
       });
   });
</script>
<!-- Unit Code and Name V-->
<script>
   function  UnitCodePurch(r){
   
   var countryId = $('#UnitPurch'+r).val();
   var Pro = $('#Product'+r).val();
   var client = $('#client').val();
   var code = $('#CodePurch'+r).val();
   var Store = $('#StorePurch'+r).val();
       
                     if(countryId) {
                         $.ajax({
                             url: 'UnitSalesFilter/'+countryId+'/'+Pro+'/'+client+'/'+code+'/'+Store,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
                                     
                     
                       $('#UnitPurchName'+r).val(data.name); 
                       $('#TaxRate'+r).val(data.rate); 
                       $('#TaxType'+r).val(data.type); 
                       $('#Price'+r).val(data.price); 
                       $('#PurchTax'+r).val(data.tax); 
                       $('#AvQty'+r).val(parseFloat(data.qty).toFixed(2)); 
                            
         
                       $('#UnitPriceOne'+r).val(data.priceOne); 
                       $('#UnitPriceTwo'+r).val(data.priceTwo); 
                       $('#UnitPriceThree'+r).val(data.priceThree); 
                              
   
       
   
                                 });
                                 
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
    var HighDisc = $("#HighDiscD"+r).val();
   
                                        
                 var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
          
           Discount=$("#Discount"+r).val();
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
       }
       
                var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscPro"+r).val(parseFloat(BFG));
   
   
       if(TaxType == 1){
           //Precent
          
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
       
       $("#TotalBFTax"+r).val(parseFloat(BF));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#Tax"+r).val(parseFloat(ii));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#Total"+r).val(parseFloat(iii));
           
       }else if(TaxType == 2){
          //Number 
     var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
         $("#TotalBFTax"+r).val(parseFloat(BF));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#Tax"+r).val(parseFloat(i));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#Total"+r).val(parseFloat(iii));
           
           
       }
       
   
        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();
        var AvQty = $("#AvQty"+r).val();
        var x=  @php echo $Def->Mainus; @endphp ;
   
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPur"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
        document.getElementById("AddBtnPur"+r).style.display = "inline-block";           
     }  
            
                 // x de elly hya lw byshtghl bsalb 
              if(x == 0){
    
       if(AvQty != 0){
           
           
       if(parseFloat(AvQty) >= parseFloat(Qty)){
            
    document.getElementById("AddBtnPur"+r).style.display = "inline-block";
            
        }else{
            
            
   document.getElementById("AddBtnPur"+r).style.display = "none";     
            
        }   
       
   
           }else{
               
      document.getElementById("AddBtnPur"+r).style.display = "none";         
           }    
        
        
    }else{
        
       document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
        
    }   
   
        
                                   if(HighDisc != 0){
           
         
           if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                     document.getElementById("Submit").style.display="none";   
           }else{
                  document.getElementById("Submit").style.display="inline-block";    
               
           }
           
           
       }
   
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }
       
       
           
   
   }   
</script>  
<!-- Unit Code and Name -->
<script>
   function  UnitCodePurchh(r){
   
   var countryId = $('#UnitPurch'+r).val();
   var Pro = $('#Product'+r).val();
   var client = $('#client').val();
   var code = $('#CodePurch'+r).val();
       var Store = $('#StorePurch'+r).val();   
                     if(countryId) {
                         $.ajax({
                             url: 'UnitSalesFilter/'+countryId+'/'+Pro+'/'+client+'/'+code+'/'+Store,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
                                     
                       $('#CodePurch'+r).val(data.code); 
                       $('#UnitPurchName'+r).val(data.name); 
                       $('#TaxRate'+r).val(data.rate); 
                       $('#TaxType'+r).val(data.type); 
                       $('#Price'+r).val(data.price); 
                       $('#PurchTax'+r).val(data.tax); 
                       $('#AvQty'+r).val(parseFloat(data.qty).toFixed(2)); 
                                     
                       $('#UnitPriceOne'+r).val(data.priceOne); 
                       $('#UnitPriceTwo'+r).val(data.priceTwo); 
                       $('#UnitPriceThree'+r).val(data.priceThree); 
   
                                 });
                                 
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
    var HighDisc = $("#HighDiscD"+r).val();
   
                                        
                 var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
          
           Discount=$("#Discount"+r).val();
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
       }
                  var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscPro"+r).val(parseFloat(BFG));
       
       if(TaxType == 1){
           //Precent
          
     var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) ); 
       
       $("#TotalBFTax"+r).val(parseFloat(BF));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#Tax"+r).val(parseFloat(ii));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#Total"+r).val(parseFloat(iii));
           
       }else if(TaxType == 2){
          //Number 
        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) ); 
         $("#TotalBFTax"+r).val(parseFloat(BF));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#Tax"+r).val(parseFloat(i));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#Total"+r).val(parseFloat(iii));
           
           
       }
       
   
        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();
        var AvQty = $("#AvQty"+r).val();
       var x=  @php echo $Def->Mainus; @endphp ;
   
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPur"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
        document.getElementById("AddBtnPur"+r).style.display = "inline-block";           
     }  
            
                 // x de elly hya lw byshtghl bsalb 
              if(x == 0){
    
       if(AvQty != 0){
           
           
       if(parseFloat(AvQty) >= parseFloat(Qty)){
            
    document.getElementById("AddBtnPur"+r).style.display = "inline-block";
            
        }else{
            
            
   document.getElementById("AddBtnPur"+r).style.display = "none";     
            
        }   
       
   
           }else{
               
      document.getElementById("AddBtnPur"+r).style.display = "none";         
           }    
        
        
    }else{
        
       document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
        
    }   
   
                    if(HighDisc != 0){
           
         
           if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                     document.getElementById("Submit").style.display="none";   
           }else{
                  document.getElementById("Submit").style.display="block";    
               
           }
           
           
       }
   
   
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }
   
   }   
</script>  
<!-- Store Name -->
<script>
   function  StoreNamePurch(r){
   
   var countryId = $('#StorePurch'+r).val();
   var Product = $('#Product'+r).val();
   var Code = $('#CodePurch'+r).val();
   var Unit = $('#UnitPurch'+r).val();
    var UnitDefault = $("#UnitDefault"+r).val();   
    var CodeDefault = $("#CodeDefault"+r).val();   
    var StoreDefault = $("#StoreDefault"+r).val();   
                     if(countryId) {
                         $.ajax({
        url: 'StoreNameSalesFilter/'+countryId+'/'+Product+'/'+Code+'/'+Unit+'/'+UnitDefault+'/'+CodeDefault+'/'+StoreDefault,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
                                     
                       $('#StorePurchName'+r).val(data.name); 
                       $('#AvQty'+r).val(data.AvQty); 
   
                                     
   
                                 });
                                 
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
    var HighDisc = $("#HighDiscD"+r).val();
   
                                             
                 var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
          
           Discount=$("#Discount"+r).val();
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
       }
                  var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscPro"+r).val(parseFloat(BFG));
       if(TaxType == 1){
           //Precent
          
         var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
       
       $("#TotalBFTax"+r).val(parseFloat(BF));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#Tax"+r).val(parseFloat(ii));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#Total"+r).val(parseFloat(iii));
           
       }else if(TaxType == 2){
          //Number 
          var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );   
         $("#TotalBFTax"+r).val(parseFloat(BF));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#Tax"+r).val(parseFloat(i));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#Total"+r).val(parseFloat(iii));
           
           
       }
       
   
        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var x=  @php echo $Def->Mainus; @endphp ;
                      
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPur"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
        document.getElementById("AddBtnPur"+r).style.display = "inline-block";           
     }  
            
          // x de elly hya lw byshtghl bsalb 
      if(x == 0){
    
       if(AvQty != 0){
           
           
       if(parseFloat(AvQty) >= parseFloat(Qty)){
            
    document.getElementById("AddBtnPur"+r).style.display = "inline-block";
            
        }else{
            
   document.getElementById("AddBtnPur"+r).style.display = "none";     
            
        }   
       
   
           }else{
               
      document.getElementById("AddBtnPur"+r).style.display = "none";         
           }    
        
        
    }else{
        
       document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
        
    }   
   
     
                    if(HighDisc != 0){
           
         
           if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                     document.getElementById("Submit").style.display="none";   
           }else{
                  document.getElementById("Submit").style.display="block";    
               
           }
           
           
       }
   
   
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }
   
   }   
</script>  
<!-- Account Balance -->
<script>
   $(document).ready(function() {
   
                  $('#client').on('change', function(){
                      var countryId = $(this).val();
                      if(countryId) {
                          $.ajax({
                              url: 'AccountBalanceSOFilter/'+countryId,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },
   
                              success:function(data) {
                                  $.each(data, function(key, value){
   
        
                    $('#AccountCredit').val(key); 
                    $('#AccountCredit').val(value); 
                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });
                      } else {
   
                          $('select[name="state"]').empty();
                      }
   
                  });
   
              });
    
     $(document).ready(function() { 
   
                      var countryId = $('#client').val();
                      if(countryId) {
                          $.ajax({
                              url: 'AccountBalanceSFilter/'+countryId,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },
   
                              success:function(data) {
                                  $.each(data, function(key, value){
   
        
                    $('#AccountCredit').val(key); 
                    $('#AccountCredit').val(value); 
                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });
                      } else {
   
                          $('select[name="state"]').empty();
                      }
     
     });
</script>  
<!--  Filter Products -->
<script>
   $(document).ready(function(){
   
    fetch_customer_data();
   
    function fetch_customer_data(search = '',store='',client='',Brand='',Group='')
    {  
     $.ajax({
      url:'SalesProductsFilter',
      method:'GET',
      data:{search:search,store:store,client:client,Brand:Brand,Group:Group},
      dataType:'json',
      success:function(data)
      {
        
          
       $('.Data').html(data.table_data);
               $("#Data").show();
          
      }
     })
    }
    
   $(document).on('keyup', '#search', function(event){
     var search = $(this).val();     
     var store = $('#store').val();     
     var client = $('#client').val();     
     var Brand = $('#Brandd').val();     
     var Group = $('#Groupp').val();     
          if (event.which != '13') {
       
   fetch_customer_data(search,store,client,Brand,Group);
       
   }
   
    });
       
       
    $(document).on('change', '#store', function(){
     var store = $(this).val();     
     var search = $('#search').val();     
     var client = $('#client').val();     
     var Brand = $('#Brandd').val();     
     var Group = $('#Groupp').val();     
     fetch_customer_data(search,store,client,Brand,Group);
    });
       
    $(document).on('change', '#client', function(){
     var client = $(this).val();     
     var search = $('#search').val();     
     var store = $('#store').val();     
     var Brand = $('#Brandd').val();     
     var Group = $('#Groupp').val();     
     fetch_customer_data(search,store,client,Brand,Group);
    });  
       
     $(document).on('change', '#Brandd', function(){
     var Brand = $(this).val();     
     var search = $('#search').val();     
     var store = $('#store').val();     
     var client = $('#client').val();     
     var Group = $('#Groupp').val();     
     fetch_customer_data(search,store,client,Brand,Group);
    });   
       
     $(document).on('change', '#Groupp', function(){
     var Group = $(this).val();     
     var search = $('#search').val();     
     var store = $('#store').val();     
     var Brand = $('#Brandd').val();     
     var client = $('#client').val();     
     fetch_customer_data(search,store,client,Brand,Group);
    });      
          
   });
</script>
<!-- Filter Search Code -->
<script>
    
   $(document).ready(function(){
   
    fetch_customer_data();
   
    function fetch_customer_data(search = '',store='',client='',Brand='',Group='')
    {  
     $.ajax({
      url:'SalesProductsSearchCodeFilter',
      method:'GET',
      data:{search:search,store:store,client:client,Brand:Brand,Group:Group},
      dataType:'json',
      success:function(data)
      {
        
          
       $('.Data').html(data.table_data);
               $("#Data").show();
          
      }
     })
    }
    
   $(document).on('keyup', '#SearchCode', function(event){
     var search = $(this).val();     
     var store = $('#store').val();     
     var client = $('#client').val();     
     var Brand = $('#Brandd').val();     
     var Group = $('#Groupp').val();     
          if (event.which != '13') {
       
   fetch_customer_data(search,store,client,Brand,Group);
       
   }
   
    });
       
       
   
          
   });
</script>
<!-- Add Products -->
<script>
   function Fun(r) { 
       
             var P_Ar_Name = $("#P_Ar_Name"+r).val();
             var P_En_Name= $("#P_En_Name"+r).val();
             var Product = $("#Product"+r).val();
             var UnitID = $("#UnitPurch"+r).val();
             var UnitName = $("#UnitPurchName"+r).val();
             var Qty = $("#Qty"+r).val();
             var AvQty = $("#AvQty"+r).val();
             var Barcode = $("#CodePurch"+r).val();
             var Price = $("#Price"+r).val();
             var Total = $("#Total"+r).val();
             var ExpDate = $("#ExpDate"+r).val();
             var PurchTax = $("#PurchTax"+r).val();
             var TotalTax = $("#Tax"+r).val();
             var Discount = $("#Discount"+r).val();
         var TDiscPro = $("#TDiscPro"+r).val();
             var TotalBFTax = $("#TotalBFTax"+r).val();
             var StorePurch = $("#StorePurch"+r).val();
             var StorePurchName = $("#StorePurchName"+r).val();
             var PurchTax = $("#PurchTax"+r).val();
             var VOne = $("#VOne"+r).val();
             var VTwo = $("#VTwo"+r).val();
             var V_Name = $("#V_Name"+r).val();
             var VV_Name = $("#VV_Name"+r).val();
            var TaxRate = $("#TaxRate"+r).val();
             var TaxType = $("#TaxType"+r).val();  
             var PatchNum = $("#PatchNum"+r).val();  
                var HighDisc = $("#HighDisc"+r).val();
                var CostPrice = $("#CostPrice"+r).val();
             var Viro = '';
             var VViro = '';
         var serial =$("#serial"+r).val();
       if( V_Name != ''){
           
          Viro= '(' + V_Name +')';
       }
   
       if( VV_Name != ''){
           
         VViro= '(' + VV_Name +')'; 
       }
   
          var PO='';
          var DO='';
        var PRICEOPEN = $("#PRICEOPEN").val();
        var DISCOPEN = $("#DISCOPEN").val();
       
          if(parseFloat(PRICEOPEN) == 0){
            PO="<input type='number' id='PriD"+r+"' step='any'  value='"+Price+"' class='form-control' disabled ><input type='hidden' name='Price[]'  value='"+Price+"'>";  
     }else{
   
            PO="<input type='number' id='PriD"+r+"' step='any' name='Price[]' value='"+Price+"' class='form-control' onkeyup='TotD("+r+")' onclick='TotD("+r+")'>";  
     
     }
       
       
               if(parseFloat(DISCOPEN) == 0){
    DO="<input class='Disc form-control' id='DiscD"+r+"' type='number' step='any' value='"+Discount+"'  disabled ><input type='hidden' name='Discount[]'  value='"+Discount+"'>";  
     }else{
       DO="<input class='Disc form-control' id='DiscD"+r+"' type='number' step='any' name='Discount[]' value='"+Discount+"' onkeyup='TotD("+r+")' onclick='TotD("+r+")' >";  
     
     }
              
            var Exp='';
        var ED = $("#ED").val();
       
        var DIS = $("#DIS").val();
   
         if(ED == 1){
           
         Exp = "<td><input type='hidden' name='Exp_Date[]' value='"+ExpDate+"'>" + ExpDate + "</td>";
           
       }else{
           
           Exp = "<input type='hidden' name='Exp_Date[]' value='"+ExpDate+"'>";
       }
              
       
        var Patch = $("#Patch").val();
       if(parseFloat(Patch) == 1){
           
   var pn="<td><input type='hidden' step='any' class='form-control' name='Patch_Number[]' value="+PatchNum+">"+PatchNum+"</td>";
       }else{
           var pn="<input type='hidden'  name='Patch_Number[]' value="+PatchNum+">";
           
       }
       
             document.getElementById("AddBtnPur"+r).style.display = "none";
             document.getElementById("Row"+r).style.display = "none";
                    $("#Data").hide();
       
       var RFF= parseFloat(Qty) * parseFloat(Price);
       var RFFResult= parseFloat(RFF) - parseFloat(Total);
       
            var DISCSHOW = $("#DISCSHOW").val();
        var TOTBFSHOW = $("#TOTBFSHOW").val();
        var TAXSHOW = $("#TAXSHOW").val();
        var STORESHOW = $("#STORESHOW").val();
        var AVQTYSHOW = $("#AVQTYSHOW").val();
       
       
           if(AVQTYSHOW == 1){
           
       var  AVQTYSHOWW = "";
           
       }else{
           
             var  AVQTYSHOWW = "none";
       }
       
        if(DISCSHOW == 1){
           
       var  DISCSHOWW = "";
           
       }else{
           
             var  DISCSHOWW = "none";
       }
       
       
          if(TOTBFSHOW == 1){
           
        var TOTBFSHOWW = "";
           
       }else{
           
            var TOTBFSHOWW  = "none";
       }
       
       
       
          if(TAXSHOW == 1){
           
      var   TAXSHOWW = "";
           
       }else{
           
            var   TAXSHOWW = "none";
       }
       
       
       
          if(STORESHOW == 1){
           
        var STORESHOWW = "";
           
       }else{
           
             var STORESHOWW  = "none";
       }
       
               var LANG = $("#LANG").val();
   if(LANG == 'ar' ){ 
          var Nemo = P_Ar_Name ;
          }else{
             var Nemo = P_En_Name ;   
          } 
       
             var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='"+P_Ar_Name+"'><input type='hidden' name='P_En_Name[]' value='"+P_En_Name+"'>" + Nemo + ""+ Viro +" "+ VViro +"</td><td><input type='hidden' name='Unit[]' value='"+UnitID+"'>" + UnitName + "</td><td><input type='hidden' id='BAR"+r+"' name='P_Code[]' value='"+Barcode+"'>" + Barcode + "</td>"+pn+"<td style='display:"+AVQTYSHOWW+"'><input type='hidden' id='AvQuntD"+r+"' name='AvQty[]' value='"+AvQty+"'>" + AvQty + "</td><td><input class='Qun form-control' id='QuntD"+r+"' type='number' step='any' name='Qty[]' value='"+Qty+"' onkeyup='TotD("+r+")' onclick='TotD("+r+")' ></td><td>"+PO+"</td><td style='display:"+DISCSHOWW+"'>"+DO+"</td><td style='display:"+TOTBFSHOWW+"'><input class='TotalBFTax form-control' id='TotBFTaxD"+r+"' type='number' step='any' disabled  value='"+TotalBFTax+"'><input type='hidden'  id='TotBFTaxDHide"+r+"' name='TotalBFTax[]'  value='"+TotalBFTax+"'></td><td style='display:"+TAXSHOWW+"'><input class='TotalTax form-control' id='TaxD"+r+"' type='number' step='any' disabled  value='"+TotalTax+"'><input type='hidden' id='TaxDHide"+r+"' name='TotalTax[]'  value='"+TotalTax+"'></td><td><input class='Tot form-control' type='number' step='any' id='TotD"+r+"' disabled   name='Total[]' value='"+Total+"'><input type='hidden' id='TotDHide"+r+"' name='Total[]'  value='"+Total+"'></td><td style='display:"+STORESHOWW+"'><input  type='hidden' name='StorePurch[]' value='"+StorePurch+"'>" + StorePurchName + "</td>"+Exp+"<td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input id='PRO"+r+"' type='hidden' name='Product[]' value='"+Product+"'><input type='hidden' name='VOne[]' value='"+VOne+"'><input type='hidden' name='VTwo[]' value='"+VTwo+"'></td><input type='hidden' name='V_Name[]' value='"+Viro+"'><input type='hidden' name='VV_Name[]' value='"+VViro+"'><input type='hidden' name='PurchTax[]' value='"+PurchTax+"'><input id='TaxRateD"+r+"' type='hidden'  value='"+TaxRate+"'><input type='hidden' id='TaxTypeD"+r+"'  value='"+TaxType+"'><input type='hidden' id='HighDiscD"+r+"'  value='"+HighDisc+"'><input type='hidden' id='Enough"+r+"' name='AllEnough[]' class='ENO'  value='0'><input type='hidden' class='DiscoPrecent' id='disssccoount"+r+"' value='"+RFFResult+"'><input type='hidden' class='TDISCOOO' id='TDiscProEdit"+r+"' name='TDiscPro[]' value='"+TDiscPro+"'><input type='hidden' class='COSTPRICES'  name='CostPrice[]' value='"+CostPrice+"'></tr>";
   
            
   
           var P = $("#PRO"+r).val();
           var Bar = $("#BAR"+r).val();
             if(Product != P &&  Barcode != Bar){
                  $("#data-dt").append(markup); 
             }
   
      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var sumQ = 0;        
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });   
            
    var sumT = 0;        
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });       
       
        var sumD = 0;        
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   }); 
       
       
           var sumBF = 0;        
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   }); 
       
           var sumTax = 0;        
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   }); 
       
               var prec = 0;        
   $('.DiscoPrecent').each(function(){
   prec += parseFloat($(this).val());
   }); 
       
          var sumTTD = 0;        
   $('.TDISCOOO').each(function(){
   sumTTD += parseFloat($(this).val());
   }); 
   
       
                 var COPRI = 0;        
   $('.COSTPRICES').each(function(){
   COPRI += parseFloat($(this).val());
   }); 
       

       $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));
       
   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));
       
       var TootPriice=parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax);
     $('#Total_Price').val(parseFloat(TootPriice).toFixed(2));
   $('#Total_PriceHide').val(parseFloat(TootPriice).toFixed(2));
       
   $('#Total_PriceW').val(parseFloat(sumT).toFixed(2));
       
       var PROFIIIT=parseFloat(sumT) - parseFloat(COPRI);
   $('#ProfitPrecent').val(parseFloat(PROFIIIT).toFixed(2));
       
       var nfd=((parseFloat(sumT) - parseFloat(COPRI)) * 100) / parseFloat(COPRI);
   $('#proPrecent').text(parseFloat(nfd).toFixed(2));
       $('#Total_Bill').val(parseFloat(sumT).toFixed(2));
   
           $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));
    
       $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));
       
       
       var BEFO=parseFloat(sumBF)+parseFloat(sumTTD);
       
          $('#Total_Bf_Taxes').val(parseFloat(BEFO).toFixed(2));
   $('#Total_Bf_TaxesHide').val(parseFloat(BEFO).toFixed(2));
       
          $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));
   $('#TotalCost').val(parseFloat(COPRI).toFixed(2));
   
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
       
        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        
      if(Pay == 'Later' &&  Stat == 0 ){
               
             if(paid == 0 || paid < 0){   
        document.getElementById("Submit").style.display = "none";  
             }else{
                 
           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
                 
                 
                 
             }
           
       }else{
           
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }   
       }
   
       
      
       
        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        var resdiual =$('#resdiual').val();
        var total =$('#Total_PriceHide').val();
        var totalDisc =$('#Total_DiscountHideTT').val();
   
          var totalTax =$('#Total_TaxesHide').val();
   
   
         var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterD').val(parseFloat(RRR).toFixed(2));        
         $('#paid').val(parseFloat(RR).toFixed(2));
       
         $('#presenter').val(parseFloat(RR).toFixed(2));
         $('#total').val(parseFloat(sumT).toFixed(2));
    
       
       
       
               var Pay =$('#Payment_Method').val();
      if(Pay == 'Later'){
         
        
                   $('#paid').val('');
           
       }
       
               var SafyMby3at =$('#Total_PriceW').val();
         var SafyMshtryat =$('#Total_PriceWP').val();
       
        var DifRR=  parseFloat(SafyMby3at) -  parseFloat(SafyMshtryat);
       $('#Dif').val(DifRR);
       
   
        $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove(); 
            
   
      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var sumQ = 0;        
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });   
            
    var sumT = 0;        
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });       
       
        var sumD = 0;        
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   }); 
       
       
           var sumBF = 0;        
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   }); 
       
           var sumTax = 0;        
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   }); 
       
                           var prec = 0;        
   $('.DiscoPrecent').each(function(){
   prec += parseFloat($(this).val());
   }); 
            
                      var sumTTD = 0;        
   $('.TDISCOOO').each(function(){
   sumTTD += parseFloat($(this).val());
   }); 
                    var COPRI = 0;        
   $('.COSTPRICES').each(function(){
   COPRI += parseFloat($(this).val());
   }); 
    $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));
       
   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));
       
       var TootPriice=parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax);
     $('#Total_Price').val(parseFloat(TootPriice).toFixed(2));
   $('#Total_PriceHide').val(parseFloat(TootPriice).toFixed(2));
       
   $('#Total_PriceW').val(parseFloat(sumT).toFixed(2));
       
       var PROFIIIT=parseFloat(sumT) - parseFloat(COPRI);
   $('#ProfitPrecent').val(parseFloat(PROFIIIT).toFixed(2));
       
       var nfd=((parseFloat(sumT) - parseFloat(COPRI)) * 100) / parseFloat(COPRI);
   $('#proPrecent').text(parseFloat(nfd).toFixed(2));
       $('#Total_Bill').val(parseFloat(sumT).toFixed(2));
   
           $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));
    
       $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));
       
       
       var BEFO=parseFloat(sumBF)+parseFloat(sumTTD);
       
          $('#Total_Bf_Taxes').val(parseFloat(BEFO).toFixed(2));
   $('#Total_Bf_TaxesHide').val(parseFloat(BEFO).toFixed(2));
       
          $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));
   $('#TotalCost').val(parseFloat(COPRI).toFixed(2));
   
       
            
                  var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        var resdiual =$('#resdiual').val();
        var total =$('#Total_PriceHide').val();
        var totalDisc =$('#Total_DiscountHideTT').val();
   
          var totalTax =$('#Total_TaxesHide').val();
   
   
         var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterD').val(parseFloat(RRR).toFixed(2));        
         $('#paid').val(parseFloat(RR).toFixed(2));
    
             $('#presenter').val(parseFloat(RR).toFixed(2));
         $('#total').val(parseFloat(sumT).toFixed(2));
            
   
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
            
                  var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        
      if(Pay == 'Later' &&  Stat == 0 ){
               
             if(paid == 0 || paid < 0){   
        document.getElementById("Submit").style.display = "none";  
             }else{
                 
           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
                 
                 
                 
             }
           
       }else{
           
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }   
       }
   
     
      
               var Pay =$('#Payment_Method').val();
      if(Pay == 'Later'){
         
        
                   $('#paid').val('');
           
       }
       
                 var EN = 0;   
 $('.ENO').each(function(){
   EN += parseFloat($(this).val());
   }); 
    
                        var Total_PriceW =$('#Total_PriceW').val();

             if(EN == 0){
        
             if(Total_PriceW == 'NaN'){
                   document.getElementById("Submit").style.display = "none";   
                    }else{
        document.getElementById("Submit").style.display = "block";    
             }
             
       }else{
           
        document.getElementById("Submit").style.display = "none";    
       } 
            
                    var SafyMby3at =$('#Total_PriceW').val();
         var SafyMshtryat =$('#Total_PriceWP').val();
       
        var DifRR=  parseFloat(SafyMby3at) -  parseFloat(SafyMshtryat);
       $('#Dif').val(DifRR);
       
   
   
                    })  
       
       
     }    
</script> 
<!-- Total Products -->
<script>
   function PurchTotal(r) { 
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var HighDisc = $("#HighDisc"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
     var x=  @php echo $Def->Mainus; @endphp ;
   
          var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
          
           Discount=$("#Discount"+r).val();
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
       }
       
                  var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscPro"+r).val(parseFloat(BFG));
       
       
       if(TaxType == 1){
           //Precent
          
        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
       
       $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#Tax"+r).val(parseFloat(ii).toFixed(2));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#Total"+r).val(parseFloat(iii).toFixed(2));
           
       }else if(TaxType == 2){
          //Number 
          var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
         $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#Tax"+r).val(parseFloat(i).toFixed(2));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#Total"+r).val(parseFloat(iii).toFixed(2));
           
           
       }
       
   
        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();
   
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPur"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
                if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";  
           
           }else{
             document.getElementById("AddBtnPur"+r).style.display = "inline-block";  
           }
             
     }  
            
      // x de elly hya lw byshtghl bsalb 
    if(x == 0){
    
       if(parseFloat(AvQty) != 0){
           
           
        if(parseFloat(AvQty) >= parseFloat(Qty)){
          
            if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";  
           
           }else{
             document.getElementById("AddBtnPur"+r).style.display = "inline-block";  
           }
            
        }else{
            
   document.getElementById("AddBtnPur"+r).style.display = "none";     
            
        }   
       
   
           }else{
               
      document.getElementById("AddBtnPur"+r).style.display = "none";         
           }    
        
        
    }else{
        
       document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
        
    }   
   
   
       if(HighDisc != 0){
           
         
           if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                     document.getElementById("AddBtnPur"+r).style.display = "none";    
           }else{
                          if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";  
           
           }else{
             document.getElementById("AddBtnPur"+r).style.display = "inline-block";  
           }  
               
           }
           
           
       }
       

       
   }
    
    
     function TotD(r) { 
   var TaxRate = $("#TaxRateD"+r).val();
   var TaxType = $("#TaxTypeD"+r).val();
   var Qty = $("#QuntD"+r).val();
   var AvQty = $("#AvQuntD"+r).val();
   var Price = $("#PriD"+r).val();
   var Discount = $("#DiscD"+r).val();     
    var HighDisc = $("#HighDiscD"+r).val();
       var EN = 0;   
   var i = 0;
   var ii=0;       
   var iii=0;    
        
         
     var x=  @php echo $Def->Mainus; @endphp ;
       
                 var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
          
           Discount=$("#DiscD"+r).val();
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
       }
                     var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscProEdit"+r).val(parseFloat(BFG));
       if(TaxType == 1){
           //Precent
          
    var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
       
       $("#TotBFTaxD"+r).val(parseFloat(BF).toFixed(2));
       $("#TotBFTaxDHide"+r).val(parseFloat(BF).toFixed(2));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#TaxD"+r).val(parseFloat(ii).toFixed(2));
           $("#TaxDHide"+r).val(parseFloat(ii).toFixed(2));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#TotD"+r).val(parseFloat(iii).toFixed(2));
           $("#TotDHide"+r).val(parseFloat(iii).toFixed(2));
           
       }else if(TaxType == 2){
          //Number 
           var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );    
         $("#TotBFTaxD"+r).val(parseFloat(BF));
         $("#TotBFTaxDHide"+r).val(parseFloat(BF));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#TaxD"+r).val(parseFloat(i));
           $("#TaxDHide"+r).val(parseFloat(i));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#TotD"+r).val(parseFloat(iii));
           $("#TotDHide"+r).val(parseFloat(iii));
           
           
       }
    
            
         if(parseFloat(Qty) > parseFloat(AvQty)){
             
         
         document.getElementById("QuntD"+r).style.border="1px solid darkred";     
             $("#Enough"+r).val(1);
       
             
         }else{
           
               if(parseFloat(Qty) < 0 || parseFloat(Price) < 0 || parseFloat(Discount) < 0)
           {
               document.getElementById("QuntD"+r).style.border="1px solid darkred";     
             $("#Enough"+r).val(1);
              
              }else{  
                       document.getElementById("QuntD"+r).style.border="none"; 
             $("#Enough"+r).val(0);
                        }

         }
         
       var Total = $("#TotD"+r).val();
       var RFF= parseFloat(Qty) * parseFloat(Price);
       var RFFResult= parseFloat(RFF) - parseFloat(Total);
         $("#disssccoount"+r).val(parseFloat(RFFResult).toFixed(2));
   
       $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
                
    var sumQ = 0;        
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });   
            
    var sumT = 0;        
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });       
       
        var sumD = 0;        
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   }); 
       
       
           var sumBF = 0;        
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   }); 
       
           var sumTax = 0;        
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   }); 
       
               var prec = 0;        
   $('.DiscoPrecent').each(function(){
   prec += parseFloat($(this).val());
   }); 
       
          var sumTTD = 0;        
   $('.TDISCOOO').each(function(){
   sumTTD += parseFloat($(this).val());
   }); 
   
                          var COPRI = 0;        
   $('.COSTPRICES').each(function(){
   COPRI += parseFloat($(this).val());
   }); 
         
  
         
    $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));
       
   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));
       
       var TootPriice=parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax);
     $('#Total_Price').val(parseFloat(TootPriice).toFixed(2));
   $('#Total_PriceHide').val(parseFloat(TootPriice).toFixed(2));
       
   $('#Total_PriceW').val(parseFloat(sumT).toFixed(2));
       
       var PROFIIIT=parseFloat(sumT) - parseFloat(COPRI);
   $('#ProfitPrecent').val(parseFloat(PROFIIIT).toFixed(2));
       
       var nfd=((parseFloat(sumT) - parseFloat(COPRI)) * 100) / parseFloat(COPRI);
   $('#proPrecent').text(parseFloat(nfd).toFixed(2));
       $('#Total_Bill').val(parseFloat(sumT).toFixed(2));
   
           $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));
    
       $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));
       
       
       var BEFO=parseFloat(sumBF)+parseFloat(sumTTD);
       
          $('#Total_Bf_Taxes').val(parseFloat(BEFO).toFixed(2));
   $('#Total_Bf_TaxesHide').val(parseFloat(BEFO).toFixed(2));
       
          $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));
   $('#TotalCost').val(parseFloat(COPRI).toFixed(2));
   
   
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
       
        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        
      if(Pay == 'Later' &&  Stat == 0 ){
               
             if(paid == 0 || paid < 0){   
        document.getElementById("Submit").style.display = "none";  
             }else{
                 
           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
                 
                 
                 
             }
           
       }else{
           
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }   
       }
   
       
           var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        var resdiual =$('#resdiual').val();
        var total =$('#Total_PriceHide').val();
        var totalDisc =$('#Total_DiscountHideTT').val();
          var totalTax =$('#Total_TaxesHide').val();
   
   
         var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterD').val(parseFloat(RRR).toFixed(2));        
         $('#paid').val(parseFloat(RR).toFixed(2));
    
          $('#presenter').val(parseFloat(RR).toFixed(2));
         $('#total').val(parseFloat(sumT).toFixed(2));
               var Pay =$('#Payment_Method').val();

      if(Pay == 'Later'){
         
        
                   $('#paid').val('');
           
       }
       
                   
   $('.ENO').each(function(){
   EN += parseFloat($(this).val());
   }); 
    
                        var Total_PriceW =$('#Total_PriceW').val();

             if(EN == 0){
        
             if(Total_PriceW == 'NaN'){
                   document.getElementById("Submit").style.display = "none";   
                    }else{
        document.getElementById("Submit").style.display = "block";    
             }
             
       }else{
           
        document.getElementById("Submit").style.display = "none";    
       } 
       
         
             var SafyMby3at =$('#Total_PriceW').val();
         var SafyMshtryat =$('#Total_PriceWP').val();
       
        var DifRR=  parseFloat(SafyMby3at) -  parseFloat(SafyMshtryat);
       $('#Dif').val(DifRR);
       
         
         
   }
    
</script>
<!-- Scanner  problem -->         
<script>
   $(".form-control").keypress(function(event){
   if (event.which == '10' || event.which == '13') {
   event.preventDefault();
   }
   });             
   
   
</script>
<!-- Status -->
<script>
   function Statuss(){
       var Pay =$('#Payment_Method').val();
       var Stat =$('#Status').val();
       var paid =$('#paid').val();
       var resdiual =$('#resdiual').val();
       var total =$('#Total_PriceHide').val();
       var totalDisc =$('#Total_DiscountHideTT').val();
   
         var totalTax =$('#Total_TaxesHide').val();
   
   
        var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
            var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
         $('#TAFterD').val(parseFloat(RRR).toFixed(2));        
        $('#paid').val(parseFloat(RR).toFixed(2));
   $('#Total_PriceW').val(parseFloat(RR));
        $('#presenter').val(parseFloat(RR).toFixed(2));
        $('#total').val(parseFloat(RR).toFixed(2));
   $.fn.rowCount = function() {
    return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dt').rowCount();     
    
   if(rowctr == 0){
       document.getElementById("Submit").style.display = "none";    
          
      }else{
          
   
              
               document.getElementById("Submit").style.display = "block";    
      
      }
    if(Pay == 'Installment'){
      
           document.getElementById("Install").style.display = "block";  
        
    }else{
        
         document.getElementById("Install").style.display = "none"; 
        
    }
       
       
              if(Pay == 'Check'){
        
          document.getElementById("CHECK").style.display = "block";  
          
      }else{
          
        document.getElementById("CHECK").style.display = "none";    
      }  
       
              if(Pay == 'Later'){
        
          document.getElementById("Later_Due").style.display = "block";  
                  $('#paid').val('');
          
      }else{
          
        document.getElementById("Later_Due").style.display = "none";    
      }     
       
               if(Pay == 'InstallmentCompanies'){
        
          document.getElementById("CompInstall").style.display = "block";  
          
      }else{
          
        document.getElementById("CompInstall").style.display = "none";    
      }  
       
       
       
   }
    
</script> 
<!-- Submit Script -->
<script>
   function SPP(){
      $('#sp').val(1);  
      var x= $('#sp').val();   
      var store= $('#store').val();   
      var SSAFE= $('#SSAFE').val();   
      var client= $('#client').val();   
   
   
       if(store != '' && SSAFE != '' && client != null){
       
   if(x == 1){
        document.getElementById("Submit").style.display = "none"; 
   document.getElementById('form').submit();   
   }
           
       }else{
           
           alert('تأكد من اختيار مخزن و خزنه وحساب');
           
       }
           
           
   }
   
   
   function SPS(){
      $('#sp').val(0);  
      var x= $('#sp').val();   
   
             var store= $('#store').val();   
      var SSAFE= $('#SSAFE').val();   
      var client= $('#client').val();   
   
   if(store != '' && SSAFE != '' && client != null){
       
    if(x == 0){
        document.getElementById("Submit").style.display = "none"; 
   document.getElementById('form').submit();   
   }
   }else{
           
           alert('تأكد من اختيار مخزن و خزنه وحساب');
           
       }
      
      
   
   }
   
   function SPP8(){
      $('#sp').val(2);  
      var x= $('#sp').val();   
   
   
     
     
                   var store= $('#store').val();   
      var SSAFE= $('#SSAFE').val();   
      var client= $('#client').val();   
   
   if(store != '' && SSAFE != '' && client != null){
     if(x == 2){
        document.getElementById("Submit").style.display = "none"; 
   document.getElementById('form').submit();   
   }
   }else{
           
           alert('تأكد من اختيار مخزن و خزنه وحساب');
           
       }
     
   }
   
   function SPP5(){
      $('#sp').val(3);  
      var x= $('#sp').val();   
   
   
      
                    var store= $('#store').val();   
      var SSAFE= $('#SSAFE').val();   
      var client= $('#client').val();   
   
   if(store != '' && SSAFE != '' && client != null){
     if(x == 3){
        document.getElementById("Submit").style.display = "none"; 
   document.getElementById('form').submit();   
   }
   }else{
           
           alert('تأكد من اختيار مخزن و خزنه وحساب');
           
       }
      
      
   }
   
   
   
</script>
<!-- Installment Total -->
<script>
   function Install(){
       
     var presenter =$('#presenter').val();  
     var annual_interest =$('#annual_interest').val();  
     var Years_Number =$('#Years_Number').val();  
     var total =$('#total').val();  
   
       
       var dif = parseFloat(total) - parseFloat(presenter) ; 
       
       var Percent = parseFloat(annual_interest) / parseFloat(100) ;
       
       var Tp = parseFloat(dif) * parseFloat(Percent) ;
       
       var years = parseFloat(Tp) * parseFloat(Years_Number) ;
       
       var tot = parseFloat(dif) + parseFloat(years) ; 
       
       var monthly = parseFloat(Years_Number) * parseFloat(12) ; 
       
       var t = parseFloat(tot) / parseFloat(monthly) ;
       
       
              $('#monthly_installment').val(parseFloat(t)); 
              $('#monthly_installmentHide').val(parseFloat(t)); 
              $('#installment_Num').val(parseFloat(monthly));  
              $('#installment_NumHide').val(parseFloat(monthly));      
   
   }
</script>
<!-- Add New Client -->
<script>
   function NewClients(){
       
   var co = $('#CODE').val();    
   var Name = $('#Name').val();  
   var PriceLevel = $('#PriceLevel').val();  
   var Phone = $('#Phone').val();  
       
         if(Name) {
                        $.ajax({
                            url: 'AddNewClient/'+co+'/'+Name+'/'+PriceLevel+'/'+Phone,
                            type:"GET",
                            dataType:"json",
                            beforeSend: function(){
                                $('#loader').css("visibility", "visible");
                            },
   
                            success:function(data) {
                                $.each(data, function(key, value){
                                    
                    alert('تم الاضافه بنجاح');
                         
    $('#Name').val('');  
    $('#Phone').val('');               
                                    
                                    
                                });
                            },
                            complete: function(){
                                $('#loader').css("visibility", "hidden");
                            }
                        });
                    }else{
                        
                       alert('حقل الاسم مطلوب'); 
                        
                    }
       
       
       
   }
</script>
<!-- Change Price -->
<script>
   function ChangePriceU(r){
       
     var PriceOne = $("#UnitPriceOne"+r).val();
          $("#Price"+r).val(parseFloat(PriceOne).toFixed(2));
       
    var TaxRate = $("#TaxRate"+r).val();
      var TaxType = $("#TaxType"+r).val();
      var Qty = $("#Qty"+r).val();
      var AvQty = $("#AvQty"+r).val();
      var Price = $("#Price"+r).val();
      var Discount = $("#Discount"+r).val();
      var i = 0;
      var ii=0;       
      var iii=0;       
    var x=  @php echo $Def->Mainus; @endphp ;
            var HighDisc = $("#HighDisc"+r).val(); 
                                                
                    var DIS = $("#DIS").val();
           
          if(parseFloat(DIS) == 0){
             
              Discount=$("#Discount"+r).val();
          }else{
            
              var d= Discount / 100 ;
              var Multi= parseFloat(Qty) * parseFloat(Price) ;
             var dd= Multi * d;
              
           Discount=  dd; 
          }
                     var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
                $("#TDiscProEdit"+r).val(parseFloat(BFG));
          if(TaxType == 1){
              //Precent
             
       var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
          
          $("#TotalBFTax"+r).val(parseFloat(BF));
              
          i =    parseFloat(TaxRate)  / 100 ;  
              
           ii=  parseFloat(BF) * parseFloat(i) ;
                 
              $("#Tax"+r).val(parseFloat(ii));
   
          iii =  parseFloat(BF) + parseFloat(ii) ;
              
              $("#Total"+r).val(parseFloat(iii));
              
          }else if(TaxType == 2){
             //Number 
              var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
            $("#TotalBFTax"+r).val(parseFloat(BF));
             
               i =    parseFloat(TaxRate)   ; 
              
              $("#Tax"+r).val(parseFloat(i));
   
          iii =  parseFloat(BF) + parseFloat(i) ;
              
              $("#Total"+r).val(parseFloat(iii));
              
              
          }
          
   
           var Total = $("#Total"+r).val();
           var TotalBFTax = $("#TotalBFTax"+r).val();
           var Tax = $("#Tax"+r).val();
           var UnitID = $("#UnitPurch"+r).val();
           var StorePurch = $("#StorePurch"+r).val();
   
          if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
            
           document.getElementById("AddBtnPur"+r).style.display = "none";           
        }
      
        
          if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
            
           document.getElementById("AddBtnPur"+r).style.display = "inline-block";           
        }  
               
         // x de elly hya lw byshtghl bsalb 
       if(x == 0){
       
          if(parseFloat(AvQty) != 0){
              
              
           if(parseFloat(AvQty) >= parseFloat(Qty)){
             
             
       document.getElementById("AddBtnPur"+r).style.display = "inline-block";
               
           }else{
               
      document.getElementById("AddBtnPur"+r).style.display = "none";     
               
           }   
          
   
              }else{
                  
         document.getElementById("AddBtnPur"+r).style.display = "none";         
              }    
           
           
       }else{
           
          document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
           
       }   
          
          if(HighDisc != 0){
              
            
              if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                        document.getElementById("AddBtnPur"+r).style.display = "none";    
              }else{
                      document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
                  
              }
              
              
          }
          
       
   }
       
   function ChangePriceUU(r){
       
     var PriceTwo = $("#UnitPriceTwo"+r).val();
          $("#Price"+r).val(parseFloat(PriceTwo).toFixed(2));
       
    var TaxRate = $("#TaxRate"+r).val();
      var TaxType = $("#TaxType"+r).val();
      var Qty = $("#Qty"+r).val();
      var AvQty = $("#AvQty"+r).val();
      var Price = $("#Price"+r).val();
      var Discount = $("#Discount"+r).val();
      var i = 0;
      var ii=0;       
      var iii=0;       
    var x=  @php echo $Def->Mainus; @endphp ;
        var HighDisc = $("#HighDisc"+r).val();                                           
                    var DIS = $("#DIS").val();
           
          if(parseFloat(DIS) == 0){
             
              Discount=$("#Discount"+r).val();
          }else{
            
              var d= Discount / 100 ;
              var Multi= parseFloat(Qty) * parseFloat(Price) ;
             var dd= Multi * d;
              
           Discount=  dd; 
          }
          
                      var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
                $("#TDiscProEdit"+r).val(parseFloat(BFG));
          if(TaxType == 1){
              //Precent
             
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
          
          $("#TotalBFTax"+r).val(parseFloat(BF));
              
          i =    parseFloat(TaxRate)  / 100 ;  
              
           ii=  parseFloat(BF) * parseFloat(i) ;
                 
              $("#Tax"+r).val(parseFloat(ii));
   
          iii =  parseFloat(BF) + parseFloat(ii) ;
              
              $("#Total"+r).val(parseFloat(iii));
              
          }else if(TaxType == 2){
             //Number 
         var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
            $("#TotalBFTax"+r).val(parseFloat(BF));
             
               i =    parseFloat(TaxRate)   ; 
              
              $("#Tax"+r).val(parseFloat(i));
   
          iii =  parseFloat(BF) + parseFloat(i) ;
              
              $("#Total"+r).val(parseFloat(iii));
              
              
          }
          
   
           var Total = $("#Total"+r).val();
           var TotalBFTax = $("#TotalBFTax"+r).val();
           var Tax = $("#Tax"+r).val();
           var UnitID = $("#UnitPurch"+r).val();
           var StorePurch = $("#StorePurch"+r).val();
   
          if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
            
           document.getElementById("AddBtnPur"+r).style.display = "none";           
        }
      
        
          if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
            
           document.getElementById("AddBtnPur"+r).style.display = "inline-block";           
        }  
               
         // x de elly hya lw byshtghl bsalb 
       if(x == 0){
       
          if(parseFloat(AvQty) != 0){
              
              
           if(parseFloat(AvQty) >= parseFloat(Qty)){
             
             
       document.getElementById("AddBtnPur"+r).style.display = "inline-block";
               
           }else{
               
      document.getElementById("AddBtnPur"+r).style.display = "none";     
               
           }   
          
   
              }else{
                  
         document.getElementById("AddBtnPur"+r).style.display = "none";         
              }    
           
           
       }else{
           
          document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
           
       }   
       
          if(HighDisc != 0){
              
            
              if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                        document.getElementById("AddBtnPur"+r).style.display = "none";    
              }else{
                      document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
                  
              }
              
              
          }
             
       
   }
           
   function ChangePriceUUU(r){
       
     var PriceThree = $("#UnitPriceThree"+r).val();
          $("#Price"+r).val(parseFloat(PriceThree).toFixed(2));
       
    var TaxRate = $("#TaxRate"+r).val();
      var TaxType = $("#TaxType"+r).val();
      var Qty = $("#Qty"+r).val();
      var AvQty = $("#AvQty"+r).val();
      var Price = $("#Price"+r).val();
      var Discount = $("#Discount"+r).val();
      var i = 0;
      var ii=0;       
      var iii=0;       
    var x=  @php echo $Def->Mainus; @endphp ;
            var HighDisc = $("#HighDisc"+r).val();                                       
                    var DIS = $("#DIS").val();
           
          if(parseFloat(DIS) == 0){
             
              Discount=$("#Discount"+r).val();
          }else{
            
              var d= Discount / 100 ;
              var Multi= parseFloat(Qty) * parseFloat(Price) ;
             var dd= Multi * d;
              
           Discount=  dd; 
          }
                     var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
                $("#TDiscProEdit"+r).val(parseFloat(BFG));
          
          if(TaxType == 1){
              //Precent
             
     var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
          
          $("#TotalBFTax"+r).val(parseFloat(BF));
              
          i =    parseFloat(TaxRate)  / 100 ;  
              
           ii=  parseFloat(BF) * parseFloat(i) ;
                 
              $("#Tax"+r).val(parseFloat(ii));
   
          iii =  parseFloat(BF) + parseFloat(ii) ;
              
              $("#Total"+r).val(parseFloat(iii));
              
          }else if(TaxType == 2){
             //Number 
        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );   
            $("#TotalBFTax"+r).val(parseFloat(BF));
             
               i =    parseFloat(TaxRate)   ; 
              
              $("#Tax"+r).val(parseFloat(i));
   
          iii =  parseFloat(BF) + parseFloat(i) ;
              
              $("#Total"+r).val(parseFloat(iii));
              
              
          }
          
   
           var Total = $("#Total"+r).val();
           var TotalBFTax = $("#TotalBFTax"+r).val();
           var Tax = $("#Tax"+r).val();
           var UnitID = $("#UnitPurch"+r).val();
           var StorePurch = $("#StorePurch"+r).val();
   
          if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
            
           document.getElementById("AddBtnPur"+r).style.display = "none";           
        }
      
        
          if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
            
           document.getElementById("AddBtnPur"+r).style.display = "inline-block";           
        }  
               
         // x de elly hya lw byshtghl bsalb 
       if(x == 0){
       
          if(parseFloat(AvQty) != 0){
              
              
           if(parseFloat(AvQty) >= parseFloat(Qty)){
             
             
       document.getElementById("AddBtnPur"+r).style.display = "inline-block";
               
           }else{
               
      document.getElementById("AddBtnPur"+r).style.display = "none";     
               
           }   
          
   
              }else{
                  
         document.getElementById("AddBtnPur"+r).style.display = "none";         
              }    
           
           
       }else{
           
          document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
           
       }   
       
          if(HighDisc != 0){
              
            
              if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                        document.getElementById("AddBtnPur"+r).style.display = "none";    
              }else{
                      document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
                  
              }
              
              
          }
             
       
   }
   
</script>
<!-- Recipy Voucher Add Ajax -->       
<script>
   $(document).ready(function(){
   
   fetch_customer_data();
   
   function fetch_customer_data(Creditor = '',AccountCode='',Shift='',Safe='',Coin='',Draw='',STORE='')
   {  
    $.ajax({
     url:'AddReciptVoucherAjax',
     method:'GET',
     data:{Creditor:Creditor,AccountCode:AccountCode,Shift:Shift,Safe:Safe,Coin:Coin,Draw:Draw,STORE:STORE},
     dataType:'json',
     success:function(data)
     {
         
         alert('تم الاضافه بنجاح');
   
         $('#Creditor').val(''); 
   $('#AccountCodeF').empty();     
         
     }
    })
   }
   
   $(document).on('click', '#ReciptVoucher', function(){
   
    var Creditor = $('#Creditor').val();     
    var AccountCode = $('#AccountCodeF').val();       
    var Shift = null;       
    var Safe = $('#SafeF').val();       
    var Coin = $('#CoinF').val();       
    var Draw = $('#DrawF').val();       
    var STORE = $('#STOREF').val();    
      
      if(Creditor != '' && AccountCode != ''){
       fetch_customer_data(Creditor,AccountCode,Shift,Safe,Coin,Draw,STORE);    
      }
      
   });
   
      
   
                
   });
   
</script>  
<!-- Payment Voucher Add Ajax -->       
<script>
   $(document).ready(function(){
   
   fetch_customer_data();
   
   function fetch_customer_data(Debitor = '',AccountCodee='',Shift='',Safe='',Coin='',Draw='',STORE='')
   {  
    $.ajax({
     url:'AddPaymentVoucherAjax',
     method:'GET',
     data:{Debitor:Debitor,AccountCodee:AccountCodee,Shift:Shift,Safe:Safe,Coin:Coin,Draw:Draw,STORE:STORE},
     dataType:'json',
     success:function(data)
     {
         
         alert('تم الاضافه بنجاح');
   
         $('#Debitor').val(''); 
   $('#AccountCodee').empty();     
         
     }
    })
   }
   
   $(document).on('click', '#PaymentVoucher', function(){
   
    var Debitor = $('#Debitor').val();     
    var AccountCodee = $('#AccountCodee').val();       
    var Shift = null;       
    var Safe = $('#SafeP').val();       
    var Coin = $('#CoinP').val();       
    var Draw = $('#DrawP').val();       
    var STORE = $('#STOREP').val();    
   
      if(Debitor != '' && AccountCodee != ''){
       fetch_customer_data(Debitor,AccountCodee,Shift,Safe,Coin,Draw,STORE);    
      }
      
   });
   
      
   
   
                
   });
   
</script>  
<!-- Change Tax -->
<script>
   function  TAXPurch(r){
   
   var countryId = $('#OLDTAX'+r).val();
   var Pro = $('#Product'+r).val();
   var Un = $('#UnitPurch'+r).val();
   var CO = $('#CodePurch'+r).val();
                   if(countryId) {
                       $.ajax({
                           url: 'TaxNamePurchasesFilter/'+countryId,
                           type:"GET",
                           dataType:"json",
                           beforeSend: function(){
                               $('#loader').css("visibility", "visible");
                           },
   
                           success:function(data) {
                        
                                   
                     $('#TaxRate'+r).val(data.rate); 
                     $('#TaxType'+r).val(data.type); 
                     $('#PurchTax'+r).val(data.tax); 
         
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var HighDisc = $("#HighDisc"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
   var x=  @php echo $Def->Mainus; @endphp ;
   
        var DIS = $("#DIS").val();
      
     if(parseFloat(DIS) == 0){
        
         Discount=$("#Discount"+r).val();
     }else{
       
         var d= Discount / 100 ;
         var Multi= parseFloat(Qty) * parseFloat(Price) ;
        var dd= Multi * d;
         
      Discount=  dd; 
     }
     
                var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
           $("#TDiscPro"+r).val(parseFloat(BFG));
     
     
     if(TaxType == 1){
         //Precent
        
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
     
     $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));
         
     i =    parseFloat(TaxRate)  / 100 ;  
         
      ii=  parseFloat(BF) * parseFloat(i) ;
            
         $("#Tax"+r).val(parseFloat(ii).toFixed(2));
   
     iii =  parseFloat(BF) + parseFloat(ii) ;
         
         $("#Total"+r).val(parseFloat(iii).toFixed(2));
         
     }else if(TaxType == 2){
        //Number 
        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
       $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));
        
          i =    parseFloat(TaxRate)   ; 
         
         $("#Tax"+r).val(parseFloat(i).toFixed(2));
   
     iii =  parseFloat(BF) + parseFloat(i) ;
         
         $("#Total"+r).val(parseFloat(iii).toFixed(2));
         
         
     }
     
   
      var Total = $("#Total"+r).val();
      var TotalBFTax = $("#TotalBFTax"+r).val();
      var Tax = $("#Tax"+r).val();
      var UnitID = $("#UnitPurch"+r).val();
      var StorePurch = $("#StorePurch"+r).val();
   
     if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
       
      document.getElementById("AddBtnPur"+r).style.display = "none";           
   }
   
   
     if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
       
      document.getElementById("AddBtnPur"+r).style.display = "inline-block";           
   }  
          
    // x de elly hya lw byshtghl bsalb 
   if(x == 0){
   
     if(parseFloat(AvQty) != 0){
         
         
      if(parseFloat(AvQty) >= parseFloat(Qty)){
        
        
   document.getElementById("AddBtnPur"+r).style.display = "inline-block";
          
      }else{
          
   document.getElementById("AddBtnPur"+r).style.display = "none";     
          
      }   
     
   
         }else{
             
    document.getElementById("AddBtnPur"+r).style.display = "none";         
         }    
      
      
   }else{
      
     document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
      
   }   
   
   
     if(HighDisc != 0){
         
       
         if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                   document.getElementById("AddBtnPur"+r).style.display = "none";    
         }else{
                 document.getElementById("AddBtnPur"+r).style.display = "inline-block";      
             
         }
         
         
     }
     
     
      
   
                           },
                           complete: function(){
                               $('#loader').css("visibility", "hidden");
                           }
                       });
                   } else {
   
                       $('select[name="state"]').empty();
                   }
   
   }   
   
   function PayInstall(){
      
         var Pay= $('#paid').val();
   
        $('#presenter').val(parseFloat(Pay).toFixed(2));
      
   }
</script>
<script type="text/javascript">
   function disableBack() { window.history.forward(); }
   setTimeout("disableBack()", 0);
   window.onunload = function () { null };
</script> 

<!-- Tax on Total -->
<script>
      function  TaxOn(){
   
   var TaxOnTotalType = $('#TaxOnTotalType').val();
   var TotalNet = $('#Total_PriceW').val();

       
                     if(TaxOnTotalType) {
                         $.ajax({
                             url: 'TaxOnTotalTypeFilter',
                             type:"GET",
                             data:{
                               TaxOnTotalType:TaxOnTotalType  
                             },
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 
            if(data.TaxType == 1){
         //Precent
             var i= parseFloat(data.TaxRate)  / parseFloat(100) ;
                
                var ii=  parseFloat(TotalNet) * parseFloat(i) ;  
                 $('#ProfitTax').val(parseFloat(ii)); 
                
                var iii =  $('#ProfitTax').val(); 
                var iiii = parseFloat(iii) + parseFloat(TotalNet); 
                $('#Total_PriceW').val(parseFloat(iiii)); 
                $('#paid').val(parseFloat(iiii)); 
                
                
                
}else if(data.TaxType == 2){
        //Number 
    
         
              
                 $('#ProfitTax').val(parseFloat(data.TaxRate)); 
                
                var iii =  $('#ProfitTax').val(); 
                var iiii = parseFloat(iii) + parseFloat(TotalNet); 
                $('#Total_PriceW').val(parseFloat(iiii)); 
                $('#paid').val(parseFloat(iiii)); 
    
}
                         
                      
           
      
   
   
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }
       
       
           
   
   }   
</script>

<!-- Purchases -->

<!--  Filter Products -->
<script>
   $(document).ready(function(){
   
    fetch_customer_data();
   
    function fetch_customer_data(search = '',store='',vendor='',Brand='',Group='')
    {  
     $.ajax({
      url:'NewPurchacesProductsFilter',
      method:'GET',
      data:{search:search,store:store,vendor:vendor,Brand:Brand,Group:Group},
      dataType:'json',
      success:function(data)
      {
       $('.DataP').html(data.table_data);
             $("#DataP").show();
      }
     })
    }
    
   $(document).on('keyup', '#searchP', function(){
     var search = $(this).val();     
     var store = $('#store').val();     
     var vendor = $('#client').val();     
     var Brand = $('#Brandd').val();     
     var Group = $('#Groupp').val();     
       if(search == ''){
            $("#Data").hide();
          }
     fetch_customer_data(search,store,vendor,Brand,Group);
    });
       
       
    $(document).on('change', '#store', function(){
     var store = $(this).val();     
     var search = $('#searchP').val();     
        var vendor = $('#client').val();     
       var Brand = $('#Brandd').val();     
     var Group = $('#Groupp').val();     
     fetch_customer_data(search,store,vendor,Brand,Group);
    });
       
       
        $(document).on('change', '#client', function(){
     var vendor = $(this).val();     
     var search = $('#searchP').val();  
      var store = $('#store').val();          
    var Brand = $('#Brandd').val();     
     var Group = $('#Groupp').val();     
     fetch_customer_data(search,store,vendor,Brand,Group);
    });   
   
            $(document).on('change', '#Brandd', function(){
     var Brand = $(this).val();     
     var search = $('#searchP').val();  
      var store = $('#store').val();          
    var vendor = $('#client').val();     
     var Group = $('#Groupp').val();     
     fetch_customer_data(search,store,vendor,Brand,Group);
    });   
   
       
            $(document).on('change', '#Groupp', function(){
     var Group = $(this).val();     
     var search = $('#searchP').val();  
      var store = $('#store').val();          
    var Brand = $('#Brandd').val();     
     var vendor = $('#client').val();     
     fetch_customer_data(search,store,vendor,Brand,Group);
    });   
   
   
        
   });
</script>
<!-- Add Products -->
<script>
   function FunP(r) { 
       
             var P_Ar_Name = $("#P_Ar_NameP"+r).val();
             var P_En_Name= $("#P_En_NameP"+r).val();
             var Product = $("#ProductP"+r).val();
             var UnitID = $("#UnitPurchP"+r).val();
             var UnitName = $("#UnitPurchNameP"+r).val();
             var Qty = $("#QtyP"+r).val();
             var Barcode = $("#CodePurchP"+r).val();
             var Price = $("#PriceP"+r).val();
             var Total = $("#TotalP"+r).val();
             var ExpDate = $("#ExpDateP"+r).val();
             var PurchTax = $("#PurchTaxP"+r).val();
             var TotalTax = $("#TaxP"+r).val();
             var Discount = $("#DiscountP"+r).val();
             var TDiscPro = $("#TDiscProP"+r).val();
             var TotalBFTax = $("#TotalBFTaxP"+r).val();
             var StorePurch = $("#StorePurchP"+r).val();
             var StorePurchName = $("#StorePurchNameP"+r).val();
             var PurchTax = $("#PurchTaxP"+r).val();
   var Price_Sale = $("#Price_SaleP"+r).val();
   var TaxRate = $("#TaxRateP"+r).val();
             var TaxType = $("#TaxTypeP"+r).val();
       var Exp='';
        var ED = $("#ED").val();
        var DISCSHOW = $("#DISCSHOW").val();
        var TOTBFSHOW = $("#TOTBFSHOW").val();
        var TAXSHOW = $("#TAXSHOW").val();
        var STORESHOW = $("#STORESHOW").val();
       
   
         if(ED == 1){
           
         Exp = "<td><input type='hidden' name='Exp_DateP[]' value='"+ExpDate+"'>" + ExpDate + "</td>";
           
       }else{
           
           Exp = "<input type='hidden' name='Exp_DateP[]' value='"+ExpDate+"'>";
       }
       
          if(DISCSHOW == 1){
           
       var  DISCSHOWW = "";
           
       }else{
           
             var  DISCSHOWW = "none";
       }
       
       
          if(TOTBFSHOW == 1){
           
        var TOTBFSHOWW = "";
           
       }else{
           
            var TOTBFSHOWW  = "none";
       }
       
       
       
          if(TAXSHOW == 1){
           
      var   TAXSHOWW = "";
           
       }else{
           
            var   TAXSHOWW = "none";
       }
       
       
       
          if(STORESHOW == 1){
           
        var STORESHOWW = "";
           
       }else{
           
             var STORESHOWW  = "none";
       }
       
       
       
       
             document.getElementById("AddBtnPurP"+r).style.display = "none";
             document.getElementById("RowP"+r).style.display = "none";
   
       



             var markup = "<tr><td><input type='hidden' name='P_Ar_NameP[]' value='"+P_Ar_Name+"'><input type='hidden' name='P_En_NameP[]' value='"+P_En_Name+"'>" + P_Ar_Name + "</td><td><input type='hidden' name='UnitP[]' value='"+UnitID+"'>" + UnitName + "</td><td><input type='hidden' name='P_CodeP[]' value='"+Barcode+"'>" + Barcode + "</td><td><input class='QunP form-control' id='QuntDP"+r+"' type='number' step='any' name='QtyP[]' value='"+Qty+"' onkeyup='TotDP("+r+")' onclick='TotDP("+r+")' ></td><td><input type='number' id='PriDP"+r+"' step='any' name='PriceP[]' value='"+Price+"' class='form-control' onkeyup='TotDP("+r+")' onclick='TotDP("+r+")' ></td><td style='display:"+DISCSHOWW+"' ><input class='DiscP form-control' id='DiscDP"+r+"' type='number' step='any' name='DiscountP[]' value='"+Discount+"' onkeyup='TotDP("+r+")' onclick='TotDP("+r+")' ></td><td style='display:"+TOTBFSHOWW+"'><input class='TotalBFTaxP form-control' id='TotBFTaxDP"+r+"' type='number' step='any' disabled  value='"+TotalBFTax+"'><input type='hidden'  id='TotBFTaxDHideP"+r+"' name='TotalBFTaxP[]'  value='"+TotalBFTax+"'></td><td style='display:"+TAXSHOWW+"'><input class='TotalTaxP form-control' id='TaxDP"+r+"' disabled  type='number' step='any' value='"+TotalTax+"'><input type='hidden' id='TotalTaxVVHideP"+r+"'  name='TotalTaxP[]'  value='"+TotalTax+"'></td><td><input class='TotP form-control' type='number' step='any' id='TotDP"+r+"' disabled   name='TotalP[]' value='"+Total+"'><input type='hidden' id='TotDHideP"+r+"' name='TotalP[]'  value='"+Total+"'></td><td style='display:"+STORESHOWW+"'><input  type='hidden' name='StorePurchP[]' value='"+StorePurch+"'>" + StorePurchName + "</td>"+Exp+"<td><button id='DelAssemP' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden' name='ProductP[]' value='"+Product+"'><input type='hidden' name='VOneP[]' value=''><input type='hidden' name='VTwoP[]' value=''></td><input type='hidden' name='V_NameP[]' value=''><input type='hidden' class='TDISCOOOP' id='TDiscProEditP"+r+"' name='TDiscProP[]' value='"+TDiscPro+"'><input type='hidden' name='VV_NameP[]' value=''><input type='hidden' name='PurchTaxP[]' value='"+PurchTax+"'><input id='TaxRateDP"+r+"' type='hidden'  value='"+TaxRate+"'><input type='hidden' id='TaxTypeDP"+r+"'  value='"+TaxType+"'><input type='hidden' name='Price_SaleP[]' value='"+Price_Sale+"'><input type='hidden' id='EnoughP"+r+"' name='AllEnoughP[]' class='ENOP'  value='0'></tr>";
   
   
       
             $("#data-dtP").append(markup);
       $("#DataP").hide();
      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dtP').rowCount();     
                
    var sumQ = 0;        
   $('.QunP').each(function(){
   sumQ += parseFloat($(this).val());
   });   
            
    var sumT = 0;        
   $('.TotP').each(function(){
   sumT += parseFloat($(this).val());
   });       
       
        var sumD = 0;        
   $('.DiscP').each(function(){
   sumD += parseFloat($(this).val());
   }); 
       
               var sumTTD = 0;        
   $('.TDISCOOOP').each(function(){
   sumTTD += parseFloat($(this).val());
   }); 
       
       
           var sumBF = 0;        
   $('.TotalBFTaxP').each(function(){
   sumBF += parseFloat($(this).val());
   }); 
       
           var sumTax = 0;        
   $('.TotalTaxP').each(function(){
   sumTax += parseFloat($(this).val());
   }); 
       
   
   $('#Product_NumbersP').val(parseFloat(rowctr));
   $('#Product_NumbersHideP').val(parseFloat(rowctr));
       
   $('#Total_QtyP').val(parseFloat(sumQ));
   $('#Total_QtyHideP').val(parseFloat(sumQ));
       
   $('#Total_PriceP').val(parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax));
   $('#Total_PriceHideP').val(parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax));
   $('#Total_PriceWP').val(parseFloat(sumT));
   $('#Total_BillP').val(parseFloat(sumT));
   
     
           $('#Total_DiscountTTP').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTTP').val(parseFloat(sumTTD).toFixed(2));
    
       $('#Total_DiscountP').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHideP').val(parseFloat(sumD).toFixed(2));
       
          $('#Total_Bf_TaxesP').val(parseFloat(sumBF)+parseFloat(sumTTD));
   $('#Total_Bf_TaxesHideP').val(parseFloat(sumBF)+parseFloat(sumTTD));
       
          $('#Total_TaxesP').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHideP').val(parseFloat(sumTax).toFixed(2));
       
   
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
       
            var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paidP').val();
        
      if(Pay == 'Later' &&  Stat == 0 ){
               
             if(paid == 0 || paid < 0){   
        document.getElementById("Submit").style.display = "none";  
             }else{
                 
           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
                 
                 
                 
             }
           
       }else{
           
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }   
       }
   
     
                             var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paidP').val();
        var resdiual =$('#resdiualP').val();
        var total =$('#Total_PriceHideP').val();
        var totalDisc =$('#Total_DiscountHideTTP').val();
        var totalTax =$('#Total_TaxesHideP').val();
   
   
           var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
           var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterDP').val(parseFloat(RRR).toFixed(2));     
         $('#paidP').val(parseFloat(RR).toFixed(2));
            
       
               var Pay =$('#Payment_Method').val();
      if(Pay == 'Later'){
         
        
                   $('#paidP').val('');
           
       }
       
        var SafyMby3at =$('#Total_PriceW').val();
         var SafyMshtryat =$('#Total_PriceWP').val();
       
        var DifRR=  parseFloat(SafyMby3at) -  parseFloat(SafyMshtryat);
       $('#Dif').val(DifRR);
       
   
        $('#data-dtP').on('click', '#DelAssemP', function(e){
                $(this).closest('tr').remove(); 
            
   
      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };
   
   var rowctr = $('#dtP').rowCount();     
                
    var sumQ = 0;        
   $('.QunP').each(function(){
   sumQ += parseFloat($(this).val());
   });   
            
    var sumT = 0;        
   $('.TotP').each(function(){
   sumT += parseFloat($(this).val());
   });       
       
        var sumD = 0;        
   $('.DiscP').each(function(){
   sumD += parseFloat($(this).val());
   }); 
       
       
           var sumBF = 0;        
   $('.TotalBFTaxP').each(function(){
   sumBF += parseFloat($(this).val());
   }); 
       
           var sumTax = 0;        
   $('.TotalTaxP').each(function(){
   sumTax += parseFloat($(this).val());
   }); 
       
   
                 var sumTTD = 0;        
   $('.TDISCOOOP').each(function(){
   sumTTD += parseFloat($(this).val());
   }); 
       
  $('#Product_NumbersP').val(parseFloat(rowctr));
   $('#Product_NumbersHideP').val(parseFloat(rowctr));
       
   $('#Total_QtyP').val(parseFloat(sumQ));
   $('#Total_QtyHideP').val(parseFloat(sumQ));
       
   $('#Total_PriceP').val(parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax));
   $('#Total_PriceHideP').val(parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax));
   $('#Total_PriceWP').val(parseFloat(sumT));
   $('#Total_BillP').val(parseFloat(sumT));
   
     
           $('#Total_DiscountTTP').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTTP').val(parseFloat(sumTTD).toFixed(2));
    
       $('#Total_DiscountP').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHideP').val(parseFloat(sumD).toFixed(2));
       
          $('#Total_Bf_TaxesP').val(parseFloat(sumBF)+parseFloat(sumTTD));
   $('#Total_Bf_TaxesHideP').val(parseFloat(sumBF)+parseFloat(sumTTD));
       
          $('#Total_TaxesP').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHideP').val(parseFloat(sumTax).toFixed(2));
       
       
   
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
            
                  var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paidP').val();
        
      if(Pay == 'Later' &&  Stat == 0 ){
               
             if(paid == 0 || paid < 0){   
        document.getElementById("Submit").style.display = "none";  
             }else{
                 
           if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }
                 
                 
                 
             }
           
       }else{
           
       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";    
           
       }else{
           
        document.getElementById("Submit").style.display = "block";    
       }   
       }
   
     
      
                             var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paidP').val();
        var resdiual =$('#resdiualP').val();
        var total =$('#Total_PriceHideP').val();
          var totalDisc =$('#Total_DiscountHideTTP').val();
        var totalTax =$('#Total_TaxesHideP').val();
   
   
        var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterDP').val(parseFloat(RRR).toFixed(2));       
         $('#paidP').val(parseFloat(RR).toFixed(2));
            
            
               var Pay =$('#Payment_Method').val();
      if(Pay == 'Later'){
         
        
                   $('#paidP').val('');
           
       }
       
          var EN = 0;  
    var Total_PriceW =$('#Total_PriceWP').val();
      
  $('.ENO').each(function(){
   EN += parseFloat($(this).val());
   }); 
 if(EN == 0){
        
             if(Total_PriceW == 'NaN'){
                   document.getElementById("Submit").style.display = "none";   
                    }else{
        document.getElementById("Submit").style.display = "block";    
             }
             
       }else{
           
        document.getElementById("Submit").style.display = "none";    
       } 
            
           
            
                    var SafyMby3at =$('#Total_PriceW').val();
         var SafyMshtryat =$('#Total_PriceWP').val();
       
        var DifRR=  parseFloat(SafyMby3at) -  parseFloat(SafyMshtryat);
       $('#Dif').val(DifRR);
       
   
   
                    })  
       
       
     }    
</script> 
<!-- Total Products -->
<script>
   function PurchTotalP(r) { 
   var TaxRate = $("#TaxRateP"+r).val();
   var TaxType = $("#TaxTypeP"+r).val();
   var Qty = $("#QtyP"+r).val();
   var Price = $("#PriceP"+r).val();
   var Discount = $("#DiscountP"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
   
   
   
          var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
        
           Discount=$("#DiscountP"+r).val();
         
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
   
       }
           var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscPro"+r).val(parseFloat(BFG));
       if(TaxType == 1){
           //Precent
          
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
     
            var BFF =  parseFloat(Qty) *  parseFloat(Price);  
    
         $("#TotalBFTaxP"+r).val(parseFloat(BFF).toFixed(2));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#TaxP"+r).val(parseFloat(ii).toFixed(2));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#TotalP"+r).val(parseFloat(iii).toFixed(2));
           
       }else if(TaxType == 2){
          //Number 
       var BF =  parseFloat(Qty) *  ( parseFloat(Price)  -  parseFloat(Discount) );  
       var BFF =  parseFloat(Qty) *  parseFloat(Price)  ;  
    
         $("#TotalBFTaxP"+r).val(parseFloat(BFF).toFixed(2));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#TaxP"+r).val(parseFloat(i).toFixed(2));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#TotalP"+r).val(parseFloat(iii).toFixed(2));
           
           
       }
       
   
        var Total = $("#TotalP"+r).val();
        var TotalBFTax = $("#TotalBFTaxP"+r).val();
        var Tax = $("#TaxP"+r).val();
        var UnitID = $("#UnitPurchP"+r).val();
        var StorePurch = $("#StorePurchP"+r).val();
   
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPurP"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
              if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPurP"+r).style.display = "none";  
           
           }else{
             document.getElementById("AddBtnPurP"+r).style.display = "inline-block";  
           }      
     }  
            
       
       
       
       
   }
    
     function TotDP(r) { 
   var TaxRate = $("#TaxRateDP"+r).val();
   var TaxType = $("#TaxTypeDP"+r).val();
   var Qty = $("#QuntDP"+r).val();
   var Price = $("#PriDP"+r).val();
   var Discount = $("#DiscDP"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
   
               var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
          
           Discount=$("#DiscDP"+r).val();
               var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscProEditP"+r).val(parseFloat(BFG));
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
               var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscProEditP"+r).val(parseFloat(BFG));
       }
         
       if(TaxType == 1){
           //Precent
          
     var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
     var BFF =  parseFloat(Qty) *  parseFloat(Price);  
   
       $("#TotBFTaxDP"+r).val(parseFloat(BFF).toFixed(2));
       $("#TotBFTaxDHideP"+r).val(parseFloat(BFF).toFixed(2));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#TaxDP"+r).val(parseFloat(ii).toFixed(2));
           $("#TaxDHideP"+r).val(parseFloat(ii).toFixed(2));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#TotDP"+r).val(parseFloat(iii).toFixed(2));
           $("#TotDHideP"+r).val(parseFloat(iii).toFixed(2));
           
       }else if(TaxType == 2){
          //Number 
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) ); 
   var BFF =  parseFloat(Qty) *  parseFloat(Price) ;  
         $("#TotBFTaxDP"+r).val(parseFloat(BFF).toFixed(2));
         $("#TotBFTaxDHideP"+r).val(parseFloat(BFF).toFixed(2));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#TaxDP"+r).val(parseFloat(i).toFixed(2));
           $("#TaxDHideP"+r).val(parseFloat(i).toFixed(2));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#TotDP"+r).val(parseFloat(iii).toFixed(2));
           $("#TotDHideP"+r).val(parseFloat(iii).toFixed(2));
           
           
       }
       
   var rowctr = $('#dtP').rowCount();     
                
    var sumQ = 0;        
   $('.QunP').each(function(){
   sumQ += parseFloat($(this).val());
   });   
            
    var sumT = 0;        
   $('.TotP').each(function(){
   sumT += parseFloat($(this).val());
   });       
       
        var sumD = 0;        
   $('.DiscP').each(function(){
   sumD += parseFloat($(this).val());
   }); 
       
       
           var sumBF = 0;        
   $('.TotalBFTaxP').each(function(){
   sumBF += parseFloat($(this).val());
   }); 
       
           var sumTax = 0;        
   $('.TotalTaxP').each(function(){
   sumTax += parseFloat($(this).val());
   }); 
       
   
                var sumTTD = 0;        
   $('.TDISCOOOP').each(function(){
   sumTTD += parseFloat($(this).val());
   }); 
       
   $('#Product_NumbersP').val(parseFloat(rowctr));
   $('#Product_NumbersHideP').val(parseFloat(rowctr));
       
   $('#Total_QtyP').val(parseFloat(sumQ));
   $('#Total_QtyHideP').val(parseFloat(sumQ));
       
    $('#Total_PriceP').val(parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax));
   $('#Total_PriceHideP').val(parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax));
   $('#Total_PriceWP').val(parseFloat(sumT));
       $('#Total_BillP').val(parseFloat(sumT));
           $('#Total_DiscountTTP').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTTP').val(parseFloat(sumTTD).toFixed(2));
    
       $('#Total_DiscountP').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHideP').val(parseFloat(sumD).toFixed(2));
       
          $('#Total_Bf_TaxesP').val(parseFloat(sumBF)+parseFloat(sumTTD));
   $('#Total_Bf_TaxesHideP').val(parseFloat(sumBF)+parseFloat(sumTTD));
       
          $('#Total_TaxesP').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHideP').val(parseFloat(sumTax).toFixed(2));
       
                            var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paidP').val();
        var resdiual =$('#resdiualP').val();
        var total =$('#Total_PriceHideP').val();
        var totalDisc =$('#Total_DiscountHideTTP').val();
   
          var totalTax =$('#Total_TaxesHideP').val();
   
   
         var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterDP').val(parseFloat(RRR).toFixed(2));        
         $('#paidP').val(parseFloat(RR).toFixed(2));
    
           
            var EN = 0;  
               var Pay =$('#Payment_Method').val();
               var Total_PriceW =$('#Total_PriceWP').val();
      if(Pay == 'Later'){
         
        
                   $('#paidP').val('');
           
       }
       
         
                  if(parseFloat(Qty) < 0 || parseFloat(Price) < 0 || parseFloat(Discount) < 0)
           {
               document.getElementById("QuntD"+r).style.border="1px solid darkred";     
             $("#EnoughP"+r).val(1);
              
              }else{  
                       document.getElementById("QuntD"+r).style.border="none"; 
             $("#EnoughP"+r).val(0);
                        }
       
  $('.ENO').each(function(){
   EN += parseFloat($(this).val());
   }); 
 if(EN == 0){
        
             if(Total_PriceW == 'NaN'){
                   document.getElementById("Submit").style.display = "none";   
                    }else{
        document.getElementById("Submit").style.display = "block";    
             }
             
       }else{
           
        document.getElementById("Submit").style.display = "none";    
       } 
       
             var SafyMby3at =$('#Total_PriceW').val();
         var SafyMshtryat =$('#Total_PriceWP').val();
       
        var DifRR=  parseFloat(SafyMby3at) -  parseFloat(SafyMshtryat);
       $('#Dif').val(DifRR);
       
     
   }
    
</script>
<!-- Unit Code and Name -->
<script>
   function  UnitCodePurchhP(r){
   
   var countryId = $('#UnitPurchP'+r).val();
   var Pro = $('#ProductP'+r).val();
   var store = $('#StorePurchP'+r).val();
   var code = $('#CodePurchP'+r).val();
                     if(countryId) {
                         $.ajax({
                             url: 'UnitPurchasesFilter/'+countryId+'/'+Pro+'/'+store+'/'+code,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
                                     
                       $('#CodePurchP'+r).val(data.code); 
                       $('#UnitPurchNameP'+r).val(data.name); 
                       $('#TaxRateP'+r).val(data.rate); 
                       $('#TaxTypeP'+r).val(data.type); 
                       $('#PriceP'+r).val(data.price); 
                       $('#PurchTaxP'+r).val(data.tax); 
                                         $('#UnitPriceOneP'+r).val(data.priceOne); 
                       $('#UnitPriceTwoP'+r).val(data.priceTwo); 
                       $('#UnitPriceThreeP'+r).val(data.priceThree);                   
   
                                 });
                                 
                                var TaxRate = $("#TaxRateP"+r).val();
   var TaxType = $("#TaxTypeP"+r).val();
   var Qty = $("#QtyP"+r).val();
   var Price = $("#PricP"+r).val();
   var Discount = $("#DiscountP"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
   
               var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
        
           Discount=$("#DiscountP"+r).val();
         
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
   
       }
           var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscProP"+r).val(parseFloat(BFG));
   
       if(TaxType == 1){
           //Precent
          
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
      var BFF =  parseFloat(Qty) *  parseFloat(Price);  
       
       $("#TotalBFTaxP"+r).val(parseFloat(BFF));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#TaxP"+r).val(parseFloat(ii));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#TotalP"+r).val(parseFloat(iii));
           
       }else if(TaxType == 2){
          //Number 
        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
        var BFF =  parseFloat(Qty) *  parseFloat(Price);  
         $("#TotalBFTaxP"+r).val(parseFloat(BFF));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#TaxP"+r).val(parseFloat(i));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#TotalP"+r).val(parseFloat(iii));
           
           
       }
       
   
        var Total = $("#TotalP"+r).val();
        var TotalBFTax = $("#TotalBFTaxP"+r).val();
        var Tax = $("#TaxP"+r).val();
        var UnitID = $("#UnitPurchP"+r).val();
        var StorePurch = $("#StorePurchP"+r).val();
   
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPurP"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
        document.getElementById("AddBtnPurP"+r).style.display = "block";           
     }  
            
       
        
   
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }
   
   }   
</script>  

<!-- Store Name -->
<script>
   function  StoreNamePurchP(r){
   
   var countryId = $('#StorePurchP'+r).val();
   var Pro = $('#ProductP'+r).val();
   var Un = $('#UnitPurchP'+r).val();
   var CO = $('#CodePurchP'+r).val();
                     if(countryId) {
                         $.ajax({
                             url: 'StoreNamePurchasesFilter/'+countryId,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
                                     
                       $('#StorePurchNameP'+r).val(data.name); 
                   
                                     
                             $.ajax({
                             url: 'StorePricePurchasesFilter',
                             type:"GET",
                             data:{
                                Product:Pro,
                                Store:countryId,
                                Unit:Un,
                                Code:CO,
                             },
                            dataType:"json",         
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },
   
                             success:function(data) {
                                 $.each(data, function(key, value){
                                     
                       $('#Price'+r).val(data.price); 
                   
                                     
   
                                 });
                                 
   var TaxRate = $("#TaxRateP"+r).val();
   var TaxType = $("#TaxTypeP"+r).val();
   var Qty = $("#QtyP"+r).val();
   var Price = $("#PriceP"+r).val();
   var Discount = $("#DiscountP"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
   
                                         var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
        
           Discount=$("#DiscountP"+r).val();
         
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
   
       }
           var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscProP"+r).val(parseFloat(BFG));
       
       if(TaxType == 1){
           //Precent
          
        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
        var BFF =  parseFloat(Qty) *  parseFloat(Price);  
       
       $("#TotalBFTaxP"+r).val(parseFloat(BFF));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#TaxP"+r).val(parseFloat(ii));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#TotalP"+r).val(parseFloat(iii));
           
       }else if(TaxType == 2){
          //Number 
           var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );    
           var BFF =  parseFloat(Qty) *  parseFloat(Price);    
         $("#TotalBFTaxP"+r).val(parseFloat(BFF));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#TaxP"+r).val(parseFloat(i));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#TotalP"+r).val(parseFloat(iii));
           
           
       }
       
   
        var Total = $("#TotalP"+r).val();
        var TotalBFTax = $("#TotalBFTaxP"+r).val();
        var Tax = $("#TaxP"+r).val();
        var UnitID = $("#UnitPurchP"+r).val();
        var StorePurch = $("#StorePurchP"+r).val();
   
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPurP"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
        document.getElementById("AddBtnPurP"+r).style.display = "block";           
     }  
            
       
        
   
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });             
                                     
   
   
                                 });
                                 
   var TaxRate = $("#TaxRateP"+r).val();
   var TaxType = $("#TaxTypeP"+r).val();
   var Qty = $("#QtyP"+r).val();
   var Price = $("#PriceP"+r).val();
   var Discount = $("#DiscountP"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
        var DIS = $("#DIS").val();
        
       if(parseFloat(DIS) == 0){
        
           Discount=$("#DiscountP"+r).val();
         
       }else{
         
           var d= Discount / 100 ;
           var Multi= parseFloat(Price) ;
          var dd= Multi * d;
           
        Discount=  dd; 
   
       }
           var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscProP"+r).val(parseFloat(BFG));
       
       if(TaxType == 1){
           //Precent
          
   var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );   
   var BFF =  parseFloat(Qty) *  (parseFloat(Price)  );   
       
       $("#TotalBFTaxP"+r).val(parseFloat(BFF));
           
       i =    parseFloat(TaxRate)  / 100 ;  
           
        ii=  parseFloat(BF) * parseFloat(i) ;
              
           $("#TaxP"+r).val(parseFloat(ii));
   
       iii =  parseFloat(BF) + parseFloat(ii) ;
           
           $("#TotalP"+r).val(parseFloat(iii));
           
       }else if(TaxType == 2){
          //Number 
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );    
      var BFF =  parseFloat(Qty) *  (parseFloat(Price)   );    
         $("#TotalBFTaxP"+r).val(parseFloat(BFF));
          
            i =    parseFloat(TaxRate)   ; 
           
           $("#TaxP"+r).val(parseFloat(i));
   
       iii =  parseFloat(BF) + parseFloat(i) ;
           
           $("#TotalP"+r).val(parseFloat(iii));
           
           
       }
       
   
        var Total = $("#TotalP"+r).val();
        var TotalBFTax = $("#TotalBFTaxP"+r).val();
        var Tax = $("#TaxP"+r).val();
        var UnitID = $("#UnitPurchP"+r).val();
        var StorePurch = $("#StorePurchP"+r).val();
   
       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
         
        document.getElementById("AddBtnPurP"+r).style.display = "none";           
     }
   
     
       if(TaxRate != ''  && TaxType != ''  &&  Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
         
        document.getElementById("AddBtnPurP"+r).style.display = "block";           
     }  
            
       
        
   
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {
   
                         $('select[name="state"]').empty();
                     }
   
   }   
</script>  
<!-- Change Price Unit -->
<script>
   function ChangePriceUnitP(r){
       
   var POne = $('#UnitPriceOneP'+r).val();    
   var PTwo = $('#UnitPriceTwoP'+r).val();    
   var PThree = $('#UnitPriceThreeP'+r).val();    
   var ID = $('#UnitPriceIDP'+r).val();    
   
       if(PTwo == ''){
           
           PTwo  = 0 ;
       }else{
           
         PTwo = $('#UnitPriceTwoP'+r).val();   
       }
       
          if(PThree == ''){
           
           PThree  = 0 ;
       }else{
           
         PThree = $('#UnitPriceThreeP'+r).val();   
       }
       
         if(POne) {
                        $.ajax({
                            url: 'ChangePriceUnit/'+POne+'/'+PTwo+'/'+PThree+'/'+ID,
                            type:"GET",
                            dataType:"json",
                            beforeSend: function(){
                                $('#loader').css("visibility", "visible");
                            },
   
                            success:function(data) {
                                $.each(data, function(key, value){
                                    
                    alert('تم التحديث بنجاح');
                                    
                                });
                            },
                            complete: function(){
                                $('#loader').css("visibility", "hidden");
                            }
                        });
                    }else{
                        
                       alert('حقل السعر الاول مطلوب'); 
                        
                    }
       
       
       
   }
</script>
<!-- Change Tax -->
<script>
   function  TAXPurchP(r){
   
   var countryId = $('#OLDTAXP'+r).val();
   var Pro = $('#ProductP'+r).val();
   var Un = $('#UnitPurchP'+r).val();
   var CO = $('#CodePurchP'+r).val();
                   if(countryId) {
                       $.ajax({
                           url: 'TaxNamePurchasesFilter/'+countryId,
                           type:"GET",
                           dataType:"json",
                           beforeSend: function(){
                               $('#loader').css("visibility", "visible");
                           },
   
                           success:function(data) {
                        
                                   
                     $('#TaxRateP'+r).val(data.rate); 
                     $('#TaxTypeP'+r).val(data.type); 
                     $('#PurchTaxP'+r).val(data.tax); 
         
   var TaxRate = $("#TaxRateP"+r).val();
   var TaxType = $("#TaxTypeP"+r).val();
   var Qty = $("#QtyP"+r).val();
   var Price = $("#PriceP"+r).val();
   var Discount = $("#DiscountP"+r).val();
   var i = 0;
   var ii=0;       
   var iii=0;       
      var DIS = $("#DIS").val();
      
     if(parseFloat(DIS) == 0){
      
         Discount=$("#DiscountP"+r).val();
       
     }else{
       
         var d= Discount / 100 ;
         var Multi= parseFloat(Price) ;
        var dd= Multi * d;
         
      Discount=  dd; 
   
     }
         var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
           $("#TDiscProP"+r).val(parseFloat(BFG));
     
     if(TaxType == 1){
         //Precent
        
      var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );  
      var BFF =  parseFloat(Qty) *  parseFloat(Price)  ;  
     
     $("#TotalBFTaxP"+r).val(parseFloat(BFF).toFixed(2));
         
     i =    parseFloat(TaxRate)  / 100 ;  
         
      ii=  parseFloat(BF) * parseFloat(i) ;
            
         $("#TaxP"+r).val(parseFloat(ii).toFixed(2));
   
     iii =  parseFloat(BF) + parseFloat(ii) ;
         
         $("#TotalP"+r).val(parseFloat(iii).toFixed(2));
         
     }else if(TaxType == 2){
        //Number 
        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );    
        var BFF =  parseFloat(Qty) *  parseFloat(Price) ;    
       $("#TotalBFTaxP"+r).val(parseFloat(BFF).toFixed(2));
        
          i =    parseFloat(TaxRate)   ; 
         
         $("#TaxP"+r).val(parseFloat(i).toFixed(2));
   
     iii =  parseFloat(BF) + parseFloat(i) ;
         
         $("#TotalP"+r).val(parseFloat(iii).toFixed(2));
         
         
     }
     
   
      var Total = $("#TotalP"+r).val();
      var TotalBFTax = $("#TotalBFTaxP"+r).val();
      var Tax = $("#TaxP"+r).val();
      var UnitID = $("#UnitPurchP"+r).val();
      var StorePurch = $("#StorePurchP"+r).val();
   
     if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){
       
      document.getElementById("AddBtnPurP"+r).style.display = "none";           
   }
   
   
     if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){
       
         if( Price == 0 ){
       
      document.getElementById("AddBtnPurP"+r).style.display = "none";           
   }else{  
         
      document.getElementById("AddBtnPurP"+r).style.display = "inline-block";  
   }       
   }  
          
     
     
   
     
      
   
                           },
                           complete: function(){
                               $('#loader').css("visibility", "hidden");
                           }
                       });
                   } else {
   
                       $('select[name="state"]').empty();
                   }
   
   }   
</script>
<script>
   $(document).ready(function(){
         $( "#Barcode" ).val(Math.floor(Math.random() * 1000000));
   });
</script>




@endpush