@extends('admin.index')
@section('content')
@php
use App\Models\ProductSales;
use App\Models\CompanyData;
use App\Models\GeneralDaily;
use App\Models\Addressses;
use App\Models\Customers;
$Def=CompanyData::orderBy('id','desc')->first();
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();

use App\Models\SalesDefaultData;
$Deff=SalesDefaultData::orderBy('id','desc')->first();

@endphp
<title>{{trans('admin.SalesDeliverySechdule')}}</title>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}}</a></li>
      <li class="breadcrumb-item active"> {{trans('admin.SalesDeliverySechdule')}} </li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
         class="js-get-date"></span></li>
   </ol>
      <!-- Filter -->
     <div class="row">
                        <div class="col-lg-12">
                            <div id="panel-2" class="panel first-color">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i> Filter  </i></span>
                                    </h2>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <form action="{{url('FilterSalesDelivery')}}" method="get" class="form-row">
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                                <input type="date" name="From" value="{{date('Y-m-d')}}" class="form-control" required>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                                <input type="date" name="To" value="{{date('Y-m-d')}}" class="form-control" required>
                                            </div>

                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Client')}} </label>
                                                <select class="select2 form-control w-100" name="Client">
                                          <option value=""> {{trans('admin.Client')}}</option>
                                           @foreach($Clients as $cli)
                                                <option value="{{$cli->id}}">
                                                {{app()->getLocale() == 'ar' ?$cli->Name :$cli->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>

                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">   {{trans('admin.Deliverd')}} </label>
                                                <select class="select2 form-control w-100" name="Delivery_Status">
                                                   <option value=""> {{trans('admin.Deliverd')}}</option>
                                                 <option value="1">{{trans('admin.Yes')}} </option>
                                                <option value="0">{{trans('admin.No')}}</option>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Delivery')}}  </label>
                                                <select class="select2 form-control w-100" name="Delivery">
                                                    <option value=""> {{trans('admin.Delivery')}}</option>
                                                 @foreach($Deliveries as $emp)
                                                <option value="{{$emp->id}}">

                                                {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>

                                          <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Governrates')}}  </label>
                                                <select class="select2 form-control w-100" name="Governrate">
                                                    <option value=""> {{trans('admin.Governrates')}}</option>
                                                 @foreach($Governrates as $gov)
                                                <option value="{{$gov->id}}">

                                                 {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>

                                                         <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Cities')}}  </label>
                                                <select class="select2 form-control w-100" name="City">
                                                    <option value=""> {{trans('admin.Cities')}}</option>
                                                 @foreach($Cities as $cit)
                                                <option value="{{$cit->id}}">

                                           {{app()->getLocale() == 'ar' ?$cit->Arabic_Name :$cit->English_Name}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>

                                                         <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Places')}}  </label>
                                                <select class="select2 form-control w-100" name="Place">
                                                    <option value=""> {{trans('admin.Places')}}</option>
                                                 @foreach($Places as $pla)
                                                <option value="{{$pla->id}}">
                                                   {{app()->getLocale() == 'ar' ?$pla->Arabic_Name :$pla->English_Name}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>



                                            <div class="form-group col-lg-2">
                                      <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                <input type="text" name="Code" class="form-control">
                                            </div>

                                            <div class="form-group col-md-2">
                                                <div class="buttons mt-4">
    <button type="submit" class="btn btn-primary show-table w-100"> <i class="fal fa-folder"></i> {{trans('admin.Show')}}</button>
                                                </div>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
   <!-- Data -->
   <div class="row hide-table">
      <div class="col-xl-12">
         <div id="panel-1" class="panel second-color">
            <div class="panel-hdr">
               <h2>
                  {{trans('admin.SalesDeliverySechdule')}}
               </h2>
               <div class="panel-toolbar">
                  <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delivery">{{trans('admin.Delivery')}} </button>
               </div>
               <div class="panel-toolbar">
                  <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Collection">{{trans('admin.Collection')}} </button>
               </div>
               <!--         Bill Collection modal -->
               <div class="modal fade" id="Collection" tabindex="-1" role="dialog" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                     <div class="modal-content">
                        <div class="modal-header">
                           <h4 class="modal-title">
                              {{trans('admin.Collection')}}
                           </h4>
                           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                           <span aria-hidden="true"><i class="fal fa-times"></i></span>
                           </button>
                        </div>
                        <form action="{{url('PostCollectDelivery')}}" method="post">
                           @csrf
                           <div class="modal-body">
                              <div class="row">
                                 <div class="form-group col-lg-12">
                                    <select class="select2 form-control"  id="DeliveryCollection" onchange="Collect()">
                                       <option value="">{{trans('admin.Delivery')}}</option>
                                       @foreach($Deliveries as $del)
                                       <option value="{{$del->id}}">

                             {{app()->getLocale() == 'ar' ?$del->Name :$del->NameEn}}
                                        </option>
                                       @endforeach
                                    </select>
                                 </div>
                                 <div class="col-md-6">
                                    <label>{{trans('admin.Debitor')}}</label>
                                    <input type="text"  class="form-control" id="Debitor" disabled >
                                 </div>
                                 <div class="col-md-6">
                                    <label>{{trans('admin.Creditor')}}</label>
                                    <input type="number" step="any" class="form-control" name="Creditor" >
                                 </div>
                                 <input type="hidden" name="Account" id="Account">
                                 <div class="form-group col-lg-4">
                                    <label class="form-label" for="">{{trans('admin.Currency')}}</label>
                                    <select class="select2 form-control w-100" name="Coin" >
                                       <option value="">{{trans('admin.Currency')}}</option>
                                       @foreach($Coins as $coin)
                                       <option value="{{$coin->id}}" @if($Deff->Coin == $coin->id) selected @endif>
                                          {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                       </option>
                                       @endforeach
                                    </select>
                                 </div>
                                 <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                    <input type="number" step="any" name="Draw" value="1" class="form-control"  />
                                 </div>
                                 <div class="form-group col-lg-4">
                                    <label class="form-label" for="">{{trans('admin.Safe')}} </label>
                                    <select class="select2 form-control w-100" name="Safe" >
                                       <option value=""> {{trans('admin.Safe')}}</option>
                                       @foreach($Safes as $safe)
                                       <option value="{{$safe->id}}" @if($Deff->Safe == $safe->id) selected @endif>
                                       {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                       </option>
                                       @endforeach
                                    </select>
                                 </div>
                              </div>
                           </div>
                           <div class="modal-footer">
                              <button type="button" class="btn btn-secondary" data-dismiss="modal">   {{trans('admin.Close')}}</button>
                              <button type="submit" class="btn btn-secondary">   {{trans('admin.Save')}}</button>
                           </div>
                        </form>
                     </div>
                  </div>
               </div>
               <div class="panel-toolbar">
                  <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                  Style</button>
                   @include('admin.layouts.toolbar')
               </div>
            </div>
            <div class="panel-container show">
               <span id="ex"> @include('admin.layouts.messages')</span>
               <div class="panel-content">
                  <form action="{{url('ChangeDelivery')}}" method="post">
                     @csrf
                     <!--         Deliverymodal -->
                     <div class="modal fade" id="Delivery" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                           <div class="modal-content">
                              <div class="modal-header">
                                 <h4 class="modal-title">
                                    {{trans('admin.Delivery')}}
                                 </h4>
                                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                 <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                 </button>
                              </div>
                              <div class="modal-body">
                                 <div class="row">
                                    <div class="form-group col-lg-12">
                                       <select class="select2 form-control" name="Delivery" id="Delivery">
                                          <option value="">{{trans('admin.Delivery')}}</option>
                                          @foreach($Deliveries as $del)
                                          <option value="{{$del->id}}">   {{app()->getLocale() == 'ar' ?$del->Name :$del->NameEn}}    </option>
                                          @endforeach
                                       </select>
                                    </div>
                                 </div>
                              </div>
                              <div class="modal-footer">
                                 <button type="button" class="btn btn-secondary" data-dismiss="modal">   {{trans('admin.Close')}}</button>
                                 <button type="submit" class="btn btn-secondary">   {{trans('admin.Save')}}</button>
                              </div>
                           </div>
                        </div>
                     </div>
                     <!-- datatable start -->
                     <div style="overflow:auto;">
                        <table id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                           <thead class="bg-highlight">
                              <tr>
                                 <th></th>
                                 <th>{{trans('admin.Code')}}</th>
                                 <th>{{trans('admin.Date')}}</th>
                                 <th> {{trans('admin.Delivery')}}</th>
                                 <th> {{trans('admin.Client')}} </th>
                                 <th> {{trans('admin.Client_Phone')}} </th>
                                 <th> {{trans('admin.Total_Price')}} </th>
                                 <th> {{trans('admin.Store')}} </th>
                                 <th>{{trans('admin.Addresses')}}</th>
                                 <th>{{trans('admin.Details')}}</th>
                                 <th>{{trans('admin.Data')}}</th>
                                 <th>{{trans('admin.Actions')}} </th>
                              </tr>
                           </thead>
                           <tbody>
                              @foreach($items as $item)
                              @if($item->Delivery_Status == 1)
                              <tr style="background: #6c92d3; color: black">
                                 @else
                              <tr>
                                 @endif
                                 <td>
                                    @if($item->Delivery_Status == 0)
                                    <input type="checkbox" name="SALES[]" value="{{$item->id}}">
                                    @endif
                                 </td>
                                 <td>{{$item->Code}}</td>
                                 <td>{{$item->Date}}</td>
                                 <td>
                                    @if(!empty($item->Delivery))


                {{app()->getLocale() == 'ar' ?$item->Delivery()->first()->Name :$item->Delivery()->first()->NameEn}}
                                    @endif
                                 </td>
                                 <td>


              {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                 </td>
                                 <td>
                                    @php
                                    $Phone=Customers::where('Account',$item->Client)->first();
                                    @endphp
                                    {{$Phone->Phone}}
                                 </td>
                                 <td>{{$item->Total_Price}}</td>
                                 <td>
                             {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                 </td>
                                 <td>
                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Addresses{{$item->id}}">{{trans('admin.Addresses')}} </button>
                                 </td>
                                 <td>
                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                    {{trans('admin.Details')}}
                                    </button>
                                 </td>
                                 <td>
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                    {{trans('admin.Data')}}
                                    </button>
                                 </td>
                                 <td class="text-center">
                                    <a href="{{url('SalesPrint/'.$item->id)}}" class="btn btn-default" >
                                    <i class="fal fa-print">A4</i>
                                    </a>
                                    <a href="{{url('SalesPrint8/'.$item->id)}}" class="btn btn-default" >
                                    <i class="fal fa-print">8CM</i>
                                    </a>
                                    @if($item->Delivery_Status == 0)
                                    <a href="{{url('RecivedDelivery/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-truck"></i></a>
                                    @endif
                                    @can('تعديل فاتوره مبيعات')
                                    <a href="{{url('ESBill/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-edit"></i></a>
                                    @endcan
                                    @can('حذف فاتوره مبيعات')
                                    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}"><i class="fal fa-trash-alt"></i></button>
                                    @endcan
                                 </td>
                              </tr>
                              @endforeach
                           </tbody>
                           <tfoot>
                              <tr>
                                 <th>{{trans('admin.Code')}}</th>
                                 <th>{{trans('admin.Date')}}</th>
                                 <th> {{trans('admin.Delivery')}}</th>
                                 <th> {{trans('admin.Client')}} </th>
                                 <th> {{trans('admin.Client_Phone')}} </th>
                                 <th> {{trans('admin.Total_Price')}} </th>
                                 <th> {{trans('admin.Store')}} </th>
                                 <th>{{trans('admin.Addresses')}}</th>
                                 <th>{{trans('admin.Details')}}</th>
                                 <th>{{trans('admin.Data')}}</th>
                                 <th>{{trans('admin.Actions')}} </th>
                              </tr>
                           </tfoot>
                        </table>
                        {{$items->Links()}}
                     </div>
                     <!-- datatable end -->
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
</main>
@foreach($items as $item)
<!-- Modal Details -->
<div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
   aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               {{trans('admin.Details')}}
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-body">
            @php
            $details=ProductSales::where('Sales',$item->id)->get();
            @endphp
            <div class="mt-3">
               <div style="overflow:auto">
                  <table id=""
                     class="table table-bordered table-hover table-striped " style="width:100%">
                     <thead>
                        <tr>
                           <th>{{trans('admin.Code')}} </th>
                           <th>{{trans('admin.Name')}} </th>
                           <th>{{trans('admin.Group')}} </th>
                           <th>{{trans('admin.Qty')}} </th>
                           <th>{{trans('admin.Price')}} </th>
                           <th>{{trans('admin.Discount')}} </th>
                           <th>{{trans('admin.Total')}} </th>

                        </tr>
                     </thead>
                     <tbody id="">
                        @foreach($details as $detail)
                        <tr>
                           <td>{{$detail->Product_Code}}</td>

                           <td>
                                                                  {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}

     @if(!empty($detail->V1))   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
                                  @if(!empty($detail->V2))    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  ))  @endif
                           </td>
                           <td>
                                            @if(!empty($detail->Product()->first()->Group))       {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn}}    @endif
                           </td>

                           <td>{{$detail->Qty}}</td>
                           <td>{{$detail->Price}}</td>
                           <td>{{$detail->Discount}}</td>
                           <td>{{$detail->Total}}</td>

                        </tr>
                        @endforeach
                     </tbody>
                     <tfoot>
                        <tr>
                            <th>{{trans('admin.Code')}} </th>
                            <th>{{trans('admin.Name')}} </th>
                            <th>{{trans('admin.Group')}} </th>
                            <th>{{trans('admin.Qty')}} </th>
                            <th>{{trans('admin.Price')}} </th>
                            <th>{{trans('admin.Discount')}} </th>
                            <th>{{trans('admin.Total')}} </th>
                        </tr>
                     </tfoot>
                  </table>
               </div>
               <div style="overflow:auto">
                   <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-striped table-condensed">
                       <tbody>

@php

    $Address=Addressses::find($item->Client_Address);

 @endphp

                           <td class="text-center"> {{trans('admin.Total_Bf_Delivery')}} </td>
                           <td class="text-center"> {{number_format((float)$item->Total_Price, 2, '.', '')}} </td>
                           <td class="text-center"> {{trans('admin.Delivery_Amount')}} </td>


                           <td class="text-center">@if(!empty($Address->Place)){{$Address->Place()->first()->Ship_Price}} @else 0 @endif</td>

                           <td class="text-center"> {{trans('admin.The_Net')}} </td>
                           <td class="text-center">{{number_format((float)$item->Pay, 2, '.', '')}} </td>
                       </tbody>
                   </table>
                   <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-striped table-condensed">
                       <tbody>
                       <td class="text-center"> {{trans('admin.Total_Af_Delivery')}} </td>
                       <td class="text-center"> @if(!empty($Address->Place))  {{$Address->Place()->first()->Ship_Price + $item->Total_Price}} @else {{$item->Total_Price}} @endif</td>
                       <td class="text-center">    {{trans('admin.Total_Pay_With_Delivery')}} </td>
                       <td class="text-center"> @if(!empty($Address->Place)) {{$Address->Place()->first()->Ship_Price + $item->Pay}}@else {{$item->Pay}} @endif </td>

                       </tbody>
                   </table>
               </div>
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- Modal show data -->
<div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog"
   aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               {{trans('admin.Data')}}
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-body">
            <div style="overflow:auto;">
               <table id="" class="table table-bordered table-hover table-striped " style="width:120%;">
                  <thead class="bg-highlight">
                     <tr>
                        <th>{{trans('admin.Store_Code')}}</th>
                        <th> {{trans('admin.Draw')}} </th>
                        <th> {{trans('admin.Payment_Method')}}</th>
                        <th>{{trans('admin.Status')}} </th>
                        <th> {{trans('admin.Executor')}} </th>
                        <th> {{trans('admin.Refernce_Number')}} </th>
                        <th> {{trans('admin.Notes')}} </th>
                        <th> {{trans('admin.Safe')}} </th>
                        <th> {{trans('admin.Delegate')}} </th>
                        <th> {{trans('admin.Later_Due')}} </th>
                        <th> {{trans('admin.Coin')}} </th>
                        <th> {{trans('admin.Cost_Center')}} </th>
                        <th> {{trans('admin.Shipping_Compaines')}} </th>
                        <th> {{trans('admin.User')}} </th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>{{$item->Store_Code}}</td>
                        <td>{{$item->Draw}}</td>
                        <td>
                           @if($item->Payment_Method == 'Cash')
                           {{trans('admin.Cash')}}
                           @elseif($item->Payment_Method == 'Later')
                           {{trans('admin.Later')}}
                           @elseif($item->Payment_Method == 'Delivery')
                           {{trans('admin.Delivery')}}
                           @elseif($item->Payment_Method == 'Cash_Visa')
                           {{trans('admin.Cash_Visa')}}
                           @elseif($item->Payment_Method == 'Cash_Collection')
                           {{trans('admin.Cash_Collection')}}
                           @elseif($item->Payment_Method == 'Check')
                           <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Check{{$item->id}}">{{trans('admin.Check')}} </button>
                           @elseif($item->Payment_Method == 'Installment')
                           <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Installment{{$item->id}}">{{trans('admin.Installment')}} </button>
                           @endif
                        </td>
                        <td>
                           @if($item->Status == 1)
                           {{trans('admin.Recived')}}
                           @elseif($item->Status == 0)
                           {{trans('admin.Pending')}}
                           @endif
                        </td>
                        <td>
                           @if(!empty($item->Executor))
                             {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                           @endif
                        </td>
                        <td>{{$item->Refernce_Number}}</td>
                        <td>{{$item->Note}}</td>
                        <td>
                              {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}
                        </td>
                        <td>
                           @if(!empty($item->Delegate))
                     {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                           @endif
                        </td>
                        <td>
                           {{$item->Later_Due}}
                        </td>
                        <td>

           {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}

                        </td>
                        <td>
                           @if(!empty($item->Cost_Center))

      {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                           @endif
                        </td>
                        <td>
                           @if(!empty($item->Ship))

                  {{app()->getLocale() == 'ar' ?$item->Ship()->first()->Name :$item->Ship()->first()->NameEn}}
                           @endif
                        </td>
                        <td>

               {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
         </div>
      </div>
   </div>
</div>
<!-- Modal Installment -->
<div class="modal fade" id="Installment{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               <div class="row">
                  <div class="col-md-3">
                     <label>{{trans('admin.Presenter')}}</label>
                     <span>{{$item->presenter}}</span>
                  </div>
                  <div class="col-md-3">
                     <label>{{trans('admin.annual_interest')}}</label>
                     <span>{{$item->annual_interest}}</span>
                  </div>
                  <div class="col-md-3">
                     <label>{{trans('admin.monthly_installment')}}</label>
                     <span>{{$item->monthly_installment}}</span>
                  </div>
                  <div class="col-md-3">
                     <label>{{trans('admin.Years_Number')}}</label>
                     <span>{{$item->Years_Number}}</span>
                  </div>
                  <div class="col-md-3">
                     <label>{{trans('admin.total')}}</label>
                     <span>{{$item->total}}</span>
                  </div>
                  <div class="col-md-3">
                     <label>{{trans('admin.installment_Num')}}</label>
                     <span>{{$item->installment_Num}}</span>
                  </div>
                  <div class="col-md-3">
                     <label>{{trans('admin.Date_First_installment')}}</label>
                     <span>{{$item->Date_First_installment}}</span>
                  </div>
               </div>
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
         </div>
      </div>
   </div>
</div>
<!-- Modal Check -->
<div class="modal fade" id="Check{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               <div class="row">
                  <div class="col-md-4">
                     <label>{{trans('admin.Check_Type')}}</label>
                     @if(!empty($item->Check_Type))
                     <span>

         {{app()->getLocale() == 'ar' ?$item->Check_Type()->first()->Arabic_Name :$item->Check_Type()->first()->English_Name}}
                      </span>
                     @endif
                  </div>
                  <div class="col-md-4">
                     <label>{{trans('admin.Due_Date')}}</label>
                     <span>{{$item->Due_Date}}</span>
                  </div>
                  <div class="col-md-4">
                     <label>{{trans('admin.Check_Number')}}</label>
                     <span>{{$item->Check_Number}}</span>
                  </div>
               </div>
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
         </div>
      </div>
   </div>
</div>
<!-- Modal Delete -->
<div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
            <a href="{{url('DeleteSalesBill/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
         </div>
      </div>
   </div>
</div>
<!-- Modal Addresses -->
<div class="modal fade" id="Addresses{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">
               {{trans('admin.Address')}}
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true"><i class="fal fa-times"></i></span>
            </button>
         </div>
         <div class="modal-body">
            <div id="mobile-overflow">
               <table id="" aria-describedby=""class="table table-bordered table-hover table-striped w-100 mobile-width table-color2">
                  <thead>
                     <tr>
                        <th>{{trans('admin.Name')}}</th>
                        <th>{{trans('admin.Governrate')}}</th>
                        <th>{{trans('admin.City')}}</th>
                        <th>{{trans('admin.Place')}}</th>
                        <th>{{trans('admin.Street')}}</th>
                        <th>{{trans('admin.Buliding')}}</th>
                        <th>{{trans('admin.Floor')}}</th>
                        <th>{{trans('admin.Flat')}}</th>
                        <th>{{trans('admin.Special_Mark')}} </th>
                        <th>{{trans('admin.Location')}} </th>
                        <th>{{trans('admin.Address_Details')}} </th>
                     </tr>
                  </thead>
                  <tbody id="data-dt">
                     @php  $cust=Addressses::find($item->Client_Address);   @endphp
                     @if(!empty($cust))
                     <tr>
                        <td>
                           {{$cust->Address_Name}}
                        </td>
                        <td>
                           @if(!empty($cust->Governrate()->first()->Arabic_Name))


                                  {{app()->getLocale() == 'ar' ?$cust->Governrate()->first()->Arabic_Name :$cust->Governrate()->first()->English_Name}}
                            @endif
                        </td>
                        <td>
                           @if(!empty($cust->City()->first()->Arabic_Name))
                                {{app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name}}


                            @endif
                        </td>
                        <td>
                           @if(!empty($cust->Place()->first()->Arabic_Name))
                                {{app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name}}


                            @endif
                        </td>
                        <td>
                           {{$cust->Street}}
                        </td>
                        <td>
                           {{$cust->Buliding}}
                        </td>
                        <td>
                           {{$cust->Floor}}
                        </td>
                        <td>
                           {{$cust->Flat}}
                        </td>
                        <td>
                           {{$cust->Special_Mark}}
                        </td>
                        <td>
                           {{$cust->Location}}
                        </td>
                        <td>
                           {{$cust->Details}}
                        </td>
                     </tr>
                     @endif
                  </tbody>
               </table>
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Cancel')}} </button>
            </div>
         </div>
      </div>
   </div>
</div>
@endforeach
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
   //_fnFeatureHtmlLength();
   $(document).ready(function () {
       // Setup - add a text input to each footer cell
       $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
       $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
           var title = $(this).text();
           $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

           $('input', this).on('keyup change', function () {
               if (table.column(i).search() !== this.value) {
                   table
                       .column(i)
                       .search(this.value)
                       .draw();
               }
           });
       });
       var table = $('#dt-basic-example').DataTable(
           {
               // responsive: true,
               orderCellsTop: true,
               fixedHeader: true,
               lengthChange: true,

               dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                   "<'row'<'col-sm-12'tr>>" +
                   "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

               buttons: [
                   {
                       extend: 'pageLength',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'colvis',
                       text: 'Column Visibility',
                       titleAttr: 'Col visibility',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'pdfHtml5',
                       text: 'PDF',
                       titleAttr: 'Generate PDF',
                       className: 'btn-outline-danger btn-sm mr-1'
                   },
                   {
                       extend: 'excelHtml5',
                       text: 'Excel',
                       titleAttr: 'Generate Excel',
                       className: 'btn-outline-success btn-sm mr-1'
                   },
                   {
                       extend: 'csvHtml5',
                       text: 'CSV',
                       titleAttr: 'Generate CSV',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'copyHtml5',
                       text: 'Copy',
                       titleAttr: 'Copy to clipboard',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'print',
                       text: 'Print',
                       titleAttr: 'Print Table',
                       className: 'btn-outline-primary btn-sm'
                   }
               ],
           });
       $('.js-thead-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
       });

       $('.js-tbody-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
       });

   });

</script>
<!-- Search Selecet -->
<script>
   $(document).ready(function () {
       $(function () {
           $(".select2").select2();

           $(".select2-placeholder-multiple").select2({
               placeholder: "Select State",
           });
           $(".js-hide-search").select2({
               minimumResultsForSearch: 1 / 0,
           });
           $(".js-max-length").select2({
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items",
           });
           $(".select2-placeholder").select2({
               placeholder: "Select a state",
               allowClear: true,
           });

           $(".js-select2-icons").select2({
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function (elm) {
                   return elm;
               },
           });

           function icon(elm) {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
           }

           $("#Emp").select2({
               placeholder: "select...",
               ajax: {
                   type: "GET",
                   dataType: "json",
                   url: "AllEmps",
                   processResults: function (data) {
                       return {
                           results: $.map(data, function (obj, index) {
                               return { id: index, text: obj };
                           }),
                       };

                       console.log(data);
                   },
                 data: function (params) {


                  var query = {
                           search: params.term,
                       };


             $.ajax({
                             url: 'AllEmpsJ/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                         $('#Emp').empty();
                                 $.each(data, function(key, value){

                        $('#Emp').append('<option value="'+ key +'">' + value + '</option>');

                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



       }
               },
           });

           $("#Emp").on("select2:select", function (e) {
               console.log("select done", e.params.data);
           });






       });
   });
</script>
<script>
   var autoSave = $('#autoSave');
   var interval;
   var timer = function()
   {
       interval = setInterval(function()
       {
           //start slide...
           if (autoSave.prop('checked'))
               saveToLocal();

           clearInterval(interval);
       }, 3000);
   };

   //save
   var saveToLocal = function()
   {
       localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
       console.log("saved");
   }

   //delete
   var removeFromLocal = function()
   {
       localStorage.removeItem("summernoteData");
       $('#saveToLocal').summernote('reset');
   }

   $(document).ready(function()
   {
       //init default
       $('.js-summernote').summernote(
       {
           height: 200,
           tabsize: 2,
           placeholder: "Type here...",
           dialogsFade: true,
           toolbar: [
               ['style', ['style']],
               ['font', ['strikethrough', 'superscript', 'subscript']],
               ['font', ['bold', 'italic', 'underline', 'clear']],
               ['fontsize', ['fontsize']],
               ['fontname', ['fontname']],
               ['color', ['color']],
               ['para', ['ul', 'ol', 'paragraph']],
               ['height', ['height']]
               ['table', ['table']],
               ['insert', ['link', 'picture', 'video']],
               ['view', ['fullscreen', 'codeview', 'help']]
           ],
           callbacks:
           {
               //restore from localStorage
               onInit: function(e)
               {
                   $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
               },
               onChange: function(contents, $editable)
               {
                   clearInterval(interval);
                   timer();
               }
           }
       });

       //load emojis
       $.ajax(
       {
           url: 'https://api.github.com/emojis',
           async: false
       }).then(function(data)
       {
           window.emojis = Object.keys(data);
           window.emojiUrls = data;
       });

       //init emoji example
       $(".js-hint2emoji").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: 'type starting with : and any alphabet',
           hint:
           {
               match: /:([\-+\w]+)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(emojis, function(item)
                   {
                       return item.indexOf(keyword) === 0;
                   }));
               },
               template: function(item)
               {
                   var content = emojiUrls[item];
                   return '<img src="' + content + '" width="20" /> :' + item + ':';
               },
               content: function(item)
               {
                   var url = emojiUrls[item];
                   if (url)
                   {
                       return $('<img />').attr('src', url).css('width', 20)[0];
                   }
                   return '';
               }
           }
       });

       //init mentions example
       $(".js-hint2mention").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: "type starting with @",
           hint:
           {
               mentions: ['jayden', 'sam', 'alvin', 'david'],
               match: /\B@(\w*)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(this.mentions, function(item)
                   {
                       return item.indexOf(keyword) == 0;
                   }));
               },
               content: function(item)
               {
                   return '@' + item;
               }
           }
       });

   });

</script>
<script type="text/javascript">
   $(".show-table").click(function(){
       $(".hide-table").show();
   });

</script>
<style>
   @media print {
   body * {
   visibility: hidden;
   }
   .modal-content * {
   visibility: visible;
   overflow: visible;
   }
   .main-page * {
   display: none;
   }
   .modal {
   position: absolute;
   left: 0;
   top: -220px;
   margin: 0;
   padding: 0;
   min-height: 550px;
   visibility: visible;
   overflow: visible !important; /* Remove scrollbar for printing. */
   }
   .modal-dialog {
   visibility: visible !important;
   overflow: visible !important; /* Remove scrollbar for printing. */
   }
   .page-content{
   display:none;
   }
   @page {
   size: a4;
   }
   }
</style>
<!-- Account Balance -->
<script>
   function priiiint() {

                     var countryId = $('#Credit').val();
                     if(countryId) {
                         $.ajax({
                             url: 'AccountBalanceFilter/'+countryId,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                 $.each(data, function(key, value){

                   $('#AccountCredit').text(parseFloat(key).toFixed(2));
                   $('#AccountCredit').text(parseFloat(value).toFixed(2));



                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {

                         $('select[name="state"]').empty();
                     }

   }
</script>
<!-- Collect -->
<script>
   function Collect(){
       var Delivery = $('#DeliveryCollection').val();

         $.ajax({
                             url: 'DeliveryCollectionFilter',
                             type:"GET",
             data:{
               Delivery:Delivery
             },
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {


                   $('#Debitor').val(data.Deb);
                   $('#Account').val(data.Acc);

                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



   }
</script>
<script>
   function SHOWVOUCHER(r){

        var d =$('#D'+r).val();

       if(parseFloat(d) == 1){
           document.getElementById('SS'+r).style.display='block';
       }else{
           document.getElementById('SS'+r).style.display='none';
       }
   }
</script>
@endpush
