@php
use App\Models\ReturnSalesProducts;
use App\Models\CompanyData;
use App\Models\ProductUnits;
use App\Models\Addressses;
use App\Models\DefaultDataShowHide;
$Def=CompanyData::orderBy('id','desc')->first();
$show=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp
<!doctype html>
<html>
   <head>
      <meta charset="utf-8">
      <title>{{trans('admin.Sales')}}</title>
      <meta http-equiv="cache-control" content="max-age=0"/>
      <meta http-equiv="cache-control" content="no-cache"/>
      <meta http-equiv="expires" content="0"/>
      <meta http-equiv="pragma" content="no-cache"/>
      <link rel="stylesheet" media="screen, print" href="{{asset('Admin/styles.css')}}">
      <style type="text/css" media="all">
         body {
         color: #000;
         text-align:right;
         direction:rtl;
         }
         .well{
         background-color:white;
         }
         td ,th{
         background: white!important;
         }
         .table{
         margin-bottom:7px;
         }
         .th-td-width th,.th-td-width td{
         padding:0!important;
         }
         .alert{
         padding-bottom:0;
         margin-bottom:0;
         padding-top:0;
         margin-top:0;
         }
         .alert h1{
         margin:0;
         }
         #wrapper { max-width: 600px; margin: 0 auto; padding-top: 20px; }
         .btn { margin-bottom: 5px; }
         .table { border-radius: 3px; }
         .table th { background: #f5f5f5; }
         .table th, .table td { vertical-align: middle !important; }
         h3 { margin: 5px 0; }
         .table-bordered{
         border: 1px solid #746f6f;
         }
         .table-bordered>thead>tr>th ,.table-bordered>tbody>tr>td {
         border: 1px solid #746f6f;
         }
         .col-lg-6,.col-lg-12, .col-xs-6{
         float:right;
         }
         @media print {
         .no-print { display: none; }
         #buttons { display: none; }
         #wrapper { max-width: 480px; width: 100%; min-width: 250px; margin: 0 auto; }
         }
         .text-right { text-align: left; }
         .text-left { text-align: right; }
         tfoot tr th:first-child { text-align: left; }
      </style>
      <!--English style-->
      <!--<style>-->
      <!--    body{-->
      <!--        direction:ltr;-->
      <!--        text-align:left;-->
      <!--    }-->
      <!--    .col-lg-6,.col-lg-12, .col-xs-6{-->
      <!--        float:left;-->
      <!--    }-->
      <!--</style>-->
   </head>

   <body>


       <div id="wrapper" style="display: none">
                 <div style="text-align:center;" class="alert">
                  <button data-dismiss="alert" class="close" type="button"></button>

                  <h1>{{trans('admin.Return_Sales')}}</h1>

               </div>
            <div class="row">
                     <div style="font-weight: 500;color: black" class="col-lg-3 col-xs-3">
                        {{trans('admin.Code')}}  :- {{$item->Code}}
                     </div>
                     <div style="font-weight: 500;color: black" class="col-lg-4 col-xs-4">
                         {{$item->Date}}
                     </div>
                     <div style="font-weight: 900;color: black" class="col-lg-5 col-xs-5">
                        {{trans('admin.Client')}}  :- {{app()->getLocale() == 'ar' ?$item->Sales()->first()->Client()->first()->Name :$item->Sales()->first()->Client()->first()->NameEn}}
                     </div>
                    <div style="font-weight: 900;color: black" class="col-lg-5 col-xs-5">
                        {{trans('admin.Sales_Bill_Num')}}  :- {{$item->Sales()->first()->Code}}
                     </div>

                  </div>
             <div style="clear:both;margin-top:8px;"></div>
                  <table style="font-size: 12px;"  class="table table-bordered table-striped table-condensed th-td-width">
                     <thead>
                        <tr>
                           <th style="width: 65%;">{{trans('admin.Name')}}</th>
                           <th style="width: 12%; ">{{trans('admin.Return_Qty')}}</th>
                           <th style="width: 12%;">{{trans('admin.Price')}}</th>
                           <th style="width: 14%;">{{trans('admin.Total')}}</th>
                        </tr>
                     </thead>
                     <tbody style="font-weight: bold;">
                        @php
                        $details=ReturnSalesProducts::where('Return',$item->id)->get();
                        @endphp
                        @foreach($details as $detail)
                            @if($detail->Recived_Qty != 0)
                                <tr>
                           <td class="text-center">
                                                                   {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
     @if(!empty($detail->V1))   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
                                  @if(!empty($detail->V2))    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  ))  @endif
                           </td>
                           <td class="text-center">
                              {{$detail->Recived_Qty}}
                           </td>
                           <td class="text-center">
                       {{number_format((float)abs($detail->Price), 2, '.', '')}}
                           </td>
                           <td class="text-center">
                         {{number_format((float)abs($detail->Total), 2, '.', '')}}
                           </td>
                        </tr>
                            @endif
                        @endforeach
                     </tbody>
                  </table>
                  <table  style="border-style: solid;" class="table table-striped table-condensed">
                     <thead>
                        <tr>
                           <th class="text-center" style="width: 35%; border-bottom: 2px solid #ddd;">{{trans('admin.Total_Return_Qty')}}</th>
                           <th class="text-center" style="width: 15%; border-bottom: 2px solid #ddd;">{{$item->Total_Return_Qty}}</th>
                        </tr>
                        <tr>
                           <th class="text-center" style="width: 30%; border-bottom: 2px solid #ddd;">{{trans('admin.Total_BF_Taxes')}}</th>
                           <th class="text-center" style="width: 20%; border-bottom: 2px solid #ddd;">{{$item->Total_BF_Taxes}}</th>
                           <th class="text-center" style="width: 30%; border-bottom: 2px solid #ddd;">{{trans('admin.Total_Taxes')}}</th>
                           <th class="text-center" style="width: 20%; border-bottom: 2px solid #ddd;">{{$item->Total_Taxes}}</th>
                        </tr>
                     </thead>
                  </table>
                  <table style="border-style: double;font-size: 20px;font-weight: bold;"class="table table-striped table-condensed">
                     <tbody>
                        <tr>
                           <td class="text-center"> {{trans('admin.Total_Return_Value')}} </td>
                           <td class="text-center"> {{$item->Total_Return_Value}} </td>
                        </tr>
                     </tbody>
                  </table>
                  <div class="well well-sm"  style="margin:7px 0;">
                     <div style="text-align: center;font-weight: 900;font-size: 20px;">    @if(!empty($Def->Print_Text))
                        {{$Def->Print_Text}}
                        @endif
                     </div>
                  </div>
       </div>

      <div>
         <div id="receiptData" style="width: auto; max-width: 600px; min-width: 250px; margin: 0 auto;overflow: hidden;">
            <div class="no-print" >
               <div style="text-align:center;" class="alert">
                  <button data-dismiss="alert" class="close" type="button"></button>

                  <h1>{{trans('admin.Return_Sales')}}</h1>

               </div>
            </div>
            <div id="receipt-data">
               <div>
                  <div style="text-align:center;margin-bottom:10px;">
                     @if(!empty($Def->Logo))
                     <img style="text-align:center; width:180px; height: 60px;"  src="{{URL::to($Def->Logo)}}" alt="Logo" />
                     @else
                     <img style="text-align:center; width:180px; height: 60px;"  src="{{asset('Admin/img/theme/logo.png')}}" alt="Logo" />
                     @endif
                  </div>
                   <table style="border-style: solid;" class="table table-bordered table-striped table-condensed text-center">
                       <tr>
                           <td style="padding: 0;">{{$Def->Phone1}}</td>
                           <td style="padding: 0;">{{$Def->Phone2}}</td>
                       </tr>
                       <tr>
                           <td style="padding: 0;">{{$Def->Phone3}}</td>
                           <td style="padding: 0;">{{$Def->Phone4}}</td>
                       </tr>
                       </table>
                  <div class="row">
              <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-2 col-xs-3 text-center">
                        <!--{{trans('admin.Code')}}  :- {{$item->Code}}   -->
                       <span style="border: 1px solid black;border-radius: 4px;padding:3px;"> {{$item->Code}} </span>
                     </div>

                     <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-4 col-xs-4">
                         {{$item->Date}}
                     </div>
                     <div style="font-weight: 900;color: black;font-size: 11px;" class="col-lg-6 col-xs-5">
                        {{trans('admin.Client')}}  :- {{app()->getLocale() == 'ar' ?$item->Sales()->first()->Client()->first()->Name :$item->Sales()->first()->Client()->first()->NameEn}}

                     </div>
                           <div style="font-weight: 900;color: black;font-size: 11px;" class="col-lg-6 col-xs-5">
                        {{trans('admin.Sales_Bill_Num')}}  :- {{$item->Sales()->first()->Code}}

                     </div>
                  </div>
                   <div class="row">
              <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-2 col-xs-3 text-center">
                       {{trans('admin.Saler')}}  :-  @if(!empty($item->Sales()->first()->Sale_User))

                  {{app()->getLocale() == 'ar' ?$item->Sales()->first()->Sale_User()->first()->name :$item->Sales()->first()->Sale_User()->first()->nameEn}}

                  @endif

                     </div>

                     <div style="font-weight: 500;color: black;font-size: 11px;" class="col-lg-4 col-xs-4">
                         {{date('h:m')}}
                     </div>
                     <div style="font-weight: 900;color: black;font-size: 11px;" class="col-lg-6 col-xs-5">
                        {{trans('admin.Casher')}}  :- {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                     </div>
                  </div>
                   <div class="row">


                   </div>
                  <div style="clear:both;margin-top:8px;"></div>
                  <table  class="table table-bordered table-striped table-condensed th-td-width">
                     <thead>
                        <tr>
                           <th style="width: 60%;">{{trans('admin.Name')}}</th>
                           <th style="width: 12%; ">{{trans('admin.Return_Qty')}}</th>
                           <th style="width: 14%;">{{trans('admin.Price')}}</th>
                           <th style="width: 14%;">{{trans('admin.Total')}}</th>
                        </tr>
                     </thead>
                     <tbody style="font-weight: bold;">
                        @php
                        $details=ReturnSalesProducts::where('Return',$item->id)->get();
                        @endphp
                        @foreach($details as $detail)
                        <tr>
                           <td class="text-center">
                                                                        {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}

     @if(!empty($detail->V1))   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
                                  @if(!empty($detail->V2))    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  ))  @endif
                           </td>
                           <td class="text-center">
                              {{$detail->Recived_Qty}}
                           </td>
                           <td class="text-center">
                       {{number_format((float)abs($detail->Price + $detail->Total_Tax), 2, '.', '')}}
                           </td>
                           <td class="text-center">
                         {{number_format((float)abs($detail->Total), 2, '.', '')}}
                           </td>
                        </tr>
                        @endforeach
                     </tbody>
                  </table>
                  <table  style="border-style: solid;" class="table table-striped table-condensed">
                     <thead>
                        <tr>
                           <th class="text-center" style="width: 35%; border-bottom: 2px solid #ddd;">{{trans('admin.Total_Return_Qty')}}</th>
                           <th class="text-center" style="width: 15%; border-bottom: 2px solid #ddd;">{{$item->Total_Return_Qty}}</th>
                           <th class="text-center" style="width: 35%; border-bottom: 2px solid #ddd;">{{trans('admin.Total_BF_Taxes')}}</th>
                           <th class="text-center" style="width: 15%; border-bottom: 2px solid #ddd;">
                               {{number_format((float)$item->Total_BF_Taxes, 2, '.', '')}}
                            </th>
                        </tr>
                        <tr>
                           <th class="text-center" style="width: 30%; border-bottom: 2px solid #ddd;">{{trans('admin.Total_Taxes')}}</th>
                           <th class="text-center" style="width: 20%; border-bottom: 2px solid #ddd;">
                        {{number_format((float)$item->Total_Taxes, 2, '.', '')}}
                            </th>
                           <th class="text-center" style="width: 30%; border-bottom: 2px solid #ddd;">{{trans('admin.Total_Return_Value')}}</th>
                           <th class="text-center" style="width: 20%; border-bottom: 2px solid #ddd;">
                               {{number_format((float)$item->Total_Return_Value, 2, '.', '')}}
                           </th>
                        </tr>
                     </thead>
                  </table>


                  <div class="well well-sm"  style="margin:7px 0;">
                     <div style="text-align: center;font-weight: 900;font-size: 12px;">    @if(!empty($Def->Print_Text))
                        {{$Def->Print_Text}}
                        @endif
                     </div>
                  </div>
                  <div >
                     <div style="text-align: center;">
                        @php
                        $x=$item->Code;
                        $y=DNS1D::getBarcodePNG($x, 'C39');
                        @endphp
                        <img src="data:image/png;base64,{{$y}}" id="barcode"  class="height-3 mt-1" />
                     </div>
                  </div>
               </div>
               <div style="clear:both;"></div>
            </div>
            <div class="row" style="display:none">
               @if(!empty($Def->Print_Text_Footer))
               @php echo html_entity_decode($Def->Print_Text_Footer)  @endphp
               @endif
            </div>
            <div class="row" style="display:none">
               @if(!empty($Def->Seal))
               <img src="{{URL::to($Def->Seal)}}" class="img-fluid"  />
               @endif
            </div>
            <!-- start -->
            <div id="buttons" style=" text-transform:uppercase;" class="no-print">
               <hr>
               <div class="btn-group btn-group-justified" role="group" aria-label="...">
                  <div class="btn-group" role="group">
                     <button onclick="window.print();" class="btn btn-block btn-primary">{{trans('admin.Print')}}</button>
                  </div>
                  <div class="btn-group" role="group">
                     <a href="{{ url()->previous() }}" class="btn btn-default" data-dismiss="modal">{{trans('admin.Back')}}</a>
                  </div>
                      <div class="btn-group" role="group" style="display: none">
                         <button type="button" class="btn btn-block btn-danger" onclick="x()" id="generatePDF">PDF</button>
                  </div>
               </div>
               <div style="clear:both;"></div>
            </div>
            <!-- end -->
         </div>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.5.3/jspdf.debug.js" integrity="sha384-NaWTHo/8YCBYJ59830LTz/P4aQZK1sS0SneOgAvhsIl3zBu8r9RevNg5lHCHAuQ/" crossorigin="anonymous"></script>

<script src="https://unpkg.com/jspdf@latest/dist/jspdf.min.js"></script>


              <script>

             function x(){
             var doc = new jsPDF();
var elementhtml = document.querySelector("#wrapper").innerHTML;

var specialElementHandlers = {
    '#editor': function (element, renderer) {
        return true;
    }
};

    doc.fromHTML(
        elementhtml,
            15,
            15,
            {
            'width':170,
            'elementHandlers':specialElementHandlers
        }
               );


    doc.save('Bill.pdf');


             }
          </script>

           <script>


  </script>
            <script>window.print()</script>

                   <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="{{asset('Admin/js/vendors.bundle.js')}}"></script>
        <script src="{{asset('Admin/js/app.bundle.js')}}"></script>
        <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

      <script type="text/javascript">
        function disableBack() { window.history.forward(); }
        setTimeout("disableBack()", 0);
        window.onunload = function () { null };
    </script>

      </div>
      <!-- start -->
      <!-- end -->

   </body>
</html>
