@extends('admin.index')
@section('content')
@php
use App\Models\InstallmentCompaniesRatios;
@endphp
  <title>{{trans('admin.InstallmentCompanies')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Sales')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.InstallmentCompanies')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel second-color">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.InstallmentCompanies')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">


                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>


                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Logo')}}</th>
                                                    <th>{{trans('admin.Account')}} {{trans('admin.Expenses')}}</th>
                                                    <th>{{trans('admin.Account')}} {{trans('admin.Cashing')}} </th>
                                                    <th>{{trans('admin.Ratios')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Arabic_Name}}</td>
                                                    <td>{{$item->English_Name}}</td>
                                                    <td>
                                            <img src="{{URL::to($item->Logo)}}" class="img-fluid" >
                                                    </td>
                                                    <td>

                                                       @if(!empty($item->Account()->first()->Code))
                                                            {{$item->Account()->first()->Code}}

                                                       @endif


                                                    </td>
                                                    <td>
                                                        @if(!empty($item->NakdyaAccount()->first()->Code))
                                                        {{$item->NakdyaAccount()->first()->Code}}
                                                        @endif

                                                    </td>
                                                    <td>

                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Ratios{{$item->id}}">
                                                        {{trans('admin.Ratios')}}
                                                        </button>

                                                    </td>


                                                    <td class="text-center">


                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>



                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                 <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Logo')}}</th>
                                                  <th>{{trans('admin.Account')}} {{trans('admin.Expenses')}}</th>
                                                    <th>{{trans('admin.Account')}} {{trans('admin.Cashing')}} </th>
                                                    <th>{{trans('admin.Ratios')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Add-->
         <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('AddInstallmentCompanies')}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                        <div class="form-row">
                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                            <input type="text" name="Arabic_Name" value="{{old('Arabic_Name')}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                         <input type="text" name="English_Name"  value="{{old('English_Name')}}" class="form-control" >
                                        </div>
                                          <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Logo')}}</label>
                         <input type="file"  name="Logo" >
                                        </div>



                                        </div>

                                                   <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Service_Fee')}} %</th>
                                                                         <th>{{trans('admin.Company_Precent')}} % </th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>
                                                                        <td>
                                                                    <div class="form-group">

                           <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="From" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="To" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

              <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="Service_Fee" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="Company_Precent" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertData()" class="btn btn-default" id="add-data"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Service_Fee')}} %</th>
                                                                         <th>{{trans('admin.Company_Precent')}} % </th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dt">

                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>

                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

         @foreach($items as $item)
        <!-- Modal Edit-->
                    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('EditInstallmentCompanies/'.$item->id)}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                        <input type="hidden" name="Logos" value="{{$item->Logo}}">
                                        <input type="hidden" name="Account" value="{{$item->Account}}">
                                        <div class="form-row">
                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                            <input type="text" name="Arabic_Name" value="{{$item->Arabic_Name}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                          <input type="text" name="English_Name"  value="{{$item->English_Name}}" class="form-control" >
                                        </div>

                                            <div class="form-group col-lg-12">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Logo')}}</label>
                         <input type="file"  name="Logo" >
                                        </div>

                                        </div>
                                              @php
                $details=InstallmentCompaniesRatios::where('Company',$item->id)->get();
                @endphp
                                         <div class="panel-container show">

                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Service_Fee')}} %</th>
                                                                         <th>{{trans('admin.Company_Precent')}} % </th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>
                                                                        <td>
                                                                    <div class="form-group">

                           <input type="number" onkeyup="PLUSEdit({{$item->id}})" onclick="PLUSEdit({{$item->id}})" step="any" id="From{{$item->id}}" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSEdit({{$item->id}})" onclick="PLUSEdit({{$item->id}})" step="any" id="To{{$item->id}}" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

              <input type="number" onkeyup="PLUSEdit({{$item->id}})" onclick="PLUSEdit({{$item->id}})" step="any" id="Service_Fee{{$item->id}}" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

         <input type="number" onkeyup="PLUSEdit({{$item->id}})" onclick="PLUSEdit({{$item->id}})" step="any" id="Company_Precent{{$item->id}}" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertDataEdit({{$item->id}})" class="btn btn-default" id="add-data{{$item->id}}"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Service_Fee')}} %</th>
                                                                         <th>{{trans('admin.Company_Precent')}} % </th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dt{{$item->id}}" class="data-dt">

                                                        @foreach($details as $det)

                                                                        <tr>
                                <td>
                        {{$det->From}}
                                </td>
                            <td>
                          {{$det->To}}
                                </td>

                                <td>
                                {{$det->Service_Fee}}
                               </td>

                                <td>      {{$det->Company_Precent}}
                <input type="hidden" name="From[]" value="{{$det->From}}">
    <input type="hidden" name="To[]" value=" {{$det->To}}">
    <input type="hidden" name="Service_Fee[]" value="  {{$det->Service_Fee}}">
    <input type="hidden" name="Company_Precent[]" value=" {{$det->Company_Precent}}">

                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default Del"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>

                                                                        @endforeach
                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                      <!-- Modal Delete -->
                      <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>
                                         {{app()->getLocale() == 'ar' ?$item->Arabic_Name :$item->English_Name}}

                                        </strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteInstallmentCompanies/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>


                        <!-- Modal Ratios -->
    <div class="modal fade" id="Ratios{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Ratios')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=InstallmentCompaniesRatios::where('Company',$item->id)->get();
                @endphp
                        <div class="mt-3">
                             <div style="overflow:auto">
                            <table id=""
                            class="table table-bordered table-hover table-striped " >
                            <thead>
                                <tr>

                                    <th>{{trans('admin.From')}} </th>
                                     <th>{{trans('admin.To')}} </th>
                                    <th>{{trans('admin.Service_Fee')}} </th>
                                    <th>{{trans('admin.Company_Precent')}} </th>

                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>

                                    <td>{{$detail->From}}</td>
                                    <td>{{$detail->To}}</td>
                                    <td>{{$detail->Service_Fee}}</td>
                                    <td>{{$detail->Company_Precent}}</td>

                                </tr>
                                 @endforeach
                            </tbody>

                        </table>
                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <a class="btn btn-primary" href="#" onclick="window.print()"> <i class="fal fa-print"></i> {{trans('admin.Print')}}</a>
                        </div>
                    </div>
                </div>
            </div>

            </div>

        @endforeach
                </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

<!-- Insert Table Ratio -->
<script>
    function PLUS() {
        var From = $("#From").val();
        var To = $("#To").val();
        var Service_Fee = $("#Service_Fee").val();
        var Company_Precent = $("#Company_Precent").val();


        if (From != "" && To != "" && Service_Fee != "" && Company_Precent != "") {
            document.getElementById("add-data").style.display = "block";
        }


         if (From == "" || To == "" || Service_Fee == "" || Company_Precent == "") {
             document.getElementById("add-data").style.display = "none";
        }




    }
</script>

<script>
    function InsertData() {
        var From = document.getElementById("From").value;
        var To = document.getElementById("To").value;
        var Service_Fee = document.getElementById("Service_Fee").value;
        var Company_Precent = document.getElementById("Company_Precent").value;



        var table = ` <tr>
                                <td>
                            ${From}
                                </td>
                            <td>
                            ${To}
                                </td>

                                <td>
                                ${Service_Fee}
                               </td>

                                <td>${Company_Precent}
                <input type="hidden" name="From[]" value="${From}">
    <input type="hidden" name="To[]" value="${To}">
    <input type="hidden" name="Service_Fee[]" value="${Service_Fee}">
    <input type="hidden" name="Company_Precent[]" value="${Company_Precent}">

                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dt").innerHTML += table;



        $("#data-dt").on("click", "#Del", function (e) {
            $(this).closest("tr").remove();

        });
    }
</script>

<script>
    function PLUSEdit(r) {
        var From = $("#From"+r).val();
        var To = $("#To"+r).val();
        var Service_Fee = $("#Service_Fee"+r).val();
        var Company_Precent = $("#Company_Precent"+r).val();


        if (From != "" && To != "" && Service_Fee != "" && Company_Precent != "") {
            document.getElementById("add-data").style.display = "block";
        }


         if (From == "" || To == "" || Service_Fee == "" || Company_Precent == "") {
             document.getElementById("add-data").style.display = "none";
        }




    }
</script>

<script>
    function InsertDataEdit(r) {
        var From = document.getElementById("From"+r).value;
        var To = document.getElementById("To"+r).value;
        var Service_Fee = document.getElementById("Service_Fee"+r).value;
        var Company_Precent = document.getElementById("Company_Precent"+r).value;



        var table = ` <tr>
                                <td>
                            ${From}
                                </td>
                            <td>
                            ${To}
                                </td>

                                <td>
                                ${Service_Fee}
                               </td>

                                <td>${Company_Precent}
                <input type="hidden" name="From[]" value="${From}">
    <input type="hidden" name="To[]" value="${To}">
    <input type="hidden" name="Service_Fee[]" value="${Service_Fee}">
    <input type="hidden" name="Company_Precent[]" value="${Company_Precent}">

                                 </td>
                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dt"+r).innerHTML += table;



        $("#data-dt"+r).on("click", "#Del", function (e) {
            $(this).closest("tr").remove();

        });
    }

       $(".data-dt").on("click", ".Del", function (e) {
            $(this).closest("tr").remove();

        });

</script>




@endpush

