@extends('admin.index')
@section('content')
@php
use App\Models\SalesDefaultData;
$Def=SalesDefaultData::orderBy('id','desc')->first();
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();
$Style='none';
$credStyle="none";
    use App\Models\CrmDefaultData;
$crm=CrmDefaultData::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.ExecuteJobOrder')}}</title>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
      <li class="breadcrumb-item active">{{trans('admin.ExecuteJobOrder')}} </li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
   </ol>
   <form id="form" action="{{url('PostExecuteJobOrderExe')}}" method="post" enctype="multipart/form-data">
      {!! csrf_field() !!}
      @honeypot


       <input type="hidden" name="Order" value="{{$order->id}}">
      <div class="row">
         <div class="col-lg-12">
            <div id="panel-2" class="panel" style="background: #ccbed59e;">
               <div class="panel-hdr">
                  <h2>
                     <span class="fw-300"><i>   {{trans('admin.ExecuteJobOrder')}}  </i></span>
                  </h2>
               </div>
               <div class="panel-container show">
                  <span id="ex"> @include('admin.layouts.messages')</span>
                  <div class="panel-content">
                     <div class="form-row">
                        <div class="form-group col-lg-4">
                           <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                           <input type="text" value="{{$Code}}" class="form-control " disabled>
                           <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                        </div>
                   @if(auth()->guard('admin')->user()->emp == 0)
                      <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                </div>
                                        @else

                                         @if(auth()->guard('admin')->user()->Date == 1)
                                   <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                </div>
                                        @else
                                 <div class="form-group col-lg-4">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required readonly>
                                </div>
                                        @endif

                                        @endif




                        <div class="form-group col-lg-4">
                           <label class="form-label" for="">{{trans('admin.Store')}}</label>
                           <select class="select2 form-control w-100" id="store" name="Store" required>
                           @foreach($Stores as $stor)
                           <option value="{{$stor->id}}" @if($Def->Store == $stor->id) selected @endif>

                            {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}

                           </option>
                           @endforeach
                           </select>
                        </div>


                                    <div class="form-group col-lg-12">
                            <h2 class="text-center">{{trans('admin.JobOrder')}}</h2>
                         </div>
                        <hr>
                               <div class="form-group col-lg-2">
                           <label class="form-label" for="simpleinput"> ({{trans('admin.Code')}})  </label>
                           <input type="text" value="{{$item->Code}}" class="form-control " readonly>
                        </div>

                                         <div class="form-group col-lg-2">
                           <label class="form-label" for="simpleinput">{{trans('admin.Date')}} </label>
                           <input type="text" value="{{$item->Date}}" class="form-control " readonly>
                        </div>


                                         <div class="form-group col-lg-2">
                           <label class="form-label" for="simpleinput">{{trans('admin.RecivedDate')}} </label>
                           <input type="text" value="{{$item->RecivedDate}}" name="RecivedDate" class="form-control " readonly>
                        </div>


                                                <div class="form-group col-lg-2">
                           <label class="form-label" for="simpleinput">{{trans('admin.Client')}} </label>
                           <input  type="text" value="{{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}" class="form-control " readonly>

                                                                 <input type="hidden" name="Client" value="{{$item->Client}}">
                        </div>


                                                        <div class="form-group col-lg-2">
                           <label class="form-label" for="simpleinput">{{trans('admin.Executor')}} </label>
                                @if(!empty($item->Executor()->first()->Name))
                           <input  type="text" value="{{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}" class="form-control " readonly>
                                            @endif
                        </div>


                               <input type="hidden" name="Executor" value="{{$item->Executor}}">

                                                               <div class="form-group col-lg-2">
                           <label class="form-label" for="simpleinput">{{trans('admin.Recipient')}} </label>
                                @if(!empty($item->Recipient()->first()->Name))
                           <input  type="text" value="{{app()->getLocale() == 'ar' ?$item->Recipient()->first()->Name :$item->Recipient()->first()->NameEn}}" class="form-control " readonly>
                                            @endif
                        </div>
                            <input type="hidden" name="Recipient" value="{{$item->Recipient}}">

                                           <div class="form-group col-lg-12">
                           <label class="form-label"  for="simpleinput">{{trans('admin.Note')}} </label>
                           {{$item->Note}}
                                    <input type="hidden" name="Note" value="{{$item->Note}}">
                        </div>


                           <div class="form-group col-lg-12">

                                   <div style="overflow:auto">
                            <table id=""
                            class="table table-bordered table-hover table-striped " >
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Length')}} </th>
                                    <th>{{trans('admin.Width')}} </th>
                                    <th>{{trans('admin.Height')}} </th>
                                    <th>{{trans('admin.Thickness')}} </th>
                                    <th>{{trans('admin.Size')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>


                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                @if($order->Product == $detail->Product)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>

                                    <td>
                             {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
                                    </td>

                                    <td>{{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}</td>

                                    <td>{{$detail->Length}}</td>
                                    <td>{{$detail->Width}}</td>
                                    <td>{{$detail->Height}}</td>
                                    <td>{{$detail->Thickness}}</td>
                                    <td>{{$detail->Size}}</td>
                                    <td>{{$detail->Qty}}</td>




                                </tr>
                            @endif
                                 @endforeach
                            </tbody>

                        </table>
                        </div>

                         </div>

                     </div>
                     <div class="form-row">

                            <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.ManufacturingModel')}}</label>
                                            <select class="select2 form-control w-100" id="model" name="Model" required>
                                                <option value=""> {{trans('admin.ManufacturingModel')}}</option>
                                            @foreach($Models as $model)
                                                <option value="{{$model->id}}">

                                     {{app()->getLocale() == 'ar' ?$model->Name :$model->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>

            <div class="form-group col-lg-4">
                                    <label class="form-label" for=""> {{trans('admin.Qty')}} </label>
                        <input type="number" step="any" onclick="ChangePrice()" onkeyup="ChangePrice()"  name="Qtyy"  id="Qty" value="{{old('Qty')}}" class="form-control" required>

                                </div>

                                        <div class="form-group col-lg-2" style="display: none">
                                    <label class="form-label" for=""> {{trans('admin.Total_Cost')}} </label>
                        <input type="text"  id="Total" value="{{old('Total')}}" class="form-control" disabled>
                            <input type="hidden"  id="TotalHide">
                            <input type="hidden" name="Totall"  id="OriginalTotalHide">
                                </div>

       <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Name_Outcome')}} </label>
    <input type="text"  name="Name_Outcome"  id="Name_Outcome" value="{{old('Name_Outcome')}}" class="form-control" disabled>
                                </div>
                            <div class="form-group col-lg-1">
                             <button type="button"  class="btn btn-primary" id="Btnsubmit" style="display: none;    margin: 23px;" onclick="AddModel()"> <i class="fal fa-plus"></i> </button>
                         </div>

                             <div class="form-group col-lg-12">
                            <input type="hidden" id="count">
                            <div id="mobile-overflow">
                       <table class="table table-bordered table-hover table-striped th-width mobile-width" >
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Name')}}</th>
                                                    <th> {{trans('admin.Store_Qty')}}</th>

                                                    <th> {{trans('admin.Required_Qty')}}</th>
                                                    <th> {{trans('admin.Store')}}</th>
                                                    <th> {{trans('admin.Unit')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody class="DataCC">

                                            </tbody>
                                        </table>
                                        </div>
                         </div>


                            <div class="form-group col-lg-12">
                              <!-- datatable start -->
                     <div id="mobile-overflow">
                        <table id="dt"
                           class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color2">
                           <thead>
                              <tr>
                                 <th>{{trans('admin.Model')}}</th>
                                 <th>{{trans('admin.Qty')}}</th>
                                 <th>{{trans('admin.Outcome')}}</th>
                                 <th>{{trans('admin.Actions')}}</th>
                              </tr>
                           </thead>
                           <tbody id="data-dt-model">
                           </tbody>
                        </table>
                     </div>
                     <!-- datatable end -->
                         </div>



                     </div>


                  </div>
               </div>
            </div>
         </div>
         <div class="col-xl-12">
            <div id="panel-1" class="panel">
               <div class="panel-container show">
                  <div class="panel-content" style="background: #fad2f796;">
                     <div class="row">

                            <div class="form-group col-lg-12 text-center">
                         {{trans('admin.Workmanship')}}
                         </div>

                              <div class="form-group col-lg-12">
                           <label class="form-label" for="simpleinput">  </label>
                           <div class="input-items" style="position:relative;">
                              <input type="text" id="search" class="form-control" placeholder="{{trans('admin.Search_For_Products')}}">
                                                                 @if(app()->getLocale() == 'ar' )
                     <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                      @else
                            <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                      @endif
                           </div>
                        </div>


                     </div>
                     <div id="mobile-overflow">
                        <table
                           class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color1 mt-2">
                           <thead>
                              <tr>
                                 <th>{{trans('admin.Name')}}</th>
                                 <th>{{trans('admin.Unit')}}</th>
                                 <th>{{trans('admin.Code')}}</th>
                                 <th>{{trans('admin.Qty')}}</th>
                                 <th>{{trans('admin.Actions')}}</th>
                              </tr>
                           </thead>
                           <tbody class="Data" id="Data">
                           </tbody>
                        </table>
                     </div>
                     <!-- datatable start -->
                     <div id="mobile-overflow">
                        <table id="dt"
                           class="table table-bordered table-hover table-striped w-100 mobile-width-more table-color2">
                           <thead>
                              <tr>
                                 <th>{{trans('admin.Name')}}</th>
                                 <th>{{trans('admin.Unit')}}</th>
                                 <th>{{trans('admin.Code')}}</th>
                                 <th>{{trans('admin.Qty')}}</th>
                                 <th>{{trans('admin.Actions')}}</th>
                              </tr>
                           </thead>
                           <tbody id="data-dt">
                           </tbody>
                        </table>
                     </div>
                     <!-- datatable end -->

                 <input type="hidden" id="SubmitX" >

                     <div class="buttons mt-3"  >
                        <input type="hidden" id="sp" name="SP">
                        <button type="button"  class="btn btn-primary" onclick="SPS()"> <i class="fal fa-folder"></i> {{trans('admin.Save')}} </button>
                        @if($show->A4 == 1)
                        <button type="button"  class="btn btn-primary" onclick="SPP()"><i class="fal fa-save"></i>  {{trans('admin.SaveandPrint')}} </button>
                        @endif
                        @if($show->CM8 == 1)
                        <button type="button"  class="btn btn-primary" onclick="SPP8()"><i class="fal fa-save"></i>  {{trans('admin.SaveandPrint8')}} </button>
                        @endif

                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </form>


</main>


@if(app()->getLocale() == 'ar' )
<input type="hidden" id="LANG" value="ar">
@else
<input type="hidden" id="LANG" value="en">
@endif


<input type="hidden" id="LOWCOSTPRICE" value="{{$Def->SalesLowCostPrice}}">

@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<style>
    #HALK  {

        display:none;
    }
    #ACTIONS{

        display:none;
    }

</style>
<script>
   var autoSave = $('#autoSave');
   var interval;
   var timer = function()
   {
       interval = setInterval(function()
       {
           //start slide...
           if (autoSave.prop('checked'))
               saveToLocal();

           clearInterval(interval);
       }, 3000);
   };

   //save
   var saveToLocal = function()
   {
       localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
       console.log("saved");
   }

   //delete
   var removeFromLocal = function()
   {
       localStorage.removeItem("summernoteData");
       $('#saveToLocal').summernote('reset');
   }

   $(document).ready(function()
   {
       //init default
       $('.js-summernote').summernote(
       {
           height: 200,
           tabsize: 2,
           placeholder: "Type here...",
           dialogsFade: true,
           toolbar: [
               ['style', ['style']],
               ['font', ['strikethrough', 'superscript', 'subscript']],
               ['font', ['bold', 'italic', 'underline', 'clear']],
               ['fontsize', ['fontsize']],
               ['fontname', ['fontname']],
               ['color', ['color']],
               ['para', ['ul', 'ol', 'paragraph']],
               ['height', ['height']]
               ['table', ['table']],
               ['insert', ['link', 'picture', 'video']],
               ['view', ['fullscreen', 'codeview', 'help']]
           ],
           callbacks:
           {
               //restore from localStorage
               onInit: function(e)
               {
                   $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
               },
               onChange: function(contents, $editable)
               {
                   clearInterval(interval);
                   timer();
               }
           }
       });

       //load emojis
       $.ajax(
       {
           url: 'https://api.github.com/emojis',
           async: false
       }).then(function(data)
       {
           window.emojis = Object.keys(data);
           window.emojiUrls = data;
       });

       //init emoji example
       $(".js-hint2emoji").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: 'type starting with : and any alphabet',
           hint:
           {
               match: /:([\-+\w]+)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(emojis, function(item)
                   {
                       return item.indexOf(keyword) === 0;
                   }));
               },
               template: function(item)
               {
                   var content = emojiUrls[item];
                   return '<img src="' + content + '" width="20" /> :' + item + ':';
               },
               content: function(item)
               {
                   var url = emojiUrls[item];
                   if (url)
                   {
                       return $('<img />').attr('src', url).css('width', 20)[0];
                   }
                   return '';
               }
           }
       });

       //init mentions example
       $(".js-hint2mention").summernote(
       {
           height: 100,
           toolbar: false,
           placeholder: "type starting with @",
           hint:
           {
               mentions: ['jayden', 'sam', 'alvin', 'david'],
               match: /\B@(\w*)$/,
               search: function(keyword, callback)
               {
                   callback($.grep(this.mentions, function(item)
                   {
                       return item.indexOf(keyword) == 0;
                   }));
               },
               content: function(item)
               {
                   return '@' + item;
               }
           }
       });

   });

</script>

<!-- Search Selecet -->
<script>
   $(document).ready(function () {
       $(function () {
           $(".select2").select2();

           $(".select2-placeholder-multiple").select2({
               placeholder: "Select State",
           });
           $(".js-hide-search").select2({
               minimumResultsForSearch: 1 / 0,
           });
           $(".js-max-length").select2({
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items",
           });
           $(".select2-placeholder").select2({
               placeholder: "Select a state",
               allowClear: true,
           });

           $(".js-select2-icons").select2({
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function (elm) {
                   return elm;
               },
           });

           function icon(elm) {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
           }

           $("#Emp").select2({
               placeholder: "select...",
               ajax: {
                   type: "GET",
                   dataType: "json",
                   url: "AllEmps",
                   processResults: function (data) {
                       return {
                           results: $.map(data, function (obj, index) {
                               return { id: index, text: obj };
                           }),
                       };

                       console.log(data);
                   },
                  data: function (params) {


                  var query = {
                           search: params.term,
                       };


             $.ajax({
                             url: 'AllEmpsJ/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                         $('#Emp').empty();
                                 $.each(data, function(key, value){

                        $('#Emp').append('<option value="'+ key +'">' + value + '</option>');

                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



       }
               },
           });

           $("#Emp").on("select2:select", function (e) {
               console.log("select done", e.params.data);
           });

             $("#client").select2({
               placeholder: "select...",
               ajax: {
                   type: "GET",
                   dataType: "json",
                   url: "AllClientsFilter",
                   processResults: function (data) {
                       return {
                           results: $.map(data, function (obj, index) {

                               return { id: index, text: obj };
                           }),
                       };

                       console.log(data);
                   },
                 data: function (params) {


                  var query = {
                           search: params.term,
                       };


             $.ajax({
                             url: 'AllClientsFilterJS/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                         $('#client').empty();
                                 $.each(data, function(key, value){

                        $('#client').append('<option value="'+ key +'">' + value + '</option>');

                                 });

                               var countryId = $('#client').val();
                     if(countryId) {
                         $.ajax({
                             url: 'AccountBalanceSOFilter/'+countryId,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                 $.each(data, function(key, value){


                   $('#AccountCredit').val(key);
                   $('#AccountCredit').val(value);
                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });
                     } else {

                         $('select[name="state"]').empty();
                     }



                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



       }
               },
           });

           $("#client").on("select2:select", function (e) {
               console.log("select done", e.params.data);
           });


                         $('#AccountCodeF').select2({
   placeholder: "select...",
   ajax: {
       type: "GET",
       dataType: 'json',
       url: 'AllClientsFilter',
       processResults: function (data) {
         return {
           results: $.map(data, function(obj, index) {
             return { id: index, text: obj };
           })
         };

           	console.log(data);

       },
        data: function (params) {


                  var query = {
                           search: params.term,
                       };


             $.ajax({
                             url: 'AllClientsFilterJS/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                         $('#AccountCodeF').empty();
                                 $.each(data, function(key, value){

                        $('#AccountCodeF').append('<option value="'+ key +'">' + value + '</option>');

                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



       }
   }
   });


   $('#AccountCodeF').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });




                         $('#AccountCodee').select2({
   placeholder: "select...",
   ajax: {
       type: "GET",
       dataType: 'json',
       url: 'AllClientsFilter',
       processResults: function (data) {
         return {
           results: $.map(data, function(obj, index) {
             return { id: index, text: obj };
           })
         };

           	console.log(data);

       },
        data: function (params) {


                  var query = {
                           search: params.term,
                       };


             $.ajax({
                             url: 'AllClientsFilterJS/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                         $('#AccountCodee').empty();
                                 $.each(data, function(key, value){

                        $('#AccountCodee').append('<option value="'+ key +'">' + value + '</option>');

                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



       }
   }
   });


   $('#AccountCodee').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });

           $(".EmpDele").select2({
               placeholder: "select...",
               ajax: {
                   type: "GET",
                   dataType: "json",
                   url: "AllEmps",
                   processResults: function (data) {
                       return {
                           results: $.map(data, function (obj, index) {
                               return { id: index, text: obj };
                           }),
                       };

                       console.log(data);
                   },
                  data: function (params) {


                  var query = {
                           search: params.term,
                       };


             $.ajax({
                             url: 'AllEmpsJ/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                         $('.EmpDele').empty();
                                 $.each(data, function(key, value){

                        $('.EmpDele').append('<option value="'+ key +'">' + value + '</option>');

                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



       }
               },
           });

           $(".EmpDele").on("select2:select", function (e) {
               console.log("select done", e.params.data);
           });






       });
   });
</script>


<!--  Filter Products -->
<script>
   $(document).ready(function(){

    fetch_customer_data();

    function fetch_customer_data(search = '',store='')
    {
     $.ajax({
      url:'ExecuteJobOrderFilter',
      method:'GET',
      data:{search:search,store:store},
      dataType:'json',
      success:function(data)
      {


       $('.Data').html(data.table_data);
               $("#Data").show();

      }
     })
    }

   $(document).on('keyup', '#search', function(event){
     var search = $(this).val();
     var store = $('#store').val();

   fetch_customer_data(search,store);



    });



   });
</script>

<!-- Add Products -->
<script>
   function Fun(r) {

             var P_Ar_Name = $("#P_Ar_Name"+r).val();
             var P_En_Name= $("#P_En_Name"+r).val();
             var Product = $("#Product"+r).val();
             var UnitID = $("#UnitPurch"+r).val();
             var UnitName = $("#UnitPurchName"+r).val();
             var Qty = $("#Qty"+r).val();
             var AvQty = $("#AvQty"+r).val();
             var Barcode = $("#CodePurch"+r).val();
             var Price = $("#Price"+r).val();
             var Total = $("#Total"+r).val();
             var ExpDate = $("#ExpDate"+r).val();
             var PurchTax = $("#PurchTax"+r).val();
             var TotalTax = $("#Tax"+r).val();
             var Discount = $("#Discount"+r).val();
             var TDiscPro = $("#TDiscPro"+r).val();
             var TotalBFTax = $("#TotalBFTax"+r).val();
             var StorePurch = $("#StorePurch"+r).val();
             var StorePurchName = $("#StorePurchName"+r).val();
             var PurchTax = $("#PurchTax"+r).val();
             var VOne = $("#VOne"+r).val();
             var VTwo = $("#VTwo"+r).val();
             var V_Name = $("#V_Name"+r).val();
             var VV_Name = $("#VV_Name"+r).val();
            var TaxRate = $("#TaxRate"+r).val();
             var TaxType = $("#TaxType"+r).val();
             var PatchNum = $("#PatchNum"+r).val();
                var HighDisc = $("#HighDisc"+r).val();
                var CostPrice = $("#CostPrice"+r).val();
                var Length = $("#Length"+r).val();
                var Width = $("#Width"+r).val();
                var Height = $("#Height"+r).val();
                var Thickness = $("#Thickness"+r).val();
                var Size = $("#Size"+r).val();
             var Viro = '';
             var VViro = '';
         var serial =$("#serial"+r).val();
       if( V_Name != ''){

          Viro= '(' + V_Name +')';
       }

       if( VV_Name != ''){

         VViro= '(' + VV_Name +')';
       }

          var PO='';
          var DO='';
        var PRICEOPEN = $("#PRICEOPEN").val();
        var DISCOPEN = $("#DISCOPEN").val();


            PO="<input type='hidden' name='Price[]'  value='"+Price+"'>";



    DO="<input type='hidden' name='Discount[]'  value='"+Discount+"'>";


            var Exp='';
        var ED = $("#ED").val();

        var DIS = $("#DIS").val();

         if(ED == 1){

         Exp = "<td><input type='hidden' name='Exp_Date[]' value='"+ExpDate+"'>" + ExpDate + "</td>";

       }else{

           Exp = "<input type='hidden' name='Exp_Date[]' value='"+ExpDate+"'>";
       }


        var Patch = $("#Patch").val();
       if(parseFloat(Patch) == 1){

   var pn="<td><input type='hidden' step='any' class='form-control' name='Patch_Number[]' value="+PatchNum+">"+PatchNum+"</td>";
       }else{
           var pn="<input type='hidden'  name='Patch_Number[]' value="+PatchNum+">";

       }

             document.getElementById("AddBtnPur"+r).style.display = "none";
             document.getElementById("Row"+r).style.display = "none";
                    $("#Data").hide();

       var RFF= parseFloat(Qty) * parseFloat(Price);
       var RFFResult= parseFloat(RFF) - parseFloat(Total);

            var DISCSHOW = $("#DISCSHOW").val();
        var TOTBFSHOW = $("#TOTBFSHOW").val();
        var TAXSHOW = $("#TAXSHOW").val();
        var STORESHOW = $("#STORESHOW").val();
        var AVQTYSHOW = $("#AVQTYSHOW").val();


           if(AVQTYSHOW == 1){

       var  AVQTYSHOWW = "";

       }else{

             var  AVQTYSHOWW = "none";
       }

        if(DISCSHOW == 1){

       var  DISCSHOWW = "";

       }else{

             var  DISCSHOWW = "none";
       }


          if(TOTBFSHOW == 1){

        var TOTBFSHOWW = "";

       }else{

            var TOTBFSHOWW  = "none";
       }



          if(TAXSHOW == 1){

      var   TAXSHOWW = "";

       }else{

            var   TAXSHOWW = "none";
       }



          if(STORESHOW == 1){

        var STORESHOWW = "";

       }else{

             var STORESHOWW  = "none";
       }

               var LANG = $("#LANG").val();
   if(LANG == 'ar' ){
          var Nemo = P_Ar_Name ;
          }else{
             var Nemo = P_En_Name ;
          }



             var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='"+P_Ar_Name+"'><input type='hidden' name='P_En_Name[]' value='"+P_En_Name+"'>" + Nemo + "</td><td><input type='hidden' name='Unit[]' value='"+UnitID+"'>" + UnitName + "</td><td><input type='hidden' id='BAR"+r+"' name='P_Code[]' value='"+Barcode+"'>" + Barcode + "</td><td><input class='Qun form-control' id='QuntD"+r+"' type='number' step='any' name='Qty[]' value='"+Qty+"' onkeyup='TotD("+r+")' onclick='TotD("+r+")' ></td><td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input id='PRO"+r+"' type='hidden' name='Product[]' value='"+Product+"'><input type='hidden' name='VOne[]' value='"+VOne+"'><input type='hidden' name='VTwo[]' value='"+VTwo+"'></td><input type='hidden' name='V_Name[]' value='"+Viro+"'><input type='hidden' name='VV_Name[]' value='"+VViro+"'><input type='hidden' name='PurchTax[]' value='"+PurchTax+"'><input id='TaxRateD"+r+"' type='hidden'  value='"+TaxRate+"'><input type='hidden' id='TaxTypeD"+r+"'  value='"+TaxType+"'><input type='hidden' id='HighDiscD"+r+"'  value='"+HighDisc+"'><input type='hidden' id='Enough"+r+"' name='AllEnough[]' class='ENO'  value='0'><input type='hidden' class='DiscoPrecent' id='disssccoount"+r+"' value='"+RFFResult+"'><input type='hidden' class='TDISCOOO' id='TDiscProEdit"+r+"' name='TDiscPro[]' value='"+TDiscPro+"'><input type='hidden' id='AvQuntD"+r+"' name='AvQty[]' value='"+AvQty+"'><input type='hidden' id='costPric"+r+"' class='COSTPRICES'  name='CostPrice[]' value='"+CostPrice+"'><input type='hidden'  id='TotBFTaxDHide"+r+"' name='TotalBFTax[]'  value='"+TotalBFTax+"'><input type='hidden' name='Exp_Date[]' value='"+ExpDate+"'><input type='hidden'  name='Patch_Number[]' value="+PatchNum+"><input  type='hidden' name='StorePurch[]' value='"+StorePurch+"'>"+PO+""+DO+"<input type='hidden' id='TaxDHide"+r+"' name='TotalTax[]'  value='"+TotalTax+"'><input type='hidden' id='TotDHide"+r+"' name='Total[]'  value='"+Total+"'></tr>";






           var P = $("#PRO"+r).val();
           var Bar = $("#BAR"+r).val();
             if(Product != P &&  Barcode != Bar){
                  $("#data-dt").append(markup);
             }

      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });

               var prec = 0;
   $('.DiscoPrecent').each(function(){
   prec += parseFloat($(this).val());
   });

          var sumTTD = 0;
   $('.TDISCOOO').each(function(){
   sumTTD += parseFloat($(this).val());
   });


                 var COPRI = 0;
   $('.COSTPRICES').each(function(){
   COPRI += parseFloat($(this).val());
   });


       $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

       var TootPriice=parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax);
     $('#Total_Price').val(parseFloat(TootPriice).toFixed(2));
   $('#Total_PriceHide').val(parseFloat(TootPriice).toFixed(2));

   $('#Total_PriceW').val(parseFloat(sumT).toFixed(2));

       var PROFIIIT=parseFloat(sumT) - parseFloat(COPRI);
   $('#ProfitPrecent').val(parseFloat(PROFIIIT).toFixed(2));

       var nfd=((parseFloat(sumT) - parseFloat(COPRI)) * 100) / parseFloat(COPRI);
   $('#proPrecent').text(parseFloat(nfd).toFixed(2));
       $('#Total_Bill').val(parseFloat(sumT).toFixed(2));

           $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

       $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));


       var BEFO=parseFloat(sumBF)+parseFloat(sumTTD);

          $('#Total_Bf_Taxes').val(parseFloat(BEFO).toFixed(2));
   $('#Total_Bf_TaxesHide').val(parseFloat(BEFO).toFixed(2));

          $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));
   $('#TotalCost').val(parseFloat(COPRI).toFixed(2));

       if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }

        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

      if(Pay == 'Later' &&  Stat == 0 ){

             if(paid == 0 || paid < 0){
        document.getElementById("SubmitX").style.display = "none";
             }else{

           if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }



             }

       }else{

       if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }
       }




        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        var resdiual =$('#resdiual').val();
        var total =$('#Total_PriceHide').val();
        var totalDisc =$('#Total_DiscountHideTT').val();

          var totalTax =$('#Total_TaxesHide').val();


         var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterD').val(parseFloat(RRR).toFixed(2));
         $('#paid').val(parseFloat(RR).toFixed(2));

         $('#presenter').val(parseFloat(RR).toFixed(2));
         $('#total').val(parseFloat(sumT).toFixed(2));




               var Pay =$('#Payment_Method').val();
      if(Pay == 'Later'){


                   $('#paid').val('');

       }


        $('#data-dt').on('click', '#DelAssem', function(e){
                $(this).closest('tr').remove();


      $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });

                           var prec = 0;
   $('.DiscoPrecent').each(function(){
   prec += parseFloat($(this).val());
   });

                      var sumTTD = 0;
   $('.TDISCOOO').each(function(){
   sumTTD += parseFloat($(this).val());
   });
                    var COPRI = 0;
   $('.COSTPRICES').each(function(){
   COPRI += parseFloat($(this).val());
   });
    $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

       var TootPriice=parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax);
     $('#Total_Price').val(parseFloat(TootPriice).toFixed(2));
   $('#Total_PriceHide').val(parseFloat(TootPriice).toFixed(2));

   $('#Total_PriceW').val(parseFloat(sumT).toFixed(2));

       var PROFIIIT=parseFloat(sumT) - parseFloat(COPRI);
   $('#ProfitPrecent').val(parseFloat(PROFIIIT).toFixed(2));

       var nfd=((parseFloat(sumT) - parseFloat(COPRI)) * 100) / parseFloat(COPRI);
   $('#proPrecent').text(parseFloat(nfd).toFixed(2));
       $('#Total_Bill').val(parseFloat(sumT).toFixed(2));

           $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

       $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));


       var BEFO=parseFloat(sumBF)+parseFloat(sumTTD);

          $('#Total_Bf_Taxes').val(parseFloat(BEFO).toFixed(2));
   $('#Total_Bf_TaxesHide').val(parseFloat(BEFO).toFixed(2));

          $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));
   $('#TotalCost').val(parseFloat(COPRI).toFixed(2));



                  var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        var resdiual =$('#resdiual').val();
        var total =$('#Total_PriceHide').val();
        var totalDisc =$('#Total_DiscountHideTT').val();

          var totalTax =$('#Total_TaxesHide').val();


         var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterD').val(parseFloat(RRR).toFixed(2));
         $('#paid').val(parseFloat(RR).toFixed(2));

             $('#presenter').val(parseFloat(RR).toFixed(2));
         $('#total').val(parseFloat(sumT).toFixed(2));


       if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }

                  var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

      if(Pay == 'Later' &&  Stat == 0 ){

             if(paid == 0 || paid < 0){
        document.getElementById("SubmitX").style.display = "none";
             }else{

           if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }



             }

       }else{

       if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }
       }



               var Pay =$('#Payment_Method').val();
      if(Pay == 'Later'){


                   $('#paid').val('');

       }

                 var EN = 0;
 $('.ENO').each(function(){
   EN += parseFloat($(this).val());
   });

                        var Total_PriceW =$('#Total_PriceW').val();

             if(EN == 0){

             if(Total_PriceW == 'NaN'){
                   document.getElementById("SubmitX").style.display = "none";
                    }else{
        document.getElementById("SubmitX").style.display = "block";
             }

       }else{

        document.getElementById("SubmitX").style.display = "none";
       }

                    })


     }
</script>

<!-- Total Products -->
<script>
   function PurchTotalL(r) {
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var HighDisc = $("#HighDisc"+r).val();
   var CostPrice = $("#CostPrice"+r).val();
   var LOWCOSTPRICE = $("#LOWCOSTPRICE").val();
         var Length = $("#Length"+r).val();
                var Width = $("#Width"+r).val();
    var Size = $("#Size"+r).val();
   var i = 0;
   var ii=0;
   var iii=0;


       var NewResult =parseFloat(Length) * parseFloat(Width);

       $("#Size"+r).val(parseFloat(NewResult));
$("#Qty"+r).val(parseFloat(NewResult));


Qty = NewResult;

     var x=  @php echo $Def->Mainus; @endphp ;

          var DIS = $("#DIS").val();

       if(parseFloat(DIS) == 0){

           Discount=$("#Discount"+r).val();
       }else{

           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;

        Discount=  dd;
       }

                  var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscPro"+r).val(parseFloat(BFG));


       if(TaxType == 1){
           //Precent

        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );

       $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#Tax"+r).val(parseFloat(ii).toFixed(2));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#Total"+r).val(parseFloat(iii).toFixed(2));

       }else if(TaxType == 2){
          //Number
          var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );
         $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));

            i =    parseFloat(TaxRate)   ;

           $("#Tax"+r).val(parseFloat(i).toFixed(2));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#Total"+r).val(parseFloat(iii).toFixed(2));


       }


        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();

       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

        document.getElementById("AddBtnPur"+r).style.display = "none";
     }


       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

                if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";

           }else{


             if(parseFloat(LOWCOSTPRICE) == 0){

                            if(parseFloat(Price) < parseFloat(CostPrice)){

        document.getElementById("AddBtnPur"+r).style.display = "none";

                         }else{
                document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                         }




                  }else{
                   document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                  }

           }

     }

      // x de elly hya lw byshtghl bsalb
    if(x == 0){

       if(parseFloat(AvQty) != 0){


        if(parseFloat(AvQty) >= parseFloat(Qty)){

            if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";

           }else{


               if(parseFloat(LOWCOSTPRICE) == 0){

                            if(parseFloat(Price) < parseFloat(CostPrice)){

        document.getElementById("AddBtnPur"+r).style.display = "none";

                         }else{
                document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                         }




                  }else{
                   document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                  }


           }

        }else{

   document.getElementById("AddBtnPur"+r).style.display = "none";

        }


           }else{

      document.getElementById("AddBtnPur"+r).style.display = "none";
           }


    }else{

       document.getElementById("AddBtnPur"+r).style.display = "inline-block";

    }


       if(HighDisc != 0){


           if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                     document.getElementById("AddBtnPur"+r).style.display = "none";
           }else{
                          if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";

           }else{
               if(parseFloat(LOWCOSTPRICE) == 0){

                            if(parseFloat(Price) < parseFloat(CostPrice)){

        document.getElementById("AddBtnPur"+r).style.display = "none";

                         }else{
                document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                         }




                  }else{
                   document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                  }
           }

           }


       }



   }

       function PurchTotal(r) {
   var TaxRate = $("#TaxRate"+r).val();
   var TaxType = $("#TaxType"+r).val();
   var Qty = $("#Qty"+r).val();
   var AvQty = $("#AvQty"+r).val();
   var Price = $("#Price"+r).val();
   var Discount = $("#Discount"+r).val();
   var HighDisc = $("#HighDisc"+r).val();
   var CostPrice = $("#CostPrice"+r).val();
   var LOWCOSTPRICE = $("#LOWCOSTPRICE").val();
   var i = 0;
   var ii=0;
   var iii=0;
     var x=  @php echo $Def->Mainus; @endphp ;

          var DIS = $("#DIS").val();

       if(parseFloat(DIS) == 0){

           Discount=$("#Discount"+r).val();
       }else{

           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;

        Discount=  dd;
       }

                  var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscPro"+r).val(parseFloat(BFG));


       if(TaxType == 1){
           //Precent

        var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );

       $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#Tax"+r).val(parseFloat(ii).toFixed(2));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#Total"+r).val(parseFloat(iii).toFixed(2));

       }else if(TaxType == 2){
          //Number
          var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );
         $("#TotalBFTax"+r).val(parseFloat(BF).toFixed(2));

            i =    parseFloat(TaxRate)   ;

           $("#Tax"+r).val(parseFloat(i).toFixed(2));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#Total"+r).val(parseFloat(iii).toFixed(2));


       }


        var Total = $("#Total"+r).val();
        var TotalBFTax = $("#TotalBFTax"+r).val();
        var Tax = $("#Tax"+r).val();
        var UnitID = $("#UnitPurch"+r).val();
        var StorePurch = $("#StorePurch"+r).val();

       if(TaxRate == ''  || TaxType == ''  ||  Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == ''){

        document.getElementById("AddBtnPur"+r).style.display = "none";
     }


       if(TaxRate != ''  && TaxType != ''  &&  Qty != ''  && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != ''){

                if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";

           }else{


             if(parseFloat(LOWCOSTPRICE) == 0){

                            if(parseFloat(Price) < parseFloat(CostPrice)){

        document.getElementById("AddBtnPur"+r).style.display = "none";

                         }else{
                document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                         }




                  }else{
                   document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                  }

           }

     }

      // x de elly hya lw byshtghl bsalb
    if(x == 0){

       if(parseFloat(AvQty) != 0){


        if(parseFloat(AvQty) >= parseFloat(Qty)){

            if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";

           }else{


               if(parseFloat(LOWCOSTPRICE) == 0){

                            if(parseFloat(Price) < parseFloat(CostPrice)){

        document.getElementById("AddBtnPur"+r).style.display = "none";

                         }else{
                document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                         }




                  }else{
                   document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                  }


           }

        }else{

   document.getElementById("AddBtnPur"+r).style.display = "none";

        }


           }else{

      document.getElementById("AddBtnPur"+r).style.display = "none";
           }


    }else{

       document.getElementById("AddBtnPur"+r).style.display = "inline-block";

    }


       if(HighDisc != 0){


           if(parseFloat(Discount)  >  parseFloat(HighDisc)){
                     document.getElementById("AddBtnPur"+r).style.display = "none";
           }else{
                          if(Qty < 0 || Price < 0 || Discount < 0 || Total < 0){
               document.getElementById("AddBtnPur"+r).style.display = "none";

           }else{
               if(parseFloat(LOWCOSTPRICE) == 0){

                            if(parseFloat(Price) < parseFloat(CostPrice)){

        document.getElementById("AddBtnPur"+r).style.display = "none";

                         }else{
                document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                         }




                  }else{
                   document.getElementById("AddBtnPur"+r).style.display = "inline-block";
                  }
           }

           }


       }



   }


     function TotD(r) {
   var TaxRate = $("#TaxRateD"+r).val();
   var TaxType = $("#TaxTypeD"+r).val();
   var Qty = $("#QuntD"+r).val();
   var AvQty = $("#AvQuntD"+r).val();
   var Price = $("#PriD"+r).val();
   var Discount = $("#DiscD"+r).val();
    var HighDisc = $("#HighDiscD"+r).val();
    var CostPrice = $("#costPric"+r).val();
       var EN = 0;
   var i = 0;
   var ii=0;
   var iii=0;


 var LOWCOSTPRICE = $("#LOWCOSTPRICE").val();
     var x=  @php echo $Def->Mainus; @endphp ;

                 var DIS = $("#DIS").val();

       if(parseFloat(DIS) == 0){

           Discount=$("#DiscD"+r).val();
       }else{

           var d= Discount / 100 ;
           var Multi= parseFloat(Qty) * parseFloat(Price) ;
          var dd= Multi * d;

        Discount=  dd;
       }
                     var BFG =  parseFloat(Qty) * parseFloat(Discount) ;
             $("#TDiscProEdit"+r).val(parseFloat(BFG));
       if(TaxType == 1){
           //Precent

    var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );

       $("#TotBFTaxD"+r).val(parseFloat(BF).toFixed(2));
       $("#TotBFTaxDHide"+r).val(parseFloat(BF).toFixed(2));

       i =    parseFloat(TaxRate)  / 100 ;

        ii=  parseFloat(BF) * parseFloat(i) ;

           $("#TaxD"+r).val(parseFloat(ii).toFixed(2));
           $("#TaxDHide"+r).val(parseFloat(ii).toFixed(2));

       iii =  parseFloat(BF) + parseFloat(ii) ;

           $("#TotD"+r).val(parseFloat(iii).toFixed(2));
           $("#TotDHide"+r).val(parseFloat(iii).toFixed(2));

       }else if(TaxType == 2){
          //Number
           var BF =  parseFloat(Qty) *  (parseFloat(Price)  -  parseFloat(Discount) );
         $("#TotBFTaxD"+r).val(parseFloat(BF));
         $("#TotBFTaxDHide"+r).val(parseFloat(BF));

            i =    parseFloat(TaxRate)   ;

           $("#TaxD"+r).val(parseFloat(i));
           $("#TaxDHide"+r).val(parseFloat(i));

       iii =  parseFloat(BF) + parseFloat(i) ;

           $("#TotD"+r).val(parseFloat(iii));
           $("#TotDHide"+r).val(parseFloat(iii));


       }


         if(parseFloat(Qty) > parseFloat(AvQty)){


         document.getElementById("QuntD"+r).style.border="1px solid darkred";
             $("#Enough"+r).val(1);


         }else{

               if(parseFloat(Qty) < 0 || parseFloat(Price) < 0 || parseFloat(Discount) < 0)
           {
               document.getElementById("QuntD"+r).style.border="1px solid darkred";
             $("#Enough"+r).val(1);

              }else{


                  if(parseFloat(LOWCOSTPRICE) == 0){


                      if(parseFloat(Price) < parseFloat(CostPrice)){

                             document.getElementById("QuntD"+r).style.border="1px solid darkred";
             $("#Enough"+r).val(1);

                         }else{
                                document.getElementById("QuntD"+r).style.border="none";
             $("#Enough"+r).val(0);
                         }


                     }else{


                       document.getElementById("QuntD"+r).style.border="none";
             $("#Enough"+r).val(0);
                     }



                        }

         }





       var Total = $("#TotD"+r).val();
       var RFF= parseFloat(Qty) * parseFloat(Price);
       var RFFResult= parseFloat(RFF) - parseFloat(Total);
         $("#disssccoount"+r).val(parseFloat(RFFResult).toFixed(2));

       $.fn.rowCount = function() {
     return $('tr', $(this).find('tbody')).length;
   };

   var rowctr = $('#dt').rowCount();

    var sumQ = 0;
   $('.Qun').each(function(){
   sumQ += parseFloat($(this).val());
   });

    var sumT = 0;
   $('.Tot').each(function(){
   sumT += parseFloat($(this).val());
   });

        var sumD = 0;
   $('.Disc').each(function(){
   sumD += parseFloat($(this).val());
   });


           var sumBF = 0;
   $('.TotalBFTax').each(function(){
   sumBF += parseFloat($(this).val());
   });

           var sumTax = 0;
   $('.TotalTax').each(function(){
   sumTax += parseFloat($(this).val());
   });

               var prec = 0;
   $('.DiscoPrecent').each(function(){
   prec += parseFloat($(this).val());
   });

          var sumTTD = 0;
   $('.TDISCOOO').each(function(){
   sumTTD += parseFloat($(this).val());
   });

                          var COPRI = 0;
   $('.COSTPRICES').each(function(){
   COPRI += parseFloat($(this).val());
   });



    $('#Product_Numbers').val(parseFloat(rowctr));
   $('#Product_NumbersHide').val(parseFloat(rowctr));

   $('#Total_Qty').val(parseFloat(sumQ));
   $('#Total_QtyHide').val(parseFloat(sumQ));

       var TootPriice=parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax);
     $('#Total_Price').val(parseFloat(TootPriice).toFixed(2));
   $('#Total_PriceHide').val(parseFloat(TootPriice).toFixed(2));

   $('#Total_PriceW').val(parseFloat(sumT).toFixed(2));

       var PROFIIIT=parseFloat(sumT) - parseFloat(COPRI);
   $('#ProfitPrecent').val(parseFloat(PROFIIIT).toFixed(2));

       var nfd=((parseFloat(sumT) - parseFloat(COPRI)) * 100) / parseFloat(COPRI);
   $('#proPrecent').text(parseFloat(nfd).toFixed(2));
       $('#Total_Bill').val(parseFloat(sumT).toFixed(2));

           $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
   $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

       $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
   $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));


       var BEFO=parseFloat(sumBF)+parseFloat(sumTTD);

          $('#Total_Bf_Taxes').val(parseFloat(BEFO).toFixed(2));
   $('#Total_Bf_TaxesHide').val(parseFloat(BEFO).toFixed(2));

          $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
   $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));
   $('#TotalCost').val(parseFloat(COPRI).toFixed(2));


       if(rowctr == 0){
        document.getElementById("Submit").style.display = "none";

       }else{

        document.getElementById("Submit").style.display = "block";
       }

        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

      if(Pay == 'Later' &&  Stat == 0 ){

             if(paid == 0 || paid < 0){
        document.getElementById("SubmitX").style.display = "none";
             }else{

           if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }



             }

       }else{

       if(rowctr == 0){
        document.getElementById("SubmitX").style.display = "none";

       }else{

        document.getElementById("SubmitX").style.display = "block";
       }
       }


           var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        var resdiual =$('#resdiual').val();
        var total =$('#Total_PriceHide').val();
        var totalDisc =$('#Total_DiscountHideTT').val();
          var totalTax =$('#Total_TaxesHide').val();


         var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
             var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
          $('#TAFterD').val(parseFloat(RRR).toFixed(2));
         $('#paid').val(parseFloat(RR).toFixed(2));

          $('#presenter').val(parseFloat(RR).toFixed(2));
         $('#total').val(parseFloat(sumT).toFixed(2));
               var Pay =$('#Payment_Method').val();

      if(Pay == 'Later'){


                   $('#paid').val('');

       }


   $('.ENO').each(function(){
   EN += parseFloat($(this).val());
   });

                        var Total_PriceW =$('#Total_PriceW').val();

             if(EN == 0){

             if(Total_PriceW == 'NaN'){
                   document.getElementById("Submit").style.display = "none";
                    }else{
        document.getElementById("SubmitX").style.display = "block";
             }

       }else{

        document.getElementById("SubmitX").style.display = "none";
       }




   }

</script>



<!--  Filter Model -->
<script>
   $(document).ready(function(){

    fetch_customer_data();

    function fetch_customer_data(search = '')
    {
     $.ajax({
      url:'ModelExecutingFilter',
      method:'GET',
      data:{search:search},
      dataType:'json',
      success:function(data)
      {
       $('.DataCC').html(data.table_data);
       $('#Name_Outcome').val(data.Outcome);
       $('#Qty').val(data.qty);
       $('#Total').val(data.tot);
       $('#TotalHide').val(data.tot);
       $('#OriginalTotalHide').val(data.tot);
       $('#count').val(data.count);




      var count =$('#count').val();
     var Qty =$('#Qty').val();
     var Total =$('#OriginalTotalHide').val();
     var Cost_Workmentship =$('#Cost_Workmentship').val();
        var x = 0 ;

     var NewTotal = parseFloat(Qty) * parseFloat(Total) ;

     $('#Total').val(parseFloat(NewTotal).toFixed(2));
     $('#TotalHide').val(parseFloat(NewTotal).toFixed(2));

     for(var i=1; i<= count ; i++){

        var Dep= $('#OriginalDepreciationQty'+i).val();
        var Qtyy= $('#OriginalQtyy'+i).val();
        var StoreQty= $('#StoreQty'+i).val();


        var newDep = parseFloat(Dep) * parseFloat(Qty) ;
        var newQty = parseFloat(Qtyy) * parseFloat(Qty) ;

         $('#DepreciationQty'+i).val(newDep);
         $('#Qtyy'+i).val(newQty);

         if(parseFloat(StoreQty) < parseFloat(newQty)){
             $('#More'+i).val(1);
         }else{

            $('#More'+i).val(0);

         }

     }



   $('.MO').each(function(){
   x += parseFloat($(this).val());
   });

     var FF=parseFloat(Qty) * parseFloat(Cost_Workmentship) ;
     $('#Total_Workmentship').val(parseFloat(FF));





if(parseFloat(x) == 0){

    document.getElementById('Btnsubmit').style.display='block';

}else{

    document.getElementById('Btnsubmit').style.display='none';

}





      }
     })
    }

   $(document).on('change', '#model', function(){
     var search = $(this).val();
     fetch_customer_data(search);
    });


   });
</script>

<script>
 function ChangePrice(){

     var count =$('#count').val();
     var Qty =$('#Qty').val();
     var Total =$('#OriginalTotalHide').val();
     var Cost_Workmentship =$('#Cost_Workmentship').val();
        var x = 0 ;

     var NewTotal = parseFloat(Qty) * parseFloat(Total) ;

     $('#Total').val(parseFloat(NewTotal).toFixed(2));
     $('#TotalHide').val(parseFloat(NewTotal).toFixed(2));

     for(var i=1; i<= count ; i++){

        var Dep= $('#OriginalDepreciationQty'+i).val();
        var Qtyy= $('#OriginalQtyy'+i).val();
        var StoreQty= $('#StoreQty'+i).val();


        var newDep = parseFloat(Dep) * parseFloat(Qty) ;
        var newQty = parseFloat(Qtyy) * parseFloat(Qty) ;

         $('#DepreciationQty'+i).val(newDep);
         $('#Qtyy'+i).val(newQty);

         if(parseFloat(StoreQty) < parseFloat(newQty)){
             $('#More'+i).val(1);
         }else{

            $('#More'+i).val(0);

         }

     }



   $('.MO').each(function(){
   x += parseFloat($(this).val());
   });

     var FF=parseFloat(Qty) * parseFloat(Cost_Workmentship) ;
     $('#Total_Workmentship').val(parseFloat(FF));





if(parseFloat(x) == 0){

    document.getElementById('Btnsubmit').style.display='block';

}else{

    document.getElementById('Btnsubmit').style.display='none';

}



 }

function IncomChange(r){

    var count =$('#count').val();
     var StoreQty =$('#StoreQty'+r).val();
     var Qtyy =$('#Qtyy'+r).val();
      var Dep= $('#OriginalDepreciationQty'+r).val();
      var Cost_Workmentship =$('#Cost_Workmentship').val();
       var x = 0 ;
   var newDep = parseFloat(Dep) * parseFloat(Qtyy) ;


         $('#DepreciationQty'+r).val(newDep);


         if(parseFloat(StoreQty) < parseFloat(Qtyy)){
             $('#More'+r).val(1);
         }else{

            $('#More'+r).val(0);

         }

   $('.MO').each(function(){
   x += parseFloat($(this).val());
   });

     var FF=parseFloat(Qtyy) * parseFloat(Cost_Workmentship) ;
     $('#Total_Workmentship').val(parseFloat(FF));





if(parseFloat(x) == 0){

    document.getElementById('submit').style.display='block';

}else{

    document.getElementById('submit').style.display='none';

}



}
</script>

<script>
    function AddModel(){

        var model=$('#model').val();
        var modelName=$('#model').find(":selected").text();
        var Qty=$('#Qty').val();
        var TotalHide=$('#TotalHide').val();
        var Name_Outcome=$('#Name_Outcome').val();


      var table = ` <tr>
                                <td class="TDeb">
                            ${modelName}

                                </td>
                                <td class="TCred">
                                ${Qty}
                               </td>
                                <td>${Name_Outcome}</td>

                <input type="hidden"  name="modelM[]" value="${model}">
    <input type="hidden" name="QtyM[]" value="${Qty}">
    <input type="hidden" name="TotalHideM[]" value="${TotalHide}">
    <input type="hidden" name="Name_OutcomeM[]" value="${Name_Outcome}">

                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>




                             </tr>`;


     document.getElementById("data-dt-model").innerHTML += table;


      $('#Qty').val('');
       $('#TotalHide').val('');
        $('#Name_Outcome').val('');
        $('.DataCC').empty();
     document.getElementById('Btnsubmit').style.display='none';
    }


               $("#data-dt-model").on("click", "#Del", function (e) {
            $(this).closest("tr").remove();

        });



submit

</script>

<!-- Submit Script -->
<script>
   function SPP(){
      $('#sp').val(1);
      var x= $('#sp').val();


   if(x == 1){
        document.getElementById("SubmitX").style.display = "none";
   document.getElementById('form').submit();
   }



   }


   function SPS(){
      $('#sp').val(0);
      var x= $('#sp').val();



    if(x == 0){
        document.getElementById("SubmitX").style.display = "none";
   document.getElementById('form').submit();
   }



   }

   function SPP8(){
      $('#sp').val(2);
      var x= $('#sp').val();


     if(x == 2){
        document.getElementById("SubmitX").style.display = "none";
   document.getElementById('form').submit();
   }


   }

   function SPP5(){
      $('#sp').val(3);
      var x= $('#sp').val();


     if(x == 3){
        document.getElementById("SubmitX").style.display = "none";
   document.getElementById('form').submit();
   }


   }



</script>

<script>
    $('#data-dt').on('click', '#DelAssem', function(e){
        $(this).closest('tr').remove();


        $.fn.rowCount = function() {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function(){
            sumQ += parseFloat($(this).val());
        });

        var sumT = 0;
        $('.Tot').each(function(){
            sumT += parseFloat($(this).val());
        });

        var sumD = 0;
        $('.Disc').each(function(){
            sumD += parseFloat($(this).val());
        });


        var sumBF = 0;
        $('.TotalBFTax').each(function(){
            sumBF += parseFloat($(this).val());
        });

        var sumTax = 0;
        $('.TotalTax').each(function(){
            sumTax += parseFloat($(this).val());
        });

        var prec = 0;
        $('.DiscoPrecent').each(function(){
            prec += parseFloat($(this).val());
        });

        var sumTTD = 0;
        $('.TDISCOOO').each(function(){
            sumTTD += parseFloat($(this).val());
        });
        var COPRI = 0;
        $('.COSTPRICES').each(function(){
            COPRI += parseFloat($(this).val());
        });
        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

        var TootPriice=parseFloat(sumT) + parseFloat(sumTTD) -  parseFloat(sumTax);
        $('#Total_Price').val(parseFloat(TootPriice).toFixed(2));
        $('#Total_PriceHide').val(parseFloat(TootPriice).toFixed(2));

        $('#Total_PriceW').val(parseFloat(sumT).toFixed(2));

        var PROFIIIT=parseFloat(sumT) - parseFloat(COPRI);
        $('#ProfitPrecent').val(parseFloat(PROFIIIT).toFixed(2));

        var nfd=((parseFloat(sumT) - parseFloat(COPRI)) * 100) / parseFloat(COPRI);
        $('#proPrecent').text(parseFloat(nfd).toFixed(2));
        $('#Total_Bill').val(parseFloat(sumT).toFixed(2));

        $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
        $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

        $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
        $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));


        var BEFO=parseFloat(sumBF)+parseFloat(sumTTD);

        $('#Total_Bf_Taxes').val(parseFloat(BEFO).toFixed(2));
        $('#Total_Bf_TaxesHide').val(parseFloat(BEFO).toFixed(2));

        $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
        $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));
        $('#TotalCost').val(parseFloat(COPRI).toFixed(2));



        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();
        var resdiual =$('#resdiual').val();
        var total =$('#Total_PriceHide').val();
        var totalDisc =$('#Total_DiscountHideTT').val();

        var totalTax =$('#Total_TaxesHide').val();


        var RR= (parseFloat(total) + parseFloat(totalTax) ) - (parseFloat(resdiual) + parseFloat(totalDisc));
        var RRR= parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
        $('#TAFterD').val(parseFloat(RRR).toFixed(2));
        $('#paid').val(parseFloat(RR).toFixed(2));

        $('#presenter').val(parseFloat(RR).toFixed(2));
        $('#total').val(parseFloat(sumT).toFixed(2));


        if(rowctr == 0){
            document.getElementById("SubmitX").style.display = "none";

        }else{

            document.getElementById("SubmitX").style.display = "block";
        }

        var Pay =$('#Payment_Method').val();
        var Stat =$('#Status').val();
        var paid =$('#paid').val();

        if(Pay == 'Later' &&  Stat == 0 ){

            if(paid == 0 || paid < 0){
                document.getElementById("SubmitX").style.display = "none";
            }else{

                if(rowctr == 0){
                    document.getElementById("SubmitX").style.display = "none";

                }else{

                    document.getElementById("SubmitX").style.display = "block";
                }



            }

        }else{

            if(rowctr == 0){
                document.getElementById("SubmitX").style.display = "none";

            }else{

                document.getElementById("SubmitX").style.display = "block";
            }
        }



        var Pay =$('#Payment_Method').val();
        if(Pay == 'Later'){


            $('#paid').val('');

        }

        var EN = 0;
        $('.ENO').each(function(){
            EN += parseFloat($(this).val());
        });

        var Total_PriceW =$('#Total_PriceW').val();

        if(EN == 0){

            if(Total_PriceW == 'NaN'){
                document.getElementById("SubmitX").style.display = "none";
            }else{
                document.getElementById("SubmitX").style.display = "block";
            }

        }else{

            document.getElementById("SubmitX").style.display = "none";
        }

    })


</script>
@endpush
