@extends('admin.index')
@section('content')
     <title>{{trans('admin.Edit_Clients')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Edit_Clients')}}  </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                            <div class="row">
                                    <div class="col-xl-12">
                                        <div  class="panel">
                                            <div class="panel-container show">
                                                 <span id="ex"> @include('admin.layouts.messages')</span>
                                                <div class="panel-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">{{trans('admin.Edit_Clients')}}  </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                                        </button>
                                                    </div>
                                                    <div class="panel-container show">
                                                        <div class="panel-content">
                                                            <ul class="nav nav-tabs" role="tablist">
                                                                <li class="nav-item">
                                                                    <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab"><i class="fal fa-home mr-1"></i> {{trans('admin.Main')}} </a>
                                                                </li>
                                                                <li class="nav-item">
                                                                    <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-2" role="tab"><i class="fal fa-user mr-1"></i>  {{trans('admin.Sub')}}</a>
                                                                </li>
                                                                <li class="nav-item">
                              <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-4" role="tab"><i class="fal fa-user mr-1"></i>  {{trans('admin.Trading_Data')}}</a>
                           </li>
                                                             <li class="nav-item">
                              <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-3" role="tab"><i class="fal fa-user mr-1"></i>  {{trans('admin.Addresses')}}</a>
                           </li>

                                                            </ul>
                       <form action="{{url('PostEditClients/'.$item->id)}}" method="post" enctype="multipart/form-data">
                            {!! csrf_field() !!}
                                 @honeypot
                        <input type="hidden" name="Images" value="{{$item->Image}}">
                        <input type="hidden" name="Account" value="{{$item->Account}}">

                                                            <div class="tab-content border border-top-0 p-3">

                              <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                                                   <div class="form-row">
                                                                    <div class="form-group col-md-2">
                                 <label class="form-label" for="simpleinput">   {{trans('admin.Code')}}</label>
                                 <input type="text"  value="{{$item->Code}}" disabled class="form-control">
                                        <input type="hidden" name="Code"  value="{{$item->Code}}">
                                                                    </div>
                                                                    <div class="form-group col-md-3">
                                             <label class="form-label" for="simpleinput">{{trans('admin.Date')}}  </label>
                                     <input type="date" name="Date" value="{{$item->Date}}" class="form-control">
                                                                    </div>

                                                                    <div class="form-group col-md-4">
                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}}  </label><span class="strick">*</span>
                        <input type="text" name="Name" value="{{$item->Name}}" class="form-control" required>
                                                                    </div>
                                                   <div class="form-group col-md-4">
                <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}  </label><span class="strick">*</span>
                        <input type="text" name="NameEn" value="{{$item->NameEn}}" class="form-control" required>
                                                                    </div>



                                                                    <div class="form-group col-md-3">
                <label class="form-label" for="">   {{trans('admin.Price_Level')}} </label><span class="strick">*</span>
                             <select class="select2 form-control w-100" name="Price_Level" required>
                                    <option value=""> {{trans('admin.Price_Level')}} </option>
            <option value="1" @if($item->Price_Level == 1) selected  @endif > {{trans('admin.Level1')}} </option>
             <option value="2" @if($item->Price_Level == 2) selected  @endif> {{trans('admin.Level2')}} </option>
             <option value="3" @if($item->Price_Level == 3) selected  @endif> {{trans('admin.Level3')}} </option>

                                                                        </select>
                                                                    </div>
                                                                    </div>
                                                                    <div class="form-row">
                                                                        <div class="form-group col-md-3">
                                           <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}  </label>
                              <input type="number" name="Phone" value="{{$item->Phone}}" class="form-control">
                                                                        </div>

                                                                        <div class="form-group col-md-2">
                                                                            <label class="form-label" for="simpleinput"> {{trans('admin.Email')}} </label>
                                                                            <input type="email" name="email" value="{{$item->email}}" class="form-control">
                                                                        </div>

                                                                </div>
                                                                    <div class="form-row">
                                                                    <div class="form-group col-md-3">
                                             <label class="form-label" for="">   {{trans('admin.ClientStatus')}}</label>
                                <select class="select2 form-control w-100" name="ClientStatus">
                             <option value="">{{trans('admin.ClientStatus')}}</option>
                                              @foreach($ClientStatus as $cls)
                      <option value="{{$cls->id}}" @if($item->ClientStatus == $cls->id) selected  @endif>

                           {{app()->getLocale() == 'ar' ?$cls->Arabic_Name :$cls->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                                          <div class="form-group col-md-3">
                                      <label class="form-label" for="">  {{trans('admin.Platforms')}} </label>
                                            <select class="select2 form-control w-100" id="Platform" name="Platform">
                                                <option value="">{{trans('admin.Platforms')}}</option>
                                              @foreach($Platforms as $pl)
            <option value="{{$pl->id}}" @if($item->Platform == $pl->id) selected  @endif>

                    {{app()->getLocale() == 'ar' ?$pl->Arabic_Name :$pl->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>

                                                                    <div class="form-group col-md-3">
                                           <label class="form-label" for="">  {{trans('admin.Campagin')}} </label>
                                     <select class="select2 form-control w-100" id="Campagin" name="Campagin">
                                                               @foreach($Campaigns as $camp)
      <option value="{{$camp->id}}" @if($item->Campagin == $camp->id) selected  @endif>

         {{app()->getLocale() == 'ar' ?$camp->Arabic_Name :$camp->English_Name}}
                                              </option>
                                              @endforeach

                                                                        </select>
                                                                    </div>

                                                                    <div class="form-group col-md-3">
                                      <label class="form-label" for="">  {{trans('admin.Activity')}}</label>
                                            <select class="select2 form-control w-100" name="Activity">
                                              <option value="">{{trans('admin.Activity')}}</option>
                                              @foreach($Activites as $act)
                <option value="{{$act->id}}" @if($item->Activity == $act->id) selected  @endif>

                    {{app()->getLocale() == 'ar' ?$act->Arabic_Name :$act->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>

                                                              <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Group')}} </label>
                                       <select class="select2 form-control w-100" name="Group" required>
                                          <option value="">{{trans('admin.Group')}}</option>
                                          @foreach($Groups as $g)
                                          <option value="{{$g->id}}"  @if($item->Group == $g->id) selected  @endif>

                             {{app()->getLocale() == 'ar' ?$g->Arabic_Name :$g->English_Name}}
                                          </option>
                                          @endforeach
                                       </select>
                                    </div>

                                                                    <div class="form-group col-md-3">
                                        <label class="form-label" for="">  {{trans('admin.Responsible')}}</label>
                                            <select class="select2 form-control w-100" name="Responsible">
                                                 <option value="">{{trans('admin.Responsible')}}</option>
                                              @foreach($Employess as $emp)
            <option value="{{$emp->id}}" @if($item->Responsible == $emp->id) selected  @endif>

                 {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                                                        <div class="form-group col-md-6">
                                                                            <label class="form-label" for="simpleinput">{{trans('admin.Address')}}   </label>
                                                                            <input type="text" name="Address" value="{{$item->Address}}" class="form-control">
                                                                        </div>

                                                                </div>
                                                                <div class="form-row">


                                                                    <div class="form-group col-lg-4">
                 <label class="form-label" for=""> {{trans('admin.Governrate')}}</label>
                                                                        <select class="select2 form-control w-100 Governrate" id="Governrate{{$item->id}}" name="Governrate" onchange="G({{$item->id}})" >
                                                                            <option value="">{{trans('admin.Governrate')}}</option>
                                                                            @foreach($Governrates as $gov)
                                                                                <option value="{{$gov->id}}" @if($gov->id == $item->Governrate) selected @endif>

                                                                                    {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                                                                </option>
                                                                            @endforeach
                                                                        </select>


                                                                    </div>


                                                                    <div class="form-group col-lg-4">
           <label class="form-label" for=""> {{trans('admin.City')}}</label>
                                                                        <select class="select2 form-control w-100 City" id="City{{$item->id}}" name="City" onchange="C({{$item->id}})" >
                                                                            @if(!empty($item->City))
                                                                                <option value="{{$item->City}}" selected>
                                                                                    {{app()->getLocale() == 'ar' ?$item->City()->first()->Arabic_Name :$item->City()->first()->English_Name}}
                                                                                </option>
                                                                            @endif
                                                                        </select>

                                                                    </div>


                                                                    <div class="form-group col-lg-4">
    <label class="form-label" for=""> {{trans('admin.Place')}}</label>
                                                                        <select class="select2 form-control w-100 Place" id="Place{{$item->id}}" name="Place" >

                                                                            @if(!empty($item->Place))
                                                                                <option value="{{$item->Place}}" selected>
                                                                                    {{app()->getLocale() == 'ar' ?$item->Place()->first()->Arabic_Name :$item->Place()->first()->English_Name}}
                                                                                </option>
                                                                            @endif

                                                                        </select>

                                                                    </div>






                                                            </div>

                                                                </div>

                  <div class="tab-pane fade" id="tab_borders_icons-2" role="tabpanel">

                                                                <div class="form-row">

                                                                    <div class="form-group col-md-3">
                                                                        <label class="form-label" for="">  {{trans('admin.Executions_Status')}}</label>
                                                                        <select class="select2 form-control w-100" name="Executions_Status">
                                                                            <option value="potential_client"  @if($item->Executions_Status == 'potential_client') selected  @endif>{{trans('admin.potential_client')}}</option>
                                                                            <option value="new_client"@if($item->Executions_Status == 'new_client') selected  @endif>{{trans('admin.new_client')}}</option>
                                                                            <option value="pending"@if($item->Executions_Status == 'pending') selected  @endif>{{trans('admin.pending')}}</option>
                                                                            <option value="former"@if($item->Executions_Status == 'former') selected  @endif>{{trans('admin.former')}}</option>
                                                                            <option value="important"@if($item->Executions_Status == 'important') selected  @endif>{{trans('admin.important')}}</option>
                                                                        </select>
                                                                    </div>

                                                                    <div class="form-group col-md-6">
                                                                        <label class="form-label" for="simpleinput">  {{trans('admin.ID_Number')}} </label>
                                                                        <input type="number" name="ID_Number" value="{{$item->ID_Number}}" class="form-control">
                                                                    </div>


                                                                    <div class="form-group col-md-2">
                                                                        <label class="form-label" for="simpleinput"> {{trans('admin.Respon_Person')}} </label>
                                                                        <input type="text"  name="Respon_Person" value="{{$item->Respon_Person}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-2">
                                                                        <label class="form-label" for="simpleinput"> {{trans('admin.Respon_Person_Phone')}} </label>
                                                                        <input type="tel"  name="Respon_Person_Phone" value="{{$item->Respon_Person_Phone}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-2">
                                                                        <label class="form-label" for="simpleinput"> {{trans('admin.Operating_Date')}} </label>
                                                                        <input type="date"  name="Operating_Date" value="{{$item->Operating_Date}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-2">
                                                                        <label class="form-label" for="simpleinput"> {{trans('admin.Activation_Serial')}} </label>
                                                                        <input type="text"  name="Activation_Serial" value="{{$item->Activation_Serial}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-2">
                                                                        <label class="form-label" for="simpleinput"> {{trans('admin.Activation_Code')}} </label>
                                                                        <input type="text"  name="Activation_Code" value="{{$item->Activation_Code}}" class="form-control">
                                                                    </div>


                                                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Credit_Limit')}}   </label>
                                       <input type="number" step="any" name="Credit_Limit" value="{{$item->Credit_Limit}}" class="form-control">
                                    </div>

                                                                    <div class="form-group col-md-3">
                                               <label class="form-label" for="simpleinput"> {{trans('admin.Qualifications')}}   </label>
                   <input type="text" name="Qualifications" value="{{$item->Qualifications}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Birthdate')}}   </label>
                                <input type="date" name="Birthdate" value="{{$item->Birthdate}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-3">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Social_Status')}}   </label>
                 <input type="text" name="Social_Status" value="{{$item->Social_Status}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-3">
                                   <label class="form-label" for="simpleinput">  {{trans('admin.Passport_Number')}}   </label>
                     <input type="text" name="Passport_Number" value="{{$item->Passport_Number}}" class="form-control">
                                                                    </div>
                                                                </div>
                                                                <div class="form-row">

                                                                    <div class="form-group col-md-3">
                                <label class="form-label" for="simpleinput">  {{trans('admin.Contract_Strat')}} </label>
                           <input type="date" name="Contract_Start" value="{{$item->Contract_Start}}" class="form-control">
                                                                    </div>
                                                                    <div class="form-group col-md-3">
                        <label class="form-label" for="simpleinput">  {{trans('admin.Contract_End')}}  </label>
                       <input type="date" name="Contract_End" value="{{$item->Contract_End}}" class="form-control">
                                                                    </div>

                                                                </div>
                                                                <div class="form-row">
                                                                    <div class="form-group col-md-3">
                      <label class="form-label" for="simpleinput">   {{trans('admin.Company_Name')}}   </label>
                            <input type="text" name="Company_Name" value="{{$item->Company_Name}}" class="form-control">
                                                                    </div>

                                                                    <div class="form-group col-md-3">
                              <label class="form-label" for="simpleinput"> {{trans('admin.Bank_Account')}} </label>
                             <input type="text" name="Bank_Account" value="{{$item->Bank_Account}}" class="form-control">
                                                                    </div>

                                                                </div>
                                                                <div class="form-row">
                                                                    <div class="form-group col-md-6 mb-6">
    <label class="form-label customize-input" for="imgInp"><i class="fal fa-image"></i>  {{trans('admin.Image')}}  </label>
                                    <input type="file" name="Image">
                                                    @if(!empty($item->Image))
                                        <img class="img-fluid" src="{{URL::to($item->Image)}}">
                                                    @endif
                                                                    </div>
                                                  </div>



                                                                      <div class="form-row">
                                                                    <div class="form-group col-md-6 mb-6">
                                   <label class="form-label" for="">     {{trans('admin.Client_Paper')}} </label>
                         <input type="file" name="File[]" multiple>
                                                                    </div>

                                            @foreach($CustomersFiles as $file)
                                            <div class="col-md-10">
                          <a class="btn btn-default" href="../{{Storage::url($file->File)}}" download>
                                           <i class="fal fa-file"> {{trans('admin.Download')}}</i>
                                                </a>

                                            </div>
                                            <div class="col-md-2">
                                    <a href="{{url('DeleteClientFile/'.$file->id)}}" class="btn btn-default">
                                               <i class="fal fa-trash"></i>
                                                </a>
                                                    </div>
                                              @endforeach
                                                                </div>


                                  <div class="form-group col-md-2 mb-2">
                                       <label class="form-label" for="">     {{trans('admin.Phone2')}} </label>
                                          <input type="tel" name="Phone2" value="{{$item->Phone2}}" class="form-control">
                                    </div>
                                                  <div class="form-group col-md-2 mb-2">
                                       <label class="form-label" for="">     {{trans('admin.Phone3')}} </label>
                                          <input type="tel" name="Phone3" value="{{$item->Phone3}}" class="form-control">
                                    </div>

                                                  <div class="form-group col-md-2 mb-2">
                                       <label class="form-label" for="">     {{trans('admin.Phone4')}} </label>
                                          <input type="tel" name="Phone4" value="{{$item->Phone4}}" class="form-control">
                                    </div>
                                                  <div class="form-group col-md-2 mb-2">
                                       <label class="form-label" for="">     {{trans('admin.SearchCode')}} </label>
                                          <input type="text" name="SearchCode" value="{{$item->SearchCode}}" class="form-control">
                                    </div>

                                             <div class="form-group col-lg-4">
                           <label class="form-label" for=""> ({{trans('admin.Product')}})</label>
                           <select  class="select2 form-control w-100" id="product" name="Product" >
                        @if(!empty($item->Product()->first()->P_Ar_Name)) <option value="{{$item->Product}}">

                              {{app()->getLocale() == 'ar' ?$item->Product()->first()->P_Ar_Name :$item->Product()->first()->P_En_Name}}
                               </option>  @endif
                           </select>
                        </div>


                                                    <div class="form-group col-lg-4">

                                       <select class="select2 form-control w-100"  name="Warranty"  >
                                          <option value="">{{trans('admin.Warranty')}}</option>
                                          <option value="Yes" @if($item->Warranty == 'Yes') selected @endif>{{trans('admin.Yes')}}</option>
                                          <option value="No" @if($item->Warranty == 'No') selected @endif>{{trans('admin.No')}}</option>
                                       </select>


                                                                            </div>


                                                                </div>
                          <div class="tab-pane fade" id="tab_borders_icons-4" role="tabpanel">

                                 <div class="form-row">

                                     <div class="form-group col-md-3">
                                         <label class="form-label" for="simpleinput"> {{trans('admin.Repayment_Period')}} </label>
                                         <input type="number" name="Repayment_Period" value="{{$item->Repayment_Period}}" class="form-control">
                                     </div>
                             <div class="form-group col-md-4">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Commercial_Registration_No')}}  </label>
                                       <input type="number" name="Commercial_Registration_No" value="{{$item->Commercial_Registration_No}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-4">
                                       <label class="form-label" for="simpleinput">  {{trans('admin.Tax_Card_No')}}  </label>
                                       <input type="number" name="Tax_Card_No" value="{{$item->Tax_Card_No}}" class="form-control">
                                    </div>

                            <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Tax_Registration_Number')}}   </label>
                                       <input type="text" name="Tax_Registration_Number" value="{{$item->Tax_Registration_Number}}" class="form-control">
                                    </div>


                                                     <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Tax_activity_code')}}   </label>
                                       <input type="text" name="Tax_activity_code" value="{{$item->Tax_activity_code}}" class="form-control">
                                    </div>


 <div class="form-group col-md-4">
                                       <label class="form-label" for="">    {{trans('admin.work_nature')}}    </label>
                              <select class="select2 form-control" name="work_nature" >
                    <option value="P" @if($item->work_nature == 'P') selected @endif>{{trans('admin.Person')}}</option>
                  <option value="B" @if($item->work_nature  == 'B') selected @endif>{{trans('admin.Egyptian_trading_company')}}</option>
                  <option value="F" @if($item->work_nature  == 'F') selected @endif>{{trans('admin.foreign_trading_company')}}</option>
                              </select>
                                    </div>
 <div class="form-group col-md-4">
                              <label class="form-label" for="">  {{trans('admin.Nationality')}} </label>
                              <select class="select2 form-control w-100"  name="Nationality" >
                                 <option value="">{{trans('admin.Nationality')}}</option>
                                 @foreach($Nationality as $nation)
                                 <option value="{{$nation->id}}"  @if($nation->id  == $item->Nationality) selected @endif>

                     {{app()->getLocale() == 'ar' ?$nation->Arabic_Name :$nation->English_Name}}
                                 </option>
                                 @endforeach
                              </select>
                           </div>


                                                                    <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Buliding_Num')}}   </label>
                                       <input type="text" name="Buliding_Num" value="{{$item->Buliding_Num}}" class="form-control">
                                    </div>
                                                                    <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Street')}}   </label>
                                       <input type="text" name="Street" value="{{$item->Street}}" class="form-control">
                                    </div>

                                                                    <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Postal_Code')}}   </label>
                                       <input type="text" name="Postal_Code" value="{{$item->Postal_Code}}" class="form-control">
                                    </div>
                                                                    <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.tax_magistrate')}}   </label>
                                       <input type="text" name="tax_magistrate" value="{{$item->tax_magistrate}}" class="form-control">
                                    </div>
                                                  <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Floor')}}   </label>
                                       <input type="text" name="Floor" value="{{$item->Floor}}" class="form-control">
                                    </div>


                                                                    <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Room')}}   </label>
                                       <input type="text" name="Room" value="{{$item->Room}}" class="form-control">
                                    </div>


                                                                    <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Landmark')}}   </label>
                                       <input type="text" name="Landmark" value="{{$item->Landmark}}" class="form-control">
                                    </div>


                                                                    <div class="form-group col-md-4">
                                       <label class="form-label" for=""> {{trans('admin.Add_Info')}}   </label>
                                       <input type="text" name="Add_Info" value="{{$item->Add_Info}}" class="form-control">
                                    </div>




                                 </div>
                              </div>
                        <div class="tab-pane fade" id="tab_borders_icons-3" role="tabpanel">
                                      <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.Name')}}</th>
                                                                        <th>{{trans('admin.Governrate')}}</th>
                                                                        <th>{{trans('admin.City')}}</th>
                                                                        <th>{{trans('admin.Place')}}</th>
                                                                         <th>{{trans('admin.Street')}}</th>
                                                                         <th>{{trans('admin.Buliding')}}</th>
                                                                         <th>{{trans('admin.Floor')}}</th>
                                                                         <th>{{trans('admin.Flat')}}</th>
                                                                         <th>{{trans('admin.Special_Mark')}} </th>
                                                                         <th>{{trans('admin.Location')}} </th>
                                                                         <th>{{trans('admin.Address_Details')}} </th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>
                                                            <td>
                                                    <input type="text" id="Naame" class="form-control">
                                                            </td>
                                                                        <td>
                                                                    <div class="form-group">

                                       <select class="select2 form-control w-100" id="Governrate" >
                                          <option value="">{{trans('admin.Governrate')}}</option>
                                          @foreach($Governrates as $gov)
                                          <option value="{{$gov->id}}" >


                               {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                          </option>
                                          @endforeach
                                       </select>


                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                                       <select class="select2 form-control w-100" id="City" >

                                       </select>

                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                        <div class="form-group">

                                       <select class="select2 form-control w-100" id="Place" >

                                       </select>

                                                                            </div>
                                                                        </td>

                                                                        <td>
                                                                            <div class="form-group">

                <input type="text" id="Street" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                                <td>
                                                                            <div class="form-group">

                <input type="text" id="Buliding" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                                <td>
                                                                            <div class="form-group">

                <input type="text" id="Floor" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                                <td>
                                                                            <div class="form-group">

                <input type="text" id="Flat" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                                <td>
                                                                            <div class="form-group">

                <input type="text" id="Special_Mark" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                                <td>
                                                                            <div class="form-group">

                <input type="text" id="Location" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                   <td>
                                                                            <div class="form-group">

                <input type="text" id="Address_Details" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertData()" class="btn btn-default" id="add-data"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>{{trans('admin.Name')}}</th>
                                                                        <th>{{trans('admin.Governrate')}}</th>
                                                                        <th>{{trans('admin.City')}}</th>
                                                                        <th>{{trans('admin.Place')}}</th>
                                                                         <th>{{trans('admin.Street')}}</th>
                                                                         <th>{{trans('admin.Buliding')}}</th>
                                                                         <th>{{trans('admin.Floor')}}</th>
                                                                         <th>{{trans('admin.Flat')}}</th>
                                                                         <th>{{trans('admin.Special_Mark')}} </th>
                                                                         <th>{{trans('admin.Location')}} </th>
                                                                         <th>{{trans('admin.Address_Details')}} </th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dt">

                                        @foreach($CustomersAddresses as $cust)
                                             <tr>
                            <td>
                         {{$cust->Address_Name}}
                                </td>
                                <td>
                          @if(!empty($cust->Governrate))    {{app()->getLocale() == 'ar' ?$cust->Governrate()->first()->Arabic_Name :$cust->Governrate()->first()->English_Name}} @endif
                                </td>
                            <td>
                          @if(!empty($cust->City)) {{app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name}} @endif
                                </td>

                                <td>
                          @if(!empty($cust->Place)) {{app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name}}  @endif
                               </td>

                                <td>
                             {{$cust->Street}}
                               </td>
                                <td>
                         {{$cust->Buliding}}
                               </td>
                                <td>
                       {{$cust->Floor}}
                               </td>
                                <td>
                      {{$cust->Flat}}
                               </td>
                                <td>
                           {{$cust->Special_Mark}}
                               </td>
                                <td>
                        {{$cust->Location}}
                               </td>
                                <td>
                             {{$cust->Details}}

 <input type="hidden" name="Address_Name[]" value="{{$cust->Address_Name}}">
 <input type="hidden" name="StreetAdd[]" value="{{$cust->Street}}">
 <input type="hidden" name="BulidingAdd[]" value="{{$cust->Buliding}}">
 <input type="hidden" name="FloorAdd[]" value="{{$cust->Floor}}">
 <input type="hidden" name="FlatAdd[]" value="{{$cust->Flat}}">
 <input type="hidden" name="Special_MarkAdd[]" value="{{$cust->Special_Mark}}">
 <input type="hidden" name="LocationAdd[]" value="{{$cust->Location}}">
 <input type="hidden" name="Address_DetailsAdd[]" value="{{$cust->Details}}">
 <input type="hidden" name="GovernrateAdd[]" value="{{$cust->Governrate}}">
 <input type="hidden" name="CityAdd[]" value="{{$cust->City}}">
 <input type="hidden" name="PlaceAdd[]" value="{{$cust->Place}}">
                               </td>

                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>
                                        @endforeach


                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>


                                                    </div>

                                               <div class="form-row">
                                                                   <div class="buttons mt-3">
            <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i> {{trans('admin.Save')}} </button>
                                                                  </div>
                                                                </div>

                                                            </div>
                                                        </form>
                                                        </div>
                                                    </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                                </div>


</main>

@endsection

@push('js')



    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/dropzone/dropzone.css')}}">

    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


                        <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
                        <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
                        <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
                        <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
                        <script>
                            //_fnFeatureHtmlLength();
                            $(document).ready(function () {
                                // Setup - add a text input to each footer cell
                                $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
                                $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                                    var title = $(this).text();
                                    $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                                    $('input', this).on('keyup change', function () {
                                        if (table.column(i).search() !== this.value) {
                                            table
                                                .column(i)
                                                .search(this.value)
                                                .draw();
                                        }
                                    });
                                });
                                var table = $('#dt-basic-example').DataTable(
                                    {
                                        responsive: true,
                                        orderCellsTop: true,
                                        fixedHeader: true,
                                        lengthChange: true,

                                        dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                                            "<'row'<'col-sm-12'tr>>" +
                                            "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                                        buttons: [
                                            {
                                                extend: 'pageLength',
                                                className: 'btn-outline-default'
                                            },
                                            {
                                                extend: 'colvis',
                                                text: 'Column Visibility',
                                                titleAttr: 'Col visibility',
                                                className: 'btn-outline-default'
                                            },
                                            {
                                                extend: 'pdfHtml5',
                                                text: 'PDF',
                                                titleAttr: 'Generate PDF',
                                                className: 'btn-outline-danger btn-sm mr-1'
                                            },
                                            {
                                                extend: 'excelHtml5',
                                                text: 'Excel',
                                                titleAttr: 'Generate Excel',
                                                className: 'btn-outline-success btn-sm mr-1'
                                            },
                                            {
                                                extend: 'csvHtml5',
                                                text: 'CSV',
                                                titleAttr: 'Generate CSV',
                                                className: 'btn-outline-primary btn-sm mr-1'
                                            },
                                            {
                                                extend: 'copyHtml5',
                                                text: 'Copy',
                                                titleAttr: 'Copy to clipboard',
                                                className: 'btn-outline-primary btn-sm mr-1'
                                            },
                                            {
                                                extend: 'print',
                                                text: 'Print',
                                                titleAttr: 'Print Table',
                                                className: 'btn-outline-primary btn-sm'
                                            }
                                        ],
                                    });
                                $('.js-thead-colors a').on('click', function () {
                                    var theadColor = $(this).attr("data-bg");
                                    console.log(theadColor);
                                    $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
                                });

                                $('.js-tbody-colors a').on('click', function () {
                                    var theadColor = $(this).attr("data-bg");
                                    console.log(theadColor);
                                    $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
                                });

                            });

                        </script>

                  <!-- Search Selecet -->
<script>
   $(document).ready(function () {
       $(function () {
           $(".select2").select2();

           $(".select2-placeholder-multiple").select2({
               placeholder: "Select State",
           });
           $(".js-hide-search").select2({
               minimumResultsForSearch: 1 / 0,
           });
           $(".js-max-length").select2({
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items",
           });
           $(".select2-placeholder").select2({
               placeholder: "Select a state",
               allowClear: true,
           });

           $(".js-select2-icons").select2({
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function (elm) {
                   return elm;
               },
           });

           function icon(elm) {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
           }




                         $('#product').select2({
   placeholder: "select...",
   ajax: {
       type: "GET",
       dataType: 'json',
       url: 'AllProClientFilter',
       processResults: function (data) {
         return {
           results: $.map(data, function(obj, index) {
             return { id: index, text: obj };
           })
         };

           	console.log(data);

       },
        data: function (params) {


                  var query = {
                           search: params.term,
                       };


             $.ajax({
                             url: 'AllProClientFilterJs/'+params.term,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                         $('#product').empty();
                                 $.each(data, function(key, value){

                        $('#product').append('<option value="'+ key +'">' + value + '</option>');

                                 });
                             },
                             complete: function(){
                                 $('#loader').css("visibility", "hidden");
                             }
                         });



       }
   }
   });


   $('#product').on('select2:select', function (e) {
   console.log("select done", e.params.data);
   });





       });
   });
</script>
                    <script>
                        var autoSave = $('#autoSave');
                        var interval;
                        var timer = function()
                        {
                            interval = setInterval(function()
                            {
                                //start slide...
                                if (autoSave.prop('checked'))
                                    saveToLocal();

                                clearInterval(interval);
                            }, 3000);
                        };

                        //save
                        var saveToLocal = function()
                        {
                            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
                            console.log("saved");
                        }

                        //delete
                        var removeFromLocal = function()
                        {
                            localStorage.removeItem("summernoteData");
                            $('#saveToLocal').summernote('reset');
                        }

                        $(document).ready(function()
                        {
                            //init default
                            $('.js-summernote').summernote(
                            {
                                height: 200,
                                tabsize: 2,
                                placeholder: "Type here...",
                                dialogsFade: true,
                                toolbar: [
                                    ['style', ['style']],
                                    ['font', ['strikethrough', 'superscript', 'subscript']],
                                    ['font', ['bold', 'italic', 'underline', 'clear']],
                                    ['fontsize', ['fontsize']],
                                    ['fontname', ['fontname']],
                                    ['color', ['color']],
                                    ['para', ['ul', 'ol', 'paragraph']],
                                    ['height', ['height']]
                                    ['table', ['table']],
                                    ['insert', ['link', 'picture', 'video']],
                                    ['view', ['fullscreen', 'codeview', 'help']]
                                ],
                                callbacks:
                                {
                                    //restore from localStorage
                                    onInit: function(e)
                                    {
                                        $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                                    },
                                    onChange: function(contents, $editable)
                                    {
                                        clearInterval(interval);
                                        timer();
                                    }
                                }
                            });

                            //load emojis
                            $.ajax(
                            {
                                url: 'https://api.github.com/emojis',
                                async: false
                            }).then(function(data)
                            {
                                window.emojis = Object.keys(data);
                                window.emojiUrls = data;
                            });

                            //init emoji example
                            $(".js-hint2emoji").summernote(
                            {
                                height: 100,
                                toolbar: false,
                                placeholder: 'type starting with : and any alphabet',
                                hint:
                                {
                                    match: /:([\-+\w]+)$/,
                                    search: function(keyword, callback)
                                    {
                                        callback($.grep(emojis, function(item)
                                        {
                                            return item.indexOf(keyword) === 0;
                                        }));
                                    },
                                    template: function(item)
                                    {
                                        var content = emojiUrls[item];
                                        return '<img src="' + content + '" width="20" /> :' + item + ':';
                                    },
                                    content: function(item)
                                    {
                                        var url = emojiUrls[item];
                                        if (url)
                                        {
                                            return $('<img />').attr('src', url).css('width', 20)[0];
                                        }
                                        return '';
                                    }
                                }
                            });

                            //init mentions example
                            $(".js-hint2mention").summernote(
                            {
                                height: 100,
                                toolbar: false,
                                placeholder: "type starting with @",
                                hint:
                                {
                                    mentions: ['jayden', 'sam', 'alvin', 'david'],
                                    match: /\B@(\w*)$/,
                                    search: function(keyword, callback)
                                    {
                                        callback($.grep(this.mentions, function(item)
                                        {
                                            return item.indexOf(keyword) == 0;
                                        }));
                                    },
                                    content: function(item)
                                    {
                                        return '@' + item;
                                    }
                                }
                            });

                        });

                    </script>
                    <script type="text/javascript">


                        $(".show-table").click(function(){
                            $(".hide-table").show();
                        });

                    </script>

<!-- Filter Governrate and City !-->
<script>
   $(document).ready(function() {

       $('#Governrate').on('change', function(){
           var countryId = $(this).val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });

                      var CIITY = $('#City').val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place').empty();

                       $.each(data, function(key, value){

             $('#Place').append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });



                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       });

   });

   $(document).ready(function() {


           var countryId = $('#Governrate').val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });

                     var CIITY = $('#City').val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place').empty();

                       $.each(data, function(key, value){

             $('#Place').append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });




                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }


   });


 $('#City').on('change', function(){
      var CIITY = $('#City').val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place').empty();

                       $.each(data, function(key, value){

             $('#Place').append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });


 });

</script>
<!-- Filter Platform and Campaigns !-->
<script>
   $(document).ready(function() {

       $('#Platform').on('change', function(){
           var countryId = $(this).val();
           if(countryId) {
               $.ajax({
                   url: 'PlatformFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Campagin').empty();

                       $.each(data, function(key, value){

             $('#Campagin').append('<option value="'+ key +'">' + value + '</option>');

                       });
                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       });

   });
</script>

<!-- Address -->
<script>
    function InsertData() {
        var Naame = document.getElementById("Naame").value;
        var Street = document.getElementById("Street").value;
        var Buliding = document.getElementById("Buliding").value;
        var Floor = document.getElementById("Floor").value;
        var Flat = document.getElementById("Flat").value;
        var Special_Mark = document.getElementById("Special_Mark").value;
        var Location = document.getElementById("Location").value;
        var Address_Details = document.getElementById("Address_Details").value;

        var GovernrateName =  $("#Governrate option:selected").text();
        var Governrate =  $("#Governrate").val();

          var CityName =  $("#City option:selected").text();
        var City =  $("#City").val();

          var PlaceName =  $("#Place option:selected").text();
        var Place =  $("#Place").val();


        var table = ` <tr>
                            <td>
                            ${Naame}
                                </td>
                                <td>
                            ${GovernrateName}
                                </td>
                            <td>
                            ${CityName}
                                </td>

                                <td>
                                ${PlaceName}
                               </td>

                                <td>
                                ${Street}
                               </td>
                                <td>
                                ${Buliding}
                               </td>
                                <td>
                                ${Floor}
                               </td>
                                <td>
                                ${Flat}
                               </td>
                                <td>
                                ${Special_Mark}
                               </td>
                                <td>
                                ${Location}
                               </td>
                                <td>
                                ${Address_Details}

 <input type="hidden" name="Address_Name[]" value="${Naame}">
 <input type="hidden" name="StreetAdd[]" value="${Street}">
 <input type="hidden" name="BulidingAdd[]" value="${Buliding}">
 <input type="hidden" name="FloorAdd[]" value="${Floor}">
 <input type="hidden" name="FlatAdd[]" value="${Flat}">
 <input type="hidden" name="Special_MarkAdd[]" value="${Special_Mark}">
 <input type="hidden" name="LocationAdd[]" value="${Location}">
 <input type="hidden" name="Address_DetailsAdd[]" value="${Address_Details}">
 <input type="hidden" name="GovernrateAdd[]" value="${Governrate}">
 <input type="hidden" name="CityAdd[]" value="${City}">
 <input type="hidden" name="PlaceAdd[]" value="${Place}">
                               </td>

                                <td>
                    <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dt").innerHTML += table;



        $("#data-dt").on("click", "#Del", function (e) {
            $(this).closest("tr").remove();

        });
    }

        $("#data-dt").on("click", "#Del", function (e) {
            $(this).closest("tr").remove();

        });
</script>


    <!-- Filter Governrate and City !-->
<script>
   $(document).ready(function() {

       $('#Governrate').on('change', function(){
           var countryId = $(this).val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });

                      var CIITY = $('#City').val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place').empty();

                       $.each(data, function(key, value){

             $('#Place').append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });



                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       });

   });

   $(document).ready(function() {


           var countryId = $('#Governrate').val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City').empty();

                       $.each(data, function(key, value){

             $('#City').append('<option value="'+ key +'">' + value + '</option>');

                       });

                     var CIITY = $('#City').val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place').empty();

                       $.each(data, function(key, value){

             $('#Place').append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });




                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }


   });


 $('#City').on('change', function(){
      var CIITY = $('#City').val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place').empty();

                       $.each(data, function(key, value){

             $('#Place').append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });


 });



    function G(r){
           var countryId = $('#Governrate'+r).val();
           if(countryId) {
               $.ajax({
                   url: 'GovernrateFilter/'+countryId,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#City'+r).empty();

                       $.each(data, function(key, value){

             $('#City'+r).append('<option value="'+ key +'">' + value + '</option>');

                       });

                      var CIITY = $('#City'+r).val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place'+r).empty();

                       $.each(data, function(key, value){

             $('#Place'+r).append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });



                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });
           } else {

               $('select[name="states"]').empty();
           }

       }






function C(r){
      var CIITY = $('#City'+r).val();
                         $.ajax({
                   url: 'CityFilter/'+CIITY,
                   type:"GET",
                   dataType:"json",
                   beforeSend: function(){
                       $('#loader').css("visibility", "visible");
                   },

                   success:function(data) {

                       $('#Place'+r).empty();

                       $.each(data, function(key, value){

             $('#Place'+r).append('<option value="'+ key +'">' + value + '</option>');

                       });


                   },
                   complete: function(){
                       $('#loader').css("visibility", "hidden");
                   }
               });


 }


</script>
@endpush

