@extends('admin.index')
@section('content')
@php
use App\Models\CustomersFiles;
use App\Models\Interviews;
use App\Models\Sales;
use App\Models\Addressses;
@endphp
     <title>{{trans('admin.Clients')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Sales')}} </a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Clients')}}  </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <!-- Filter -->
                    <div class="row">
                        <div class="col-lg-12">
                            <div id="panel-2" class="panel first-color">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i>   {{trans('admin.Clients')}}  </i></span>
                                    </h2>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <form action="{{url('FilterClientSechdule')}}" method="get" class="form-row">
                                            <div class="form-group col-md-2" style="display: none">
                                                <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" name="From" class="form-control" required>
                                            </div>
                                            <div class="form-group col-md-2" style="display: none">
                                                <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" name="To" class="form-control" required>
                                            </div>
                                            <div class="form-group col-md-2" style="display: block">
                                    <label class="form-label" for="">  {{trans('admin.Governrate')}} </label>
                                          <select class="select2 form-control w-100" id="Governrate" name="Governrate">
                                                   <option value="">{{trans('admin.Governrate')}}</option>
                                              @foreach($Governrates as $gov)
                                                    <option value="{{$gov->id}}">

                             {{app()->getLocale() == 'ar' ?$gov->Arabic_Name :$gov->English_Name}}
                                              </option>
                                              @endforeach
                                                        </select>
                                                    </div>
                                            <div class="form-group col-md-2" style="display: block">
                                        <label class="form-label" for="">  {{trans('admin.City')}}</label>
                                               <select class="select2 form-control w-100" id="City" name="City">
                                  <option value="">{{trans('admin.City')}}</option>
                                              @foreach($Cities as $cit)
                                            <option value="{{$cit->id}}">

                              {{app()->getLocale() == 'ar' ?$cit->Arabic_Name :$cit->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                      <label class="form-label" for="">  {{trans('admin.Activity')}}</label>
                                            <select class="select2 form-control w-100" name="Activity">
                                              <option value="">{{trans('admin.Activity')}}</option>
                                              @foreach($Activites as $act)
                                                    <option value="{{$act->id}}">

                               {{app()->getLocale() == 'ar' ?$act->Arabic_Name :$act->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                        <label class="form-label" for="">  {{trans('admin.Responsible')}}</label>
                                            <select class="select2 form-control w-100" name="Responsible">
                                                 <option value="">{{trans('admin.Responsible')}}</option>
                                              @foreach($Employess as $emp)
                                                    <option value="{{$emp->id}}">

                                {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                        <label class="form-label" for="">  {{trans('admin.Executions_Status')}}</label>
                                            <select class="select2 form-control w-100" name="Executions_Status">
                                        <option value="">{{trans('admin.Executions_Status')}}</option>
                                        <option value="potential_client">{{trans('admin.potential_client')}}</option>
                                                 <option value="new_client">{{trans('admin.new_client')}}</option>
                                                 <option value="pending">{{trans('admin.pending')}}</option>
                                                 <option value="former">{{trans('admin.former')}}</option>
                                                 <option value="important">{{trans('admin.important')}}</option>
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                             <label class="form-label" for="">   {{trans('admin.ClientStatus')}}</label>
                                <select class="select2 form-control w-100" name="ClientStatus">
                             <option value="">{{trans('admin.ClientStatus')}}</option>
                                              @foreach($ClientStatus as $cls)
                                                    <option value="{{$cls->id}}">

                                    {{app()->getLocale() == 'ar' ?$cls->Arabic_Name :$cls->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                      <label class="form-label" for="">  {{trans('admin.Platforms')}} </label>
                                            <select class="select2 form-control w-100" id="Platform" name="Platform">
                                                <option value="">{{trans('admin.Platforms')}}</option>
                                              @foreach($Platforms as $pl)
                                                    <option value="{{$pl->id}}">

                                   {{app()->getLocale() == 'ar' ?$pl->Arabic_Name :$pl->English_Name}}
                                              </option>
                                              @endforeach
                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                           <label class="form-label" for="">  {{trans('admin.Campagin')}} </label>
                                     <select class="select2 form-control w-100" id="Campagin" name="Campagin">
                                            <option value=""> {{trans('admin.Campagin')}}</option>
                                                               @foreach($Campaigns as $camp)
                                            <option value="{{$camp->id}}" >


                         {{app()->getLocale() == 'ar' ?$camp->Arabic_Name :$camp->English_Name}}
                                              </option>
                                              @endforeach

                                                                        </select>
                                                                    </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.User')}}  </label>
                                                <select class="select2 form-control w-100" name="User">
                                                    <option value=""> {{trans('admin.User')}}</option>
                                                 @foreach($Users as $user)
                                                <option value="{{$user->id}}">

                             {{app()->getLocale() == 'ar' ?$user->name :$user->nameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>

                                            <div class="form-group col-lg-2">
                                      <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                <input type="text" name="Code" class="form-control">
                                            </div>
                                            <div class="form-group col-lg-2">
                                      <label class="form-label" for="simpleinput">{{trans('admin.Name')}} </label>
                                                <input type="text" name="Name" class="form-control">
                                            </div>
                                            <div class="form-group col-lg-2">
                                      <label class="form-label" for="simpleinput">{{trans('admin.Phone')}} </label>
                                                <input type="number" name="Phone" class="form-control">
                                            </div>

                                            <div class="form-group col-md-2">
                                                <div class="buttons mt-4">
                     <button type="submit" class="btn btn-primary w-100">  {{trans('admin.Show')}}</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
          <!-- data entry -->
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel second-color">
                                <div class="panel-hdr">
                                    <h2> {{trans('admin.Clients')}}</h2>
                                    <div class="panel-toolbar">
    <a href="{{'ExportAllClients'}}" class="btn btn-success btn-sm">
                                 Export Excel
                                            </a>
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">TableStyle</button>
                                         @include('admin.layouts.toolbar')
                                    </div>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped" style="width:100%;">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>

                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>

                                                    <th>{{trans('admin.Account_Code')}}</th>
                                                    <th>{{trans('admin.Responsible')}}</th>

                                                    <th>{{trans('admin.Addresses')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.TicketsClient')}}</th>
                                                    <th>{{trans('admin.Comments')}}</th>

                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Code}}</td>

                                                    <td>{{$item->Name}}</td>
                                                    <td>{{$item->NameEn}}</td>

                                                    <td>      @if(!empty($item->Account()->first()->Code))  {{$item->Account()->first()->Code}} @endif</td>
                                                    <td>
                                                @if(!empty($item->Responsible))


                                  {{app()->getLocale() == 'ar' ?$item->Responsible()->first()->Name :$item->Responsible()->first()->NameEn}}
                                                @endif
                                                    </td>


                                                                      <td>
                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Addresses{{$item->id}}">{{trans('admin.Addresses')}} </button>
                                                </td>
                                                    <td>
                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Details{{$item->id}}">{{trans('admin.Details')}} </button>
                                                </td>

                                                    <td>
                        <a href="{{url('TicketsClient/'.$item->id)}}" class="btn btn-default">{{trans('admin.TicketsClient')}}</a>

                                                </td>
                                                                     <td>
                        <a href="{{url('CommentsClient/'.$item->id)}}" class="btn btn-default">{{trans('admin.Comments')}}</a>

                                                </td>


                                                        <td class="text-center">
                         <a href="{{url('ProfileCustomer/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-user"></i></a>
                         <a href="{{url('CoooMCustomer/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-eye"></i></a>

                                           @can('حذف العملاء')
            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}"><i class="fal fa-trash"></i></button>
                                            @endcan

                                          @can('تعديل العملاء')
             <a href="{{url('EditClients/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-edit"></i></a>
                                        @endcan
                                                        </td>
                                                </tr>
                                            @endforeach
                                           </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>

                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>

                                                    <th>{{trans('admin.Account_Code')}}</th>
                                                    <th>{{trans('admin.Responsible')}}</th>

                                                    <th>{{trans('admin.Addresses')}}</th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.TicketsClient')}}</th>
                                                       <th>{{trans('admin.Comments')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                        </div>
                                       {{$items->Links()}}
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

@foreach($items as $item)


                    <!-- Modal Details -->
       <div class="modal fade" id="Details{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                 {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-row">
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">  {{trans('admin.Price_Level')}}</label>
                                    @if($item->Price_Level == 1)
                                    <input type="text" value="{{trans('admin.Level1')}}"  class="form-control" disabled>
                                @elseif($item->Price_Level == 2)
                                     <input type="text" value="{{trans('admin.Level2')}}"  class="form-control" disabled>
                                @elseif($item->Price_Level == 3)
                                     <input type="text" value="{{trans('admin.Level3')}}"  class="form-control" disabled>
                                @endif

                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone')}}</label>
                                    <input type="text" value="{{$item->Phone}}"  class="form-control" disabled>
                                </div>

                                      <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}</label>
                                    <input type="text" value="{{$item->Phone2}}"  class="form-control" disabled>
                                </div>


                                      <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone3')}}</label>
                                    <input type="text" value="{{$item->Phone3}}"  class="form-control" disabled>
                                </div>


                                      <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Phone4')}}</label>
                                    <input type="text" value="{{$item->Phone4}}"  class="form-control" disabled>
                                </div>

                                      <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Credit_Limit')}}</label>
                                    <input type="text" value="{{$item->Credit_Limit}}"  class="form-control" disabled>
                                </div>


                                        <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                                    <input type="text" value="{{$item->Date}}"  class="form-control" disabled>
                                </div>

                                        <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Email')}}</label>
                                    <input type="text" value="{{$item->email}}"  class="form-control" disabled>
                                </div>

                                        <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Next_Appointment')}}</label>
                                    <input type="text" value=""  class="form-control" disabled>
                                </div>
                                                  <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Product')}}</label>
                                        @if(!empty($item->Product()->first()->P_Ar_Name))
                                    <input type="text" value="{{$item->Product()->first()->P_Ar_Name}}"  class="form-control" disabled>
                                        @endif
                                </div>


                                        <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.User')}}</label>
                                            @if(!empty($item->User()->first()->name))
                                    <input type="text" value=" {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}  "  class="form-control" disabled>
                                            @endif
                                </div>


                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="simpleinput">{{trans('admin.Governrate')}}</label>
                                    @if(!empty($item->Governrate))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->Governrate()->first()->Arabic_Name :$item->Governrate()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif
                                </div>

                                    <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput">{{trans('admin.City')}} </label>
                                       @if(!empty($item->City))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->City()->first()->Arabic_Name :$item->City()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif
                                    </div>

                                                <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Place')}} </label>
                                       @if(!empty($item->Place))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->Place()->first()->Arabic_Name :$item->Place()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif
                                    </div>

                                                <div class="form-group col-lg-3">
                                        <label class="form-label" for="simpleinput">{{trans('admin.Nationality')}} </label>
                                       @if(!empty($item->Nationality))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->Nationality()->first()->Arabic_Name :$item->Nationality()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif
                                    </div>

                                             <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Tax_Registration_Number')}} </label>
                                    <input type="text" value="{{$item->Tax_Registration_Number}}"  class="form-control"  disabled>
                                </div>
                                             <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Tax_activity_code')}} </label>
                                    <input type="text" value="{{$item->Tax_activity_code}}"  class="form-control"  disabled>
                                </div>
                                             <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.work_nature')}} </label>

                                        @if($item->work_nature == 'P')

                                                  <input type="text" value="{{trans('admin.Person')}}"  class="form-control"  disabled>
                                        @elseif($item->work_nature == 'B')
                                                  <input type="text" value="{{trans('admin.Egyptian_trading_company')}}"  class="form-control"  disabled>
                                        @elseif($item->work_nature == 'F')
                                                  <input type="text" value="{{trans('admin.foreign_trading_company')}}"  class="form-control"  disabled>

                                        @endif

                                </div>
                                             <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Buliding_Num')}} </label>
                                    <input type="text" value="{{$item->Buliding_Num}}"  class="form-control"  disabled>
                                </div>
                                             <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Street')}} </label>
                                    <input type="text" value="{{$item->Street}}"  class="form-control"  disabled>
                                </div>
                                             <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Postal_Code')}} </label>
                                    <input type="text" value="{{$item->Postal_Code}}"  class="form-control"  disabled>
                                </div>
                                             <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.tax_magistrate')}} </label>
                                    <input type="text" value="{{$item->tax_magistrate}}"  class="form-control"  disabled>
                                </div>


                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Address')}} </label>
                                    <input type="text" value="{{$item->Address}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Activity')}}  </label>

                                                 @if(!empty($item->Activity))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->Activity()->first()->Arabic_Name :$item->Activity()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif

                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.ClientStatus')}}  </label>
                            @if(!empty($item->ClientStatus))
        <input type="text" value="{{app()->getLocale() == 'ar' ?$item->ClientStatus()->first()->Arabic_Name :$item->ClientStatus()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Platform')}}   </label>
                                             @if(!empty($item->Platform))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->Platform()->first()->Arabic_Name :$item->Platform()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Campagin')}}   </label>
                                             @if(!empty($item->Campagin))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->Campagin()->first()->Arabic_Name :$item->Campagin()->first()->English_Name}}"  class="form-control" disabled>
                                    @else
                              <input type="text"  class="form-control" disabled>
                                    @endif
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.ID_Number')}}   </label>
                                    <input type="text" value="{{$item->ID_Number}}"  class="form-control"  disabled>
                                </div>
                                   <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Birthdate')}}   </label>
                                    <input type="text" value="{{$item->Birthdate}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Qualifications')}}   </label>
                                    <input type="text" value="{{$item->Qualifications}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">{{trans('admin.Passport_Number')}}   </label>
                 <input type="text" value="{{$item->Passport_Number}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Social_Status')}}   </label>
                       <input type="text" value="{{$item->Social_Status}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Contract_Start')}}    </label>
                 <input type="text" value="{{$item->Contract_Start}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Contract_End')}}    </label>
                 <input type="text" value="{{$item->Contract_End}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Company_Name')}}    </label>
                                    <input type="text" value="{{$item->Company_Name}}"  class="form-control"  disabled>
                                </div>
                                       <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Warranty')}}    </label>
                                    <input type="text" value="{{$item->Warranty}}"  class="form-control"  disabled>
                                </div>
                                            <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.SearchCode')}}    </label>
                                    <input type="text" value="{{$item->SearchCode}}"  class="form-control"  disabled>
                                </div>

                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Repayment_Period')}}    </label>
                                    <input type="text" value="{{$item->Repayment_Period}}"  class="form-control"  disabled>
                                </div>


                                <div class="form-group col-lg-3">
                                <label class="form-label" for="">{{trans('admin.Commercial_Registration_No')}}  </label>
                        <input type="text" value="{{$item->Commercial_Registration_No}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                          <label class="form-label" for="">  {{trans('admin.Tax_Card_No')}}   </label>
             <input type="text" value="{{$item->Tax_Card_No}}"  class="form-control"  disabled>
                                </div>
                                              <div class="form-group col-lg-3">
                          <label class="form-label" for="">  {{trans('admin.Group')}}   </label>
                            @if(!empty($item->Group))
             <input type="text" value="{{app()->getLocale() == 'ar' ?$item->Group()->first()->Arabic_Name :$item->Group()->first()->English_Name}}"  class="form-control"  disabled>
                            @endif
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Bank_Account')}}   </label>
                                    <input type="text" value="{{$item->Bank_Account}}"  class="form-control"  disabled>
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for="">  {{trans('admin.Executions_Status')}}   </label>
                                      @if($item->Executions_Status == 'potential_client')
             <input type="text" value="{{trans('admin.potential_client')}}"  class="form-control" disabled>
                                    @elseif($item->Executions_Status == 'new_client')
              <input type="text" value="{{trans('admin.new_client')}}"  class="form-control" disabled>
                                    @elseif($item->Executions_Status == 'pending')
              <input type="text" value="{{trans('admin.pending')}}"  class="form-control" disabled>
                                    @elseif($item->Executions_Status == 'former')
              <input type="text" value="{{trans('admin.former')}}"  class="form-control" disabled>
                                    @elseif($item->Executions_Status == 'important')
              <input type="text" value="{{trans('admin.important')}}"  class="form-control" disabled>
                                    @endif
                                </div>
                                <div class="form-group col-lg-3">
                                    <label class="form-label" for=""> {{trans('admin.Image')}}     </label>
                                 <img src="{{URL::to($item->Image)}}" class="img-fluid">
                                </div>
                                        <div class="form-group col-lg-12">
                                    <label class="form-label" for=""> {{trans('admin.Client_Paper')}}     </label>
                            @php    $CustomersFiles=CustomersFiles::where('Customer',$item->id)->get();  @endphp
                                @foreach($CustomersFiles as $file)
                              <div class="col-md-3">
                  <a class="btn btn-default" href="{{Storage::url($file->File)}}" download>
                                           <i class="fal fa-file"> {{trans('admin.Download')}}</i>
                                                </a>
                                    </div>
                                @endforeach
                                </div>
                            </div>

                        <div class="modal-footer">

         <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Cancel')}} </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>


                  <!-- Modal Delete -->
            <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>
                                         {{app()->getLocale() == 'ar' ?$item->Name :$item->NameEn}}
                                        </strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteClients/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Modal Addresses -->
       <div class="modal fade" id="Addresses{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                 {{trans('admin.Addresses')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                          <div id="mobile-overflow">
         <table id="" aria-describedby=""class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>{{trans('admin.Name')}}</th>
                                                                        <th>{{trans('admin.Governrate')}}</th>
                                                                        <th>{{trans('admin.City')}}</th>
                                                                        <th>{{trans('admin.Place')}}</th>
                                                                         <th>{{trans('admin.Street')}}</th>
                                                                         <th>{{trans('admin.Buliding')}}</th>
                                                                         <th>{{trans('admin.Floor')}}</th>
                                                                         <th>{{trans('admin.Flat')}}</th>
                                                                         <th>{{trans('admin.Special_Mark')}} </th>
                                                                         <th>{{trans('admin.Location')}} </th>
                                                                         <th>{{trans('admin.Map')}} </th>
                                                                         <th>{{trans('admin.Address_Details')}} </th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dt">
                                @php     $CustomersAddresses=Addressses::where('Customer',$item->id)->get();   @endphp

                                        @foreach($CustomersAddresses as $cust)
                                             <tr>
                            <td>
                         {{$cust->Address_Name}}
                                </td>
                                <td>
                          @if(!empty($cust->Governrate()->first()->Arabic_Name))

                         {{app()->getLocale() == 'ar' ?$cust->Governrate()->first()->Arabic_Name :$cust->Governrate()->first()->English_Name}}
                                    @endif
                                </td>
                            <td>
                          @if(!empty($cust->City()->first()->Arabic_Name))

           {{app()->getLocale() == 'ar' ?$cust->City()->first()->Arabic_Name :$cust->City()->first()->English_Name}}
                                @endif
                                </td>

                                <td>
                          @if(!empty($cust->Place()->first()->Arabic_Name))

                  {{app()->getLocale() == 'ar' ?$cust->Place()->first()->Arabic_Name :$cust->Place()->first()->English_Name}}
                                    @endif
                               </td>

                                <td>
                             {{$cust->Street}}
                               </td>
                                <td>
                         {{$cust->Buliding}}
                               </td>
                                <td>
                       {{$cust->Floor}}
                               </td>
                                <td>
                      {{$cust->Flat}}
                               </td>
                                <td>
                           {{$cust->Special_Mark}}
                               </td>
                                <td>
                        {{$cust->Location}}
                               </td>

                                                 <td>
                                                     <iframe src="https://maps.google.com/maps?q={{$cust->Lat}},{{$cust->Lng}}&hl=en&z=14&amp;output=embed" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>




                                                 </td>
                                <td>
                             {{$cust->Details}}
                               </td>

                             </tr>
                                        @endforeach


                                                                    </tbody>

                                                                </table>
                                                                </div>

                        <div class="modal-footer">

         <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Cancel')}} </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>





@endforeach


                </main>




@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
   $(document).ready(function()
   {
       $(function()
       {
           $('.select2').select2();

           $(".select2-placeholder-multiple").select2(
           {
               placeholder: "Select State"
           });
           $(".js-hide-search").select2(
           {
               minimumResultsForSearch: 1 / 0
           });
           $(".js-max-length").select2(
           {
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items"
           });
           $(".select2-placeholder").select2(
           {
               placeholder: "Select a state",
               allowClear: true
           });

           $(".js-select2-icons").select2(
           {
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function(elm)
               {
                   return elm
               }
           });

           function icon(elm)
           {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
           }

           $(".js-data-example-ajax").select2(
           {
               ajax:
               {
                   url: "https://api.github.com/search/repositories",
                   dataType: 'json',
                   delay: 250,
                   data: function(params)
                   {
                       return {
                           q: params.term, // search term
                           page: params.page
                       };
                   },
                   processResults: function(data, params)
                   {
                       // parse the results into the format expected by Select2
                       // since we are using custom formatting functions we do not need to
                       // alter the remote JSON data, except to indicate that infinite
                       // scrolling can be used
                       params.page = params.page || 1;

                       return {
                           results: data.items,
                           pagination:
                           {
                               more: (params.page * 30) < data.total_count
                           }
                       };
                   },
                   cache: true
               },
               placeholder: 'Search for a repository',
               escapeMarkup: function(markup)
               {
                   return markup;
               }, // let our custom formatter work
               minimumInputLength: 1,
               templateResult: formatRepo,
               templateSelection: formatRepoSelection
           });

           function formatRepo(repo)
           {
               if (repo.loading)
               {
                   return repo.text;
               }

               var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                   "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                   "<div class='select2-result-repository__meta'>" +
                   "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

               if (repo.description)
               {
                   markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
               }

               markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                   "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                   "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                   "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                   "</div>" +
                   "</div></div>";

               return markup;
           }

           function formatRepoSelection(repo)
           {
               return repo.full_name || repo.text;
           }
       });
   });

</script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

