@extends('admin.index')
@section('content')

  <title>{{trans('admin.Tables')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Resturant')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Tables')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.Tables')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">

                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Table_Number')}}</th>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Place_Ar')}}</th>
                                                    <th>{{trans('admin.Place_En')}}</th>
                                                    <th>{{trans('admin.Chairs_Num')}}</th>
                                                    <th>{{trans('admin.QR')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Table_Number}}</td>
                                                    <td>{{$item->Arabic_Name}}</td>
                                                    <td>{{$item->English_Name}}</td>
                                                    <td>{{$item->Place_Ar}}</td>
                                                    <td>{{$item->Place_En}}</td>
                                                    <td>{{$item->Chairs_Num}}</td>
                                                    <td>


                                                      @php
                                    $x=$item->QR;

                                    $z=DNS2D::getBarcodePNG("$x", 'QRCODE',100,100);


                                    @endphp

                                         <a href="data:image/png;base64,{{$z}}" download>       <img src="data:image/png;base64,{{$z}}" width="100%" height="100%" alt="QR" />  </a>


                                                    </td>

                                                    <td class="text-center">


                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>



                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>


                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                  <th>{{trans('admin.Table_Number')}}</th>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Place_Ar')}}</th>
                                                    <th>{{trans('admin.Place_En')}}</th>
                                                    <th>{{trans('admin.Chairs_Num')}}</th>
                                                    <th>{{trans('admin.QR')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Add-->
                    <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('AddTables')}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                        <div class="form-row">



                                        <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                            <input type="text" name="Arabic_Name" value="{{old('Arabic_Name')}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                         <input type="text" name="English_Name"  value="{{old('English_Name')}}" class="form-control" >
                                        </div>


                                                                 <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Place_Ar')}}</label>
                                            <input type="text" name="Place_Ar" value="{{old('Place_Ar')}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Place_En')}}</label>
                         <input type="text" name="Place_En"  value="{{old('Place_En')}}" class="form-control" >
                                        </div>



                                              <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Table_Number')}}</label>
                                            <input type="number" name="Table_Number" value="{{old('Table_Number')}}"  class="form-control" required>
                                        </div>

                                              <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Chairs_Num')}}</label>
                                            <input type="number" name="Chairs_Num" value="{{old('Chairs_Num')}}"  class="form-control" required>
                                        </div>




                                                      <div class="form-group col-lg-12" style="display: none">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.QR')}}</label>
                         <input type="text" name="QR"  value="{{old('QR')}}" class="form-control" >
                                        </div>






                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>



         @foreach($items as $item)
        <!-- Modal Edit-->
                    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('EditTables/'.$item->id)}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                        <div class="form-row">
                                               <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Arabic_Name')}}</label>
                                            <input type="text" name="Arabic_Name" value="{{$item->Arabic_Name}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                         <input type="text" name="English_Name"  value="{{$item->English_Name}}" class="form-control" >
                                        </div>


                                                                 <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Place_Ar')}}</label>
                                            <input type="text" name="Place_Ar" value="{{$item->Place_Ar}}"  class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-6">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.Place_En')}}</label>
                         <input type="text" name="Place_En"  value="{{$item->Place_En}}" class="form-control" >
                                        </div>



                                              <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Table_Number')}}</label>
                                            <input type="number" name="Table_Number" value="{{$item->Table_Number}}"  class="form-control" required>
                                        </div>

                                              <div class="form-group col-lg-6">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Chairs_Num')}}</label>
                                            <input type="number" name="Chairs_Num" value="{{$item->Chairs_Num}}"  class="form-control" required>
                                        </div>




                                                      <div class="form-group col-lg-12" style="display: none">
                                     <label class="form-label" for="simpleinput"> {{trans('admin.QR')}}</label>
                         <input type="text" name="QR"  value="{{$item->QR}}" class="form-control" >
                                        </div>



                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                      <!-- Modal Delete -->
                      <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>     {{app()->getLocale() == 'ar' ?$item->Arabic_Name :$item->English_Name}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteTables/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
        @endforeach
                </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
   <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

