@extends('admin.index')
@section('content')
@php
use App\Models\ProductSalesOrder;
use App\Models\CompanyData;
use App\Models\GeneralDaily;
$Def=CompanyData::orderBy('id','desc')->first();
use App\Models\DefaultDataShowHide;
$show=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp
  <title>{{trans('admin.Orders')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Resturant')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.Orders')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

            <!-- Data -->
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.SalesOrderSechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                              <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
        <table id="dt-basic-example" class="table table-bordered table-hover table-striped " style="width:120%;">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th> {{trans('admin.Draw')}} </th>
                                                    <th> {{trans('admin.Payment_Method')}}</th>
                                                    <th>{{trans('admin.Status')}} </th>
                                                    <th> {{trans('admin.Executor')}} </th>
                                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>
                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Client')}} </th>
                                                    <th> {{trans('admin.Delegate')}} </th>
                                                    <th> {{trans('admin.Store')}} </th>
                                                    <th> {{trans('admin.Later_Due')}} </th>
                                                    <th> {{trans('admin.Sale_Date')}} </th>
                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                    <th> {{trans('admin.User')}} </th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Address')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Time}}</td>
                                                    <td>{{$item->Date}}</td>

                                                      <td>{{$item->Draw}}</td>
                                                    <td>

                                                    @if($item->Payment_Method == 'Cash')
                                                       {{trans('admin.Cash')}}
                                                    @elseif($item->Payment_Method == 'Later')
                                                       {{trans('admin.Later')}}
                                                    @elseif($item->Payment_Method == 'Installment')

                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Installment{{$item->id}}">{{trans('admin.Installment')}} </button>
                                                    @endif
                                                    </td>
                                                        <td>

                                                         @if($item->Delivery_Status == 0)
                                                       <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delivery_Status{{$item->id}}">{{trans('admin.Pending')}} </button>
                                                    @elseif($item->Status == 1)
                                         <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delivery_Status{{$item->id}}">{{trans('admin.Processing')}} </button>
                                                    @elseif($item->Status == 2)
                                             <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delivery_Status{{$item->id}}">{{trans('admin.Recived')}} </button>
                                                    @endif
                                                    </td>
                                                        <td>
                                                            @if(!empty($item->Executor()->first()->Name))


                                                                {{app()->getLocale() == 'ar' ?$item->Executor()->first()->Name :$item->Executor()->first()->NameEn}}
                                                    @endif
                                                    </td>
                                                        <td>{{$item->Refernce_Number}}</td>
                                                        <td>{{$item->Note}}</td>

                                                      <td>
                                                          @if(!empty($item->Safe()->first()->Name))


                                                              {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}
                                                          @endif

                                                       </td>
                                                        <td>
                                                            @if(!empty($item->Client()->first()->Name))


                                                                {{app()->getLocale() == 'ar' ?$item->Client()->first()->Name :$item->Client()->first()->NameEn}}
                                                            @endif

                                                    </td>
                                                        <td>

                                                            @if(!empty($item->Delegate()->first()->Name))


                                                                {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                            @endif

                                                    </td>
                                                        <td>
                                                            @if(!empty($item->Store()->first()->Name))


                                                                {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                            @endif

                                                    </td>
                                                           <td>{{$item->Later_Due}}</td>
                                                    <td>{{$item->Sale_Date}}</td>
                                                        <td>
                                                            @if(!empty($item->Coin()->first()->Arabic_Name))


                                                                {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                            @endif


                                                    </td>
                                                            <td>
                                                                @if(!empty($item->Cost_Center()->first()->Arabic_Name))


                                                                    {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                                                @endif

                                                    </td>
                                                             <td>
                                                                 @if(!empty($item->User()->first()->name))


                                                                     {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                                 @endif

                                                    </td>

                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>
                                                     <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Address{{$item->id}}">
                                                            {{trans('admin.Address')}}
                                                        </button>
                                                    </td>

                                                    <td class="text-center">

                        <a href="{{url('SalesOrderPrint/'.$item->id)}}" class="btn btn-default" >
                                                    <i class="fal fa-print"></i>
                                                    </a>

                         @if($item->ToSales != 1)


                                 @can('حذف امر البيع')
            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                                 @endcan

                            @can('تعديل امر البيع')

                            <form action="{{url('EditSalesOrderResturant')}}" method="get">
                                <input type="hidden" name="OrderID" value="{{$item->id}}">
                        <button type="submit" class="btn btn-default" ><i class="fal fa-edit"></i></button>
                            </form>

                            @endcan

                            @endif

                                                    </td>
                                                </tr>
                                                @endforeach

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Time')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th> {{trans('admin.Draw')}} </th>
                                                    <th> {{trans('admin.Payment_Method')}}</th>
                                                    <th>{{trans('admin.Status')}} </th>
                                                    <th> {{trans('admin.Executor')}} </th>
                                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>
                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Client')}} </th>
                                                    <th> {{trans('admin.Delegate')}} </th>
                                                    <th> {{trans('admin.Store')}} </th>
                                                    <th> {{trans('admin.Later_Due')}} </th>
                                                    <th> {{trans('admin.Sale_Date')}} </th>
                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                    <th> {{trans('admin.User')}} </th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Address')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </tfoot>

                                        </table>

                                        {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>

  @foreach($items as $item)

                  <!-- Modal Delete -->
    <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                         {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                                    <a href="{{url('DeleteSalesOrder/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>


                        <!-- Modal Details -->
    <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=ProductSalesOrder::where('SalesOrder',$item->id)->get();
                @endphp
                        <div class="mt-3">
                             <div style="overflow:auto">
                            <table id=""
                            class="table table-bordered table-hover table-striped" style="width:160%">
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                                @if($show->Patch_Number == 1)
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                            @endif
                                    <th>{{trans('admin.Name')}} </th>
                                            <th>{{trans('admin.Group')}} </th>
                                    <th>{{trans('admin.Brand')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.AvQty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                                     @if($show->Patch_Number == 1)
                                         <td>{{$detail->Patch_Number}}</td>
                                            @endif
                                    <td>
                                        {{$detail->Product()->first()->P_Ar_Name}}

                                @if(!empty($detail->V1))    ({{$detail->V1()->first()->Name}})  @endif
                                  @if(!empty($detail->V2))    ({{$detail->V2()->first()->Name}})  @endif
                                    </td>
                                                <td>
                                       {{$detail->Product()->first()->Group()->first()->Name}}
                                    </td>
                                         <td>
                                            @if(!empty($detail->Product()->first()->Brand))
                                       {{$detail->Product()->first()->Brand()->first()->Name}}
                                            @endif
                                    </td>
                                    <td>{{$detail->Unit()->first()->Name}}</td>
                                    <td>{{$detail->AvQty}}</td>
                                    <td>{{$detail->Qty}}</td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>{{$detail->Store()->first()->Name}}</td>
                                    <td>{{$detail->Exp_Date}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                        </table>
                        </div>
                         <div style="overflow:auto">
                        <table class="table table-bordered table-hover table-striped mt-4" style="width:140%">
                            <tbody>
                                <tr>
                                    <td>{{trans('admin.Product_Numbers')}}</td>
                                    <td>{{$item->Product_Numbers}}</td>

                                    <td>{{trans('admin.Total_Qty')}}</td>
                                    <td>{{$item->Total_Qty}}</td>

                                    <td>{{trans('admin.Total_Discount')}}</td>
                                    <td>{{$item->Total_Discount}}</td>

                                     <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                    <td>{{$item->Total_BF_Taxes}}</td>

                                    <td>{{trans('admin.Total_Taxes')}}</td>
                                    <td>{{$item->Total_Taxes}}</td>

                                        <td>{{trans('admin.CuponCode')}}</td>
                                    <td>{{$item->CuponCode}}</td>


                                        <td>{{trans('admin.Shipping')}}</td>
                                    <td>{{$item->Shipping}}</td>



                                    <td>{{trans('admin.Total_Price')}}</td>
                                    <td>{{$item->Total_Price}}</td>

                                    <td>{{trans('admin.Paid')}}</td>
                                    <td>{{$item->Pay}}</td>

                                </tr>
                            </tbody>
                        </table>
                        </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                            <a class="btn btn-primary" href="#" onclick="window.print()"> <i class="fal fa-print"></i> {{trans('admin.Print')}}</a>
                        </div>
                    </div>
                </div>
            </div>

            </div>

                                <!-- Modal Address -->
    <div class="modal fade" id="Address{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Address')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">

                        <div class="mt-3">
                             <div style="overflow:auto">
                            <table id=""
                            class="table table-bordered table-hover table-striped" style="width:160%">
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.Email')}} </th>
                                    <th>{{trans('admin.Phone')}} </th>
                                    <th>{{trans('admin.Other_Phone')}} </th>
                                    <th>{{trans('admin.Address_Name')}} </th>
                                    <th>{{trans('admin.Special_Mark')}} </th>
                                    <th>{{trans('admin.Street')}} </th>
                                    <th>{{trans('admin.Buliding')}} </th>
                                    <th>{{trans('admin.Floor')}} </th>
                                    <th>{{trans('admin.Flat')}} </th>
                                    <th>{{trans('admin.Governrate')}} </th>
                                    <th>{{trans('admin.City')}} </th>
                                    <th>{{trans('admin.Place')}} </th>
                                    <th>{{trans('admin.Location')}} </th>
                                    <th>{{trans('admin.Address_Details')}} </th>

                                </tr>
                            </thead>
                            <tbody id="">
                      <tr>
                        <td>{{$item->Name}}</td>
                        <td>{{$item->Email}}</td>
                        <td>{{$item->Phone}}</td>
                        <td>{{$item->OtherPhone}}</td>
                        <td>{{$item->Address_Name}}</td>
                        <td>{{$item->Special_MarkAdd}}</td>
                        <td>{{$item->StreetAdd}}</td>
                        <td>{{$item->BulidingAdd}}</td>
                        <td>{{$item->FloorAdd}}</td>
                        <td>{{$item->FlatAdd}}</td>
                        <td>

                            @if(!empty($item->Governrate()->first()->Arabic_Name))


                                {{app()->getLocale() == 'ar' ?$item->Governrate()->first()->Arabic_Name :$item->Governrate()->first()->English_Name}}
                            @endif

                          </td>
                        <td>
                            @if(!empty($item->City()->first()->Arabic_Name))


                                {{app()->getLocale() == 'ar' ?$item->City()->first()->Arabic_Name :$item->City()->first()->English_Name}}
                            @endif

                               </td>
                        <td>
                            @if(!empty($item->Place()->first()->Arabic_Name))


                                {{app()->getLocale() == 'ar' ?$item->Place()->first()->Arabic_Name :$item->Place()->first()->English_Name}}
                            @endif


                          </td>
                        <td>{{$item->LocationAdd}}</td>
                        <td>{{$item->Address_DetailsAdd}}</td>
                      </tr>
                            </tbody>
                        </table>
                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            </div>


                             <!-- Modal Delivery_Status -->
    <div class="modal fade" id="Delivery_Status{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Status')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <form action="{{url('ChangeStatusShop')}}" method="post">
                            @csrf

                        <div class="modal-body">
             <input type="hidden" name="ID" value="{{$item->id}}">
                            <select class="select2 form-control" name="Delivery_Status" required>
            <option value="0" @if($item->Delivery_Status == 0) selected @endif>{{trans('admin.Pending')}} </option>
            <option value="1" @if($item->Delivery_Status == 1) selected @endif>{{trans('admin.Processing')}}</option>
            <option value="2" @if($item->Delivery_Status == 2) selected @endif>{{trans('admin.Recived')}}</option>
                            </select>

                        <div class="modal-footer">
                 <button type="submit" class="btn btn-secondary">{{trans('admin.Submit')}}</button>
                 <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                         </form>
                </div>
            </div>

            </div>

               <!-- Modal Installment -->
    <div class="modal fade" id="Installment{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">

                                    <div class="row">
                                                <div class="col-md-3">
                                            <label>{{trans('admin.Presenter')}}</label>
                                                <span>{{$item->presenter}}</span>
                                                    </div>

                                                          <div class="col-md-3">
                                            <label>{{trans('admin.annual_interest')}}</label>
                                                <span>{{$item->annual_interest}}</span>
                                                    </div>

                                                          <div class="col-md-3">
                                            <label>{{trans('admin.monthly_installment')}}</label>
                                                <span>{{$item->monthly_installment}}</span>
                                                    </div>

                                                          <div class="col-md-3">
                                            <label>{{trans('admin.Years_Number')}}</label>
                                                <span>{{$item->Years_Number}}</span>
                                                    </div>

                                                          <div class="col-md-3">
                                            <label>{{trans('admin.total')}}</label>
                                                <span>{{$item->total}}</span>
                                                    </div>

                                                          <div class="col-md-3">
                                            <label>{{trans('admin.installment_Num')}}</label>
                                                <span>{{$item->installment_Num}}</span>
                                                    </div>

                                                          <div class="col-md-3">
                                            <label>{{trans('admin.Date_First_installment')}}</label>
                                                <span>{{$item->Date_First_installment}}</span>
                                                    </div>

                                                        </div>



                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>

@endforeach



@endsection


@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

	<style>
	@media print {
		body * {
			visibility: hidden;
		}
		.modal-content * {
			visibility: visible;
			overflow: visible;
		}
		.main-page * {
			display: none;
		}
		.modal {
			position: absolute;
			left: 0;
			top: -180px;
			margin: 0;
			padding: 0;
			min-height: 550px;
			visibility: visible;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}
		.modal-dialog {
			visibility: visible !important;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}

		.page-content{
		    display:none;
		}
         @page {

		size: a4;

    }

	}
	</style>

    <!-- Search Selecet -->
<script>
    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                    data: function (params) {
                        var query = {
                            search: params.term,
                        };
                        if (params.term == "*") query.items = [];
                        return { json: JSON.stringify(query) };
                    },
                },
            });

            $("#Emp").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });
        });
    });
</script>



@endpush
