@extends('admin.index')
@section('content')
@php
use App\Models\ProductSales;
use App\Models\ReturnSalesProducts;
use App\Models\ReturnPurchProducts;
use App\Models\ProductsPurchases;
use App\Models\ProductsStartPeriods;
use App\Models\ProductsStoresTransfers;
use App\Models\ProductsReturnMaintainceBill;
use App\Models\ProductMaintaincBill;
use App\Models\ProductSettlement;
use App\Models\ProductsConsists;
use App\Models\ProductsExecutingReceiving;
use App\Models\CompanyData;
use App\Models\DefaultDataShowHide;
$Def=CompanyData::orderBy('id','desc')->first();
$show=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp
 <title>{{trans('admin.StoresMovesReport')}}</title>

               
     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Report')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.StoresMovesReport')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block">
                        <span class="js-get-date"></span></li>
                    </ol>
                    
                    <!-- data entry -->
          
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                 <div class="modal-body">
                                    <div data-size="A4">
                                       <div class="row invoive-info" style="margin-bottom:20px;">
                                            <div style="text-align: center;" class="col-md-4 col-sm-4 col-4 invoice-client-info">
                                                <div class="style-info">
                                                    <h1 style="text-align: center;" class="m-0">
                                               @if(!empty($Def->Name))
                      {{app()->getLocale() == 'ar' ?$Def->Name :$Def->NameEn}}
                      @else
                       {{trans('admin.Klar')}}
                      @endif         
                                                    </h1>
                              <h3 style="text-align: center;" class="m-10">
                         @if(!empty($Def->Print_Text))
                   {{app()->getLocale() == 'ar' ?$Def->Print_Text :$Def->Print_Text_En}}     
                      @endif                
                                                    </h3>
                                                </div>
                                            </div>
                                            <div style="text-align: center;" class="col-md-4 col-sm-4 col-4 invoice-client-info">
             
              <h1>{{trans('admin.StoresMovesReport')}}</h1>
                   
                                            </div>
                                   <div style="text-align: center;" class="col-md-4 col-sm-4 col-4 invoice-client-info">
                         <div class="style-info">
                       @if(!empty($Def->Logo))         
    <img style="height: 50px; " class="img-fluid" src="{{URL::to($Def->Logo)}}" alt="Logo" />
                                       
                    @else  
 <img style="height: 50px; " class="img-fluid" src="https://klarerp.com/site/img/theme/logo.png" alt="Logo" />
                      @endif
               
                             
            <input type="checkbox" id="CHANGE" class="form-control m-2 m2 no-print" onclick="ChangeClass()"><span class="no-print">{{trans('admin.PrintDetails')}}  </span>              
                                       </div>
                                            </div>
                                        </div>
                                        <hr />
                                        <div class="row"></div>
                                      
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="table-responsive-lg">
                                
                                  <div style="overflow:auto;">
                     <table  class="table table-bordered table-hover w-100 table-striped ">
                        <thead class="bg-highlight">
                           <tr>
                               @if($colum->Date == 1)
                              <th>{{trans('admin.Date')}}</th>
                               @endif

                                   @if($colum->Code == 1)
                              <th>{{trans('admin.Code')}}</th>
                               @endif
                               
                                 @if($colum->Time == 1)
                              <th>{{trans('admin.Time')}}</th>
                               @endif
                               
                                   @if($colum->Branch == 1)
                              <th>{{trans('admin.Branch')}}</th>
                               @endif
                               
                                   @if($colum->Store == 1)
                              <th>{{trans('admin.Store')}}</th>
                               @endif
                               
                                      @if($colum->Safe == 1)
                              <th>{{trans('admin.Safe')}}</th>
                               @endif
                               
                               
                                   @if($colum->Type == 1)
                              <th>{{trans('admin.Type')}}</th>
                               @endif
                               
                                   @if($colum->Cost_Center == 1)
                              <th>{{trans('admin.Cost_Center')}}</th>
                               @endif
                               
                                   @if($colum->User == 1)
                              <th>{{trans('admin.User')}}</th>
                               @endif
                               
                                   @if($colum->Coin == 1)
                              <th>{{trans('admin.Coin')}}</th>
                               @endif
                               
                                   @if($colum->Note == 1)
                              <th>{{trans('admin.Note')}}</th>
                               @endif
                               
                                   @if($colum->Total_Qty == 1)
                              <th>{{trans('admin.Total_Qty')}}</th>
                               @endif
                               
                                   @if($colum->Total_Price == 1)
                              <th>{{trans('admin.Total_Price')}}</th>
                               @endif
                               
                                   @if($colum->Account == 1)
                              <th>{{trans('admin.Account')}}</th>
                               @endif
                               
                                   @if($colum->Ship == 1)
                              <th>{{trans('admin.Ship')}}</th>
                               @endif

                              <th>{{trans('admin.Actions')}}</th>
                           </tr>
                        </thead>
                        <tbody>
                         @foreach($items as $item)
                                    @if($item->Type == 'بدايه فتره')
                                             @php
                              $details=ProductsStartPeriods::where('SP_ID',$item->ID)->paginate(100);   
                            @endphp
                                       @elseif($item->Type == 'مشتريات')
                                            @php
                              $details=ProductsPurchases::where('Purchase',$item->ID)->get(); 
                            @endphp
                                          
                               @elseif($item->Type == 'مرتجع مشتريات')
                                             @php
                        
                              $details=ReturnPurchProducts::where('Return',$item->ID)->get(); 
                
                            @endphp
                                  
                              @elseif($item->Type == 'مبيعات')
                                            @php
                              $details=ProductSales::where('Sales',$item->ID)->get(); 
                             
                            @endphp
                                         
                               @elseif($item->Type == 'مرتجع مبيعات')
                                            @php
                            
                              $details=ReturnSalesProducts::where('Return',$item->ID)->get(); 
                            
                            @endphp
                                      
                               @elseif($item->Type == 'صيانه')
                                            @php
                             
                              $details=ProductMaintaincBill::where('Maintaince',$item->ID)->get();    
                            @endphp
                                      
                              @elseif($item->Type == 'مرتجع صيانه')
                                            @php
                           
                              $details=ProductsReturnMaintainceBill::where('Return',$item->ID)->get(); 
                         
                            @endphp
                                            
                             @elseif($item->Type == 'مدخلات تصنيع')
                                            @php
           
                              $details=ProductsExecutingReceiving::where('Executing',$item->ID)->get(); 
        
                            @endphp
                                           @elseif($item->Type == 'مخرجات تصنيع')
                                                              @php
           
                              $details=ProductsExecutingReceiving::where('Executing',$item->ID)->get(); 
        
                            @endphp
                                          
                             @elseif($item->Type == 'توالف')
                                             @php
                     
                              $details=ProductsConsists::where('Consist_ID',$item->ID)->get(); 
                               
                            @endphp
                                          @elseif($item->Type == 'تحويلات مخازن الي')
                                            @php
                            
                              $details=ProductsStoresTransfers::where('ST_ID',$item->ID)->get(); 
                             
                            @endphp
                                               @elseif($item->Type == 'تحويلات مخازن من')
                                                          @php
                            
                              $details=ProductsStoresTransfers::where('ST_ID',$item->ID)->get(); 
                             
                            @endphp
                                         
                            
                            @elseif($item->Type == 'تسويه')
                            @php
                             
                              $details=ProductSettlement::where('Set_ID',$item->ID)->get(); 
                             
                            @endphp
                                    @endif  
                    
                               <tr>
                                     @if($colum->Date == 1)
                                   <td>{{$item->Date}}</td>
                                   @endif
                                   
                                         @if($colum->Code == 1)
                                   <td>{{$item->Code}}</td>
                                   @endif
                                   
                                         @if($colum->Time == 1)
                                   <td>{{$item->Time}}</td>
                                   @endif
                                   
                                         @if($colum->Branch == 1)
                                 <td>@if(!empty($item->Branch()->first()->Arabic_Name)) 
                                     
                                   {{app()->getLocale() == 'ar' ?$item->Branch()->first()->Arabic_Name :$item->Branch()->first()->English_Name}}      
                                     
                                     @endif</td>
                                   @endif
                                   
                                         @if($colum->Store == 1)
                                   <td>@if(!empty($item->Store()->first()->Name))  
                                       
                                     {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}        
                                       
                                       @endif</td>
                                   @endif
                                   
                                              @if($colum->Safe == 1)
                                   <td>@if(!empty($item->Safe()->first()->Name)) 
                                       
                                         {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}   
                                       @endif</td>
                                   @endif
                                   
                                         @if($colum->Type == 1)
                                   <td>
                                       {{app()->getLocale() == 'ar' ?$item->Type :$item->TypeEn}}  
                                   </td>
                                   @endif
                                   
                                         @if($colum->Cost_Center == 1)
                                   <td>@if(!empty($item->Cost_Center))
                                       
                                            {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}   
                                       @endif</td>
                                   @endif
                                   
                                         @if($colum->User == 1)
                            
                                   <td>@if(!empty($item->User))
                                       
                                         {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}    
                                       
                                       @endif</td>

                                   @endif
                                   
                                   
                                     @if($colum->Coin == 1)
                                   <td>@if(!empty($item->Coin)) 
                                       
                                       
                                          {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}   
                                       @endif</td>
                                   @endif
                                   
                                         @if($colum->Note == 1)
                                   <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Note{{$item->id}}">
                                                            {{trans('admin.Note')}}
                                                        </button>
                                   </td>
                                   @endif
                                   
                                         @if($colum->Total_Qty == 1)
                                   <td>{{$item->Total_Qty}}</td>
                                   @endif 
                                   
                                   @if($colum->Total_Price == 1)
                                   <td>{{$item->Total_Price}}</td>
                                   @endif
                                   
                                         @if($colum->Account == 1)
                                       <td>@if(!empty($item->Account)) 
                                           
                                     {{app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn}}            
                                           
                                           @endif</td>
                                   @endif
                                   
                                         @if($colum->Ship == 1)
                                <td>@if(!empty($item->Ship)) 
                                    
                                 {{app()->getLocale() == 'ar' ?$item->Ship()->first()->Name :$item->Ship()->first()->NameEn}}     
                                    
                                    @endif</td>
                                   @endif 
                                   
                            
                                            <td>
                                           
                                                 @if($item->Type == 'بدايه فتره')
                                  <a href="{{url('StartPeriodPrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   
  <a href="{{url('EditStartPeriod/'.$item->ID)}}" class="btn btn-default" target="_blank" ><i class="fal fa-edit"></i></a> 
                                       @elseif($item->Type == 'مشتريات')
                                    <a href="{{url('PurchPrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   
  <a href="{{url('EditPuechasesBill/'.$item->ID)}}" class="btn btn-default" target="_blank" ><i class="fal fa-edit"></i></a> 
        
                                     @elseif($item->Type == 'مبيعات')
                                                                       <a href="{{url('SalesPrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   
  <a href="{{url('ESBill/'.$item->ID)}}" class="btn btn-default" target="_blank" ><i class="fal fa-edit"></i></a> 
                                         @elseif($item->Type == 'مرتجع مبيعات')
                                    <a href="{{url('ReturnSalesPrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   
                                          @elseif($item->Type == 'صيانه')
                     <a href="{{url('ReciptMaintaincePrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   
                                               @elseif($item->Type == 'مرتجع صيانه')
                                                                       <a href="{{url('ReturnMaintaincePrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   

                      
                                               @elseif($item->Type == 'تحويلات مخازن الي')
                                                                       <a href="{{url('StoresTransferPrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   
  <a href="{{url('EditStoreTransfer/'.$item->ID)}}" class="btn btn-default" target="_blank" ><i class="fal fa-edit"></i></a> 
                                         @elseif($item->Type == 'تحويلات مخازن من')
                                                                       <a href="{{url('StoresTransferPrint/'.$item->ID)}}" class="btn btn-default" target="_blank" >
                                                    <i class="fal fa-print"></i>    
                                                    </a>   
  <a href="{{url('EditStoreTransfer/'.$item->ID)}}" class="btn btn-default" target="_blank" ><i class="fal fa-edit"></i></a> 
            
                                                
                                                
                                        @endif        
                                                
                                    <button type="button" class="btn btn-default " data-toggle="collapse" data-target="#collapseExample{{$item->id}}" aria-expanded="true" aria-controls="collapseExample">
                                 <a data-toggle="tooltip" data-placement="top" title="  المزيد">
                            <i class="fal fa-arrow-circle-down"></i>   
                                </a>     
                         </button>     
                               </td>
                            </tr>  
                            <tr>  
                              <td colspan="23"> 
                                 <div class="collapse " id="collapseExample{{$item->id}}" style="background:white">
                                       <table class="">
                                                        
                                         @if($item->Type == 'بدايه فتره')
                                             <tr>
                                     <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.P_Code')}} </th>
                                    <th>{{trans('admin.Patch_Number')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                    <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                </tr>
                                <tbody id="">
                                
                            @foreach($details as $pro)    
                                <tr>
                                    <td>
                                    
                                              {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}} 
                                                        
                                                @if(!empty($pro->V1))    {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}}   @endif        
                                                @if(!empty($pro->V2))    {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}}   @endif  
                                        
                                        
                   @if(!empty($pro->Product()->first()->Space))   ({{$pro->Product()->first()->Space}}) @endif                       
                   @if(!empty($pro->Product()->first()->Storage))   ({{$pro->Product()->first()->Storage}}) @endif                       
                   @if(!empty($pro->Product()->first()->Processor))   ({{$pro->Product()->first()->Processor}}) @endif                       
                   @if(!empty($pro->Product()->first()->Camera))   ({{$pro->Product()->first()->Camera}}) @endif                       
                   @if(!empty($pro->Product()->first()->Screen))   ({{$pro->Product()->first()->Screen}}) @endif                       
                   @if(!empty($pro->Product()->first()->OS))   ({{$pro->Product()->first()->OS}}) @endif                       
                   @if(!empty($pro->Product()->first()->Battery))   ({{$pro->Product()->first()->Battery}}) @endif                       
                   @if(!empty($pro->Product()->first()->Warranty))   ({{$pro->Product()->first()->Warranty}}) @endif                       
                   @if(!empty($pro->Product()->first()->Color))   ({{$pro->Product()->first()->Color}}) @endif                       
                   @if(!empty($pro->Product()->first()->Category))   ({{$pro->Product()->first()->Category}}) @endif                       
                   @if(!empty($pro->Product()->first()->Model))   ({{$pro->Product()->first()->Model}}) @endif                       
                                    </td>
                                    <td>{{$pro->P_Code}}</td>
                                     <td>{{$pro->Patch_Number}}</td>
                                     <td>{{$pro->Exp_Date}}</td>
                                       <td>
                                    
                                 {{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}         
                                    </td>
                                        <td>{{$pro->Qty}}</td>
                                       <td>{{$pro->Price}}</td>
                                       <td>{{$pro->Total}}</td>
                                </tr>
                        @endforeach        
                            </tbody>
                                          @elseif($item->Type == 'مشتريات')
                                             <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.Group')}} </th>
                                    <th>{{trans('admin.Brand')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                    <th>{{trans('admin.Later_Due')}} </th>
                                </tr>
                                           <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>
                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}} 
                                                        
                                                @if(!empty($detail->V1))    {{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}   @endif        
                                                @if(!empty($detail->V2))    {{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}   @endif    
                    @if(!empty($detail->Product()->first()->Space))   ({{$detail->Product()->first()->Space}}) @endif                       
                   @if(!empty($detail->Product()->first()->Storage))   ({{$detail->Product()->first()->Storage}}) @endif                       
                   @if(!empty($detail->Product()->first()->Processor))   ({{$detail->Product()->first()->Processor}}) @endif                       
                   @if(!empty($detail->Product()->first()->Camera))   ({{$detail->Product()->first()->Camera}}) @endif                       
                   @if(!empty($detail->Product()->first()->Screen))   ({{$detail->Product()->first()->Screen}}) @endif                       
                   @if(!empty($detail->Product()->first()->OS))   ({{$detail->Product()->first()->OS}}) @endif                       
                   @if(!empty($detail->Product()->first()->Battery))   ({{$detail->Product()->first()->Battery}}) @endif                       
                   @if(!empty($detail->Product()->first()->Warranty))   ({{$detail->Product()->first()->Warranty}}) @endif                       
                   @if(!empty($detail->Product()->first()->Color))   ({{$detail->Product()->first()->Color}}) @endif                       
                   @if(!empty($detail->Product()->first()->Category))   ({{$detail->Product()->first()->Category}}) @endif                       
                   @if(!empty($detail->Product()->first()->Model))   ({{$detail->Product()->first()->Model}}) @endif  
                                    </td>
                                    <td>
                            {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn}}  
                                        
                                        
                                    </td>
                                         <td>
                                            @if(!empty($detail->Product()->first()->Brand)) 
                                       {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Brand()->first()->Name :$detail->Product()->first()->Brand()->first()->NameEn}} 
                                            @endif 
                                    </td>
                                    
                                    <td>              {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}   </td>
                                    <td>
    
                                         {{$detail->Qty}}
                            
                                    </td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>       {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}       </td>
                                    <td>{{$detail->Exp_Date}}</td>
                                    <td>{{$detail->Later_Due}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                                        @elseif($item->Type == 'مرتجع مشتريات')
                                             <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                            <th>{{trans('admin.Group')}} </th>
                                    <th>{{trans('admin.Brand')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Original_Qty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Return_Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                                           <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>
                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}   
                                  
                                    
                                @if(!empty($detail->V1))    
                                  
                                       {{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}} 
                                  @endif 
                                  @if(!empty($detail->V2))    
                                  
                                      {{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}} 
                                  @endif  
                                               @if(!empty($detail->Product()->first()->Space))   ({{$detail->Product()->first()->Space}}) @endif                       
                   @if(!empty($detail->Product()->first()->Storage))   ({{$detail->Product()->first()->Storage}}) @endif                       
                   @if(!empty($detail->Product()->first()->Processor))   ({{$detail->Product()->first()->Processor}}) @endif                       
                   @if(!empty($detail->Product()->first()->Camera))   ({{$detail->Product()->first()->Camera}}) @endif                       
                   @if(!empty($detail->Product()->first()->Screen))   ({{$detail->Product()->first()->Screen}}) @endif                       
                   @if(!empty($detail->Product()->first()->OS))   ({{$detail->Product()->first()->OS}}) @endif                       
                   @if(!empty($detail->Product()->first()->Battery))   ({{$detail->Product()->first()->Battery}}) @endif                       
                   @if(!empty($detail->Product()->first()->Warranty))   ({{$detail->Product()->first()->Warranty}}) @endif                       
                   @if(!empty($detail->Product()->first()->Color))   ({{$detail->Product()->first()->Color}}) @endif                       
                   @if(!empty($detail->Product()->first()->Category))   ({{$detail->Product()->first()->Category}}) @endif                       
                   @if(!empty($detail->Product()->first()->Model))   ({{$detail->Product()->first()->Model}}) @endif  
                                    </td>
                                                <td>
                          {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn}}  
                                    </td>
                                         <td>
                                            @if(!empty($detail->Product()->first()->Brand)) 
                                    {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Brand()->first()->Name :$detail->Product()->first()->Brand()->first()->NameEn}} 
                                            @endif 
                                    </td>
                                    <td>           {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}    </td>
                                    <td>{{$detail->Original_Qty}}</td>
                                    <td>{{$detail->Qty}}</td>
                                    <td>{{$detail->Return_Qty}}</td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>   {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}       </td>
                                    <td>{{$detail->Exp_Date}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                                       @elseif($item->Type == 'مبيعات')
                                             <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                    <th>{{trans('admin.Name')}} </th>
                                            <th>{{trans('admin.Group')}} </th>
                                    <th>{{trans('admin.Brand')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.AvQty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                                           <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                      
                                         <td>{{$detail->Patch_Number}}</td>
                               
                                    <td>
                           {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}   
                                  
                                    
                                @if(!empty($detail->V1))    
                                  
                                       {{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}} 
                                  @endif 
                                  @if(!empty($detail->V2))    
                                  
                                      {{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}} 
                                  @endif  
                                               @if(!empty($detail->Product()->first()->Space))   ({{$detail->Product()->first()->Space}}) @endif                       
                   @if(!empty($detail->Product()->first()->Storage))   ({{$detail->Product()->first()->Storage}}) @endif                       
                   @if(!empty($detail->Product()->first()->Processor))   ({{$detail->Product()->first()->Processor}}) @endif                       
                   @if(!empty($detail->Product()->first()->Camera))   ({{$detail->Product()->first()->Camera}}) @endif                       
                   @if(!empty($detail->Product()->first()->Screen))   ({{$detail->Product()->first()->Screen}}) @endif                       
                   @if(!empty($detail->Product()->first()->OS))   ({{$detail->Product()->first()->OS}}) @endif                       
                   @if(!empty($detail->Product()->first()->Battery))   ({{$detail->Product()->first()->Battery}}) @endif                       
                   @if(!empty($detail->Product()->first()->Warranty))   ({{$detail->Product()->first()->Warranty}}) @endif                       
                   @if(!empty($detail->Product()->first()->Color))   ({{$detail->Product()->first()->Color}}) @endif                       
                   @if(!empty($detail->Product()->first()->Category))   ({{$detail->Product()->first()->Category}}) @endif                       
                   @if(!empty($detail->Product()->first()->Model))   ({{$detail->Product()->first()->Model}}) @endif  
                                    </td>
                                                <td>
                              {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn}}  
                                    </td>
                                         <td>
                                            @if(!empty($detail->Product()->first()->Brand)) 
                                      {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Brand()->first()->Name :$detail->Product()->first()->Brand()->first()->NameEn}} 
                                            @endif 
                                    </td>
                                    <td>  {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}  </td>
                                    <td>{{$detail->AvQty}}</td>
                                    <td>{{$detail->Qty}}</td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td> {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}} </td>
                                    <td>{{$detail->Exp_Date}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                                        @elseif($item->Type == 'مرتجع مبيعات')
                                             <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                          
                                            <th>{{trans('admin.Patch_Number')}}</th>
                                     
                                    <th>{{trans('admin.Name')}} </th>
                                            <th>{{trans('admin.Group')}} </th>
                                    <th>{{trans('admin.Brand')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Original_Qty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Return_Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                                           <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                   
                                         <td>{{$detail->Patch_Number}}</td>
                              
                                    <td>
                                        {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}   
                                  
                                    
                                @if(!empty($detail->V1))    
                                  
                                       {{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}} 
                                  @endif 
                                  @if(!empty($detail->V2))    
                                  
                                      {{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}} 
                                  @endif  
                                               @if(!empty($detail->Product()->first()->Space))   ({{$detail->Product()->first()->Space}}) @endif                       
                   @if(!empty($detail->Product()->first()->Storage))   ({{$detail->Product()->first()->Storage}}) @endif                       
                   @if(!empty($detail->Product()->first()->Processor))   ({{$detail->Product()->first()->Processor}}) @endif                       
                   @if(!empty($detail->Product()->first()->Camera))   ({{$detail->Product()->first()->Camera}}) @endif                       
                   @if(!empty($detail->Product()->first()->Screen))   ({{$detail->Product()->first()->Screen}}) @endif                       
                   @if(!empty($detail->Product()->first()->OS))   ({{$detail->Product()->first()->OS}}) @endif                       
                   @if(!empty($detail->Product()->first()->Battery))   ({{$detail->Product()->first()->Battery}}) @endif                       
                   @if(!empty($detail->Product()->first()->Warranty))   ({{$detail->Product()->first()->Warranty}}) @endif                       
                   @if(!empty($detail->Product()->first()->Color))   ({{$detail->Product()->first()->Color}}) @endif                       
                   @if(!empty($detail->Product()->first()->Category))   ({{$detail->Product()->first()->Category}}) @endif                       
                   @if(!empty($detail->Product()->first()->Model))   ({{$detail->Product()->first()->Model}}) @endif  
                                    </td>
                                                <td>
                                       {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Group()->first()->Name :$detail->Product()->first()->Group()->first()->NameEn}}  
                                    </td>
                                         <td>
                                            @if(!empty($detail->Product()->first()->Brand)) 
                                   {{app()->getLocale() == 'ar' ?$detail->Product()->first()->Brand()->first()->Name :$detail->Product()->first()->Brand()->first()->NameEn}} 
                                            @endif 
                                    </td>
                                    <td>  {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}  </td>
                                    <td>{{$detail->Original_Qty}}</td>
                                    <td>{{$detail->Qty}}</td>
                                    <td>{{$detail->Recived_Qty}}</td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td> {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}} </td>
                                    <td>{{$detail->Exp_Date}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                                         @elseif($item->Type == 'صيانه')
                                            <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                 
                                </tr>
                                           <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>
                                    
                                {{app()->getLocale() == 'ar' ?$detail->P_Ar_Name :$detail->P_En_Name}}         
                                    </td>
                                    <td>{{$detail->Qty}}</td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>
                                       {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}     
                                    </td>
                                </tr>
                                 @endforeach
                            </tbody>
                                         @elseif($item->Type == 'مرتجع صيانه')
                                           <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.Return_Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                 
                                </tr>
                                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>  {{app()->getLocale() == 'ar' ?$detail->P_Ar_Name :$detail->P_En_Name}}    </td>
                                    <td>{{$detail->Recived_Qty}}</td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>        {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}  </td>
                                </tr>
                                 @endforeach
                            </tbody>
                                      @elseif($item->Type == 'مدخلات تصنيع' or $item->Type == 'مخرجات تصنيع')
                                   <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>

                                </tr>
                                <tbody id="">
                                
                                               @foreach($details as $detail)
                                @if($detail->type == 1)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>
                                           
                                        
                                {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}             
                                    </td>
                                   
                                    <td>
                                    
                                        {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}} 
                                    </td>
                            
                                         <td>
    
                                         {{$detail->Qty * $item->Qty}}
                            
                                    </td>
                                </tr>
                                @endif
                                 @endforeach
                                    
                    
                            </tbody> 
                                           <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Depreciation')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                </tr>
                                        <tbody id="">
                                
                         
                                @foreach($details as $detail)
                                @if($detail->type == 0)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>
                                       {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}       
                                    </td>
                                   
                                    <td>      {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}    </td>
                                    <td>
    
                                         {{$detail->Dep * $item->Qty}}
                            
                                    </td>
                                         <td>
    
                                         {{$detail->Qty * $item->Qty}}
                            
                                    </td>
                                    <td>{{$detail->Price *  $item->Qty}}</td>
                                    <td>{{$detail->Total *  $item->Qty}}</td>
                                    <td>       {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}       </td>
     

                                </tr>
                                @endif
                                 @endforeach
                            </tbody>
                                      @elseif($item->Type == 'توالف')
                                            <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Consist')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                               
                                </tr>
                                           <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>
                           {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}   
                                  
                                    
                                @if(!empty($detail->V1))    
                                  
                                       {{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}} 
                                  @endif 
                                  @if(!empty($detail->V2))    
                                  
                                      {{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}} 
                                  @endif  
      
                                    </td>

                                    <td>        {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}   </td>
                                    <td>{{$detail->Qty}}</td>
                                    <td>{{$detail->Consist}}</td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Total}}</td>
                          

                                </tr>
                                 @endforeach
                            </tbody>
                                  @elseif($item->Type == 'تحويلات مخازن الي' or $item->Type == 'تحويلات مخازن من')
                                            <tr>
                                     <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Group')}} </th>
                                     <th>{{trans('admin.Brand')}} </th>
                                    <th>{{trans('admin.P_Code')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
    
                                                <th> {{trans('admin.Price')}}</th>
                                    <th>{{trans('admin.Trans_Qty')}} </th>
                                    <th>{{trans('admin.Unit')}} </th>
    
                                                     <th>{{trans('admin.Total')}} </th>
                                     
                                </tr>     
                                           <tbody id="">
                                
                            @foreach($details as $pro)    
                                <tr>
                                    <td>
                 {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}} 
                                                        
                                                @if(!empty($pro->V1))    {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}}   @endif        
                                                @if(!empty($pro->V2))    {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}}   @endif  
                                        
                                    </td>
                                    <td>
                    @if(!empty($pro->Product()->first()->Group))     
                     
        {{app()->getLocale() == 'ar' ?$pro->Product()->first()->Group()->first()->Name :$pro->Product()->first()->Group()->first()->NameEn}}  
         
                    @endif                    
                                    </td>
                                                           <td>
                    @if(!empty($pro->Product()->first()->Brand))     
               {{app()->getLocale() == 'ar' ?$pro->Product()->first()->Brand()->first()->Name :$pro->Product()->first()->Brand()->first()->NameEn}}                
                    @endif                    
                                    </td>
                                    <td>{{$pro->P_Code}}</td>
                                     <td>{{$pro->Av_Qty}}</td>
                               
                                                        <td>{{$pro->Price}}</td>
                                       
                           
                                     <td>{{$pro->Trans_Qty}}</td>
                                       <td>  {{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}   </td>
                       
                                                       <td>{{$pro->Total}}</td>
                                      
                                </tr>
                        @endforeach        
                            </tbody> 
                         
                               @elseif($item->Type == 'تسويه')
                                           <tr>
                                     <th>{{trans('admin.Name')}} </th>
                                    <th>{{trans('admin.P_Code')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Inventory')}} </th>
                                    <th>{{trans('admin.Dificit')}} </th>
                                    <th>{{trans('admin.Execess')}} </th>
                                </tr>
                                           <tbody id="">
                                
                            @foreach($details as $pro)    
                                <tr>
                                    <td>
      {{app()->getLocale() == 'ar' ?$pro->Product()->first()->P_Ar_Name :$pro->Product()->first()->P_En_Name}} 
                                                        
                                                @if(!empty($pro->V1))    {{app()->getLocale() == 'ar' ?$pro->V1()->first()->Name :$pro->V1()->first()->NameEn}}   @endif        
                                                @if(!empty($pro->V2))    {{app()->getLocale() == 'ar' ?$pro->V2()->first()->Name :$pro->V2()->first()->NameEn}}   @endif  
                                    </td>
                                    <td>{{$pro->P_Code}}</td>
                                     <td>{{$pro->Av_Qty}}</td>
                                     <td>{{$pro->Price}}</td>
                                       <td> {{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}}</td>
                                        <td>{{$pro->Inventory}}</td>
                                       <td>{{$pro->Deficit}}</td>
                                       <td>{{$pro->Excess}}</td>
                                </tr>
                        @endforeach        
                            </tbody>
                                           
                                        @endif   
                                                    </table>
                                                </div>
                                   </td>
                           </tr> 
                          @endforeach
                            
                            
                    
                        </tbody>
                        <tfoot>
                       <tr>
                               @if($colum->Date == 1)
                              <th>{{trans('admin.Date')}}</th>
                               @endif

                                   @if($colum->Code == 1)
                              <th>{{trans('admin.Code')}}</th>
                               @endif
                               
                                 @if($colum->Time == 1)
                              <th>{{trans('admin.Time')}}</th>
                               @endif
                               
                                   @if($colum->Branch == 1)
                              <th>{{trans('admin.Branch')}}</th>
                               @endif
                               
                                   @if($colum->Store == 1)
                              <th>{{trans('admin.Store')}}</th>
                               @endif
                               
                                      @if($colum->Safe == 1)
                              <th>{{trans('admin.Safe')}}</th>
                               @endif
                               
                               
                                   @if($colum->Type == 1)
                              <th>{{trans('admin.Type')}}</th>
                               @endif
                               
                                   @if($colum->Cost_Center == 1)
                              <th>{{trans('admin.Cost_Center')}}</th>
                               @endif
                               
                                   @if($colum->User == 1)
                              <th>{{trans('admin.User')}}</th>
                               @endif
                               
                                   @if($colum->Coin == 1)
                              <th>{{trans('admin.Coin')}}</th>
                               @endif
                               
                                   @if($colum->Note == 1)
                              <th>{{trans('admin.Note')}}</th>
                               @endif
                               
                                   @if($colum->Total_Qty == 1)
                              <th>{{trans('admin.Total_Qty')}}</th>
                               @endif
                               
                                   @if($colum->Total_Price == 1)
                              <th>{{trans('admin.Total_Price')}}</th>
                               @endif
                               
                                   @if($colum->Account == 1)
                              <th>{{trans('admin.Account')}}</th>
                               @endif
                               
                                   @if($colum->Ship == 1)
                              <th>{{trans('admin.Ship')}}</th>
                               @endif

                              <th>{{trans('admin.Actions')}}</th>
                           </tr>
                            
                        </tfoot>
                     </table>
                  </div>
    {{$items->Links()}}
                             <div style="overflow:auto;">
                     <table style="    background: linear-gradient(45deg, #1d1f83, #921b1bde);
color: white;" id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                         <tr>
                         <th>{{trans('admin.Bills_Nums')}}</th>
                         <td>{{$Bills_Nums}}</td>
                         
                           <th>{{trans('admin.Total_Incom')}}  ({{trans('admin.Qty')}})</th>
                         <td>{{$Total_Ward}}</td>
                         
                                  <th>{{trans('admin.Total_Outcom')}} ({{trans('admin.Qty')}})</th>
                         <td>{{$Total_Sadr}}</td>  
                             
                                       <th>{{trans('admin.Balance')}} ({{trans('admin.Qty')}})</th>
                         <td>{{$CreditQty}}</td>  
                             
                             
                                <th>{{trans('admin.Total_Incom')}}  ({{trans('admin.Price')}})</th>
                         <td>{{$Total_Price_Ward}}</td>
                         
                                  <th>{{trans('admin.Total_Outcom')}} ({{trans('admin.Price')}})</th>
                         <td>{{$Total_Price_Sadr}}</td>  
                             
                                       <th>{{trans('admin.Balance')}} ({{trans('admin.Price')}})</th>
                         <td>{{$CreditPrice}}</td>  

                        </tr> 
                  
                       
                             
                     
                           </table>                 
                   </div>                    
                                                
                                                </div>
                                            </div>
                                        </div>
                                        
                         
                                    </div>
                                </div>
                                
                                  @if($show->Text == 1)  
                                                   <div class="row">
                                       
                                             @if(!empty($Def->Print_Text_Footer_Sales))
            
                         {!! app()->getLocale() == 'ar' ?$Def->Print_Text_Footer :$Def->Print_Text_Footer_En !!}
                      @endif          
                                        </div>  
                                @endif
                                
                     
                          
                                <div class="modal-footer">
                <a href="{{url('KlarAdmin')}}" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Back')}}</a>
             <button type="button" class="btn btn-default" onclick="window.print()"><i class="fal fa-print"></i></button>  
                                </div>
                                
                            </div>
                        </div>
         </div>
</main>

       


@endsection
@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
  
  <script>
    $(document).ready(function()
    {
        $(function()
        {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2(
            {
                placeholder: "Select State"
            });
            $(".js-hide-search").select2(
            {
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2(
            {
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2(
            {
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2(
            {
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm)
                {
                    return elm
                }
            });

            function icon(elm)
            {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2(
            {
                ajax:
                {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params)
                    {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params)
                    {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination:
                            {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup)
                {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo)
            {
                if (repo.loading)
                {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description)
                {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo)
            {
                return repo.full_name || repo.text;
            }
        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });
    
</script>

	<style>
	@media print {
		body * {
			visibility: hidden;
		}
		.modal-body * {
			visibility: visible;
			overflow: visible;
		}
		
        

	}
	</style>

<script>
function ChangeClass(){
    
   var $a1Check  = $('#CHANGE').is(':checked');

   
    if($a1Check){

  $(".X").removeClass("no-print");
 
        
    }
    else{
     
 $(".X").addClass("no-print");
     
        
        
    }    
    
    
    

    
}
</script>

@endpush