@extends('admin.index')
@section('content')

    <title>{{trans('admin.ItemsCostsReportGroup')}}</title>

    <main id="js-page-content" role="main" class="page-content">
        <ol class="breadcrumb page-breadcrumb no-print">
            <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Reports')}} </a></li>
            <li class="breadcrumb-item active">{{trans('admin.ItemsCostsReportGroup')}} </li>
            <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
        </ol>
        <div class="subheader">

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div id="panel-1" class="panel">
                    <div class="panel-hdr">
                        <h2>
                            <span class="fw-300"><i>  {{trans('admin.ItemsCostsReportGroup')}}</i></span>
                        </h2>



                    </div>
                    <div class="panel-container show">
                        <div class="panel-content">

                            <div class="row">


                                <div class="col-md-3 mt-2">



                                                @if($ReportsSettings->Products == 1)
                                                    @can('تقرير المنتجات')
                                                        <li>
                                                            <a href="{{url('ProductsReports')}}" title="{{trans('admin.Products')}}" data-filter-tags="{{trans('admin.Products')}}">
                                                                <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.Products')}}</span>
                                                            </a>
                                                        </li>
                                                    @endcan
                                                @endif


                                </div>
                                <div class="col-md-3 mt-2">


                                                @if($ReportsSettings->StoresCost == 1)
                                                    @can('تكلفه المخزون')
                                                        <li>
                                                            <a href="{{url('StoresCost')}}" title="{{trans('admin.StoresCost')}}" data-filter-tags="{{trans('admin.StoresCost')}}">
                                                                <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.StoresCost')}}</span>
                                                            </a>
                                                        </li>
                                                    @endcan
                                                @endif



                                </div>
                                <div class="col-md-3 mt-2">


                                 @if($ReportsSettings->StoresCosts == 1)
                                                    @can('تكلفه المخازن')
                                                        <li>
                                                            <a href="{{url('StoresCosts')}}" title="{{trans('admin.StoresCosts')}}" data-filter-tags="{{trans('admin.StoresCosts')}}">
                                                                <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.StoresCosts')}}</span>
                                                            </a>
                                                        </li>
                                                    @endcan
                                                @endif




                                </div>
                                <div class="col-md-3 mt-2">

                @if($ReportsSettings->ItemCost == 1)
                                                    @can('جرد المخازن')
                                                        <li>
                                                            <a href="{{url('ItemCost')}}" title="{{trans('admin.ItemCost')}}" data-filter-tags="{{trans('admin.ItemCost')}}">
                                                                <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.ItemCost')}}</span>
                                                            </a>
                                                        </li>
                                                    @endcan
                                                @endif



                                </div>

                                <div class="col-md-3 mt-2">

                                    @can('كميات المخزون')
                                                    <li>
                                                        <a href="{{url('StoresQtiesReport')}}" title="{{trans('admin.StoresQtiesReport')}}" data-filter-tags="{{trans('admin.StoresQtiesReport')}}">
                                                            <span class="nav-link-text" data-i18n="nav.utilities_borders"> {{trans('admin.StoresQtiesReport')}}</span>
                                                        </a>
                                                    </li>
                                                @endcan




                                </div>


                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                    {
                        placeholder: "Select State"
                    });
                $(".js-hide-search").select2(
                    {
                        minimumResultsForSearch: 1 / 0
                    });
                $(".js-max-length").select2(
                    {
                        maximumSelectionLength: 2,
                        placeholder: "Select maximum 2 items"
                    });
                $(".select2-placeholder").select2(
                    {
                        placeholder: "Select a state",
                        allowClear: true
                    });

                $(".js-select2-icons").select2(
                    {
                        minimumResultsForSearch: 1 / 0,
                        templateResult: icon,
                        templateSelection: icon,
                        escapeMarkup: function(elm)
                        {
                            return elm
                        }
                    });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }

                $(".js-data-example-ajax").select2(
                    {
                        ajax:
                            {
                                url: "https://api.github.com/search/repositories",
                                dataType: 'json',
                                delay: 250,
                                data: function(params)
                                {
                                    return {
                                        q: params.term, // search term
                                        page: params.page
                                    };
                                },
                                processResults: function(data, params)
                                {
                                    // parse the results into the format expected by Select2
                                    // since we are using custom formatting functions we do not need to
                                    // alter the remote JSON data, except to indicate that infinite
                                    // scrolling can be used
                                    params.page = params.page || 1;

                                    return {
                                        results: data.items,
                                        pagination:
                                            {
                                                more: (params.page * 30) < data.total_count
                                            }
                                    };
                                },
                                cache: true
                            },
                        placeholder: 'Search for a repository',
                        escapeMarkup: function(markup)
                        {
                            return markup;
                        }, // let our custom formatter work
                        minimumInputLength: 1,
                        templateResult: formatRepo,
                        templateSelection: formatRepoSelection
                    });

                function formatRepo(repo)
                {
                    if (repo.loading)
                    {
                        return repo.text;
                    }

                    var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                        "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                        "<div class='select2-result-repository__meta'>" +
                        "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                    if (repo.description)
                    {
                        markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                    }

                    markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                        "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                        "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                        "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                        "</div>" +
                        "</div></div>";

                    return markup;
                }

                function formatRepoSelection(repo)
                {
                    return repo.full_name || repo.text;
                }
            });
        });

    </script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');


                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


@endpush
