@extends('admin.index')
@section('content')
@php
use App\Models\DefaultDataShowHide;
$Def=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp
  <title>{{trans('admin.NetPurchases')}}</title>

  <style>
    .over-flow{
        overflow:auto;
    }
    .table-width{
        width:200%;
    }
    @media print{
        .over-flow{
        overflow:visible;
    }
    .table-width{
        width:100%;
    }
    }
</style>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb no-print">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.Reports')}} </a></li>
                        <li class="breadcrumb-item active">{{trans('admin.NetPurchases')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
                    </ol>
                    <div class="subheader">

                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i>  {{trans('admin.NetPurchases')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">
                                          <button class="btn btn-sm btn-primary waves-effect waves-themed" onclick="window.print()" style="margin-left:3px"><i class="fal fa-print"></i> {{trans('admin.Print')}}</button>
                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">

                                              <form action="{{url('NetPurchasesFilterTwo')}}" method="get">


                                    <div class="form-row">
                                   <div class="form-group col-md-2 col-4">
                     <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label><span class="strick">*</span>
                                                <input type="date"  value="{{date('Y-m-d')}}" id="From" name="From" class="form-control" required>
                                            </div>
                                            <div class="form-group col-md-2 col-4">
            <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label><span class="strick">*</span>
                                                <input type="date" value="{{date('Y-m-d')}}"  id="To" name="To" class="form-control" required>
                                            </div>
                                     <div class="form-group col-md-2 col-4">
                                                <label class="form-label" for="">  {{trans('admin.Account')}} </label>
                                                <select class="select2 form-control w-100" id="Vendor" name="Vendor">
                                          <option value=""> {{trans('admin.Account')}}</option>
                                           @foreach($Vendors as $vend)
                                                <option value="{{$vend->id}}">
                                         {{app()->getLocale() == 'ar' ?$vend->Name :$vend->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                      <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">  {{trans('admin.Coin')}} </label>
                                                <select class="select2 form-control w-100" id="Coin" name="Coin">
                     <option value=""> {{trans('admin.Coin')}}</option>
                                            @foreach($Coins as $coin)
                                                <option value="{{$coin->id}}">
                                        {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">  {{trans('admin.Safe')}} </label>
                                                <select class="select2 form-control w-100" id="Safe" name="Safe">
                                             <option value=""> {{trans('admin.Safe')}}</option>
                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}">
                                                    {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                        <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">   {{trans('admin.Payment_Method')}} </label>
                                                <select class="select2 form-control w-100" id="Payment_Method" name="Payment_Method">
                                                   <option value=""> {{trans('admin.Account')}}</option>
                                                 <option value="Cash">{{trans('admin.Cash')}} </option>
                                                <option value="Later">{{trans('admin.Later')}}</option>
                                                <option value="Check">{{trans('admin.Check')}}</option>
                                                </select>
                                            </div>
                                 <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">   {{trans('admin.Cost_Center')}} </label>
                                                <select class="select2 form-control w-100" id="Cost_Center" name="Cost_Center">

                                                <option value=""> {{trans('admin.Cost_Center')}}</option>
                                            @foreach($CostCenters as $cost)
                                                <option value="{{$cost->id}}">

                                            {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">  {{trans('admin.Delegate')}}  </label>
                                                <select class="select2 form-control w-100" id="Delegate" name="Delegate">
                                                    <option value=""> {{trans('admin.Delegate')}}</option>
                                                 @foreach($Employess as $emp)
                                                <option value="{{$emp->id}}">
                                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                          <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">  {{trans('admin.User')}}  </label>
                                                <select class="select2 form-control w-100" id="User" name="User">
                                                    <option value=""> {{trans('admin.User')}}</option>
                                                 @foreach($Users as $user)
                                                <option value="{{$user->id}}">
                                                 {{app()->getLocale() == 'ar' ?$user->name :$user->nameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                        <div class="form-group col-lg-2 no-print">
                  <label class="form-label" for="">  {{trans('admin.Group')}}  </label>
                              <select class="select2 form-control w-100" id="group" name="group">
                               <option value="">{{trans('admin.Group')}}</option>
                                                                @foreach($ItemsGroups as $group)
                                          <option value="{{$group->id}}">

                                     {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}
                                  </option>
                                                                @endforeach
                                                            </select>
                                            </div>
                 <div class="form-group col-lg-2 no-print">
                  <label class="form-label" for="">  {{trans('admin.Stores')}}  </label>
                              <select class="select2 form-control w-100" id="Store" name="Store">
                               <option value="">{{trans('admin.Stores')}}</option>
                                                                @foreach($Stores as $store)
                                          <option value="{{$store->id}}">

                                     {{app()->getLocale() == 'ar' ?$store->Name :$store->NameEn}}
                                  </option>
                                                                @endforeach
                                                            </select>
                                            </div>
                                 <div class="form-group col-md-2 no-print">
                                                <label class="form-label" for="">   {{trans('admin.Type')}} </label>
                                                <select class="select2 form-control w-100" id="Type" name="Type">
                                                   <option value=""> {{trans('admin.Type')}}</option>
                                                 <option value="مشتريات">{{trans('admin.Purchases')}} </option>
                                                <option value="مرتجع مشتريات"> {{trans('admin.Return_Purchases')}}</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-lg-2 no-print">
                                      <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                <input type="text" id="Code" class="form-control" name="Code">
                                            </div>

                <div class="form-group col-lg-10 no-print">
                                            <div class="input-items position-re">
                       <input type="text" id="search" class="form-control" name="search" placeholder="{{trans('admin.Search_For_Products')}}">

                                      @if(app()->getLocale() == 'ar' )
                     <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;left:3px;"></i>
                      @else
                            <i class="fal fa-barcode-alt" style="position:absolute ;top:5px;right: 0;left:auto;"></i>
                      @endif
                                            </div>
                                         </div>

                                             <div class="form-group col-lg-1 no-print" style="padding: 22px;">

                    <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>

                                        </div>
                                        </div>

                                        </form>
                                        <!-- datatable start -->

                                        <div class="over-flow">
                                        <table id="X"
                                            class="table table-bordered table-hover table-striped table-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Date')}} </th>
                                                    <th>{{trans('admin.Bill_Num')}} </th>
                                                              @if($Def->Refrence_Number_Print == 1)
                                                    <th>{{trans('admin.Refernce_Number')}} </th>
                                                    @else
                                                     <th class="no-print">{{trans('admin.Refernce_Number')}} </th>
                                                    @endif
                                                       @if($Def->Code_Report == 1)
                                                    <th>{{trans('admin.Code')}} </th>
                                                    @else
                                                     <th class="no-print">{{trans('admin.Code')}} </th>
                                                    @endif
                                                    <th>{{trans('admin.Name')}} </th>
                                                                   @if($Def->Unit == 1)
                                                    <th>{{trans('admin.Unit')}} </th>
                                                    @else
                                                     <th class="no-print">{{trans('admin.Unit')}} </th>
                                                    @endif
                                                    <th class="no-print">{{trans('admin.Group')}} </th>
                                                    <th>{{trans('admin.Price')}} </th>
                                                    <th>{{trans('admin.Qty')}} </th>
                                                    <th>{{trans('admin.Total')}} </th>
                                                    <th>{{trans('admin.Total_Return')}} </th>
                                                    <th class="no-print">{{trans('admin.Delegate')}} </th>
                                                    <th class="no-print">{{trans('admin.Coin')}} </th>
                                                    <th class="no-print">{{trans('admin.Cost_Center')}} </th>
                                                    <th class="no-print">{{trans('admin.Safe')}} </th>
                                                    <th class="no-print">{{trans('admin.Store')}} </th>
                                                    <th class="no-print">{{trans('admin.Type')}} </th>
                                                    <th class="no-print">{{trans('admin.Payment_Method')}} </th>
                                                    <th class="no-print">{{trans('admin.User')}} </th>
                                                </tr>
                                            </thead>
                                            <tbody class="Data">


                                            </tbody>
                                        </table>
                                        </div>
                                        <div class="panel-content">
                                            <div id="mobile-overflow">
                                        <table class="table table-bordered table-hover table-striped w-100 mt-4 mobile-width">
                                            <tbody>
                                                <tr>
                                                    <td> {{trans('admin.Total_Bill_Num')}} </td>
                                                    <td  id="BILLNUMS"></td>
                                                    <td> {{trans('admin.Total_Purch')}}</td>
                                                    <td  id="TOTALPURCH"></td>
                                                     <td> {{trans('admin.Total_Return_Purch')}}</td>
                                                    <td  id="TOTALRETURN"></td>
                                                </tr>
                                                <tr>
                  <td style="text-align: center; font-size: 200%; " colspan="2">{{trans('admin.NetPurchases')}}  </td>
                  <td style="text-align: center; font-size: 200%;" colspan="2" id="NetPurchases"></td>


                                                </tr>
                                            </tbody>
                                        </table>
                                        </div>
                                    </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
@endsection

@push('js')
   <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }

                $(".js-data-example-ajax").select2(
                {
                    ajax:
                    {
                        url: "https://api.github.com/search/repositories",
                        dataType: 'json',
                        delay: 250,
                        data: function(params)
                        {
                            return {
                                q: params.term, // search term
                                page: params.page
                            };
                        },
                        processResults: function(data, params)
                        {
                            // parse the results into the format expected by Select2
                            // since we are using custom formatting functions we do not need to
                            // alter the remote JSON data, except to indicate that infinite
                            // scrolling can be used
                            params.page = params.page || 1;

                            return {
                                results: data.items,
                                pagination:
                                {
                                    more: (params.page * 30) < data.total_count
                                }
                            };
                        },
                        cache: true
                    },
                    placeholder: 'Search for a repository',
                    escapeMarkup: function(markup)
                    {
                        return markup;
                    }, // let our custom formatter work
                    minimumInputLength: 1,
                    templateResult: formatRepo,
                    templateSelection: formatRepoSelection
                });

                function formatRepo(repo)
                {
                    if (repo.loading)
                    {
                        return repo.text;
                    }

                    var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                        "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                        "<div class='select2-result-repository__meta'>" +
                        "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                    if (repo.description)
                    {
                        markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                    }

                    markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                        "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                        "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                        "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                        "</div>" +
                        "</div></div>";

                    return markup;
                }

                function formatRepoSelection(repo)
                {
                    return repo.full_name || repo.text;
                }
            });
        });

    </script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');


                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

@endpush
