@extends('admin.index')
@section('content')
    @php
        use App\Models\CompanyData;
        $DefC=CompanyData::orderBy('id','desc')->first();
        $title=trans('admin.Collection_Delegates');
    @endphp

  <title>{{trans('admin.Collection_Delegates')}}</title>


   <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb no-print">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Reports')}}</a></li>
                        <li class="breadcrumb-item active">  {{trans('admin.Collection_Delegates')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                       <!-- Head Of Print -->
       @include('admin.layouts.PrintHeader')
                    <!-- data entry -->
                    <div class="row ">
                        <div class="col-lg-12">
                            <div id="panel-2" class="panel">
                                <div class="panel-hdr no-print">
                                    <h2>
                                        <span class="fw-300"><i>    {{trans('admin.Collection_Delegates')}}</i></span>
                                    </h2>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <form class="form-row">
                                            <div class="form-group col-md-2 col-4" style="display: none">
                                 <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" id="From" class="form-control">
                                            </div>
                                            <div class="form-group col-md-2 col-4" style="display: none">
                              <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" id="To" class="form-control">
                                            </div>
                                            <div class="form-group col-md-3 no-print">
                                                <label class="form-label" for=""> {{trans('admin.Delegate')}} </label>
                                                <select class="select2 form-control w-100" id="Delegate">
                                                    <option value="">{{trans('admin.Delegate')}}</option>
                                                    @foreach($Vendors as $vend)
                                                    <option value="{{$vend->id}}">
                                                     {{app()->getLocale() == 'ar' ?$vend->Name :$vend->NameEn}}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2 no-print">
                                                <div class="buttons mt-4">
{{--                                                    <a class="btn btn-primary w-100" href="#" onclick="window.print()"> <i class="fal fa-print"></i> {{trans('admin.Print')}}</a>--}}
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         {{trans('admin.Collection_Delegates')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                   @include('admin.layouts.toolbar')
                                    </div>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="X"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>

                                                    <th> {{trans('admin.Account_Name')}} </th>
                                                    <th> {{trans('admin.Debitor_Balance')}} </th>
                                                    <th> {{trans('admin.Creditor_Balance')}} </th>
                                                    <th> {{trans('admin.Last_Joun')}} </th>
                                                    <th> {{trans('admin.Last_Bill')}} </th>
                                                    <th> {{trans('admin.Last_Recipt_Voucher')}} </th>
                                                </tr>
                                            </thead>
                                            <tbody class="Data">

                                            </tbody>
                                            <tfoot>
                                                <tr>

                                                    <th> {{trans('admin.Account_Name')}} </th>
                                                    <th> {{trans('admin.Debitor_Balance')}} </th>
                                                    <th> {{trans('admin.Creditor_Balance')}} </th>
                                                    <th> {{trans('admin.Last_Joun')}} </th>
                                                    <th> {{trans('admin.Last_Bill')}} </th>
                                                    <th> {{trans('admin.Last_Recipt_Voucher')}} </th>
                                                </tr>
                                            </tfoot>

                                        </table>
                                        </div>
                                        <div id="mobile-overflow">
                                        <table class="table table-bordered table-hover table-striped w-100 mt-4 mobile-width">
                                            <tbody>
                                                <tr>
                                                    <td> {{trans('admin.Total_Debitor_Balance')}}</td>
                                                    <td class="TDBL"></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>



@endsection


@push('js')

  <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

  <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            exportOptions: {
                                format: {
                                    body: function ( inner, rowidx, colidx, node ) {
                                        if ($(node).children("select").length > 0) {
                                            // we are in a cell containing a "select" drop-down - so, get it:
                                            var selectNode = node.firstElementChild;
                                            var txt = selectNode.options[selectNode.selectedIndex].text;
                                            //var txt = selectNode.options[selectNode.selectedIndex].text;
                                            return txt;
                                        } else {

                                            if ($(node).children("input").length > 0) {
                                                return $(node).children("input").first().val();
                                            } else {
                                                return inner;
                                            }


                                        }
                                    }
                                }
                            },
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>


<!-- Filter -->
<script>
   $(document).ready(function(){

    fetch_customer_data();

    function fetch_customer_data(From = '',To = '',Delegate = '')
    {
     $.ajax({
      url:'FilterCollection_Delegates',
      method:'GET',
      data:{From:From,To:To,Delegate:Delegate},
      dataType:'json',
      success:function(data)
      {

       $('.Data').html(data.table_data);
       $('.TDBL').html(data.TDBL);


          var table = $('#X').DataTable(
              {
                  retrieve: true,
                  responsive: true,
                  orderCellsTop: true,
                  fixedHeader: false,
                  lengthChange: false,
                  pageLength : 1000000,
                  dom: 'Bfrtip',

                  buttons: [
                      {
                          extend: 'pageLength',
                          className: 'btn-outline-default'
                      },
                      {
                          extend: 'colvis',
                          text: 'Column Visibility',
                          titleAttr: 'Col visibility',
                          className: 'btn-outline-default'
                      },

                      {
                          extend: 'excelHtml5',
                          text: 'Excel',
                          titleAttr: 'Generate Excel',
                          className: 'btn-outline-success btn-sm mr-1'
                      },

                      {
                          extend: 'print',
                          text: 'Print',
                          titleAttr: 'Print Table',
                          className: 'btn-outline-primary btn-sm'
                      }
                  ],
              });


      }
     })
    }


$(document).on('change', '#From', function(){
     var From = $(this).val();
     var To = $('#To').val();
     var Delegate = $('#Delegate').val();
    $('#X').dataTable().fnDestroy();
     fetch_customer_data(From,To,Delegate);
    });

$(document).on('change', '#To', function(){
     var To = $(this).val();
     var From = $('#From').val();
     var Delegate = $('#Delegate').val();
    $('#X').dataTable().fnDestroy();
     fetch_customer_data(From,To,Delegate);
    });

$(document).on('change', '#Delegate', function(){
     var Delegate = $(this).val();
     var From = $('#From').val();
     var To = $('#To').val();
    $('#X').dataTable().fnDestroy();
     fetch_customer_data(From,To,Delegate);
    });


   });
</script>

<!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


  $('#Type').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllMainAccounts',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
        data: function (params) {
          var query = {
            search: params.term
          };
          if (params.term == "*") query.items = [];
          return { json: JSON.stringify( query ) }
        }
    }
  });


$('#Type').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});






            });
        });



    </script>

@endpush
