@extends('admin.index')
@section('content')
@php
use App\Models\ProductsShortcomings;
use App\Models\CompanyData;
$Def=CompanyData::orderBy('id','desc')->first();
@endphp
  <title>{{trans('admin.ShortcomingsSechdule')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Purchases')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.ShortcomingsSechdule')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>


            <!-- Data -->
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel second-color">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.ShortcomingsSechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                     @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                              <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
        <table id="dt-basic-example" class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>

                                                    <th> {{trans('admin.Payment_Method')}}</th>

                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Vendor')}} </th>

                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr  @if($item->Edit == 1) class="edited" @elseif($item->Delete == 1) class="deleted" @endif>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>

                                                    <td>

                                                    @if($item->Payment_Method == 'Cash')
                                                       {{trans('admin.Cash')}}
                                                    @elseif($item->Payment_Method == 'Later')
                                                       {{trans('admin.Later')}}
                                                    @endif
                                                    </td>

                                                <td>

                                                    @if(!empty($item->Safe()->first()->Name))
                                                     {{app()->getLocale() == 'ar' ?$item->Safe()->first()->Name :$item->Safe()->first()->NameEn}}
                                                    @endif
                                                    </td>
                                                <td>

                                                    @if(!empty($item->Vendor()->first()->Name))
                                              {{app()->getLocale() == 'ar' ?$item->Vendor()->first()->Name :$item->Vendor()->first()->NameEn}}
                                                    @endif
                                                    </td>



                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>
                                                     <td>
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                           {{trans('admin.Data')}}
                                                        </button>
                                                    </td>
                                                    <td class="text-center">

                                                        @if($item->Edit == 0 and $item->Delete == 0)
                                      @if($item->ToPurch != 1)

                                                                <a href="{{url('ShortcomingsPrint/'.$item->id)}}" class="btn btn-default" >
                                                                    <i class="fal fa-print"></i>
                                                                </a>


                                                                <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>

                        <form action="{{url('EditShortcomings')}}" method="get" style="display: inline-block;">
                                            <input type="hidden" name="ID" value="{{$item->id}}">
                            <button type="submit" class="btn btn-default"><i class="fal fa-edit"></i></button>
                                                        </form>


          <a href="{{url('TransferToPurchasesShortcomings/'.$item->id)}}" class="btn btn-default" ><i class="fal fa-arrow-right"></i></a>

                                            @endif
                                            @endif


                                                            @if($item->Edit == 1)
                                                                <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                                                <a href="{{url('ShortcomingsPrint/'.$item->id)}}" class="btn btn-default" >
                                                                    <i class="fal fa-print"></i>
                                                                </a>

                                                            @elseif($item->Delete == 1)

                                                                <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>
                                                                <a href="{{url('ShortcomingsPrint/'.$item->id)}}" class="btn btn-default" >
                                                                    <i class="fal fa-print"></i>
                                                                </a>


                                                            @endif


                                                            @if($item->ToPurch == 1)
                                                                <span class="btn btn-warning">{{trans('admin.Transfer_to')}} ({{$item->Edit_New_Code}})</span>

                                                            @endif

                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>

                                                    <th> {{trans('admin.Payment_Method')}}</th>

                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Vendor')}} </th>

                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </tfoot>

                                        </table>

                                        {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>

  @foreach($items as $item)
                  <!-- Modal Delete -->
    <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                         {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                                    <a href="{{url('DeleteShortcomings/'.$item->id)}}" class="btn btn-primary">{{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>


                        <!-- Modal Details -->
    <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=ProductsShortcomings::where('Shortmings',$item->id)->get();
                @endphp
                        <div class="mt-3">
                            <div style="overflow:auto">
                            <table id=""
                            class="table table-bordered table-hover table-striped" style="width:160%">
                            <thead>
                                <tr>
                                   <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.AvQty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>

                                                         @if(auth()->guard('admin')->user()->emp == 0)
                                                   <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.The_Net')}} </th>
             @else
  @if(auth()->guard('admin')->user()->cost_price_purch == 1)
                                                   <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.The_Net')}} </th>
        @endif
                                    @endif


                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                @foreach($details as $detail)
                                <tr>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>

                                        @if(!empty($detail->Product()->first()->P_Ar_Name))
                                                                            {{app()->getLocale() == 'ar' ?$detail->Product()->first()->P_Ar_Name :$detail->Product()->first()->P_En_Name}}
                                        @endif

     @if(!empty($detail->V1()->first()->Name))   ({{app()->getLocale() == 'ar' ?$detail->V1()->first()->Name :$detail->V1()->first()->NameEn}}  )  @endif
                                  @if(!empty($detail->V2()->first()->Name))    (({{app()->getLocale() == 'ar' ?$detail->V2()->first()->Name :$detail->V2()->first()->NameEn}}  ))  @endif
                                    </td>

                                    <td>
                                        @if(!empty($detail->Unit()->first()->Name))

                                        {{app()->getLocale() == 'ar' ?$detail->Unit()->first()->Name :$detail->Unit()->first()->NameEn}}

                                        @endif

                                    </td>
                                    <td>{{$detail->Av_Qty}}</td>
                                    <td>{{$detail->Qty}}</td>

                                 @if(auth()->guard('admin')->user()->emp == 0)
                                       <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>{{$detail->Total_Net}}</td>
           @else
  @if(auth()->guard('admin')->user()->cost_price_purch == 1)
                       <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>{{$detail->Total_Net}}</td>
 @endif
                                    @endif


                                    <td>
                                        @if(!empty($detail->Store()->first()->Name))
                                        {{app()->getLocale() == 'ar' ?$detail->Store()->first()->Name :$detail->Store()->first()->NameEn}}
                                        @endif
                                    </td>
                                    <td>{{$detail->Exp_Date}}</td>

                                </tr>
                                 @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                  <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.AvQty')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>

                                       @if(auth()->guard('admin')->user()->emp == 0)
                                      <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.The_Net')}} </th>
           @else
  @if(auth()->guard('admin')->user()->cost_price_purch == 1)
                                      <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.The_Net')}} </th>
 @endif
                                    @endif



                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                </tr>
                            </tfoot>
                        </table>
                        </div>
                        <div style="overflow:auto">
                        <table class="table table-bordered table-hover table-striped  mt-4" style="width:120%;">
                            <tbody>
                                <tr>
                                    <td>{{trans('admin.Product_Numbers')}}</td>
                                    <td>{{$item->Product_Numbers}}</td>

                                    <td>{{trans('admin.Total_Qty')}}</td>
                                    <td>{{$item->Total_Qty}}</td>

                                 @if(auth()->guard('admin')->user()->emp == 0)
                           <td>{{trans('admin.Total_Discount')}}</td>
                                    <td>{{$item->Total_Discount}}</td>

                                     <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                    <td>{{$item->Total_BF_Taxes}}</td>

                                    <td>{{trans('admin.Total_Taxes')}}</td>
                                    <td>{{$item->Total_Taxes}}</td>

                                    <td>{{trans('admin.Total_Price')}}</td>
                                    <td>{{$item->Total_Price}}</td>
          @else
  @if(auth()->guard('admin')->user()->cost_price_purch == 1)
                                       <td>{{trans('admin.Total_Discount')}}</td>
                                    <td>{{$item->Total_Discount}}</td>

                                     <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                    <td>{{$item->Total_BF_Taxes}}</td>

                                    <td>{{trans('admin.Total_Taxes')}}</td>
                                    <td>{{$item->Total_Taxes}}</td>

                                    <td>{{trans('admin.Total_Price')}}</td>
                                    <td>{{$item->Total_Price}}</td>
 @endif
                                    @endif


                                </tr>
                            </tbody>
                        </table>
                        </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>
                    </div>
                </div>
            </div>

            </div>

    <!-- Modal show data -->
    <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                              {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
       <div style="overflow:auto;">
        <table id="" class="table table-bordered table-hover table-striped " style="width:120%;">
                                            <thead class="bg-highlight">
                                                <tr>

                                                    <th> {{trans('admin.Draw')}} </th>

                                                    <th>{{trans('admin.Status')}} </th>
                                                    <th> {{trans('admin.Vendor_Bill_Date')}} </th>
                                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>

                                                    <th> {{trans('admin.Delegate')}} </th>
                                                    <th> {{trans('admin.Store')}} </th>
                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                    <th> {{trans('admin.User')}} </th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                                <tr>

                                                      <td>{{$item->Draw}}</td>

                                                        <td>

                                                         @if($item->Status == 1)
                                                       {{trans('admin.Recived')}}
                                                    @elseif($item->Status == 0)
                                                       {{trans('admin.Pending')}}
                                                    @endif
                                                    </td>
                                                        <td>{{$item->Vendor_Bill_Date}}</td>
                                                        <td>{{$item->Refernce_Number}}</td>
                                                        <td>{{$item->Note}}</td>

                                                <td>
                                                   @if(!empty($item->Delegate()->first()->Name))


                                                     {{app()->getLocale() == 'ar' ?$item->Delegate()->first()->Name :$item->Delegate()->first()->NameEn}}
                                                    @endif
                                                    </td>

                                                          <td>
                                                   @if(!empty($item->Store()->first()->Name))

                                                         {{app()->getLocale() == 'ar' ?$item->Store()->first()->Name :$item->Store()->first()->NameEn}}
                                                    @endif
                                                    </td>

                                                                    <td>
                                                   @if(!empty($item->Coin()->first()->Arabic_Name))

                                                         {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                    @endif
                                                    </td>

                                                            <td>
                                                     @if(!empty($item->Cost_Center()->first()->Arabic_Name))


                                                     {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                                    @endif
                                                    </td>

                                                                    <td>
                                                     @if(!empty($item->User()->first()->name))


                                                        {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                                    @endif
                                                    </td>



                                                </tr>

                                            </tbody>
                                            <tfoot>
                                                <tr>

                                                    <th> {{trans('admin.Draw')}} </th>

                                                    <th>{{trans('admin.Status')}} </th>
                                                    <th> {{trans('admin.Vendor_Bill_Date')}} </th>
                                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>

                                                    <th> {{trans('admin.Delegate')}} </th>
                                                    <th> {{trans('admin.Store')}} </th>
                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                    <th> {{trans('admin.User')}} </th>

                                                </tr>
                                            </tfoot>

                                        </table>

                                        {{$items->Links()}}
                                        </div>
                       </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        </div>

                </div>
            </div>

            </div>

@endforeach



@endsection


@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">


    <style>
        th{
            width:135px!important;
        }
    </style>

 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search '  + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

  <script>
    $(document).ready(function()
    {
        $(function()
        {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2(
            {
                placeholder: "Select State"
            });
            $(".js-hide-search").select2(
            {
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2(
            {
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2(
            {
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2(
            {
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm)
                {
                    return elm
                }
            });

            function icon(elm)
            {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2(
            {
                ajax:
                {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params)
                    {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params)
                    {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination:
                            {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup)
                {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo)
            {
                if (repo.loading)
                {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description)
                {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo)
            {
                return repo.full_name || repo.text;
            }
        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

	<style>
	@media print {
		body * {
			visibility: hidden;
		}
		.modal-content * {
			visibility: visible;
			overflow: visible;
		}
		.main-page * {
			display: none;
		}
		.modal {
			position: absolute;
			left: 0;
			top: -150px;
			right:0;
			margin: 0;
			padding: 0;
			/*min-height: 550px;*/
			width:100%;
			/*visibility: visible;*/
			overflow: visible !important; /* Remove scrollbar for printing. */
		}
		.modal-dialog {
			visibility: visible !important;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}

        @page {

		size: a4;

    }

    .page-content{
        display:none;
    }
	}
	</style>



@endpush
