@extends('admin.index')
@section('content')
@php
use App\Models\ProductsPurchases;
use App\Models\ReturnPurch;
use App\Models\CompanyData;
$Def=CompanyData::orderBy('id','desc')->first();
@endphp
  <title>{{trans('admin.PurchasesSechdule')}}</title>


     <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Purchases')}}</a></li>
                        <li class="breadcrumb-item active"> {{trans('admin.PurchasesSechdule')}} </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                     <!-- Filter -->
                    <div class="row">
                        <div class="col-lg-12">
                            <div id="panel-2" class="panel first-color">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i> {{trans('admin.PurchasesSechdule')}}  </i></span>
                                    </h2>
                                </div>
                                <div class="panel-container show">
                                    <div class="panel-content">
                                        <form action="{{url('FilterBillPurchases')}}" method="get" class="form-row">
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" name="From" class="form-control">
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                                                <input type="date" value="{{date('Y-m-d')}}" name="To" class="form-control">
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Store')}} </label>
                                                <select class="select2 form-control w-100" name="Store">
                                            <option value=""> {{trans('admin.Store')}}</option>
                                            @foreach($Stores as $stor)
                                                <option value="{{$stor->id}}">
                                              {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Account')}} </label>
                                                <select class="select2 form-control w-100" name="Vendor">
                                          <option value=""> {{trans('admin.Account')}}</option>
                                           @foreach($Vendors as $vend)
                                                <option value="{{$vend->id}}">

                                     {{app()->getLocale() == 'ar' ?$vend->Name :$vend->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Coin')}} </label>
                                                <select class="select2 form-control w-100" name="Coin">
                     <option value=""> {{trans('admin.Coin')}}</option>
                                            @foreach($Coins as $coin)
                                                <option value="{{$coin->id}}">
                                              {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Safe')}} </label>
                                                <select class="select2 form-control w-100" name="Safe">
                                             <option value=""> {{trans('admin.Safe')}}</option>
                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}">
                                               {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">   {{trans('admin.Payment_Method')}} </label>
                                                <select class="select2 form-control w-100" name="Payment_Method">
                                                   <option value=""> {{trans('admin.Account')}}</option>
                                                 <option value="Cash">{{trans('admin.Cash')}} </option>
                                                <option value="Later">{{trans('admin.Later')}}</option>
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">   {{trans('admin.Cost_Center')}} </label>
                                                <select class="select2 form-control w-100" name="Cost_Center">

                                                <option value=""> {{trans('admin.Cost_Center')}}</option>
                                            @foreach($CostCenters as $cost)
                                                <option value="{{$cost->id}}">
                                       {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.Delegate')}}  </label>
                                                <select class="select2 form-control w-100" name="Delegate">
                                                    <option value=""> {{trans('admin.Delegate')}}</option>
                                                 @foreach($Employess as $emp)
                                                <option value="{{$emp->id}}">
                                            {{app()->getLocale() == 'ar' ?$emp->Name :$emp->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                          <div class="form-group col-md-2">
                                                <label class="form-label" for="">  {{trans('admin.User')}}  </label>
                                                <select class="select2 form-control w-100" name="User">
                                                    <option value=""> {{trans('admin.User')}}</option>
                                                 @foreach($Users as $user)
                                                <option value="{{$user->id}}">
                                                   {{app()->getLocale() == 'ar' ?$user->Name :$user->NameEn}}
                                                </option>
                                            @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group col-lg-2">
                                      <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                                <input type="text" name="Code" class="form-control">
                                            </div>
        <div class="form-group col-lg-2">
                                      <label class="form-label" for="simpleinput">{{trans('admin.Refernce_Number')}} </label>
                                                <input type="text" name="Refernce_Number" class="form-control">
                                            </div>
                                            <div class="form-group col-md-2">
                                                <div class="buttons mt-4">
    <button type="submit" class="btn btn-primary show-table w-100"> <i class="fal fa-folder"></i> {{trans('admin.Show')}}</button>
                                                </div>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            <!-- Data -->
                    <div class="row hide-table">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel second-color">
                                <div class="panel-hdr">
                                    <h2>
                                    {{trans('admin.PurchasesSechdule')}}
                                    </h2>

                                    <div class="panel-toolbar">
                                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                                            Style</button>
                                      @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                              <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">

                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
        <table  class="table table-bordered table-hover table-striped ">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th> {{trans('admin.Payment_Method')}}</th>
                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Vendor')}} </th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr  @if($item->Edit == 1) class="edited" @elseif($item->Delete == 1) class="deleted"  @endif >
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>

                                                    <td>

                                                    @if($item->Payment_Method == 'Cash')
                                                       {{trans('admin.Cash')}}
                                                    @elseif($item->Payment_Method == 'Later')
                                                       {{trans('admin.Later')}}
                                         @elseif($item->Payment_Method == 'Check')

                             <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Check{{$item->id}}">{{trans('admin.Check')}} </button>
                                                    @endif
                                                    </td>

                                                        <td>


                                                    @if(!empty($item->Safe_fk->Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Safe_fk->Name :$item->Safe_fk->Name}}
                                                        @endif


                                                       </td>
                                                        <td>


                                                    @if(!empty($item->Vendor_fk->Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Vendor_fk->Name :$item->Vendor_fk->Name}}
                                                        @endif



                                                    </td>


                                                    <td>
                                                        <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center-open{{$item->id}}">
                                                            {{trans('admin.Details')}}
                                                        </button>
                                                    </td>
                                                     <td>
                                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                           {{trans('admin.Data')}}
                                                        </button>
                                                    </td>

                                                    @php
                                                        $Total_Return_Qty=ReturnPurch::where('Purchase',$item->id)->get()->sum('Total_Return_Qty');
                                                        $Total_Qty=ProductsPurchases::where('Purchase',$item->id)->get()->sum('Original_Qty');
                                                    @endphp


                                                    @if($Total_Return_Qty !=$Total_Qty)

                                                    <td class="text-center" colspan="2">

                                                        @if($item->Edit == 0 and $item->Delete == 0)
                                     <div class="row">
                                     <div class="col-md-2">
                                           @can('ارتجاع فاتوره مشتريات')
             <a href="{{url('ReturnPurch/'.$item->id)}}" class="btn btn-default" data-toggle="tooltip" data-placement="top" title="{{trans('admin.Return')}}" data-original-title="{{trans('admin.Return')}}" ><i class="fal fa-arrow-right"></i></a>
                                        @endcan
                                         </div>
                                        <div class="col-md-2">
                 <a href="{{url('PurchPrint/'.$item->id)}}" class="btn btn-default" data-toggle="tooltip" data-placement="top" title="{{trans('admin.Print')}}" data-original-title="{{trans('admin.Print')}}" >
                                                    <i class="fal fa-print" ></i>
                                                    </a>
                                         </div>
                                        <div class="col-md-2">
       <a href="{{url('Barcode/'.$item->id)}}" class="btn btn-default"  data-toggle="tooltip" data-placement="top" title="{{trans('admin.Barcode_Print')}}" data-original-title="{{trans('admin.Barcode_Print')}} "><i class="fal fa-barcode"></i></a>                                        </div>


                                        <div class="col-md-2">
                                                          @can('تعديل فاتوره مشتريات')
             <a href="{{url('EditPuechasesBill/'.$item->id)}}" class="btn btn-default"  data-toggle="tooltip" data-placement="top" title="{{trans('admin.Edit')}}" data-original-title="{{trans('admin.Edit')}}"><i class="fal fa-edit"></i></a>
                                        @endcan
                                         </div>
                                            <div class="col-md-2">
                                                 @can('حذف فاتوره مشتريات')
             <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}" ><i class="fal fa-trash-alt" data-toggle="tooltip" data-placement="top" title="{{trans('admin.Delete')}}" data-original-title="{{trans('admin.Delete')}}"></i></button>
                                        @endcan
                                         </div>

                                                 </div>

                                                        @endif


                                                            @if($item->Edit == 1)
                                                                <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                                                <a href="{{url('PurchPrint/'.$item->id)}}" class="btn btn-default" data-toggle="tooltip" data-placement="top" title="{{trans('admin.Print')}}" data-original-title="{{trans('admin.Print')}}" >
                                                                    <i class="fal fa-print" ></i>
                                                                </a>
                                                            @elseif($item->Delete == 1)

                                                                <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>
                                                                <a href="{{url('PurchPrint/'.$item->id)}}" class="btn btn-default" data-toggle="tooltip" data-placement="top" title="{{trans('admin.Print')}}" data-original-title="{{trans('admin.Print')}}" >
                                                                    <i class="fal fa-print" ></i>
                                                                </a>
                                                            @endif



                                                    </td>

                                                    @else
                                                      <td>

                                                       {{trans('admin.FullReturned')}}
                                                      </td>

                                                    @endif
                                                </tr>
                                                @endforeach

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th> {{trans('admin.Payment_Method')}}</th>
                                                    <th> {{trans('admin.Safe')}} </th>
                                                    <th> {{trans('admin.Vendor')}} </th>
                                                    <th>{{trans('admin.Details')}}</th>
                                                    <th>{{trans('admin.Data')}}</th>
                                                    <th>{{trans('admin.Actions')}} </th>
                                                </tr>
                                            </tfoot>

                                        </table>

                                        {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </main>

  @foreach($items as $item)

                        <!-- Modal Details -->
    <div class="modal fade" id="default-example-modal-center-open{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                               {{trans('admin.Details')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">


                @php
                $details=ProductsPurchases::with('Product','Unit','Store' ,'V1', 'V2')->where('Purchase',$item->id)->get();
                @endphp
                        <div class="mt-3">
                            <div style="overflow:auto;">
                            <table id="details"
                            class="table table-bordered table-hover table-striped " >
                            <thead>
                                <tr>
                                    <th>{{trans('admin.Code')}} </th>
                                    <th>{{trans('admin.Name')}} </th>
                                     <th>{{trans('admin.Unit')}} </th>
                                    <th>{{trans('admin.Qty')}} </th>
                                    <th>{{trans('admin.Price')}} </th>
                                    <th>{{trans('admin.Discount')}} </th>
                                    <th>{{trans('admin.Total_Bf_Tax')}} </th>
                                    <th>{{trans('admin.Total_Tax')}} </th>
                                    <th>{{trans('admin.Total')}} </th>
                                    <th>{{trans('admin.The_Net')}} </th>
                                    <th>{{trans('admin.Store')}} </th>
                                    <th>{{trans('admin.Exp_Date')}} </th>
                                    <th>{{trans('admin.Later_Due')}} </th>

                                </tr>
                            </thead>
                            <tbody id="">


                                @foreach($details as $detail)
                                    @php
                                        $fqty=$detail->Original_Qty - $detail->Qty;
                                    @endphp
                                <tr @if($detail->Qty == 0) style="background-color:darkred;color:white" @elseif($fqty != 0) style="background-color:#21afe4;color:white"@elseif($detail->Discount != 0) style="background-color:darkgreen;color:white" @endif>
                                    <td>{{$detail->Product_Code}}</td>
                                    <td>

                                     @if(!empty($detail->Product_fk->P_Ar_Name))
                            {{app()->getLocale() == 'ar' ?$detail->Product_fk->P_Ar_Name :$detail->Product_fk->P_En_Name}}
                                        @endif

     @if(!empty($detail->V1))   ({{app()->getLocale() == 'ar' ?$detail->V1_fk->Name :$detail->V1_fk->NameEn}}  )  @endif
                                  @if(!empty($detail->V2))    (({{app()->getLocale() == 'ar' ?$detail->V2_fk->Name :$detail->V2_fk->NameEn}}  ))  @endif
                                    </td>


                                    <td>       @if(!empty($detail->Unit_fk->Name))
                                        {{app()->getLocale() == 'ar' ?$detail->Unit_fk->Name :$detail->Unit_fk->NameEn}}
                                    @endif
                                    </td>
                                    <td>

                                         {{$detail->Qty}} ({{$detail->Original_Qty - $detail->Qty}})

                                    </td>
                                    <td>{{$detail->Price}}</td>
                                    <td>{{$detail->Discount}}</td>
                                    <td>{{$detail->Total_Bf_Tax}}</td>
                                    <td>{{$detail->Total_Tax}}</td>
                                    <td>{{$detail->Total}}</td>
                                    <td>{{$detail->Total_Net}}</td>
                                    <td>
                                             @if(!empty($detail->Store_fk->Name))
                                        {{app()->getLocale() == 'ar' ?$detail->Store_fk->Name :$detail->Store_fk->NameEn}}
                                    @endif
                                    </td>
                                    <td>{{$detail->Exp_Date}}</td>
                                    <td>{{$detail->Later_Due}}</td>


                                </tr>
                                 @endforeach
                            </tbody>

                        </table>
                        </div>
                        <div style="overflow:auto;">
                        <table class="table table-bordered table-hover table-striped  mt-4" >
                            <tbody>

                            @php
                                $Total_Return=ReturnPurch::where('Purchase',$item->id)->get()->sum('Total_Return_Value');
                                $Total_Return_Qty=ReturnPurch::where('Purchase',$item->id)->get()->sum('Total_Return_Qty');
                                $Total_Return_BF_Taxes=ReturnPurch::where('Purchase',$item->id)->get()->sum('Total_BF_Taxes');
                                $Total_Return_Taxes=ReturnPurch::where('Purchase',$item->id)->get()->sum('Total_Taxes');
                                $Total_Return_Discount=ReturnPurch::where('Purchase',$item->id)->get()->sum('Total_Discount');

                            @endphp


                            <tr>
                                    <td>{{trans('admin.Product_Numbers')}}</td>
                                    <td>{{$item->Product_Numbers}}</td>

                                    <td>{{trans('admin.Total_Qty')}}</td>
                                    <td>{{$item->Total_Qty + $Total_Return_Qty}}</td>

                                <td>{{trans('admin.Total_Price')}}</td>
                                <td>{{number_format((float)$item->Total_Price + $Total_Return, 2, '.', '')}}</td>

                                <td>{{trans('admin.Total_Taxes')}}</td>
                                <td>{{$item->Total_Taxes + $Total_Return_Taxes}}</td>


                            </tr>


                            <tr>

                                <td>{{trans('admin.Total_Bf_Taxes')}}</td>
                                <td>{{$item->Total_BF_Taxes + $Total_Return_BF_Taxes}}</td>

                                <td>{{trans('admin.Total_Discount')}}</td>
                                <td>{{$item->Total_Discount + $Total_Return_Discount}}</td>


                                <td>{{trans('admin.Total_Net')}}</td>
                                <td>{{$item->Total_Net}}</td>

                                <td>{{trans('admin.Paid')}}</td>
                                <td>{{$item->Pay}}</td>


                            </tr>


                            <tr>


                                <td>{{trans('admin.Residual')}}</td>
                                <td>{{round($item->Total_Net) - round($item->Pay)}}</td>




                                <td>{{trans('admin.Total_Return')}}</td>
                                <td>{{$Total_Return}}</td>


                                <td>{{trans('admin.TotalNetReturn')}}</td>
                                <td>{{$item->Total_Net - $Total_Return}}</td>


                                <td>{{trans('admin.Total_Return_Qty')}}</td>
                                <td>{{$Total_Return_Qty}}</td>
                            </tr>



                            <tr>
                                <td>{{trans('admin.Total_Return_BF_Taxes')}}</td>
                                <td>{{$Total_Return_BF_Taxes}}</td>
                                <td>{{trans('admin.Total_Return_Taxes')}}</td>
                                <td>{{$Total_Return_Taxes}}</td>
                                <td>{{trans('admin.Total_Return_Discount')}}</td>
                                <td>{{$Total_Return_Discount}}</td>


                            </tr>
                            </tbody>
                        </table>
                        </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                                                                 @can('تعديل فاتوره مشتريات')
             <a href="{{url('EditPuechasesBill/'.$item->id)}}" class="btn btn-default"  data-toggle="tooltip" data-placement="top" title="تعديل" data-original-title="تعديل"><i class="fal fa-edit"></i></a>
                                        @endcan
                        </div>
                    </div>
                </div>
            </div>

            </div>

    <!-- Modal show data -->
    <div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                             {{trans('admin.Data')}}
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
      <div style="overflow:auto;">
        <table id="" class="table table-bordered table-hover table-striped " style="width:120%;">
                                            <thead class="bg-highlight">
                                                <tr>

                                                    <th> {{trans('admin.Draw')}} </th>

                                                    <th>{{trans('admin.Status')}} </th>
                                                    <th> {{trans('admin.Vendor_Bill_Date')}} </th>
                                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>

                                                    <th> {{trans('admin.Delegate')}} </th>
                                                    <th> {{trans('admin.Store')}} </th>
                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                    <th> {{trans('admin.Shipping_Compaines')}} </th>
                                                    <th> {{trans('admin.User')}} </th>
                                                    <th> {{trans('admin.File')}} </th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                                <tr>

                                                      <td>{{$item->Draw}}</td>

                                                        <td>

                                                         @if($item->Status == 1)
                                                       {{trans('admin.Recived')}}
                                                    @elseif($item->Status == 0)
                                                       {{trans('admin.Pending')}}
                                                    @endif
                                                    </td>
                                                        <td>{{$item->Vendor_Bill_Date}}</td>
                                                        <td>{{$item->Refernce_Number}}</td>
                                                        <td>{{$item->Note}}</td>


                                                        <td>



                                                       @if(!empty($item->Delegate_fk->Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Delegate_fk->Name :$item->Delegate_fk->Name}}
                                                        @endif


                                                    </td>
                                                        <td>



                                                       @if(!empty($item->Store_fk->Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Store_fk->Name :$item->Store_fk->Name}}
                                                        @endif



                                                    </td>
                                                        <td>


                                                       @if(!empty($item->Coin_fk->Arabic_Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Coin_fk->Arabic_Name :$item->Coin_fk->English_Name}}
                                                        @endif



                                                    </td>
                                                            <td>



                                                       @if(!empty($item->Cost_Center_fk->Arabic_Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Cost_Center_fk->Arabic_Name :$item->Cost_Center_fk->English_Name}}
                                                        @endif



                                                    </td>

                                                             <td>



                                                       @if(!empty($item->Ship_fk->Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Ship_fk->Name :$item->Ship_fk->NameEn}}
                                                        @endif



                                                    </td>

                                                             <td>




                                                       @if(!empty($item->User_fk->name))
                                                  {{app()->getLocale() == 'ar' ?$item->User_fk->name :$item->User_fk->nameEn}}
                                                        @endif


                                                    </td>
                                                                <td>
                                @if(!empty($item->File))
                            <a href="{{URL::to($item->File)}}" class="btn btn-primary" dowmload><i class="fal fa-download"></i></a>
                                        @endif
                                    </td>

                                                </tr>


                                            </tbody>
                                            <tfoot>
                                                <tr>

                                                    <th> {{trans('admin.Draw')}} </th>

                                                    <th>{{trans('admin.Status')}} </th>
                                                    <th> {{trans('admin.Vendor_Bill_Date')}} </th>
                                                    <th> {{trans('admin.Refernce_Number')}} </th>
                                                    <th> {{trans('admin.Notes')}} </th>

                                                    <th> {{trans('admin.Delegate')}} </th>
                                                    <th> {{trans('admin.Store')}} </th>
                                                    <th> {{trans('admin.Coin')}} </th>
                                                    <th> {{trans('admin.Cost_Center')}} </th>
                                                 <th> {{trans('admin.Shipping_Compaines')}} </th>
                                                    <th> {{trans('admin.User')}} </th>

                                                </tr>
                                            </tfoot>

                                        </table>


                                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>

                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Check -->
    <div class="modal fade" id="Check{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">

                                    <div class="row">
                                                <div class="col-md-4">
                                            <label>{{trans('admin.Check_Type')}}</label>

                                                <span>



                                                       @if(!empty($item->Check_Type_fk->Arabic_Name))
                                                  {{app()->getLocale() == 'ar' ?$item->Check_Type_fk->Arabic_Name :$item->Check_Type_fk->English_Name}}
                                                        @endif


                                                    </span>

                                                    </div>

                                                          <div class="col-md-4">
                                            <label>{{trans('admin.Due_Date')}}</label>
                                                <span>{{$item->Due_Date}}</span>
                                                    </div>

                                                          <div class="col-md-4">
                                            <label>{{trans('admin.Check_Number')}}</label>
                                                <span>{{$item->Check_Number}}</span>
                                                    </div>


                                                        </div>



                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.No')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>


          <!-- Modal Delete -->
                    <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeletePurchaseBill/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>


@endforeach



@endsection


@push('js')




    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <style>
        th{
            width:135px!important;
        }
    </style>

 <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable({
                // responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                lengthChange: true,

                dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                    {
                        extend: 'colvis',
                        text: 'Column Visibility',
                        titleAttr: 'Col visibility',
                        className: 'btn-outline-default'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        titleAttr: 'Generate PDF',
                        className: 'btn-outline-danger btn-sm mr-1'
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        titleAttr: 'Generate Excel',
                        className: 'btn-outline-success btn-sm mr-1'
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        titleAttr: 'Generate CSV',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'copyHtml5',
                        text: 'Copy',
                        titleAttr: 'Copy to clipboard',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        titleAttr: 'Print Table',
                        className: 'btn-outline-primary btn-sm'
                    }
                ],
            });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('#details thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#details thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#details').DataTable({
                // responsive: true,
                orderCellsTop: true,
                fixedHeader: true,
                lengthChange: true,

                dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                    {
                        extend: 'colvis',
                        text: 'Column Visibility',
                        titleAttr: 'Col visibility',
                        className: 'btn-outline-default'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: 'PDF',
                        titleAttr: 'Generate PDF',
                        className: 'btn-outline-danger btn-sm mr-1'
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        titleAttr: 'Generate Excel',
                        className: 'btn-outline-success btn-sm mr-1'
                    },
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        titleAttr: 'Generate CSV',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'copyHtml5',
                        text: 'Copy',
                        titleAttr: 'Copy to clipboard',
                        className: 'btn-outline-primary btn-sm mr-1'
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        titleAttr: 'Print Table',
                        className: 'btn-outline-primary btn-sm'
                    }
                ],
            });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#details thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#details').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

    <script>
    $(document).ready(function()
    {
        $(function()
        {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2(
            {
                placeholder: "Select State"
            });
            $(".js-hide-search").select2(
            {
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2(
            {
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2(
            {
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2(
            {
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm)
                {
                    return elm
                }
            });

            function icon(elm)
            {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }

            $(".js-data-example-ajax").select2(
            {
                ajax:
                {
                    url: "https://api.github.com/search/repositories",
                    dataType: 'json',
                    delay: 250,
                    data: function(params)
                    {
                        return {
                            q: params.term, // search term
                            page: params.page
                        };
                    },
                    processResults: function(data, params)
                    {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;

                        return {
                            results: data.items,
                            pagination:
                            {
                                more: (params.page * 30) < data.total_count
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Search for a repository',
                escapeMarkup: function(markup)
                {
                    return markup;
                }, // let our custom formatter work
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo)
            {
                if (repo.loading)
                {
                    return repo.text;
                }

                var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                    "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                    "<div class='select2-result-repository__meta'>" +
                    "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                if (repo.description)
                {
                    markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                }

                markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                    "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                    "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                    "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                    "</div>" +
                    "</div></div>";

                return markup;
            }

            function formatRepoSelection(repo)
            {
                return repo.full_name || repo.text;
            }
        });
    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function()
    {
        interval = setInterval(function()
        {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function()
    {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete
    var removeFromLocal = function()
    {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function()
    {
        //init default
        $('.js-summernote').summernote(
        {
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks:
            {
                //restore from localStorage
                onInit: function(e)
                {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable)
                {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax(
        {
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data)
        {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint:
            {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(emojis, function(item)
                    {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item)
                {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item)
                {
                    var url = emojiUrls[item];
                    if (url)
                    {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote(
        {
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint:
            {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback)
                {
                    callback($.grep(this.mentions, function(item)
                    {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item)
                {
                    return '@' + item;
                }
            }
        });

    });

</script>
<script type="text/javascript">


    $(".show-table").click(function(){
        $(".hide-table").show();
    });

</script>

	<style>
	@media print {
		body * {
			visibility: hidden;
		}
		.modal-content * {
			visibility: visible;
			overflow: visible;
		}
		.main-page * {
			display: none;
		}
		.modal {
			position: absolute;
			left: 0;
			top: -140px;
			margin: 0;
			padding: 0;
			font-size:20px;
			min-height: 550px;
			visibility: visible;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}
		.modal-dialog {
			visibility: visible !important;
			overflow: visible !important; /* Remove scrollbar for printing. */
		}

		  .page-content{
            display:none;
        }
        @page {

		size: a4;

    }


	}
	</style>




@endpush
