@extends('admin.index')
@section('content')
    @php
        use App\Models\SalesDefaultData;
        $Def=SalesDefaultData::orderBy('id','desc')->first();
    @endphp

    <title>{{trans('admin.ExchangeCommissions')}}</title>

<main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.HR')}} </a></li>
                        <li class="breadcrumb-item active">{{trans('admin.ExchangeCommissions')}}  </li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <form action="{{url('PostExchangeCommissions')}}" method="post">
                         {!! csrf_field() !!}
                              @honeypot
                            <div class="row">
                                    <div class="col-xl-12">
                                        <div  class="panel">
                                            <div class="panel-container show">
                                                 <span id="ex"> @include('admin.layouts.messages')</span>
                                                <div class="panel-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">{{trans('admin.ExchangeCommissions')}}  </h5>
                                                    </div>
                                                    <div class="panel-container show">
                                                        <div class="panel-content">

                                        <div class="form-row">
                                      <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                            <input type="text" value="{{$Code}}" class="form-control " disabled>
                                            <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                           <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                            <select class="select2 form-control w-100" name="Safe" required>
                                                 <option value=""> {{trans('admin.Safe')}}</option>
                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}" @if($Def->Safe == $safe->id) selected @endif>
                                        {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                            <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                            <select class="select2 form-control w-100" name="Coin" required>
                                                 <option value=""> {{trans('admin.Coin')}}</option>
                                            @foreach($Coins as $coin)
                                                <option value="{{$coin->id}}"  @if($Def->Coin == $coin->id) selected @endif>
                                       {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                            <input type="text" name="Draw" value="1" class="form-control" required>
                                        </div>
                                            <div class="form-group col-lg-3">
                                            <label class="form-label" for=""> {{trans('admin.Cost_Center')}} </label>
                                            <select class="select2 form-control w-100" name="Cost_Center">
                                            <option value=""> {{trans('admin.Cost_Center')}}</option>
                                            @foreach($CostCenters as $cost)
                                                <option value="{{$cost->id}}">
                                             {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Employee')}}</label>
                               <select onchange="Check()" class="js-data-example-ajax form-control w-100" id="Emp" name="Emp" required>

                                            </select>


                                        </div>


                                 <div class="form-group col-lg-3">
                          <label class="form-label" for="simpleinput">   {{trans('admin.Precentage_of_Sales')}}    </label>
                                   <input type="text" id="Pre_Sales"  disabled class="form-control">
                                       <input type="hidden" name="Pre_Sales" id="Pre_SalesHide" >
                                        </div>

                                    <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">   {{trans('admin.Precentage_of_Execution')}}    </label>
                                   <input type="text" id="Pre_Execu"  disabled class="form-control">
                                       <input type="hidden" name="Pre_Execu" id="Pre_ExecuHide" >
                                        </div>


                                      <div class="form-group col-lg-3" style="display: none">
                <label class="form-label" for="simpleinput">   {{trans('admin.Return_Maintaince')}}    </label>
                                   <input type="text" id="Return_Maintaince"  disabled class="form-control">
                                       <input type="hidden" name="Return_Maintaince" id="Return_MaintainceHide" >
                                        </div>


                                      <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">   {{trans('admin.Collection')}}    </label>
                                   <input type="text" id="Collection"  disabled class="form-control">
                                       <input type="hidden" name="Collection" id="CollectionHide" >
                                        </div>

                                                <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">   {{trans('admin.Total_Exchange_Commision')}}    </label>
                                   <input type="text" id="Total_Exchange_Commision"  disabled class="form-control">
                            <input type="hidden" name="Total_Exchange_Commision" id="Total_Exchange_CommisionHide" >
                                        </div>

                                <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">   {{trans('admin.Total_Commision')}}    </label>
                                   <input type="text" id="Commision"  disabled class="form-control">
                                       <input type="hidden" name="Commision" id="CommisionHide" >
                                        </div>

                                  <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">   {{trans('admin.Residual')}}    </label>
                                   <input type="text" id="Residual"  disabled class="form-control">

                                        </div>


                                                  <div class="form-group col-lg-3">
                <label class="form-label" for="simpleinput">   {{trans('admin.Amount')}}    </label>
         <input type="number" step="any" name="Amount" id="Amount" value="{{old('Amount')}}"   class="form-control" onclick="change()" onkeyup="change()">
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}  </label>
                                            <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                                        </div>


                                    <div class="form-row" style="display: none" id="Alert">
                                      <span id="ALertText" class="alert alert-danger"></span>
                                            </div>

                                    <div class="form-row" style="display: none" id="Submit">

                            <button type="submit" class="btn btn-primary">
                                        {{trans('admin.Save')}}
                                        </button>
                                            </div>

                                        </div>



                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div>
    </div>
               </form>
</main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

<!-- Search Selecet -->
<script>
    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $("#Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                      data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllEmpsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#Emp').empty();
                                  $.each(data, function(key, value){

                         $('#Emp').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $("#Emp").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });
        });
    });
</script>

<!-- Check Emp -->
<script>

   function  Check(){

   var Emp = $('#Emp').val();

                     if(Emp) {
                         $.ajax({
                             url: 'EmpCheckCommision/'+Emp,
                             type:"GET",
                             dataType:"json",
                             beforeSend: function(){
                                 $('#loader').css("visibility", "visible");
                             },

                             success:function(data) {
                                 $.each(data, function(key, value){


                       $('#Pre_Sales').val(data.Sales);
                       $('#Pre_SalesHide').val(data.Sales);
                       $('#Pre_Execu').val(data.Exec);
                       $('#Pre_ExecuHide').val(data.Exec);
                       $('#Return_Maintaince').val(data.Retu);
                       $('#Return_MaintainceHide').val(data.Retu);
                       $('#Total_Exchange_Commision').val(data.Ex);
                       $('#Total_Exchange_CommisionHide').val(data.Ex);
                       $('#Collection').val(data.collector);
                       $('#CollectionHide').val(data.collector);



        var  Pre_Sales=  $('#Pre_Sales').val();
        var  Pre_Execu=   $('#Pre_Execu').val();
        var  Return=  $('#Return_Maintaince').val();
        var  Exchange=  $('#Total_Exchange_Commision').val();
        var  CollectionHide=  $('#CollectionHide').val();

        var result = (parseFloat(Pre_Sales) + parseFloat(Pre_Execu) + parseFloat(CollectionHide))  -  parseFloat(Return) ;

    $('#Commision').val(parseFloat(result));
    $('#CommisionHide').val(parseFloat(result));
   var  Com=  $('#Commision').val();


        var re = parseFloat(Com)  -  parseFloat(Exchange)   ;

          $('#Residual').val(parseFloat(re));

        var  Residual=  $('#Residual').val();
        var  Amount=  $('#Amount').val();


                    if(parseFloat(Residual) <= 0){

                      document.getElementById("Submit").style.display = "none";
                    document.getElementById("Alert").style.display = "block";
                      $('#ALertText').text('لا يوجد عموله');


                    }else{

                        if(parseFloat(Amount) > parseFloat(Residual)){

                                  document.getElementById("Submit").style.display = "none";
                    document.getElementById("Alert").style.display = "block";
                      $('#ALertText').text('المبلغ اكبر من العموله');


                        }else{

                                            document.getElementById("Submit").style.display = "block";
                    document.getElementById("Alert").style.display = "none";
                      $('#ALertText').text('');



                        }




                    }




                                 });
                             }
                                 });
                     }
   }


</script>

<!-- Change -->
<script>
     function  change(){


        var  Pre_Sales=  $('#Pre_Sales').val();
        var  Pre_Execu=   $('#Pre_Execu').val();
        var  Return=  $('#Return_Maintaince').val();
        var  Exchange=  $('#Total_Exchange_Commision').val();
                var  CollectionHide=  $('#CollectionHide').val();
        var result = (parseFloat(Pre_Sales) + parseFloat(Pre_Execu) + parseFloat(CollectionHide))  -  parseFloat(Return) ;

    $('#Commision').val(parseFloat(result));
    $('#CommisionHide').val(parseFloat(result));
   var  Com=  $('#Commision').val();


        var re = parseFloat(Com)  -  parseFloat(Exchange)   ;

          $('#Residual').val(parseFloat(re));

        var  Residual=  $('#Residual').val();
        var  Amount=  $('#Amount').val();


                    if(parseFloat(Residual) <= 0){

                      document.getElementById("Submit").style.display = "none";
                    document.getElementById("Alert").style.display = "block";
                      $('#ALertText').text('لا يوجد عموله');


                    }else{

                        if(parseFloat(Amount) > parseFloat(Residual)){

                                  document.getElementById("Submit").style.display = "none";
                    document.getElementById("Alert").style.display = "block";
                      $('#ALertText').text('المبلغ اكبر من العموله');


                        }else{

                                            document.getElementById("Submit").style.display = "block";
                    document.getElementById("Alert").style.display = "none";
                      $('#ALertText').text('');



                        }




                    }




     }

</script>

@endpush
