@extends('admin.index')
@section('content')

  <title>{{trans('admin.Entitlements')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.HR')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Entitlements')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>
                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.Entitlements')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">

                                    @can(' اضافه  استحقاق')
                   <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                                    @endcan

                          <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                         <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Month')}}</th>
                                                    <th>{{trans('admin.Type')}}</th>
                                                    <th>{{trans('admin.Amount')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Code}}</td>
                                                    <td>{{$item->Date}}</td>
                                                    <td>{{$item->Month}}</td>
                                                    <td>
                                                        @if(!empty($item->Type()->first()->Arabic_Name))
                                         {{app()->getLocale() == 'ar' ?$item->Type()->first()->Arabic_Name :$item->Type()->first()->English_Name}}
                                                        @endif
                                                    </td>
                                                    <td>{{$item->Amount}}</td>
                                                    <td>{{$item->Draw}}</td>
                                                    <td>{{$item->Note}}</td>
                                                    <td>
                                                        @if(!empty($item->Emp()->first()->Name))
                                        {{app()->getLocale() == 'ar' ?$item->Emp()->first()->Name :$item->Emp()->first()->NameEn}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Coin()->first()->Arabic_Name))
                                        {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(!empty($item->User()->first()->name))
                                            {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->name}}
                                                        @endif
                                                    </td>

                                                    <td class="text-center">
                                             @can(' حذف  استحقاق')
                         <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-center{{$item->id}}"><i class="fal fa-trash"></i></button>
                            @endcan

                                                     @can(' تعديل  استحقاق')
       <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg-edit{{$item->id}}"><i class="fal fa-edit"></i></button>
                            @endcan


                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Code')}}</th>
                                                    <th>{{trans('admin.Date')}}</th>
                                                    <th>{{trans('admin.Month')}}</th>
                                                    <th>{{trans('admin.Type')}}</th>
                                                    <th>{{trans('admin.Amount')}}</th>
                                                    <th>{{trans('admin.Draw')}}</th>
                                                    <th>{{trans('admin.Notes')}}</th>
                                                    <th>{{trans('admin.Employee')}}</th>
                                                    <th>{{trans('admin.Coin')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                       {{$items->Links()}}
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Add-->
         <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('AddEntitlements')}}" method="post">
                                        {!! csrf_field() !!}
                                  @honeypot
                                            <div class="form-row">
                                      <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                            <input type="text" value="{{$Code}}" class="form-control " disabled>
                                            <input type="hidden" name="Code" value="{{$Code}}" class="form-control">
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                           <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-3">
                               <label class="form-label" for="simpleinput">{{trans('admin.Month')}}</label>
                <input  type="month" id="Month" name="Month" value="{{old('Month')}}" class="form-control" required>
                                        </div>

                                            <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                            <select class="select2 form-control w-100" name="Coin" required>
                                                 <option value=""> {{trans('admin.Coin')}}</option>
                                            @foreach($Coins as $coin)
                                                <option value="{{$coin->id}}">

                                     {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                            <input type="text" name="Draw" value="1" class="form-control" required>
                                        </div>
                                            <div class="form-group col-lg-3">
                                            <label class="form-label" for=""> {{trans('admin.Type')}} </label>
                                            <select class="select2 form-control w-100" name="Type">
                                            <option value=""> {{trans('admin.Type')}}</option>
                                            @foreach($BeneftisTypes as $typ)
                                                <option value="{{$typ->id}}">

                                     {{app()->getLocale() == 'ar' ?$typ->Arabic_Name :$typ->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Employee')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Emp"  name="Emp" required>

                                            </select>
                                        </div>


                                        <div class="form-group col-lg-3">
                                   <label class="form-label" for="simpleinput">  {{trans('admin.Amount')}}     </label>
               <input type="number"   step="any" id="Amount" value="0" name="Amount"  class="form-control" required>
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}  </label>
                                            <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                                        </div>

                                        </div>

                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>


         @foreach($items as $item)
  <!-- Modal Edit-->
                    <div class="modal fade" id="default-example-modal-lg-edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('EditEntitlements/'.$item->id)}}" method="post">
                                        {!! csrf_field() !!}
                                              @honeypot
                                      <div class="form-row">
                                      <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Code')}} </label>
                                            <input type="text" value="{{$item->Code}}" class="form-control " disabled>
                                            <input type="hidden" name="Code" value="{{$item->Code}}" class="form-control">
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                           <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                                        </div>
                                        <div class="form-group col-lg-3">
                               <label class="form-label" for="simpleinput">{{trans('admin.Month')}}</label>
                <input  type="month" id="Month" name="Month" value="{{$item->Month}}" class="form-control" required>
                                        </div>

                                            <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Coin')}}</label>
                                            <select class="select2 form-control w-100" name="Coin" required>
                                                 <option value=""> {{trans('admin.Coin')}}</option>
                                            @foreach($Coins as $coin)
                <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected  @endif>
                                          {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                                            <input type="text" name="Draw" value="{{$item->Draw}}" class="form-control" required>
                                        </div>
                                            <div class="form-group col-lg-3">
                                            <label class="form-label" for=""> {{trans('admin.Type')}} </label>
                                            <select class="select2 form-control w-100" name="Type">
                                            <option value=""> {{trans('admin.Type')}}</option>
                                            @foreach($BeneftisTypes as $typ)
                                                <option value="{{$typ->id}}"  @if($item->Type == $typ->id) selected  @endif>
                                                    {{app()->getLocale() == 'ar' ?$typ->Arabic_Name :$typ->English_Name}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                            <label class="form-label" for="">{{trans('admin.Employee')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Emp" name="Emp" required>
                                   <option value="{{$item->Emp}}">{{$item->Emp()->first()->Name}}</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-lg-3">
                                   <label class="form-label" for="simpleinput">  {{trans('admin.Amount')}}     </label>
         <input type="number"  step="any" id="Amount" value="{{$item->Amount}}" name="Amount"  class="form-control" required>
                                        </div>

                                        <div class="form-group col-lg-12">
                                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}  </label>
                                            <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                        </div>

                                        </div>
                                    <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                      <!-- Modal Delete -->
                      <div class="modal fade" id="default-example-modal-center{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                          {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteEntitlements/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
        @endforeach
                </main>

@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>

<!-- Search Selecet -->
<script>
    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $(".Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                      data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllEmpsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Emp').empty();
                                  $.each(data, function(key, value){

                         $('.Emp').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Emp").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });
        });
    });
</script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
@endpush

