@extends('admin.index')
@section('content')
<title>{{trans('admin.Add_Emp')}}</title>
<main id="js-page-content" role="main" class="page-content">
   <ol class="breadcrumb page-breadcrumb">
      <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.HR')}}</a></li>
      <li class="breadcrumb-item active">{{trans('admin.Add_Emp')}}</li>
      <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
         class="js-get-date"></span></li>
   </ol>
   <form action="{{url('PostEditEmp/'.$item->id)}}" method="post" enctype="multipart/form-data">
      {!! csrf_field() !!}
      @honeypot
      <div class="row">
         <div class="col-xl-12">
            <div  class="panel">
               <div class="panel-container show">
                  <span id="ex"> @include('admin.layouts.messages')</span>
                  <div class="panel-content">
                     <div class="panel-container show">
                        <div class="panel-content">
                           <ul class="nav nav-tabs" role="tablist">
                              <li class="nav-item">
                                 <a class="nav-link active" data-toggle="tab" href="#tab_borders_icons-1" role="tab"><i class="fal fa-home mr-1"></i>   {{trans('admin.Main_Data')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-2" role="tab"><i class="fal fa-user mr-1"></i>  {{trans('admin.Sub_Data')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-4" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Employment_data')}}</a>
                              </li>
                              <li class="nav-item">
                                 <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-3" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Ratio')}}</a>
                              </li>

                                                                            <li class="nav-item">
          <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-6" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Allowances')}}</a>
                                                    </li>

                                                                                             <li class="nav-item">
          <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-5" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Discounts')}}</a>
                                                    </li>

                                                                                                                <li class="nav-item">
          <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-7" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.production_quantity')}}</a>
                                                    </li>

                                                                                                                                      <li class="nav-item">
          <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-9" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Attendence_Policy')}}</a>
                                                    </li>

                                                                                                                             <li class="nav-item">
          <a class="nav-link" data-toggle="tab" href="#tab_borders_icons-10" role="tab"><i class="fal fa-dollar-sign mr-1"></i>  {{trans('admin.Departure_Policy')}}</a>
                                                    </li>


                           </ul>
                           <div class="tab-content border border-top-0 p-3">
                              <div class="tab-pane fade show active" id="tab_borders_icons-1" role="tabpanel">
                                 <div class="form-row">
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput">  {{trans('admin.Code')}}</label>
                                       <input type="text"  value="{{$item->Code}}" disabled class="form-control">
                                       <input type="hidden" name="Code" value="{{$item->Code}}">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.EmpSort')}}</label><span class="strick">*</span>
                                       <select class="select2 form-control w-100" name="EmpSort" required>
                                       <option value="1" @if($item->EmpSort == 1) selected @endif>{{trans('admin.Employee')}}</option>
                                       <option value="2" @if($item->EmpSort == 2) selected @endif>{{trans('admin.JobApplication')}}</option>
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}} </label><span class="strick">*</span>
                                       <input type="text" name="Name" value="{{$item->Name}}" class="form-control" required>
                                    </div>
                                     <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}} </label><span class="strick">*</span>
                                       <input type="text" name="NameEn" value="{{$item->NameEn}}" class="form-control" required>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Job')}}</label><span class="strick">*</span>
                                       <select class="select2 form-control w-100" name="Job" required>
                                          <option value="">{{trans('admin.Job')}}</option>
                                          @foreach($JobsTypes as $job)
                                          <option value="{{$job->id}}" @if($item->Job  == $job->id)  selected    @endif >
                                          {{app()->getLocale() == 'ar' ?$job->Arabic_Name :$job->English_Name}}
                                          </option>
                                          @endforeach
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Emp_Type')}}</label><span class="strick">*</span>
                                       <select class="select2 form-control w-100" name="Emp_Type" required>
                                          <option value="">{{trans('admin.Emp_Type')}}</option>
                                          <option value="Manager"  @if($item->Emp_Type  == "Manager")  selected    @endif>{{trans('admin.Manager')}}</option>
                                          <option value="Production_Manager" @if($item->Emp_Type  == "Production_Manager")  selected    @endif>{{trans('admin.Production_Manager')}}</option>
                                          <option value="Saller" @if($item->Emp_Type  == "Saller")  selected    @endif>{{trans('admin.Saller')}}</option>
                                          <option value="Buyer" @if($item->Emp_Type  == "Buyer")  selected    @endif>{{trans('admin.Buyer')}}</option>
                                          <option value="Driver" @if($item->Emp_Type  == "Driver")  selected    @endif>{{trans('admin.Driver')}}</option>
                                          <option value="Engineer" @if($item->Emp_Type  == "Engineer")  selected    @endif>{{trans('admin.Engineer')}}</option>
                                          <option value="Techinical" @if($item->Emp_Type  == "Techinical")  selected    @endif>{{trans('admin.Techinical')}}</option>
                                          <option value="Delivery" @if($item->Emp_Type  == "Delivery")  selected    @endif>{{trans('admin.Delivery')}}</option>
                                          <option value="Designer" @if($item->Emp_Type  == "Designer")  selected    @endif>{{trans('admin.Designer')}}</option>
                                          <option value="Programmer" @if($item->Emp_Type  == "Programmer")  selected    @endif>{{trans('admin.Programmer')}}</option>
                                          <option value="Accountant" @if($item->Emp_Type  == "Accountant")  selected    @endif>{{trans('admin.Accountant')}}</option>
                                          <option value="StoreKeeper" @if($item->Emp_Type  == "StoreKeeper")  selected    @endif>{{trans('admin.Store_Keeper')}}</option>
                                          <option value="ObserverQuality" @if($item->Emp_Type  == "ObserverQuality")  selected    @endif>{{trans('admin.Observer_Quality')}}</option>
                                          <option value="Supervisor" @if($item->Emp_Type  == "Supervisor")  selected    @endif>{{trans('admin.Supervisor')}}</option>
                                          <option value="Doctor" @if($item->Emp_Type  == "Doctor")  selected    @endif>{{trans('admin.Doctor')}}</option>
                                          <option value="Teacher" @if($item->Emp_Type  == "Teacher")  selected    @endif>{{trans('admin.Teacher')}}</option>
                                          <option value="Worker" @if($item->Emp_Type  == "Worker")  selected    @endif>{{trans('admin.Worker')}}</option>
                                          <option value="Nurse" @if($item->Emp_Type  == "Nurse")  selected    @endif>{{trans('admin.Nurse')}}</option>
                                          <option value="Cashier" @if($item->Emp_Type  == "Cashier")  selected    @endif>{{trans('admin.Cashier')}}</option>
                                          <option value="Chef" @if($item->Emp_Type  == "Chef")  selected    @endif>{{trans('admin.Chef')}}</option>
                                          <option value="Waiter" @if($item->Emp_Type  == "Waiter")  selected    @endif>{{trans('admin.Waiter')}}</option>
                                          <option value="Secuirty" @if($item->Emp_Type  == "Secuirty")  selected    @endif>{{trans('admin.Secuirty')}}</option>
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Account')}}</label><span class="strick">*</span>
                                       <select class="select2 form-control w-100" name="Account" required>
                                          <option value="">{{trans('admin.Account')}}</option>
                                          @foreach($Accounts as $acc)
                                          <option value="{{$acc->id}}" @if($item->Account  == $acc->id)  selected    @endif>
                                   {{app()->getLocale() == 'ar' ?$acc->Name :$acc->NameEn}}
                                          </option>
                                          @endforeach
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Department')}}</label><span class="strick">*</span>
                                       <select class="select2 form-control w-100" name="Department" required>
                                          <option value="">{{trans('admin.Department')}}</option>
                                          @foreach($Departments as $dep)
                                          <option value="{{$dep->id}}" @if($item->Department  == $dep->id)  selected    @endif>
                                          {{app()->getLocale() == 'ar' ?$dep->Arabic_Name :$dep->English_Name}}
                                          </option>
                                          @endforeach
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.POSStores')}}</label>
                                       <select class="select2 form-control w-100" multiple  name="POSStores[]"  required>
                                       @foreach($Stores as $sto)
                                       <option value="{{$sto->id}}"
                                       @foreach($POSS as $pos)
                                       @if($pos->Store == $sto->id)
                                       selected
                                       @endif
                                       @endforeach
                                       >           {{app()->getLocale() == 'ar' ?$sto->Name :$sto->NameEn}}    </option>
                                       @endforeach
                                       </select>
                                    </div>
                                     <div class="form-group col-md-2">
                                         <label class="form-label" for="">  {{trans('admin.Safes')}}</label>
                                         <select class="select2 form-control  w-100" multiple  name="POSSafes[]"  required>
                                             @foreach($Safes as $safe)
                                                 <option value="{{$safe->id}}"
                                                         @foreach($POSSafes as $psaf)
                                                             @if($psaf->Safe == $safe->id)
                                                                 selected
                                                     @endif
                                                     @endforeach

                                                 >
                                                     {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                 </option>
                                             @endforeach
                                         </select>
                                     </div>

                                    <div class="form-group col-md-2" id="NUMOFBILLLL" style="display: none">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.NumbersOfBill')}} </label>
                                       <input type="number"  name="NumbersOfBill" value="{{$item->NumbersOfBill}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput">  {{trans('admin.Salary')}}</label><span class="strick">*</span>
                                       <input type="number" step="any" name="Salary" value="{{$item->Salary}}" class="form-control" required>
                                    </div>
                                 </div>
                                 <div class="form-row">
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Attendence')}}  </label>
                                       <input type="time" name="Attendence" value="{{$item->Attendence}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Departure')}}  </label>
                                       <input type="time" name="Departure" value="{{$item->Departure}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">   {{trans('admin.Hours_Numbers')}} </label>
                                       <input type="number" name="Hours_Numbers" value="{{$item->Hours_Numbers}}" class="form-control" required>
                                    </div>
                                               <div class="form-group col-md-2">
                                    <label class="form-label" for="">   {{trans('admin.MonthlyTarget')}} </label>
                        <input type="number" name="MonthlyTarget" value="{{$item->MonthlyTarget}}" class="form-control" required>
                                                        </div>

                                                                       <div class="form-group col-md-2">
                                    <label class="form-label" for="">   {{trans('admin.QuarterTarget')}} </label>
                        <input type="number" name="QuarterTarget" value="{{$item->QuarterTarget}}" class="form-control" required>
                                                        </div>

                                                                       <div class="form-group col-md-2">
                                    <label class="form-label" for="">   {{trans('admin.SemiTarget')}} </label>
                        <input type="number" name="SemiTarget" value="{{$item->SemiTarget}}" class="form-control" required>
                                                        </div>

                                                                       <div class="form-group col-md-2">
                                    <label class="form-label" for="">   {{trans('admin.YearlyTarget')}} </label>
                        <input type="number" name="YearlyTarget" value="{{$item->YearlyTarget}}" class="form-control" required>
                                                        </div>

                                        <div class="form-group col-md-2">
                        <label class="form-label" for="">  {{trans('admin.Group')}}</label>
                     <select class="select2 form-control  w-100"  name="Pro_Group" >
                              <option value=""> {{trans('admin.Group')}}</option>
                                       @foreach($Groups as $grop)
<option value="{{$grop->id}}" @if($grop->id == $item->Pro_Group) selected @endif>
                          {{app()->getLocale() == 'ar' ?$grop->Name :$grop->NameEn}}

                         </option>
                                       @endforeach
                                                            </select>
                                                        </div>

                                 </div>
                                 <div class="form-row">
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-2" role="tabpanel">
                                 <div class="form-row">
                                    <div class="form-group col-lg-4">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Price_Level')}}</label>
                                       <select class="select2 form-control" name="Price_Level" required>
                                          <option value="">{{trans('admin.Price_Level')}}</option>
                                          <option value="1"  @if($item->Price_Level  == 1)  selected    @endif>{{trans('admin.Level_1')}}</option>
                                          <option value="2"  @if($item->Price_Level  == 2)  selected    @endif>{{trans('admin.Level_2')}}</option>
                                          <option value="3"  @if($item->Price_Level  == 3)  selected    @endif>{{trans('admin.Level_3')}}</option>
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Bill_Numbers')}}</label>
                                       <select class="select2 form-control w-100" id="Bill_Num" name="Bill_Num" onchange="bill()" required>
                                       <option value="0" @if($item->Bill_Num == 0) selected @endif>{{trans('admin.No')}}</option>
                                       <option value="1" @if($item->Bill_Num == 1) selected @endif>{{trans('admin.Yes')}}</option>
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">   {{trans('admin.Days_Numbers')}} </label>
                                       <input type="number" name="Days_Numbers" value="{{$item->Days_Numbers}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">   {{trans('admin.Day_Price')}} </label>
                                       <input type="number" name="Day_Price" value="{{$item->Day_Price}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="">  {{trans('admin.Notes')}}    </label>
                                       <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3 mb-3">
                                       <label class="form-label customize-input" for="imgInp"><i class="fal fa-image"></i> {{trans('admin.Image')}}  </label>
                                       <input type='file' name="Image" />
                                       <input type='hidden' name="Images" value="{{$item->Image}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Bank_Account')}}  </label>
                                       <input type="text" name="Bank_Account" value="{{$item->Bank_Account}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Qualifications')}}   </label>
                                       <input type="text" name="Qualifications" value="{{$item->Qualifications}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.Address')}}    </label>
                                       <input type="text" name="Address" value="{{$item->Address}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.Social_Status')}}  </label>
                                       <input type="text" name="Social_Status" value="{{$item->Social_Status}}" class="form-control">
                                    </div>

                                        <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.IDExpireDate')}}  </label>
                                       <input type="date" name="IDExpireDate" value="{{$item->IDExpireDate}}" class="form-control">
                                    </div>
                                        <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.LicensExpireDate')}}  </label>
                                       <input type="date" name="LicensExpireDate" value="{{$item->LicensExpireDate}}" class="form-control">
                                    </div>
                                        <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.PassportExpireDate')}}  </label>
                                       <input type="date" name="PassportExpireDate" value="{{$item->PassportExpireDate}}" class="form-control">
                                    </div>




                                 </div>
                                 <div class="form-row">
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.ID_Number')}}  </label>
                                       <input type="number" name="ID_Number" value="{{$item->ID_Number}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.Contract_Start')}}  </label>
                                       <input type="date" name="Contract_Start" value="{{$item->Contract_Start}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.Contract_End')}}  </label>
                                       <input type="date" name="Contract_End" value="{{$item->Contract_End}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}  </label>
                                       <input type="number" name="Phone" value="{{$item->Phone}}" class="form-control">
                                    </div>
                                 </div>
                                 <div class="form-row">
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput">{{trans('admin.Phone2')}}   </label>
                                       <input type="number" name="Phone2" value="{{$item->Phone2}}" class="form-control">
                                    </div>
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-4" role="tabpanel">
                                 <div class="form-row">
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.CV')}} </label>
                                       <input type="file" name="CV">
                                       <input type='hidden' name="CVs" value="{{$item->CV}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.ID_Image')}} </label>
                                       <input type="file" name="ID_Image">
                                       <input type='hidden' name="ID_Images" value="{{$item->ID_Image}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Criminal_status')}} </label>
                                       <input type="file" name="Criminal_status">
                                       <input type='hidden' name="Criminal_statuss" value="{{$item->Criminal_status}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Contract')}} </label>
                                       <input type="file" name="Contract">
                                       <input type='hidden' name="Contracts" value="{{$item->Contract}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.health_certificate')}} </label>
                                       <input type="file" name="health_certificate">
                                       <input type='hidden' name="health_certificates" value="{{$item->health_certificate}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Search_Card')}} </label>
                                       <input type="file" name="Search_Card">
                                       <input type='hidden' name="Search_Cards" value="{{$item->Search_Card}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Recruitment_certificate')}} </label>
                                       <input type="file" name="Recruitment_certificate">
                                       <input type='hidden' name="Recruitment_certificates" value="{{$item->Recruitment_certificate}}" />
                                    </div>
                                    <div class="form-group col-md-3">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.employee_profile')}} </label>
                                       <input type="file" name="employee_profile">
                                       <input type='hidden' name="employee_profiles" value="{{$item->employee_profile}}" />
                                    </div>
                                    <hr>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.duration_criminal_investigation')}} </label>
                                       <input type="date" name="duration_criminal_investigation" value="{{$item->duration_criminal_investigation}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Birthdate')}} </label>
                                       <input type="date" name="Birthdate" value="{{$item->Birthdate}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Attitude_recruiting')}} </label>
                                       <input type="text" name="Attitude_recruiting" value="{{$item->Attitude_recruiting}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Job_Number')}} </label>
                                       <input type="text" name="Job_Number" value="{{$item->Job_Number}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.date_resignation')}} </label>
                                       <input type="date" name="date_resignation" value="{{$item->date_resignation}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Living')}} </label>
                                       <input type="text" name="Living" value="{{$item->Living}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Religion')}} </label>
                                       <input type="text" name="Religion" value="{{$item->Religion}}" class="form-control">
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Insurance_salary')}} </label>
                                       <input type="text" name="Insurance_salary" value="{{$item->Insurance_salary}}" class="form-control">
                                    </div>


                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.Previous_experience')}} </label>
                                       <input type="text" name="Previous_experience" value="{{$item->Previous_experience}}" class="form-control">
                                    </div>

                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="simpleinput"> {{trans('admin.SearchCode')}} </label>
                                       <input type="text" name="SearchCode" value="{{$item->SearchCode}}" class="form-control">
                                    </div>



                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Branch')}}</label>
                                       <select class="select2 form-control w-100" name="Branch">
                                          <option value="">{{trans('admin.Branch')}}</option>
                                          @foreach($Branches as $branch)
                                          <option value="{{$branch->id}}" @if($item->Branch == $branch->id) selected @endif>           {{app()->getLocale() == 'ar' ?$branch->Arabic_Name :$branch->English_Name}}</option>
                                          @endforeach
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Level')}}</label>
                                       <select class="select2 form-control w-100" name="Level">
                                          <option value="">{{trans('admin.Level')}}</option>
                                          @foreach($Employment_levels as $level)
                                          <option value="{{$level->id}}" @if($item->Level == $level->id) selected @endif>         {{app()->getLocale() == 'ar' ?$level->Arabic_Name :$level->English_Name}}</option>
                                          @endforeach
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Insurance_companies')}}</label>
                                       <select class="select2 form-control w-100" name="Insurance_companies">
                                          <option value="">{{trans('admin.Insurance_companies')}}</option>
                                          @foreach($Insurance_companies as $comp)
                                          <option value="{{$comp->id}}" @if($item->Insurance_companies == $comp->id) selected @endif>

                                             {{app()->getLocale() == 'ar' ?$comp->Arabic_Name :$comp->English_Name}}

                                           </option>
                                          @endforeach
                                       </select>
                                    </div>
                                    <div class="form-group col-md-2">
                                       <label class="form-label" for="">  {{trans('admin.Nationality')}}</label>
                                       <select class="select2 form-control w-100" name="Nationality">
                                          <option value="">{{trans('admin.Nationality')}}</option>
                                          @foreach($Countris as $cunt)
                                          <option value="{{$cunt->id}}" @if($item->Nationality == $cunt->id) selected @endif >


                                              {{app()->getLocale() == 'ar' ?$cunt->Arabic_Name :$cunt->English_Name}}
                                           </option>
                                          @endforeach
                                       </select>
                                    </div>
                                 </div>
                              </div>
                              <div class="tab-pane fade" id="tab_borders_icons-3" role="tabpanel">
                                 <div class="panel-container show">
                                    <div class="panel-content">
                                       <div id="mobile-overflow">
                                          <table
                                             class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Salary')}} %</th>
                                                   <th>{{trans('admin.Precent')}} % </th>
                                                   <th>{{trans('admin.Rate_Type')}} </th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <tr>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="from" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="to" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="salary" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <input type="number" onkeyup="PLUS()" onclick="PLUS()" step="any" id="rate" class="form-control">
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <div class="form-group">
                                                         <select onchange="PLUS()" class="slesct2 form-control w-100" id="type">
                                                            <option value="1"> {{trans('admin.Precentage_of_Sales')}}  </option>
                                                            <option value="2"> {{trans('admin.Precentage_of_Execution')}}  </option>
                                                            <option value="3"> {{trans('admin.Precentage_of_Collection')}}  </option>


                                                         </select>
                                                      </div>
                                                   </td>
                                                   <td>
                                                      <button type="button" onclick="InsertData()" class="btn btn-default" id="add-data"><i class="fal fa-plus"></i></button>
                                                   </td>
                                                </tr>
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable start -->
                                       <div id="mobile-overflow">
                                          <table id=""
                                             class="table table-bordered table-hover table-striped w-100 mobile-width">
                                             <thead>
                                                <tr>
                                                   <th>{{trans('admin.From')}}</th>
                                                   <th>{{trans('admin.To')}}</th>
                                                   <th>{{trans('admin.Salary')}} %</th>
                                                   <th>{{trans('admin.Precent')}} % </th>
                                                   <th>{{trans('admin.Rate_Type')}} </th>
                                                   <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                             </thead>
                                             <tbody id="data-dt">
                                                @foreach($ratios as $rate)
                                                <tr>
                                                   <td>
                                                      {{$rate->From}}
                                                   </td>
                                                   <td>
                                                      {{$rate->To}}
                                                   </td>
                                                   <td>
                                                      {{$rate->Salary}}
                                                   </td>
                                                   <td>
                                                      {{$rate->Rate}}
                                                   </td>
                                                   <td>
                                                      {{$rate->Type}}
                                                      <input type="hidden" name="from[]" value="{{$rate->From}}">
                                                      <input type="hidden" name="to[]" value="{{$rate->To}}">
                                                      <input type="hidden" name="salary[]" value="{{$rate->Salary}}">
                                                      <input type="hidden" name="rate[]" value="{{$rate->Rate}}">
                                                      <input type="hidden" name="type[]" value="{{$rate->Type}}">
                                                      <input type="hidden" name="typee[]" value="{{$rate->Typee}}">
                                                   </td>
                                                   <td>
                                                      <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                   </td>
                                                </tr>
                                                @endforeach
                                             </tbody>
                                          </table>
                                       </div>
                                       <!-- datatable end -->
                                    </div>
                                 </div>
                              </div>
                                  <div class="tab-pane fade" id="tab_borders_icons-6" role="tabpanel">
                                      <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.Name')}}</th>
                                                                        <th>{{trans('admin.Amount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>
                                                                        <td>
                                                                                              <div class="form-group">
                            <select onchange="PLUSAllow()" class="form-control w-100" id="Allow">
       @foreach($Aloownces  as $allow)
        <option value="{{$allow->id}}">   {{app()->getLocale() == 'ar' ?$allow->Arabic_Name :$allow->English_Name}}       </option>
                        @endforeach
                                                   </select>

                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSAllow()" onclick="PLUSAllow()" step="any" id="AmountAllow" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertDataAllow()" class="btn btn-default" id="add-dataAlow"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                         <th>{{trans('admin.Name')}}</th>
                                                                        <th>{{trans('admin.Amount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dtAllow">
                                                         @foreach($alow as $rate)
                                                <tr>
                                                   <td>
                                                  @if(!empty($rate->Allow()->first()->Arabic_Name))


                                                     {{app()->getLocale() == 'ar' ?$rate->Allow()->first()->Arabic_Name :$rate->Allow()->first()->English_Name}}

                                                       @endif
                                                   </td>
                                                   <td>
                                                      {{$rate->AmountAllow}}
                                                         <input type="hidden" name="Allow[]" value="{{$rate->Allow}}">
                                                      <input type="hidden" name="AmountAllow[]" value="{{$rate->AmountAllow}}">
                                                   </td>

                                                   <td>
                                                      <button id="DelAllow" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                   </td>
                                                </tr>
                                                @endforeach
                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>


                                                    </div>
                                   <div class="tab-pane fade" id="tab_borders_icons-5" role="tabpanel">
                                      <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.Name')}}</th>
                                                                        <th>{{trans('admin.Amount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>
                                                                        <td>
                                                                                              <div class="form-group">
                            <select onchange="PLUSDiscount()" class="form-control w-100" id="Discount">
       @foreach($Discounts  as $dis)
        <option value="{{$dis->id}}">     {{app()->getLocale() == 'ar' ?$dis->Arabic_Name :$dis->English_Name}}       </option>
                        @endforeach
                                                   </select>

                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSDiscount()" onclick="PLUSDiscount()" step="any" id="AmountDiscount" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertDataDiscount()" class="btn btn-default" id="add-dataDiscount"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                         <th>{{trans('admin.Name')}}</th>
                                                                        <th>{{trans('admin.Amount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dtDiscount">

                                                                          @foreach($disco as $rate)
                                                <tr>
                                                   <td>
                                                  @if(!empty($rate->Discount()->first()->Arabic_Name))


                                                           {{app()->getLocale() == 'ar' ?$rate->Discount()->first()->Arabic_Name :$rate->Discount()->first()->English_Name}}

                                                       @endif
                                                   </td>
                                                   <td>
                                                      {{$rate->AmountDiscount}}
                                                         <input type="hidden" name="Discount[]" value="{{$rate->Discount}}">
                                                      <input type="hidden" name="AmountDiscount[]" value="{{$rate->AmountDiscount}}">
                                                   </td>

                                                   <td>
                                                      <button id="DelDiscount" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                   </td>
                                                </tr>
                                                @endforeach
                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>


                                                    </div>
       <div class="tab-pane fade" id="tab_borders_icons-7" role="tabpanel">
                                      <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Value')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>

                                                                                                                 <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSQuantity()" onclick="PLUSQuantity()" step="any" id="FromQ" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                                                                 <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSQuantity()" onclick="PLUSQuantity()" step="any" id="ToQ" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSQuantity()" onclick="PLUSQuantity()" step="any" id="ValueQ" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertDataQuantity()" class="btn btn-default" id="add-dataQ" style="display: none"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Value')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dtQ">
                                                   @foreach($Qties as $qty)
                                                <tr>
                                                   <td>
                                                {{$qty->FromQ}}
                                                   </td>
                                                            <td>
                                                {{$qty->ToQ}}
                                                   </td>
                                                   <td>
                                                      {{$qty->ValueQ}}
                                                         <input type="hidden" name="FromQ[]" value="{{$qty->FromQ}}">
                                                      <input type="hidden" name="ToQ[]" value="{{$qty->ToQ}}">
                                                      <input type="hidden" name="ValueQ[]" value="{{$qty->ValueQ}}">
                                                   </td>

                                                   <td>
                                                      <button id="DelQ" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                   </td>
                                                </tr>
                                                @endforeach
                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>


                                                    </div>

                                        <div class="tab-pane fade" id="tab_borders_icons-9" role="tabpanel">
                                      <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Discount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>

                                                                                                                 <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSAttP()" onclick="PLUSAttP()" step="any" id="FromAttP" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                                                                 <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSAttP()" onclick="PLUSAttP()" step="any" id="ToAttP" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSAttP()" onclick="PLUSAttP()" step="any" id="DiscountAttP" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertDataAttP()" class="btn btn-default" id="add-dataAttP" style="display: none"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Discount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dtAttP">
                                                                                       @foreach($Atts as $att)
                                                <tr>
                                                   <td>
                                                {{$att->From}}
                                                   </td>
                                                            <td>
                                                {{$att->To}}
                                                   </td>
                                                   <td>
                                                      {{$att->Discount}}
                                                         <input type="hidden" name="FromAttendence[]" value="{{$att->From}}">
                                                      <input type="hidden" name="ToAttendence[]" value="{{$att->To}}">
                                                      <input type="hidden" name="DiscountAttendence[]" value="{{$att->Discount}}">
                                                   </td>

                                                   <td>
                                                      <button id="DelAttP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                   </td>
                                                </tr>
                                                @endforeach
                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>


                                                    </div>

                               <div class="tab-pane fade" id="tab_borders_icons-10" role="tabpanel">
                                      <div class="panel-container show">
                                                            <div class="panel-content">
                                                                <div id="mobile-overflow">
                                                                <table
                                                                class="table table-bordered table-hover table-striped w-100 mobile-width th-width">
                                                                <thead>
                                                                    <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Discount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr>

                                                                                                                 <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSDepP()" onclick="PLUSDepP()" step="any" id="FromDepP" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                                                                 <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSDepP()" onclick="PLUSDepP()" step="any" id="ToDepP" class="form-control">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-group">

                   <input type="number" onkeyup="PLUSDepP()" onclick="PLUSDepP()" step="any" id="DiscountDepP" class="form-control">
                                                                            </div>
                                                                        </td>

                                                                        <td>
                            <button type="button" onclick="InsertDataDepP()" class="btn btn-default" id="add-dataDepP" style="display: none"><i class="fal fa-plus"></i></button>
                                                                        </td>

                                                                    </tr>
                                                                </tbody>
                                                                </table>
                                                                </div>
                                                                <!-- datatable start -->
                                                                <div id="mobile-overflow">
                                                                <table id=""
                                                                    class="table table-bordered table-hover table-striped w-100 mobile-width">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>{{trans('admin.From')}}</th>
                                                                        <th>{{trans('admin.To')}}</th>
                                                                        <th>{{trans('admin.Discount')}}</th>
                                                                        <th>{{trans('admin.Actions')}}</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="data-dtDepP">
                                                                            @foreach($Deps as $deb)
                                                <tr>
                                                   <td>
                                                {{$deb->From}}
                                                   </td>
                                                            <td>
                                                {{$deb->To}}
                                                   </td>
                                                   <td>
                                                      {{$deb->Discount}}
                                                         <input type="hidden" name="FromDeparture[]" value="{{$deb->From}}">
                                                      <input type="hidden" name="ToDeparture[]" value="{{$deb->To}}">
                                                      <input type="hidden" name="DiscountDeparture[]" value="{{$deb->Discount}}">
                                                   </td>

                                                   <td>
                                                      <button id="DelDepP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                                   </td>
                                                </tr>
                                                @endforeach
                                                                    </tbody>

                                                                </table>
                                                                </div>
                                                                <!-- datatable end -->

                                                            </div>
                                                        </div>


                                                    </div>



                              <input type="hidden" name="Account_Emp" value="{{$item->Account_Emp}}">
                           </div>
                           <div class="form-row">
                              <div class="buttons mt-3">
                                 <button type="submit" class="btn btn-primary"><i class="fal fa-save"></i>
                                 {{trans('admin.Save')}}
                                 </button>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </form>
</main>
@endsection
@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/dropzone/dropzone.css')}}">
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/dropzone/dropzone.js')}}"></script>
<script>
   /* demo scripts for change table color */
   /* change background */


   $(document).ready(function () {

       $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
       $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
           var title = $(this).text();
           $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

           $('input', this).on('keyup change', function () {
               if (table.column(i).search() !== this.value) {
                   table
                       .column(i)
                       .search(this.value)
                       .draw();
               }
           });
       });

       var table = $('#dt-basic-example').dataTable(
           {
               responsive: true,
               orderCellsTop: true,
               fixedHeader: true,
               lengthChange: false,

               dom: "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-center justify-content-end'B>>" +
                   "<'row'<'col-sm-12'tr>>" +
                   "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
               buttons: [
                   {
                       extend: 'colvis',
                       text: 'Column Visibility',
                       titleAttr: 'Col visibility',
                       className: 'btn-outline-default'
                   },
                   {
                       extend: 'pdfHtml5',
                       text: 'PDF',
                       titleAttr: 'Generate PDF',
                       className: 'btn-outline-danger btn-sm mr-1'
                   },
                   {
                       extend: 'excelHtml5',
                       text: 'Excel',
                       titleAttr: 'Generate Excel',
                       className: 'btn-outline-success btn-sm mr-1'
                   },
                   {
                       extend: 'csvHtml5',
                       text: 'CSV',
                       titleAttr: 'Generate CSV',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'copyHtml5',
                       text: 'Copy',
                       titleAttr: 'Copy to clipboard',
                       className: 'btn-outline-primary btn-sm mr-1'
                   },
                   {
                       extend: 'print',
                       text: 'Print',
                       titleAttr: 'Print Table',
                       className: 'btn-outline-primary btn-sm'
                   }
               ],
           });

       $('.js-thead-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
       });

       $('.js-tbody-colors a').on('click', function () {
           var theadColor = $(this).attr("data-bg");
           console.log(theadColor);
           $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
       });

   });

</script>
<script>
   $(document).ready(function()
   {
       $(function()
       {
           $('.select2').select2();

           $(".select2-placeholder-multiple").select2(
           {
               placeholder: "Select State"
           });
           $(".js-hide-search").select2(
           {
               minimumResultsForSearch: 1 / 0
           });
           $(".js-max-length").select2(
           {
               maximumSelectionLength: 2,
               placeholder: "Select maximum 2 items"
           });
           $(".select2-placeholder").select2(
           {
               placeholder: "Select a state",
               allowClear: true
           });

           $(".js-select2-icons").select2(
           {
               minimumResultsForSearch: 1 / 0,
               templateResult: icon,
               templateSelection: icon,
               escapeMarkup: function(elm)
               {
                   return elm
               }
           });

           function icon(elm)
           {
               elm.element;
               return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
           }

           $(".js-data-example-ajax").select2(
           {
               ajax:
               {
                   url: "https://api.github.com/search/repositories",
                   dataType: 'json',
                   delay: 250,
                   data: function(params)
                   {
                       return {
                           q: params.term, // search term
                           page: params.page
                       };
                   },
                   processResults: function(data, params)
                   {
                       // parse the results into the format expected by Select2
                       // since we are using custom formatting functions we do not need to
                       // alter the remote JSON data, except to indicate that infinite
                       // scrolling can be used
                       params.page = params.page || 1;

                       return {
                           results: data.items,
                           pagination:
                           {
                               more: (params.page * 30) < data.total_count
                           }
                       };
                   },
                   cache: true
               },
               placeholder: 'Search for a repository',
               escapeMarkup: function(markup)
               {
                   return markup;
               }, // let our custom formatter work
               minimumInputLength: 1,
               templateResult: formatRepo,
               templateSelection: formatRepoSelection
           });

           function formatRepo(repo)
           {
               if (repo.loading)
               {
                   return repo.text;
               }

               var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                   "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                   "<div class='select2-result-repository__meta'>" +
                   "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

               if (repo.description)
               {
                   markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
               }

               markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                   "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                   "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                   "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                   "</div>" +
                   "</div></div>";

               return markup;
           }

           function formatRepoSelection(repo)
           {
               return repo.full_name || repo.text;
           }
       });
   });

</script>
<!-- Insert Table Ratio -->
<script>
   function PLUS() {
       var from = $("#from").val();
       var to = $("#to").val();
       var salary = $("#salary").val();
       var rate = $("#rate").val();
       var type = $("#type").val();

       if (from != "" && to != "" && salary != "" && rate != "" && type != "") {
           document.getElementById("add-data").style.display = "block";
       }


        if (from == "" || to == "" || salary == "" || rate == "" || type == "") {
            document.getElementById("add-data").style.display = "none";
       }




   }
</script>
<script>
   function InsertData() {
       var from = document.getElementById("from").value;
       var to = document.getElementById("to").value;
       var salary = document.getElementById("salary").value;
       var rate = document.getElementById("rate").value;
          var type =  $("#type option:selected").text();
       var typee =  $("#type").val();

       var table = ` <tr>
                               <td>
                           ${from}
                               </td>
                           <td>
                           ${to}
                               </td>

                               <td>
                               ${salary}
                              </td>
                           <td>
                               ${rate}
                              </td>
                               <td>${type}
               <input type="hidden" name="from[]" value="${from}">
   <input type="hidden" name="to[]" value="${to}">
   <input type="hidden" name="salary[]" value="${salary}">
   <input type="hidden" name="rate[]" value="${rate}">
   <input type="hidden" name="type[]" value="${type}">
   <input type="hidden" name="typee[]" value="${typee}">
                                </td>
                               <td>
                   <button id="Del" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                               </td>

                            </tr>`;

       document.getElementById("data-dt").innerHTML += table;



       $("#data-dt").on("click", "#Del", function (e) {
           $(this).closest("tr").remove();

       });
   }
</script>
<script>
   $("#data-dt").on("click", "#Del", function (e) {
          $(this).closest("tr").remove();

      });

           $("#data-dtAllow").on("click", "#DelAllow", function (e) {
            $(this).closest("tr").remove();

        });
      $("#data-dtDiscount").on("click", "#DelDiscount", function (e) {
            $(this).closest("tr").remove();

        });
         $("#data-dtQ").on("click", "#DelQ", function (e) {
            $(this).closest("tr").remove();

        });


         $("#data-dtAttP").on("click", "#DelAttP", function (e) {
            $(this).closest("tr").remove();

        });

      $("#data-dtDepP").on("click", "#DelDepP", function (e) {
            $(this).closest("tr").remove();

        });

</script>
<script>
   function bill(){

       var Bill_Num=$('#Bill_Num').val();

       if(parseFloat(Bill_Num) == 1){

         document.getElementById('NUMOFBILLLL').style.display='block';
       }else{

             document.getElementById('NUMOFBILLLL').style.display='none';
       }


   }

     $(document).ready(function () {

           var Bill_Num=$('#Bill_Num').val();

       if(parseFloat(Bill_Num) == 1){

         document.getElementById('NUMOFBILLLL').style.display='block';
       }else{

             document.getElementById('NUMOFBILLLL').style.display='none';
       }

     });
</script>
<!-- Insert Table Allownces -->
<script>
    function PLUSAllow() {
        var Allow = $("#Allow").val();
        var AmountAllow = $("#AmountAllow").val();


        if (Allow != "" && AmountAllow != "") {
            document.getElementById("add-dataAlow").style.display = "block";
        }


         if (Allow == "" || AmountAllow == "") {
             document.getElementById("add-dataAlow").style.display = "none";
        }




    }

      function InsertDataAllow() {
        var Allow = document.getElementById("Allow").value;
        var AmountAllow = document.getElementById("AmountAllow").value;
        var AllowName =  $("#Allow option:selected").text();



        var table = ` <tr>
                                <td>
                            ${AllowName}
                                </td>
                            <td>
                            ${AmountAllow}
                <input type="hidden" name="Allow[]" value="${Allow}">
    <input type="hidden" name="AmountAllow[]" value="${AmountAllow}">
                                </td>

                                <td>
                    <button id="DelAllow" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dtAllow").innerHTML += table;



        $("#data-dtAllow").on("click", "#DelAllow", function (e) {
            $(this).closest("tr").remove();

        });
    }
</script>
<!-- Insert Table Discounts -->
<script>
    function PLUSDiscount() {
        var Discount = $("#Discount").val();
        var AmountDiscount = $("#AmountDiscount").val();


        if (Discount != "" && AmountDiscount != "") {
            document.getElementById("add-dataDiscount").style.display = "block";
        }


         if (Discount == "" || AmountDiscount == "") {
             document.getElementById("add-dataDiscount").style.display = "none";
        }




    }

      function InsertDataDiscount() {
        var Discount = document.getElementById("Discount").value;
        var AmountDiscount = document.getElementById("AmountDiscount").value;
        var DiscountName =  $("#Discount option:selected").text();



        var table = ` <tr>
                                <td>
                            ${DiscountName}
                                </td>
                            <td>
                            ${AmountDiscount}
                <input type="hidden" name="Discount[]" value="${Discount}">
    <input type="hidden" name="AmountDiscount[]" value="${AmountDiscount}">
                                </td>

                                <td>
                    <button id="DelDiscount" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dtDiscount").innerHTML += table;



        $("#data-dtDiscount").on("click", "#DelDiscount", function (e) {
            $(this).closest("tr").remove();

        });
    }
</script>
<!-- Insert Table Pro Quantity -->
<script>
    function PLUSQuantity() {
        var FromQ = $("#FromQ").val();
        var ToQ = $("#ToQ").val();
        var ValueQ = $("#ValueQ").val();


        if (FromQ != "" && ToQ != "" && ValueQ != "") {
            document.getElementById("add-dataQ").style.display = "block";
        }


         if (FromQ == "" || ToQ == "" || ValueQ == "") {
             document.getElementById("add-dataQ").style.display = "none";
        }




    }

      function InsertDataQuantity() {
           var FromQ = $("#FromQ").val();
        var ToQ = $("#ToQ").val();
        var ValueQ = $("#ValueQ").val();



        var table = ` <tr>
                                <td>
                            ${FromQ}
                                </td>
                                <td>
                            ${ToQ}
                                </td>
                            <td>
                            ${ValueQ}
                <input type="hidden" name="FromQ[]" value="${FromQ}">
    <input type="hidden" name="ToQ[]" value="${ToQ}">
    <input type="hidden" name="ValueQ[]" value="${ValueQ}">
                                </td>

                                <td>
                    <button id="DelQ" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dtQ").innerHTML += table;

       $("#FromQ").val('');
$("#ToQ").val('');
$("#ValueQ").val('');
    document.getElementById("add-dataQ").style.display = "none";

        $("#data-dtQ").on("click", "#DelQ", function (e) {
            $(this).closest("tr").remove();

        });
    }
</script>
<!-- Insert Table Attendence Policy -->
<script>

    function PLUSAttP() {
        var FromQ = $("#FromAttP").val();
        var ToQ = $("#ToAttP").val();
        var ValueQ = $("#DiscountAttP").val();


        if (FromQ != "" && ToQ != "" && ValueQ != "") {
            document.getElementById("add-dataAttP").style.display = "block";
        }


         if (FromQ == "" || ToQ == "" || ValueQ == "") {
             document.getElementById("add-dataAttP").style.display = "none";
        }




    }

      function InsertDataAttP() {
           var FromQ = $("#FromAttP").val();
        var ToQ = $("#ToAttP").val();
        var ValueQ = $("#DiscountAttP").val();



        var table = ` <tr>
                                <td>
                            ${FromQ}
                                </td>
                                <td>
                            ${ToQ}
                                </td>
                            <td>
                            ${ValueQ}
                <input type="hidden" name="FromAttendence[]" value="${FromQ}">
    <input type="hidden" name="ToAttendence[]" value="${ToQ}">
    <input type="hidden" name="DiscountAttendence[]" value="${ValueQ}">
                                </td>

                                <td>
                    <button id="DelAttP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dtAttP").innerHTML += table;

       $("#FromAttP").val('');
$("#ToAttP").val('');
$("#DiscountAttP").val('');
    document.getElementById("add-dataAttP").style.display = "none";

        $("#data-dtAttP").on("click", "#DelAttP", function (e) {
            $(this).closest("tr").remove();

        });
    }
</script>
<!-- Insert Table Departure Policy -->
<script>

    function PLUSDepP() {
        var FromQ = $("#FromDepP").val();
        var ToQ = $("#ToDepP").val();
        var ValueQ = $("#DiscountDepP").val();


        if (FromQ != "" && ToQ != "" && ValueQ != "") {
            document.getElementById("add-dataDepP").style.display = "block";
        }


         if (FromQ == "" || ToQ == "" || ValueQ == "") {
             document.getElementById("add-dataDepP").style.display = "none";
        }




    }

      function InsertDataDepP() {
           var FromQ = $("#FromDepP").val();
        var ToQ = $("#ToDepP").val();
        var ValueQ = $("#DiscountDepP").val();



        var table = ` <tr>
                                <td>
                            ${FromQ}
                                </td>
                                <td>
                            ${ToQ}
                                </td>
                            <td>
                            ${ValueQ}
                <input type="hidden" name="FromDeparture[]" value="${FromQ}">
    <input type="hidden" name="ToDeparture[]" value="${ToQ}">
    <input type="hidden" name="DiscountDeparture[]" value="${ValueQ}">
                                </td>

                                <td>
                    <button id="DelDepP" type="button" class="btn btn-default"><i class="fal fa-trash"></i></button>
                                </td>

                             </tr>`;

        document.getElementById("data-dtDepP").innerHTML += table;

       $("#FromDepP").val('');
$("#ToDepP").val('');
$("#DiscountDepP").val('');
    document.getElementById("add-dataDepP").style.display = "none";

        $("#data-dtDepP").on("click", "#DelDepP", function (e) {
            $(this).closest("tr").remove();

        });
    }
</script>
@endpush
