<!DOCTYPE>
<html>
<head>
    <meta charset="utf-8">

    <meta name="description" content="Basic">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no, minimal-ui">
    <!-- Call App Mode on ios devices -->
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <!-- Remove Tap Highlight on Windows Phone IE -->
    <meta name="msapplication-tap-highlight" content="no">
        <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests" />
    <!-- base css -->
    <link id="vendorsbundle" rel="stylesheet" media="screen, print" href="{{asset('Admin/css/vendors.bundle.css')}}">
    <link id="appbundle" rel="stylesheet" media="screen, print" href="{{asset('Admin/css/app.bundle.css')}}">
    <link id="mytheme" rel="stylesheet" media="screen, print" href="#">
    <link id="myskin" rel="stylesheet" media="screen, print" href="{{asset('Admin/css/skins/skin-master.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/style.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/style-ar.css')}}">
    <!-- Place favicon.ico in the root directory -->
    <link rel="apple-touch-icon" sizes="180x180" href="{{asset('Admin/img/favicon/apple-touch-icon.png')}}">
    <link rel="icon" type="image/png" sizes="32x32" href="i{{asset('Admin/mg/favicon/favicon-32x32.png')}}">
    <link rel="mask-icon" href="{{asset('Admin/img/favicon/safari-pinned-tab.svg')}}" color="#5bbad5">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <style>
        .carousel-item img{
            height: 100vh;
        }
        .menu{
            margin-top:50px;
        }
        .head-menu{
            text-align: center;
        }
        .head-menu img{
            height: 90px;
        }
        .head-menu h1{
            color: #886ab5;
            font-size: 30px;
            padding-bottom: 20px;
        }
        .product{
            margin-top: 10px;
            border: 1px solid #ccc;
             border-radius: 5px;
             padding: 5px;
             background: #efdef559;
        }
        
        .product img{
            height: 70px;
            max-width:100%;
        }
        .product p{
            color: #646464;
            margin-bottom: 0;
        }

        .product .padding-item{
            padding-right: 0;
        }
        .filter{
            background: #c17cd740;
            padding:10px 15px 0 15px;
            border: 1px solid #ccc;
             border-radius: 5px;
        }
       
    </style>
</head>
<body>
  <title>{{trans('admin.Price_List')}}</title>

    <!-- Start Menu -->
    <section class="menu">
        <div class=" head-menu">
         <img src="{{URL::to($company->Logo_Store)}}" alt="">
         <a class="btn btn-primary" href="{{url('Logout')}}"><i class="fal fa-sign-out"></i></a>
        </div>
        <!-- Start Filter -->
    
        <div class="container-fluid">
            <div class="filter">
        <div class="row">
            <div class="form-group col-md-3">
                <label class="form-label" for="">  {{trans('admin.Brands')}} </label>
                <select class="select2 form-control w-100" id="Brand">
                    <option value="">{{trans('admin.Brands')}}</option>
                    @foreach($Brands as $brand)
                    <option value="{{$brand->id}}"> {{app()->getLocale() == 'ar' ?$brand->Name :$brand->NameEn}}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-md-2">
                <label class="form-label" for="">  {{trans('admin.Groups')}} </label>
                <select class="select2 form-control w-100" id="Group">
                    <option value="">{{trans('admin.Groups')}}</option>
                               @foreach($Groups as $group)
                    <option value="{{$group->id}}">      {{app()->getLocale() == 'ar' ?$group->Name :$group->NameEn}}</option>
                    @endforeach
                </select>
            </div>
            
              <div class="form-group col-md-3">
                <label class="form-label" for="">  {{trans('admin.Search')}} </label>
      <input type="text" id="Search" class="form-control">
            </div>
            
 @if(auth()->guard('admin')->user()->email  != 'GuestH@test.com')  
            <div class="form-group col-md-2">
                <label class="form-label" for="">  {{trans('admin.Highest_Price')}}</label>
                <select class="select2 form-control w-100" id="HP">
                    <option value="">{{trans('admin.Highest_Price')}}</option>
                    <option value="100000">100000</option>
                    <option value="50000">50000</option>
                    <option value="25000">25000</option>
                    <option value="10000">10000</option>
                    <option value="5000">5000</option>
                    <option value="2500">2500</option>
                    <option value="1000">1000</option>
                    <option value="500">500</option>
                    <option value="250">250</option>
                    <option value="100">100</option>
                    <option value="50">50</option>
                    <option value="25">25</option>
                    <option value="10">10</option>
                    <option value="5">5</option>
                </select>
            </div>
            <div class="form-group col-md-2">
                <label class="form-label" for="">  {{trans('admin.Lowest_Price')}} </label>
                <select class="select2 form-control w-100" id="LP">
                      <option value="">{{trans('admin.Lowest_Price')}}</option>
                    <option value="5">5</option>
                       <option value="10">10</option>
                          <option value="25">25</option>
                       <option value="50">50</option>
                             <option value="100">100</option>
                            <option value="250">250</option>
                      <option value="500">500</option>
                            <option value="1000">1000</option>
                           <option value="2500">2500</option>
                            <option value="5000">5000</option>
                       <option value="10000">10000</option>    
                    <option value="25000">25000</option>
                            <option value="50000">50000</option>
                    <option value="100000">100000</option>
             
                </select>
            </div>
    @endif        
        </div>
    </div>
    </div>
    <!-- End Filter -->
        <div class="container-fluid">
            <div class="row Data">
                @foreach($Products as $pro)
            @if($pro->Product()->first()->Store_Show == 2 or $pro->Product()->first()->Store_Show == 3)
                <div class="col-md-2">
                    <div class="product">
                    <div class="row">
                        <div class="col-md-6 col-6">
                            @if(!empty($pro->Product()->first()->Image))
                              <img src="{{URL::to($pro->Product()->first()->Image)}}" alt=""> 
                            @else
                            <img src="{{asset('Admin/img/demo/gallery/5.jpg')}}" alt="">
                            @endif
                        </div>
                        <div class="col-md-6 col-6 padding-item">
                            <h5>      {{app()->getLocale() == 'ar' ?$pro->P_Ar_Name :$pro->P_En_Name}} </h5>
                            <h6>
                          {{app()->getLocale() == 'ar' ?$pro->Unit()->first()->Name :$pro->Unit()->first()->NameEn}        
                            
                            </h6>
                            
                        @if(auth()->guard('admin')->user()->email  != 'GuestH@test.com')    
                            @if(auth()->guard('admin')->user()->price_level == 1)
                            <p>{{trans('admin.Price')}}: <span>{{$pro->Price}}</span></p>
                            @elseif(auth()->guard('admin')->user()->price_level == 2)
                            <p>{{trans('admin.Price')}}: <span>{{$pro->Price_Two}}</span></p>
                                @elseif(auth()->guard('admin')->user()->price_level == 3)
                            <p>{{trans('admin.Price')}}: <span>{{$pro->Price_Three}}</span></p>
                            @endif
                        @endif    
                            
                            <p> <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#description{{$pro->id}}"> {{trans('admin.Desc')}}</button></p>
                        </div>
                    </div>
            </div>
                </div>
                
                
                    <!-- description modal  -->
    <div class="modal fade" id="description{{$pro->id}}" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {{trans('admin.Desc')}}
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    @if(!empty($pro->Product()->first()->Ar_Desc))

                    
           {{app()->getLocale() == 'ar' ?$pro->Product()->first()->Ar_Desc :$pro->StProductoProductre()->first()->En_Desc}             
                    @endif
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>
    <!-- End Menu -->

                
           @endif
                @endforeach
            </div>
        </div>
    </section>

    <script src="{{asset('Admin/js/vendors.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/app.bundle.js')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/holder/2.9.7/holder.min.js"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }

                $(".js-data-example-ajax").select2(
                {
                    ajax:
                    {
                        url: "https://api.github.com/search/repositories",
                        dataType: 'json',
                        delay: 250,
                        data: function(params)
                        {
                            return {
                                q: params.term, // search term
                                page: params.page
                            };
                        },
                        processResults: function(data, params)
                        {
                            // parse the results into the format expected by Select2
                            // since we are using custom formatting functions we do not need to
                            // alter the remote JSON data, except to indicate that infinite
                            // scrolling can be used
                            params.page = params.page || 1;

                            return {
                                results: data.items,
                                pagination:
                                {
                                    more: (params.page * 30) < data.total_count
                                }
                            };
                        },
                        cache: true
                    },
                    placeholder: 'Search for a repository',
                    escapeMarkup: function(markup)
                    {
                        return markup;
                    }, // let our custom formatter work
                    minimumInputLength: 1,
                    templateResult: formatRepo,
                    templateSelection: formatRepoSelection
                });

                function formatRepo(repo)
                {
                    if (repo.loading)
                    {
                        return repo.text;
                    }

                    var markup = "<div class='select2-result-repository clearfix d-flex'>" +
                        "<div class='select2-result-repository__avatar mr-2'><img src='" + repo.owner.avatar_url + "' class='width-2 height-2 mt-1 rounded' /></div>" +
                        "<div class='select2-result-repository__meta'>" +
                        "<div class='select2-result-repository__title fs-lg fw-500'>" + repo.full_name + "</div>";

                    if (repo.description)
                    {
                        markup += "<div class='select2-result-repository__description fs-xs opacity-80 mb-1'>" + repo.description + "</div>";
                    }

                    markup += "<div class='select2-result-repository__statistics d-flex fs-sm'>" +
                        "<div class='select2-result-repository__forks mr-2'><i class='fal fa-lightbulb'></i> " + repo.forks_count + " Forks</div>" +
                        "<div class='select2-result-repository__stargazers mr-2'><i class='fal fa-star'></i> " + repo.stargazers_count + " Stars</div>" +
                        "<div class='select2-result-repository__watchers mr-2'><i class='fal fa-eye'></i> " + repo.watchers_count + " Watchers</div>" +
                        "</div>" +
                        "</div></div>";

                    return markup;
                }

                function formatRepoSelection(repo)
                {
                    return repo.full_name || repo.text;
                }
            });
        });

    </script>
    
    
    
        <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    
     <script>
        var autoSave = $('#autoSave');
        var interval;
        var timer = function()
        {
            interval = setInterval(function()
            {
                //start slide...
                if (autoSave.prop('checked'))
                    saveToLocal();

                clearInterval(interval);
            }, 3000);
        };

        //save
        var saveToLocal = function()
        {
            localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
            console.log("saved");
        }

        //delete 
        var removeFromLocal = function()
        {
            localStorage.removeItem("summernoteData");
            $('#saveToLocal').summernote('reset');
        }

        $(document).ready(function()
        {
            //init default
            $('.js-summernote').summernote(
            {
                height: 200,
                tabsize: 2,
                placeholder: "Type here...",
                dialogsFade: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['fontname', ['fontname']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']]
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                callbacks:
                {
                    //restore from localStorage
                    onInit: function(e)
                    {
                        $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                    },
                    onChange: function(contents, $editable)
                    {
                        clearInterval(interval);
                        timer();
                    }
                }
            });

            //load emojis
            $.ajax(
            {
                url: 'https://api.github.com/emojis',
                async: false
            }).then(function(data)
            {
                window.emojis = Object.keys(data);
                window.emojiUrls = data;
            });

            //init emoji example
            $(".js-hint2emoji").summernote(
            {
                height: 100,
                toolbar: false,
                placeholder: 'type starting with : and any alphabet',
                hint:
                {
                    match: /:([\-+\w]+)$/,
                    search: function(keyword, callback)
                    {
                        callback($.grep(emojis, function(item)
                        {
                            return item.indexOf(keyword) === 0;
                        }));
                    },
                    template: function(item)
                    {
                        var content = emojiUrls[item];
                        return '<img src="' + content + '" width="20" /> :' + item + ':';
                    },
                    content: function(item)
                    {
                        var url = emojiUrls[item];
                        if (url)
                        {
                            return $('<img />').attr('src', url).css('width', 20)[0];
                        }
                        return '';
                    }
                }
            });

            //init mentions example
            $(".js-hint2mention").summernote(
            {
                height: 100,
                toolbar: false,
                placeholder: "type starting with @",
                hint:
                {
                    mentions: ['jayden', 'sam', 'alvin', 'david'],
                    match: /\B@(\w*)$/,
                    search: function(keyword, callback)
                    {
                        callback($.grep(this.mentions, function(item)
                        {
                            return item.indexOf(keyword) == 0;
                        }));
                    },
                    content: function(item)
                    {
                        return '@' + item;
                    }
                }
            });

        });

    </script>


<!--  Filter Products -->
<script>
   $(document).ready(function(){
   
    fetch_customer_data();
   
    function fetch_customer_data(Brand = '',Group='',HP='',LP='',Search='')
    {  
     $.ajax({
      url:'PriceListFilter',
      method:'GET',
      data:{Brand:Brand,Group:Group,HP:HP,LP:LP,Search:Search},
      dataType:'json',
      success:function(data)
      {
       $('.Data').html(data.table_data);
 
      }
     })
    }
    
        $(document).on('change', '#Brand', function(){
     var Brand = $(this).val();     
     var Group = $('#Group').val();     
     var HP = $('#HP').val();     
     var LP = $('#LP').val();     
     var Search = $('#Search').val();     
     fetch_customer_data(Brand,Group,HP,LP,Search);
    });
       
          $(document).on('change', '#Group', function(){
     var Group = $(this).val();     
     var Brand = $('#Brand').val();     
     var HP = $('#HP').val();     
     var LP = $('#LP').val();     
         var Search = $('#Search').val();     
     fetch_customer_data(Brand,Group,HP,LP,Search);
    });
       
          $(document).on('change', '#HP', function(){
     var HP = $(this).val();     
     var Group = $('#Group').val();     
     var Brand = $('#Brand').val();     
     var LP = $('#LP').val();     
         var Search = $('#Search').val();     
     fetch_customer_data(Brand,Group,HP,LP,Search);
    });
       
          $(document).on('change', '#LP', function(){
     var LP = $(this).val();     
     var Group = $('#Group').val();     
     var HP = $('#HP').val();     
     var Brand = $('#Brand').val();     
          var Search = $('#Search').val();     
     fetch_customer_data(Brand,Group,HP,LP,Search);
    });
       
       
                 $(document).on('keyup', '#Search', function(){
     var Search = $(this).val();     
     var Group = $('#Group').val();     
     var HP = $('#HP').val();     
     var Brand = $('#Brand').val();     
          var LP = $('#LP').val();     
     fetch_customer_data(Brand,Group,HP,LP,Search);
    });
 
        
   });
</script>


    
    
</body>

</html>