@extends('admin.index')
@section('content')

  <title>{{trans('admin.MyMissions')}}</title>

    <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);"> {{trans('admin.CRM')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.MyMissions')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                         <span class="fw-300"><i>{{trans('admin.MyMissions')}}</i></span>
                                    </h2>

                                    <div class="panel-toolbar">

                                        <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>

                                        @include('admin.layouts.toolbar')
                                    </div>

                                </div>
                                <div class="panel-container show">
                                   <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div style="overflow:auto;">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped " >
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Start_Date')}}</th>
                                                    <th>{{trans('admin.End_Date')}}</th>
                                                    <th>{{trans('admin.Duration')}}</th>
                                                    <th>{{trans('admin.Value')}}</th>
                                                    <th>{{trans('admin.File')}}</th>
                                                    <th>{{trans('admin.Task_Owner')}}</th>
                                                    <th>{{trans('admin.Observer')}}</th>
                                                    <th>{{trans('admin.Project')}}</th>
                                                    <th>{{trans('admin.Desc')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>

                                            @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Name}}</td>
                                                    <td>{{$item->NameEn}}</td>
                                                    <td>{{$item->Start_Date}}</td>
                                                    <td>{{$item->End_Date}}</td>
                                                    <td>{{$item->Duration}}</td>
                                                    <td>{{$item->Value}}</td>
                                                    <td>
                                                    @if(!empty($item->File))
                 <a class="btn btn-primary" href="{{URL::to($item->File)}}" download><i class="fal fa-download"></i></a>
                                                    @else
                                                        {{trans('admin.Not_Found')}}
                                                    @endif
                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Task_Owner()->first()->Name))
                                                        {{app()->getLocale() == 'ar' ?$item->Task_Owner()->first()->Name :$item->Task_Owner()->first()->NameEn}}
                                                        @endif

                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Observer()->first()->Name))
                                                        {{app()->getLocale() == 'ar' ?$item->Observer()->first()->Name :$item->Observer()->first()->NameEn}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if(!empty($item->Project()->first()->Name))
                                                        {{app()->getLocale() == 'ar' ?$item->Project()->first()->Name :$item->Project()->first()->NameEn}}
                                                        @endif
                                                    </td>

                                                    <td>

                                       <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Desc{{$item->id}}">{{trans('admin.Desc')}}</button>
                                                    </td>
                                 <td>{{$item->User()->first()->name}}</td>
                                                    <td class="text-center">


                <a class="btn btn-primary" href="{{url('SureMissionByEmp/'.$item->id)}}"><i class="fal fa-check"></i></a>





                                                    </td>
                                                </tr>
                                             @endforeach


                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Start_Date')}}</th>
                                                    <th>{{trans('admin.End_Date')}}</th>
                                                    <th>{{trans('admin.Duration')}}</th>
                                                    <th>{{trans('admin.Value')}}</th>
                                                    <th>{{trans('admin.File')}}</th>
                                                    <th>{{trans('admin.Task_Owner')}}</th>
                                                    <th>{{trans('admin.Observer')}}</th>
                                                    <th>{{trans('admin.Project')}}</th>
                                                    <th>{{trans('admin.Desc')}}</th>
                                                    <th>{{trans('admin.User')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        {{$items->Links()}}
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

      @foreach($items as $item)
      <!-- Modal Desc -->
                      <div class="modal fade" id="Desc{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                      {{$item->Desc}}
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>

                                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>


     @endforeach


                </main>

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
  <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>

    <!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


  $('.Client').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllCli',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
       data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllCliJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Client').empty();
                                  $.each(data, function(key, value){

                         $('.Client').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('.Client').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



          $('#Client').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllCli',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
       data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllCliJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('#Client').empty();
                                  $.each(data, function(key, value){

                         $('#Client').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
    }
  });


$('#Client').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});



            });
        });



    </script>

    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>


@endpush

