@extends('admin.index')
@section('content')
@php
use App\Models\Admin;
use Spatie\Permission\Models\Role;
@endphp
  <title>{{trans('admin.Admins')}}</title>

 <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Settings')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Admins')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>
                    <div class="subheader">

                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i> {{trans('admin.Admins')}}</i></span>

                                                                                 @if(auth()->guard('admin')->user()->email == 'Klar@test.com')
<button class="btn btn-danger" type="button"><i class="fal fa-times">Hide</i></button>
<button class="btn btn-success" type="button"><i class="fal fa-check">Not Hide</i></button>
    @endif


                                    </h2>

                                    <div class="panel-toolbar">
                              @can('اضافه المستخدمين')
                     <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                                @endcan




                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
             @include('admin.layouts.toolbar')
                                    </div>
                                </div>
                                <div class="panel-container show">
                                      <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Arabic_Name')}}</th>
                                                    <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Email')}}</th>
                                                    <th>{{trans('admin.Image')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>
                                                    <th>{{trans('admin.Type')}}</th>
                                                    <th>{{trans('admin.Premations')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->name}}</td>
                                                    <td>{{$item->nameEn}}</td>
                                                    <td>{{$item->email}}</td>
                                                    <td>
                                        @if(!empty($item->image))
                                             <img style="width:60px ;height:60px;" src="{{URL::to($item->image)}}">
                                        @else
                                    <img style="width:60px ;height:60px;" src="{{asset('Admin/img/default.jpeg')}}">
                                        @endif
                                                    </td>
                                                      <td>{{$item->phone}}</td>

                                                      <td>
                                                    @if($item->type == 'Admin')
                                                          {{trans('admin.Admin')}}
                                                    @elseif($item->type == 'Emp')
                                                          {{trans('admin.Employee')}}
                                                    @elseif($item->type == 'Vend')
                                                          {{trans('admin.Vendor')}}
                                                    @elseif($item->type == 'Client')
                                                          {{trans('admin.Client')}}
                                                    @elseif($item->type == 'Ship')
                                                          {{trans('admin.Shipping_Company')}}
                                                    @endif

                                                    </td>

                                                       <td>{{$item->roles_name}}</td>

                                                    <td class="text-center">

                                                        @can('حذف المستخدمين')
             <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}"><i class="fal fa-trash-alt"></i></button>
                                        @endcan


                                             @can('تعديل المستخدمين')
            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Edit{{$item->id}}"><i class="fal fa-edit"></i></button>
                                    @endcan

                                                @if(auth()->guard('admin')->user()->email == 'Klar@test.com')

                                                    @if($item->hidden != 0)
                                    <a class="btn btn-danger" href="{{url('Hide/'.$item->id)}}"><i class="fal fa-times"></i></a>
                                                    @else
                                    <a class="btn btn-success" href="{{url('UnHide/'.$item->id)}}"><i class="fal fa-check"></i></a>
                                                        @endif

                                                @endif

                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                     <th>{{trans('admin.Arabic_Name')}}</th>
                                                     <th>{{trans('admin.English_Name')}}</th>
                                                    <th>{{trans('admin.Email')}}</th>
                                                    <th>{{trans('admin.Image')}}</th>
                                                    <th>{{trans('admin.Phone')}}</th>
                                                    <th>{{trans('admin.Type')}}</th>
                                                    <th>{{trans('admin.Premations')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Modal Add-->
             <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{url('AddAdmin')}}" method="post" enctype="multipart/form-data" id="formid">
                                        {!! csrf_field() !!}
                                        <div class="form-row">
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}}</label>
                        <input type="text" name="name" value="{{old('name')}}"  class="form-control" required>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                        <input type="text" name="nameEn" value="{{old('nameEn')}}"  class="form-control" >
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Email')}}</label>
                     <input type="email" name="email" value="{{old('email')}}"  class="form-control" required>
                                            </div>
                                         <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Password')}}</label>
                     <input type="password" name="password" value="{{old('password')}}"  class="form-control" required>
                                            </div>
                                              <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}</label>
                     <input type="number" name="phone" value="{{old('phone')}}"  class="form-control">
                                            </div>

                                            @if(auth()->guard('admin')->user()->email == 'Klar@test.com')
                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Expire_Type')}}</label>
                                                <select class="select2" name="expire_type" required >

                                                    <option value="0" @if(old('expire_type') == 0)selected  @endif >{{trans('admin.Not_Use')}}</option>
                                                    <option value="1" @if(old("expire_type") == 1) selected @endif>{{trans('admin.Use')}}</option>

                                                </select>
                                            </div>

                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Expire_Date')}}</label>
                                                <input type="date" name="expire" value="{{old('expire')}}"  class="form-control">
                                            </div>

                                            @endif


                                  <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Type')}}</label>
               <select class="select2" id="Type" onchange="TYPEE()" name="Type" >
                      <option value="Admin" @if(old('Type') == "Admin")selected  @endif >{{trans('admin.Admin')}}</option>
                      <option value="Emp" @if(old("Type") == "Emp") selected @endif>{{trans('admin.Employee')}}</option>
                      <option value="Vend" @if(old("Type") == "Vend") selected @endif>{{trans('admin.Vendor')}}</option>
                      <option value="Client" @if(old("Type") == "Client") selected @endif>{{trans('admin.Client')}}</option>
                      <option value="Ship" @if(old("Type") == "Ship") selected @endif>{{trans('admin.Shipping_Company')}}</option>
                                      </select>
                                            </div>

                                        @if(auth()->guard('admin')->user()->email ==  'Klar@test.com')

                                                  <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Packages')}}</label>
               <select class="select2 form-control"  name="package">
                   @foreach($Packages as $pack)
                      <option value="{{$pack->id}}">{{app()->getLocale() == 'ar' ?$pack->Arabic_Name :$pack->English_Name}}</option>
                       @endforeach
                                      </select>
                                            </div>


                                        @else
                                      <input type="hidden" name="package" value="{{auth()->guard('admin')->user()->package}}">
                                        @endif

                                             <div class="form-group col-lg-6">
       <label class="form-label" for="">{{trans('admin.Premations')}}</label>


                {!! Form::select('roles_name', $roles,[], array('class' => 'select2 form-control')) !!}

                                            </div>

                                            <div class="form-group col-lg-6">
                                                <label class="form-label">{{trans('admin.Image')}}</label>
                                                <div class="custom-file">
                                      <input type="file" class="custom-file-input" id="customControlValidation7" name="image">
                                  <label class="custom-file-label" for="customControlValidation7">Choose file...</label>

                                                </div>
                                            </div>
                                    <div class="col-lg-12" style="display: none" id="EMP">

                                    <div class="row">
                                <div class=" col-lg-3 mt-2" >
                                            <label class="form-label" for="">{{trans('admin.Employee')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Emp" name="emp" id="Empo">

                                            </select>
                                            </div>

                                                   <div class=" col-lg-3 mt-2">
                                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                                            <select class="select2 form-control w-100"  name="store" id="Storo">
                                                <option value=""> {{trans('admin.Store')}}</option>
                                            @foreach($Stores as $stor)
                                                <option value="{{$stor->id}}"  >

                                         {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>

                                        <div class=" col-lg-3 mt-2">
                                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                            <select class="select2 form-control w-100" name="safe" id="Safeo" >
                                                 <option value=""> {{trans('admin.Safe')}}</option>
                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}">


                                        {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>
                                        <div class=" col-lg-3 mt-2" >
                                            <label class="form-label" for="">{{trans('admin.Executor_Sales')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Exe" name="executor" id="Exeo">

                                            </select>
                                            </div>
                                             <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Price_Sale')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="price_sale" id="X">
                                         <label class="custom-control-label" for="X">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="price_sale" id="Y">
                              <label class="custom-control-label" for="Y">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Discount')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="discount" id="XX">
                                         <label class="custom-control-label" for="XX">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="discount" id="YY">
                              <label class="custom-control-label" for="YY">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                      <div class=" col-lg-4 mt-2">
                                           <div >{{trans('admin.Sale_Prices')}}</div>
                                      <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="price_1" value="1" id="defaultUnchecked">
                                                        <label class="custom-control-label" for="defaultUnchecked">{{trans('admin.Price_One')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="price_2" value="1" id="defaultUncheckedd">
                                                        <label class="custom-control-label" for="defaultUncheckedd">{{trans('admin.Price_Two')}}</label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="price_3" value="1" id="defaultUncheckeddd">
                                                        <label class="custom-control-label" for="defaultUncheckeddd">{{trans('admin.Price_Three')}}  </label>
                                                    </div>
                                                    </div>


                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.cost_price')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="cost_price" id="z">
                                         <label class="custom-control-label" for="z">{{trans('admin.Appear')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="cost_price" id="zz">
                              <label class="custom-control-label" for="zz">{{trans('admin.Hidden')}}</label>
                                                    </div>
                                                     </div>


                                 <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.pos_pay')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_pay" id="f">
                                         <label class="custom-control-label" for="f">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_pay" id="ff">
                              <label class="custom-control-label" for="ff">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>



                                           <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Stores')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_stores" id="fp">
                                         <label class="custom-control-label" for="fp">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_stores" id="ffp">
                              <label class="custom-control-label" for="ffp">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>


                                           <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Safes')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_safes" id="fpsafe">
                                         <label class="custom-control-label" for="fpsafe">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_safes" id="ffpsafe">
                              <label class="custom-control-label" for="ffpsafe">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>




                                                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.pos_hold')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="pos_hold" id="fph">
                                         <label class="custom-control-label" for="fph">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_hold" id="ffph">
                              <label class="custom-control-label" for="ffph">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>


                                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.pos_product')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="pos_product" id="posPro">
                                         <label class="custom-control-label" for="posPro">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_product" id="posPros">
                              <label class="custom-control-label" for="posPros">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                                        <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.ticket_price')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_price" id="ticket_price">
                                         <label class="custom-control-label" for="ticket_price">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_price" id="ticket_prices">
                              <label class="custom-control-label" for="ticket_prices">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                                        <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.ticket_discount')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_discount" id="ticket_discount">
                                         <label class="custom-control-label" for="ticket_discount">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_discount" id="ticket_discounts">
                              <label class="custom-control-label" for="ticket_discounts">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                                        <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.bill_discount')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="bill_discount" id="bill_discount">
                                         <label class="custom-control-label" for="bill_discount">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="bill_discount" id="bill_discounts">
                              <label class="custom-control-label" for="bill_discounts">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>





                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Date')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="Date" id="date">
                                         <label class="custom-control-label" for="date">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="Date" id="dateC">
                              <label class="custom-control-label" for="dateC">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>


                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.cost_price_purch')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="cost_price_purch" id="cpp">
                                         <label class="custom-control-label" for="cpp">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="cost_price_purch" id="cp">
                              <label class="custom-control-label" for="cp">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>

                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.cost_price_sales')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="cost_price_sales" id="css">
                                         <label class="custom-control-label" for="css">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="cost_price_sales" id="cs">
                              <label class="custom-control-label" for="cs">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>

                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.manu_order_precent')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="manu_order_precent" id="mop">
                                         <label class="custom-control-label" for="mop">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="manu_order_precent" id="mopp">
                              <label class="custom-control-label" for="mopp">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>



                                             <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.job_order_price')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="job_order_price" id="jop">
                                         <label class="custom-control-label" for="jop">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="job_order_price" id="jopp">
                              <label class="custom-control-label" for="jopp">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>



                                      <div class=" col-lg-4 mt-2">
                                           <div >{{trans('admin.Payment_Method')}}</div>
                                      <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash" value="1" id="defaultUncheckedCash">
                                                        <label class="custom-control-label" for="defaultUncheckedCash">{{trans('admin.Cash')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Later" value="1" id="defaultUncheckeddLater">
                                                        <label class="custom-control-label" for="defaultUncheckeddLater">{{trans('admin.Later')}}</label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Check" value="1" id="defaultUncheckedddCheck">
                                                        <label class="custom-control-label" for="defaultUncheckedddCheck">{{trans('admin.Check')}}  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Installment" value="1" id="defaultUncheckedInstallment">
                                                        <label class="custom-control-label" for="defaultUncheckedInstallment">{{trans('admin.Installment')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Visa" value="1" id="defaultUncheckeddCash_Visa">
                                                        <label class="custom-control-label" for="defaultUncheckeddCash_Visa">{{trans('admin.Cash_Visa')}}</label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Visa_Network" value="1" id="defaultUncheckeddVisa_Network">
                                                        <label class="custom-control-label" for="defaultUncheckeddVisa_Network">{{trans('admin.Visa_Network')}}</label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Collection" value="1" id="defaultUncheckedddCash_Collection">
                                                        <label class="custom-control-label" for="defaultUncheckedddCash_Collection">{{trans('admin.Cash_Collection')}}  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Delivery" value="1" id="defaultUncheckedDelivery">
                                                        <label class="custom-control-label" for="defaultUncheckedDelivery">{{trans('admin.Delivery')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="InstallmentCompanies" value="1" id="defaultUncheckeddInstallmentCompanies">
                                                        <label class="custom-control-label" for="defaultUncheckeddInstallmentCompanies">{{trans('admin.InstallmentCompanies')}}</label>
                                                    </div>

                                                    </div>







                                           </div>
                                        </div>

                              <div class="form-group col-lg-12" style="display: none" id="SHIP">
                                            <label class="form-label" for="">{{trans('admin.Shipping_Company')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Ship" name="ship">

                                            </select>
                                            </div>

                                  <div class="form-group col-lg-12" style="display: none" id="VEND">
                                            <label class="form-label" for="">{{trans('admin.Vendor')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Vend" name="vend">

                                            </select>
                                            </div>


             <div class="form-group col-lg-12" style="display: none" id="CLIENT">
                                            <label class="form-label" for="">{{trans('admin.Client')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Cli" name="cli">

                                            </select>
                                            </div>

                                        </div>
                                         <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        <button type="submit" class="btn btn-primary"> {{trans('admin.Add')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

      @foreach($items as $item)
                    <!-- Modal Edit-->
                    <div class="modal fade" id="Edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.Edit')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                   <div class="modal-body">
                               <form action="{{url('EditAdmin/'.$item->id)}}" method="post" enctype="multipart/form-data">
                                        {!! csrf_field() !!}

                            <input type="hidden" name="passwords" value="{{$item->password}}">
                            <input type="hidden" name="hidden" value="{{$item->hidden}}">
                            <input type="hidden" name="status" value="{{$item->status}}">
                            <input type="hidden" name="images" value="{{$item->image}}">
                            <input type="hidden" name="roles" value="{{$item->roles_name}}">

                                        <div class="form-row">
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Arabic_Name')}}</label>
                        <input type="text" name="name" value="{{$item->name}}"  class="form-control" required>
                                            </div>

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.English_Name')}}</label>
                        <input type="text" name="nameEn" value="{{$item->nameEn}}"  class="form-control" required>
                                            </div>
                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Email')}}</label>
                     <input type="email" name="email" value="{{$item->email}}"  class="form-control" required>
                                            </div>
                                         <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Password')}}</label>
                     <input type="password" name="password" value="{{old('password')}}"  class="form-control" >
                                            </div>
                                              <div class="form-group col-lg-4">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Phone')}}</label>
                     <input type="number" name="phone" value="{{$item->phone}}"  class="form-control">
                                            </div>

@if(auth()->guard('admin')->user()->email == 'Klar@test.com')
                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Expire_Type')}}</label>
                                                <select class="select2" name="expire_type" required >

                                                    <option value="0" @if($item->expire_type == 0)selected  @endif >{{trans('admin.Not_Use')}}</option>
                                                    <option value="1" @if($item->expire_type == 1) selected @endif>{{trans('admin.Use')}}</option>

                                                </select>
                                            </div>

                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Expire_Date')}}</label>
                                                <input type="date" name="expire" value="{{$item->expire}}"  class="form-control">
                                            </div>
                                            @endif

                                            <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Type')}}</label>
               <select class="select2" id="Type{{$item->id}}" onchange="TYPEEE({{$item->id}})" name="Type">
              <option value="Admin" @if($item->type == 'Admin') selected @endif>{{trans('admin.Admin')}}</option>
                      <option value="Emp" @if($item->type == 'Emp') selected @endif>{{trans('admin.Employee')}}</option>
                      <option value="Vend" @if($item->type == 'Vend') selected @endif>{{trans('admin.Vendor')}}</option>
                      <option value="Client" @if($item->type == 'Client') selected @endif>{{trans('admin.Client')}}</option>
                      <option value="Ship" @if($item->type == 'Ship') selected @endif>{{trans('admin.Shipping_Company')}}</option>
                                      </select>
                                            </div>

                                                                 @if(auth()->guard('admin')->user()->email ==  'Klar@test.com')

                                                  <div class="form-group col-lg-4">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Packages')}}</label>
               <select class="select2 form-control"  name="package">
                   @foreach($Packages as $pack)
                      <option value="{{$pack->id}}" @if($pack->id == $item->package) selected @endif>{{app()->getLocale() == 'ar' ?$pack->Arabic_Name :$pack->English_Name}}</option>
                       @endforeach
                                      </select>
                                            </div>


                                        @else
                                      <input type="hidden" name="package" value="{{$item->package}}">
                                        @endif


<div class="row"  @if($item->type == 'Emp') style="display: block" @else style="display: none" @endif id="EMP{{$item->id}}" >

              <div class="row">

                                    <div class="form-group col-lg-4"  >
                                            <label class="form-label" for="">{{trans('admin.Employee')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Emp" name="emp">
                                @if($item->emp != 0)
                                   @if(!empty($item->emp()->first()->Name))
                              <option value="{{$item->emp}}">

                                     {{app()->getLocale() == 'ar' ?$item->emp()->first()->Name :$item->emp()->first()->NameEn}}
                                   </option>
                                   @endif
                                @endif
                                            </select>
                                            </div>

                        <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Safe')}}</label>
                                            <select class="select2 form-control w-100" name="safe" >
                                                 <option value=""> {{trans('admin.Safe')}}</option>
                                            @foreach($Safes as $safe)
                                                <option value="{{$safe->id}}" @if($safe->id == $item->safe) selected @endif>

                                                       {{app()->getLocale() == 'ar' ?$safe->Name :$safe->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>


                               <div class="form-group col-lg-4">
                                            <label class="form-label" for="">{{trans('admin.Store')}}</label>
                                            <select class="select2 form-control w-100"  name="store" >
                                                <option value=""> {{trans('admin.Store')}}</option>
                                            @foreach($Stores as $stor)
                                                <option value="{{$stor->id}}" @if($stor->id == $item->store) selected @endif>
                                                 {{app()->getLocale() == 'ar' ?$stor->Name :$stor->NameEn}}
                                                </option>
                                            @endforeach
                                            </select>
                                        </div>

                                           <div class=" col-lg-4 mt-2" >
                                            <label class="form-label" for="">{{trans('admin.Executor_Sales')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Exe" name="executor">

                                   @if(!empty($item->executor()->first()->Name))
                              <option value="{{$item->executor}}">

                                   {{app()->getLocale() == 'ar' ?$item->executor()->first()->Name :$item->executor()->first()->NameEn}}
                                   </option>
                                   @endif

                                            </select>
                                            </div>


                   <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Price_Sale')}}</div>
                                        <div class=" custom-control custom-radio">

                <input type="radio" class="custom-control-input"  value="1"  name="price_sale" id="X{{$item->id}}" @if($item->price_sale == 1) checked @endif >
                                         <label class="custom-control-label" for="X{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="price_sale" id="Y{{$item->id}}" @if($item->price_sale == 0) checked @endif>
                              <label class="custom-control-label" for="Y{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Discount')}}</div>
                                        <div class=" custom-control custom-radio">

           <input type="radio" class="custom-control-input"  value="1"  name="discount" id="XX{{$item->id}}" @if($item->discount == 1) checked @endif>
                                         <label class="custom-control-label" for="XX{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
      <input type="radio" class="custom-control-input" value="0"  name="discount" id="YY{{$item->id}}" @if($item->discount == 0) checked @endif>
                              <label class="custom-control-label" for="YY{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                      <div class=" col-lg-4 mt-2">
                                           <div >{{trans('admin.Sale_Prices')}}</div>
                                      <div class="custom-control custom-checkbox">
         <input type="checkbox" class="custom-control-input" name="price_1" value="1" id="defaultUnchecked{{$item->id}}" @if($item->price_1 == 1) checked @endif>
           <label class="custom-control-label" for="defaultUnchecked{{$item->id}}">{{trans('admin.Price_One')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
         <input type="checkbox" class="custom-control-input" name="price_2" value="1" id="defaultUncheckedd{{$item->id}}" @if($item->price_2 == 1) checked @endif>
           <label class="custom-control-label" for="defaultUncheckedd{{$item->id}}">{{trans('admin.Price_Two')}}</label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
         <input type="checkbox" class="custom-control-input" name="price_3" value="1" id="defaultUncheckeddd{{$item->id}}" @if($item->price_3 == 1) checked @endif>
           <label class="custom-control-label" for="defaultUncheckeddd{{$item->id}}">{{trans('admin.Price_Three')}}  </label>
                                                    </div>
                                                    </div>


                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.cost_price')}}</div>
                                        <div class=" custom-control custom-radio">

                   <input type="radio" class="custom-control-input"  value="1"  name="cost_price" id="z{{$item->id}}" @if($item->cost_price == 1) checked @endif>
                                         <label class="custom-control-label" for="z{{$item->id}}">{{trans('admin.Appear')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
          <input type="radio" class="custom-control-input" value="0"  name="cost_price" id="zz{{$item->id}}" @if($item->cost_price == 0) checked @endif>
                              <label class="custom-control-label" for="zz{{$item->id}}">{{trans('admin.Hidden')}}</label>
                                                    </div>
                                                     </div>


                                 <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.pos_pay')}}</div>
                                        <div class=" custom-control custom-radio">

        <input type="radio" class="custom-control-input"  value="1"  name="pos_pay" id="f{{$item->id}}" @if($item->pos_pay == 1) checked @endif>
                                         <label class="custom-control-label" for="f{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
   <input type="radio" class="custom-control-input" value="0"  name="pos_pay" id="ff{{$item->id}}" @if($item->pos_pay == 0) checked @endif>
                              <label class="custom-control-label" for="ff{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>


         <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.ticket_price')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_price" id="ticket_price{{$item->id}}" @if($item->ticket_price == 1) checked @endif>
                                         <label class="custom-control-label" for="ticket_price{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_price" id="ticket_prices{{$item->id}}" @if($item->ticket_price == 0) checked @endif>
                              <label class="custom-control-label" for="ticket_prices{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                  <div class=" col-lg-4 mt-2">
                      <div class="" for="">{{trans('admin.bill_discount')}}</div>
                      <div class=" custom-control custom-radio">

                          <input type="radio" class="custom-control-input"  value="1"  name="bill_discount" id="bill_discount{{$item->id}}" @if($item->bill_discount == 1) checked @endif>
                          <label class="custom-control-label" for="bill_discount{{$item->id}}">{{trans('admin.Open')}}  </label>
                      </div>
                      <div class="custom-control custom-radio">
                          <input type="radio" class="custom-control-input" value="0"  name="bill_discount" id="bill_discounts{{$item->id}}" @if($item->bill_discount == 0) checked @endif>
                          <label class="custom-control-label" for="bill_discounts{{$item->id}}">{{trans('admin.Closed')}}</label>
                      </div>
                  </div>


                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.ticket_discount')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="ticket_discount" id="ticket_discount{{$item->id}}"  @if($item->ticket_discount == 1) checked @endif>
                                         <label class="custom-control-label" for="ticket_discount{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="ticket_discount" id="ticket_discounts{{$item->id}}"  @if($item->ticket_discount == 0) checked @endif>
                              <label class="custom-control-label" for="ticket_discounts{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>



                         <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Date')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="Date" id="date{{$item->id}}" @if($item->Date == 1) checked @endif>
                                         <label class="custom-control-label" for="date{{$item->id}}" >{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="Date" id="dateC{{$item->id}}" @if($item->Date == 0) checked @endif>
                              <label class="custom-control-label" for="dateC{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.Stores')}}</div>
                                        <div class=" custom-control custom-radio">

          <input type="radio" class="custom-control-input"  value="1"  name="pos_stores" id="fp{{$item->id}}" @if($item->pos_stores == 1) checked @endif>
                                         <label class="custom-control-label" for="fp{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
            <input type="radio" class="custom-control-input" value="0"  name="pos_stores" id="ffp{{$item->id}}" @if($item->pos_stores == 0) checked @endif>
                              <label class="custom-control-label" for="ffp{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>

                  <div class=" col-lg-4 mt-2">
                      <div class="" for="">{{trans('admin.Safes')}}</div>
                      <div class=" custom-control custom-radio">

                          <input type="radio" class="custom-control-input"  value="1"  name="pos_safes" id="fpsafe{{$item->id}}" @if($item->pos_safes == 1) checked @endif>
                          <label class="custom-control-label" for="fpsafe{{$item->id}}">{{trans('admin.Open')}}  </label>
                      </div>
                      <div class="custom-control custom-radio">
                          <input type="radio" class="custom-control-input" value="0"  name="pos_safes" id="ffpsafe{{$item->id}}" @if($item->pos_safes == 0) checked @endif>
                          <label class="custom-control-label" for="ffpsafe{{$item->id}}">{{trans('admin.Closed')}}</label>
                      </div>
                  </div>


                  <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.pos_hold')}}</div>
                                        <div class=" custom-control custom-radio">

         <input type="radio" class="custom-control-input"  value="1"  name="pos_hold" id="fph{{$item->id}}" @if($item->pos_hold == 1) checked @endif>
                                         <label class="custom-control-label" for="fph{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
     <input type="radio" class="custom-control-input" value="0"  name="pos_hold" id="ffph{{$item->id}}" @if($item->pos_hold == 0) checked @endif>
                              <label class="custom-control-label" for="ffph{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>


           <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.pos_product')}}</div>
                                        <div class=" custom-control custom-radio">

                     <input type="radio" class="custom-control-input"  value="1"  name="pos_product" id="posPro{{$item->id}}"  @if($item->pos_product == 1) checked @endif>
                                         <label class="custom-control-label" for="posPro{{$item->id}}">{{trans('admin.Open')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="pos_product" id="posPros{{$item->id}}"  @if($item->pos_product == 0) checked @endif>
                              <label class="custom-control-label" for="posPros{{$item->id}}">{{trans('admin.Closed')}}</label>
                                                    </div>
                                                     </div>


                          <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.cost_price_purch')}}</div>
                                        <div class=" custom-control custom-radio">

           <input type="radio" class="custom-control-input"  value="1"  name="cost_price_purch" id="cpp{{$item->id}}" @if($item->cost_price_purch == 1) checked @endif>
                                         <label class="custom-control-label" for="cpp{{$item->id}}">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
     <input type="radio" class="custom-control-input" value="0"  name="cost_price_purch" id="cp{{$item->id}}" @if($item->cost_price_purch == 0) checked @endif>
                              <label class="custom-control-label" for="cp{{$item->id}}">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>

                                              <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.cost_price_sales')}}</div>
                                        <div class=" custom-control custom-radio">

     <input type="radio" class="custom-control-input"  value="1"  name="cost_price_sales" id="css{{$item->id}}" @if($item->cost_price_sales == 1) checked @endif>
                                         <label class="custom-control-label" for="css{{$item->id}}">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
<input type="radio" class="custom-control-input" value="0"  name="cost_price_sales" id="cs{{$item->id}}" @if($item->cost_price_sales == 0) checked @endif>
                              <label class="custom-control-label" for="cs{{$item->id}}">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>


                                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.manu_order_precent')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="manu_order_precent" id="mop{{$item->id}}" @if($item->manu_order_precent == 1) checked @endif>
                                         <label class="custom-control-label" for="mop{{$item->id}}">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="manu_order_precent" id="mopp{{$item->id}}" @if($item->manu_order_precent == 0) checked @endif>
                              <label class="custom-control-label" for="mopp{{$item->id}}">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>


                    <div class=" col-lg-4 mt-2">
                                                  <div class="" for="">{{trans('admin.job_order_price')}}</div>
                                        <div class=" custom-control custom-radio">

                                       <input type="radio" class="custom-control-input"  value="1"  name="job_order_price" id="jop{{$item->id}}"  @if($item->job_order_price == 1) checked @endif>
                                         <label class="custom-control-label" for="jop{{$item->id}}">{{trans('admin.Show')}}  </label>
                                                        </div>
                                            <div class="custom-control custom-radio">
                                  <input type="radio" class="custom-control-input" value="0"  name="job_order_price" id="jopp{{$item->id}}" @if($item->job_order_price == 0) checked @endif>
                              <label class="custom-control-label" for="jopp{{$item->id}}">{{trans('admin.Hide')}}</label>
                                                    </div>
                                                     </div>



     <div class=" col-lg-4 mt-2">
                                           <div >{{trans('admin.Payment_Method')}}</div>
                                      <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" name="Cash" value="1" id="defaultUncheckedCash{{$item->id}}" @if($item->Cash == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckedCash{{$item->id}}">{{trans('admin.Cash')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                             <input type="checkbox" class="custom-control-input" name="Later" value="1" id="defaultUncheckeddLater{{$item->id}}" @if($item->Later == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckeddLater{{$item->id}}">{{trans('admin.Later')}}</label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Check" value="1" id="defaultUncheckedddCheck{{$item->id}}" @if($item->Check == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckedddCheck{{$item->id}}">{{trans('admin.Check')}}  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Installment" value="1" id="defaultUncheckedInstallment{{$item->id}}" @if($item->Installment == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckedInstallment{{$item->id}}">{{trans('admin.Installment')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Visa" value="1" id="defaultUncheckeddCash_Visa{{$item->id}}" @if($item->Cash_Visa == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckeddCash_Visa{{$item->id}}">{{trans('admin.Cash_Visa')}}</label>
                                                    </div>
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Visa_Network" value="1" id="defaultUncheckeddVisa_Network{{$item->id}}" @if($item->Visa_Network == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckeddVisa_Network{{$item->id}}">{{trans('admin.Visa_Network')}}</label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Cash_Collection" value="1" id="defaultUncheckedddCash_Collection{{$item->id}}" @if($item->Cash_Collection == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckedddCash_Collection{{$item->id}}">{{trans('admin.Cash_Collection')}}  </label>
                                                    </div>
                                          <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="Delivery" value="1" id="defaultUncheckedDelivery{{$item->id}}" @if($item->Delivery == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckedDelivery{{$item->id}}">{{trans('admin.Delivery')}} </label>
                                                    </div>
                                                     <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" name="InstallmentCompanies" value="1" id="defaultUncheckeddInstallmentCompanies{{$item->id}}" @if($item->InstallmentCompanies == 1) checked @endif>
                                                        <label class="custom-control-label" for="defaultUncheckeddInstallmentCompanies{{$item->id}}">{{trans('admin.InstallmentCompanies')}}</label>
                                                    </div>

                                                    </div>

                  </div>

                                            </div>





             <div class="form-group col-lg-12" @if($item->type == 'Ship') style="display: block" @else style="display: none" @endif  id="SHIP{{$item->id}}">
                                            <label class="form-label" for="">{{trans('admin.Shipping_Company')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Ship" name="ship">
                            @if($item->ship != 0)
                                   @if(!empty($item->ship))
                              <option value="{{$item->ship}}">

                                          {{app()->getLocale() == 'ar' ?$item->ship()->first()->Name :$item->ship()->first()->NameEn}}
                                   </option>
                                   @endif
                                @endif
                                            </select>
                                            </div>

          <div class="form-group col-lg-12" @if($item->type == 'Vend') style="display: block" @else style="display: none" @endif id="VEND{{$item->id}}">
                                            <label class="form-label" for="">{{trans('admin.Vendor')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Vend" name="vend">
                                @if($item->vend != 0)
                                   @if(!empty($item->vend))
                              <option value="{{$item->vend}}">

                                 {{app()->getLocale() == 'ar' ?$item->vend()->first()->Name :$item->vend()->first()->NameEn}}
                                   </option>
                                   @endif
                                @endif
                                            </select>
                                            </div>


             <div class="form-group col-lg-12" @if($item->type == 'Client') style="display: block" @else style="display: none" @endif id="CLIENT{{$item->id}}">
                                            <label class="form-label" for="">{{trans('admin.Client')}}</label>
                               <select  class="js-data-example-ajax form-control w-100 Cli" name="cli">
                                   @if($item->cli != 0)
                                   @if(!empty($item->cli))
                              <option value="{{$item->cli}}">
                                        {{app()->getLocale() == 'ar' ?$item->cli()->first()->Name :$item->cli()->first()->NameEn}}
                                   </option>
                                   @endif
                                @endif
                                            </select>
                                            </div>




                                             <div class="form-group col-lg-12">
                                        @php
                            $user = Admin::find($item->id);

                            if(app()->getLocale() == 'ar' ){
                            $roles = Role::pluck('name','name')->all();
                            $userRole = $user->roles->pluck('name','name')->all();
                                }else{
                               $roles = Role::pluck('nameEn','name')->all();
                            $userRole = $user->roles->pluck('name','name')->all();

                                                 }
                                        @endphp
       <label class="form-label" for="">{{trans('admin.Premations')}}</label>

            {!! Form::select('roles_name', $roles,$userRole, array('class' => 'select2 form-control'))!!}

                                            </div>

                                            <div class="form-group col-lg-12">
                                                <label class="form-label">{{trans('admin.Image')}}</label>
                                                <div class="custom-file">
                                      <input type="file" class="custom-file-input" id="customControlValidation7" name="image">
                                  <label class="custom-file-label" for="customControlValidation7">Choose file...</label>

                                                </div>
                                            </div>
                                            <div class="form-group col-lg-12">
                                        <img src="{{URL::to($item->image)}}" style="height: 20%; width: 20%">
                                            </div>


                                        </div>
                                         <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        <button type="submit" class="btn btn-primary"> {{trans('admin.Add')}}</button>
                                </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Delete -->
                    <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">

                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    {{trans('admin.RUSWDT')}} <strong>{{app()->getLocale() == 'ar' ?$item->name :$item->nameEn}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeleteAdmin/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>

     @endforeach

                </main>
@endsection

@push('js')
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>

<!-- Search Selecet -->
<script>

    $(document).ready(function () {
        $(function () {
            $(".select2").select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State",
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0,
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items",
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true,
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function (elm) {
                    return elm;
                },
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
            }

            $(".Emp").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
  data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllEmpsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Emp').empty();
                                  $.each(data, function(key, value){

                         $('.Emp').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Emp").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });

                    $(".Ship").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllShips",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                    data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllShipsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Ship').empty();
                                  $.each(data, function(key, value){

                         $('.Ship').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Ship").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });

                    $(".Vend").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllVend",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
         data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllVendJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Vend').empty();
                                  $.each(data, function(key, value){

                         $('.Vend').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Vend").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });


                    $(".Cli").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllCli",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
                   data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllCliJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Cli').empty();
                                  $.each(data, function(key, value){

                         $('.Cli').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Cli").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });

                       $(".Exe").select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: "json",
                    url: "AllEmps",
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (obj, index) {
                                return { id: index, text: obj };
                            }),
                        };

                        console.log(data);
                    },
  data: function (params) {


                   var query = {
                            search: params.term,
                        };


              $.ajax({
                              url: 'AllEmpsJ/'+params.term,
                              type:"GET",
                              dataType:"json",
                              beforeSend: function(){
                                  $('#loader').css("visibility", "visible");
                              },

                              success:function(data) {
                                          $('.Exe').empty();
                                  $.each(data, function(key, value){

                         $('.Exe').append('<option value="'+ key +'">' + value + '</option>');

                                  });
                              },
                              complete: function(){
                                  $('#loader').css("visibility", "hidden");
                              }
                          });



        }
                },
            });

            $(".Exe").on("select2:select", function (e) {
                console.log("select done", e.params.data);
            });





        });
    });
</script>

<!-- Check Type -->
<script>


   function  TYPEE(){

   var Type = $('#Type').val();

       if(Type == 'Admin'){

           document.getElementById("EMP").style.display = "none";
           document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "none";

             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;

       }else if(Type == 'Emp'){
            document.getElementById("EMP").style.display = "block";
              document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "none";

             document.getElementById('Empo').required = true;
        document.getElementById('Storo').required = true;
        document.getElementById('Safeo').required = true;
        document.getElementById('Exeo').required = true;
        document.getElementById('X').required = true;
        document.getElementById('Y').required = true;
        document.getElementById('XX').required = true;
        document.getElementById('YY').required = true;
        document.getElementById('z').required = true;
        document.getElementById('zz').required = true;
        document.getElementById('f').required = true;
        document.getElementById('ff').required = true;
        document.getElementById('fp').required = true;
        document.getElementById('ffp').required = true;
        document.getElementById('fph').required = true;
        document.getElementById('ffph').required = true;
        document.getElementById('posPro').required = true;
        document.getElementById('posPros').required = true;
        document.getElementById('date').required = true;
        document.getElementById('dateC').required = true;
        document.getElementById('cpp').required = true;
        document.getElementById('cp').required = true;
        document.getElementById('css').required = true;
        document.getElementById('cs').required = true;
        document.getElementById('mop').required = true;
        document.getElementById('mopp').required = true;

       }else if(Type == 'Ship'){
            document.getElementById("EMP").style.display = "none";
          document.getElementById("SHIP").style.display = "block";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "none";


             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;

       }else if(Type == 'Vend'){
            document.getElementById("EMP").style.display = "none";
             document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "block";
           document.getElementById("CLIENT").style.display = "none";

             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;


       }else if(Type == 'Client'){
         document.getElementById("EMP").style.display = "none";
              document.getElementById("SHIP").style.display = "none";
           document.getElementById("VEND").style.display = "none";
           document.getElementById("CLIENT").style.display = "block";

             document.getElementById('Empo').required = false;
        document.getElementById('Storo').required = false;
        document.getElementById('Safeo').required = false;
        document.getElementById('Exeo').required = false;
        document.getElementById('X').required = false;
        document.getElementById('Y').required = false;
        document.getElementById('XX').required = false;
        document.getElementById('YY').required = false;
        document.getElementById('z').required = false;
        document.getElementById('zz').required = false;
        document.getElementById('f').required = false;
        document.getElementById('ff').required = false;
        document.getElementById('fp').required = false;
        document.getElementById('ffp').required = false;
        document.getElementById('fph').required = false;
        document.getElementById('ffph').required = false;
        document.getElementById('posPro').required = false;
        document.getElementById('posPros').required = false;
        document.getElementById('date').required = false;
        document.getElementById('dateC').required = false;
        document.getElementById('cpp').required = false;
        document.getElementById('cp').required = false;
        document.getElementById('css').required = false;
        document.getElementById('cs').required = false;
        document.getElementById('mop').required = false;
        document.getElementById('mopp').required = false;


       }

   }

      function  TYPEEE(r){

   var Type = $('#Type'+r).val();

   if(Type == 'Admin'){

           document.getElementById("EMP"+r).style.display = "none";
           document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Emp'){
            document.getElementById("EMP"+r).style.display = "block";
              document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Ship'){
            document.getElementById("EMP"+r).style.display = "none";
          document.getElementById("SHIP"+r).style.display = "block";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Vend'){
            document.getElementById("EMP"+r).style.display = "none";
             document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "block";
           document.getElementById("CLIENT"+r).style.display = "none";


       }else if(Type == 'Client'){
         document.getElementById("EMP"+r).style.display = "none";
              document.getElementById("SHIP"+r).style.display = "none";
           document.getElementById("VEND"+r).style.display = "none";
           document.getElementById("CLIENT"+r).style.display = "block";


       }
   }

</script>


<script>

        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + title + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>

@endpush

