@extends('admin.index')
@section('content')


  <title>{{trans('admin.Partners')}}</title>

 <main id="js-page-content" role="main" class="page-content">
                    <ol class="breadcrumb page-breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Capital')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('admin.Partners')}}</li>
                        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span
                                class="js-get-date"></span></li>
                    </ol>

                    <div class="row">
                        <div class="col-xl-12">
                            <div id="panel-1" class="panel">
                                <div class="panel-hdr">
                                    <h2>
                                        <span class="fw-300"><i> {{trans('admin.Partners')}}  </i></span>
                                    </h2>

                                    <div class="panel-toolbar">

                       @can('اضافه شركاء')
                     <button type="button" class="btn btn-default" data-toggle="modal" data-target="#default-example-modal-lg">{{trans('admin.AddNew')}}</button>
                        @endcan


                            <button class="btn btn-primary btn-sm mx-3" data-toggle="dropdown">Table Style</button>
                           @include('admin.layouts.toolbar')
                                    </div>
                                </div>
                                <div class="panel-container show">
                                      <span id="ex"> @include('admin.layouts.messages')</span>
                                    <div class="panel-content">
                                        <!-- datatable start -->
                                        <div id="mobile-overflow">
                                        <table id="dt-basic-example"
                                            class="table table-bordered table-hover table-striped w-100 mobile-width">
                                            <thead class="bg-highlight">
                                                <tr>
                                                    <th>{{trans('admin.Name')}}</th>
                                                    <th>{{trans('admin.Capital_Account')}}</th>
                                                    <th>{{trans('admin.Gary_Account')}}</th>
                                                    <th>{{trans('admin.Recent_Profit_Account')}}</th>
                                                    <th>{{trans('admin.Stage_Profit_Account')}}</th>
                                                    <th>{{trans('admin.Shares_Number')}}</th>
                                                    <th>{{trans('admin.Nominal_Value_of_Shares')}}</th>
                                                    <th>{{trans('admin.Actual_Share_Value')}}</th>
                                                    <th>{{trans('admin.First_Partner_Share')}}</th>
                                                    <th>{{trans('admin.Now_Partner_Share')}}</th>
                                                    <th>{{trans('admin.Capital_Increase_Rate')}}</th>
                                                    <th>{{trans('admin.Capital_Increase_Value')}}</th>
                                                    <th>{{trans('admin.Partnership_Ratio')}}</th>
                                                    <th>{{trans('admin.Profitss')}}</th>
                                                    <th>{{trans('admin.Withdraw_Profits')}}</th>
                                                    <th>{{trans('admin.Remaining_Profits')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($items as $item)
                                                <tr>
                                                    <td>{{$item->Name}}</td>
                                                    <td>{{$item->Account()->first()->Code}}</td>
                                                    <td>{{$item->Gary_Account()->first()->Code}}</td>
                                                    <td>{{$item->Recent_Profit_Account()->first()->Code}}</td>
                                                    <td>{{$item->Stage_Profit_Account()->first()->Code}}</td>
                                                    <td>{{$item->Shares_Number}}</td>
                                                    <td>{{$item->Nominal_Value_of_Shares}}</td>
                                                    <td>{{$item->Actual_Share_Value}}</td>
                                                    <td>{{$item->First_Partner_Share}}</td>
                                                    <td>{{$item->Now_Partner_Share}}</td>
                                                    <td>{{$item->Capital_Increase_Rate}}</td>
                                                    <td>{{$item->Capital_Increase_Value}}</td>
                                                    <td>{{$item->Partnership_Ratio}} %</td>
                                                    <td>{{$item->Profits}}</td>
                                                    <td>{{$item->Withdraw_Profits}}</td>
                                                    <td>{{$item->Remaining_Profits}}</td>

                                                    <td class="text-center">
{{--                       @can('حذف شركاء')--}}
{{--             <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}"><i class="fal fa-trash-alt"></i></button>--}}
{{--@endcan--}}

                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>{{trans('admin.Name')}}</th>
                                                    <th>{{trans('admin.Capital_Account')}}</th>
                                                    <th>{{trans('admin.Gary_Account')}}</th>
                                                    <th>{{trans('admin.Recent_Profit_Account')}}</th>
                                                    <th>{{trans('admin.Stage_Profit_Account')}}</th>
                                                    <th>{{trans('admin.Shares_Number')}}</th>
                                                    <th>{{trans('admin.Nominal_Value_of_Shares')}}</th>
                                                    <th>{{trans('admin.Actual_Share_Value')}}</th>
                                                    <th>{{trans('admin.First_Partner_Share')}}</th>
                                                    <th>{{trans('admin.Now_Partner_Share')}}</th>
                                                    <th>{{trans('admin.Capital_Increase_Rate')}}</th>
                                                    <th>{{trans('admin.Capital_Increase_Value')}}</th>
                                                    <th>{{trans('admin.Partnership_Ratio')}}</th>
                                                    <th>{{trans('admin.Profitss')}}</th>
                                                    <th>{{trans('admin.Withdraw_Profits')}}</th>
                                                    <th>{{trans('admin.Remaining_Profits')}}</th>
                                                    <th>{{trans('admin.Actions')}}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        </div>
                                        <!-- datatable end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Modal Add-->
             <div class="modal fade" id="default-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{trans('admin.AddNew')}}  </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-body">
                          <form action="{{url('AddPartner')}}" method="post" enctype="multipart/form-data">
                                        {!! csrf_field() !!}
                                        <div class="form-row">

                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Name')}}</label>
                        <input type="text" name="Name" value="{{old('Name')}}"  class="form-control" required>
                        <input type="hidden" id="NowProfit" value="{{$profit}}" >
                        <input type="hidden" id="AllShares" value="{{$capital->Shares_Number}}" >
                        <input type="hidden" id="SumShares" value="{{$SumShares}}">
                                            </div>



                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Residual_Shares')}}</label>
                                                <input type="number"  id="Residual_Shares"  value="{{$capital->Shares_Number - $SumShares}}"  class="form-control" readonly>
                                            </div>

                                              <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Shares_Number')}}</label>
             <input type="number" name="Shares_Number" id="Shares_Number" onkeyup="Result()" onclick="Result()" value="{{old('Shares_Number')}}"  class="form-control" required>
                                            </div>



                                                                      <div class="form-group col-lg-3">
                  <label class="form-label" for="simpleinput"> {{trans('admin.Nominal_Value_of_Shares')}}</label>
             <input type="number" id="Nominal_Value_of_Shares" name="Nominal_Value_of_Shares"  value="{{$capital->Nominal_Value_of_Shares}}"  class="form-control" readonly>

                                            </div>

                                          <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Actual_Share_Value')}}</label>
             <input type="number"  id="Actual_Share_Value" name="Actual_Share_Value" value="{{$capital->Actual_Share_Value}}"  class="form-control" readonly>

                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.First_Partner_Share')}}</label>
                                                <input type="number"  id="First_Partner_Share"  name="First_Partner_Share" value="{{old('First_Partner_Share')}}"  class="form-control" readonly>

                                            </div>


                                            <div class="form-group col-lg-3">
                                                <label class="form-label" for="simpleinput"> {{trans('admin.Now_Partner_Share')}}</label>
                                                <input type="number"  id="Now_Partner_Share"  name="Now_Partner_Share" value="{{old('Now_Partner_Share')}}"  class="form-control" readonly>

                                            </div>




                                  <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Capital_Increase_Rate')}}</label>
             <input type="number"  id="Capital_Increase_Rate"  name="Capital_Increase_Rate" value="{{old('Capital_Increase_Rate')}}"  class="form-control" readonly>
                                            </div>



                                  <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Capital_Increase_Value')}}</label>
             <input type="number"  id="Capital_Increase_Value"  name="Capital_Increase_Value" value="{{old('Capital_Increase_Value')}}"  class="form-control" readonly>
                                            </div>


                                  <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Partnership_Ratio')}} %</label>
             <input type="number"  id="Partnership_Ratio"  name="Partnership_Ratio" value="{{old('Partnership_Ratio')}}"  class="form-control" readonly>
                                            </div>


                                        <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Profitss')}}</label>
             <input type="number"  id="Profits" name="Profits"  class="form-control" readonly>

                                            </div>

                                     <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Withdraw_Profits')}}</label>
             <input type="number"  id="Withdraw_Profits"  name="Withdraw_Profits" value="0"  class="form-control" readonly>

                                            </div>

                                     <div class="form-group col-lg-3">
                                <label class="form-label" for="simpleinput"> {{trans('admin.Remaining_Profits')}}</label>
             <input type="number"  id="Remaining_Profits" name="Remaining_Profits"    class="form-control" readonly>
                                            </div>



                                        </div>
                                         <div class="modal-footer" id="Submit" style="display: none">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                        <button type="submit" class="btn btn-primary"> {{trans('admin.Add')}}</button>
                                </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>


           @foreach($items as $item)

                    <!-- Modal Delete -->
                    <div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                    {{trans('admin.RUSWDT')}} <strong>{{$item->Name}}</strong>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                                    </button>
                                </div>
                                <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                   <a href="{{url('DeletePartner/'.$item->id)}}"  class="btn btn-primary"> {{trans('admin.Yes')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>

     @endforeach

                </main>
@endsection

@push('js')
  <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
    <script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
    <link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">
    <script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
    <script>
        //_fnFeatureHtmlLength();
        $(document).ready(function () {
            // Setup - add a text input to each footer cell
            $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
            $('#dt-basic-example thead tr:eq(1) th').each(function (i) {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

                $('input', this).on('keyup change', function () {
                    if (table.column(i).search() !== this.value) {
                        table
                            .column(i)
                            .search(this.value)
                            .draw();
                    }
                });
            });
            var table = $('#dt-basic-example').DataTable(
                {
                    // responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    lengthChange: true,

                    dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        {
                            extend: 'pageLength',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-outline-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-outline-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-primary btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-primary btn-sm'
                        }
                    ],
                });
            $('.js-thead-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
            });

            $('.js-tbody-colors a').on('click', function () {
                var theadColor = $(this).attr("data-bg");
                console.log(theadColor);
                $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
            });

        });

    </script>
<!-- Search Selecet -->
 <script>
        $(document).ready(function()
        {
            $(function()
            {
                $('.select2').select2();

                $(".select2-placeholder-multiple").select2(
                {
                    placeholder: "Select State"
                });
                $(".js-hide-search").select2(
                {
                    minimumResultsForSearch: 1 / 0
                });
                $(".js-max-length").select2(
                {
                    maximumSelectionLength: 2,
                    placeholder: "Select maximum 2 items"
                });
                $(".select2-placeholder").select2(
                {
                    placeholder: "Select a state",
                    allowClear: true
                });

                $(".js-select2-icons").select2(
                {
                    minimumResultsForSearch: 1 / 0,
                    templateResult: icon,
                    templateSelection: icon,
                    escapeMarkup: function(elm)
                    {
                        return elm
                    }
                });

                function icon(elm)
                {
                    elm.element;
                    return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
                }


  $('#AccountCode').select2({
    placeholder: "select...",
    ajax: {
        type: "GET",
        dataType: 'json',
        url: 'AllSubAccounts',
        processResults: function (data) {
          return {
            results: $.map(data, function(obj, index) {
              return { id: index, text: obj };
            })
          };

            	console.log(data);

        },
        data: function (params) {
          var query = {
            search: params.term
          };
          if (params.term == "*") query.items = [];
          return { json: JSON.stringify( query ) }
        }
    }
  });


$('#AccountCode').on('select2:select', function (e) {
	console.log("select done", e.params.data);
});


            });
        });



    </script>

  <!-- Result -->
<script>
function Result(){

   var  Shares_Number = $('#Shares_Number').val();
   var  Nominal_Value_of_Shares = $('#Nominal_Value_of_Shares').val();
   var  Actual_Share_Value = $('#Actual_Share_Value').val();
   var  NowProfit = $('#NowProfit').val();
   var  AllShares = $('#AllShares').val();


    var FirstPartnerShare= parseFloat(Shares_Number) * parseFloat(Nominal_Value_of_Shares);
    var NowPartnerShare= parseFloat(Shares_Number) * parseFloat(Actual_Share_Value);

    $('#First_Partner_Share').val(parseFloat(FirstPartnerShare).toFixed(2));
    $('#Now_Partner_Share').val(parseFloat(NowPartnerShare).toFixed(2));


    var  First_Partner_Share = $('#First_Partner_Share').val();
    var  Now_Partner_Share = $('#Now_Partner_Share').val();

    var CapitalIncreaseValue= parseFloat(Now_Partner_Share) - parseFloat(First_Partner_Share);

    var CapitalIncreaseRate= (parseFloat(CapitalIncreaseValue) / parseFloat(First_Partner_Share) ) * 100;

    $('#Capital_Increase_Value').val(parseFloat(CapitalIncreaseValue).toFixed(2));

    $('#Capital_Increase_Rate').val(parseFloat(CapitalIncreaseRate).toFixed(2));

    var PartnershipRatio= (parseFloat(Shares_Number) / parseFloat(AllShares) ) * 100;

    $('#Partnership_Ratio').val(parseFloat(PartnershipRatio).toFixed(2));

    var profits= (parseFloat(PartnershipRatio) / parseFloat(100) ) * parseFloat(NowProfit);
    $('#Profits').val(parseFloat(profits).toFixed(2));
    $('#Withdraw_Profits').val(0);
    $('#Remaining_Profits').val(parseFloat(profits).toFixed(2));



    var Residual_Shares = $('#Residual_Shares').val();


if(parseFloat(Shares_Number) <=   parseFloat(Residual_Shares)){

    if(parseFloat(Shares_Number) !=  0) {
        document.getElementById('Submit').style.display = 'block';
    }else{
        document.getElementById('Submit').style.display='none';
    }

}else{

    document.getElementById('Submit').style.display='none';
}


}

</script>

@endpush

