@extends('admin.index')
@section('content')
@php
use App\Models\AccountsDefaultData;
use App\Models\DefaultDataShowHide;
$Def=AccountsDefaultData::orderBy('id','desc')->first();
$show=DefaultDataShowHide::orderBy('id','desc')->first();
@endphp
<title>{{trans('admin.Incoming_checks')}}</title>

<!-- the #js-page-content id is needed for some plugins to initialize -->
<main id="js-page-content" role="main" class="page-content">
    <ol class="breadcrumb page-breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);">{{trans('admin.Accounts')}}</a></li>
        <li class="breadcrumb-item active"> {{trans('admin.Incoming_checks')}}</li>
        <li class="position-absolute pos-top pos-right d-none d-sm-block"><span class="js-get-date"></span></li>
    </ol>

    <!-- Filter -->
    <div class="panel-container show">
        <div class="panel-content">


            <form action="{{url('IncomingchecksSechduleFilter')}}" method="get">

                <div class="form-row">
                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.From')}}</label>
                        <input type="date" id="from" value="{{date('Y-m-d')}}" name="From" class="form-control">
                    </div>
                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.To')}}</label>
                        <input type="date" id="to" value="{{date('Y-m-d')}}" name="To" class="form-control">
                    </div>

                    <div class="form-group col-lg-3">
                        <label class="form-label" for=""> {{trans('admin.Account_Name')}} </label>
                        <select class="js-data-example-ajax form-control w-100 Acc" name="Account">
                        </select>
                    </div>


                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.Due_Date')}}</label>
                        <input type="date" id="Due_Date" name="Due_Date" class="form-control">
                    </div>


                    <div class="form-group col-md-3 col-4-print">
                        <label class="form-label" for="simpleinput">{{trans('admin.Code')}}</label>
                        <input type="text" id="Code" name="Code" class="form-control">
                    </div>
                    <div class="buttons m-2">
                        <button type="submit" class="btn btn-primary"><i class="fal fa-search"></i></button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">

                <div class="panel-hdr">
                    <h2>
                        {{trans('admin.Incoming_checks')}}
                    </h2>

                    <div class="panel-toolbar">
                        @can('اضافه شيك وارد')
                        <button type="button" class="btn btn-default btn-sm margin-btn" data-toggle="modal" data-target="#default-example-modal-center-add">
                            {{trans('admin.AddNew')}}</button>
                        @endcan

                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table
                            Style</button>

                        @include('admin.layouts.toolbar')
                    </div>


                </div>
                <div class="panel-container show">
                    <span id="ex"> @include('admin.layouts.messages')</span>
                    <div class="panel-content">

                        <!-- datatable start -->
                        <div style="overflow:auto;">
                            <table id="dt-basic-example" class="table table-bordered table-hover table-striped">
                                <thead class="bg-highlight">
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th> {{trans('admin.Account_Name')}}</th>
                                        <th> {{trans('admin.Bank')}}</th>
                                        <th> {{trans('admin.Check_Num')}}</th>
                                        <th> {{trans('admin.Due_Date')}}</th>
                                        <th> {{trans('admin.Amount')}}</th>
                                        <th> {{trans('admin.Data')}}</th>
                                        <th> {{trans('admin.File')}}</th>
                                        <th style="padding: 13px 75px;"> {{trans('admin.Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($items as $item)
                                    <tr @if($item->Edit == 1) class="edited" @elseif($item->Delete == 1) class="deleted" @elseif($item->Transfer == 1) class="transfered" @endif>
                                        <td>{{$item->Code}}</td>
                                        <td>{{$item->Date}}</td>
                                        <td>

                                            @if(!empty($item->Account()->first()->Name))
                                            {{app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn}}
                                            @endif
                                        </td>

                                        <td>
                                            @if(!empty($item->Bank()->first()->Name))
                                            {{app()->getLocale() == 'ar' ?$item->Bank()->first()->Name :$item->Bank()->first()->NameEn}}
                                            @endif
                                        </td>
                                        <td>{{$item->Check_Num}}</td>
                                        <td>{{$item->Due_Date}}</td>

                                        <td>{{$item->Amount}}</td>
                                        <td>
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#show-data{{$item->id}}">
                                                {{trans('admin.Data')}}
                                            </button>
                                        </td>

                                        <td>
                                            @if(!empty($item->File))
                                            <a href="{{URL::to($item->File)}}" class="btn btn-primary" dowmload><i class="fal fa-download"></i></a>
                                            @endif
                                        </td>
                                        <td>

                                            @if($item->Edit == 0 and $item->Delete == 0 and $item->Transfer == 0)

                                            @if($item->Status == 0)

                                            @can('تعديل شيك صادر')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Edit{{$item->id}}">
                                                <i class="fal fa-edit"></i>
                                            </button>
                                            @endcan
                                            @can('تحويل الي شيك وارد')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Trans{{$item->id}}">
                                                <i class="fal fa-money-check-alt"></i>
                                            </button>
                                            @endcan
                                            @can('رفض شيك صادر')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Ref{{$item->id}}">
                                                <i class="fal fa-ban"></i>
                                            </button>
                                            @endcan

                                            @can('صرف شيك صادر')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Pay{{$item->id}}">
                                                <i class="fal fa-money-check"></i>
                                            </button>
                                            @endcan

                                            <a type="button" class="btn btn-default" href="{{url('PrintIncomChecks/'.$item->id)}}">
                                                <i class="fal fa-print"></i>
                                            </a>


                                            @can('حذف شيك صادر')
                                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#Delete{{$item->id}}">
                                                <i class="fal fa-trash"></i>
                                            </button>
                                            @endcan
                                            @endif

                                            @endif


                                            @if($item->Edit == 1)
                                            <span class="btn btn-warning">{{trans('admin.Edited_to_New_One')}} ({{$item->Edit_New_Code}})</span>
                                            @elseif($item->Delete == 1)

                                            <span class="btn btn-danger">{{trans('admin.Deleted')}}</span>

                                            @elseif($item->Transfer == 1)

                                            <span class="btn btn-primary">{{trans('admin.Transfer_to')}} ({{$item->Edit_New_Code}})</span>
                                            @endif



                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>{{trans('admin.Code')}}</th>
                                        <th>{{trans('admin.Date')}}</th>
                                        <th> {{trans('admin.Account_Name')}}</th>
                                        <th> {{trans('admin.Bank')}}</th>
                                        <th> {{trans('admin.Check_Num')}}</th>
                                        <th> {{trans('admin.Due_Date')}}</th>
                                        <th> {{trans('admin.Amount')}}</th>
                                        <th> {{trans('admin.Data')}}</th>
                                        <th> {{trans('admin.File')}}</th>
                                        <th> {{trans('admin.Actions')}}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        {{$items->Links()}}
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<!-- Modal Add -->
<div class="modal fade" id="default-example-modal-center-add" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.AddNew')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="{{url('AddIncoming_checks')}}" method="post" enctype="multipart/form-data">
                {!! csrf_field() !!}
                @honeypot
                <div class="modal-body">

                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                            <input type="text" value="{{$Code}}" disabled class="form-control">
                            <input type="hidden" name="Code" value="{{$Code}}">
                        </div>
                        @if(auth()->guard('admin')->user()->emp == 0)
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                            <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                        </div>
                        @else

                        @if(auth()->guard('admin')->user()->Date == 1)
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                            <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required>
                        </div>
                        @else
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                            <input type="date" name="Date" value="{{date('Y-m-d')}}" class="form-control" required readonly>
                        </div>
                        @endif

                        @endif

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Account_Name')}} </label>
                            <select class="js-data-example-ajax form-control w-100" name="Account" id="AccountCode" required>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Check_Type')}} </label>
                            <select class="select2 form-control w-100" name="Check_Type" required>
                                <option value="">{{trans('admin.Check_Type')}} </option>
                                @foreach($ChecksTypes as $type)
                                <option value="{{$type->id}}">
                                    {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Bank')}} </label>
                            <select class="js-data-example-ajax form-control w-100" name="Bank" id="Bank" required>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Check_Num')}}</label>
                            <input type="text" name="Check_Num" value="{{old('Check_Num')}}" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Due_Date')}}</label>
                            <input type="date" name="Due_Date" value="{{old('Due_Date')}}" class="form-control" required>
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Coin')}} </label>
                            <select class="select2 form-control w-100" name="Coin" required>
                                <option value="">{{trans('admin.Coin')}}</option>
                                @foreach($Coins as $coin)
                                <option value="{{$coin->id}}" @if($coin->id == $Def->Coin) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                            <input type="number" step="any" name="Draw" value="{{$Def->Draw}}" class="form-control" required />
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Cost_Center')}} </label>
                            <select class="select2 form-control w-100" name="Cost_Center">
                                <option value="">{{trans('admin.Cost_Center')}} </option>
                                @foreach($CostCenters as $cost)
                                <option value="{{$cost->id}}">
                                    {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Amount')}}</label>
                            <input type="number" step="any" value="{{old('Amount')}}" name="Amount" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                            <input type="text" name="Note" value="{{old('Note')}}" class="form-control">
                        </div>




                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Signture_Name')}}</label>
                            <input type="text" name="Signture_Name" value="{{old('Signture_Name')}}" class="form-control">
                        </div>


                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Bank_Branch')}}</label>
                            <input type="text" name="Bank_Branch" value="{{old('Bank_Branch')}}" class="form-control">
                        </div>

                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Image')}}</label>
                            <input type="file" name="Image">
                        </div>


                        @if($show->Show_File_Checks == 1)
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput">{{trans('admin.File')}}</label>
                            <input type="file" name="File" class="form-control">
                        </div>
                        @endif

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                    <button type="submit" class="btn btn-primary">{{trans('admin.Save')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>


@foreach($items as $item)

<!-- Modal Edit-->
<div class="modal fade" id="Edit{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Edit')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="{{url('EditIncoming_checks/'.$item->id)}}" method="post" enctype="multipart/form-data">
                {!! csrf_field() !!}
                @honeypot
                <div class="modal-body">

                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                            <input type="text" name="Old_Code" value="{{$item->Code}}" readonly class="form-control">
                            <input type="hidden" name="Code" value="{{$Code}}">
                        </div>
                        @if(auth()->guard('admin')->user()->emp == 0)
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                            <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                        </div>
                        @else

                        @if(auth()->guard('admin')->user()->Date == 1)
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                            <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required>
                        </div>
                        @else
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                            <input type="date" name="Date" value="{{$item->Date}}" class="form-control" required readonly>
                        </div>
                        @endif

                        @endif

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Account_Name')}} </label>
                            <select class="js-data-example-ajax form-control w-100 Acc" name="Account" required>
                                <option value="{{$item->Account}}" selected>
                                    {{app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn}}
                                </option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Check_Type')}} </label>
                            <select class="select2 form-control w-100" name="Check_Type" required>
                                <option value="">{{trans('admin.Check_Type')}} </option>
                                @foreach($ChecksTypes as $type)
                                <option value="{{$type->id}}" @if($item->Check_Type == $type->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">

                            <label class="form-label" for="">{{trans('admin.Bank')}} </label>
                            <select class="js-data-example-ajax form-control w-100 Bn" name="Bank" required>
                                <option value="{{$item->Bank}}" selected>
                                    {{app()->getLocale() == 'ar' ?$item->Bank()->first()->Name :$item->Bank()->first()->NameEn}}
                                </option>
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Check_Num')}}</label>
                            <input type="text" name="Check_Num" value="{{$item->Check_Num}}" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Due_Date')}}</label>
                            <input type="date" name="Due_Date" value="{{$item->Due_Date}}" class="form-control" required>
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Coin')}} </label>
                            <select class="select2 form-control w-100" name="Coin" required>
                                <option value="">{{trans('admin.Coin')}}</option>
                                @foreach($Coins as $coin)
                                <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                            <input type="text" name="Draw" value="{{$item->Draw}}" required class="form-control">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Cost_Center')}} </label>
                            <select class="select2 form-control w-100" name="Cost_Center">
                                <option value="">{{trans('admin.Cost_Center')}} </option>
                                @foreach($CostCenters as $cost)
                                <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Amount')}}</label>
                            <input type="number" step="any" value="{{$item->Amount}}" name="Amount" class="form-control" required>
                        </div>
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                            <input type="text" name="Note" value="{{$item->Note}}" class="form-control">
                        </div>





                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Signture_Name')}}</label>
                            <input type="text" name="Signture_Name" value="{{$item->Signture_Name}}" class="form-control">
                        </div>


                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Bank_Branch')}}</label>
                            <input type="text" name="Bank_Branch" value="{{$item->Bank_Branch}}" class="form-control">
                        </div>

                        <div class="form-group col-lg-4">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Image')}}</label>
                            <input type="file" name="Image">
                        </div>


                        <input type="hidden" name="Files" value="{{$item->File}}">
                        <input type="hidden" name="Images" value="{{$item->Image}}">
                        @if($show->Show_File_Checks == 1)
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput">{{trans('admin.File')}}</label>
                            <input type="file" name="File" class="form-control">
                        </div>
                        @endif

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                    <button type="submit" class="btn btn-primary">{{trans('admin.SaveChanges')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Transfer to Incom Check-->
<div class="modal fade" id="Trans{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Transfer_to_ExportCheck')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <form action="{{url('TransIncoming_checks')}}" method="post" enctype="multipart/form-data">
                {!! csrf_field() !!}
                @honeypot
                <div class="modal-body">

                    <div class="row">
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Code')}}</label>
                            <input type="text" value="{{$item->Code}}" disabled class="form-control">
                            <input type="hidden" name="Code" value="{{$item->Code}}">
                            <input type="hidden" name="ID" value="{{$item->id}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Date')}}</label>
                            <input type="date" value="{{$item->Date}}" class="form-control" disabled>
                            <input type="hidden" name="Date" value="{{$item->Date}}">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Account_Name')}} </label>
                            <select class="js-data-example-ajax form-control w-100" disabled>
                                <option value="{{$item->Account}}" selected>

                                    {{app()->getLocale() == 'ar' ?$item->Account()->first()->Name :$item->Account()->first()->NameEn}}

                                </option>
                            </select>
                            <input type="hidden" name="Account" value="{{$item->Account}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Check_Type')}} </label>
                            <select class="select2 form-control w-100" name="Check_Type" disabled>
                                <option value="">{{trans('admin.Check_Type')}} </option>
                                @foreach($ChecksTypes as $type)
                                <option value="{{$type->id}}" @if($item->Check_Type == $type->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$type->Arabic_Name :$type->English_Name}}
                                </option>
                                @endforeach
                            </select>
                            <input type="hidden" name="Check_Type" value="{{$item->Check_Type}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Bank')}} </label>
                            <select class="js-data-example-ajax form-control w-100" disabled>
                                <option value="{{$item->Bank}}" selected>

                                    {{app()->getLocale() == 'ar' ?$item->Bank()->first()->Name :$item->Bank()->first()->NameEn}}
                                </option>
                            </select>
                            <input type="hidden" name="Bank" value="{{$item->Bank}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput"> {{trans('admin.Check_Num')}}</label>
                            <input type="text" value="{{$item->Check_Num}}" class="form-control" disabled>
                            <input type="hidden" name="Check_Num" value="{{$item->Check_Num}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Due_Date')}}</label>
                            <input type="date" value="{{$item->Due_Date}}" class="form-control" disabled>
                            <input type="hidden" name="Due_Date" value="{{$item->Due_Date}}">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Coin')}} </label>
                            <select class="select2 form-control w-100" disabled>
                                <option value="">{{trans('admin.Coin')}}</option>
                                @foreach($Coins as $coin)
                                <option value="{{$coin->id}}" @if($item->Coin == $coin->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$coin->Arabic_Name :$coin->English_Name}}
                                </option>
                                @endforeach
                            </select>
                            <input type="hidden" name="Coin" value="{{$item->Coin}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Draw')}}</label>
                            <input type="text" value="{{$item->Draw}}" class="form-control" disabled>
                            <input type="hidden" name="Draw" value="{{$item->Draw}}">
                        </div>

                        <div class="form-group col-lg-3">
                            <label class="form-label" for="">{{trans('admin.Cost_Center')}} </label>
                            <select class="select2 form-control w-100" disabled>
                                <option value="">{{trans('admin.Cost_Center')}} </option>
                                @foreach($CostCenters as $cost)
                                <option value="{{$cost->id}}" @if($item->Cost_Center == $cost->id) selected @endif>
                                    {{app()->getLocale() == 'ar' ?$cost->Arabic_Name :$cost->English_Name}}
                                </option>
                                @endforeach
                            </select>
                            <input type="hidden" name="Cost_Center" value="{{$item->Cost_Center}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Amount')}}</label>
                            <input type="number" step="any" value="{{$item->Amount}}" class="form-control" disabled>
                            <input type="hidden" name="Amount" value="{{$item->Amount}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for="simpleinput">{{trans('admin.Notes')}}</label>
                            <input type="text" value="{{$item->Note}}" class="form-control" disabled>
                            <input type="hidden" name="Note" value="{{$item->Note}}">
                        </div>
                        <div class="form-group col-lg-3">
                            <label class="form-label" for=""> {{trans('admin.Bene_Account')}}</label>
                            <select class="js-data-example-ajax form-control w-100 Acc" name="Bene_Account">
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                    <button type="submit" class="btn btn-primary">{{trans('admin.Save')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Refuse -->
<div class="modal fade" id="Ref{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Refuse')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <form action="{{url('ReasonIncoming_checks')}}" method="post">
                {!! csrf_field() !!}
                @honeypot
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-lg-12">
                            <label class="form-label" for="simpleinput">
                                {{trans('admin.Reason_Refuse')}}
                            </label>
                            <input type="text" name="Reason" value="{{old('Reason')}}" class="form-control" required>
                            <input type="hidden" name="ID" value="{{$item->id}}">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.Close')}} </button>
                    <button type="submit" class="btn btn-primary"> {{trans('admin.Save')}} </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Delete -->
<div class="modal fade" id="Delete{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Delete')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                {{trans('admin.RUSWDT')}} <strong>{{$item->Code}}</strong>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.No')}}</button>
                <a href="{{url('DeleteIncoming_checks/'.$item->id)}}" class="btn btn-primary"> {{trans('admin.Yes')}}</a>
            </div>
        </div>
    </div>
</div>

<!--Modal show data-->
<div class="modal fade" id="show-data{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Data')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <div style="overflow:auto">
                    <table class="table table-bordered table-hover table-striped">
                        <thead class="bg-highlight">
                            <tr>
                                <th> {{trans('admin.Check_Type')}}</th>
                                <th> {{trans('admin.Pay_Account')}}</th>
                                <th> {{trans('admin.Amount')}}</th>
                                <th> {{trans('admin.Coin')}}</th>
                                <th> {{trans('admin.Draw')}}</th>
                                <th> {{trans('admin.Coin_Amount')}}</th>
                                <th> {{trans('admin.Cost_Center')}}</th>
                                <th> {{trans('admin.Notes')}}</th>
                                <th> {{trans('admin.Status')}}</th>
                                <th> {{trans('admin.Image')}}</th>
                                <th> {{trans('admin.Signture_Name')}}</th>
                                <th> {{trans('admin.Bank_Branch')}}</th>
                                <th> {{trans('admin.User')}}</th>
                            </tr>
                        </thead>
                        <tbody>

                            <tr>
                                <td>

                                    @if(!empty($item->Check_Type()->first()->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ?$item->Check_Type()->first()->Arabic_Name :$item->Check_Type()->first()->English_Name}}
                                    @endif
                                </td>
                                <td>
                                    @if(!empty($item->Arrest_Account()->first()->Name))

                                    {{app()->getLocale() == 'ar' ?$item->Arrest_Account()->first()->Name :$item->Arrest_Account()->first()->NameEn}}

                                    @endif
                                </td>
                                <td>{{$item->Amount}}</td>

                                <td>
                                    @if(!empty($item->Coin()->first()->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ?$item->Coin()->first()->Arabic_Name :$item->Coin()->first()->English_Name}}
                                    @endif
                                </td>
                                <td>{{$item->Draw}}</td>
                                <td>{{$item->Draw * $item->Amount}}</td>
                                <td>


                                    @if(!empty($item->Cost_Center()->first()->Arabic_Name))
                                    {{app()->getLocale() == 'ar' ?$item->Cost_Center()->first()->Arabic_Name :$item->Cost_Center()->first()->English_Name}}
                                    @endif
                                </td>

                                <td>{{$item->Note}}</td>
                                <td>
                                    @if($item->Status == 0)
                                    {{trans('admin.Waiting')}}

                                    @elseif($item->Status == 1)

                                    {{trans('admin.Refused')}} <br>

                                    {{$item->Reason}}



                                    @elseif($item->Status == 2)

                                    {{trans('admin.Transfered')}} <br>
                                    @if(!empty($item->Bene_Account))

                                    {{app()->getLocale() == 'ar' ?$item->Bene_Account()->first()->Name :$item->Bene_Account()->first()->NameEn}}
                                    @endif

                                    @elseif($item->Status == 3)


                                    {{trans('admin.Check_Payed')}}


                                    @endif
                                </td>

                                <td><img src="{{URL::to($item->Image)}}" style="width: 50%"></td>
                                <td>{{$item->Signture_Name}}</td>
                                <td>{{$item->Bank_Branch}}</td>

                                <td>

                                    @if(!empty($item->User()->first()->name))
                                    {{app()->getLocale() == 'ar' ?$item->User()->first()->name :$item->User()->first()->nameEn}}
                                    @endif
                                </td>

                            </tr>

                        </tbody>

                    </table>
                </div>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-secondary" data-dismiss="modal"> {{trans('admin.close')}}</button>

            </div>
        </div>
    </div>
</div>



<!-- Modal Pay -->
<div class="modal fade" id="Pay{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {{trans('admin.Pay')}}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>

            <form action="{{url('PayIncomingChecks')}}" method="post" enctype="multipart/form-data">
                {!! csrf_field() !!}
                @honeypot
                <div class="modal-body">

                    <div class="row">

                        <input type="hidden" name="ID" value="{{$item->id}}">

                        <div class="form-group col-lg-12">
                            <label class="form-label" for=""> {{trans('admin.Account')}}</label>
                            <select class="js-data-example-ajax form-control w-100 Safe" name="BankSafe_Account">
                            </select>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('admin.Close')}}</button>
                    <button type="submit" class="btn btn-primary">{{trans('admin.Pay')}}</button>
                </div>
            </form>
        </div>
    </div>
</div>



@endforeach

@endsection

@push('js')
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/datagrid/datatables/datatables.bundle.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/summernote/summernote.css')}}">
<link rel="stylesheet" media="screen, print" href="{{asset('Admin/css/formplugins/select2/select2.bundle.css')}}">

<script src="{{asset('Admin/js/datagrid/datatables/datatables.export.js')}}"></script>
<script src="{{asset('Admin/js/datagrid/datatables/datatables.bundle.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/summernote/summernote.js')}}"></script>
<script src="{{asset('Admin/js/formplugins/select2/select2.bundle.js')}}"></script>
<script>
    //_fnFeatureHtmlLength();
    $(document).ready(function() {
        // Setup - add a text input to each footer cell
        $('#dt-basic-example thead tr').clone(true).appendTo('#dt-basic-example thead');
        $('#dt-basic-example thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Search ' + '" />');

            $('input', this).on('keyup change', function() {
                if (table.column(i).search() !== this.value) {
                    table
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });
        var table = $('#dt-basic-example').DataTable({
            // responsive: true,
            orderCellsTop: true,
            fixedHeader: true,
            lengthChange: true,

            dom: "<'row mb-3'<'col-sm-12 col-md-3 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-9 d-flex align-items-center justify-content-end'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

            buttons: [{
                    extend: 'pageLength',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'colvis',
                    text: 'Column Visibility',
                    titleAttr: 'Col visibility',
                    className: 'btn-outline-default'
                },
                {
                    extend: 'pdfHtml5',
                    text: 'PDF',
                    titleAttr: 'Generate PDF',
                    className: 'btn-outline-danger btn-sm mr-1'
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    titleAttr: 'Generate Excel',
                    className: 'btn-outline-success btn-sm mr-1'
                },
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    titleAttr: 'Generate CSV',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'copyHtml5',
                    text: 'Copy',
                    titleAttr: 'Copy to clipboard',
                    className: 'btn-outline-primary btn-sm mr-1'
                },
                {
                    extend: 'print',
                    text: 'Print',
                    titleAttr: 'Print Table',
                    className: 'btn-outline-primary btn-sm'
                }
            ],
        });
        $('.js-thead-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example thead').removeClassPrefix('bg-').addClass(theadColor);
        });

        $('.js-tbody-colors a').on('click', function() {
            var theadColor = $(this).attr("data-bg");
            console.log(theadColor);
            $('#dt-basic-example').removeClassPrefix('bg-').addClass(theadColor);
        });

    });

</script>
<script>
    var autoSave = $('#autoSave');
    var interval;
    var timer = function() {
        interval = setInterval(function() {
            //start slide...
            if (autoSave.prop('checked'))
                saveToLocal();

            clearInterval(interval);
        }, 3000);
    };

    //save
    var saveToLocal = function() {
        localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
        console.log("saved");
    }

    //delete 
    var removeFromLocal = function() {
        localStorage.removeItem("summernoteData");
        $('#saveToLocal').summernote('reset');
    }

    $(document).ready(function() {
        //init default
        $('.js-summernote').summernote({
            height: 200,
            tabsize: 2,
            placeholder: "Type here...",
            dialogsFade: true,
            toolbar: [
                ['style', ['style']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['font', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video']],
                ['view', ['fullscreen', 'codeview', 'help']]
            ],
            callbacks: {
                //restore from localStorage
                onInit: function(e) {
                    $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
                },
                onChange: function(contents, $editable) {
                    clearInterval(interval);
                    timer();
                }
            }
        });

        //load emojis
        $.ajax({
            url: 'https://api.github.com/emojis',
            async: false
        }).then(function(data) {
            window.emojis = Object.keys(data);
            window.emojiUrls = data;
        });

        //init emoji example
        $(".js-hint2emoji").summernote({
            height: 100,
            toolbar: false,
            placeholder: 'type starting with : and any alphabet',
            hint: {
                match: /:([\-+\w]+)$/,
                search: function(keyword, callback) {
                    callback($.grep(emojis, function(item) {
                        return item.indexOf(keyword) === 0;
                    }));
                },
                template: function(item) {
                    var content = emojiUrls[item];
                    return '<img src="' + content + '" width="20" /> :' + item + ':';
                },
                content: function(item) {
                    var url = emojiUrls[item];
                    if (url) {
                        return $('<img />').attr('src', url).css('width', 20)[0];
                    }
                    return '';
                }
            }
        });

        //init mentions example
        $(".js-hint2mention").summernote({
            height: 100,
            toolbar: false,
            placeholder: "type starting with @",
            hint: {
                mentions: ['jayden', 'sam', 'alvin', 'david'],
                match: /\B@(\w*)$/,
                search: function(keyword, callback) {
                    callback($.grep(this.mentions, function(item) {
                        return item.indexOf(keyword) == 0;
                    }));
                },
                content: function(item) {
                    return '@' + item;
                }
            }
        });

    });

</script>


<!-- Search Selecet -->
<script>
    $(document).ready(function() {
        $(function() {
            $('.select2').select2();

            $(".select2-placeholder-multiple").select2({
                placeholder: "Select State"
            });
            $(".js-hide-search").select2({
                minimumResultsForSearch: 1 / 0
            });
            $(".js-max-length").select2({
                maximumSelectionLength: 2,
                placeholder: "Select maximum 2 items"
            });
            $(".select2-placeholder").select2({
                placeholder: "Select a state",
                allowClear: true
            });

            $(".js-select2-icons").select2({
                minimumResultsForSearch: 1 / 0,
                templateResult: icon,
                templateSelection: icon,
                escapeMarkup: function(elm) {
                    return elm
                }
            });

            function icon(elm) {
                elm.element;
                return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text
            }


            $('#AccountCode').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSubAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSubAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#AccountCode').empty();
                                $.each(data, function(key, value) {

                                    $('#AccountCode').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#AccountCode').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('#Bank').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllBanksAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllBanksAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Bank').empty();
                                $.each(data, function(key, value) {

                                    $('#Bank').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Bank').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });



            $('#Bene_Account').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSubAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSubAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('#Bene_Account').empty();
                                $.each(data, function(key, value) {

                                    $('#Bene_Account').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('#Bene_Account').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('.Acc').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSubAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSubAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.Acc').empty();
                                $.each(data, function(key, value) {

                                    $('.Acc').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.Acc').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('.Bn').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllBanksAccounts',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllBanksAccountsJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.Bn').empty();
                                $.each(data, function(key, value) {

                                    $('.Bn').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.Bn').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });


            $('.Safe').select2({
                placeholder: "select...",
                ajax: {
                    type: "GET",
                    dataType: 'json',
                    url: 'AllSafes',
                    processResults: function(data) {
                        return {
                            results: $.map(data, function(obj, index) {
                                return {
                                    id: index,
                                    text: obj
                                };
                            })
                        };

                        console.log(data);

                    },
                    data: function(params) {


                        var query = {
                            search: params.term,
                        };


                        $.ajax({
                            url: 'AllSafesJ/' + params.term,
                            type: "GET",
                            dataType: "json",
                            beforeSend: function() {
                                $('#loader').css("visibility", "visible");
                            },

                            success: function(data) {
                                $('.Safe').empty();
                                $.each(data, function(key, value) {

                                    $('.Safe').append('<option value="' + key + '">' + value + '</option>');

                                });
                            },
                            complete: function() {
                                $('#loader').css("visibility", "hidden");
                            }
                        });



                    }
                }
            });


            $('.Safe').on('select2:select', function(e) {
                console.log("select done", e.params.data);
            });





        });
    });

</script>


@endpush
