//
var autoSave = $('#autoSave');
var interval;
var timer = function () {
    interval = setInterval(function () {
        //start slide...
        if (autoSave.prop('checked'))
            saveToLocal();

        clearInterval(interval);
    }, 3000);
};

//save
var saveToLocal = function () {
    localStorage.setItem('summernoteData', $('#saveToLocal').summernote("code"));
    console.log("saved");
}

//delete
var removeFromLocal = function () {
    localStorage.removeItem("summernoteData");
    $('#saveToLocal').summernote('reset');
}

$(document).ready(function () {
    //init default
    $('.js-summernote').summernote({
        height: 200,
        tabsize: 2,
        placeholder: "Type here...",
        dialogsFade: true,
        toolbar: [
               ['style', ['style']],
               ['font', ['strikethrough', 'superscript', 'subscript']],
               ['font', ['bold', 'italic', 'underline', 'clear']],
               ['fontsize', ['fontsize']],
               ['fontname', ['fontname']],
               ['color', ['color']],
               ['para', ['ul', 'ol', 'paragraph']],
               ['height', ['height']]
               ['table', ['table']],
               ['insert', ['link', 'picture', 'video']],
               ['view', ['fullscreen', 'codeview', 'help']]
           ],
        callbacks: {
            //restore from localStorage
            onInit: function (e) {
                $('.js-summernote').summernote("code", localStorage.getItem("summernoteData"));
            },
            onChange: function (contents, $editable) {
                clearInterval(interval);
                timer();
            }
        }
    });

    //load emojis
    $.ajax({
        url: 'https://api.github.com/emojis',
        async: false
    }).then(function (data) {
        window.emojis = Object.keys(data);
        window.emojiUrls = data;
    });

    //init emoji example
    $(".js-hint2emoji").summernote({
        height: 100,
        toolbar: false,
        placeholder: 'type starting with : and any alphabet',
        hint: {
            match: /:([\-+\w]+)$/,
            search: function (keyword, callback) {
                callback($.grep(emojis, function (item) {
                    return item.indexOf(keyword) === 0;
                }));
            },
            template: function (item) {
                var content = emojiUrls[item];
                return '<img src="' + content + '" width="20" /> :' + item + ':';
            },
            content: function (item) {
                var url = emojiUrls[item];
                if (url) {
                    return $('<img />').attr('src', url).css('width', 20)[0];
                }
                return '';
            }
        }
    });

    //init mentions example
    $(".js-hint2mention").summernote({
        height: 100,
        toolbar: false,
        placeholder: "type starting with @",
        hint: {
            mentions: ['jayden', 'sam', 'alvin', 'david'],
            match: /\B@(\w*)$/,
            search: function (keyword, callback) {
                callback($.grep(this.mentions, function (item) {
                    return item.indexOf(keyword) == 0;
                }));
            },
            content: function (item) {
                return '@' + item;
            }
        }
    });

});

//
//Search Selecet -->
//
$(document).ready(function () {
    $(function () {
        $(".select2").select2();

        $(".select2-placeholder-multiple").select2({
            placeholder: "Select State",
        });
        $(".js-hide-search").select2({
            minimumResultsForSearch: 1 / 0,
        });
        $(".js-max-length").select2({
            maximumSelectionLength: 2,
            placeholder: "Select maximum 2 items",
        });
        $(".select2-placeholder").select2({
            placeholder: "Select a state",
            allowClear: true,
        });

        $(".js-select2-icons").select2({
            minimumResultsForSearch: 1 / 0,
            templateResult: icon,
            templateSelection: icon,
            escapeMarkup: function (elm) {
                return elm;
            },
        });

        function icon(elm) {
            elm.element;
            return elm.id ? "<i class='" + $(elm.element).data("icon") + " mr-2'></i>" + elm.text : elm.text;
        }


        $("#vendor").select2({
            placeholder: "select...",
            ajax: {
                type: "GET",
                dataType: "json",
                url: "AllVendors",
                processResults: function (data) {
                    return {
                        results: $.map(data, function (obj, index) {

                            return {
                                id: index,
                                text: obj
                            };
                        }),
                    };

                    console.log(data);
                },
                data: function (params) {


                    var query = {
                        search: params.term,
                    };


                    $.ajax({
                        url: 'AllVendorsJS/' + params.term,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function () {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function (data) {
                            $('#vendor').empty();
                            $.each(data, function (key, value) {

                                $('#vendor').append('<option value="' + key + '">' + value + '</option>');

                            });
                            var countryId = $('#vendor').val();
                            if (countryId) {
                                $.ajax({
                                    url: 'NewAccountBalanceSOFilter/' + countryId,
                                    type: "GET",
                                    dataType: "json",
                                    beforeSend: function () {
                                        $('#loader').css("visibility", "visible");
                                    },

                                    success: function (data) {

                                        $('#AccountCredit').val(data.credit);
                                        $('#Credit_Limit').val(data.limit);

                                    },
                                    complete: function () {
                                        $('#loader').css("visibility", "hidden");
                                    }
                                });
                            } else {

                                $('select[name="state"]').empty();
                            }



                        },
                        complete: function () {
                            $('#loader').css("visibility", "hidden");
                        }
                    });



                }
            },
        });

        $("#vendor").on("select2:select", function (e) {
            console.log("select done", e.params.data);
        });


        $('#AccountCodeF').select2({
            placeholder: "select...",
            ajax: {
                type: "GET",
                dataType: 'json',
                url: 'AllVendors',
                processResults: function (data) {
                    return {
                        results: $.map(data, function (obj, index) {
                            return {
                                id: index,
                                text: obj
                            };
                        })
                    };

                    console.log(data);

                },
                data: function (params) {


                    var query = {
                        search: params.term,
                    };


                    $.ajax({
                        url: 'AllVendorsJS/' + params.term,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function () {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function (data) {
                            $('#AccountCodeF').empty();
                            $.each(data, function (key, value) {

                                $('#AccountCodeF').append('<option value="' + key + '">' + value + '</option>');

                            });
                        },
                        complete: function () {
                            $('#loader').css("visibility", "hidden");
                        }
                    });



                }
            }
        });


        $('#AccountCodeF').on('select2:select', function (e) {
            console.log("select done", e.params.data);
        });




        $('#AccountCodee').select2({
            placeholder: "select...",
            ajax: {
                type: "GET",
                dataType: 'json',
                url: 'AllVendors',
                processResults: function (data) {
                    return {
                        results: $.map(data, function (obj, index) {
                            return {
                                id: index,
                                text: obj
                            };
                        })
                    };

                    console.log(data);

                },
                data: function (params) {


                    var query = {
                        search: params.term,
                    };


                    $.ajax({
                        url: 'AllVendorsJS/' + params.term,
                        type: "GET",
                        dataType: "json",
                        beforeSend: function () {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function (data) {
                            $('#AccountCodee').empty();
                            $.each(data, function (key, value) {

                                $('#AccountCodee').append('<option value="' + key + '">' + value + '</option>');

                            });
                        },
                        complete: function () {
                            $('#loader').css("visibility", "hidden");
                        }
                    });



                }
            }
        });


        $('#AccountCodee').on('select2:select', function (e) {
            console.log("select done", e.params.data);
        });




    });
});
//
//Unit Code and Name -->
//
function UnitCodePurchh(r) {

    var countryId = $('#UnitPurch' + r).val();
    var Pro = $('#Product' + r).val();
    var store = $('#StorePurch' + r).val();
    var code = $('#CodePurch' + r).val();

    if (countryId) {
        $.ajax({
            url: 'UnitPurchasesFilter',
            type: "GET",
            data: {
                countryId: countryId,
                Pro: Pro,
                store: store,
                code: code
            },
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    $('#CodePurch' + r).val(data.code);
                    $('#UnitPurchName' + r).val(data.name);
                    $('#TaxRate' + r).val(data.rate);
                    $('#TaxType' + r).val(data.type);
                    $('#Price' + r).val(data.price);
                    $('#Price_Sale' + r).val(data.priceOne);
                    $('#PurchTax' + r).val(data.tax);
                    $('#UnitPriceOne' + r).val(data.priceOne);
                    $('#UnitPriceTwo' + r).val(data.priceTwo);
                    $('#UnitPriceThree' + r).val(data.priceThree);


                });

                var TaxRate = $("#TaxRate" + r).val();
                var TaxType = $("#TaxType" + r).val();
                var Qty = $("#Qty" + r).val();
                var Price = $("#Price" + r).val();
                var Discount = $("#Discount" + r).val();
                var i = 0;
                var ii = 0;
                var iii = 0;

                var DIS = $("#DIS").val();

                if (parseFloat(DIS) == 0) {

                    Discount = $("#Discount" + r).val();

                } else {

                    var d = Discount / 100;
                    var Multi = parseFloat(Price);
                    var dd = Multi * d;

                    Discount = dd;

                }
                var BFG = parseFloat(Qty) * parseFloat(Discount);
                $("#TDiscPro" + r).val(parseFloat(BFG));

                if (TaxType == 1) {
                    //Precent

                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * parseFloat(Price);

                    $("#TotalBFTax" + r).val(parseFloat(BFF));

                    i = parseFloat(TaxRate) / 100;

                    ii = parseFloat(BFF) * parseFloat(i);

                    $("#Tax" + r).val(parseFloat(ii));

                    iii = parseFloat(BFF) + parseFloat(ii);

                    $("#Total" + r).val(parseFloat(iii));

                } else if (TaxType == 2) {
                    //Number
                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * parseFloat(Price);
                    $("#TotalBFTax" + r).val(parseFloat(BFF));

                    i = parseFloat(TaxRate);

                    $("#Tax" + r).val(parseFloat(i));

                    iii = parseFloat(BFF) + parseFloat(i);

                    $("#Total" + r).val(parseFloat(iii));


                }


                var Total = $("#Total" + r).val();
                var TotalBFTax = $("#TotalBFTax" + r).val();
                var Tax = $("#Tax" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var StorePurch = $("#StorePurch" + r).val();

                if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

                    document.getElementById("AddBtnPur" + r).style.display = "none";
                }


                if (TaxRate != '' && TaxType != '' && Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

                    document.getElementById("AddBtnPur" + r).style.display = "block";
                }




            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        $('select[name="state"]').empty();
    }

}
//
//Unit Code and Name V -->
//
function UnitCodePurch(r) {

    var countryId = $('#UnitPurch' + r).val();
    var Pro = $('#Product' + r).val();
    var store = $('#StorePurch' + r).val();
    var code = $('#CodePurch' + r).val();
    if (countryId) {
        $.ajax({
            url: 'UnitPurchasesFilter',
            type: "GET",
            data: {
                countryId: countryId,
                Pro: Pro,
                store: store,
                code: code
            },
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    $('#CodePurch' + r).val(data.code);
                    $('#UnitPurchName' + r).val(data.name);
                    $('#TaxRate' + r).val(data.rate);
                    $('#TaxType' + r).val(data.type);
                    $('#Price' + r).val(data.price);
                    $('#Price_Sale' + r).val(data.priceOne);
                    $('#PurchTax' + r).val(data.tax);
                    $('#UnitPriceOne' + r).val(data.priceOne);
                    $('#UnitPriceTwo' + r).val(data.priceTwo);
                    $('#UnitPriceThree' + r).val(data.priceThree);

                });

                var TaxRate = $("#TaxRate" + r).val();
                var TaxType = $("#TaxType" + r).val();
                var Qty = $("#Qty" + r).val();
                var Price = $("#Price" + r).val();
                var Discount = $("#Discount" + r).val();
                var i = 0;
                var ii = 0;
                var iii = 0;
                var DIS = $("#DIS").val();

                if (parseFloat(DIS) == 0) {

                    Discount = $("#Discount" + r).val();

                } else {

                    var d = Discount / 100;
                    var Multi = parseFloat(Price);
                    var dd = Multi * d;

                    Discount = dd;

                }
                var BFG = parseFloat(Qty) * parseFloat(Discount);
                $("#TDiscPro" + r).val(parseFloat(BFG));


                if (TaxType == 1) {
                    //Precent

                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * parseFloat(Price);

                    $("#TotalBFTax" + r).val(parseFloat(BFF));

                    i = parseFloat(TaxRate) / 100;

                    ii = parseFloat(BFF) * parseFloat(i);

                    $("#Tax" + r).val(parseFloat(ii));

                    iii = parseFloat(BFF) + parseFloat(ii);

                    $("#Total" + r).val(parseFloat(iii));

                } else if (TaxType == 2) {
                    //Number
                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * parseFloat(Price);
                    $("#TotalBFTax" + r).val(parseFloat(BFF));

                    i = parseFloat(TaxRate);

                    $("#Tax" + r).val(parseFloat(i));

                    iii = parseFloat(BFF) + parseFloat(i);

                    $("#Total" + r).val(parseFloat(iii));


                }


                var Total = $("#Total" + r).val();
                var TotalBFTax = $("#TotalBFTax" + r).val();
                var Tax = $("#Tax" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var StorePurch = $("#StorePurch" + r).val();

                if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

                    document.getElementById("AddBtnPur" + r).style.display = "none";
                }


                if (TaxRate != '' && TaxType != '' && Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

                    document.getElementById("AddBtnPur" + r).style.display = "block";
                }




            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        $('select[name="state"]').empty();
    }

}
//
//Store Name -->
//
function StoreNamePurch(r) {

    var countryId = $('#StorePurch' + r).val();
    var Pro = $('#Product' + r).val();
    var Un = $('#UnitPurch' + r).val();
    var CO = $('#CodePurch' + r).val();
    if (countryId) {
        $.ajax({
            url: 'StoreNamePurchasesFilter/' + countryId,
            type: "GET",
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    $('#StorePurchName' + r).val(data.name);


                    $.ajax({
                        url: 'StorePricePurchasesFilter',
                        type: "GET",
                        data: {
                            Product: Pro,
                            Store: countryId,
                            Unit: Un,
                            Code: CO,
                        },
                        dataType: "json",
                        beforeSend: function () {
                            $('#loader').css("visibility", "visible");
                        },

                        success: function (data) {
                            $.each(data, function (key, value) {

                                $('#Price' + r).val(data.price);



                            });

                            var TaxRate = $("#TaxRate" + r).val();
                            var TaxType = $("#TaxType" + r).val();
                            var Qty = $("#Qty" + r).val();
                            var Price = $("#Price" + r).val();
                            var Discount = $("#Discount" + r).val();
                            var i = 0;
                            var ii = 0;
                            var iii = 0;

                            var DIS = $("#DIS").val();

                            if (parseFloat(DIS) == 0) {

                                Discount = $("#Discount" + r).val();

                            } else {

                                var d = Discount / 100;
                                var Multi = parseFloat(Price);
                                var dd = Multi * d;

                                Discount = dd;

                            }
                            var BFG = parseFloat(Qty) * parseFloat(Discount);
                            $("#TDiscPro" + r).val(parseFloat(BFG));

                            if (TaxType == 1) {
                                //Precent

                                var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                                var BFF = parseFloat(Qty) * parseFloat(Price);

                                $("#TotalBFTax" + r).val(parseFloat(BFF));

                                i = parseFloat(TaxRate) / 100;

                                ii = parseFloat(BFF) * parseFloat(i);

                                $("#Tax" + r).val(parseFloat(ii));

                                iii = parseFloat(BFF) + parseFloat(ii);

                                $("#Total" + r).val(parseFloat(iii));

                            } else if (TaxType == 2) {
                                //Number
                                var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                                var BFF = parseFloat(Qty) * parseFloat(Price);
                                $("#TotalBFTax" + r).val(parseFloat(BFF));

                                i = parseFloat(TaxRate);

                                $("#Tax" + r).val(parseFloat(i));

                                iii = parseFloat(BFF) + parseFloat(i);

                                $("#Total" + r).val(parseFloat(iii));


                            }


                            var Total = $("#Total" + r).val();
                            var TotalBFTax = $("#TotalBFTax" + r).val();
                            var Tax = $("#Tax" + r).val();
                            var UnitID = $("#UnitPurch" + r).val();
                            var StorePurch = $("#StorePurch" + r).val();

                            if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

                                document.getElementById("AddBtnPur" + r).style.display = "none";
                            }


                            if (TaxRate != '' && TaxType != '' && Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

                                document.getElementById("AddBtnPur" + r).style.display = "block";
                            }




                        },
                        complete: function () {
                            $('#loader').css("visibility", "hidden");
                        }
                    });



                });

                var TaxRate = $("#TaxRate" + r).val();
                var TaxType = $("#TaxType" + r).val();
                var Qty = $("#Qty" + r).val();
                var Price = $("#Price" + r).val();
                var Discount = $("#Discount" + r).val();
                var i = 0;
                var ii = 0;
                var iii = 0;
                var DIS = $("#DIS").val();

                if (parseFloat(DIS) == 0) {

                    Discount = $("#Discount" + r).val();

                } else {

                    var d = Discount / 100;
                    var Multi = parseFloat(Price);
                    var dd = Multi * d;

                    Discount = dd;

                }
                var BFG = parseFloat(Qty) * parseFloat(Discount);
                $("#TDiscPro" + r).val(parseFloat(BFG));

                if (TaxType == 1) {
                    //Precent

                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * (parseFloat(Price));

                    $("#TotalBFTax" + r).val(parseFloat(BFF));

                    i = parseFloat(TaxRate) / 100;

                    ii = parseFloat(BFF) * parseFloat(i);

                    $("#Tax" + r).val(parseFloat(ii));

                    iii = parseFloat(BFF) + parseFloat(ii);

                    $("#Total" + r).val(parseFloat(iii));

                } else if (TaxType == 2) {
                    //Number
                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * (parseFloat(Price));
                    $("#TotalBFTax" + r).val(parseFloat(BFF));

                    i = parseFloat(TaxRate);

                    $("#Tax" + r).val(parseFloat(i));

                    iii = parseFloat(BFF) + parseFloat(i);

                    $("#Total" + r).val(parseFloat(iii));


                }


                var Total = $("#Total" + r).val();
                var TotalBFTax = $("#TotalBFTax" + r).val();
                var Tax = $("#Tax" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var StorePurch = $("#StorePurch" + r).val();

                if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

                    document.getElementById("AddBtnPur" + r).style.display = "none";
                }


                if (TaxRate != '' && TaxType != '' && Qty != '' && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

                    document.getElementById("AddBtnPur" + r).style.display = "block";
                }




            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        $('select[name="state"]').empty();
    }

}
//
//Account Balance -->
//
$(document).ready(function () {

    $('#vendor').on('change', function () {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'AccountBalanceFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function () {
                    $('#loader').css("visibility", "visible");
                },

                success: function (data) {
                    $.each(data, function (key, value) {


                        $('#AccountCredit').val(parseFloat(key).toFixed(2));
                        $('#AccountCredit').val(parseFloat(value).toFixed(2));
                    });
                },
                complete: function () {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="state"]').empty();
        }

    });

});


$(document).ready(function () {

    var countryId = $('#vendor').val();
    if (countryId) {
        $.ajax({
            url: 'AccountBalanceFilter/' + countryId,
            type: "GET",
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {



                    $('#AccountCredit').val(parseFloat(key).toFixed(2));
                    $('#AccountCredit').val(parseFloat(value).toFixed(2));
                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        $('select[name="state"]').empty();
    }

});


//
// Filter Products -->
//
$(document).ready(function () {

    fetch_customer_data();

    function fetch_customer_data(search = '', store = '', vendor = '', Brand = '', Group = '') {
        $.ajax({
            url: 'PurchacesProductsFilter',
            method: 'GET',
            data: {
                search: search,
                store: store,
                vendor: vendor,
                Brand: Brand,
                Group: Group
            },
            dataType: 'json',
            success: function (data) {
                $('.Data').html(data.table_data);
                $("#Data").show();
            }
        })
    }

    $(document).on('keyup', '#search', function () {
        var search = $(this).val();
        var store = $('#store').val();
        var vendor = $('#vendor').val();
        var Brand = $('#Brandd').val();
        var Group = $('#Groupp').val();
        if (search == '') {
            $("#Data").hide();
        }
        fetch_customer_data(search, store, vendor, Brand, Group);
    });


    $(document).on('change', '#store', function () {
        var store = $(this).val();
        var search = $('#search').val();
        var vendor = $('#vendor').val();
        var Brand = $('#Brandd').val();
        var Group = $('#Groupp').val();
        fetch_customer_data(search, store, vendor, Brand, Group);
    });


    $(document).on('change', '#vendor', function () {
        var vendor = $(this).val();
        var search = $('#search').val();
        var store = $('#store').val();
        var Brand = $('#Brandd').val();
        var Group = $('#Groupp').val();
        fetch_customer_data(search, store, vendor, Brand, Group);
    });

    $(document).on('change', '#Brandd', function () {
        var Brand = $(this).val();
        var search = $('#search').val();
        var store = $('#store').val();
        var vendor = $('#vendor').val();
        var Group = $('#Groupp').val();
        fetch_customer_data(search, store, vendor, Brand, Group);
    });


    $(document).on('change', '#Groupp', function () {
        var Group = $(this).val();
        var search = $('#search').val();
        var store = $('#store').val();
        var Brand = $('#Brandd').val();
        var vendor = $('#vendor').val();
        fetch_customer_data(search, store, vendor, Brand, Group);
    });



});
//
//Filter Search Code -->
//
$(document).ready(function () {

    fetch_customer_data();

    function fetch_customer_data(search = '', store = '', vendor = '', Brand = '', Group = '') {
        $.ajax({
            url: 'PurchacesProductsSearchCodeFilter',
            method: 'GET',
            data: {
                search: search,
                store: store,
                vendor: vendor,
                Brand: Brand,
                Group: Group
            },
            dataType: 'json',
            success: function (data) {
                $('.Data').html(data.table_data);
                $("#Data").show();
            }
        })
    }

    $(document).on('keyup', '#SearchCode', function () {
        var search = $(this).val();
        var store = $('#store').val();
        var vendor = $('#vendor').val();
        var Brand = $('#Brandd').val();
        var Group = $('#Groupp').val();
        if (search == '') {
            $("#Data").hide();
        }
        fetch_customer_data(search, store, vendor, Brand, Group);
    });



});
//
//Add Products -->


function Fun(r) {

    var P_Ar_Name = $("#P_Ar_Name" + r).val();
    var P_En_Name = $("#P_En_Name" + r).val();
    var Product = $("#Product" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var UnitName = $("#UnitPurchName" + r).val();
    var Qty = $("#Qty" + r).val();
    var Barcode = $("#CodePurch" + r).val();
    var Price = $("#Price" + r).val();
    var Total = $("#Total" + r).val();
    var TotalNet = $("#TotalNet" + r).val();
    var ExpDate = $("#ExpDate" + r).val();
    var PurchTax = $("#PurchTax" + r).val();
    var TotalTax = $("#Tax" + r).val();
    var Discount = $("#Discount" + r).val();
    var TDiscPro = $("#TDiscPro" + r).val();
    var TotalBFTax = $("#TotalBFTax" + r).val();
    var StorePurch = $("#StorePurch" + r).val();
    var StorePurchName = $("#StorePurchName" + r).val();
    var PurchTax = $("#PurchTax" + r).val();
    var Price_Sale = $("#Price_Sale" + r).val();
    var TaxRate = $("#TaxRate" + r).val();
    var TaxType = $("#TaxType" + r).val();
    var Exp = '';
    var ED = $("#ED").val();
    var DISCSHOW = $("#DISCSHOW").val();
    var TOTBFSHOW = $("#TOTBFSHOW").val();
    var TAXSHOW = $("#TAXSHOW").val();
    var STORESHOW = $("#STORESHOW").val();
    var Show_Unit = $("#Show_Unit").val();
    var Show_Barcode = $("#Show_Barcode").val();
    var Show_Total = $("#Show_Total").val();
    var Show_Net = $("#Show_Net").val();
    var Duplicate_Items = $("#Duplicate_Items").val();


    if (ED == 1) {

        Exp = "<td><input type='hidden' name='Exp_Date[]' value='" + ExpDate + "'>" + ExpDate + "</td>";

    } else {

        Exp = "<input type='hidden' name='Exp_Date[]' value='" + ExpDate + "'>";
    }

    if (DISCSHOW == 1) {

        var DISCSHOWW = "";

    } else {

        var DISCSHOWW = "none";
    }


    if (TOTBFSHOW == 1) {

        var TOTBFSHOWW = "";

    } else {

        var TOTBFSHOWW = "none";
    }



    if (TAXSHOW == 1) {

        var TAXSHOWW = "";

    } else {

        var TAXSHOWW = "none";
    }



    if (STORESHOW == 1) {

        var STORESHOWW = "";

    } else {

        var STORESHOWW = "none";
    }



    if (Show_Unit == 1) {

        var UNITSHOWW = "";

    } else {

        var UNITSHOWW = "none";
    }
    if (Show_Barcode == 1) {

        var BARCODESHOWW = "";

    } else {

        var BARCODESHOWW = "none";
    }


    if (Show_Total == 1) {

        var TOTALSHOWW = "";

    } else {

        var TOTALSHOWW = "none";
    }

    if (Show_Net == 1) {

        var NETSHOWW = "";

    } else {

        var NETSHOWW = "none";
    }

    if (Duplicate_Items == 1) {

        var Duplicate_ItemsSHOW = "readonly";

    } else {

        var Duplicate_ItemsSHOW = "";
    }



    document.getElementById("AddBtnPur" + r).style.display = "none";
    document.getElementById("Row" + r).style.display = "none";


    var LANG = $("#LANG").val();
    if (LANG == 'ar') {
        var Nemo = P_Ar_Name;
    } else {
        var Nemo = P_En_Name;
    }


   var Net=(parseFloat(Total) ) - (parseFloat(Discount) * parseFloat(Qty));
    var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'>" + Nemo + "</td><td style='display: "+UNITSHOWW+"'><input type='hidden' name='Unit[]' value='" + UnitID + "'>" + UnitName + "</td><td style='display: "+BARCODESHOWW+"'><input type='hidden' id='BAR" + r + "' name='P_Code[]' value='" + Barcode + "'>" + Barcode + "</td><td><input class='Qun form-control' id='QuntD" + r + "' type='number' step='any' name='Qty[]' value='" + Qty + "' onkeyup='TotD(" + r + ")' onclick='TotD(" + r + ")' "+Duplicate_ItemsSHOW+"></td><td><input type='number' id='PriD" + r + "' step='any' name='Price[]' value='" + Price + "' class='form-control' onkeyup='TotD(" + r + ")' onclick='TotD(" + r + ")' "+Duplicate_ItemsSHOW+" ></td><td style='display:" + DISCSHOWW + "' ><input class='Disc form-control' id='DiscD" + r + "' type='number' step='any' name='Discount[]' value='" + Discount + "' onkeyup='TotD(" + r + ")' onclick='TotD(" + r + ")' "+Duplicate_ItemsSHOW+" ></td><td style='display:" + TOTBFSHOWW + "'><input class='TotalBFTax form-control' id='TotBFTaxD" + r + "' type='number' step='any' disabled  value='" + TotalBFTax + "'><input type='hidden'  id='TotBFTaxDHide" + r + "' name='TotalBFTax[]'  value='" + TotalBFTax + "'></td><td style='display:" + TAXSHOWW + "'><input class='TotalTax form-control' id='TaxD" + r + "' disabled  type='number' step='any' value='" + TotalTax + "'><input type='hidden' id='TotalTaxVVHide" + r + "'  name='TotalTax[]'  value='" + TotalTax + "'></td><td style='display: "+TOTALSHOWW+"'><input class='Tot form-control' type='number' step='any' id='TotD" + r + "' disabled   name='Total[]' value='" + Total + "'><input type='hidden' id='TotDHide" + r + "' name='Total[]'  value='" + Total + "'></td><td style='display: "+NETSHOWW+"'><input class='form-control' type='number' step='any' id='NetD" + r + "' readonly   name='Total_Net[]' value='" + Net + "'></td><td style='display:" + STORESHOWW + "'><input  type='hidden' name='StorePurch[]' value='" + StorePurch + "'>" + StorePurchName + "</td>" + Exp + "<td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden'  id='PRO" + r + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value=''><input type='hidden' name='VTwo[]' value=''></td><input type='hidden' name='V_Name[]' value=''><input type='hidden' class='TDISCOOO' id='TDiscProEdit" + r + "' name='TDiscPro[]' value='" + TDiscPro + "'><input type='hidden' name='VV_Name[]' value=''><input type='hidden' name='PurchTax[]' value='" + PurchTax + "'><input id='TaxRateD" + r + "' type='hidden'  value='" + TaxRate + "'><input type='hidden' id='TaxTypeD" + r + "'  value='" + TaxType + "'><input type='hidden' name='Price_Sale[]' value='" + Price_Sale + "'><input type='hidden' id='Enough" + r + "' name='AllEnough[]' class='ENO'  value='0'></tr>";


    if (Duplicate_Items == 1) {

        $("#data-dt").append(markup);
    }else {
        var P = $("#PRO" + r).val();
        var Bar = $("#Bar" + r).val();
        if (Product != P && Barcode != Bar) {
            $("#data-dt").append(markup);
        }
    }

    var SHOWHIDEPRO = $("#SHOWHIDEPRO").val();

    if (parseFloat(SHOWHIDEPRO) == 0) {
        $("#Data").hide();
    }

    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

    var sumT = 0;
    $('.Tot').each(function () {
        sumT += parseFloat($(this).val());
    });

    var sumD = 0;
    $('.Disc').each(function () {
        sumD += parseFloat($(this).val());
    });

    var sumTTD = 0;
    $('.TDISCOOO').each(function () {
        sumTTD += parseFloat($(this).val());
    });


    var sumBF = 0;
    $('.TotalBFTax').each(function () {
        sumBF += parseFloat($(this).val());
    });

    var sumTax = 0;
    $('.TotalTax').each(function () {
        sumTax += parseFloat($(this).val());
    });

var resdiual=$('#resdiual').val();

    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

    $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
    $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



    $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
    $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

    $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
    $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

    $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
    $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

    $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
    $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


    $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
    var RR = ($after_tax - parseFloat(sumTTD));
    $('#Total_After_Taxes').val($after_tax);
    $('#TAFterD').val(parseFloat(RR).toFixed(2));
    $('#paid').val(parseFloat(RR).toFixed(2));

    $('#Total_Bill').val(parseFloat(RR).toFixed(2));
    $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



    if (rowctr == 0) {
        document.getElementById("Submit").style.display = "none";

    } else {

        document.getElementById("Submit").style.display = "block";
    }

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();

    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }



        }

    } else {

        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }
    }

    if (Pay == 'Later') {


        $('#paid').val('');

    }

    Statuss();

    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();


        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

        var sumT = 0;
        $('.Tot').each(function () {
            sumT += parseFloat($(this).val());
        });

        var sumD = 0;
        $('.Disc').each(function () {
            sumD += parseFloat($(this).val());
        });


        var sumBF = 0;
        $('.TotalBFTax').each(function () {
            sumBF += parseFloat($(this).val());
        });

        var sumTax = 0;
        $('.TotalTax').each(function () {
            sumTax += parseFloat($(this).val());
        });


        var sumTTD = 0;
        $('.TDISCOOO').each(function () {
            sumTTD += parseFloat($(this).val());
        });

        var resdiual=$('#resdiual').val();

        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

        $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
        $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



        $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
        $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

        $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
        $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

        $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
        $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

        $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
        $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


        $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
        var RR = ($after_tax - parseFloat(sumTTD));
        $('#Total_After_Taxes').val($after_tax);
        $('#TAFterD').val(parseFloat(RR).toFixed(2));
        $('#paid').val(parseFloat(RR).toFixed(2));

        $('#Total_Bill').val(parseFloat(RR).toFixed(2));
        $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }

        var Pay = $('#Payment_Method').val();
        var Stat = $('#Status').val();
        var paid = $('#paid').val();

        if (Pay == 'Later' && Stat == 0) {

            if (paid <= 0) {
                document.getElementById("Submit").style.display = "none";
            } else {

                if (rowctr == 0) {
                    document.getElementById("Submit").style.display = "none";

                } else {

                    document.getElementById("Submit").style.display = "block";
                }



            }

        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }
        }

        if (Pay == 'Later') {


            $('#paid').val('');

        }


        var EN = 0;
        var Total_PriceW = $('#Total_PriceW').val();

        $('.ENO').each(function () {
            EN += parseFloat($(this).val());
        });
        if (EN == 0) {

            if (Total_PriceW == 'NaN') {
                document.getElementById("Submit").style.display = "none";
            } else {
                document.getElementById("Submit").style.display = "block";
            }

        } else {

            document.getElementById("Submit").style.display = "none";
        }

        Statuss();

    })


}
//
//Add Vira One -->
//
function FunV(r) {

    $.ajax({
        url: 'ViraFilterPurchases/' + r,
        type: "GET",
        dataType: "json",
        beforeSend: function () {
            $('#loader').css("visibility", "visible");
        },

        success: function (data) {
            $.each(data, function (key, value) {

                var P_Ar_Name = $("#P_Ar_Name" + r).val();
                var P_En_Name = $("#P_En_Name" + r).val();
                var Product = $("#Product" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var UnitName = $("#UnitPurchName" + r).val();
                var Qty = $("#Qty" + r).val();
                var Barcode = Math.floor(Math.random() * 10000);
                var Price = $("#Price" + r).val();
                var Total = $("#Total" + r).val();
                var ExpDate = $("#ExpDate" + r).val();
                var PurchTax = $("#PurchTax" + r).val();
                var TotalTax = $("#Tax" + r).val();
                var Discount = $("#Discount" + r).val();
                var TDiscPro = $("#TDiscPro" + r).val();
                var TotalBFTax = $("#TotalBFTax" + r).val();
                var StorePurch = $("#StorePurch" + r).val();
                var StorePurchName = $("#StorePurchName" + r).val();
                var TaxRate = $("#TaxRate" + r).val();
                var Price_Sale = $("#Price_Sale" + r).val();
                var TaxType = $("#TaxType" + r).val();
                var PurchTax = $("#PurchTax" + r).val();

                var Exp = '';
                var ED = $("#ED").val();

                var DISCSHOW = $("#DISCSHOW").val();
                var TOTBFSHOW = $("#TOTBFSHOW").val();
                var TAXSHOW = $("#TAXSHOW").val();
                var STORESHOW = $("#STORESHOW").val();

                if (DISCSHOW == 1) {

                    var DISCSHOWW = "";

                } else {

                    var DISCSHOWW = "none";
                }


                if (TOTBFSHOW == 1) {

                    var TOTBFSHOWW = "";

                } else {

                    var TOTBFSHOWW = "none";
                }



                if (TAXSHOW == 1) {

                    var TAXSHOWW = "";

                } else {

                    var TAXSHOWW = "none";
                }



                if (STORESHOW == 1) {

                    var STORESHOWW = "";

                } else {

                    var STORESHOWW = "none";
                }


                var Show_Unit = $("#Show_Unit").val();
                var Show_Barcode = $("#Show_Barcode").val();
                var Show_Total = $("#Show_Total").val();
                var Show_Net = $("#Show_Net").val();

                if (Show_Unit == 1) {

                    var UNITSHOWW = "";

                } else {

                    var UNITSHOWW = "none";
                }
                if (Show_Barcode == 1) {

                    var BARCODESHOWW = "";

                } else {

                    var BARCODESHOWW = "none";
                }


                if (Show_Total == 1) {

                    var TOTALSHOWW = "";

                } else {

                    var TOTALSHOWW = "none";
                }

                if (Show_Net == 1) {

                    var NETSHOWW = "";

                } else {

                    var NETSHOWW = "none";
                }
                var Net=(parseFloat(Total) ) - (parseFloat(Discount) * parseFloat(Qty));




            if (ED == 1) {

                    Exp = "<td><input type='hidden' name='Exp_Date[]' value='" + ExpDate + "'>" + ExpDate + "</td>";

                } else {

                    Exp = "<input type='hidden' name='Exp_Date[]' value='" + ExpDate + "'>";
                }







                document.getElementById("AddBtnPur" + r).style.display = "none";
                document.getElementById("Row" + r).style.display = "none";


                var LANG = $("#LANG").val();
                if (LANG == 'ar') {
                    var Nemo = P_Ar_Name;
                    var PNNN = 'سعر البيع';
                } else {
                    var Nemo = P_En_Name;
                    var PNNN = 'Sales Price';
                }


                var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'>" + Nemo + " (" + value + ") </td><td style='display: "+UNITSHOWW+"'><input type='hidden' name='Unit[]' value='" + UnitID + "'>" + UnitName + "<br><label> " + PNNN + "</label><input type='number' name='Price_Sale[]' value='" + Price_Sale + "'></td><td style='display: "+BARCODESHOWW+"'><input type='text' id='BAR" + key + "' name='P_Code[]' value='" + Barcode + "' class='form-control'></td><td><input class='Qun  form-control' type='number' id='QuntityV" + key + "' value='" + Qty + "' step='any' name='Qty[]' onkeyup='TotV(" + key + ")' onclick='TotV(" + key + ")'></td> <td><input type='number' name='Price[]' value='" + Price + "' onkeyup='TotV(" + key + ")' onclick='TotV(" + key + ")'  id='PriceV" + key + "' step='any' class='form-control' ></td><td style='display:" + DISCSHOWW + "'><input type='number' name='Discount[]' value='" + Discount + "' onkeyup='TotV(" + key + ")' onclick='TotV(" + key + ")'  id='DiscountV" + key + "' step='any' class='form-control' ></td><td style='display:" + TOTBFSHOWW + "'><input class='TotalBFTax form-control' type='text' id='TotalBFV" + key + "' value='" + TotalBFTax + "'  disabled><input type='hidden' id='TotalBFVHide" + key + "' name='TotalBFTax[]' value='" + TotalBFTax + "'></td><td style='display:" + TAXSHOWW + "'><input class='TotalTax form-control' type='text' id='TotalTax" + key + "' value='" + TotalTax + "'  disabled><input type='hidden' id='TotalTaxVVHide" + key + "'  value='" + TotalTax + "' name='TotalTax[]'></td><td style='display: "+TOTALSHOWW+"'><input class='Tot form-control' type='text' id='TotalV" + key + "' value='" + Total + "'  disabled><input type='hidden' id='TotalVHide" + key + "' name='Total[]' value='" + Total + "'></td>    <td style='display: "+NETSHOWW+"'><input class='form-control' type='number' step='any' id='NetV" + key + "' readonly   name='Total_Net[]' value='" + Net + "'></td><td style='display:" + STORESHOWW + "'><input  type='hidden' name='StorePurch[]' value='" + StorePurch + "'>" + StorePurchName + "</td>" + Exp + "<td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden' id='PRO" + key + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value='" + key + "'><input type='hidden' name='VTwo[]' value=''></td><input type='hidden' name='V_Name[]' value='" + value + "'><input type='hidden' name='VV_Name[]' value=''><input type='hidden'  value='" + TaxRate + "' id='RateV" + key + "'><input type='hidden'  value='" + TaxType + "' id='TypeV" + key + "'><input type='hidden' name='PurchTax[]' value='" + PurchTax + "'><input type='hidden' class='TDISCOOO' id='TDiscProEdit" + key + "' name='TDiscPro[]' value='" + TDiscPro + "'><input type='hidden' id='Enough" + key + "' name='AllEnough[]' class='ENO'  value='0'></tr>";

                $("#data-dt").append(markup);
                var SHOWHIDEPRO = $("#SHOWHIDEPRO").val();

                if (parseFloat(SHOWHIDEPRO) == 0) {
                    $("#Data").hide();
                }
                $.fn.rowCount = function () {
                    return $('tr', $(this).find('tbody')).length;
                };

                var rowctr = $('#dt').rowCount();

                var sumQ = 0;
                $('.Qun').each(function () {
                    sumQ += parseFloat($(this).val());
                });

                var sumT = 0;
                $('.Tot').each(function () {
                    sumT += parseFloat($(this).val());
                });

                var sumD = 0;
                $('.Disc').each(function () {
                    sumD += parseFloat($(this).val());
                });


                var sumBF = 0;
                $('.TotalBFTax').each(function () {
                    sumBF += parseFloat($(this).val());
                });

                var sumTax = 0;
                $('.TotalTax').each(function () {
                    sumTax += parseFloat($(this).val());
                });


                var sumTTD = 0;
                $('.TDISCOOO').each(function () {
                    sumTTD += parseFloat($(this).val());
                });
                var resdiual=$('#resdiual').val();

                $('#Product_Numbers').val(parseFloat(rowctr));
                $('#Product_NumbersHide').val(parseFloat(rowctr));

                $('#Total_Qty').val(parseFloat(sumQ));
                $('#Total_QtyHide').val(parseFloat(sumQ));

                $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
                $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



                $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
                $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

                $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
                $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

                $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
                $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

                $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
                $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


                $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
                var RR = ($after_tax - parseFloat(sumTTD));
                $('#Total_After_Taxes').val($after_tax);
                $('#TAFterD').val(parseFloat(RR).toFixed(2));
                $('#paid').val(parseFloat(RR).toFixed(2));

                $('#Total_Bill').val(parseFloat(RR).toFixed(2));
                $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



                if (rowctr == 0) {
                    document.getElementById("Submit").style.display = "none";

                } else {

                    document.getElementById("Submit").style.display = "block";
                }

                var Pay = $('#Payment_Method').val();
                var Stat = $('#Status').val();
                var paid = $('#paid').val();

                if (Pay == 'Later' && Stat == 0) {

                    if (paid <= 0) {
                        document.getElementById("Submit").style.display = "none";
                    } else {

                        if (rowctr == 0) {
                            document.getElementById("Submit").style.display = "none";

                        } else {

                            document.getElementById("Submit").style.display = "block";
                        }



                    }

                } else {

                    if (rowctr == 0) {
                        document.getElementById("Submit").style.display = "none";

                    } else {

                        document.getElementById("Submit").style.display = "block";
                    }
                }

                if (Pay == 'Later') {


                    $('#paid').val('');

                }





            });
        },
        complete: function () {
            $('#loader').css("visibility", "hidden");
        }
    });

    var Pay = $('#Payment_Method').val();
    if (Pay == 'Later') {


        $('#paid').val('');

    }
    Statuss();

    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();


        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

        var sumT = 0;
        $('.Tot').each(function () {
            sumT += parseFloat($(this).val());
        });

        var sumD = 0;
        $('.Disc').each(function () {
            sumD += parseFloat($(this).val());
        });


        var sumBF = 0;
        $('.TotalBFTax').each(function () {
            sumBF += parseFloat($(this).val());
        });

        var sumTax = 0;
        $('.TotalTax').each(function () {
            sumTax += parseFloat($(this).val());
        });


        var sumTTD = 0;
        var resdiual=$('#resdiual').val();

        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

        $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
        $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



        $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
        $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

        $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
        $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

        $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
        $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

        $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
        $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


        $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
        var RR = ($after_tax - parseFloat(sumTTD));
        $('#Total_After_Taxes').val($after_tax);
        $('#TAFterD').val(parseFloat(RR).toFixed(2));
        $('#paid').val(parseFloat(RR).toFixed(2));

        $('#Total_Bill').val(parseFloat(RR).toFixed(2));
        $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }

        var Pay = $('#Payment_Method').val();
        var Stat = $('#Status').val();
        var paid = $('#paid').val();

        if (Pay == 'Later' && Stat == 0) {

            if (paid <= 0) {
                document.getElementById("Submit").style.display = "none";
            } else {

                if (rowctr == 0) {
                    document.getElementById("Submit").style.display = "none";

                } else {

                    document.getElementById("Submit").style.display = "block";
                }



            }

        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }
        }

        if (Pay == 'Later') {


            $('#paid').val('');

        }

        var EN = 0;
        var Total_PriceW = $('#Total_PriceW').val();

        $('.ENO').each(function () {
            EN += parseFloat($(this).val());
        });
        if (EN == 0) {

            if (Total_PriceW == 'NaN') {
                document.getElementById("Submit").style.display = "none";
            } else {
                document.getElementById("Submit").style.display = "block";
            }

        } else {

            document.getElementById("Submit").style.display = "none";
        }


        Statuss();
    })


}
//
//Add Vira Two -->
//
function FunVV(r) {
    $.ajax({
        url: 'ViraNamePurchases/' + r,
        type: "GET",
        dataType: "json",
        beforeSend: function () {
            $('#loader').css("visibility", "visible");
        },

        success: function (data) {
            $.each(data, function (key, value) {


                var P_Ar_Name = $("#P_Ar_Name" + r).val();
                var P_En_Name = $("#P_En_Name" + r).val();
                var Product = $("#Product" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var UnitName = $("#UnitPurchName" + r).val();
                var Qty = $("#Qty" + r).val();
                var Barcode = Math.floor(Math.random() * 10000);
                var Price = $("#Price" + r).val();
                var Total = $("#Total" + r).val();
                var ExpDate = $("#ExpDate" + r).val();
                var PurchTax = $("#PurchTax" + r).val();
                var TotalTax = $("#Tax" + r).val();
                var Discount = $("#Discount" + r).val();
                var TDiscPro = $("#TDiscPro" + r).val();
                var TotalBFTax = $("#TotalBFTax" + r).val();
                var StorePurch = $("#StorePurch" + r).val();
                var StorePurchName = $("#StorePurchName" + r).val();
                var TaxRate = $("#TaxRate" + r).val();
                var TaxType = $("#TaxType" + r).val();
                var PurchTax = $("#PurchTax" + r).val();
                var Price_Sale = $("#Price_Sale" + r).val();

                var Exp = '';
                var ED = $("#ED").val();
                var DISCSHOW = $("#DISCSHOW").val();
                var TOTBFSHOW = $("#TOTBFSHOW").val();
                var TAXSHOW = $("#TAXSHOW").val();
                var STORESHOW = $("#STORESHOW").val();

                if (DISCSHOW == 1) {

                    var DISCSHOWW = "";

                } else {

                    var DISCSHOWW = "none";
                }


                if (TOTBFSHOW == 1) {

                    var TOTBFSHOWW = "";

                } else {

                    var TOTBFSHOWW = "none";
                }



                if (TAXSHOW == 1) {

                    var TAXSHOWW = "";

                } else {

                    var TAXSHOWW = "none";
                }



                if (STORESHOW == 1) {

                    var STORESHOWW = "";

                } else {

                    var STORESHOWW = "none";
                }



                var Show_Unit = $("#Show_Unit").val();
                var Show_Barcode = $("#Show_Barcode").val();
                var Show_Total = $("#Show_Total").val();
                var Show_Net = $("#Show_Net").val();

                if (Show_Unit == 1) {

                    var UNITSHOWW = "";

                } else {

                    var UNITSHOWW = "none";
                }
                if (Show_Barcode == 1) {

                    var BARCODESHOWW = "";

                } else {

                    var BARCODESHOWW = "none";
                }


                if (Show_Total == 1) {

                    var TOTALSHOWW = "";

                } else {

                    var TOTALSHOWW = "none";
                }

                if (Show_Net == 1) {

                    var NETSHOWW = "";

                } else {

                    var NETSHOWW = "none";
                }
                var Net=(parseFloat(Total) ) - (parseFloat(Discount) * parseFloat(Qty));




            if (ED == 1) {

                    Exp = "<td><input type='hidden' name='Exp_Date[]' value='" + ExpDate + "'>" + ExpDate + "</td>";

                } else {

                    Exp = "<input type='hidden' name='Exp_Date[]' value='" + ExpDate + "'>";
                }

                document.getElementById("AddBtnPur" + r).style.display = "none";
                document.getElementById("Row" + r).style.display = "none";

                var LANG = $("#LANG").val();
                if (LANG == 'ar') {
                    var Nemo = P_Ar_Name;
                    var PNNN = 'سعر البيع';
                } else {
                    var Nemo = P_En_Name;
                    var PNNN = 'Sales Price';
                }



                var markup = "<tr><td><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'>" + Nemo + " (" + value + ") </td><td style='display: "+UNITSHOWW+"'><input type='hidden' name='Unit[]' value='" + UnitID + "'>" + UnitName + "<br><label> " + PNNN + "</label><input type='number' name='Price_Sale[]' value='" + Price_Sale + "'></td><td style='display: "+BARCODESHOWW+"'><input type='text' id='BAR" + key + "' name='P_Code[]' value='" + Barcode + "' class='form-control'></td><td><input class='Qun  form-control' type='number' id='QuntityVV" + key + "' value='" + Qty + "' step='any' name='Qty[]' onkeyup='TotVV(" + key + ")' onclick='TotVV(" + key + ")'></td> <td><input type='number' name='Price[]' value='" + Price + "' onkeyup='TotVV(" + key + ")' onclick='TotVV(" + key + ")'  id='PriceVV" + key + "' step='any' class='form-control' ></td><td style='display:" + DISCSHOWW + "'><input type='number' name='Discount[]' value='" + Discount + "' onkeyup='TotVV(" + key + ")' onclick='TotVV(" + key + ")'  id='DiscountVV" + key + "' step='any' class='form-control' ></td><td style='display:" + TOTBFSHOWW + "'><input class='TotalBFTax form-control' type='text' id='TotalBFVV" + key + "' value='" + TotalBFTax + "'  disabled><input type='hidden' id='TotalBFVVHide" + key + "' name='TotalBFTax[]' value='" + TotalBFTax + "'></td><td style='display:" + TAXSHOWW + "'><input class='TotalTax form-control' type='text' id='TotalTaxVV" + key + "' value='" + TotalTax + "'  disabled><input type='hidden' id='TotalTaxVVHide" + key + "'  value='" + TotalTax + "' name='TotalTax[]'></td><td style='display: "+TOTALSHOWW+"'><input class='Tot form-control' type='text' id='TotalVV" + key + "' value='" + Total + "'  disabled><input type='hidden' id='TotalVVHide" + key + "' name='Total[]' value='" + Total + "'></td>     <td style='display: "+NETSHOWW+"'><input class='form-control' type='number' step='any' id='NetVV" + key + "' readonly   name='Total_Net[]' value='" + Net + "'></td><td style='display:" + STORESHOWW + "'><input  type='hidden' name='StorePurch[]' value='" + StorePurch + "'>" + StorePurchName + "</td>" + Exp + "<td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button><input type='hidden' id='PRO" + key + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value=''><input type='hidden' name='VTwo[]' value=''></td><input type='hidden' name='V_Name[]' value='" + value + "'><input type='hidden' name='VV_Name[]' value='" + value + "'><input type='hidden'  value='" + TaxRate + "' id='RateVV" + key + "'><input type='hidden'  value='" + TaxType + "' id='TypeVV" + key + "'><input type='hidden' name='PurchTax[]' value='" + PurchTax + "'><input type='hidden' class='TDISCOOO' id='TDiscProEdit" + key + "' name='TDiscPro[]' value='" + TDiscPro + "'><input type='hidden' id='Enough" + key + "' name='AllEnough[]' class='ENO'  value='0'></tr>";

                $("#data-dt").append(markup);

                var SHOWHIDEPRO = $("#SHOWHIDEPRO").val();

                if (parseFloat(SHOWHIDEPRO) == 0) {
                    $("#Data").hide();
                }
            });

            $.fn.rowCount = function () {
                return $('tr', $(this).find('tbody')).length;
            };

            var rowctr = $('#dt').rowCount();

            var sumQ = 0;
            $('.Qun').each(function () {
                sumQ += parseFloat($(this).val());
            });

            var sumT = 0;
            $('.Tot').each(function () {
                sumT += parseFloat($(this).val());
            });

            var sumD = 0;
            $('.Disc').each(function () {
                sumD += parseFloat($(this).val());
            });


            var sumBF = 0;
            $('.TotalBFTax').each(function () {
                sumBF += parseFloat($(this).val());
            });

            var sumTax = 0;
            $('.TotalTax').each(function () {
                sumTax += parseFloat($(this).val());
            });


            var sumTTD = 0;
            $('.TDISCOOO').each(function () {
                sumTTD += parseFloat($(this).val());
            });
            var resdiual=$('#resdiual').val();

            $('#Product_Numbers').val(parseFloat(rowctr));
            $('#Product_NumbersHide').val(parseFloat(rowctr));

            $('#Total_Qty').val(parseFloat(sumQ));
            $('#Total_QtyHide').val(parseFloat(sumQ));

            $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
            $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



            $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
            $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

            $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
            $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

            $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
            $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

            $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
            $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


            $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
            var RR = ($after_tax - parseFloat(sumTTD));
            $('#Total_After_Taxes').val($after_tax);
            $('#TAFterD').val(parseFloat(RR).toFixed(2));
            $('#paid').val(parseFloat(RR).toFixed(2));

            $('#Total_Bill').val(parseFloat(RR).toFixed(2));
            $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }

            var Pay = $('#Payment_Method').val();
            var Stat = $('#Status').val();
            var paid = $('#paid').val();

            if (Pay == 'Later' && Stat == 0) {

                if (paid <= 0) {
                    document.getElementById("Submit").style.display = "none";
                } else {

                    if (rowctr == 0) {
                        document.getElementById("Submit").style.display = "none";

                    } else {

                        document.getElementById("Submit").style.display = "block";
                    }



                }

            } else {

                if (rowctr == 0) {
                    document.getElementById("Submit").style.display = "none";

                } else {

                    document.getElementById("Submit").style.display = "block";
                }
            }

            if (Pay == 'Later') {


                $('#paid').val('');

            }




        },
        complete: function () {
            $('#loader').css("visibility", "hidden");
        }
    });


    var Pay = $('#Payment_Method').val();
    if (Pay == 'Later') {


        $('#paid').val('');

    }



    Statuss();
    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();

        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

        var sumT = 0;
        $('.Tot').each(function () {
            sumT += parseFloat($(this).val());
        });

        var sumD = 0;
        $('.Disc').each(function () {
            sumD += parseFloat($(this).val());
        });


        var sumBF = 0;
        $('.TotalBFTax').each(function () {
            sumBF += parseFloat($(this).val());
        });

        var sumTax = 0;
        $('.TotalTax').each(function () {
            sumTax += parseFloat($(this).val());
        });


        var sumTTD = 0;
        $('.TDISCOOO').each(function () {
            sumTTD += parseFloat($(this).val());
        });
        var resdiual=$('#resdiual').val();

        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

        $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
        $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



        $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
        $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

        $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
        $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

        $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
        $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

        $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
        $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


        $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
        var RR = ($after_tax - parseFloat(sumTTD));
        $('#Total_After_Taxes').val($after_tax);
        $('#TAFterD').val(parseFloat(RR).toFixed(2));
        $('#paid').val(parseFloat(RR).toFixed(2));

        $('#Total_Bill').val(parseFloat(RR).toFixed(2));
        $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }

        var Pay = $('#Payment_Method').val();
        var Stat = $('#Status').val();
        var paid = $('#paid').val();

        if (Pay == 'Later' && Stat == 0) {

            if (paid <= 0) {
                document.getElementById("Submit").style.display = "none";
            } else {

                if (rowctr == 0) {
                    document.getElementById("Submit").style.display = "none";

                } else {

                    document.getElementById("Submit").style.display = "block";
                }



            }

        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }
        }

        if (Pay == 'Later') {


            $('#paid').val('');

        }


        var EN = 0;
        var Total_PriceW = $('#Total_PriceW').val();

        $('.ENO').each(function () {
            EN += parseFloat($(this).val());
        });
        if (EN == 0) {

            if (Total_PriceW == 'NaN') {
                document.getElementById("Submit").style.display = "none";
            } else {
                document.getElementById("Submit").style.display = "block";
            }

        } else {

            document.getElementById("Submit").style.display = "none";
        }

        Statuss();

    })


}


function FunSerial(r) {

    var P_Ar_Name = $("#P_Ar_Name" + r).val();
    var P_En_Name = $("#P_En_Name" + r).val();
    var Product = $("#Product" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var UnitName = $("#UnitPurchName" + r).val();
    var Qty = $("#Qty" + r).val();
    var Barcode = $("#CodePurch" + r).val();
    var Price = $("#Price" + r).val();
    var Total = $("#Total" + r).val();
    var ExpDate = $("#ExpDate" + r).val();
    var PurchTax = $("#PurchTax" + r).val();
    var TotalTax = $("#Tax" + r).val();
    var Discount = $("#Discount" + r).val();
    var TDiscPro = $("#TDiscPro" + r).val();
    var TotalBFTax = $("#TotalBFTax" + r).val();
    var StorePurch = $("#StorePurch" + r).val();
    var StorePurchName = $("#StorePurchName" + r).val();
    var PurchTax = $("#PurchTax" + r).val();
    var Price_Sale = $("#Price_Sale" + r).val();
    var i = 0;

    var Exp = '';
    var ED = $("#ED").val();
    var DISCSHOW = $("#DISCSHOW").val();
    var TOTBFSHOW = $("#TOTBFSHOW").val();
    var TAXSHOW = $("#TAXSHOW").val();
    var STORESHOW = $("#STORESHOW").val();

    if (DISCSHOW == 1) {

        var DISCSHOWW = "";

    } else {

        var DISCSHOWW = "none";
    }


    if (TOTBFSHOW == 1) {

        var TOTBFSHOWW = "";

    } else {

        var TOTBFSHOWW = "none";
    }



    if (TAXSHOW == 1) {

        var TAXSHOWW = "";

    } else {

        var TAXSHOWW = "none";
    }



    if (STORESHOW == 1) {

        var STORESHOWW = "";

    } else {

        var STORESHOWW = "none";
    }


    if (ED == 1) {

        Exp = "<td>" + ExpDate + "</td>";

    } else {

        Exp = "";
    }

    if (parseFloat(Qty) < 0) {
        Qty = 1;
    }



    var Show_Unit = $("#Show_Unit").val();
    var Show_Barcode = $("#Show_Barcode").val();
    var Show_Total = $("#Show_Total").val();
    var Show_Net = $("#Show_Net").val();

    if (Show_Unit == 1) {

        var UNITSHOWW = "";

    } else {

        var UNITSHOWW = "none";
    }
    if (Show_Barcode == 1) {

        var BARCODESHOWW = "";

    } else {

        var BARCODESHOWW = "none";
    }


    if (Show_Total == 1) {

        var TOTALSHOWW = "";

    } else {

        var TOTALSHOWW = "none";
    }

    if (Show_Net == 1) {

        var NETSHOWW = "";

    } else {

        var NETSHOWW = "none";
    }
    var Net=(parseFloat(Total) ) - (parseFloat(Discount) * parseFloat(Qty));




    document.getElementById("AddBtnPur" + r).style.display = "none";
    document.getElementById("Row" + r).style.display = "none";

    var LANG = $("#LANG").val();
    if (LANG == 'ar') {
        var Nemo = P_Ar_Name;

    } else {
        var Nemo = P_En_Name;

    }

    var markup = "<tr><td>" + Nemo + " (" + Qty + ")</td><td style='display: "+UNITSHOWW+"'>" + UnitName + "</td><td><div class='row'>";

    for (i; i < Qty; i++) {
        markup += "<div class='col-md-12' style='display: "+BARCODESHOWW+"' ><input type='text' onkeyup='SERIAL(" + Qty + ")' onclick='SERIAL(" + Qty + "," + Product + ")' onkeypress='SERIAL(" + Qty + "," + Product + ")' id='SRCODE" + i + Product + "' id='BAR" + r + "' name='P_Code[]'  class='form-control inputs'><input type='hidden' name='P_Ar_Name[]' value='" + P_Ar_Name + "'><input type='hidden' name='P_En_Name[]' value='" + P_En_Name + "'><input type='hidden' name='Unit[]' value='" + UnitID + "'><input class='Qun' type='hidden' name='Qty[]' value='1'><input type='hidden' name='Price[]' value='" + Price + "'><input class='Disc' type='hidden' name='Discount[]' value='" + Discount + "'><input class='TotalBFTax' type='hidden' name='TotalBFTax[]' value='" + TotalBFTax + "'><input class='TotalTax' type='hidden' name='TotalTax[]' value='" + TotalTax + "'><input class='Tot' type='hidden' name='Total[]' value='" + Total + "'><input  type='hidden' name='StorePurch[]' value='" + StorePurch + "'><input type='hidden' name='Exp_Date[]' value='" + ExpDate + "'><input type='hidden' id='PRO" + r + "' name='Product[]' value='" + Product + "'><input type='hidden' name='VOne[]' value=''><input type='hidden' name='VTwo[]' value=''><input type='hidden' name='V_Name[]' value=''><input type='hidden' name='VV_Name[]' value=''><input type='hidden' name='PurchTax[]' value='" + PurchTax + "'><input type='hidden' name='Price_Sale[]' value='" + Price_Sale + "'><input type='hidden' class='TDISCOOO' id='TDiscProEdit" + r + "' name='TDiscPro[]' value='" + TDiscPro + "'><input type='hidden'  name='Total_Net[]' value='" + Net + "'><input type='hidden' id='Enough" + r + "' name='AllEnough[]' class='ENO'  value='0'></div>";
    }

    markup += "</div></td><td>1</td><td>" + Price + "</td><td style='display:" + DISCSHOWW + "'>" + Discount + "</td><td style='display:" + TOTBFSHOWW + "'>" + TotalBFTax + "</td><td style='display:" + TAXSHOWW + "'>" + TotalTax + "</td><td style='display: "+TOTALSHOWW+"'>" + Total + "</td><td style='display: "+NETSHOWW+"'><input class='form-control' type='number' step='any' id='NetD" + r + "' readonly  value='" + Net + "'></td><td style='display:" + STORESHOWW + "'>" + StorePurchName + "</td>" + Exp + "<td><button id='DelAssem' type='button' class='btn btn-default'><i class='fal fa-trash'></i></button></td></tr>";



    $("#data-dt").append(markup);

    var SHOWHIDEPRO = $("#SHOWHIDEPRO").val();

    if (parseFloat(SHOWHIDEPRO) == 0) {
        $("#Data").hide();
    }

    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

    var sumT = 0;
    $('.Tot').each(function () {
        sumT += parseFloat($(this).val());
    });

    var sumD = 0;
    $('.Disc').each(function () {
        sumD += parseFloat($(this).val());
    });


    var sumBF = 0;
    $('.TotalBFTax').each(function () {
        sumBF += parseFloat($(this).val());
    });

    var sumTax = 0;
    $('.TotalTax').each(function () {
        sumTax += parseFloat($(this).val());
    });


    var sumTTD = 0;
    $('.TDISCOOO').each(function () {
        sumTTD += parseFloat($(this).val());
    });
    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

    $('#Total_Price').val(parseFloat(sumT) + parseFloat(sumTTD) - parseFloat(sumTax));
    $('#Total_PriceHide').val(parseFloat(sumT) + parseFloat(sumTTD) - parseFloat(sumTax));
    $('#Total_PriceW').val(parseFloat(sumT));
    $('#Total_Bill').val(parseFloat(sumT));

    $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
    $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

    $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
    $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

    $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
    $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

    $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
    $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));



    if (rowctr == 0) {
        document.getElementById("Submit").style.display = "none";

    } else {

        document.getElementById("Submit").style.display = "block";
    }

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();

    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }



        }

    } else {

        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }
    }


    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();
    var resdiual = $('#resdiual').val();
    var total = $('#Total_PriceHide').val();
    var totalDisc = $('#Total_DiscountHideTT').val();

    var totalTax = $('#Total_TaxesHide').val();


    var RR = (parseFloat(total) + parseFloat(totalTax)) - (parseFloat(resdiual) + parseFloat(totalDisc));
    var RRR = parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
    $('#TAFterD').val(parseFloat(RRR).toFixed(2));
    $('#paid').val(parseFloat(RR).toFixed(2));


    var Pay = $('#Payment_Method').val();
    if (Pay == 'Later') {


        $('#paid').val('');

    }

    Statuss();
    $('#data-dt').on('click', '#DelAssem', function (e) {
        $(this).closest('tr').remove();

        $.fn.rowCount = function () {
            return $('tr', $(this).find('tbody')).length;
        };

        var rowctr = $('#dt').rowCount();

        var sumQ = 0;
        $('.Qun').each(function () {
            sumQ += parseFloat($(this).val());
        });

        var sumT = 0;
        $('.Tot').each(function () {
            sumT += parseFloat($(this).val());
        });

        var sumD = 0;
        $('.Disc').each(function () {
            sumD += parseFloat($(this).val());
        });


        var sumBF = 0;
        $('.TotalBFTax').each(function () {
            sumBF += parseFloat($(this).val());
        });

        var sumTax = 0;
        $('.TotalTax').each(function () {
            sumTax += parseFloat($(this).val());
        });


        var sumTTD = 0;
        $('.TDISCOOO').each(function () {
            sumTTD += parseFloat($(this).val());
        });
        $('#Product_Numbers').val(parseFloat(rowctr));
        $('#Product_NumbersHide').val(parseFloat(rowctr));

        $('#Total_Qty').val(parseFloat(sumQ));
        $('#Total_QtyHide').val(parseFloat(sumQ));

        $('#Total_Price').val(parseFloat(sumT) + parseFloat(sumTTD) - parseFloat(sumTax));
        $('#Total_PriceHide').val(parseFloat(sumT) + parseFloat(sumTTD) - parseFloat(sumTax));
        $('#Total_PriceW').val(parseFloat(sumT));
        $('#Total_Bill').val(parseFloat(sumT));

        $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
        $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

        $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
        $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

        $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
        $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

        $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
        $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));



        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }

        var Pay = $('#Payment_Method').val();
        var Stat = $('#Status').val();
        var paid = $('#paid').val();

        if (Pay == 'Later' && Stat == 0) {

            if (paid <= 0) {
                document.getElementById("Submit").style.display = "none";
            } else {

                if (rowctr == 0) {
                    document.getElementById("Submit").style.display = "none";

                } else {

                    document.getElementById("Submit").style.display = "block";
                }



            }

        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }
        }


        var Pay = $('#Payment_Method').val();
        var Stat = $('#Status').val();
        var paid = $('#paid').val();
        var resdiual = $('#resdiual').val();
        var total = $('#Total_PriceHide').val();
        var totalDisc = $('#Total_DiscountHideTT').val();

        var totalTax = $('#Total_TaxesHide').val();


        var RR = (parseFloat(total) + parseFloat(totalTax)) - (parseFloat(resdiual) + parseFloat(totalDisc));
        var RRR = parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
        $('#TAFterD').val(parseFloat(RRR).toFixed(2));
        $('#paid').val(parseFloat(RR).toFixed(2));


        var Pay = $('#Payment_Method').val();
        if (Pay == 'Later') {


            $('#paid').val('');

        }


        var EN = 0;
        var Total_PriceW = $('#Total_PriceW').val();

        $('.ENO').each(function () {
            EN += parseFloat($(this).val());
        });
        if (EN == 0) {

            if (Total_PriceW == 'NaN') {
                document.getElementById("Submit").style.display = "none";
            } else {
                document.getElementById("Submit").style.display = "block";
            }

        } else {

            document.getElementById("Submit").style.display = "none";
        }
        Statuss();

    })


}
//
//Total Products -->
//

function PurchTotal(r) {
    var TaxRate = $("#TaxRate" + r).val();
    var TaxType = $("#TaxType" + r).val();
    var Qty = $("#Qty" + r).val();
    var Price = $("#Price" + r).val();
    var Discount = $("#Discount" + r).val();
    var i = 0;
    var ii = 0;
    var iii = 0;



    var DIS = $("#DIS").val();

    if (parseFloat(DIS) == 0) {

        Discount = $("#Discount" + r).val();

    } else {

        var d = Discount / 100;
        var Multi = parseFloat(Price);
        var dd = Multi * d;

        Discount = dd;

    }
    var BFG = parseFloat(Qty) * parseFloat(Discount);
    $("#TDiscPro" + r).val(parseFloat(BFG));
    if (TaxType == 1) {
        //Precent

        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));

        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate) / 100;

        ii = parseFloat(BFF) * parseFloat(i);

        $("#Tax" + r).val(parseFloat(ii).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(ii);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));

    } else if (TaxType == 2) {
        //Number
        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate);

        $("#Tax" + r).val(parseFloat(i).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(i);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));


    }


    var Total = $("#Total" + r).val();
    var TotalBFTax = $("#TotalBFTax" + r).val();
    var Tax = $("#Tax" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var StorePurch = $("#StorePurch" + r).val();

    if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if (TaxRate != '' && TaxType != '' && Qty != '' && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

        if (Qty < 0 || Price < 0 || Discount < 0 || Total < 0) {
            document.getElementById("AddBtnPur" + r).style.display = "none";

        } else {
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
        }
    }





}

function TotD(r) {
    var TaxRate = $("#TaxRateD" + r).val();
    var TaxType = $("#TaxTypeD" + r).val();
    var Qty = $("#QuntD" + r).val();
    var Price = $("#PriD" + r).val();
    var Discount = $("#DiscD" + r).val();
    var i = 0;
    var ii = 0;
    var iii = 0;

    var DIS = $("#DIS").val();

    if (parseFloat(DIS) == 0) {

        Discount = $("#DiscD" + r).val();
        var BFG = parseFloat(Qty) * parseFloat(Discount);
        $("#TDiscProEdit" + r).val(parseFloat(BFG));
    } else {

        var d = Discount / 100;
        var Multi = parseFloat(Price);
        var dd = Multi * d;

        Discount = dd;
        var BFG = parseFloat(Qty) * parseFloat(Discount);
        $("#TDiscProEdit" + r).val(parseFloat(BFG));
    }

    if (TaxType == 1) {
        //Precent

        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotBFTaxD" + r).val(parseFloat(BFF).toFixed(2));
        $("#TotBFTaxDHide" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate) / 100;

        ii = parseFloat(BFF) * parseFloat(i);

        $("#TaxD" + r).val(parseFloat(ii).toFixed(2));
        $("#TaxDHide" + r).val(parseFloat(ii).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(ii);

        $("#TotD" + r).val(parseFloat(iii).toFixed(2));
        $("#TotDHide" + r).val(parseFloat(iii).toFixed(2));

    } else if (TaxType == 2) {
        //Number
        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);
        $("#TotBFTaxD" + r).val(parseFloat(BFF).toFixed(2));
        $("#TotBFTaxDHide" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate);

        $("#TaxD" + r).val(parseFloat(i).toFixed(2));
        $("#TaxDHide" + r).val(parseFloat(i).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(i);

        $("#TotD" + r).val(parseFloat(iii).toFixed(2));
        $("#TotDHide" + r).val(parseFloat(iii).toFixed(2));


    }


    var Total =$("#TotD" + r).val();
    var TotalTax =$("#TaxD" + r).val();
    var Net=(parseFloat(Total) ) - (parseFloat(Discount) * parseFloat(Qty));
    $("#NetD" + r).val(parseFloat(Net).toFixed(2));



    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

    var sumT = 0;
    $('.Tot').each(function () {
        sumT += parseFloat($(this).val());
    });

    var sumD = 0;
    $('.Disc').each(function () {
        sumD += parseFloat($(this).val());
    });


    var sumBF = 0;
    $('.TotalBFTax').each(function () {
        sumBF += parseFloat($(this).val());
    });

    var sumTax = 0;
    $('.TotalTax').each(function () {
        sumTax += parseFloat($(this).val());
    });


    var sumTTD = 0;
    $('.TDISCOOO').each(function () {
        sumTTD += parseFloat($(this).val());
    });

    var resdiual=$('#resdiual').val();

    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

    $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
    $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



    $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
    $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

    $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
    $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

    $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
    $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

    $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
    $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


    $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
    var RR = ($after_tax - parseFloat(sumTTD));
    $('#Total_After_Taxes').val($after_tax);
    $('#TAFterD').val(parseFloat(RR).toFixed(2));
    $('#paid').val(parseFloat(RR).toFixed(2));

    $('#Total_Bill').val(parseFloat(RR).toFixed(2));
    $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



    if (rowctr == 0) {
        document.getElementById("Submit").style.display = "none";

    } else {

        document.getElementById("Submit").style.display = "block";
    }

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();

    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }



        }

    } else {

        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }
    }

    if (Pay == 'Later') {


        $('#paid').val('');

    }



    if (parseFloat(Qty) < 0 || parseFloat(Price) < 0 || parseFloat(Discount) < 0) {
        document.getElementById("QuntD" + r).style.border = "1px solid darkred";
        $("#Enough" + r).val(1);

    } else {
        document.getElementById("QuntD" + r).style.border = "none";
        $("#Enough" + r).val(0);
    }

    $('.ENO').each(function () {
        EN += parseFloat($(this).val());
    });
    if (EN == 0) {

        if (Total_PriceW == 'NaN') {
            document.getElementById("Submit").style.display = "none";
        } else {
            document.getElementById("Submit").style.display = "block";
        }

    } else {

        document.getElementById("Submit").style.display = "none";
    }


    var paid = $('#paid').val();

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {


            document.getElementById("Submit").style.display = "block";

        }
    }



    Statuss();
}

//
//Total Products Serial -->
//
function PurchTotalSerial(r) {
    var TaxRate = $("#TaxRate" + r).val();
    var TaxType = $("#TaxType" + r).val();
    var Qty = 1;
    var Price = $("#Price" + r).val();
    var Discount = $("#Discount" + r).val();
    var i = 0;
    var ii = 0;
    var iii = 0;

    var DIS = $("#DIS").val();

    if (parseFloat(DIS) == 0) {

        Discount = $("#Discount" + r).val();

    } else {

        var d = Discount / 100;
        var Multi = parseFloat(Price);
        var dd = Multi * d;

        Discount = dd;

    }
    var BFG = parseFloat(Qty) * parseFloat(Discount);
    $("#TDiscPro" + r).val(parseFloat(BFG));

    if (TaxType == 1) {
        //Precent

        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate) / 100;

        ii = parseFloat(BFF) * parseFloat(i);

        $("#Tax" + r).val(parseFloat(ii).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(ii);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));

    } else if (TaxType == 2) {
        //Number
        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);
        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate);

        $("#Tax" + r).val(parseFloat(i).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(i);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));


    }


    var Total = $("#Total" + r).val();
    var TotalBFTax = $("#TotalBFTax" + r).val();
    var Tax = $("#Tax" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var StorePurch = $("#StorePurch" + r).val();

    if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if (TaxRate != '' && TaxType != '' && Qty != '' && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

        if (Qty < 0 || Price < 0 || Discount < 0 || Total < 0) {
            document.getElementById("AddBtnPur" + r).style.display = "none";

        } else {
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
        }
    }





}
//
//Total Products V -->
//
function PurchTotalV(r) {
    var TaxRate = $("#TaxRate" + r).val();
    var TaxType = $("#TaxType" + r).val();
    var Qty = $("#Qty" + r).val();
    var Price = $("#Price" + r).val();
    var Discount = $("#Discount" + r).val();
    var i = 0;
    var ii = 0;
    var iii = 0;

    var DIS = $("#DIS").val();

    if (parseFloat(DIS) == 0) {

        Discount = $("#Discount" + r).val();

    } else {

        var d = Discount / 100;
        var Multi = parseFloat(Price);
        var dd = Multi * d;

        Discount = dd;

    }
    var BFG = parseFloat(Qty) * parseFloat(Discount);
    $("#TDiscPro" + r).val(parseFloat(BFG));
    if (TaxType == 1) {
        //Precent

        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate) / 100;

        ii = parseFloat(BFF) * parseFloat(i);

        $("#Tax" + r).val(parseFloat(ii).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(ii);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));

    } else if (TaxType == 2) {
        //Number
        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);
        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate);

        $("#Tax" + r).val(parseFloat(i).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(i);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));


    }


    var Total = $("#Total" + r).val();
    var TotalBFTax = $("#TotalBFTax" + r).val();
    var Tax = $("#Tax" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var StorePurch = $("#StorePurch" + r).val();

    if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if (TaxRate != '' && TaxType != '' && Qty != '' && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

        if (Qty < 0 || Price < 0 || Discount < 0 || Total < 0) {
            document.getElementById("AddBtnPur" + r).style.display = "none";

        } else {
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
        }
    }





}

function TotV(r) {
    var TaxRate = $("#RateV" + r).val();
    var TaxType = $("#TypeV" + r).val();
    var Qty = $("#QuntityV" + r).val();
    var Price = $("#PriceV" + r).val();
    var Discount = $("#DiscountV" + r).val();
    var i = 0;
    var ii = 0;
    var iii = 0;

    var DIS = $("#DIS").val();

    if (parseFloat(DIS) == 0) {

        Discount = $("#DiscountV" + r).val();
        var BFG = parseFloat(Qty) * parseFloat(Discount);
        $("#TDiscProEdit" + r).val(parseFloat(BFG));
    } else {

        var d = Discount / 100;
        var Multi = parseFloat(Price);
        var dd = Multi * d;

        Discount = dd;
        var BFG = parseFloat(Qty) * parseFloat(Discount);
        $("#TDiscProEdit" + r).val(parseFloat(BFG));
    }
    if (TaxType == 1) {
        //Precent

        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotalBFV" + r).val(parseFloat(BFF).toFixed(2));
        $("#TotalBFVHide" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate) / 100;

        ii = parseFloat(BFF) * parseFloat(i);

        $("#TotalTax" + r).val(parseFloat(ii).toFixed(2));
        $("#TotalTaxHide" + r).val(parseFloat(ii).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(ii);

        $("#TotalV" + r).val(parseFloat(iii).toFixed(2));
        $("#TotalVHide" + r).val(parseFloat(iii).toFixed(2));

    } else if (TaxType == 2) {
        //Number
        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);
        $("#TotalBFV" + r).val(parseFloat(BFF).toFixed(2));
        $("#TotalBFVHide" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate);

        $("#TotalTax" + r).val(parseFloat(i).toFixed(2));
        $("#TotalTaxHide" + r).val(parseFloat(i).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(i);

        $("#TotalV" + r).val(parseFloat(iii).toFixed(2));
        $("#TotalVHide" + r).val(parseFloat(iii).toFixed(2));


    }


    var Total =$("#TotV" + r).val();
    var TotalTax =$("#TotalTax" + r).val();
    var Net=(parseFloat(Total) ) - (parseFloat(Discount) * parseFloat(Qty));
    $("#NetV" + r).val(parseFloat(Net).toFixed(2));


    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

    var sumT = 0;
    $('.Tot').each(function () {
        sumT += parseFloat($(this).val());
    });

    var sumD = 0;
    $('.Disc').each(function () {
        sumD += parseFloat($(this).val());
    });


    var sumBF = 0;
    $('.TotalBFTax').each(function () {
        sumBF += parseFloat($(this).val());
    });

    var sumTax = 0;
    $('.TotalTax').each(function () {
        sumTax += parseFloat($(this).val());
    });


    var sumTTD = 0;
    $('.TDISCOOO').each(function () {
        sumTTD += parseFloat($(this).val());
    });
    var resdiual=$('#resdiual').val();

    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

    $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
    $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



    $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
    $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

    $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
    $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

    $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
    $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

    $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
    $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


    $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
    var RR = ($after_tax - parseFloat(sumTTD));
    $('#Total_After_Taxes').val($after_tax);
    $('#TAFterD').val(parseFloat(RR).toFixed(2));
    $('#paid').val(parseFloat(RR).toFixed(2));

    $('#Total_Bill').val(parseFloat(RR).toFixed(2));
    $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



    if (rowctr == 0) {
        document.getElementById("Submit").style.display = "none";

    } else {

        document.getElementById("Submit").style.display = "block";
    }

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();

    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }



        }

    } else {

        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }
    }

    if (Pay == 'Later') {


        $('#paid').val('');

    }

    var EN = 0;
    var Total_PriceW = $('#Total_PriceW').val();
    if (parseFloat(Qty) < 0 || parseFloat(Price) < 0 || parseFloat(Discount) < 0) {
        document.getElementById("QuntityV" + r).style.border = "1px solid darkred";
        $("#Enough" + r).val(1);

    } else {
        document.getElementById("QuntityV" + r).style.border = "none";
        $("#Enough" + r).val(0);
    }


    $('.ENO').each(function () {
        EN += parseFloat($(this).val());
    });
    if (EN == 0) {

        if (Total_PriceW == 'NaN') {
            document.getElementById("Submit").style.display = "none";
        } else {
            document.getElementById("Submit").style.display = "block";
        }

    } else {

        document.getElementById("Submit").style.display = "none";
    }


    var paid = $('#paid').val();

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {


            document.getElementById("Submit").style.display = "block";

        }
    }

    Statuss();
}


//
//Total Products VV -->
//
function PurchTotalVV(r) {
    var TaxRate = $("#TaxRate" + r).val();
    var TaxType = $("#TaxType" + r).val();
    var Qty = $("#Qty" + r).val();
    var Price = $("#Price" + r).val();
    var Discount = $("#Discount" + r).val();
    var i = 0;
    var ii = 0;
    var iii = 0;

    var DIS = $("#DIS").val();

    if (parseFloat(DIS) == 0) {

        Discount = $("#Discount" + r).val();

    } else {

        var d = Discount / 100;
        var Multi = parseFloat(Price);
        var dd = Multi * d;

        Discount = dd;

    }
    var BFG = parseFloat(Qty) * parseFloat(Discount);
    $("#TDiscPro" + r).val(parseFloat(BFG));
    if (TaxType == 1) {
        //Precent

        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate) / 100;

        ii = parseFloat(BFF) * parseFloat(i);

        $("#Tax" + r).val(parseFloat(ii).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(ii);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));

    } else if (TaxType == 2) {
        //Number
        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);
        $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate);

        $("#Tax" + r).val(parseFloat(i).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(i);

        $("#Total" + r).val(parseFloat(iii).toFixed(2));


    }


    var Total = $("#Total" + r).val();
    var TotalBFTax = $("#TotalBFTax" + r).val();
    var Tax = $("#Tax" + r).val();
    var UnitID = $("#UnitPurch" + r).val();
    var StorePurch = $("#StorePurch" + r).val();

    if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

        document.getElementById("AddBtnPur" + r).style.display = "none";
    }


    if (TaxRate != '' && TaxType != '' && Qty != '' && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

        if (Qty < 0 || Price < 0 || Discount < 0 || Total < 0) {
            document.getElementById("AddBtnPur" + r).style.display = "none";

        } else {
            document.getElementById("AddBtnPur" + r).style.display = "inline-block";
        }
    }





}

function TotVV(r) {
    var TaxRate = $("#RateVV" + r).val();
    var TaxType = $("#TypeVV" + r).val();
    var Qty = $("#QuntityVV" + r).val();
    var Price = $("#PriceVV" + r).val();
    var Discount = $("#DiscountVV" + r).val();
    var i = 0;
    var ii = 0;
    var iii = 0;
    var DIS = $("#DIS").val();

    if (parseFloat(DIS) == 0) {

        Discount = $("#DiscountVV" + r).val();
        var BFG = parseFloat(Qty) * parseFloat(Discount);
        $("#TDiscProEdit" + r).val(parseFloat(BFG));
    } else {

        var d = Discount / 100;
        var Multi = parseFloat(Price);
        var dd = Multi * d;

        Discount = dd;
        var BFG = parseFloat(Qty) * parseFloat(Discount);
        $("#TDiscProEdit" + r).val(parseFloat(BFG));
    }

    if (TaxType == 1) {
        //Precent

        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);

        $("#TotalBFVV" + r).val(parseFloat(BFF).toFixed(2));
        $("#TotalBFVVHide" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate) / 100;

        ii = parseFloat(BFF) * parseFloat(i);

        $("#TotalTaxVV" + r).val(parseFloat(ii).toFixed(2));
        $("#TotalTaxVVHide" + r).val(parseFloat(ii).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(ii);

        $("#TotalVV" + r).val(parseFloat(iii).toFixed(2));
        $("#TotalVVHide" + r).val(parseFloat(iii).toFixed(2));

    } else if (TaxType == 2) {
        //Number
        var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
        var BFF = parseFloat(Qty) * parseFloat(Price);
        $("#TotalBFVV" + r).val(parseFloat(BFF).toFixed(2));
        $("#TotalBFVVHide" + r).val(parseFloat(BFF).toFixed(2));

        i = parseFloat(TaxRate);

        $("#TotalTaxVV" + r).val(parseFloat(i).toFixed(2));
        $("#TotalTaxVVHide" + r).val(parseFloat(i).toFixed(2));

        iii = parseFloat(BFF) + parseFloat(i);

        $("#TotalVV" + r).val(parseFloat(iii).toFixed(2));
        $("#TotalVVHide" + r).val(parseFloat(iii).toFixed(2));


    }

    var Total =$("#TotalVV" + r).val();
    var TotalTax =$("#TotalTaxVV" + r).val();
    var Net=(parseFloat(Total) ) - (parseFloat(Discount) * parseFloat(Qty));
    $("#NetVV" + r).val(parseFloat(Net).toFixed(2));


    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();

    var sumQ = 0;
    $('.Qun').each(function () {
        sumQ += parseFloat($(this).val());
    });

    var sumT = 0;
    $('.Tot').each(function () {
        sumT += parseFloat($(this).val());
    });

    var sumD = 0;
    $('.Disc').each(function () {
        sumD += parseFloat($(this).val());
    });


    var sumBF = 0;
    $('.TotalBFTax').each(function () {
        sumBF += parseFloat($(this).val());
    });

    var sumTax = 0;
    $('.TotalTax').each(function () {
        sumTax += parseFloat($(this).val());
    });


    var sumTTD = 0;
    $('.TDISCOOO').each(function () {
        sumTTD += parseFloat($(this).val());
    });
    var resdiual=$('#resdiual').val();

    $('#Product_Numbers').val(parseFloat(rowctr));
    $('#Product_NumbersHide').val(parseFloat(rowctr));

    $('#Total_Qty').val(parseFloat(sumQ));
    $('#Total_QtyHide').val(parseFloat(sumQ));

    $('#Total_Price').val(parseFloat(sumT)  - parseFloat(sumTax));
    $('#Total_PriceHide').val(parseFloat(sumT)  - parseFloat(sumTax));



    $('#Total_DiscountTT').val(parseFloat(sumTTD).toFixed(2));
    $('#Total_DiscountHideTT').val(parseFloat(sumTTD).toFixed(2));

    $('#Total_Discount').val(parseFloat(sumD).toFixed(2));
    $('#Total_DiscountHide').val(parseFloat(sumD).toFixed(2));

    $('#Total_Bf_Taxes').val(parseFloat(sumBF) + parseFloat(sumTTD));
    $('#Total_Bf_TaxesHide').val(parseFloat(sumBF) + parseFloat(sumTTD));

    $('#Total_Taxes').val(parseFloat(sumTax).toFixed(2));
    $('#Total_TaxesHide').val(parseFloat(sumTax).toFixed(2));


    $after_tax=(parseFloat(sumT)  - parseFloat(sumTax)) + parseFloat(sumTax)
    var RR = ($after_tax - parseFloat(sumTTD));
    $('#Total_After_Taxes').val($after_tax);
    $('#TAFterD').val(parseFloat(RR).toFixed(2));
    $('#paid').val(parseFloat(RR).toFixed(2));

    $('#Total_Bill').val(parseFloat(RR).toFixed(2));
    $('#Total_PriceW').val(parseFloat(RR) -  parseFloat(resdiual));



    if (rowctr == 0) {
        document.getElementById("Submit").style.display = "none";

    } else {

        document.getElementById("Submit").style.display = "block";
    }

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();

    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {

                document.getElementById("Submit").style.display = "block";
            }



        }

    } else {

        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            document.getElementById("Submit").style.display = "block";
        }
    }

    if (Pay == 'Later') {


        $('#paid').val('');

    }


    var Total_PriceW = $('#Total_PriceW').val();
    if (parseFloat(Qty) < 0 || parseFloat(Price) < 0 || parseFloat(Discount) < 0) {
        document.getElementById("QuntityVV" + r).style.border = "1px solid darkred";
        $("#Enough" + r).val(1);

    } else {
        document.getElementById("QuntityVV" + r).style.border = "none";
        $("#Enough" + r).val(0);
    }


    $('.ENO').each(function () {
        EN += parseFloat($(this).val());
    });
    if (EN == 0) {

        if (Total_PriceW == 'NaN') {
            document.getElementById("Submit").style.display = "none";
        } else {
            document.getElementById("Submit").style.display = "block";
        }

    } else {

        document.getElementById("Submit").style.display = "none";
    }


    var paid = $('#paid').val();

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {


            document.getElementById("Submit").style.display = "block";

        }
    }

    Statuss();
}
//
//Enter Next Input -->
//
$(function () {
    $(document).on('keyup', '.inputs', function (e) {
        if (e.which == 13) {
            var $this = $(this);
            var $td = $this.closest('.col-md-12'); // Current TD
            var $row = $td.closest('.row'); // Current TR
            var $rows = $row.parent(); // Current TABLE or TBODY - parent of all rows
            var column = $td.index(); // Current column of TD

            // Search on a row basis in current column, then try next column
            // repeat until we run out of cells
            while ($td.length) {
                // get next row
                $row = $row.next('.row');
                // If we were on last row
                if ($row.length == 0) {
                    // Go back to first row
                    $row = $rows.children().first();
                    // And use next column
                    column++;
                }
                // get the position in the row column - if it exists
                $td = $row.children().eq(column);
                var $input = $td.find('.inputs');
                if ($input.length) {
                    $input.focus();
                    break;
                }
            }
        }
    });
});
//
//Scanner  problem -->
//
$(".form-control").keypress(function (event) {
    if (event.which == '10' || event.which == '13') {
        event.preventDefault();
    }
});


//
//Status -->
//
function Statuss() {

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();
    var total = $('#Total_PriceHide').val();
    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();



    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {


                if (paid != 0 || paid == '') {

                    document.getElementById("Submit").style.display = "block";
                } else {

                    document.getElementById("Submit").style.display = "none";
                }


            }



        }

    } else {

        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            if (paid != 0 || paid == '') {

                document.getElementById("Submit").style.display = "block";
            } else {

                document.getElementById("Submit").style.display = "none";
            }

        }
    }


    if (Pay == 'Check') {

        document.getElementById("CHECK").style.display = "block";

    } else {

        document.getElementById("CHECK").style.display = "none";
    }

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();
    var resdiual = $('#resdiual').val();
    var total = $('#Total_PriceHide').val();
    var totalDisc = $('#Total_DiscountHideTT').val();
    var totalTax = $('#Total_TaxesHide').val();


    var RR = (parseFloat(total) + parseFloat(totalTax)) - (parseFloat(resdiual) + parseFloat(totalDisc));
    var RRR = parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
    $('#TAFterD').val(parseFloat(RRR).toFixed(2));
    $('#paid').val(parseFloat(RR));
    $('#Total_PriceW').val(parseFloat(RR));

    if (Pay == 'Later') {

        document.getElementById("LaterDate").style.display = "block";
        $('#paid').val('');

    } else {

        document.getElementById("LaterDate").style.display = "none";
    }



}


$(document).ready(function () {
    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();
    var total = $('#Total_PriceHide').val();


    $.fn.rowCount = function () {
        return $('tr', $(this).find('tbody')).length;
    };

    var rowctr = $('#dt').rowCount();



    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {

            if (rowctr == 0) {
                document.getElementById("Submit").style.display = "none";

            } else {


                if (paid != 0 || paid == '') {

                    document.getElementById("Submit").style.display = "block";
                } else {

                    document.getElementById("Submit").style.display = "none";
                }


            }



        }

    } else {

        if (rowctr == 0) {
            document.getElementById("Submit").style.display = "none";

        } else {

            if (paid != 0 || paid == '') {

                document.getElementById("Submit").style.display = "block";
            } else {

                document.getElementById("Submit").style.display = "none";
            }

        }
    }






    if (Pay == 'Check') {

        document.getElementById("CHECK").style.display = "block";

    } else {

        document.getElementById("CHECK").style.display = "none";
    }

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    var paid = $('#paid').val();
    var resdiual = $('#resdiual').val();
    var total = $('#Total_PriceHide').val();
    var totalDisc = $('#Total_DiscountHideTT').val();
    var totalTax = $('#Total_TaxesHide').val();

    var RR = (parseFloat(total) + parseFloat(totalTax)) - (parseFloat(resdiual) + parseFloat(totalDisc));
    var RRR = parseFloat(total) - (parseFloat(resdiual) + parseFloat(totalDisc));
    $('#TAFterD').val(parseFloat(RRR).toFixed(2));
    $('#paid').val(parseFloat(RR));
    $('#Total_PriceW').val(parseFloat(RR));

    if (Pay == 'Later') {

        document.getElementById("LaterDate").style.display = "block";

    } else {

        document.getElementById("LaterDate").style.display = "none";
    }


});
//
//Submit Script -->
//
function SPP() {
    $('#sp').val(1);
    var x = $('#sp').val();

    var store = $('#store').val();
    var SSAFE = $('#SSAFE').val();
    var vendor = $('#vendor').val();
    var LANG = $('#LANG').val();

    var Pay = $('#Payment_Method').val();
    var paid = $('#paid').val();

    var SafeBalance = $('#SafeBalance').val();
    var Amount = $('#Total_PriceW').val();

    var Check_Type = $('#Check_Type').val();
    var Due_Date = $('#Due_Date').val();
    var Check_Number = $('#Check_Number').val();

    if (Pay == 'Check') {

        if (Check_Type != '' && Due_Date != '' && Check_Number != '') {


    if (Pay == 'Later') {

        if (parseFloat(paid) > parseFloat(SafeBalance)) {


            if (LANG == 'ar') {
                alert('المبلغ غير كافي في الخزينه');
            } else {
                alert('Not Enough Money in Safe');
            }


        } else {

            if (store != '' && SSAFE != '' && vendor != null) {
                if (x == 1) {
                    document.getElementById("Submit").style.display = "none";
                    document.getElementById('form').submit();
                }
            } else {



                if (LANG == 'ar') {
                    alert('تأكد من اختيار مخزن و خزنه وحساب');
                } else {
                    alert('Must Choice Safe , Store and Account');
                }

            }


        }
    } else {
        if (parseFloat(Amount) > parseFloat(SafeBalance)) {
            if (LANG == 'ar') {
                alert('المبلغ غير كافي في الخزينه');
            } else {
                alert('Not Enough Money in Safe');
            }
        } else {

            if (store != '' && SSAFE != '' && vendor != null) {
                if (x == 1) {
                    document.getElementById("Submit").style.display = "none";
                    document.getElementById('form').submit();
                }
            } else {

                if (LANG == 'ar') {
                    alert('تأكد من اختيار مخزن و خزنه وحساب');
                } else {
                    alert('Must Choice Safe , Store and Account');
                }

            }


        }
    }


        }else{

            if (LANG == 'ar') {
                alert('تأكد من جميع بيانات الشيك المطلوبة');
            } else {
                alert('be Sure to Choice All Check Required Data');
            }

        }

    }else{



        if (Pay == 'Later') {

            if (parseFloat(paid) > parseFloat(SafeBalance)) {


                if (LANG == 'ar') {
                    alert('المبلغ غير كافي في الخزينه');
                } else {
                    alert('Not Enough Money in Safe');
                }


            } else {

                if (store != '' && SSAFE != '' && vendor != null) {
                    if (x == 1) {
                        document.getElementById("Submit").style.display = "none";
                        document.getElementById('form').submit();
                    }
                } else {



                    if (LANG == 'ar') {
                        alert('تأكد من اختيار مخزن و خزنه وحساب');
                    } else {
                        alert('Must Choice Safe , Store and Account');
                    }

                }


            }
        } else {
            if (parseFloat(Amount) > parseFloat(SafeBalance)) {
                if (LANG == 'ar') {
                    alert('المبلغ غير كافي في الخزينه');
                } else {
                    alert('Not Enough Money in Safe');
                }
            } else {

                if (store != '' && SSAFE != '' && vendor != null) {
                    if (x == 1) {
                        document.getElementById("Submit").style.display = "none";
                        document.getElementById('form').submit();
                    }
                } else {

                    if (LANG == 'ar') {
                        alert('تأكد من اختيار مخزن و خزنه وحساب');
                    } else {
                        alert('Must Choice Safe , Store and Account');
                    }

                }


            }
        }






    }





}


function SPS() {
    $('#sp').val(0);
    var x = $('#sp').val();
    var LANG = $('#LANG').val();
    var paid = $('#paid').val();

    var Pay = $('#Payment_Method').val();

    var store = $('#store').val();
    var SSAFE = $('#SSAFE').val();
    var vendor = $('#vendor').val();

    var SafeBalance = $('#SafeBalance').val();
    var Amount = $('#Total_PriceW').val();


    var Check_Type = $('#Check_Type').val();
    var Due_Date = $('#Due_Date').val();
    var Check_Number = $('#Check_Number').val();

    if (Pay == 'Check') {

        if (Check_Type != '' && Due_Date != '' && Check_Number != '') {




            if (Pay == 'Later') {
        if (parseFloat(paid) > parseFloat(SafeBalance)) {
            if (LANG == 'ar') {
                alert('المبلغ غير كافي في الخزينه');
            } else {
                alert('Not Enough Money in Safe');
            }
        } else {
            if (store != '' && SSAFE != '' && vendor != null) {
                if (x == 0) {
                    document.getElementById("Submit").style.display = "none";
                    document.getElementById('form').submit();
                }
            } else {

                if (LANG == 'ar') {
                    alert('تأكد من اختيار مخزن و خزنه وحساب');
                } else {
                    alert('Must Choice Safe , Store and Account');
                }

            }

        }
    } else {
        if (parseFloat(Amount) > parseFloat(SafeBalance)) {
            if (LANG == 'ar') {
                alert('المبلغ غير كافي في الخزينه');
            } else {
                alert('Not Enough Money in Safe');
            }
        } else {
            if (store != '' && SSAFE != '' && vendor != null) {
                if (x == 0) {
                    document.getElementById("Submit").style.display = "none";
                    document.getElementById('form').submit();
                }
            } else {

                if (LANG == 'ar') {
                    alert('تأكد من اختيار مخزن و خزنه وحساب');
                } else {
                    alert('Must Choice Safe , Store and Account');
                }

            }

        }
    }



}else{

    if (LANG == 'ar') {
        alert('تأكد من جميع بيانات الشيك المطلوبة');
    } else {
        alert('be Sure to Choice All Check Required Data');
    }

}

}else{


        if (Pay == 'Later') {
            if (parseFloat(paid) > parseFloat(SafeBalance)) {
                if (LANG == 'ar') {
                    alert('المبلغ غير كافي في الخزينه');
                } else {
                    alert('Not Enough Money in Safe');
                }
            } else {
                if (store != '' && SSAFE != '' && vendor != null) {
                    if (x == 0) {
                        document.getElementById("Submit").style.display = "none";
                        document.getElementById('form').submit();
                    }
                } else {

                    if (LANG == 'ar') {
                        alert('تأكد من اختيار مخزن و خزنه وحساب');
                    } else {
                        alert('Must Choice Safe , Store and Account');
                    }

                }

            }
        } else {
            if (parseFloat(Amount) > parseFloat(SafeBalance)) {
                if (LANG == 'ar') {
                    alert('المبلغ غير كافي في الخزينه');
                } else {
                    alert('Not Enough Money in Safe');
                }
            } else {
                if (store != '' && SSAFE != '' && vendor != null) {
                    if (x == 0) {
                        document.getElementById("Submit").style.display = "none";
                        document.getElementById('form').submit();
                    }
                } else {

                    if (LANG == 'ar') {
                        alert('تأكد من اختيار مخزن و خزنه وحساب');
                    } else {
                        alert('Must Choice Safe , Store and Account');
                    }

                }

            }
        }





    }



}



//
//Change Price Unit -->
//
function ChangePriceUnit(r) {

    var POne = $('#UnitPriceOne' + r).val();
    var PTwo = $('#UnitPriceTwo' + r).val();
    var PThree = $('#UnitPriceThree' + r).val();
    var ID = $('#UnitPriceID' + r).val();

    if (PTwo == '') {

        PTwo = 0;
    } else {

        PTwo = $('#UnitPriceTwo' + r).val();
    }

    if (PThree == '') {

        PThree = 0;
    } else {

        PThree = $('#UnitPriceThree' + r).val();
    }

    if (POne) {
        $.ajax({
            url: 'ChangePriceUnit',
            type: "GET",
            data: {
                POne: POne,
                PTwo: PTwo,
                PThree: PThree,
                ID: ID
            },
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    var LANG = $('#LANG').val();
                    if (LANG == 'ar') {
                        alert('تم التحديث بنجاح');
                    } else {
                        alert('Updated Successfully');
                    }



                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {


        if (LANG == 'ar') {
            alert('حقل السعر الاول مطلوب');
        } else {
            alert('Price Input Required');
        }


    }



}
//
//Add New Product -->
//
function NewProducts() {


    var Name = $('#P_Ar_Name').val();
    var EnName = $('#P_En_Name').val();
    var P_Type = $('#P_Type').val();
    var Brand = $('#Brand').val();
    var Group = $('#Group').val();
    var unit = $('#unit').val();
    var Rate = $('#Rate').val();
    var Barcode = $('#Barcode').val();
    var Price = $('#Price').val();
    var Price_Two = $('#Price_Two').val();
    var Price_Three = $('#Price_Three').val();

    if (Name) {
        $.ajax({
            url: 'AddNewProduct',
            type: "GET",
            data: {
                Name: Name,
                EnName: EnName,
                P_Type: P_Type,
                Brand: Brand,
                Group: Group,
                unit: unit,
                Rate: Rate,
                Barcode: Barcode,
                Price: Price,
                Price_Two: Price_Two,
                Price_Three: Price_Three
            },
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    var LANG = $('#LANG').val();
                    if (LANG == 'ar') {
                        alert('تم الاضافه بنجاح');
                    } else {
                        alert('Added Successfully');
                    }

                    $('#P_Ar_Name').val('');
                    $('#P_En_Name').val('');
                    $('#Rate').val(1);
                    $('#Barcode').val('');
                    $('#Price').val(0);
                    $('#Price_Two').val(0);
                    $('#Price_Three').val(0);


                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        var LANG = $('#LANG').val();
        if (LANG == 'ar') {
            alert('حقل الاسم مطلوب');
        } else {
            alert('Name Input is Required');
        }



    }



}
//
//Add New Vendor -->
//
function NewVendor() {

    var co = $('#CODE').val();
    var Name = $('#Name').val();
    var NameEn = $('#NameEn').val();
    var PriceLevel = $('#PriceLevel').val();
    var LANG = $('#LANG').val();

    if (NameEn == '') {

        NameEn = Name;
    }

    if (Name) {
        $.ajax({
            url: 'AddNewVendor',
            type: "GET",
            data: {
                co: co,
                Name: Name,
                PriceLevel: PriceLevel,
                NameEn: NameEn
            },
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {

                    if (LANG == 'ar') {
                        alert('تم الاضافه بنجاح');
                    } else {
                        alert('Added Successfully');
                    }

                    $('#Name').val('');
                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        if (LANG == 'ar') {
            alert('حقل الاسم مطلوب');
        } else {

            alert('Name Input is Required');
        }

    }



}
//
//Add Serial -->
//

//
//Duplicate Serial -->
//
function SERIAL(r, p) {

    var i = 0;
    var arr = [];

    for (i; i < r; i++) {
        var val = $('#SRCODE' + i + p).val();
        arr.push(val);
    }

    var encounteredIndices = {};
    for (var i = 0; i < arr.length; i++)
        if (encounteredIndices[arr[i]]) {
            console.log(i);
            document.getElementById('SRCODE' + i + p).style.border = "3px solid darkred";
            document.getElementById("Submit").style.display = "none";
        } else {
            encounteredIndices[arr[i]] = 1;
            document.getElementById('SRCODE' + i + p).style.border = "none";
            document.getElementById("Submit").style.display = "block";
        }

}
//
//Recipy Voucher Add Ajax -->
//
$(document).ready(function () {

    fetch_customer_data();

    function fetch_customer_data(Creditor = '', AccountCode = '', Shift = '', Safe = '', Coin = '', Draw = '', STORE = '') {
        $.ajax({
            url: 'AddReciptVoucherAjax',
            method: 'GET',
            data: {
                Creditor: Creditor,
                AccountCode: AccountCode,
                Shift: Shift,
                Safe: Safe,
                Coin: Coin,
                Draw: Draw,
                STORE: STORE
            },
            dataType: 'json',
            success: function (data) {

                alert('تم الاضافه بنجاح');

                $('#Creditor').val('');
                $('#AccountCodeF').empty();

            }
        })
    }

    $(document).on('click', '#ReciptVoucher', function () {

        var Creditor = $('#Creditor').val();
        var AccountCode = $('#AccountCodeF').val();
        var Shift = null;
        var Safe = $('#SafeF').val();
        var Coin = $('#CoinF').val();
        var Draw = 1;
        var STORE = $('#STOREF').val();

        if (Creditor != '' && AccountCode != '') {
            fetch_customer_data(Creditor, AccountCode, Shift, Safe, Coin, Draw, STORE);
        }

    });




});

//
//Payment Voucher Add Ajax -->
//
$(document).ready(function () {

    fetch_customer_data();

    function fetch_customer_data(Debitor = '', AccountCodee = '', Shift = '', Safe = '', Coin = '', Draw = '', STORE = '') {
        $.ajax({
            url: 'AddPaymentVoucherAjax',
            method: 'GET',
            data: {
                Debitor: Debitor,
                AccountCodee: AccountCodee,
                Shift: Shift,
                Safe: Safe,
                Coin: Coin,
                Draw: Draw,
                STORE: STORE
            },
            dataType: 'json',
            success: function (data) {

                alert('تم الاضافه بنجاح');

                $('#Debitor').val('');
                $('#AccountCodee').empty();

            }
        })
    }

    $(document).on('click', '#PaymentVoucher', function () {

        var Debitor = $('#Debitor').val();
        var AccountCodee = $('#AccountCodee').val();
        var Shift = null;
        var Safe = $('#SafeP').val();
        var Coin = $('#CoinP').val();
        var Draw = 1;
        var STORE = $('#STOREP').val();

        if (Debitor != '' && AccountCodee != '') {
            fetch_customer_data(Debitor, AccountCodee, Shift, Safe, Coin, Draw, STORE);
        }

    });





});

//
//Change Tax -->
//
function TAXPurch(r) {

    var countryId = $('#OLDTAX' + r).val();
    var Pro = $('#Product' + r).val();
    var Un = $('#UnitPurch' + r).val();
    var CO = $('#CodePurch' + r).val();
    if (countryId) {
        $.ajax({
            url: 'TaxNamePurchasesFilter/' + countryId,
            type: "GET",
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {


                $('#TaxRate' + r).val(data.rate);
                $('#TaxType' + r).val(data.type);
                $('#PurchTax' + r).val(data.tax);

                var TaxRate = $("#TaxRate" + r).val();
                var TaxType = $("#TaxType" + r).val();
                var Qty = $("#Qty" + r).val();
                var Price = $("#Price" + r).val();
                var Discount = $("#Discount" + r).val();
                var i = 0;
                var ii = 0;
                var iii = 0;
                var DIS = $("#DIS").val();

                if (parseFloat(DIS) == 0) {

                    Discount = $("#Discount" + r).val();

                } else {

                    var d = Discount / 100;
                    var Multi = parseFloat(Price);
                    var dd = Multi * d;

                    Discount = dd;

                }
                var BFG = parseFloat(Qty) * parseFloat(Discount);
                $("#TDiscPro" + r).val(parseFloat(BFG));

                if (TaxType == 1) {
                    //Precent

                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * parseFloat(Price);

                    $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

                    i = parseFloat(TaxRate) / 100;

                    ii = parseFloat(BFF) * parseFloat(i);

                    $("#Tax" + r).val(parseFloat(ii).toFixed(2));

                    iii = parseFloat(BFF) + parseFloat(ii);

                    $("#Total" + r).val(parseFloat(iii).toFixed(2));

                } else if (TaxType == 2) {
                    //Number
                    var BF = parseFloat(Qty) * (parseFloat(Price) - parseFloat(Discount));
                    var BFF = parseFloat(Qty) * parseFloat(Price);
                    $("#TotalBFTax" + r).val(parseFloat(BFF).toFixed(2));

                    i = parseFloat(TaxRate);

                    $("#Tax" + r).val(parseFloat(i).toFixed(2));

                    iii = parseFloat(BFF) + parseFloat(i);

                    $("#Total" + r).val(parseFloat(iii).toFixed(2));


                }


                var Total = $("#Total" + r).val();
                var TotalBFTax = $("#TotalBFTax" + r).val();
                var Tax = $("#Tax" + r).val();
                var UnitID = $("#UnitPurch" + r).val();
                var StorePurch = $("#StorePurch" + r).val();

                if (TaxRate == '' || TaxType == '' || Qty == '' || Price == '' || Discount == '' || Total == '' || TotalBFTax == '' || Tax == '' || UnitID == '' || StorePurch == '') {

                    document.getElementById("AddBtnPur" + r).style.display = "none";
                }


                if (TaxRate != '' && TaxType != '' && Qty != '' && Qty != 0 && Price != '' && Discount != '' && Total != '' && TotalBFTax != '' && Tax != '' && UnitID != '' && StorePurch != '') {

                    if (Price == 0) {

                        document.getElementById("AddBtnPur" + r).style.display = "none";
                    } else {

                        document.getElementById("AddBtnPur" + r).style.display = "inline-block";
                    }
                }







            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        $('select[name="state"]').empty();
    }

}
//
//
$(document).ready(function () {
    $("#Barcode").val(Math.floor(Math.random() * 1000000));
});
//
//Safe Balnces  -->
//
$(document).ready(function () {

    $('#SSAFE').on('change', function () {
        var countryId = $(this).val();
        if (countryId) {
            $.ajax({
                url: 'SafeBalanceFilter/' + countryId,
                type: "GET",
                dataType: "json",
                beforeSend: function () {
                    $('#loader').css("visibility", "visible");
                },

                success: function (data) {
                    $.each(data, function (key, value) {


                        $('#SafeBalance').val(key);
                        $('#SafeBalance').val(value);
                    });
                },
                complete: function () {
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {

            $('select[name="state"]').empty();
        }

    });

});

$(document).ready(function () {

    var countryId = $("#SSAFE").val();
    if (countryId) {
        $.ajax({
            url: 'SafeBalanceFilter/' + countryId,
            type: "GET",
            dataType: "json",
            beforeSend: function () {
                $('#loader').css("visibility", "visible");
            },

            success: function (data) {
                $.each(data, function (key, value) {


                    $('#SafeBalance').val(key);
                    $('#SafeBalance').val(value);
                });
            },
            complete: function () {
                $('#loader').css("visibility", "hidden");
            }
        });
    } else {

        $('select[name="state"]').empty();
    }


});
//

////Paid Check -->
//
function PaidCheck() {

    var paid = $('#paid').val();

    var Pay = $('#Payment_Method').val();
    var Stat = $('#Status').val();
    if (Pay == 'Later' && Stat == 0) {

        if (paid <= 0) {
            document.getElementById("Submit").style.display = "none";
        } else {


            document.getElementById("Submit").style.display = "block";

        }
    }


}
//
