<?php

namespace App\Services;
use App\Http\Resources\ProUnitsResources;
use App\Models\Addressses;
use App\Models\AssemblyProducts;
use App\Models\CustomersGroup;
use App\Models\DefaultDataShowHide;
use App\Models\ExpireDateQty;
use App\Models\FifoQty;
use App\Models\ItemsGroups;
use App\Models\Measuerments;
use App\Models\ProductMoves;
use App\Models\ProductReturnWithoutBill;
use App\Models\Products;
use App\Models\ProductSales;
use App\Models\ProductSalesGifts;
use App\Models\ProductSalesOrder;
use App\Models\ProductsPurchases;
use App\Models\ProductsQty;
use App\Models\ProductsQuote;
use App\Models\ProductUnits;
use App\Models\PurchasesDefaultData;
use App\Models\Sales;
use App\Models\SalesDefaultData;
use App\Models\Admin;
use App\Models\GeneralDaily;
use App\Models\SalesFifoQty;
use App\Models\Shifts;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\Taxes;
use App\Models\VAQty;
use App\Models\Vendors;
use App\Services\Average;
use App\Traits\GeneralTrait;
use App\Models\Customers;
use App\Models\Employess;
use App\Models\ProductQuoteImage;
use DB;


class SalesService
{
    use GeneralTrait;

    public function CustomerIf($id)
    {



                $del=Customers::find($id);

                $Sales=SalesDefaultData::latest('id')->first();

                $Admin=Admin::where('emp',$id)->first();

                if($Sales->Client == $del->Account){

                session()->flash('error',trans('admin.Cant_Delete_Default_Data'));
                return 1;

                }

                if(!empty($Admin)) {
                if($Admin->cli == $id){

                session()->flash('error',trans('admin.Cant_Delete_User_Admin'));
                return 1;

                }
                }

                $xh=GeneralDaily::where('Account',$del->Account)->orderBy('id','desc')->first();

                if(!empty($xh)){

                session()->flash('error',trans('admin.CantDeleteAnyItemHasTraffic'));
                return 1;

                }

        return 0;

    }

    public function PriceLevel($client , $rr)
    {


        $Cli=Customers::where('Account',$client)->first();

        if(!empty($Cli)){

            if($Cli->Price_Level == 1){

                $pr= $rr->Price ;

            }elseif($Cli->Price_Level == 2){

                if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                    $pr= $rr->Price_Two ;

                }else{

                    $pr= $rr->Price ;

                }

            }elseif($Cli->Price_Level == 3){

                if(!empty($rr->Price_Three) and $rr->Price_Three != 0 ){

                    $pr= $rr->Price_Three ;

                }else{

                    $pr= $rr->Price ;

                }

            }

        }else{

            $Vend=Vendors::where('Account',$client)->first();

            if(!empty($Vend)){
                if($Vend->Price_Level == 1){

                    $pr= $rr->Price ;

                }elseif($Vend->Price_Level == 2){

                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                        $pr= $rr->Price_Two ;

                    }else{

                        $pr= $rr->Price ;

                    }

                }elseif($Vend->Price_Level == 3){

                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                        $pr= $rr->Price_Three ;

                    }else{

                        $pr= $rr->Price ;

                    }

                }
            }else{

                $EMPO=Employess::where('Account_Emp',$client)->first();

                if($EMPO->Price_Level == 1){

                    $pr= $rr->Price ;

                }elseif($EMPO->Price_Level == 2){

                    if(!empty($rr->Price_Two) and $rr->Price_Two != 0){

                        $pr= $rr->Price_Two ;

                    }else{

                        $pr= $rr->Price ;

                    }

                }elseif($EMPO->Price_Level == 3){

                    if(!empty($rr->Price_Three) and $rr->Price_Three != 0){

                        $pr= $rr->Price_Three ;

                    }else{

                        $pr= $rr->Price ;

                    }

                }


            }


        }




        return $pr;

    }

    public function AssemblyCost($product,$store)
    {


        $Asembs=AssemblyProducts::where('p_id',$product)->get();
        $AssembCost=0;
      $average = new Average ;


        foreach($Asembs as $asse){

            $COSTpr=$average->AverageCostGet($asse->Product,$asse->P_Code,$store);
            $AssembCost += $COSTpr * $asse->Qty;

        }


        return  number_format($AssembCost,2);

    }

    public function AssemblyQty($product,$store)
    {


        $Asembs=AssemblyProducts::where('p_id',$product)->get();
        $AvaliableQty=0;



        foreach($Asembs as $asse){


            $QuantityAv=$this->ProAvQties($store,$asse->Product,$asse->P_Code);


            if(!empty($QuantityAv)){
                $mta7=$QuantityAv->Qty/$asse->Qty;
                $AvaliableQty=$mta7;
            }






        }


        return  number_format($AvaliableQty,2) ;

    }


//Virable Aggerate

//VACost
//VAQty

    // ----  Show Hide Coulmns  -----

    public function ShowHideColumn(){

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();

        if($Def->Price_Sale == 0){

            if(auth()->guard('admin')->user()->emp != 0){

                if(auth()->guard('admin')->user()->price_sale == 1){

                    $show='';
                }else{

                    $show='disabled';
                }

            }else{

                $show='disabled';
            }


        }else{

            if(auth()->guard('admin')->user()->emp != 0){

                if(auth()->guard('admin')->user()->price_sale == 1){

                    $show='';
                }else{

                    $show='disabled';
                }

            }else{

                $show='';
            }

        }

        if(auth()->guard('admin')->user()->emp != 0){

            if(auth()->guard('admin')->user()->discount == 1){

                $dos='';
            }else{

                $dos='disabled';
            }

            if(auth()->guard('admin')->user()->price_1 == 1){

                $parO='block';
            }else{

                $parO='none';
            }

            if(auth()->guard('admin')->user()->price_2 == 1){

                $parOO='block';
            }else{

                $parOO='none';
            }

            if(auth()->guard('admin')->user()->price_2 == 1){

                $parOOO='block';
            }else{

                $parOOO='none';
            }

        }else{

            $dos='';
            $parO='block';
            $parOO='block';
            $parOOO='block';
        }

        if(auth()->guard('admin')->user()->emp != 0){

            $user='disabled';
        }else{
            $user='';
        }

        if($showw->Disc == 0){

            $discShow='none';
        }else{
            $discShow='';
        }



        if($showw->Sales_Pro_Desc == 0){

            $ProDescShow='none';
        }else{
            $ProDescShow='';
        }

        if($showw->Tax == 0){

            $taxShow='none';
        }else{
            $taxShow='';
        }


        if($showw->Store == 0){

            $storeShow='none';
        }else{
            $storeShow='';
        }

        if($showw->AvQty == 0){

            $avqtyShow='none';
        }else{
            $avqtyShow='';
        }
        if($showw->Show_Barcode == 0){

            $Show_Barcode='none';
        }else{
            $Show_Barcode='';
        }
        if($showw->Show_Net == 0){

            $Show_Net='none';
        }else{
            $Show_Net='';
        }
        if($showw->Show_Unit == 0){

            $Show_Unit='none';
        }else{
            $Show_Unit='';
        }
        if($showw->Show_Total == 0){

            $Show_Total='none';
        }else{
            $Show_Total='';
        }









        $data=[
           'show'=>$show,
           'dos'=>$dos,
           'parO'=>$parO,
           'parOO'=>$parOO,
           'parOOO'=>$parOOO,
           'user'=>$user,
           'discShow'=>$discShow,
           'ProDescShow'=>$ProDescShow,
           'taxShow'=>$taxShow,
           'storeShow'=>$storeShow,
           'avqtyShow'=>$avqtyShow,
           'Show_Barcode'=>$Show_Barcode,
           'Show_Net'=>$Show_Net,
           'Show_Unit'=>$Show_Unit,
           'Show_Total'=>$Show_Total,

        ];

             return $data;

    }

    public function ShowHideColumnJobOrder()
    {

        $show=DefaultDataShowHide::latest('id')->first();

        if(auth()->guard('admin')->user()->emp != 0){

            $user='disabled';
        }else{
            $user='';
        }


        if($show->Disc == 0){

            $discShow='none';
        }else{
            $discShow='';
        }

        if($show->Tax == 0){

            $taxShow='none';
        }else{
            $taxShow='';
        }





        if($show->Store == 0){

            $storeShow='none';
        }else{
            $storeShow='';
        }


        if($show->Height == 0){

            $HeightShow='none';
        }else{
            $HeightShow='';
        }

        if($show->Thickness == 0){

            $ThicknessShow='none';
        }else{
            $ThicknessShow='';
        }



        $data=[
            'user'=>$user,
            'discShow'=>$discShow,
            'taxShow'=>$taxShow,
            'storeShow'=>$storeShow,
            'HeightShow'=>$HeightShow,
            'ThicknessShow'=>$ThicknessShow,


        ];

        return $data;

    }

    // ------  Filters  -----------

    public function ItemsFilter($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $search=$Filter['search'];
        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();

        $LAST=ProductSales::where('Product', $Filter['product'])->whereRelation('Sales','Client',$Filter['client'])->latest('id')->first();

if(!empty($LAST)){
    $LASTCLIENTPRICE=$LAST->Price;
}else{
    $LASTCLIENTPRICE=0;
}



        if(is_numeric($search)){

            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        $hide=$this->ShowHideColumn();
        $show=$hide['show'];
        $dos=$hide['dos'];
        $parO=$hide['parO'];
        $parOO=$hide['parOO'];
        $parOOO=$hide['parOOO'];
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $ProDescShow=$hide['ProDescShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $avqtyShow=$hide['avqtyShow'];
        $Show_Barcode=$hide['Show_Barcode'];
        $Show_Net=$hide['Show_Net'];
        $Show_Unit=$hide['Show_Unit'];
        $Show_Total=$hide['Show_Total'];

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $AvalibleQunatity=$Filter['qty'];

        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['id'].'" onchange="ExpDateQty('.$Filter['id'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['id'].'"   class="form-control">';
        }

        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty']/ $rr->Rate;

        }


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['id'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['id'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();


        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();

        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }

        $Higher=$DES;

        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['id'] . ')"';


        } else{

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['id'] . ')"';
        }

        //lw hw serial
        if(empty($Ser)){
        }

        if($AvalibleQunatity > 0) {
        if($Filter['store']  ==  $Filter['pro_store']) {
            $output .= '

       <tr id="Row' . $Filter['id'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '  ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name' . $Filter['id'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['id'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['id'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['id'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['id'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['id'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['id'] . '" value="' . $Filter['vv_name'] . '">
        <input type="hidden"  id="serial' . $Filter['id'] . '" value="' . $Filter['serial'] . '">
        <input type="hidden"  id="HighDisc' . $Filter['id'] . '" value="' . $Higher . '">
        <input type="hidden"  id="weight' . $Filter['id'] . '" value="' . $weigh . '">
        <input type="hidden"  id="maxSales' . $Filter['id'] . '" value="' . $maxSa . '">
        </td>




        <td style="display:' . $Show_Unit . '">
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['id'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

            foreach ($units as $uni) {
                $nam = Measuerments::find($uni->Unit);


                if (app()->getLocale() == 'ar') {
                    $UnitNamme = $nam->Name;
                } else {

                    $UnitNamme = $nam->NameEn;
                }
                $output .= '
            <option value="' . $uni->Unit . '"       ';
                if ($rr->Unit == $uni->Unit) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $UnitNamme . '</option>
                 ';


            }

            $output .= '

                        </select>
        </td>
        <td style="display:' . $Show_Barcode . '">
         <input type="text" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
        </td>

       ' . $pn . '

            <td style="display:' . $avqtyShow . '">

            <input type="text" class="form-control" id="AvQty' . $Filter['id'] . '" value="' . $AvalibleQunatity . '" disabled >

            </td>

        <td>
        <input type="number" step="any" id="Qty' . $Filter['id'] . '"   class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" >
        <input type="hidden" id="CostPrice' . $Filter['id'] . '"  value="' . $COSTpr . '" >

        </td>

              <td>

 <input type="number" id="Price' . $Filter['id'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" value="' . $pr . '" ' . $show . ' >

        </td>


                  <td style="display:' . $discShow . '">

 <input type="number" id="Discount' . $Filter['id'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" value="' . $DES . '" ' . $dos . ' >
   <input type="hidden" id="TDiscPro' . $Filter['id'] . '"   class="form-control" value="' . $DES . '" >
<input type="hidden" id="TotalBFTax' . $Filter['id'] . '"   class="form-control" >
<input type="hidden" id="Tax' . $Filter['id'] . '"   class="form-control" >
  <input type="hidden" id="Total' . $Filter['id'] . '"   class="form-control" >
  <input type="hidden" id="TotalNet' . $Filter['id'] . '"   class="form-control" >
        </td>

        <td style="display:' . $taxShow . '">
   <select class="select2 form-control w-100"   id="OLDTAX' . $Filter['id'] . '" onchange="TAXPurch(' . $Filter['id'] . ')">
              ';

            foreach ($TAXESS as $tax) {
                if (app()->getLocale() == 'ar') {
                    $txNamme = $tax->Name;
                } else {

                    $txNamme = $tax->NameEn;
                }
                $output .= '
      <option value="' . $tax->id . '"       ';
                if ($tax->id == $rr->Product()->first()->Tax) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $txNamme . '</option>
                 ';
            }

            $output .= '

                        </select>
        </td>
            <td style="display:' . $storeShow . '">
   <select class="select2 form-control w-100" ' . $user . '   id="StorePurch' . $Filter['id'] . '" onchange="StoreNamePurch(' . $Filter['id'] . ')" disabled>
              ';

            foreach ($Stores as $stor) {
                if (app()->getLocale() == 'ar') {
                    $StorNamme = $stor->Name;
                } else {

                    $StorNamme = $stor->NameEn;
                }
                $output .= '
      <option value="' . $stor->id . '"       ';
                if ($stor->id == $Filter['store']) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $StorNamme . '</option>
                 ';
            }

            $output .= '

                        </select>
        </td>

       ' . $EXPIRE . '


         <td style="display:' . $ProDescShow . '">

         <input type="text" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
         </td>

        <td>
         <input type="hidden" id="StorePurchName' . $Filter['id'] . '"   class="form-control"  value="' . $StoreNemo . '" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['id'] . '" onclick="Fun(' . $Filter['id'] . ')">
          <i class="fal fa-plus"></i>
          </button>


    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#dollar' . $Filter['id'] . '">
    <i class="fal fa-dollar-sign"></i>
    </button>


        <div class="modal fade" id="dollar' . $Filter['id'] . '" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                              ' . trans('admin.Price') . '
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>     ' . trans('admin.Price_One') . ' </th>
                                    <th> ' . trans('admin.Price_Two') . ' </th>
                                    <th>  ' . trans('admin.Price_Three') . ' </th>
                                    <th>  ' . trans('admin.Last_Price_Client') . ' </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                     <td>
                   <button style="display:' . $parO . '" type="button" class="btn btn-default" onclick="ChangePriceU(' . $Filter['id'] . ')">
           <input type="text" class="form-control" id="UnitPriceOne' . $Filter['id'] . '" disabled value="' . $rr->Price . '">
           </button>

                                </td>
                                <td>
                    <button type="button" style="display:' . $parOO . '" class="btn btn-default" onclick="ChangePriceUU(' . $Filter['id'] . ')">
            <input type="text" class="form-control" id="UnitPriceTwo' . $Filter['id'] . '" disabled value="' . $rr->Price_Two . '">                 </button>
                                </td>
                                     <td>
                  <button type="button"  style="display:' . $parOOO . '" class="btn btn-default" onclick="ChangePriceUUU(' . $Filter['id'] . ')">
        <input type="text" class="form-control" id="UnitPriceThree' . $Filter['id'] . '" disabled value="' . $rr->Price_Three . '">                        </button>
                                     </td>

<td>'.$LASTCLIENTPRICE.'</td>


                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>




          </td>
        </tr>


            ';

        }
        }

        return $output;

    }

    //ItemsFilterQuoteImages
    public function ItemsFilterQuoteImages($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;
        $show = DefaultDataShowHide::orderBy('id', 'desc')->first();
        $Def = PurchasesDefaultData::orderBy('id', 'desc')->first();

        if (auth()->guard('admin')->user()->emp != 0) {
            $user = 'disabled';

            if (auth()->guard('admin')->user()->cost_price_purch == 0) {
                $Doollar = 'display: none;';
            } else {
                $Doollar = '';
            }

        } else {
            $user = '';
            $Doollar = '';
        }

        if ($show->Disc == 0) {
            $discShow = 'none';
        } else {
            $discShow = '';
        }

        if ($show->Tax == 0) {
            $taxShow = 'none';
        } else {
            $taxShow = '';
        }

        if ($show->Store == 0) {
            $storeShow = 'none';
        } else {
            $storeShow = '';
        }

        if ($show->Show_Barcode == 0) {
            $BarcodeShow = 'none';
        } else {
            $BarcodeShow = '';
        }

        if ($show->Show_Unit == 0) {
            $UnitShow = 'none';
        } else {
            $UnitShow = '';
        }


        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        if ($show->Expire_Date == 1) {

            $EXPIRE = '<td><input type="date" id="ExpDate' . $Filter['product'] . '" class="form-control"> </td>';
        } else {

            $EXPIRE = '<input type="hidden" id="ExpDate' . $Filter['product'] . '" class="form-control">';
        }

        $lastBill = ProductsPurchases::orderBy('id', 'desc')->where('Product', $Filter['product'])->where('Product_Code', $rr->Barcode)->first();
        $lastBillV = ProductsPurchases::orderBy('id', 'desc')->where('Product', $Filter['product'])->where('Product_Code', $rr->Barcode)->where('Vendor', $Filter['client'])->first();
        $qtyOther = ProductsQty::where('Product', $Filter['product'])->where('P_Code', $rr->Barcode)->where('Store', '!=', $Filter['store'])->get()->sum('Qty');

        $pr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if (!empty($lastBill)) {
            $priceone = $lastBill->Price;
        } else {
            $priceone = 0;

        }

        if (!empty($lastBillV)) {
            $pricetwo = $lastBillV->Price;
        } else {
            $pricetwo = 0;

        }


        if (!empty($rr->Product()->first()->Brand)) {
            if (app()->getLocale() == 'ar') {
                $brandd = $rr->Product()->first()->Brand()->first()->Name;
            } else {
                $brandd = $rr->Product()->first()->Brand()->first()->NameEn;
            }

        } else {

            $brandd = "";

        }

        if ($show->Group_Brand == 1) {

            if (app()->getLocale() == 'ar') {
                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->Name . ')';
            } else {

                $ShowGrBr = '(' . $brandd . ') (' . $rr->Product()->first()->Group()->first()->NameEn . ')';
            }

        } else {
            $ShowGrBr = '';
        }


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="Fun(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 2) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalSerial(' . $Filter['product'] . ')" onclick="PurchTotalSerial(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunSerial(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 3) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalV(' . $Filter['product'] . ')" onclick="PurchTotalV(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunV(' . $Filter['product'] . ')"';

        } elseif ($Filter['type'] == 4) {

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['product'] . ')"';
            $funTotal = 'onkeyup="PurchTotalVV(' . $Filter['product'] . ')" onclick="PurchTotalVV(' . $Filter['product'] . ')"';
            $funAdd = 'onclick="FunVV(' . $Filter['product'] . ')"';

        }





        $output .= '

       <tr id="Row' . $Filter['product'] . '">
        <td>
        ' . $Filter['PrrroName'] . ' ' . $ShowGrBr . '
 <input type="hidden"  id="P_Ar_Name' . $Filter['product'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['product'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['product'] . '" value="' . $Filter['product'] . '">
        </td>

        <td style="display:' . $UnitShow . '">
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['product'] . '" ' . $funUnit . '>
                <option value="">  ' . trans('admin.Choice_Unit') . '</option>
              ';

        foreach ($units as $uni) {
            $nam = Measuerments::find($uni->Unit);

            if (app()->getLocale() == 'ar') {
                $UnitNamme = $nam->Name;
            } else {

                $UnitNamme = $nam->NameEn;
            }
            $output .= '
            <option value="' . $uni->Unit . '"       ';
            if ($rr->Unit == $uni->Unit) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $UnitNamme . '</option>
                 ';


        }

        $output .= '

                        </select>
        </td>


        <td style="display:' . $BarcodeShow . '">
         <input type="text" id="CodePurch' . $Filter['product'] . '" class="form-control" value="' . $rr->Barcode . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['product'] . '" value="' . $Filter['UniiName'] . '">
         <input type="hidden" id="TaxRate' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax . '">
        </td>

        <td>
        <input type="number" step="any" id="Qty' . $Filter['product'] . '"   class="form-control" ' . $funTotal . ' >

        </td>

              <td>

 <input type="number" id="Price' . $Filter['product'] . '" step="any"  class="form-control" ' . $funTotal . '" value="' . $pr . '"  >
  <input type="hidden"  id="Price_Sale' . $Filter['product'] . '" value="' . $rr->Price . '">
        </td>



                  <td style="display:' . $discShow . '">

 <input type="number" id="Discount' . $Filter['product'] . '" step="any"  class="form-control" ' . $funTotal . ' value="0" >
  <input type="hidden" id="TDiscPro' . $Filter['product'] . '"   class="form-control" value="0" >
<input type="hidden" id="TotalBFTax' . $Filter['product'] . '"   class="form-control" >
<input type="hidden" id="Tax' . $Filter['product'] . '"   class="form-control" >
  <input type="hidden" id="Total' . $Filter['product'] . '"   class="form-control" >
  <input type="hidden" id="TotalNet' . $Filter['product'] . '"   class="form-control" >
        </td>

      <td style="display:' . $taxShow . '">
   <select class="select2 form-control w-100"    id="OLDTAX' . $Filter['product'] . '" onchange="TAXPurch(' . $Filter['product'] . ')">
              ';

        foreach ($TAXESS as $tax) {
            if (app()->getLocale() == 'ar') {
                $txNamme = $tax->Name;
            } else {

                $txNamme = $tax->NameEn;
            }

            $output .= '
      <option value="' . $tax->id . '"       ';
            if ($tax->id == $rr->Product()->first()->Tax) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $txNamme . '</option>
                 ';
        }

        $output .= '

                        </select>
        </td>

            <td style="display:' . $storeShow . '">
   <select class="select2 form-control w-100" ' . $user . '   id="StorePurch' . $Filter['product'] . '" onchange="StoreNamePurch(' . $Filter['product'] . ')">
              ';

        foreach ($Stores as $stor) {
            if (app()->getLocale() == 'ar') {
                $StorNamme = $stor->Name;
            } else {

                $StorNamme = $stor->NameEn;
            }

            $output .= '
      <option value="' . $stor->id . '"       ';
            if ($stor->id == $Filter['store']) {
                $output .= '  selected  ';
            }
            $output .= ' > ' . $StorNamme . '</option>
                 ';
        }

        $output .= '

                        </select>
        </td>

       ' . $EXPIRE . '


        <td>
           <input type="hidden" id="StorePurchName' . $Filter['product'] . '"   class="form-control"  value="' . $Filter['StoreNemo'] . '" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['product'] . '" ' . $funAdd . ' >
          <i class="fal fa-plus"></i>
          </button>


                 <button type="button" style="' . $Doollar . '" class="btn btn-default" data-toggle="modal" data-target="#dollar' . $Filter['product'] . '">
    <i class="fal fa-dollar-sign"></i>
    </button>


        <div class="modal fade" id="dollar' . $Filter['product'] . '" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                               <h4 class="modal-title">
                             ' . trans('admin.Price') . '
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                          <th>   ' . trans('admin.Price_One') . ' </th>
                                    <th>   ' . trans('admin.Price_Two') . ' </th>
                                    <th>   ' . trans('admin.Price_Three') . ' </th>
                                    <th> ' . trans('admin.Price_Last_Purch_Bill') . ' </th>
                                    <th> ' . trans('admin.Price_Last_Purch_Bill_from_this_Vendor') . ' </th>
                                    <th>    ' . trans('admin.Other_Stores_Qty') . ' </th>
                                    <th> ' . trans('admin.Actions') . ' </th>
                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                     <td>

                      <input type="text" id="UnitPriceOne' . $Filter['product'] . '" class="form-control" value="' . $rr->Price . '">
                                </td>
                                <td>
                         <input type="text" id="UnitPriceTwo' . $Filter['product'] . '" class="form-control" value="' . $rr->Price_Two . '">
                                </td>
                                     <td>

                     <input type="text" id="UnitPriceThree' . $Filter['product'] . '" class="form-control" value="' . $rr->Price_Three . '">

                     <input type="hidden" id="UnitPriceID' . $Filter['product'] . '"  value="' . $rr->id . '">
                                     </td>
                                      <td>
                                     ' . $priceone . '
                                     </td>
                                         <td>
                                         ' . $pricetwo . '
                                     </td>

                                         <td>
                                         ' . $qtyOther . '
                                     </td>

    <td>
    <button type="button" onclick="ChangePriceUnit(' . $Filter['product'] . ')" class="btn btn-primary">
    <i class="fal fa-edit"></i>
    </button>
    </td>
                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>


          </td>
        </tr>


            ';


        return $output;

    }



    public function ItemsFilterTwo($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();

        $LAST=ProductSales::where('Product', $Filter['product'])->whereRelation('Sales','Client',$Filter['client'])->latest('id')->first();

        if(!empty($LAST)){
            $LASTCLIENTPRICE=$LAST->Price;
        }else{
            $LASTCLIENTPRICE=0;
        }

        $search=$Filter['search'];

        if(is_numeric($search)){

            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        $hide=$this->ShowHideColumn();
        $show=$hide['show'];
        $dos=$hide['dos'];
        $parO=$hide['parO'];
        $parOO=$hide['parOO'];
        $parOOO=$hide['parOOO'];
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $ProDescShow=$hide['ProDescShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $avqtyShow=$hide['avqtyShow'];
        $Show_Barcode=$hide['Show_Barcode'];
        $Show_Net=$hide['Show_Net'];
        $Show_Unit=$hide['Show_Unit'];
        $Show_Total=$hide['Show_Total'];

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $AvalibleQunatity=$Filter['qty'];

        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';

        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['product'].'" onchange="ExpDateQty('.$Filter['product'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['product'].'"   class="form-control">';
        }



        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{



            $AvalibleQunatity=$Filter['qty']  / $rr->Rate;


        }




        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);


        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }

        $Higher=$DES;
        // 1 Assembly  2 service



            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['product'] . ')"';



        //lw hw assembly
        if(  $AvalibleQunatity > 0) {

            $output .= '

       <tr id="Row' . $Filter['product'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '
 <input type="hidden"  id="P_Ar_Name' . $Filter['product'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['product'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['product'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['product'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['product'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['product'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['product'] . '" value="' . $Filter['vv_name'] . '">
        <input type="hidden"  id="serial' . $Filter['product'] . '" value="' . $Filter['serial'] . '">
        <input type="hidden"  id="HighDisc' . $Filter['product'] . '" value="' . $Higher . '">
        <input type="hidden"  id="weight' . $Filter['product'] . '" value="' . $weigh . '">
        <input type="hidden"  id="maxSales' . $Filter['product'] . '" value="' . $maxSa . '">
        </td>




        <td  style="display:' . $Show_Unit . '" >
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['product'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

            foreach ($units as $uni) {
                $nam = Measuerments::find($uni->Unit);


                if (app()->getLocale() == 'ar') {
                    $UnitNamme = $nam->Name;
                } else {

                    $UnitNamme = $nam->NameEn;
                }
                $output .= '
            <option value="' . $uni->Unit . '"       ';
                if ($rr->Unit == $uni->Unit) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $UnitNamme . '</option>
                 ';


            }

            $output .= '

                        </select>
        </td>
        <td  style="display:' . $Show_Barcode . '" >
         <input type="text" id="CodePurch' . $Filter['product'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['product'] . '" value="' . $UniiName . '">
         <input type="hidden" id="UnitDefault' . $Filter['product'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['product'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['product'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax . '">
        </td>

       ' . $pn . '

            <td style="display:' . $avqtyShow . '">

            <input type="text" class="form-control" id="AvQty' . $Filter['product'] . '" value="' . $AvalibleQunatity . '" disabled >

            </td>

        <td>
        <input type="number" step="any" id="Qty' . $Filter['product'] . '"   class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" >
        <input type="hidden" id="CostPrice' . $Filter['product'] . '"  value="' . $COSTpr . '" >

        </td>

              <td>

 <input type="number" id="Price' . $Filter['product'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" value="' . $pr . '" ' . $show . ' >

        </td>


                  <td style="display:' . $discShow . '">

 <input type="number" id="Discount' . $Filter['product'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" value="' . $DES . '" ' . $dos . ' >
   <input type="hidden" id="TDiscPro' . $Filter['product'] . '"   class="form-control" value="' . $DES . '" >
<input type="hidden" id="TotalBFTax' . $Filter['product'] . '"   class="form-control" >
<input type="hidden" id="Tax' . $Filter['product'] . '"   class="form-control" >
  <input type="hidden" id="Total' . $Filter['product'] . '"   class="form-control" >
        </td>

        <td style="display:' . $taxShow . '">
   <select class="select2 form-control w-100"   id="OLDTAX' . $Filter['product'] . '" onchange="TAXPurch(' . $Filter['product'] . ')">
              ';

            foreach ($TAXESS as $tax) {
                if (app()->getLocale() == 'ar') {
                    $txNamme = $tax->Name;
                } else {

                    $txNamme = $tax->NameEn;
                }
                $output .= '
      <option value="' . $tax->id . '"       ';
                if ($tax->id == $rr->Product()->first()->Tax) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $txNamme . '</option>
                 ';
            }

            $output .= '

                        </select>
        </td>
            <td style="display:' . $storeShow . '">
   <select class="select2 form-control w-100" ' . $user . '   id="StorePurch' . $Filter['product'] . '" onchange="StoreNamePurch(' . $Filter['product'] . ')" disabled>
              ';

            foreach ($Stores as $stor) {
                if (app()->getLocale() == 'ar') {
                    $StorNamme = $stor->Name;
                } else {

                    $StorNamme = $stor->NameEn;
                }
                $output .= '
      <option value="' . $stor->id . '"       ';
                if ($stor->id == $Filter['store']) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $StorNamme . '</option>
                 ';
            }

            $output .= '

                        </select>
        </td>

       ' . $EXPIRE . '


         <td style="display:' . $ProDescShow . '">

         <input type="text" class="form-control" id="SalesProDesc' . $Filter['product'] . '">
         </td>

        <td>
         <input type="hidden" id="StorePurchName' . $Filter['product'] . '"   class="form-control"  value="' . $StoreNemo . '" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['product'] . '" onclick="Fun(' . $Filter['product'] . ')">
          <i class="fal fa-plus"></i>
          </button>


    <button type="button" class="btn btn-default" data-toggle="modal" data-target="#dollar' . $Filter['product'] . '">
    <i class="fal fa-dollar-sign"></i>
    </button>


        <div class="modal fade" id="dollar' . $Filter['product'] . '" tabindex="-1" role="dialog"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                              ' . trans('admin.Price') . '
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                        <div class="mt-3">
                            <table id="" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>     ' . trans('admin.Price_One') . ' </th>
                                    <th> ' . trans('admin.Price_Two') . ' </th>
                                    <th>  ' . trans('admin.Price_Three') . ' </th>
                                           <th>  ' . trans('admin.Last_Price_Client') . ' </th>

                                </tr>
                            </thead>
                            <tbody id="">
                                <tr>

                                     <td>
                   <button style="display:' . $parO . '" type="button" class="btn btn-default" onclick="ChangePriceU(' . $Filter['product'] . ')">
           <input type="text" class="form-control" id="UnitPriceOne' . $Filter['product'] . '" disabled value="' . $rr->Price . '">
           </button>

                                </td>
                                <td>
                    <button type="button" style="display:' . $parOO . '" class="btn btn-default" onclick="ChangePriceUU(' . $Filter['product'] . ')">
            <input type="text" class="form-control" id="UnitPriceTwo' . $Filter['product'] . '" disabled value="' . $rr->Price_Two . '">                 </button>
                                </td>
                                     <td>
                  <button type="button"  style="display:' . $parOOO . '" class="btn btn-default" onclick="ChangePriceUUU(' . $Filter['product'] . ')">
        <input type="text" class="form-control" id="UnitPriceThree' . $Filter['product'] . '" disabled value="' . $rr->Price_Three . '">                        </button>
                                     </td>
<td>'.$LASTCLIENTPRICE.'</td>
                                </tr>
                            </tbody>
                        </table>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            </div>




          </td>
        </tr>


            ';

        }

        return $output;

    }


    //Return Without Bill
    public function ItemsFilterWithoutBill($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }

        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        $hide=$this->ShowHideColumn();
        $show=$hide['show'];
        $dos=$hide['dos'];
        $parO=$hide['parO'];
        $parOO=$hide['parOO'];
        $parOOO=$hide['parOOO'];
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $ProDescShow=$hide['ProDescShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $avqtyShow=$hide['avqtyShow'];

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $Higher=$Filter['Higher'];
        $AvalibleQunatity=$Filter['qty'];

        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['id'].'" onchange="ExpDateQty('.$Filter['id'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['id'].'"   class="form-control">';
        }

        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty']/ $rr->Rate;

        }


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['id'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['id'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();

        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                $DES= $nwD->Discount ;

            }else{
                $DES=0;

            }

        }else{
            $DES=0;
        }


        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['id'] . ')"';


        } else{

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['id'] . ')"';
        }

        //lw hw serial
        if(empty($Ser)){
        }



            if($Filter['store']  ==  $Filter['pro_store']) {
                $output .= '

       <tr id="Row' . $Filter['id'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '  ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name' . $Filter['id'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['id'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['id'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['id'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['id'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['id'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['id'] . '" value="' . $Filter['vv_name'] . '">
        <input type="hidden"  id="serial' . $Filter['id'] . '" value="' . $Filter['serial'] . '">
        <input type="hidden"  id="HighDisc' . $Filter['id'] . '" value="' . $Higher . '">
        <input type="hidden"  id="weight' . $Filter['id'] . '" value="' . $weigh . '">
        <input type="hidden"  id="maxSales' . $Filter['id'] . '" value="' . $maxSa . '">
        </td>




        <td>
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['id'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

                foreach ($units as $uni) {
                    $nam = Measuerments::find($uni->Unit);


                    if (app()->getLocale() == 'ar') {
                        $UnitNamme = $nam->Name;
                    } else {

                        $UnitNamme = $nam->NameEn;
                    }
                    $output .= '
            <option value="' . $uni->Unit . '"       ';
                    if ($rr->Unit == $uni->Unit) {
                        $output .= '  selected  ';
                    }
                    $output .= ' > ' . $UnitNamme . '</option>
                 ';


                }

                $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
        </td>




        <td>
        <input type="number" step="any" id="Qty' . $Filter['id'] . '"   class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" >
        <input type="hidden" id="CostPrice' . $Filter['id'] . '"  value="' . $COSTpr . '" >

        </td>

              <td>

 <input type="number" id="Cost' . $Filter['id'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" value="' . $COSTpr . '" ' . $show . ' >

        </td>
              <td>

 <input type="number" id="Price' . $Filter['id'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" value="' . $pr . '" ' . $show . ' >

        </td>


                  <td style="display:none">

 <input type="number" id="Discount' . $Filter['id'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" value="' . $DES . '" ' . $dos . ' >
   <input type="hidden" id="TDiscPro' . $Filter['id'] . '"   class="form-control" value="' . $DES . '" >
<input type="hidden" id="TotalBFTax' . $Filter['id'] . '"   class="form-control" >
<input type="hidden" id="Tax' . $Filter['id'] . '"   class="form-control" >
  <input type="hidden" id="Total' . $Filter['id'] . '"   class="form-control" >
        </td>

        <td style="display:none">
   <select class="select2 form-control w-100"   id="OLDTAX' . $Filter['id'] . '" onchange="TAXPurch(' . $Filter['id'] . ')">
              ';

                foreach ($TAXESS as $tax) {
                    if (app()->getLocale() == 'ar') {
                        $txNamme = $tax->Name;
                    } else {

                        $txNamme = $tax->NameEn;
                    }
                    $output .= '
      <option value="' . $tax->id . '"       ';
                    if ($tax->id == $rr->Product()->first()->Tax) {
                        $output .= '  selected  ';
                    }
                    $output .= ' > ' . $txNamme . '</option>
                 ';
                }

                $output .= '

                        </select>
        </td>
            <td style="display:none">
   <select class="select2 form-control w-100" ' . $user . '   id="StorePurch' . $Filter['id'] . '" onchange="StoreNamePurch(' . $Filter['id'] . ')">
              ';

                foreach ($Stores as $stor) {
                    if (app()->getLocale() == 'ar') {
                        $StorNamme = $stor->Name;
                    } else {

                        $StorNamme = $stor->NameEn;
                    }
                    $output .= '
      <option value="' . $stor->id . '"       ';
                    if ($stor->id == $Filter['store']) {
                        $output .= '  selected  ';
                    }
                    $output .= ' > ' . $StorNamme . '</option>
                 ';
                }

                $output .= '

                        </select>
        </td>



         <td style="display:none">

         <input type="text" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
         </td>

        <td>
         <input type="hidden" id="StorePurchName' . $Filter['id'] . '"   class="form-control"  value="' . $StoreNemo . '" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['id'] . '" onclick="Fun(' . $Filter['id'] . ')">
          <i class="fal fa-plus"></i>
          </button>



          </td>
        </tr>


            ';

            }


        return $output;

    }

    public function ItemsFilterTwoWithoutBill($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }
        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        $hide=$this->ShowHideColumn();
        $show=$hide['show'];
        $dos=$hide['dos'];
        $parO=$hide['parO'];
        $parOO=$hide['parOO'];
        $parOOO=$hide['parOOO'];
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $ProDescShow=$hide['ProDescShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $avqtyShow=$hide['avqtyShow'];

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $Higher=$Filter['Higher'];
        $AvalibleQunatity=$Filter['qty'];


        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['product'].'" onchange="ExpDateQty('.$Filter['product'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '</select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['product'].'"   class="form-control">';
        }

        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty'] / $rr->Rate;

        }


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();

        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                $DES= $nwD->Discount ;

            }else{
                $DES=0;

            }

        }else{
            $DES=0;
        }


        // 1 Assembly  2 service



        $funUnit = 'onchange="UnitCodePurchh(' . $Filter['product'] . ')"';



        //lw hw assembly


            $output .= '

       <tr id="Row' . $Filter['product'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '
 <input type="hidden"  id="P_Ar_Name' . $Filter['product'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['product'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['product'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['product'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['product'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['product'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['product'] . '" value="' . $Filter['vv_name'] . '">
        <input type="hidden"  id="serial' . $Filter['product'] . '" value="' . $Filter['serial'] . '">
        <input type="hidden"  id="HighDisc' . $Filter['product'] . '" value="' . $Higher . '">
        <input type="hidden"  id="weight' . $Filter['product'] . '" value="' . $weigh . '">
        <input type="hidden"  id="maxSales' . $Filter['product'] . '" value="' . $maxSa . '">
        </td>




        <td>
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['product'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

            foreach ($units as $uni) {
                $nam = Measuerments::find($uni->Unit);


                if (app()->getLocale() == 'ar') {
                    $UnitNamme = $nam->Name;
                } else {

                    $UnitNamme = $nam->NameEn;
                }
                $output .= '
            <option value="' . $uni->Unit . '"       ';
                if ($rr->Unit == $uni->Unit) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $UnitNamme . '</option>
                 ';


            }

            $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch' . $Filter['product'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['product'] . '" value="' . $UniiName . '">
         <input type="hidden" id="UnitDefault' . $Filter['product'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['product'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['product'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['product'] . '" value="' . $rr->Product()->first()->Tax . '">
        </td>



        <td>
        <input type="number" step="any" id="Qty' . $Filter['product'] . '"   class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" >
        <input type="hidden" id="CostPrice' . $Filter['product'] . '"  value="' . $COSTpr . '" >

        </td>

              <td>

 <input type="number" id="Cost' . $Filter['product'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" value="' . $COSTpr . '" ' . $show . ' >

        </td>
              <td>

 <input type="number" id="Price' . $Filter['product'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" value="' . $pr . '" ' . $show . ' >

        </td>


                  <td style="display:none">

 <input type="number" id="Discount' . $Filter['product'] . '" step="any"  class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" value="' . $DES . '" ' . $dos . ' >
   <input type="hidden" id="TDiscPro' . $Filter['product'] . '"   class="form-control" value="' . $DES . '" >
<input type="hidden" id="TotalBFTax' . $Filter['product'] . '"   class="form-control" >
<input type="hidden" id="Tax' . $Filter['product'] . '"   class="form-control" >
  <input type="hidden" id="Total' . $Filter['product'] . '"   class="form-control" >
        </td>

        <td style="display:none">
   <select class="select2 form-control w-100"   id="OLDTAX' . $Filter['product'] . '" onchange="TAXPurch(' . $Filter['product'] . ')">
              ';

            foreach ($TAXESS as $tax) {
                if (app()->getLocale() == 'ar') {
                    $txNamme = $tax->Name;
                } else {

                    $txNamme = $tax->NameEn;
                }
                $output .= '
      <option value="' . $tax->id . '"       ';
                if ($tax->id == $rr->Product()->first()->Tax) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $txNamme . '</option>
                 ';
            }

            $output .= '

                        </select>
        </td>
            <td style="display:none">
   <select class="select2 form-control w-100" ' . $user . '   id="StorePurch' . $Filter['product'] . '" onchange="StoreNamePurch(' . $Filter['product'] . ')">
              ';

            foreach ($Stores as $stor) {
                if (app()->getLocale() == 'ar') {
                    $StorNamme = $stor->Name;
                } else {

                    $StorNamme = $stor->NameEn;
                }
                $output .= '
      <option value="' . $stor->id . '"       ';
                if ($stor->id == $Filter['store']) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $StorNamme . '</option>
                 ';
            }

            $output .= '

                        </select>
        </td>


         <td style="display:none">

         <input type="text" class="form-control" id="SalesProDesc' . $Filter['product'] . '">
         </td>

        <td>
         <input type="hidden" id="StorePurchName' . $Filter['product'] . '"   class="form-control"  value="' . $StoreNemo . '" >
 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['product'] . '" onclick="Fun(' . $Filter['product'] . ')">
          <i class="fal fa-plus"></i>
          </button>








          </td>
        </tr>


            ';



        return $output;

    }


    //POS
    public function ItemsFilterPOS($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $search=$Filter['search'];

        $st = Stores::find($Filter['store']);

        if(is_numeric($search)){

            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();

        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }



        $weigh=$Filter['weigh'];

        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];

        $AvalibleQunatity=$Filter['qty'];




        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }
        $Higher=$DES;

        //lw hw serial
        if(empty($Ser)){
        }


        if($AvalibleQunatity > 0) {
            if($Filter['store']  ==  $Filter['pro_store']) {

                $output .= '


        <div class="col-md-3" data-toggle="tooltip" data-placement="top" title="'.$pr.'" id="Row'.$Filter['id'].'">

 <button type="button" data-toggle="tooltip" data-placement="top" title="'.$pr.'" class="btn btn-default waves-effect waves-themed BUT" id="AddBtnPur'.$Filter['id'].'" onclick="Fun('.$Filter['id'].')">
        '.$PrrroName.' ('.$Filter['P_Code'].') '.$ShowGrBr.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
        </button>
        </div>

            ';


            }
        }

        return $output;

    }

    public function ProductsQtyFilterApi($Filter)
    {

        $average = new Average;
        $service = new SalesService;


        $st = Stores::find($Filter['store']);
        $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $AvalibleQunatity=$Filter['qty'] / $rr->Rate;


        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }

        $Higher=$DES;


        $Array=[];
        if($AvalibleQunatity > 0) {
            if($Filter['store']  ==  $Filter['pro_store']) {
                $UNITS=$this->ProUnitsData($Filter['product'],$Filter['store'],$Filter['client'],$Filter['P_Code']);
             $Array=[
                    'row_id'=>$Filter['id'],
                    'product_name'=>$PrrroName,
                    'product_ar_name'=>$Filter['name_ar'],
                    'product_en_name'=>$Filter['name_en'],
                    'product_id'=>$Filter['product'],
                    'virable_one_id'=>$Filter['v1'],
                    'virable_two_id'=>$Filter['v2'],
                    'virable_one_name'=>$Filter['v_name'],
                    'virable_two_name'=>$Filter['vv_name'],
                    'product_code'=>$Filter['P_Code'],
                    'unit_name'=>$UniiName,
                    'unit_id'=>$rr->Unit,
                    'unit_default'=>$rr->Unit,
                    'units'=>$UNITS,
                    'code_default'=>$rr->Barcode,
                    'tax_rate'=>$rr->Product()->first()->Tax()->first()->Rate,
                    'tax_type'=>$rr->Product()->first()->Tax()->first()->Type,
                    'tax_id'=>$rr->Product()->first()->Tax,
                    'avalible_qty'=>$AvalibleQunatity,
                    'qty'=>1,
                    'price'=>$pr,
                    'priceOne'=>$rr->Price,
                    'priceTwo'=>$rr->Price_Two,
                    'priceThree'=>$rr->Price_Three,
                    'discount'=>$DES,
                    'total_disc_pro'=>$DES,
                    'total_before_tax'=>$pr,
                    'tax_value'=>0,
                    'total'=>$pr,
                    'store_id'=>$st->id,
                    'store_name'=>$Filter['StoreNemo'],
                    'ExpDate'=>'',
                    'serial'=>$Filter['serial'],
                    'high_disc'=>$Higher,
                    'cost_price'=>$COSTpr,
                    'weight'=>$weigh,
                    'max_sales'=>$maxSa,
                    'unit_rate'=>$rr->Rate,
                    'sales_pro_desc'=>'',

                ];


            }
        }

        return $Array;

    }

    public function ProUnitsData($pro,$store,$client,$p_code)
    {
        $proUnits = ProductUnits::where('Product',$pro)->get();
        $data=[];
        foreach($proUnits as $unit){

            $average = new Average ;
            $id=$unit->Unit;
            $Pro=$pro;
            $Client=$client;
            $code=$p_code;
            $Store=$store;


            if(app()->getLocale() == 'ar' ){
                $UnitName=$unit->Unit()->first()->Name;
            }else{
                $UnitName=$unit->Unit()->first()->NameEn;
            }




            $rr = ProductUnits::where("Unit",$id)->where('Product',$Pro)->first();

            $x = $this->ProAvQties($Store,$Pro,$code);

            $price=$this->PriceLevel($Client,$rr);



            $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Pro)->where('Store',$Store)->where('P_Code',$code)->first();
            $EXPO='';
            if(!empty($EXPPPP)){
                $EXPO=$this->ExpireAvQtiesCheck($Store,$Pro,$code,$EXPPPP->Exp_Date);
            }


            $COSTpr=$average->AverageCostGetUnit($Pro,$code,$Store,$id);

            if(!empty($x)){
                $Quntity= $x->Qty / $rr->Rate ;
                if(!empty($EXPO)){

                    $Quntity=$EXPO->Qty;
                }


                if($Quntity < 0){

                    $Quntity=0;
                }

                if($COSTpr < 0){

                    $COSTpr=0;
                }


                array_push($data, [

                    'unit_id'=>$unit->Unit,
                    'unit_name'=>$UnitName,
                    'code' => $rr->Barcode ,
                    'price' => $price ,
                    'rate' => $rr->Product()->first()->Tax()->first()->Rate ,
                    'type' => $rr->Product()->first()->Tax()->first()->Type ,
                    'tax' => $rr->Product()->first()->Tax ,
                    'priceOne' => $rr->Price ,
                    'priceTwo' => $rr->Price_Two ,
                    'priceThree' => $rr->Price_Three,
                    'qty'=>$Quntity,
                    'cost'=>$COSTpr

                ]);



            }else{




                    $x = $this->ProAvQtiesUnit($Store,$unit->Product,$unit->Barcode,$id);


                    $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$unit->Product)->where('Store',$Store)->where('P_Code',$unit->Barcode)->first();
                    $EXPO='';
                    if(!empty($EXPPPP)){

                        $EXPO=$this->ExpireAvQtiesCheck($Store,$unit->Product,$unit->Barcode,$EXPPPP->Exp_Date);

                    }

                    $COSTpr=$average->AverageCostGet($unit->Product, $unit->Barcode,$Store);


                    if(!empty($EXPO)){

                        $Quntity=$EXPO->Qty;
                    }

                    if(!empty($x)){
                        $Quntity= $x->Qty / $rr->Rate ;
                        if(!empty($EXPO)){

                            $Quntity=$EXPO->Qty;
                        }


                        if($Quntity < 0){

                            $Quntity=0;
                        }

                        if($COSTpr < 0){

                            $COSTpr=0;
                        }



                        array_push($data, [

                            'unit_id'=>$unit->Unit,
                            'unit_name'=>$UnitName,
                            'code' => $unit->Barcode ,
                            'price' => $price ,
                            'rate' => $unit->Product()->first()->Tax()->first()->Rate ,
                            'type' => $unit->Product()->first()->Tax()->first()->Type ,
                            'tax' => $unit->Product()->first()->Tax ,
                            'priceOne' => $unit->Price ,
                            'priceTwo' => $unit->Price_Two ,
                            'priceThree' => $unit->Price_Three,
                            'qty'=>$Quntity,
                            'cost'=>$COSTpr

                        ]);

            }
            }







        }

            return $data;
    }

    public function ProUnitsDataTwo($pro,$store,$p_code)
    {
        $proUnits = ProductUnits::where('Product',$pro)->get();
        $data=[];
        foreach($proUnits as $unit){

            $average = new Average ;
            $id=$unit->Unit;
            $Pro=$pro;
            $code=$p_code;
            $Store=$store;


            if(app()->getLocale() == 'ar' ){
                $UnitName=$unit->Unit()->first()->Name;
            }else{
                $UnitName=$unit->Unit()->first()->NameEn;
            }




            $rr = ProductUnits::where("Unit",$id)->where('Product',$Pro)->first();

            $x = $this->ProAvQties($Store,$Pro,$code);

            $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Pro)->where('Store',$Store)->where('P_Code',$code)->first();
            $EXPO='';
            if(!empty($EXPPPP)){
                $EXPO=$this->ExpireAvQtiesCheck($Store,$Pro,$code,$EXPPPP->Exp_Date);
            }


            $COSTpr=$average->AverageCostGetUnit($Pro,$code,$Store,$id);

            if(!empty($x)){
                $Quntity= $x->Qty / $rr->Rate ;
                if(!empty($EXPO)){

                    $Quntity=$EXPO->Qty;
                }


                if($Quntity < 0){

                    $Quntity=0;
                }

                if($COSTpr < 0){

                    $COSTpr=0;
                }


                array_push($data, [

                    'unit_id'=>$unit->Unit,
                    'unit_name'=>$UnitName,
                    'code' => $rr->Barcode ,
                    'priceOne' => $rr->Price ,
                    'priceTwo' => $rr->Price_Two ,
                    'priceThree' => $rr->Price_Three,
                    'qty'=>$Quntity,
                    'cost'=>$COSTpr

                ]);



            }else{




                $x = $this->ProAvQtiesUnit($Store,$unit->Product,$unit->Barcode,$id);


                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$unit->Product)->where('Store',$Store)->where('P_Code',$unit->Barcode)->first();
                $EXPO='';
                if(!empty($EXPPPP)){

                    $EXPO=$this->ExpireAvQtiesCheck($Store,$unit->Product,$unit->Barcode,$EXPPPP->Exp_Date);

                }

                $COSTpr=$average->AverageCostGet($unit->Product, $unit->Barcode,$Store);


                if(!empty($EXPO)){

                    $Quntity=$EXPO->Qty;
                }

                if(!empty($x)){
                    $Quntity= $x->Qty / $rr->Rate ;
                    if(!empty($EXPO)){

                        $Quntity=$EXPO->Qty;
                    }


                    if($Quntity < 0){

                        $Quntity=0;
                    }

                    if($COSTpr < 0){

                        $COSTpr=0;
                    }



                    array_push($data, [

                        'unit_id'=>$unit->Unit,
                        'unit_name'=>$UnitName,
                        'code' => $unit->Barcode ,
                        'priceOne' => $unit->Price ,
                        'priceTwo' => $unit->Price_Two ,
                        'priceThree' => $unit->Price_Three,
                        'qty'=>$Quntity,
                        'cost'=>$COSTpr

                    ]);

                }
            }







        }

        return $data;
    }


//ProductsFilterApi

    public function ItemsFilterTwoPOS($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $search=$Filter['search'];


        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();

        if(is_numeric($search)){

            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();

        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }

        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();



        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $AvalibleQunatity=$Filter['qty'];


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }
        $Higher=$DES;

        if(  $AvalibleQunatity > 0) {

            $output .= '


        <div class="col-md-3" data-toggle="tooltip" data-placement="top" title="'.$pr.'" id="Row'.$Filter['id'].'">

 <button type="button" data-toggle="tooltip" data-placement="top" title="'.$pr.'" class="btn btn-default waves-effect waves-themed BUT" id="AddBtnPur'.$Filter['id'].'" onclick="Fun('.$Filter['id'].')">
        '.$PrrroName.' ('.$Filter['P_Code'].') '.$ShowGrBr.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
        </button>
        </div>

            ';



        }

        return $output;

    }

    public function ProductsFilterApi($Filter)
    {

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $AvalibleQunatity=$Filter['qty'] / $rr->Rate;


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }
        $Higher=$DES;
        $Array=[];
        if($AvalibleQunatity > 0) {

            $UNITS=$this->ProUnitsData($Filter['product'],$Filter['store'],$Filter['client'],$Filter['P_Code']);
            $Array=[

                'product_name'=>$PrrroName,
                'product_ar_name'=>$Filter['name_ar'],
                'product_en_name'=>$Filter['name_en'],
                'product_id'=>$Filter['product'],
                'virable_one_id'=>$Filter['v1'],
                'virable_two_id'=>$Filter['v2'],
                'virable_one_name'=>$Filter['v_name'],
                'virable_two_name'=>$Filter['vv_name'],
                'product_code'=>$Filter['P_Code'],
                'unit_name'=>$UniiName,
                'unit_id'=>$rr->Unit,
                'unit_default'=>$rr->Unit,
                'units'=>$UNITS,
                'code_default'=>$rr->Barcode,
                'tax_rate'=>$rr->Product()->first()->Tax()->first()->Rate,
                'tax_type'=>$rr->Product()->first()->Tax()->first()->Type,
                'tax_id'=>$rr->Product()->first()->Tax,
                'avalible_qty'=>$AvalibleQunatity,
                'qty'=>1,
                'price'=>$pr,
                'priceOne'=>$rr->Price,
                'priceTwo'=>$rr->Price_Two,
                'priceThree'=>$rr->Price_Three,
                'discount'=>$DES,
                'total_disc_pro'=>$DES,
                'total_before_tax'=>$pr,
                'tax_value'=>0,
                'total'=>$pr,
                'store_id'=>$st->id,
                'store_name'=>$Filter['StoreNemo'],
                'ExpDate'=>'',
                'serial'=>$Filter['serial'],
                'high_disc'=>$Higher,
                'cost_price'=>$COSTpr,
                'weight'=>$weigh,
                'max_sales'=>$maxSa,
                'unit_rate'=>$rr->Rate,
                'sales_pro_desc'=>'',

            ];
        }

        return $Array;

    }


    public function ItemsFilterPOSCat($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;


        $st = Stores::find($Filter['store']);
        $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $AvalibleQunatity=$Filter['qty'];
        $img=$Filter['img'];




        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }

        $Higher=$DES;
        //lw hw serial
        if(empty($Ser)){
        }


        if($AvalibleQunatity > 0) {
            if($Filter['store']  ==  $Filter['pro_store']) {

                $output .= '

  <div class="col-md-2" onclick="Fun('.$Filter['id'].')">
                        <div class="item-details">
                                            '.$img.'
                                            <p>'.$PrrroName.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')</p>
                                            <span>'.$pr.'</span>

 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
             <input type="hidden" class="form-control" id="Row' . $Filter['id'] . '">
         </div>
                                    </div>

            ';


            }
        }

        return $output;

    }


    public function ItemsFilterTwoPOSCat($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();



        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $Higher=$Filter['Higher'];
        $AvalibleQunatity=$Filter['qty'];
        $img=$Filter['img'];

        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }
        $Higher=$DES;

        if(  $AvalibleQunatity > 0) {

            $output .= '


       <div class="col-md-2" onclick="Fun('.$Filter['id'].')">
                        <div class="item-details">
                                            '.$img.'
                                            <p>'.$PrrroName.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')</p>
                                            <span>'.$pr.'</span>
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
                <input type="hidden" class="form-control" id="Row' . $Filter['id'] . '">
        </div>
        </div>

            ';



        }

        return $output;

    }


    //Job Order
    public function ItemsFilterJobOrder($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $TAXESS=Taxes::all();
        $Stores=Stores::all();
        $Executors=Employess::all();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow=ProductUnits::where('Product',$Filter['product'])->where('Rate',1)->first();
        $st=Stores::find($Filter['store']);
        $pr=$rr->Price;
        $units = ProductUnits::where('Product', $Filter['product'])->get();

        $hide=$this->ShowHideColumnJobOrder();
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $HeightShow=$hide['HeightShow'];
        $ThicknessShow=$hide['ThicknessShow'];

        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $Length=$Filter['Length'];
        $Width=$Filter['Width'];
        $Height=$Filter['Height'];
        $Thickness=$Filter['Thickness'];


        $output .= '

       <tr id="Row'.$Filter['product'].'">
        <td>
        '.$PrrroName.' '.$ShowGrBr.'
 <input type="hidden"  id="P_Ar_Name'.$Filter['product'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['product'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['product'].'" value="'.$Filter['product'].'">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$Filter['product'].'" onchange="UnitCodePurchh('.$Filter['product'].')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

        foreach($units as $uni){
            $nam=Measuerments::find($uni->Unit);

            if(app()->getLocale() == 'ar' ){
                $UnitNamme=$nam->Name;
            }else{

                $UnitNamme=$nam->NameEn;
            }
            $output .= '
            <option value="'.$uni->Unit.'"       ';  if ($rr->Unit == $uni->Unit) {   $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';


        }

        $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$Filter['product'].'" class="form-control" value="'.$rr->Barcode.'"  disabled>
         <input type="hidden" id="UnitPurchName'.$Filter['product'].'" value="'.$UniiName.'">
         <input type="hidden" id="TaxRate'.$Filter['product'].'" value="'.$rr->Product()->first()->Tax()->first()->Rate.'">
         <input type="hidden" id="TaxType'.$Filter['product'].'" value="'.$rr->Product()->first()->Tax()->first()->Type.'">
         <input type="hidden" id="PurchTax'.$Filter['product'].'" value="'.$rr->Product()->first()->Tax.'">
        </td>


            <td>
        <input type="number" step="any" id="Length'.$Filter['product'].'" value="'.$Length.'"   class="form-control" onkeyup="PurchTotalL('.$Filter['product'].')" onclick="PurchTotalL('.$Filter['product'].')" >

        </td>

                  <td>
        <input type="number" step="any" id="Width'.$Filter['product'].'" value="'.$Width.'"   class="form-control" onkeyup="PurchTotalL('.$Filter['product'].')" onclick="PurchTotalL('.$Filter['product'].')" >

        </td>



                         <td style="display:'.$HeightShow.'">
        <input type="number" step="any" id="Height'.$Filter['product'].'" value="'.$Height.'"   class="form-control" onkeyup="PurchTotalL('.$Filter['product'].')" onclick="PurchTotalL('.$Filter['product'].')" >

        </td>


                                <td style="display:'.$ThicknessShow.'">
        <input type="number" step="any" id="Thickness'.$Filter['product'].'" value="'.$Thickness.'"   class="form-control" onkeyup="PurchTotalL('.$Filter['product'].')" onclick="PurchTotalL('.$Filter['product'].')" >

        </td>


         <td>
        <input type="number"  step="any" id="Size'.$Filter['product'].'" value="'.$Length * $Width.'" readonly   class="form-control" onkeyup="PurchTotalL('.$Filter['product'].')" onclick="PurchTotalL('.$Filter['product'].')" >

        </td>

       <td>
        <input type="number" step="any" id="Qty'.$Filter['product'].'" value="'.$Length * $Width.'"   class="form-control" onkeyup="PurchTotal('.$Filter['product'].')" onclick="PurchTotal('.$Filter['product'].')" >

        </td>




              <td>

 <input type="number" id="Price'.$Filter['product'].'" step="any"  class="form-control" onkeyup="PurchTotal('.$Filter['product'].')" onclick="PurchTotal('.$Filter['product'].')" value="'.$pr.'"  >

        </td>



                  <td style="display:'.$discShow.'">

 <input type="number" id="Discount'.$Filter['product'].'" step="any"  class="form-control" onkeyup="PurchTotal('.$Filter['product'].')" onclick="PurchTotal('.$Filter['product'].')" value="0" >
  <input type="hidden" id="TDiscPro'.$Filter['product'].'"   class="form-control" value="0" >
<input type="hidden" id="TotalBFTax'.$Filter['product'].'"   class="form-control" >
<input type="hidden" id="Tax'.$Filter['product'].'"   class="form-control" >
  <input type="hidden" id="Total'.$Filter['product'].'"   class="form-control" >
        </td>

      <td style="display:'.$taxShow.'">
   <select class="select2 form-control w-100"    id="OLDTAX'.$Filter['product'].'" onchange="TAXPurch('.$Filter['product'].')">
              ';

        foreach($TAXESS as $tax){
            if(app()->getLocale() == 'ar' ){
                $txNamme=$tax->Name;
            }else{

                $txNamme=$tax->NameEn;
            }

            $output .= '
      <option value="'.$tax->id.'"       ';  if($tax->id == $rr->Product()->first()->Tax){    $output .= '  selected  ';  }   $output .= ' > '.$txNamme.'</option>
                 ';
        }

        $output .= '

                        </select>
        </td>


                <td>
             <select class="select2 form-control w-100"   id="Executor'.$Filter['product'].'" >
                <option value="">  '.trans('admin.Executor').'</option>
              ';

        foreach($Executors as $exe){
            $nam=Measuerments::find($uni->Unit);

            if(app()->getLocale() == 'ar' ){
                $ExeNamme=$exe->Name;
            }else{

                $ExeNamme=$exe->NameEn;
            }
            $output .= '
            <option value="'.$exe->id.'"> '.$ExeNamme.'</option>
                 ';


        }

        $output .= '

                        </select>
        </td>




        <td>
           <input type="hidden" id="StorePurchName'.$Filter['product'].'"   class="form-control"  value="'.$StoreNemo.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed"  id="AddBtnPur'.$Filter['product'].'" onclick="Fun('.$Filter['product'].')">
          <i class="fal fa-plus"></i>
          </button>




          </td>
        </tr>


            ';



        return $output;

    }


    //ItemsFilterExecuteJobOrder
    public function ItemsFilterExecuteJobOrder($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $TAXESS=Taxes::all();
        $Stores=Stores::all();
        $Executors=Employess::all();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow=ProductUnits::where('Product',$Filter['product'])->where('Rate',1)->first();
        $st=Stores::find($Filter['store']);
        $pr=$rr->Price;
        $units = ProductUnits::where('Product', $Filter['product'])->get();

        $hide=$this->ShowHideColumnJobOrder();
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $HeightShow=$hide['HeightShow'];
        $ThicknessShow=$hide['ThicknessShow'];

        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $Length=$Filter['Length'];
        $Width=$Filter['Width'];


        $output .= '

       <tr id="Row'.$Filter['product'].'">
        <td>
        '.$PrrroName.' '.$ShowGrBr.'
 <input type="hidden"  id="P_Ar_Name'.$Filter['product'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['product'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['product'].'" value="'.$Filter['product'].'">
        </td>

        <td>
             <select class="select2 form-control w-100"   id="UnitPurch'.$Filter['product'].'" onchange="UnitCodePurchh('.$Filter['product'].')">
                <option value="">  '.trans('admin.Choice_Unit').'</option>
              ';

        foreach($units as $uni){
            $nam=Measuerments::find($uni->Unit);

            if(app()->getLocale() == 'ar' ){
                $UnitNamme=$nam->Name;
            }else{

                $UnitNamme=$nam->NameEn;
            }
            $output .= '
            <option value="'.$uni->Unit.'"       ';  if ($rr->Unit == $uni->Unit) {    $output .= '  selected  ';  }   $output .= ' > '.$UnitNamme.'</option>
                 ';


        }

        $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch'.$Filter['product'].'" class="form-control" value="'.$rr->Barcode.'"  disabled>
         <input type="hidden" id="UnitPurchName'.$Filter['product'].'" value="'.$UniiName.'">
         <input type="hidden" id="TaxRate'.$Filter['product'].'" value="'.$rr->Product()->first()->Tax()->first()->Rate.'">
         <input type="hidden" id="TaxType'.$Filter['product'].'" value="'.$rr->Product()->first()->Tax()->first()->Type.'">
         <input type="hidden" id="PurchTax'.$Filter['product'].'" value="'.$rr->Product()->first()->Tax.'">
        </td>



       <td>
        <input type="number" step="any" id="Qty'.$Filter['product'].'" value="'.$Length * $Width.'"   class="form-control" onkeyup="PurchTotal('.$Filter['product'].')" onclick="PurchTotal('.$Filter['product'].')" >

        </td>


              <td style="display: none">

 <input type="number" id="Price'.$Filter['product'].'" step="any"  class="form-control" onkeyup="PurchTotal('.$Filter['product'].')" onclick="PurchTotal('.$Filter['product'].')" value="'.$pr.'"  >

        </td>



                  <td  style="display: none">

 <input type="number" id="Discount'.$Filter['product'].'" step="any"  class="form-control" onkeyup="PurchTotal('.$Filter['product'].')" onclick="PurchTotal('.$Filter['product'].')" value="0" >
  <input type="hidden" id="TDiscPro'.$Filter['product'].'"   class="form-control" value="0" >
<input type="hidden" id="TotalBFTax'.$Filter['product'].'"   class="form-control" >
<input type="hidden" id="Tax'.$Filter['product'].'"   class="form-control" >
  <input type="hidden" id="Total'.$Filter['product'].'"   class="form-control" >
        </td>

      <td  style="display: none">
   <select class="select2 form-control w-100"    id="OLDTAX'.$Filter['product'].'" onchange="TAXPurch('.$Filter['product'].')">
              ';

        foreach($TAXESS as $tax){
            if(app()->getLocale() == 'ar' ){
                $txNamme=$tax->Name;
            }else{

                $txNamme=$tax->NameEn;
            }

            $output .= '
      <option value="'.$tax->id.'"       ';  if($tax->id == $rr->Product()->first()->Tax){    $output .= '  selected  ';  }   $output .= ' > '.$txNamme.'</option>
                 ';
        }

        $output .= '

                        </select>
        </td>


                <td style="display: none">
             <select class="select2 form-control w-100"   id="Executor'.$Filter['product'].'" >
                <option value="">  '.trans('admin.Executor').'</option>
              ';

        foreach($Executors as $exe){
            $nam=Measuerments::find($uni->Unit);

            if(app()->getLocale() == 'ar' ){
                $ExeNamme=$exe->Name;
            }else{

                $ExeNamme=$exe->NameEn;
            }
            $output .= '
            <option value="'.$exe->id.'"> '.$ExeNamme.'</option>
                 ';


        }

        $output .= '

                        </select>
        </td>




        <td>
           <input type="hidden" id="StorePurchName'.$Filter['product'].'"   class="form-control"  value="'.$StoreNemo.'" >
 <button type="button" class="btn btn-default waves-effect waves-themed"  id="AddBtnPur'.$Filter['product'].'" onclick="Fun('.$Filter['product'].')">
          <i class="fal fa-plus"></i>
          </button>




          </td>
        </tr>


            ';



        return $output;

    }


    // ==============  Resturant ================

    public function ItemsFilterResturant($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;


        $st = Stores::find($Filter['store']);
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $AdditionsCount=$Filter['AdditionsCount'];
        $AvalibleQunatity=$Filter['qty'];




        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }
        $Higher=$DES;

        //lw hw serial
        if(empty($Ser)){
        }


        if($AvalibleQunatity > 0) {
            if($Filter['store']  ==  $Filter['pro_store']) {

                $output .= '


        <div class="col-md-3" data-toggle="tooltip" data-placement="top" title="'.$pr.'" id="Row'.$Filter['id'].'">

 <button type="button" data-toggle="tooltip" data-placement="top" title="'.$pr.'" class="btn btn-default waves-effect waves-themed BUT" id="AddBtnPur'.$Filter['id'].'" onclick="Fun('.$Filter['id'].')">
        '.$PrrroName.' ('.$Filter['P_Code'].') '.$ShowGrBr.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
             <input type="hidden" id="AV'.$Filter['id'].'" value="0" >
<input type="hidden"  id="AdditionsCount'.$Filter['id'].'" value="'.$AdditionsCount.'">
        </button>
        </div>

            ';


            }
        }

        return $output;

    }

    public function ItemsFilterTwoResturant($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }

        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();



        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $AvalibleQunatity=$Filter['qty'];
        $AdditionsCount=$Filter['AdditionsCount'];


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }
        $Higher=$DES;


        if($Filter['type'] == 3){
            $func=' onclick="FunAV('.$Filter['id'].','.$Filter['product'].')"';
        }else{
            $func='onclick="Fun('.$Filter['id'].')"';
        }



        if(  $AvalibleQunatity > 0) {

            $output .= '


        <div class="col-md-3" data-toggle="tooltip" data-placement="top" title="'.$pr.'" id="Row'.$Filter['id'].'">

 <button type="button" data-toggle="tooltip" data-placement="top" title="'.$pr.'" class="btn btn-default waves-effect waves-themed BUT" id="AddBtnPur'.$Filter['id'].'" '.$func.'>
        '.$PrrroName.' ('.$Filter['P_Code'].') '.$ShowGrBr.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
                            <input type="hidden" id="AV'.$Filter['id'].'" value="'.$Filter['AV'].'" >
<input type="hidden"  id="AdditionsCount'.$Filter['id'].'" value="'.$AdditionsCount.'">

        </button>
        </div>

            ';



        }

        return $output;

    }

    public function ItemsFilterResturantCat($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;


        $st = Stores::find($Filter['store']);
        $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $AvalibleQunatity=$Filter['qty'];
        $img=$Filter['img'];
        $AdditionsCount=$Filter['AdditionsCount'];



        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }

        $Higher=$DES;
        //lw hw serial
        if(empty($Ser)){
        }



        if($Filter['type'] == 3){
            $func=' onclick="FunAV('.$Filter['id'].','.$Filter['product'].')"';
        }else{
            $func='onclick="Fun('.$Filter['id'].')"';
        }



        if($AvalibleQunatity > 0) {
            if($Filter['store']  ==  $Filter['pro_store']) {

                $output .= '

  <div class="col-md-2"  '.$func.'>
                        <div class="item-details">
                                            '.$img.'
                                            <p>'.$PrrroName.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')</p>
                                            <span>'.$pr.'</span>

 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
             <input type="hidden" class="form-control" id="Row' . $Filter['id'] . '">
                  <input type="hidden" id="AV'.$Filter['id'].'"  value="0" >
<input type="hidden"  id="AdditionsCount'.$Filter['id'].'" value="'.$AdditionsCount.'">
         </div>
                                    </div>

            ';


            }
        }

        return $output;

    }


    public function ItemsFilterTwoResturantCat($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();



        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $Higher=$Filter['Higher'];
        $AvalibleQunatity=$Filter['qty'];
        $img=$Filter['img'];
        $AdditionsCount=$Filter['AdditionsCount'];


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }
        $Higher=$DES;
        if($Filter['type'] == 3){
            $func=' onclick="FunAV('.$Filter['id'].','.$Filter['product'].')"';
        }else{
            $func='onclick="Fun('.$Filter['id'].')"';
        }



        if(  $AvalibleQunatity > 0) {

            $output .= '


       <div class="col-md-2" '.$func.'>
                        <div class="item-details">
                                            '.$img.'
                                            <p>'.$PrrroName.' ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')</p>
                                            <span>'.$pr.'</span>
 <input type="hidden"  id="P_Ar_Name'.$Filter['id'].'" value="'.$Filter['name_ar'].'">
        <input type="hidden"  id="P_En_Name'.$Filter['id'].'" value="'.$Filter['name_en'].'">
        <input type="hidden"  id="Product'.$Filter['id'].'" value="'.$Filter['product'].'">
        <input type="hidden"  id="VOne'.$Filter['id'].'" value="'.$Filter['v1'].'">
        <input type="hidden"  id="VTwo'.$Filter['id'].'" value="'.$Filter['v2'].'">
        <input type="hidden"  id="V_Name'.$Filter['id'].'" value="'.$Filter['v_name'].'">
        <input type="hidden"  id="VV_Name'.$Filter['id'].'" value="'.$Filter['vv_name'].'">
        <input type="hidden" id="CodePurch'.$Filter['id'].'" class="form-control" value="'.$Filter['P_Code'].'"  disabled>
               <input type="hidden" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
          <input type="hidden" id="UnitPurch'.$Filter['id'].'" value="'.$rr->Unit.'">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
         <input type="hidden" id="StoreDefault' . $Filter['id'] . '" value="' . $Filter['store'] . '">
         <input type="hidden" id="TaxRate' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Rate . '">
         <input type="hidden" id="TaxType' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax()->first()->Type . '">
         <input type="hidden" id="PurchTax' . $Filter['id'] . '" value="' . $rr->Product()->first()->Tax . '">
         <input type="hidden"  id="AvQty'.$Filter['id'].'" value="'.$AvalibleQunatity.'">
         <input type="hidden"  id="Qty'.$Filter['id'].'" value="1">
         <input type="hidden"  id="Price'.$Filter['id'].'" value="'.$pr.'">
         <input type="hidden"  id="Discount'.$Filter['id'].'" value="'.$DES.'">
          <input type="hidden" id="TDiscPro'.$Filter['id'].'"   class="form-control" value="'.$DES.'" >
         <input type="hidden" id="TotalBFTax'.$Filter['id'].'"  value="'.$pr.'" >
         <input type="hidden" id="Tax'.$Filter['id'].'"   value="0" >
         <input type="hidden" id="Total'.$Filter['id'].'"   value="'.$pr.'" >
        <input type="hidden" id="StorePurchName'.$Filter['id'].'"  value="'.$st->id.'" >
        <input type="hidden" id="ExpDate'.$Filter['id'].'" >
        <input type="hidden" id="serial'.$Filter['id'].'" value="'.$Filter['serial'].'" >
         <input type="hidden"  id="HighDisc'.$Filter['id'].'" value="'.$Higher.'">
<input type="hidden" id="CostPrice'.$Filter['id'].'"  value="'.$COSTpr.'" >
       <input type="hidden" id="weight'.$Filter['id'].'"  value="'.$weigh.'" >
             <input type="hidden" id="maxSales'.$Filter['id'].'"  value="'.$maxSa.'" >
             <input type="hidden" id="UnitRato'.$Filter['id'].'"  value="'.$rr->Rate.'" >
             <input type="hidden" class="form-control" id="SalesProDesc' . $Filter['id'] . '">
                <input type="hidden" class="form-control" id="Row' . $Filter['id'] . '">
                        <input type="hidden" id="AV'.$Filter['id'].'" value="'.$Filter['AV'].'" >
<input type="hidden"  id="AdditionsCount'.$Filter['id'].'" value="'.$AdditionsCount.'">

        </div>
        </div>

            ';



        }

        return $output;

    }




//==========================  Sales ================================


//Create New Bill
public function CreateNewSalesBill($requets , $type)
{

    if(empty($requets['DiscountBill'])){
        $requets['DiscountBill']=0;
    }

    if(empty($requets['Total_Discount'])){
        $requets['Total_Discount']=0;
    }

    $RESIDUAL=  $requets['DiscountBill'] + $requets['Total_Discount']  ;
    $branch=Stores::find($requets['Store']);
    $custG=Customers::where('Account',$requets['Client'])->latest('id')->first();
    $DEEF=SalesDefaultData::latest('id')->first();

    if(empty($requets['TaxBill'])){
        $requets['TaxBill']=null;
    }
    if(empty($requets['DiscountTaxShow'])){
        $requets['DiscountTaxShow']=null;
    }

    if(empty($requets['Sale_Type'])){
        $requets['Sale_Type']='Sales';
    }
    if($requets['Payment_Method'] == 'Cash'){

        if(!empty($requets['Pay'])){

            $paid = $requets['Pay'] ;

        }else{

            $paid = $requets['Total_Price'] ;
        }

    }elseif($requets['Payment_Method']  == 'Later'){

        $paid = $requets['Pay'] ;

    }elseif($requets['Payment_Method']  == 'Installment'){

        $paid = $requets['Pay'] ;

    }elseif($requets['Payment_Method']  == 'Check'){

        $paid = $requets['Total_Price']  ;

    }elseif($requets['Payment_Method']  == 'InstallmentCompanies'){

        $paid = $requets['Total_Price']  ;

    }elseif($requets['Payment_Method']  == 'Cash_Visa' or $requets['Payment_Method'] == 'Visa'){

        $paid = $requets['Total_Price']  ;

    }elseif($requets['Payment_Method']  == 'Cash_Collection'){

        $paid = $requets['Cash_Collection']  ;

    }elseif($requets['Payment_Method']  == 'Delivery'){

        $paid = $requets['Pay'] ;

    }

    if($requets['Payment_Method']  == 'Later'){
        $col=0;
    }else{
        $col=1;
    }

    if(empty($requets['Client_Address'])){
        $requets['Client_Address']=null;
    }

    if(!empty($branch)){
        $BRAAA=$branch->Branch;
    }else{
        $BRAAA=null;
    }


    if(!empty($custG)){
        $CUSTGROP=$custG->Group;
    }else{
        $CUSTGROP=null;
    }

    if($requets['TaxBill'] == 1){
        $lastt=Sales::where('TaxBill',1)->latest('id')->first();

        if(!empty($lastt)){
            $TAXCODEEEEE=$lastt->TaxCode + 1;
        }else{
            $TAXCODEEEEE=1;
        }

    }else{
        $TAXCODEEEEE=0;
    }

    if($requets['DiscountTaxShow'] == 1){

        $discTaxx=$requets['Total_Price'] * (1/100) ;
    }else{

        $discTaxx=0 ;
    }

    if(!empty(auth()->guard('admin')->user()->emp)){
        $emp=auth()->guard('admin')->user()->emp;
    }else{
        $emp=null;
    }

    if($type == 'POS' or $type == 'Resturant'){
        $hold=$requets['Hold'];
        $shift=$requets['Shift_Code'];
        $clientAddress=$requets['Client_Address'];
        $delivery=$requets['Delivery'];

        if(empty($requets['Cashh'])){
            $requets['Cashh']=0;
        }
        $cash= $requets['Cash']  + $requets['Cashh'];
        $visa=$requets['Visa'];

    }else{

        $hold=null;
        $shift=null;
        $clientAddress=null;
        $delivery=null;
        $cash=null;
        $visa=null;
    }

    if(!empty($requets['ProfitTax'])){

        $ProfitTax=$requets['ProfitTax'];
    }else{
        $ProfitTax=0;
    }

    $Total_Net= ($requets['Total_Price'] +  $requets['Total_Taxes']  + $ProfitTax)  - $RESIDUAL ;
    $residual=$Total_Net - $paid ;

    $image=request()->file('File');
    $zFile=$this->UploadFile($image);

if(empty($requets['Delegate'])){
    $requets['Delegate']=null;
}
if(empty($requets['Executor'])){
    $requets['Executor']=null;
}
if(empty($requets['Quote'])){
    $requets['Quote']=null;
}
if(empty($requets['SalesOrder'])){
    $requets['SalesOrder']=null;
}

if(empty($requets['Total_Wight_Bill'])){
    $requets['Total_Wight_Bill']=null;
}

    if(empty($requets['Refernce_Number'])){
        $requets['Refernce_Number']=null;
    }

    if(empty($requets['Later_Due'])){
        $requets['Later_Due']=null;
    }
    if(empty($requets['Cost_Center'])){
        $requets['Cost_Center']=null;
    }


    if(empty($requets['Ship'])){
        $requets['Ship']=null;
    }


    if(empty($requets['TaxOnTotal'])){
        $requets['TaxOnTotal']=null;
    }

    if(empty($requets['TaxOnTotalType'])){
        $requets['TaxOnTotalType']=null;
    }

    if(empty($requets['ProfitTax'])){
        $requets['ProfitTax']=null;
    }
    if(empty($requets['Current_Credit'])){
        $requets['Current_Credit']=null;
    }
    if(empty($requets['ServiceType'])){
        $requets['ServiceType']=null;
    }
    if(empty($requets['ServiceFees'])){
        $requets['ServiceFees']=null;
    }
    if(empty($requets['ServiceValue'])){
        $requets['ServiceValue']=null;
    }

    if(empty($requets['ProfitPrecent'])){
        $requets['ProfitPrecent']=0;
    }






    if($DEEF->SalesOrderType == 1) {
        $cancelOrder=0;
    $DelgateOrder=0;
}else{
        $cancelOrder=0;
        $DelgateOrder=1;
    }


    if($type == 'Resturant'){

        $RecivedOrder=0;
$KitchenEnd=0;
$Witer=$requets['Waiter'];
$ResturantOrderType=$requets['ResturantOrderType'];
$Table=$requets['Table'];
$ServiceType=$requets['ServiceType'];
$ServiceFees=$requets['ServiceFees'];
$ServiceValue=$requets['ServiceValue'];

    }else{

        $RecivedOrder=1;
        $KitchenEnd=1;
        $Witer=null;
        $ResturantOrderType=null;
        $Table=null;
        $ServiceType=$requets['ServiceType'];
        $ServiceFees=$requets['ServiceFees'];
        $ServiceValue=$requets['ServiceValue'];

    }

    $ID = DB::table('sales')->insertGetId(
        array(

            'Date' =>$requets['Date'],
            'Draw' =>$requets['Draw'],
            'DiscountTax' => $discTaxx,
            'Payment_Method' =>$requets['Payment_Method'] ,
            'DiscountBill' =>$requets['DiscountBill'] ,
            'Status' =>$requets['Status'] ,
            'Refernce_Number' =>$requets['Refernce_Number'] ,
            'Note' =>$requets['Note'] ,
            'Product_Numbers' =>$requets['Product_Numbers'] ,
            'Total_Qty' =>$requets['Total_Qty'] ,
            'Total_Discount' => $RESIDUAL,
            'Total_BF_Taxes' =>$requets['Total_BF_Taxes'] ,
            'Total_Taxes' =>$requets['Total_Taxes'] ,
            'Total_Price' =>$requets['Total_Price'] ,
            'Pay' => $paid,
            'File' => $zFile,
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'Safe' =>$requets['Safe'] ,
            'Later_Due' =>$requets['Later_Due'] ,
            'Client' =>$requets['Client'] ,
            'Delegate' =>$requets['Delegate'] ,
            'Executor' =>$requets['Executor'] ,
            'Store' =>$requets['Store'] ,
            'Coin' =>$requets['Coin'] ,
            'Cost_Center' =>$requets['Cost_Center'] ,
            'presenter' =>$requets['presenter'] ,
            'annual_interest' =>$requets['annual_interest'] ,
            'monthly_installment' =>$requets['monthly_installment'] ,
            'Years_Number' =>$requets['Years_Number'] ,
            'total' =>$requets['total'] ,
            'Quote' =>$requets['Quote'] ,
            'Total_Cost' =>$requets['Total_Cost'] ,
            'Ship' =>$requets['Ship'] ,
            'Later_Collection' =>$col,
            'Check_Type' =>$requets['Check_Type'] ,
            'TaxBill' =>$requets['TaxBill'] ,
            'TaxOnTotal' =>$requets['TaxOnTotal'] ,
            'TaxOnTotalType' =>$requets['TaxOnTotalType'] ,
            'ProfitTax' =>$requets['ProfitTax'] ,
            'TaxCode' => $TAXCODEEEEE,
            'Due_Date' =>$requets['Due_Date'] ,
            'InstallCompany' =>$requets['InstallCompany'] ,
            'ContractNumber' =>$requets['ContractNumber'] ,
            'PayFees' =>$requets['PayFees'] ,
            'ServiceFee' => $requets['ServiceFee'] ,
            'CompanyPrecent' =>$requets['CompanyPrecent'] ,
            'ProfitPrecent' =>$requets['ProfitPrecent'] ,
            'Check_Number' =>$requets['Check_Number'] ,
            'SalesOrder' =>$requets['SalesOrder'] ,
            'installment_Num' =>$requets['installment_Num'] ,
            'Date_First_installment' =>$requets['Date_First_installment'] ,
            'Total_Wight_Bill' =>$requets['Total_Wight_Bill'] ,
            'User' => auth()->guard('admin')->user()->id,
            'Client_Address' => $clientAddress,
            'Delivery' => $delivery,
            'Cash' => $cash,
            'Visa' => $visa,
            'Sale_Type' => $type,
            'Hold' =>$hold,
            'Shift_Code' =>$shift,
            'emp' => $emp,
            'Edit' => 0,
            'Delete' => 0,
            'Edit_New_Code' => 0,
            'Total_Net' => $Total_Net,
            'Residual' => $residual,
            'Current_Credit' =>$requets['Current_Credit'],

            'RecivedOrder' => $RecivedOrder,
            'KitchenEnd' => $KitchenEnd,
            'TakeawayStatus' => 0,
            'Delivery_Status' =>0,
            'Witer' => $Witer,
            'ResturantOrderType' => $ResturantOrderType,
            'Table' => $Table,
            'TakeawayTime' => null,
            'KitchenEndTime' => null,
            'RecivedOrderTime' => null,
            'DeliveryTime' => null,
            'ServiceType' => $ServiceType,
            'ServiceFees' => $ServiceFees,
            'ServiceValue' => $ServiceValue,


        )
    );


    //Shift Details
    if($type == 'POS' or $type == 'Resturant'){

        if($requets['Hold'] == 0){

            $SHIFT=Shifts::where('Code',$requets['Shift_Code'])->first();
            $RESIDUAL=$requets['DiscountBill']  +  $requets['Total_Discount'] ;

            if($requets['Payment_Method']  == 'Cash'){

                $cash=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Later'){
                $cash=0;
                $visa=0;
                $later=$paid + $requets['Total_Taxes'] - $RESIDUAL;
                $later_not=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;

            }elseif($requets['Payment_Method'] == 'Installment'){
                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=$paid + $requets['Total_Taxes'] - $RESIDUAL;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Check'){

                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=$paid +  $requets['Total_Taxes'] - $RESIDUAL;
                $inst_comp=0;

            }elseif($requets['Payment_Method'] == 'Cash_Visa'){
                $cash=$requets['Cash'];
                $visa=$requets['Visa'];
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Cash_Collection'){
                $cash=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Delivery'){
                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=$paid;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'InstallmentCompanies'){

                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
            }elseif($requets['Payment_Method'] == 'Visa'){

                $cash=0;
                $visa=$requets['Visa2'];
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }

            $tt=$visa + $cash + $later + $install  + $check  + $delv  + $inst_comp  ;
            $shoft['Total_Cash']=$SHIFT->Total_Cash + $cash;
            $shoft['Total_Later']=$SHIFT->Total_Later + $later;
            $shoft['Total_Visa']=$SHIFT->Total_Visa + $visa;
            $shoft['Total']=$SHIFT->Total +  $tt ;
            $shoft['Total_Later_Not_Paid']=$SHIFT->Total_Later_Not_Paid + $later_not;
            $shoft['Total_Later_Paid']=$SHIFT->Total_Later_Paid + $later;
            $shoft['Total_Installment']=$SHIFT->Total_Installment + $install;
            $shoft['Total_Checks']=$SHIFT->Total_Checks + $check;
            $shoft['Total_Delivery']=$SHIFT->Total_Delivery + $delv;
            $shoft['Total_Installment_Companies']=$SHIFT->Total_Installment_Companies + $inst_comp;

            Shifts::where('id',$SHIFT->id)->update($shoft);

        }
    }


    return $ID ;
}

public function CreateNewSalesBillApi($requets , $type,$admin_id)
{

    if(empty($requets['DiscountBill'])){
        $requets['DiscountBill']=0;
    }

    if(empty($requets['Total_Discount'])){
        $requets['Total_Discount']=0;
    }


    $RESIDUAL=  $requets['DiscountBill'] + $requets['Total_Discount']  ;
    $branch=Stores::find($requets['Store']);
    $custG=Customers::where('Account',$requets['Client'])->latest('id')->first();
    $DEEF=SalesDefaultData::latest('id')->first();

    if(empty($requets['TaxBill'])){
        $requets['TaxBill']=null;
    }

    if(empty($requets['DiscountTaxShow'])){
        $requets['DiscountTaxShow']=null;
    }

    if($requets['Payment_Method'] == 'Cash'){

        if(!empty($requets['Pay'])){

            $paid = $requets['Pay'] ;

        }else{

            $paid = $requets['Total_Price'] ;
        }


    }elseif($requets['Payment_Method']  == 'Later'){

        $paid = $requets['Pay'] ;

    }elseif($requets['Payment_Method']  == 'Installment'){

        $paid = $requets['Pay'] ;

    }elseif($requets['Payment_Method']  == 'Check'){

        $paid = $requets['Total_Price']  ;

    }elseif($requets['Payment_Method']  == 'InstallmentCompanies'){

        $paid = $requets['Total_Price']  ;

    }elseif($requets['Payment_Method']  == 'Cash_Visa' or $requets['Payment_Method'] == 'Visa'){

        $paid = $requets['Total_Price']  ;

    }elseif($requets['Payment_Method']  == 'Cash_Collection'){

        $paid = $requets['Cash_Collection']  ;

    }elseif($requets['Payment_Method']  == 'Delivery'){

        $paid = $requets['Pay'] ;

    }

    if($requets['Payment_Method']  == 'Later'){
        $col=0;
    }else{
        $col=1;
    }

    if(empty($requets['Client_Address'])){
        $requets['Client_Address']=null;
    }

    if(!empty($branch)){
        $BRAAA=$branch->Branch;
    }else{
        $BRAAA=null;
    }


    if(!empty($custG)){
        $CUSTGROP=$custG->Group;
    }else{
        $CUSTGROP=null;
    }

    if($requets['TaxBill'] == 1){
        $lastt=Sales::where('TaxBill',1)->latest('id')->first();

        if(!empty($lastt)){
            $TAXCODEEEEE=$lastt->TaxCode + 1;
        }else{
            $TAXCODEEEEE=1;
        }

    }else{
        $TAXCODEEEEE=0;
    }
    if(empty($requets['DiscountTaxShow'])){
        $requets['DiscountTaxShow']=null;
    }
    if($requets['DiscountTaxShow'] == 1){

        $discTaxx=$requets['Total_Price'] * (1/100) ;
    }else{

        $discTaxx=0 ;
    }

    if(!empty(auth()->guard('admin')->user()->emp)){
        $emp=auth()->guard('admin')->user()->emp;
    }else{
        $emp=null;
    }

    $requets['Sale_Type']='POS';


    if($type == 'POS' or $type == 'Resturant'){
        $hold=$requets['Hold'];
        $shift=$requets['Shift_Code'];
        $clientAddress=$requets['Client_Address'];
        $delivery=$requets['Delivery'];

        if(empty($requets['Cashh'])){
            $requets['Cashh']=0;
        }
        if(empty($requets['Visa2'])){
            $requets['Visa2']=0;
        }
        $cash= $requets['Cash']  + $requets['Cashh'];
        $visa=$requets['Visa'] + $requets['Visa2'];

    }else{

        $hold=null;
        $shift=null;
        $clientAddress=null;
        $delivery=null;
        $cash=null;
        $visa=null;
    }

    if(!empty($requets['ProfitTax'])){

        $ProfitTax=$requets['ProfitTax'];
    }else{
        $ProfitTax=0;
    }

    $Total_Net= ($requets['Total_Price'] +  $requets['Total_Taxes']  + $ProfitTax)  - $RESIDUAL ;
    $residual=$Total_Net - $paid ;

    $image=request()->file('File');
    $zFile=$this->UploadFile($image);

if(empty($requets['Delegate'])){
    $requets['Delegate']=null;
}
if(empty($requets['Executor'])){
    $requets['Executor']=null;
}
if(empty($requets['Quote'])){
    $requets['Quote']=null;
}
if(empty($requets['SalesOrder'])){
    $requets['SalesOrder']=null;
}

if(empty($requets['Total_Wight_Bill'])){
    $requets['Total_Wight_Bill']=null;
}

    if(empty($requets['Refernce_Number'])){
        $requets['Refernce_Number']=null;
    }


    if(empty($requets['Later_Due'])){
        $requets['Later_Due']=null;
    }
    if(empty($requets['Cost_Center'])){
        $requets['Cost_Center']=null;
    }


    if(empty($requets['Ship'])){
        $requets['Ship']=null;
    }


    if(empty($requets['TaxOnTotal'])){
        $requets['TaxOnTotal']=null;
    }

    if(empty($requets['TaxOnTotalType'])){
        $requets['TaxOnTotalType']=null;
    }

    if(empty($requets['ProfitTax'])){
        $requets['ProfitTax']=null;
    }
    if(empty($requets['Current_Credit'])){
        $requets['Current_Credit']=null;
    }
    if(empty($requets['presenter'])){
        $requets['presenter']=null;
    }
    if(empty($requets['annual_interest'])){
        $requets['annual_interest']=null;
    }
    if(empty($requets['monthly_installment'])){
        $requets['monthly_installment']=null;
    }
    if(empty($requets['Years_Number'])){
        $requets['Years_Number']=null;
    }

    if(empty($requets['total'])){
        $requets['total']=null;
    }

    if(empty($requets['Quote'])){
        $requets['Quote']=null;
    }



    if(empty($requets['Check_Type'])){
        $requets['Check_Type']=null;
    }


    if(empty($requets['TaxBill'])){
        $requets['TaxBille']=null;
    }


    if(empty($requets['TaxOnTotal'])){
        $requets['TaxOnTotal']=null;
    }


    if(empty($requets['TaxOnTotalType'])){
        $requets['TaxOnTotalType']=null;
    }


    if(empty($requets['ProfitTax'])){
        $requets['ProfitTax']=null;
    }


    if(empty($requets['Due_Date'])){
        $requets['Due_Date']=null;
    }


    if(empty($requets['InstallCompany'])){
        $requets['InstallCompany']=null;
    }


    if(empty($requets['ContractNumber'])){
        $requets['ContractNumber']=null;
    }


    if(empty($requets['PayFees'])){
        $requets['PayFees']=null;
    }


    if(empty($requets['ServiceFee'])){
        $requets['ServiceFee']=null;
    }


    if(empty($requets['CompanyPrecent'])){
        $requets['CompanyPrecent']=null;
    }


    if(empty($requets['ProfitPrecent'])){
        $requets['ProfitPrecent']=null;
    }


    if(empty($requets['Check_Number'])){
        $requets['Check_Number']=null;
    }


    if(empty($requets['SalesOrder'])){
        $requets['SalesOrder']=null;
    }


    if(empty($requets['installment_Num'])){
        $requets['installment_Num']=null;
    }


    if(empty($requets['Date_First_installment'])){
        $requets['Date_First_installment']=null;
    }


    if(empty($requets['Total_Wight_Bill'])){
        $requets['Total_Wight_Bill']=null;
    }


    if(empty($requets['Hold'])){
        $requets['Hold']=0;
    }




    if($DEEF->SalesOrderType == 1) {
        $cancelOrder=0;
    $DelgateOrder=0;
}else{
        $cancelOrder=0;
        $DelgateOrder=1;
    }

    if(empty($requets['ServiceType'])){
        $requets['ServiceType']=null;
    }
    if(empty($requets['ServiceFees'])){
        $requets['ServiceFees']=null;
    }
    if(empty($requets['ServiceValue'])){
        $requets['ServiceValue']=null;
    }

    if(empty($requets['bill_lat'])){
        $requets['bill_lat']=null;
    }

    if(empty($requets['bill_lng'])){
        $requets['bill_lng']=null;
    }




    if($type == 'Resturant'){

        $RecivedOrder=0;
        $KitchenEnd=0;
        $Witer=$requets['Waiter'];
        $ResturantOrderType=$requets['ResturantOrderType'];
        $Table=$requets['Table'];
        $ServiceType=$requets['ServiceType'];
        $ServiceFees=$requets['ServiceFees'];
        $ServiceValue=$requets['ServiceValue'];
    }else{

        $RecivedOrder=1;
        $KitchenEnd=1;
        $Witer=null;
        $ResturantOrderType=null;
        $Table=null;
        $ServiceType=$requets['ServiceType'];
        $ServiceFees=$requets['ServiceFees'];
        $ServiceValue=$requets['ServiceValue'];


    }


    $ID = DB::table('sales')->insertGetId(
        array(

            'Date' =>$requets['Date'],
            'Draw' =>$requets['Draw'],
            'DiscountTax' => $discTaxx,
            'Payment_Method' =>$requets['Payment_Method'] ,
            'DiscountBill' =>$requets['DiscountBill'] ,
            'Status' =>$requets['Status'] ,
            'Refernce_Number' =>$requets['Refernce_Number'] ,
            'Note' =>$requets['Note'] ,
            'Product_Numbers' =>$requets['Product_Numbers'] ,
            'Total_Qty' =>$requets['Total_Qty'] ,
            'Total_Discount' => $RESIDUAL,
            'Total_BF_Taxes' =>$requets['Total_BF_Taxes'] ,
            'Total_Taxes' =>$requets['Total_Taxes'] ,
            'Total_Price' =>$requets['Total_Price'] ,
            'Pay' => $paid,
            'File' => $zFile,
            'Time' => date("h:i:s a", time()),
            'Branch' => $BRAAA,
            'CustomerGroup' => $CUSTGROP,
            'Safe' =>$requets['Safe'] ,
            'Later_Due' =>$requets['Later_Due'] ,
            'Client' =>$requets['Client'] ,
            'Delegate' =>$requets['Delegate'] ,
            'Executor' =>$requets['Executor'] ,
            'Store' =>$requets['Store'] ,
            'Coin' =>$requets['Coin'] ,
            'Cost_Center' =>$requets['Cost_Center'] ,
            'presenter' =>$requets['presenter'] ,
            'annual_interest' =>$requets['annual_interest'] ,
            'monthly_installment' =>$requets['monthly_installment'] ,
            'Years_Number' =>$requets['Years_Number'] ,
            'total' =>$requets['total'] ,
            'Quote' =>$requets['Quote'] ,
            'Total_Cost' =>$requets['Total_Cost'] ,
            'Ship' =>$requets['Ship'] ,
            'Later_Collection' =>$col,
            'Check_Type' =>$requets['Check_Type'] ,
            'TaxBill' =>$requets['TaxBill'] ,
            'TaxOnTotal' =>$requets['TaxOnTotal'] ,
            'TaxOnTotalType' =>$requets['TaxOnTotalType'] ,
            'ProfitTax' =>$requets['ProfitTax'] ,
            'TaxCode' => $TAXCODEEEEE,
            'Due_Date' =>$requets['Due_Date'] ,
            'InstallCompany' =>$requets['InstallCompany'] ,
            'ContractNumber' =>$requets['ContractNumber'] ,
            'PayFees' =>$requets['PayFees'] ,
            'ServiceFee' => $requets['ServiceFee'] ,
            'CompanyPrecent' =>$requets['CompanyPrecent'] ,
            'ProfitPrecent' =>$requets['ProfitPrecent'] ,
            'Check_Number' =>$requets['Check_Number'] ,
            'SalesOrder' =>$requets['SalesOrder'] ,
            'installment_Num' =>$requets['installment_Num'] ,
            'Date_First_installment' =>$requets['Date_First_installment'] ,
            'Total_Wight_Bill' =>$requets['Total_Wight_Bill'] ,
            'User' => $admin_id,
            'Client_Address' => $clientAddress,
            'Delivery' => $delivery,
            'Cash' => $cash,
            'Visa' => $visa,
            'Sale_Type' => $type,
            'Hold' =>$hold,
            'Shift_Code' =>$shift,
            'emp' => $emp,
            'Edit' => 0,
            'Delete' => 0,
            'Edit_New_Code' => 0,
            'Total_Net' => $Total_Net,
            'Residual' => $residual,
            'Current_Credit' =>$requets['Current_Credit'],
            'bill_lat' =>$requets['bill_lat'],
            'bill_lng' =>$requets['bill_lng'],


            'RecivedOrder' => $RecivedOrder,
            'KitchenEnd' => $KitchenEnd,
            'TakeawayStatus' => 0,
            'Delivery_Status' =>0,
            'Witer' => $Witer,
            'ResturantOrderType' => $ResturantOrderType,
            'Table' => $Table,
            'TakeawayTime' => null,
            'KitchenEndTime' => null,
            'RecivedOrderTime' => null,
            'DeliveryTime' => null,
            'ServiceType' => $ServiceType,
            'ServiceFees' => $ServiceFees,
            'ServiceValue' => $ServiceValue,


        )
    );



    //Shift Details
    if($type == 'POS' or $type == 'Resturant'){

        if($requets['Hold'] == 0){

            $SHIFT=Shifts::where('Code',$requets['Shift_Code'])->first();
            $RESIDUAL=$requets['DiscountBill']  +  $requets['Total_Discount'] ;

            if($requets['Payment_Method']  == 'Cash'){

                $cash=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Later'){
                $cash=0;
                $visa=0;
                $later=$paid + $requets['Total_Taxes'] - $RESIDUAL;
                $later_not=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;

            }elseif($requets['Payment_Method'] == 'Installment'){
                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=$paid + $requets['Total_Taxes'] - $RESIDUAL;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Check'){

                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=$paid +  $requets['Total_Taxes'] - $RESIDUAL;
                $inst_comp=0;

            }elseif($requets['Payment_Method'] == 'Cash_Visa'){
                $cash=$requets['Cash'];
                $visa=$requets['Visa'];
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Cash_Collection'){
                $cash=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'Delivery'){
                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=$paid;
                $check=0;
                $inst_comp=0;
            }elseif($requets['Payment_Method'] == 'InstallmentCompanies'){

                $cash=0;
                $visa=0;
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=$requets['Total_Price'] + $requets['Total_Taxes'] - $RESIDUAL;
            }elseif($requets['Payment_Method'] == 'Visa'){

                $cash=0;
                $visa=$requets['Visa2'];
                $later=0;
                $later_not=0;
                $install=0;
                $delv=0;
                $check=0;
                $inst_comp=0;
            }

            $tt=$visa + $cash + $later + $install  + $check  + $delv  + $inst_comp  ;
            $shoft['Total_Cash']=$SHIFT->Total_Cash + $cash;
            $shoft['Total_Later']=$SHIFT->Total_Later + $later;
            $shoft['Total_Visa']=$SHIFT->Total_Visa + $visa;
            $shoft['Total']=$SHIFT->Total +  $tt ;
            $shoft['Total_Later_Not_Paid']=$SHIFT->Total_Later_Not_Paid + $later_not;
            $shoft['Total_Later_Paid']=$SHIFT->Total_Later_Paid + $later;
            $shoft['Total_Installment']=$SHIFT->Total_Installment + $install;
            $shoft['Total_Checks']=$SHIFT->Total_Checks + $check;
            $shoft['Total_Delivery']=$SHIFT->Total_Delivery + $delv;
            $shoft['Total_Installment_Companies']=$SHIFT->Total_Installment_Companies + $inst_comp;

            Shifts::where('id',$SHIFT->id)->update($shoft);

        }
    }


    return $ID ;
}


//Create New Sales Order
    public function CreateNewSalesOrder($requets , $type)
    {


        $RESIDUAL=  $requets['DiscountBill'] + $requets['Total_Discount']  ;
        $branch=Stores::find($requets['Store']);
        $custG=Customers::where('Account',$requets['Client'])->latest('id')->first();
        $DEEF=SalesDefaultData::orderBy('id','desc')->first();

        if(empty($requets['TaxBill'])){
            $requets['TaxBill']=null;
        }

        if(empty($requets['DiscountTaxShow'])){
            $requets['DiscountTaxShow']=null;
        }

        if($requets['Payment_Method'] == 'Cash'){

            if(!empty($requets['Pay'])){

                $paid = $requets['Pay'] ;

            }else{

                $paid = $requets['Total_Price'] ;
            }

        }elseif($requets['Payment_Method']  == 'Later'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Installment'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Check'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'InstallmentCompanies'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Visa' or $requets['Payment_Method'] == 'Visa'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Collection'){

            $paid = $requets['Cash_Collection']  ;

        }elseif($requets['Payment_Method']  == 'Delivery'){

            $paid = $requets['Pay'] ;

        }

        if($requets['Payment_Method']  == 'Later'){
            $col=0;
        }else{
            $col=1;
        }

        if(!empty($branch)){
            $BRAAA=$branch->Branch;
        }else{
            $BRAAA=null;
        }


        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
        }else{
            $CUSTGROP=null;
        }

        if($requets['TaxBill'] == 1){
            $lastt=Sales::where('TaxBill',1)->latest('id')->first();

            if(!empty($lastt)){
                $TAXCODEEEEE=$lastt->TaxCode + 1;
            }else{
                $TAXCODEEEEE=1;
            }

        }else{
            $TAXCODEEEEE=0;
        }

        if($requets['DiscountTaxShow'] == 1){

            $discTaxx=$requets['Total_Price'] * (1/100) ;
        }else{

            $discTaxx=0 ;
        }

        if(!empty(auth()->guard('admin')->user()->emp)){
            $emp=auth()->guard('admin')->user()->emp;
        }else{
            $emp=null;
        }



        if(empty($requets['Client_Address'])){
            $requets['Client_Address']=null;
        }



        if($type == 'POS' or $type == 'Resturant'){

            $shift=$requets['Shift_Code'];
            $clientAddress=$requets['Client_Address'];
            $delivery=$requets['Delivery'];


        }else{

            $shift=null;
            $clientAddress=null;
            $delivery=null;

        }



        if($type == 'Website'){

            $CuponCode=$requets['CuponCode'];
            $Shipping=$requets['Shipping'];
            $Name=$requets['Name'];
            $Email=$requets['Email'];
            $Phone=$requets['Phone'];
            $OtherPhone=$requets['OtherPhone'];
            $Address_Name=$requets['Address_Name'];
            $Special_MarkAdd=$requets['Special_MarkAdd'];
            $StreetAdd=$requets['StreetAdd'];
            $BulidingAdd=$requets['BulidingAdd'];
            $FloorAdd=$requets['FloorAdd'];
            $FlatAdd=$requets['FlatAdd'];
            $Governrate=$requets['Governrate'];
            $City=$requets['City'];
            $Place=$requets['Place'];
            $LocationAdd=$requets['LocationAdd'];
            $Address_DetailsAdd=$requets['Address_DetailsAdd'];

        }else{

            $CuponCode=null;
            $Shipping=null;
            $Name=null;
            $Email=null;
            $Phone=null;
            $OtherPhone=null;
            $Address_Name=null;
            $Special_MarkAdd=null;
            $StreetAdd=null;
            $BulidingAdd=null;
            $FloorAdd=null;
            $FlatAdd=null;
            $Governrate=null;
            $City=null;
            $Place=null;
            $LocationAdd=null;
            $Address_DetailsAdd=null;

        }



        if(!empty($requets['ProfitTax'])){

            $ProfitTax=$requets['ProfitTax'];
        }else{
            $ProfitTax=0;
        }

        $Total_Net= ($requets['Total_Price'] +  $requets['Total_Taxes']  + $ProfitTax)  - $RESIDUAL ;
        $residual=$Total_Net - $paid ;

        $image=request()->file('File');
        $zFile=$this->UploadFile($image);

        if(empty($requets['Delegate'])){
            $requets['Delegate']=null;
        }
        if(empty($requets['Executor'])){
            $requets['Executor']=null;
        }
        if(empty($requets['Quote'])){
            $requets['Quote']=null;
        }


        if(empty($requets['Total_Wight_Bill'])){
            $requets['Total_Wight_Bill']=null;
        }




        if($DEEF->SalesOrderType == 1){

            $HOLDD=1;
        }else{
            $HOLDD=0;
        }


        if($type == 'POS' or $type == 'Resturant'){

            $HOLD=1;
        }else{
            $HOLD=0;
        }


        if(empty($requets['Refernce_Number'])){
            $requets['Refernce_Number']=null;
        }

        if(empty($requets['Later_Due'])){
            $requets['Later_Due']=null;
        }
    if(empty($requets['Sale_Date'])){
            $requets['Sale_Date']=null;
        }

        if(empty($requets['Cost_Center'])){
            $requets['Cost_Center']=null;
        }

        if(empty($requets['Ship'])){
            $requets['Ship']=null;
        }
        if(empty($requets['TaxOnTotal'])){
            $requets['TaxOnTotal']=null;
        }

        if(empty($requets['TaxOnTotalType'])){
            $requets['TaxOnTotalType']=null;
        }

        if(empty($requets['ProfitTax'])){
            $requets['ProfitTax']=null;
        }
        if(empty($requets['Current_Credit'])){
            $requets['Current_Credit']=null;
        }
        if(empty($requets['Check_Number'])){
            $requets['Check_Number']=null;
        }

        if(empty($requets['Table'])){
            $requets['Table']=null;
        }


        if($type == 'Resturant'){

            $RecivedOrder=0;
            $KitchenEnd=0;
            $Witer=$requets['Waiter'];
            $ResturantOrderType=$requets['ResturantOrderType'];
            $Table=$requets['Table'];

        }else{

            $RecivedOrder=1;
            $KitchenEnd=1;
            $Witer=null;
            $ResturantOrderType=null;
            $Table=null;


        }

        $DEEF=SalesDefaultData::latest('id')->first();
        if($DEEF->SalesOrderType == 1){
            $dele_recived=1;

        }else{

            $dele_recived=0;
        }

        $ID = DB::table('sales_orders')->insertGetId(
            array(


                'Date' => $requets['Date'],
                'Time' => date("h:i:s a", time()),
                'Draw' => $requets['Draw'],
                'Payment_Method' => $requets['Payment_Method'],
                'Status' => $requets['Status'],
                'Refernce_Number' => $requets['Refernce_Number'],
                'Note' => $requets['Note'],
                'Product_Numbers' => $requets['Product_Numbers'],
                'Total_Qty' => $requets['Total_Qty'],
                'Total_Discount' => $requets['Total_Discount'],
                'Total_BF_Taxes' => $requets['Total_BF_Taxes'],
                'Total_Taxes' => $requets['Total_Taxes'],
                'Total_Price' => $requets['Total_Price'],
                'Pay' => $paid,
                'Safe' => $requets['Safe'],
                'Later_Due' => $requets['Later_Due'],
                'Sale_Date' => $requets['Sale_Date'],
                'ToSales' => 0,
                'Client' => $requets['Client'],
                'Delegate' => $requets['Delegate'],
                'Executor' => $requets['Executor'],
                'Store' => $requets['Store'],
                'Coin' => $requets['Coin'],
                'Cost_Center' => $requets['Cost_Center'],
                'presenter' => $requets['presenter'],
                'annual_interest' => $requets['annual_interest'],
                'monthly_installment' => $requets['monthly_installment'],
                'Years_Number' => $requets['Years_Number'],
                'total' => $requets['total'],
                'InstallCompany' => $requets['InstallCompany'],
                'ContractNumber' => $requets['ContractNumber'],
                'PayFees' => $requets['PayFees'],
                'ServiceFee' => $requets['ServiceFee'],
                'CompanyPrecent' => $requets['CompanyPrecent'],
                'DiscountBill' => $requets['DiscountBill'],
                'Quote' => null,
                'installment_Num' => $requets['installment_Num'],
                'ProfitPrecent' => $requets['ProfitPrecent'],
                'Date_First_installment' => $requets['Date_First_installment'],
                'Total_Wight_Bill' => $requets['Total_Wight_Bill'],
                'Delegate_Recived' =>$dele_recived,
                'Delegate_Recived_Time' =>null,
                'To_Sales_Time' =>null,
                'Cancel_Order' =>0,
                'Cancel_Order_Time' =>null,
                'Hold' =>$HOLD,
                'Hold_Qty' =>$HOLDD,
                'User' => auth()->guard('admin')->user()->id,
                'Edit' => 0,
                'Delete' => 0,
                'Edit_New_Code' => 0,
                'Total_Net' => $Total_Net,
                'Residual' => $residual,
                'Current_Credit' =>$requets['Current_Credit'],
                'File' => $zFile,
                'Branch' => $BRAAA,
                'CustomerGroup' => $CUSTGROP,
                'Total_Cost' =>$requets['Total_Cost'] ,
                'Ship' =>$requets['Ship'] ,
                'Check_Type' =>$requets['Check_Type'] ,
                'Due_Date' =>$requets['Due_Date'] ,
                'TaxBill' =>$requets['TaxBill'] ,
                'TaxOnTotal' =>$requets['TaxOnTotal'] ,
                'TaxOnTotalType' =>$requets['TaxOnTotalType'] ,
                'ProfitTax' =>$requets['ProfitTax'] ,
                'TaxCode' => $TAXCODEEEEE,
                'Check_Number' =>$requets['Check_Number'] ,
                'Client_Address' => $clientAddress,
                'Delivery' => $delivery,

                'Shift_Code' =>$shift,
                'Order_Type' =>$type,
                'CuponCode' =>$CuponCode,
                'Shipping' =>$Shipping,
                'Name' =>$Name,
                'Email' =>$Email,
                'Phone' =>$Phone,
                'OtherPhone' =>$OtherPhone,
                'Address_Name' =>$Address_Name,
                'Special_MarkAdd' =>$Special_MarkAdd,
                'StreetAdd' =>$StreetAdd,
                'BulidingAdd' =>$BulidingAdd,
                'FloorAdd' =>$FloorAdd,
                'FlatAdd' =>$FlatAdd,
                'Governrate' =>$Governrate,
                'City' =>$City,
                'Place' =>$Place,
                'LocationAdd' =>$LocationAdd,
                'Address_DetailsAdd' =>$Address_DetailsAdd,

                'RecivedOrder' => $RecivedOrder,
                'KitchenEnd' => $KitchenEnd,
                'TakeawayStatus' => 0,
                'Delivery_Status' =>0,
                'Witer' => $Witer,
                'ResturantOrderType' => $ResturantOrderType,
                'Table' => $Table,
                'TakeawayTime' => null,
                'KitchenEndTime' => null,
                'RecivedOrderTime' => null,
                'DeliveryTime' => null,



            )
        );





        return $ID ;
    }

    public function CreateNewSalesOrderApi($requets , $type,$id)
    {


        $RESIDUAL=  $requets['DiscountBill'] + $requets['Total_Discount']  ;
        $branch=Stores::find($requets['Store']);
        $custG=Customers::where('Account',$requets['Client'])->latest('id')->first();
        $DEEF=SalesDefaultData::orderBy('id','desc')->first();

        if(empty($requets['TaxBill'])){
            $requets['TaxBill']=null;
        }
        if(empty($requets['DiscountTaxShow'])){
            $requets['DiscountTaxShow']=null;
        }

        if($requets['Payment_Method'] == 'Cash'){

            if(!empty($requets['Pay'])){

                $paid = $requets['Pay'] ;

            }else{

                $paid = $requets['Total_Price'] ;
            }

        }elseif($requets['Payment_Method']  == 'Later'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Installment'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Check'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'InstallmentCompanies'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Visa' or $requets['Payment_Method'] == 'Visa'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Collection'){

            $paid = $requets['Cash_Collection']  ;

        }elseif($requets['Payment_Method']  == 'Delivery'){

            $paid = $requets['Pay'] ;

        }

        if($requets['Payment_Method']  == 'Later'){
            $col=0;
        }else{
            $col=1;
        }

        if(!empty($branch)){
            $BRAAA=$branch->Branch;
        }else{
            $BRAAA=null;
        }


        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
        }else{
            $CUSTGROP=null;
        }

        if($requets['TaxBill'] == 1){
            $lastt=Sales::where('TaxBill',1)->latest('id')->first();

            if(!empty($lastt)){
                $TAXCODEEEEE=$lastt->TaxCode + 1;
            }else{
                $TAXCODEEEEE=1;
            }

        }else{
            $TAXCODEEEEE=0;
        }

        if($requets['DiscountTaxShow'] == 1){

            $discTaxx=$requets['Total_Price'] * (1/100) ;
        }else{

            $discTaxx=0 ;
        }

        if(!empty(auth()->guard('admin')->user()->emp)){
            $emp=auth()->guard('admin')->user()->emp;
        }else{
            $emp=null;
        }

        if(empty($requets['Client_Address'])){
            $requets['Client_Address']=null;
        }
        if(empty($requets['Delivery'])){
            $requets['Delivery']=null;
        }

        if($type == 'POS' or $type == 'Resturant'){

            $shift=$requets['Shift_Code'];
            $clientAddress=$requets['Client_Address'];
            $delivery=$requets['Delivery'];


        }else{

            $shift=null;
            $clientAddress=null;
            $delivery=null;

        }

        if($type == 'Website'){

            $CuponCode=$requets['CuponCode'];
            $Shipping=$requets['Shipping'];
            $Name=$requets['Name'];
            $Email=$requets['Email'];
            $Phone=$requets['Phone'];
            $OtherPhone=$requets['OtherPhone'];
            $Address_Name=$requets['Address_Name'];
            $Special_MarkAdd=$requets['Special_MarkAdd'];
            $StreetAdd=$requets['StreetAdd'];
            $BulidingAdd=$requets['BulidingAdd'];
            $FloorAdd=$requets['FloorAdd'];
            $FlatAdd=$requets['FlatAdd'];
            $Governrate=$requets['Governrate'];
            $City=$requets['City'];
            $Place=$requets['Place'];
            $LocationAdd=$requets['LocationAdd'];
            $Address_DetailsAdd=$requets['Address_DetailsAdd'];

        }else{

            $CuponCode=null;
            $Shipping=null;
            $Name=null;
            $Email=null;
            $Phone=null;
            $OtherPhone=null;
            $Address_Name=null;
            $Special_MarkAdd=null;
            $StreetAdd=null;
            $BulidingAdd=null;
            $FloorAdd=null;
            $FlatAdd=null;
            $Governrate=null;
            $City=null;
            $Place=null;
            $LocationAdd=null;
            $Address_DetailsAdd=null;

        }

        if(!empty($requets['ProfitTax'])){

            $ProfitTax=$requets['ProfitTax'];
        }else{
            $ProfitTax=0;
        }

        $Total_Net= ($requets['Total_Price'] +  $requets['Total_Taxes']  + $ProfitTax)  - $RESIDUAL ;
        $residual=$Total_Net - $paid ;

        $image=request()->file('File');
        $zFile=$this->UploadFile($image);

        if(empty($requets['Delegate'])){
            $requets['Delegate']=null;
        }
        if(empty($requets['Executor'])){
            $requets['Executor']=null;
        }
        if(empty($requets['Quote'])){
            $requets['Quote']=null;
        }

        if(empty($requets['Total_Wight_Bill'])){
            $requets['Total_Wight_Bill']=null;
        }

        if($DEEF->SalesOrderType == 1){

            $HOLDD=1;
        }else{
            $HOLDD=0;
        }


        if($type == 'POS' or $type == 'Resturant'){

            $HOLD=1;
        }else{
            $HOLD=0;
        }


        if(empty($requets['Refernce_Number'])){
            $requets['Refernce_Number']=null;
        }

        if(empty($requets['Later_Due'])){
            $requets['Later_Due']=null;
        }
        if(empty($requets['Sale_Date'])){
            $requets['Sale_Date']=null;
        }

        if(empty($requets['Cost_Center'])){
            $requets['Cost_Center']=null;
        }

        if(empty($requets['Ship'])){
            $requets['Ship']=null;
        }

      if(empty($requets['DiscountBill'])){
            $requets['DiscountBill']=null;
        }

        if(empty($requets['Table'])){
            $requets['Table']=null;
        }

        if($type == 'Resturant'){

            $RecivedOrder=0;
            $KitchenEnd=0;
            $Witer=$requets['Waiter'];
            $ResturantOrderType=$requets['ResturantOrderType'];
            $Table=$requets['Table'];

        }else{

            $RecivedOrder=1;
            $KitchenEnd=1;
            $Witer=null;
            $ResturantOrderType=null;
            $Table=null;


        }

        $DEEF=SalesDefaultData::latest('id')->first();
        if($DEEF->SalesOrderType == 1){
            $dele_recived=1;

        }else{

            $dele_recived=0;
        }

        $ID = DB::table('sales_orders')->insertGetId(
            array(


                'Date' => $requets['Date'],
                'Time' => date("h:i:s a", time()),
                'Draw' => $requets['Draw'],
                'Payment_Method' => $requets['Payment_Method'],
                'Status' => $requets['Status'],
                'Refernce_Number' => $requets['Refernce_Number'],
                'Note' => $requets['Note'],
                'Product_Numbers' => $requets['Product_Numbers'],
                'Total_Qty' => $requets['Total_Qty'],
                'Total_Discount' => $requets['Total_Discount'],
                'Total_BF_Taxes' => $requets['Total_BF_Taxes'],
                'Total_Taxes' => $requets['Total_Taxes'],
                'Total_Price' => $requets['Total_Price'],
                'Pay' => $paid,
                'Safe' => $requets['Safe'],
                'Later_Due' => $requets['Later_Due'],
                'Sale_Date' => $requets['Sale_Date'],
                'ToSales' => 0,
                'Client' => $requets['Client'],
                'Delegate' => $requets['Delegate'],
                'Executor' => $requets['Executor'],
                'Store' => $requets['Store'],
                'Coin' => $requets['Coin'],
                'Cost_Center' => $requets['Cost_Center'],
                'presenter' => $requets['presenter'],
                'annual_interest' => $requets['annual_interest'],
                'monthly_installment' => $requets['monthly_installment'],
                'Years_Number' => $requets['Years_Number'],
                'total' => $requets['total'],
                'InstallCompany' => $requets['InstallCompany'],
                'ContractNumber' => $requets['ContractNumber'],
                'PayFees' => $requets['PayFees'],
                'ServiceFee' => $requets['ServiceFee'],
                'CompanyPrecent' => $requets['CompanyPrecent'],
                'Quote' => null,
                'installment_Num' => $requets['installment_Num'],
                'ProfitPrecent' => $requets['ProfitPrecent'],
                'Date_First_installment' => $requets['Date_First_installment'],
                'Total_Wight_Bill' => $requets['Total_Wight_Bill'],
                'Delegate_Recived' =>$dele_recived,
                'Delegate_Recived_Time' =>null,
                'To_Sales_Time' =>null,
                'Cancel_Order' =>0,
                'Cancel_Order_Time' =>null,
                'Hold' =>$HOLD,
                'Hold_Qty' =>$HOLDD,
                'User' => $id,
                'Edit' => 0,
                'Delete' => 0,
                'Edit_New_Code' => 0,
                'Total_Net' => $Total_Net,
                'Residual' => $residual,
                'Current_Credit' =>$requets['Current_Credit'],
                'File' => $zFile,
                'Branch' => $BRAAA,
                'CustomerGroup' => $CUSTGROP,
                'Total_Cost' =>$requets['Total_Cost'] ,
                'Ship' =>$requets['Ship'] ,
                'Check_Type' =>$requets['Check_Type'] ,
                'Due_Date' =>$requets['Due_Date'] ,
                'TaxBill' =>$requets['TaxBill'] ,
                'TaxOnTotal' =>$requets['TaxOnTotal'] ,
                'TaxOnTotalType' =>$requets['TaxOnTotalType'] ,
                'ProfitTax' =>$requets['ProfitTax'] ,
                'TaxCode' => $TAXCODEEEEE,
                'Check_Number' =>$requets['Check_Number'] ,
                'DiscountBill' =>$requets['DiscountBill'] ,
                'Client_Address' => $clientAddress,
                'Delivery' => $delivery,
                'Shift_Code' =>$shift,
                'Order_Type' =>$type,
                'CuponCode' =>$CuponCode,
                'Shipping' =>$Shipping,
                'Name' =>$Name,
                'Email' =>$Email,
                'Phone' =>$Phone,
                'OtherPhone' =>$OtherPhone,
                'Address_Name' =>$Address_Name,
                'Special_MarkAdd' =>$Special_MarkAdd,
                'StreetAdd' =>$StreetAdd,
                'BulidingAdd' =>$BulidingAdd,
                'FloorAdd' =>$FloorAdd,
                'FlatAdd' =>$FlatAdd,
                'Governrate' =>$Governrate,
                'City' =>$City,
                'Place' =>$Place,
                'LocationAdd' =>$LocationAdd,
                'Address_DetailsAdd' =>$Address_DetailsAdd,

                'RecivedOrder' => $RecivedOrder,
                'KitchenEnd' => $KitchenEnd,
                'TakeawayStatus' => 0,
                'Delivery_Status' =>0,
                'Witer' => $Witer,
                'ResturantOrderType' => $ResturantOrderType,
                'Table' => $Table,
                'TakeawayTime' => null,
                'KitchenEndTime' => null,
                'RecivedOrderTime' => null,
                'DeliveryTime' => null,


            )
        );





        return $ID ;
    }



    //CreateSalesSubscribesBill
    public function CreateSalesSubscribesBill($requets)
    {


        if($requets['Payment_Method'] == 'Cash'){


            if(!empty($requets['Total_Price'])){

                $paid = $requets['Total_Price'] ;

            }else{

                $paid = $requets['Total_Price'] ;
            }

        }elseif($requets['Payment_Method'] == 'Later'){

            $paid = $requets['Total_Price'] ;

        }


        $ID = DB::table('sales_subscribes')->insertGetId(
            array(


                'Date' =>$requets['Date'] ,
                'Draw' =>$requets['Draw'] ,
                'Payment_Method' =>$requets['Payment_Method'] ,
                'Notes' =>$requets['Note'] ,
                'Product_Numbers' =>$requets['Product_Numbers'] ,
                'Total_Price' =>$requets['Total_Price'] ,
                'Safe' =>$requets['Safe'] ,
                'Later_Due' =>$requets['Later_Due'] ,
                'Account' =>$requets['Client'] ,
                'Delegate' =>$requets['Delegate'] ,
                'Coin' =>$requets['Coin'] ,
                'Current_Credit' =>$requets['Current_Credit'] ,
                'User' => auth()->guard('admin')->user()->id,

            )
        );





        return $ID ;
    }




//CreateJobOrderBill
    public function CreateJobOrderBill($requets)
    {


        if($requets['Payment_Method'] == 'Cash'){


            if(!empty($requets['Total_Price'])){

                $paid = $requets['Total_Price'] ;

            }else{

                $paid = $requets['Total_Price'] ;
            }

        }elseif($requets['Payment_Method'] == 'Later'){

            $paid = $requets['Pay'] ;

        }

        $branch=Stores::find($requets['Store']);
        $custG=Customers::where('Account',$requets['Client'])->latest('id')->first();

        if(!empty($branch)){
            $BRAAA=$branch->Branch;
        }else{
            $BRAAA=null;
        }


        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
        }else{
            $CUSTGROP=null;
        }
        if($requets['TaxBill'] == 1){
            $lastt=Sales::where('TaxBill',1)->orderBy('id','desc')->first();

            if(!empty($lastt)){
                $TAXCODEEEEE=$lastt->TaxCode + 1;
            }else{
                $TAXCODEEEEE=1;
            }

        }else{
            $TAXCODEEEEE=0;
        }

        if($requets['DiscountTaxShow'] == 1){

            $discTaxx=$requets['Total_Price'] * (1/100) ;
        }else{

            $discTaxx=0 ;
        }

        if(empty($requets['Executorr'])){
            $requets['Executorr']=null;
        }
    if(empty($requets['ProfitPrecent'])){
            $requets['ProfitPrecent']=null;
        }

    if(empty($requets['TaxOnTotal'])){
            $requets['TaxOnTotal']=null;
        }
    if(empty($requets['TaxOnTotalType'])){
            $requets['TaxOnTotalType']=null;
        }
    if(empty($requets['ProfitTax'])){
            $requets['ProfitTax']=null;
        }


        $ID = DB::table('job_orders')->insertGetId(
            array(
                'Date' => $requets['Date'],
                'Time' => date("h:i:s a", time()),
                'Draw' => $requets['Draw'],
                'Payment_Method' => $requets['Payment_Method'],
                'Status' => $requets['Status'],
                'Refernce_Number' => $requets['Refernce_Number'],
                'Note' => $requets['Note'],
                'Product_Numbers' => $requets['Product_Numbers'],
                'Total_Qty' => $requets['Total_Qty'],
                'Total_Discount' => $requets['Total_Discount'],
                'Total_BF_Taxes' => $requets['Total_BF_Taxes'],
                'Total_Taxes' => $requets['Total_Taxes'],
                'Total_Price' => $requets['Total_Price'],
                'Pay' => $paid,
                'Safe' => $requets['Safe'],
                'Later_Due' => $requets['Later_Due'],
                'Later_Collection' => null,
                'Client' => $requets['Client'],
                'Delegate' => $requets['Delegate'],
                'Executor' => $requets['Executorr'],
                'Store' => $requets['Store'],
                'Coin' => $requets['Coin'],
                'Cost_Center' => $requets['Cost_Center'],
                'Recipient' => $requets['Recipient'],
                'RecivedDate' => $requets['RecivedDate'],
                'TransferOrder' => 0,
                'ExecuteOrder' => 0,
                'Branch' => $BRAAA,
                'CustomerGroup' => $CUSTGROP,
                'Total_Cost' => $requets['Total_Cost'],
                'TaxBill' => $requets['TaxBill'],
                'TaxOnTotal' => $requets['TaxOnTotal'],
                'TaxOnTotalType' => $requets['TaxOnTotalType'],
                'ProfitTax' => $requets['ProfitTax'],
                'TaxCode' => $TAXCODEEEEE,
                'ProfitPrecent' => $requets['ProfitPrecent'],
                'DiscountTax' => $discTaxx,
                'Current_Credit' => $requets['Current_Credit'],
                'User' => auth()->guard('admin')->user()->id,
            )
        );


        return $ID ;
    }



//Remove Qties
    public function RemoveQties($id, $type, $new_code)
    {

        $Products=ProductSales::where('Sales',$id)->where('Qty','!=',0)->get();
        $def = StoresDefaultData::orderBy('id', 'desc')->first();


        foreach($Products as $prod){

            if($prod->Product()->first()->P_Type == 'Assembly'){

                $Asembs=AssemblyProducts::where('p_id',$prod->Product)->get();

                foreach($Asembs as $ass){

                    $Quantity = $this->ProAvQties($prod->Store, $ass->Product, $ass->Product_Code);


                    if(!empty($Quantity)){
                        $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                        $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                        $newqty=abs($Quantity->Qty) +  $qq ;

                        ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty]);



                        $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                        $newqty=abs($Quantity->Qty) + $qq ;


                        $newQQty=$unit->Rate * ($prod->Qty * $ass->Qty) ;




                    }


                    if(!empty($prod->Exp_Date)){

                        $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();
                        $qq= $unit->Rate *  $prod->Qty * $ass->Qty;
                        $EXPO=ExpireDateQty::find($prod->Exp_Date);
                        $NewExpQty=$EXPO->Qty +  $qq ;
                        ExpireDateQty::where('id',$prod->Exp_Date)->update(['Qty'=>$NewExpQty]);


                    }



                    if($def->Cost_Price == 2){

                        $Fifos=SalesFifoQty::where('Sales_ID',$id)->get();

                        foreach($Fifos as $fi){

                            if($fi->Sales_Qty >= ($prod->Qty * $ass->Qty) ){

                                $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                                $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                                $newqty=$fi->Sales_Qty + $qq ;

                                SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                                $fio= FifoQty::find($fi->Fifo_ID);

                                $qqq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                                $newqtyy=$fio->Qty +  $qqq ;

                                FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                            }else{

                                $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                                $ressss=($prod->Qty * $ass->Qty) -  $fi->Sales_Qty;
                                $result=($prod->Qty * $ass->Qty) -  $ressss;

                                $qq= $unit->Rate * $result ;

                                $newqty=$fi->Sales_Qty +  $qq ;

                                SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                                $fio= FifoQty::find($fi->Fifo_ID);

                                $newqtyy=$fio->Qty +  $fi->Sales_Qty ;

                                FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                            }





                        }


                    }



                    if ($type == 1) {
                        ProductMoves::where('Type', 'مبيعات')
                            ->where('Product', $ass->Product)
                            ->where('P_Code', $ass->Product_Code)
                            ->where('Bill_Num', $prod->Sales()->first()->Code)
                            ->update(['Delete' => 1]);

                    } else {

                        ProductMoves::where('Type', 'مبيعات')
                            ->where('Product', $ass->Product)
                            ->where('P_Code', $ass->Product_Code)
                            ->where('Bill_Num', $prod->Sales()->first()->Code)
                            ->update(['Edit' => 1, 'Edit_New_Code' => $new_code]);


                    }




                }

            }

            if($prod->Product()->first()->P_Type == 'Variable_Aggregate'){


                $AVs=VAQty::where('Product',$prod->Product)->where('SubV',$prod->SubVID)->get();

                foreach($AVs as $av){

                    $Quantity=$this->ProAvQties($prod->Store,$av->ProductID,$av->VAProductID()->first()->Product_Code);

                    if(!empty($Quantity)){


                        $unit=ProductUnits::where('Unit',$av->VAProductID()->first()->Unit)->where('Product',$av->ProductID)->first();
                        $qq= $unit->Rate * ($prod->Qty * $av->Qty) ;
                        $newqty=$Quantity->Qty +  $qq ;


                        $prooooo=Products::find($av->ProductID);

                        $plow=ProductUnits::where('Product',$av->ProductID)->where('Rate',1)->first();
                        $pp=ProductUnits::where('Product',$av->ProductID)->where('Unit',$av->VAProductID()->first()->Unit)->first();


                        if($def->Cost_Price == 2){

                            $totCost=0;

                            $rr = ProductUnits::where("Unit",$av->VAProductID()->first()->Unit)->where('Product',$av->ProductID)->first();
                            $fifo=$this->FifoAvQtyDate($prod->Store,$av->ProductID,$av->VAProductID()->first()->Product_Code);

                            if(!empty($fifo)){

                                if($fifo->Qty == 0){



                                    $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    if($NNQuntatity == 0){


                                        $NNQuntatity=$this->FindQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date);


                                    }else{



                                        if($NNQuntatity >= ($prod->Qty * $av->Qty)){

                                            $totCost += $fifo->Cost_Price * $prod->Qty  ;

                                        }else{

                                            $res=($prod->Qty  * $av->Qty) + $NNQuntatity ;


                                            $totCost += $fifo->Cost_Price * $NNQuntatity ;

                                            $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                            $totCost +=$ResdiualCost;

                                        }


                                    }



                                }else{


                                    if($fifo->Qty >= ($prod->Qty  * $av->Qty)){

                                        $totCost += $fifo->Cost_Price * ($prod->Qty * $av->Qty) ;

                                    }else{

                                        $res=($prod->Qty  * $av->Qty) + $fifo->Qty ;


                                        $totCost += $fifo->Cost_Price * $fifo->Qty ;

                                        $ResdiualCost=$this->MoreThanQty($fifo->Store,$fifo->Product,$fifo->P_Code,$fifo->id,$fifo->Purchases_Date,$res);

                                        $totCost +=$ResdiualCost;

                                    }



                                }


                            }

                            $newQQty= $unit->Rate * ($prod->Qty  * $av->Qty) ;
                            $CostTotalSale=$totCost;

                            $in=0;
                            $out=$CostTotalSale;

                            $current=$newqty *  $totCost;

                            $cur= $totCost ;
                            $ty= $totCost / $newQQty;


                                ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur]);



                        }else{


                            $average=new Average();
                            $ty=$average->AverageCostGetUnit($av->ProductID,$av->VAProductID()->first()->Product_Code,$prod->Store,$av->VAProductID()->first()->Unit);


                            $newQQty= $unit->Rate * ($prod->Qty  * $av->Qty) ;
                            $CostTotalSale=$ty ;
                            $in=0;
                            $out=$CostTotalSale;


                            $current= $newqty  * ($ty / $unit->Rate) ;

                            $cur=$newqty * $ty ;

                                ProductsQty::where('id', $Quantity->id)->update(['Qty' => $newqty, 'Price' => $ty, 'TotalCost' => $cur]);


                        }



                            //Expire Date
                            if (!empty($prod->Exp_Date)) {
                                $unit = ProductUnits::where('Unit', $av->VAProductID()->first()->Unit)->where('Product', $av->ProductID)->first();

                                $qq = $unit->Rate *( $prod->Qty * $av->Qty);


                                $EXPO = ExpireDateQty::find($prod->Exp_Date);
                                $NewExpQty = $EXPO->Qty + $qq;


                                ExpireDateQty::where('id', $prod->Exp_Date)->update(['Qty' => $NewExpQty]);


                            }

                            //Fifo
                            if ($def->Cost_Price == 2) {

                                $fifo=$this->FifoAvQtyDate($prod->Store,$av->ProductID, $av->VAProductID()->first()->Product_Code);


                                if (!empty($fifo)) {

                                    if ($fifo->Qty >= ($prod->Qty * $av->Qty)) {


                                        $unit = ProductUnits::where('Unit', $av->VAProductID()->first()->Unit)->where('Product', $av->ProductID)->first();

                                        $qq = $unit->Rate * ($prod->Qty * $av->Qty);

                                        $newqty = $fifo->Qty + $qq;

                                        FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);


                                        $fifQty['Sales_Qty'] = ($prod->Qty * $av->Qty);
                                        $fifQty['Sales_ID'] = $prod->Sales;
                                        $fifQty['Fifo_ID'] = $fifo->id;
                                        $fifQty['Store'] = $fifo->Store;
                                        $fifQty['Product'] = $fifo->Product;
                                        $fifQty['Cost_Price'] = $fifo->Cost_Price;
                                        $fifQty['Purchases_Date'] = $fifo->Purchases_Date;

                                        SalesFifoQty::create($fifQty);


                                    } else {


                                        $resdiualQty = ($prod->Qty * $av->Qty) - $fifo->Qty;

                                        $unit = ProductUnits::where('Unit', $av->VAProductID()->first()->Unit)->where('Product', $av->ProductID)->first();

                                        $qq = $unit->Rate * ($fifo->Qty * $av->Qty);

                                        $newqty = $fifo->Qty + $qq;

                                        FifoQty::where('id', $fifo->id)->update(['Qty' => $newqty]);


                                        $fifQty['Sales_Qty'] = $fifo->Qty;
                                        $fifQty['Sales_ID'] = $prod->Sales;
                                        $fifQty['Fifo_ID'] = $fifo->id;
                                        $fifQty['Store'] = $fifo->Store;
                                        $fifQty['Product'] = $fifo->Product;
                                        $fifQty['Cost_Price'] = $fifo->Cost_Price;
                                        $fifQty['Purchases_Date'] = $fifo->Purchases_Date;

                                        SalesFifoQty::create($fifQty);

                                        $ResdiualCost = $this->FifoStoreAssemblyQty($fifo->Store, $fifo->Product, $fifo->P_Code, $fifo->id, $fifo->Purchases_Date, $resdiualQty, $av->VAProductID()->first()->Unit, $av->Qty, $prod->Sales);


                                    }


                                }


                            }


                        if ($type == 1) {
                            ProductMoves::where('Type', 'مبيعات')
                                ->where('Product', $av->ProductID)
                                ->where('P_Code', $av->VAProductID()->first()->Product_Code)
                                ->where('Bill_Num', $prod->Sales()->first()->Code)
                                ->update(['Delete' => 1]);

                        } else {

                            ProductMoves::where('Type', 'مبيعات')
                                ->where('Product', $av->ProductID)
                                ->where('P_Code', $av->VAProductID()->first()->Product_Code)
                                ->where('Bill_Num', $prod->Sales()->first()->Code)
                                ->update(['Edit' => 1, 'Edit_New_Code' => $new_code]);


                        }



                    }



                }



            }


            if($prod->Product()->first()->P_Type != 'Service' or $prod->Product()->first()->P_Type != 'Assembly' and $prod->P_Type != 'Variable_Aggregate'){

                $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                $qq= $unit->Rate * $prod->Qty ;

                $PR = $this->ProAvQties($prod->Store, $prod->Product, $prod->Product_Code);

                if(!empty($PR)){
                    $newqty=$PR->Qty + $qq ;

                    ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                }



                if(!empty($prod->Exp_Date)){

                    $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();
                    $qq= $unit->Rate *  $prod->Qty;
                    $EXPO=ExpireDateQty::find($prod->Exp_Date);
                    $NewExpQty=$EXPO->Qty +  $qq ;
                    ExpireDateQty::where('id',$prod->Exp_Date)->update(['Qty'=>$NewExpQty]);


                }


                if($def->Cost_Price == 2){

                    $Fifos=SalesFifoQty::where('Sales_ID',$id)->get();

                    foreach($Fifos as $fi){




                        if($fi->Sales_Qty >= $prod->Qty ){

                            $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                            $qq= $unit->Rate * $prod->Qty ;

                            $newqty=$fi->Sales_Qty -  $qq ;

                            SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                            $fio= FifoQty::find($fi->Fifo_ID);

                            $qqq= $unit->Rate * $prod->Qty ;

                            $newqtyy=$fio->Qty +  $qqq ;

                            FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                        }else{

                            $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                            $ressss=$prod->Qty -  $fi->Sales_Qty;
                            $result=$prod->Qty -  $ressss;

                            $qq= $unit->Rate * $result ;

                            $newqty=$fi->Sales_Qty -  $qq ;

                            SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                            $fio= FifoQty::find($fi->Fifo_ID);

                            $newqtyy=$fio->Qty +  $fi->Sales_Qty ;

                            FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                        }





                    }


                }


                if ($type == 1) {
                    ProductMoves::where('Type', 'مبيعات')
                        ->where('Product', $prod->Product)
                        ->where('P_Code', $prod->Product_Code)
                        ->where('Bill_Num', $prod->Sales()->first()->Code)
                        ->update(['Delete' => 1]);

                } else {

                    ProductMoves::where('Type', 'مبيعات')
                        ->where('Product', $prod->Product)
                        ->where('P_Code', $prod->Product_Code)
                        ->where('Bill_Num', $prod->Sales()->first()->Code)
                        ->update(['Edit' => 1, 'Edit_New_Code' => $new_code]);


                }


            }
        }


    }

//RemoveQtiesWithout
    public function RemoveQtiesWithout($id, $type, $new_code)
    {
        $Products=ProductReturnWithoutBill::where('Bill',$id)->get();

        $def = StoresDefaultData::orderBy('id', 'desc')->first();

        foreach ($Products as $prod) {

            $unit = ProductUnits::where('Unit', $prod->Unit)->where('Product', $prod->Product)->first();

            $qq = $unit->Rate * $prod->Qty;
            $PR = $this->ProAvQties($prod->Store, $prod->Product, $prod->Product_Code);

            if (!empty($PR)) {

                $newqty = $PR->Qty - $qq;
                ProductsQty::where('id', $PR->id)->update(['Qty' => $newqty]);

            }

            if (!empty($prod->Exp_Date)) {

                $PREX = $this->ExpireAvQtiesCheck($prod->Store, $prod->Product, $prod->Product_Code, $prod->Exp_Date);

                if (!empty($PREX)) {

                    $newqtyEX = $PREX->Qty - $qq;
                    ExpireDateQty::where('id', $PREX->id)->update(['Qty' => $newqtyEX]);

                }

            }


            //Fifo Purchases

            if ($def->Cost_Price == 2) {


                $fifo = $this->FifoAvQty($prod->Store, $prod->Product, $prod->Product_Code, $prod->Date);

                if (!empty($fifo)) {

                    $newqtyFifo = $fifo->Qty - $qq;
                    FifoQty::where('id', $fifo->id)->update(['Qty' => $newqtyFifo]);


                }


            }


                ProductMoves::where('Type', 'مرتجع بدون فاتورة')
                    ->where('Product', $prod->Product)
                    ->where('P_Code', $prod->Product_Code)
                    ->where('Bill_Num', $prod->Bill()->first()->Code)
                    ->update(['Delete' => 1]);



        }

    }


    //Remove Hold
    public function RemoveHoldQties($id)
    {

        $Products=ProductSalesOrder::where('SalesOrder',$id)->get();
        $def = StoresDefaultData::orderBy('id', 'desc')->first();

        foreach($Products as $prod){

            if($prod->Product()->first()->P_Type == 'Assembly'){

                $Asembs=AssemblyProducts::where('p_id',$prod->Product)->get();

                foreach($Asembs as $ass){

                    $Quantity = $this->ProAvQties($prod->Store, $ass->Product, $ass->Product_Code);


                    if(!empty($Quantity)){
                        $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                        $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                        $newqty=abs($Quantity->Qty) +  $qq ;
                        $holdqty=abs($Quantity->Hold_Qty) -  $qq ;

                        if($holdqty < 0){
                            return 5;
                        }
                        ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Hold_Qty'=>$holdqty]);

                    }


                    if(!empty($prod->Exp_Date)){

                        $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();
                        $qq= $unit->Rate *  $prod->Qty * $ass->Qty;
                        $EXPO=ExpireDateQty::find($prod->Exp_Date);
                        $NewExpQty=$EXPO->Qty +  $qq ;
                        $HoldExpQty=$EXPO->Hold_Qty -  $qq ;
                        if($HoldExpQty < 0){
                            return 5;
                        }
                        ExpireDateQty::where('id',$prod->Exp_Date)->update(['Qty'=>$NewExpQty,'Hold_Qty'=>$HoldExpQty]);


                    }



                    if($def->Cost_Price == 2){

                        $Fifos=SalesFifoQty::where('Sales_ID',$id)->get();

                        foreach($Fifos as $fi){

                            if($fi->Sales_Qty >= ($prod->Qty * $ass->Qty) ){

                                $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                                $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                                $newqty=$fi->Sales_Qty + $qq ;


                                $fio= FifoQty::find($fi->Fifo_ID);

                                $qqq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                                $newqtyy=$fio->Qty +  $qqq ;
                                $holdqtyy=$fio->Hold_Qty -  $qqq ;

                                if($holdqtyy < 0){
                                    return 5;
                                }
                                FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy,'Hold_Qty'=>$holdqtyy]);


                            }else{

                                $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                                $ressss=($prod->Qty * $ass->Qty) -  $fi->Sales_Qty;
                                $result=($prod->Qty * $ass->Qty) -  $ressss;

                                $qq= $unit->Rate * $result ;

                                $newqty=$fi->Sales_Qty +  $qq ;



                                $fio= FifoQty::find($fi->Fifo_ID);

                                $newqtyy=$fio->Qty +  $fi->Sales_Qty ;
                                $holdqtyy=$fio->Hold_Qty -  $fi->Sales_Qty ;

                                if($holdqtyy < 0){
                                    return 5;
                                }
                                FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy,'Hold_Qty'=>$holdqtyy]);


                            }





                        }


                    }


                }

            }


            if($prod->Product()->first()->P_Type != 'Service' or $prod->Product()->first()->P_Type != 'Assembly'){

                $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                $qq= $unit->Rate * $prod->Qty ;

                $PR = $this->ProAvQties($prod->Store, $prod->Product, $prod->Product_Code);

                if(!empty($PR)){
                    $newqty=$PR->Qty + $qq ;
                    $holdqty=$PR->Hold_Qty - $qq ;

                    if($holdqty < 0){
                        return 5;
                    }
                    ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty,'Hold_Qty'=>$holdqty]);

                }



                if(!empty($prod->Exp_Date)){

                    $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();
                    $qq= $unit->Rate *  $prod->Qty;
                    $EXPO=ExpireDateQty::find($prod->Exp_Date);
                    $NewExpQty=$EXPO->Qty +  $qq ;
                    $NewExpHoldQty=$EXPO->Hold_Qty -  $qq ;
                    if($NewExpHoldQty < 0){
                        return 5;
                    }
                    ExpireDateQty::where('id',$prod->Exp_Date)->update(['Qty'=>$NewExpQty,'Hold_Qty'=>$NewExpHoldQty]);


                }


                if($def->Cost_Price == 2){

                    $Fifos=SalesFifoQty::where('Sales_ID',$id)->get();

                    foreach($Fifos as $fi){

                        if($fi->Sales_Qty >= $prod->Qty ){

                            $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                            $fio= FifoQty::find($fi->Fifo_ID);

                            $qqq= $unit->Rate * $prod->Qty ;

                            $newqtyy=$fio->Qty +  $qqq ;
                            $holdqtyy=$fio->Hold_Qty -  $qqq ;
                            if($holdqtyy < 0){
                                return 5;
                            }
                            FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy,'Hold_Qty'=>$holdqtyy]);


                        }else{

                            $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                            $ressss=$prod->Qty -  $fi->Sales_Qty;
                            $result=$prod->Qty -  $ressss;

                            $qq= $unit->Rate * $result ;

                            $fio= FifoQty::find($fi->Fifo_ID);

                            $newqtyy=$fio->Qty +  $fi->Sales_Qty ;
                            $holdqtyy=$fio->Hold_Qty -  $fi->Sales_Qty ;

                            if($holdqtyy < 0){
                                return 5;
                            }

                            FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy,'Hold_Qty'=>$holdqtyy]);

                        }





                    }


                }




            }
        }

        return 0;
    }

    //CreateBillOrder
    public function CreateBillOrder($requets ,$table ,$details,$type)
    {


        $RESIDUAL=  $requets['DiscountBill'] + $requets['Total_Discount']  ;
        $branch=Stores::find($requets['Store']);
        $custG=Customers::where('Account',$requets['Client'])->latest('id')->first();

        if($requets['Payment_Method'] == 'Cash'){

            if(!empty($requets['Pay'])){

                $paid = $requets['Pay'] ;

            }else{

                $paid = $requets['Total_Price'] ;
            }

        }elseif($requets['Payment_Method']  == 'Later'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Installment'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Check'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'InstallmentCompanies'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Visa' or $requets['Payment_Method'] == 'Visa'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Collection'){

            $paid = $requets['Cash_Collection']  ;

        }elseif($requets['Payment_Method']  == 'Delivery'){

            $paid = $requets['Pay'] ;

        }

        if($requets['Payment_Method']  == 'Later'){
            $col=0;
        }else{
            $col=1;
        }

        if(!empty($branch)){
            $BRAAA=$branch->Branch;
        }else{
            $BRAAA=null;
        }


        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
        }else{
            $CUSTGROP=null;
        }

        if($requets['TaxBill'] == 1){
            $lastt=Sales::where('TaxBill',1)->latest('id')->first();

            if(!empty($lastt)){
                $TAXCODEEEEE=$lastt->TaxCode + 1;
            }else{
                $TAXCODEEEEE=1;
            }

        }else{
            $TAXCODEEEEE=0;
        }

        if($requets['DiscountTaxShow'] == 1){

            $discTaxx=$requets['Total_Price'] * (1/100) ;
        }else{

            $discTaxx=0 ;
        }

        if(!empty(auth()->guard('admin')->user()->emp)){
            $emp=auth()->guard('admin')->user()->emp;
        }else{
            $emp=null;
        }

        if(request('Sale_Type') == 'POS'){
            $hold=$requets['Hold'];
            $shift=$requets['Shift_Code'];
            $clientAddress=$requets['Client_Address'];
            $delivery=$requets['Delivery'];
            $cash= $requets['Cash']  + $requets['Cashh'];
            $visa=$requets['Visa'];

        }else{

            $hold=null;
            $shift=null;
            $clientAddress=null;
            $delivery=null;
            $cash=null;
            $visa=null;
        }

        if(!empty($requets['ProfitTax'])){

            $ProfitTax=$requets['ProfitTax'];
        }else{
            $ProfitTax=0;
        }

        $Total_Net= ($requets['Total_Price'] +  $requets['Total_Taxes']  + $ProfitTax)  - $RESIDUAL ;
        $residual=$Total_Net - $paid ;

        $image=request()->file('File');
        $zFile=$this->UploadFile($image);

        if(empty($requets['Delegate'])){
            $requets['Delegate']=null;
        }
        if(empty($requets['Executor'])){
            $requets['Executor']=null;
        }
        if(empty($requets['Quote'])){
            $requets['Quote']=null;
        }
        if(empty($requets['SalesOrder'])){
            $requets['SalesOrder']=null;
        }

        if(empty($requets['Total_Wight_Bill'])){
            $requets['Total_Wight_Bill']=null;
        }

        if(empty($requets['TaxOnTotal'])){
            $requets['TaxOnTotal']=null;
        }

        if(empty($requets['TaxOnTotal'])){
            $requets['TaxOnTotal']=null;
        }

        if(empty($requets['TaxOnTotalType'])){
            $requets['TaxOnTotalType']=null;
        }

        if(empty($requets['ProfitTax'])){
            $requets['ProfitTax']=null;
        }
        if(empty($requets['Current_Credit'])){
            $requets['Current_Credit']=null;
        }
        if(empty($requets['Check_Number'])){
            $requets['Check_Number']=null;
        }

        $ID = DB::table($table)->insertGetId(
            array(

                'Date' =>$requets['Date'],
                'Draw' =>$requets['Draw'],
                'DiscountTax' => $discTaxx,
                'Payment_Method' =>$requets['Payment_Method'] ,
                'Status' =>$requets['Status'] ,
                'Refernce_Number' =>$requets['Refernce_Number'] ,
                'Note' =>$requets['Note'] ,
                'Product_Numbers' =>$requets['Product_Numbers'] ,
                'Total_Qty' =>$requets['Total_Qty'] ,
                'Total_Discount' => $RESIDUAL,
                'Total_BF_Taxes' =>$requets['Total_BF_Taxes'] ,
                'Total_Taxes' =>$requets['Total_Taxes'] ,
                'Total_Price' =>$requets['Total_Price'] ,
                'Pay' => $paid,
                'File' => $zFile,
                'Time' => date("h:i:s a", time()),
                'Branch' => $BRAAA,
                'CustomerGroup' => $CUSTGROP,
                'Safe' =>$requets['Safe'] ,
                'Later_Due' =>$requets['Later_Due'] ,
                'Client' =>$requets['Client'] ,
                'Delegate' =>$requets['Delegate'] ,
                'Executor' =>$requets['Executor'] ,
                'Store' =>$requets['Store'] ,
                'Coin' =>$requets['Coin'] ,
                'Cost_Center' =>$requets['Cost_Center'] ,
                'presenter' =>$requets['presenter'] ,
                'annual_interest' =>$requets['annual_interest'] ,
                'monthly_installment' =>$requets['monthly_installment'] ,
                'Years_Number' =>$requets['Years_Number'] ,
                'total' =>$requets['total'] ,
                'Total_Cost' =>$requets['Total_Cost'] ,
                'Shipping' =>$requets['Ship'] ,
                'Ship' =>$requets['Ship'] ,
                'Check_Type' =>$requets['Check_Type'] ,
                'TaxBill' =>$requets['TaxBill'] ,
                'TaxOnTotal' =>$requets['TaxOnTotal'] ,
                'TaxOnTotalType' =>$requets['TaxOnTotalType'] ,
                'ProfitTax' =>$requets['ProfitTax'] ,
                'TaxCode' => $TAXCODEEEEE,
                'Due_Date' =>$requets['Due_Date'] ,
                'InstallCompany' =>$requets['InstallCompany'] ,
                'ContractNumber' =>$requets['ContractNumber'] ,
                'PayFees' =>$requets['PayFees'] ,
                'ServiceFee' => $requets['ServiceFee'] ,
                'CompanyPrecent' =>$requets['CompanyPrecent'] ,
                'ProfitPrecent' =>$requets['ProfitPrecent'] ,
                'Check_Number' =>$requets['Check_Number'] ,
                'installment_Num' =>$requets['installment_Num'] ,
                'Date_First_installment' =>$requets['Date_First_installment'] ,
                'Total_Wight_Bill' =>$requets['Total_Wight_Bill'] ,
                'User' => auth()->guard('admin')->user()->id,
                'Client_Address' => $clientAddress,
                'Delivery' => $delivery,
                'Delivery_Status' =>0,
                'Order_Type' => $table,
                'Shift_Code' =>$shift,
                'Edit' => 0,
                'Delete' => 0,
                'Edit_New_Code' => 0,
                'ToSales' => 0,
                'Total_Net' => $Total_Net,
                'Residual' => $residual,
                'Current_Credit' =>$requets['Current_Credit'],
                'Sale_Date' =>$requets['Sale_Date'],
                'DiscountBill' =>$requets['DiscountBill'],


            )
        );




        if(!empty($requets['Unit'])){


            $P_Ar_Name=$requets['P_Ar_Name'];
            $P_En_Name=$requets['P_En_Name'];
            $Unit=$requets['Unit'];
            $P_Code=$requets['P_Code'];
            $Qty=$requets['Qty'];
            $AvQty=$requets['AvQty'];
            $Price=$requets['Price'];
            $Discount=$requets['Discount'];
            $TotalBFTax=$requets['TotalBFTax'];
            $TotalTax=$requets['TotalTax'];
            $PurchTax=$requets['PurchTax'];
            $Total=$requets['Total'];
            $StorePurch=$requets['StorePurch'];
            $Product=$requets['Product'];
            $VOne=$requets['VOne'];
            $VTwo=$requets['VTwo'];
            $V_Name=$requets['V_Name'];
            $VV_Name=$requets['VV_Name'];
            $Exp_Date=$requets['Exp_Date'];
            $Patch_Number=$requets['Patch_Number'];
            $TDiscount=$requets['TDiscPro'];
            $CostPrice=$requets['CostPrice'];
            $Total_Wight=$requets['Total_Wight'];
            $weight=$requets['weight'];
            $UnitRate=$requets['UnitRate'];
            $SalesProDesc=$requets['SalesProDesc'];
            $TotCostNew=$requets['TotCostNew'];
            $Total_Net=$requets['Total_Net'];


            for($i=0 ; $i < count($Unit) ; $i++){

                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
                $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();
                $rr = ProductUnits::where("Unit",$Unit[$i])->where('Product',$Product[$i])->first();
                $SS=Stores::find($StorePurch[$i]);
                $PSS=Products::find($Product[$i]);

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Original_Qty']=$Qty[$i];
                $uu['Qty']=$Qty[$i];
                $uu['AvQty']=$AvQty[$i];
                $uu['Price']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['weight']=$weight[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Total_Wight']=$Total_Wight[$i];
                $uu['UnitRate']=$UnitRate[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['Total_Net']=$Total_Net[$i];

                if($type == 1){
                    $uu['S_Quote']=$ID;
                }else{
                    $uu['QuoteImage']=$ID;
                }



                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['Patch_Number']=$Patch_Number[$i];
                $uu['TDiscount']=$TDiscount[$i];
                $uu['SalesProDesc']=$SalesProDesc[$i];
                $uu['TotCostNew']=$TotCostNew[$i];
                $uu['SmallCode']=$plow->Barcode;
                $uu['SmallQty']=$Qty[$i] * $pp->Rate;
                $uu['Date']=$requets['Date'];
                $uu['CostPrice']=$CostPrice[$i];
                $uu['Branch']=$SS->Branch;
                $uu['Group']=$PSS->Group;
                $uu['Brand']=$PSS->Brand;


                $details::create($uu);


            }


        }









        return $ID ;
    }

    public function CreateQuoteImages($requets ,$table ,$details,$type)
    {


        $RESIDUAL=  $requets['DiscountBill'] + $requets['Total_Discount']  ;
        $branch=Stores::find($requets['Store']);
        $custG=Customers::where('Account',$requets['Client'])->latest('id')->first();

        if($requets['Payment_Method'] == 'Cash'){

            if(!empty($requets['Pay'])){

                $paid = $requets['Pay'] ;

            }else{

                $paid = $requets['Total_Price'] ;
            }

        }elseif($requets['Payment_Method']  == 'Later'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Installment'){

            $paid = $requets['Pay'] ;

        }elseif($requets['Payment_Method']  == 'Check'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'InstallmentCompanies'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Visa' or $requets['Payment_Method'] == 'Visa'){

            $paid = $requets['Total_Price']  ;

        }elseif($requets['Payment_Method']  == 'Cash_Collection'){

            $paid = $requets['Cash_Collection']  ;

        }elseif($requets['Payment_Method']  == 'Delivery'){

            $paid = $requets['Pay'] ;

        }

        if($requets['Payment_Method']  == 'Later'){
            $col=0;
        }else{
            $col=1;
        }

        if(empty($requets['TaxBill'])){
            $requets['TaxBill']=null;
        }


        if(empty($requets['DiscountTaxShow'])){
            $requets['DiscountTaxShow']=null;
        }


        if(!empty($branch)){
            $BRAAA=$branch->Branch;
        }else{
            $BRAAA=null;
        }


        if(!empty($custG)){
            $CUSTGROP=$custG->Group;
        }else{
            $CUSTGROP=null;
        }

        if($requets['TaxBill'] == 1){
            $lastt=Sales::where('TaxBill',1)->latest('id')->first();

            if(!empty($lastt)){
                $TAXCODEEEEE=$lastt->TaxCode + 1;
            }else{
                $TAXCODEEEEE=1;
            }

        }else{
            $TAXCODEEEEE=0;
        }

        if($requets['DiscountTaxShow'] == 1){

            $discTaxx=$requets['Total_Price'] * (1/100) ;
        }else{

            $discTaxx=0 ;
        }

        if(!empty(auth()->guard('admin')->user()->emp)){
            $emp=auth()->guard('admin')->user()->emp;
        }else{
            $emp=null;
        }

        if(request('Sale_Type') == 'POS'){
            $hold=$requets['Hold'];
            $shift=$requets['Shift_Code'];
            $clientAddress=$requets['Client_Address'];
            $delivery=$requets['Delivery'];
            $cash= $requets['Cash']  + $requets['Cashh'];
            $visa=$requets['Visa'];

        }else{

            $hold=null;
            $shift=null;
            $clientAddress=null;
            $delivery=null;
            $cash=null;
            $visa=null;
        }

        if(!empty($requets['ProfitTax'])){

            $ProfitTax=$requets['ProfitTax'];
        }else{
            $ProfitTax=0;
        }

        $Total_Net= ($requets['Total_Price'] +  $requets['Total_Taxes']  + $ProfitTax)  - $RESIDUAL ;
        $residual=$Total_Net - $paid ;

        $image=request()->file('File');
        $zFile=$this->UploadFile($image);

        if(empty($requets['Delegate'])){
            $requets['Delegate']=null;
        }
        if(empty($requets['Executor'])){
            $requets['Executor']=null;
        }
        if(empty($requets['Quote'])){
            $requets['Quote']=null;
        }
        if(empty($requets['SalesOrder'])){
            $requets['SalesOrder']=null;
        }

        if(empty($requets['Total_Wight_Bill'])){
            $requets['Total_Wight_Bill']=null;
        }

        if(empty($requets['TaxOnTotal'])){
            $requets['TaxOnTotal']=null;
        }

        if(empty($requets['TaxOnTotal'])){
            $requets['TaxOnTotal']=null;
        }

        if(empty($requets['TaxOnTotalType'])){
            $requets['TaxOnTotalType']=null;
        }

        if(empty($requets['ProfitTax'])){
            $requets['ProfitTax']=null;
        }
        if(empty($requets['Current_Credit'])){
            $requets['Current_Credit']=null;
        }
        if(empty($requets['Check_Number'])){
            $requets['Check_Number']=null;
        }
       if(empty($requets['Ship'])){
            $requets['Ship']=null;
        }

        $ID = DB::table($table)->insertGetId(
            array(

                'Date' =>$requets['Date'],
                'Draw' =>1,
                'DiscountTax' => $discTaxx,
                'Payment_Method' =>$requets['Payment_Method'] ,
                'Status' =>1 ,
                'Refernce_Number' =>null ,
                'Note' =>$requets['Note'] ,
                'Product_Numbers' =>$requets['Product_Numbers'] ,
                'Total_Qty' =>$requets['Total_Qty'] ,
                'Total_Discount' => $RESIDUAL,
                'Total_BF_Taxes' =>$requets['Total_BF_Taxes'] ,
                'Total_Taxes' =>$requets['Total_Taxes'] ,
                'Total_Price' =>$requets['Total_Price'] ,
                'Pay' => $paid,
                'File' => $zFile,
                'Time' => date("h:i:s a", time()),
                'Branch' => $BRAAA,
                'CustomerGroup' => $CUSTGROP,
                'Safe' =>null ,
                'Later_Due' =>$requets['Later_Due'] ,
                'Client' =>$requets['Client'] ,
                'Delegate' =>null ,
                'Executor' =>null ,
                'Store' =>$requets['Store'] ,
                'Coin' =>null ,
                'Cost_Center' =>null ,
                'presenter' =>$requets['presenter'] ,
                'annual_interest' =>$requets['annual_interest'] ,
                'monthly_installment' =>$requets['monthly_installment'] ,
                'Years_Number' =>$requets['Years_Number'] ,
                'total' =>$requets['total'] ,
                'Total_Cost' =>$requets['Total_Cost'] ,
                'Shipping' =>$requets['Ship'] ,
                'Ship' =>$requets['Ship'] ,
                'Check_Type' =>$requets['Check_Type'] ,
                'TaxBill' =>$requets['TaxBill'] ,
                'TaxOnTotal' =>$requets['TaxOnTotal'] ,
                'TaxOnTotalType' =>$requets['TaxOnTotalType'] ,
                'ProfitTax' =>$requets['ProfitTax'] ,
                'TaxCode' => $TAXCODEEEEE,
                'Due_Date' =>$requets['Due_Date'] ,
                'InstallCompany' =>$requets['InstallCompany'] ,
                'ContractNumber' =>$requets['ContractNumber'] ,
                'PayFees' =>$requets['PayFees'] ,
                'ServiceFee' => $requets['ServiceFee'] ,
                'CompanyPrecent' =>$requets['CompanyPrecent'] ,
                'ProfitPrecent' =>$requets['ProfitPrecent'] ,
                'Check_Number' =>$requets['Check_Number'] ,
                'installment_Num' =>$requets['installment_Num'] ,
                'Date_First_installment' =>$requets['Date_First_installment'] ,
                'Total_Wight_Bill' =>$requets['Total_Wight_Bill'] ,
                'User' => auth()->guard('admin')->user()->id,
                'Client_Address' => $clientAddress,
                'Delivery' => $delivery,
                'Delivery_Status' =>0,
                'Order_Type' => $table,
                'Shift_Code' =>$shift,
                'Edit' => 0,
                'Delete' => 0,
                'Edit_New_Code' => 0,
                'ToSales' => 0,
                'Total_Net' => $Total_Net,
                'Residual' => $residual,
                'Current_Credit' =>$requets['Current_Credit'],
                'Sale_Date' =>$requets['Sale_Date'],
                'DiscountBill' =>$requets['DiscountBill'],


            )
        );




        if(!empty($requets['Unit'])){


            $P_Ar_Name=$requets['P_Ar_Name'];
            $P_En_Name=$requets['P_En_Name'];
            $Unit=$requets['Unit'];
            $P_Code=$requets['P_Code'];
            $Qty=$requets['Qty'];
            $AvQty=1;
            $Price=$requets['Price'];
            $Discount=$requets['Discount'];
            $TotalBFTax=$requets['TotalBFTax'];
            $TotalTax=$requets['TotalTax'];
            $PurchTax=$requets['PurchTax'];
            $Total=$requets['Total'];
            $StorePurch=$requets['StorePurch'];
            $Product=$requets['Product'];
            $VOne=$requets['VOne'];
            $VTwo=$requets['VTwo'];
            $V_Name=$requets['V_Name'];
            $VV_Name=$requets['VV_Name'];
            $Exp_Date=$requets['Exp_Date'];

            $TDiscount=$requets['TDiscPro'];
            $CostPrice=$requets['Price'];
            $TotCostNew=$requets['Total'];
            $Total_Net=$requets['Total_Net'];


            for($i=0 ; $i < count($Unit) ; $i++){

                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
                $plow=ProductUnits::where('Product',$Product[$i])->where('Rate',1)->first();
                $rr = ProductUnits::where("Unit",$Unit[$i])->where('Product',$Product[$i])->first();
                $SS=Stores::find($StorePurch[$i]);
                $PSS=Products::find($Product[$i]);

                $uu['Product_Code']=$P_Code[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Original_Qty']=$Qty[$i];
                $uu['Qty']=$Qty[$i];
                $uu['AvQty']=1;
                $uu['Price']=$Price[$i];
                $uu['Discount']=$Discount[$i];
                $uu['Tax']=$PurchTax[$i];
                $uu['Total_Bf_Tax']=$TotalBFTax[$i];
                $uu['Total_Tax']=$TotalTax[$i];
                $uu['Total']=$Total[$i];
                $uu['Store']=$StorePurch[$i];
                $uu['Product']=$Product[$i];
                $uu['Unit']=$Unit[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['Total_Net']=$Total_Net[$i];
                if($type == 1){
                    $uu['S_Quote']=$ID;
                }else{
                    $uu['QuoteImage']=$ID;
                }
                $uu['V1']=$VOne[$i];
                $uu['V2']=$VTwo[$i];
                $uu['TDiscount']=$TDiscount[$i];
                $uu['TotCostNew']=$TotCostNew[$i];
                $uu['SmallCode']=$plow->Barcode;
                $uu['SmallQty']=$Qty[$i] * $pp->Rate;
                $uu['Date']=$requets['Date'];
                $uu['CostPrice']=$CostPrice[$i];
                $uu['Branch']=$SS->Branch;
                $uu['Group']=$PSS->Group;
                $uu['Brand']=$PSS->Brand;


                $details::create($uu);


            }


        }



        return $ID ;
    }

    //RemoveShiftsTotal
    public function RemoveShiftsTotal($id)


    {

         $item=Sales::findOrFail($id);

        //Shift Details
        $SHIFT=Shifts::where('Code',$item->Shift_Code)->first();

                $RESIDUAL=$item->Total_Discount  ;

                if($item->Payment_Method  == 'Cash'){

                    $cash=$item->Total_Price - $item->Total_Taxes - $RESIDUAL;
                    $visa=0;
                    $later=0;
                    $later_not=0;
                    $install=0;
                    $delv=0;
                    $check=0;
                    $inst_comp=0;
                }elseif($item->Payment_Method == 'Later'){
                    $cash=0;
                    $visa=0;
                    $later=$item->Pay - $item->Total_Taxes - $RESIDUAL;
                    $later_not=$item->Total_Price + $item->Total_Taxes - $RESIDUAL;
                    $install=0;
                    $delv=0;
                    $check=0;
                    $inst_comp=0;
                }elseif($item->Payment_Method == 'Installment'){
                    $cash=0;
                    $visa=0;
                    $later=0;
                    $later_not=0;
                    $install=$item->Pay - $item->Total_Taxes - $RESIDUAL;
                    $delv=0;
                    $check=0;
                    $inst_comp=0;
                }elseif($item->Payment_Method == 'Check'){

                    $cash=0;
                    $visa=0;
                    $later=0;
                    $later_not=0;
                    $install=0;
                    $delv=0;
                    $check=$item->Pay + $item->Total_Taxes - $RESIDUAL;
                    $inst_comp=0;
                }elseif($item->Payment_Method == 'Cash_Visa'){
                    $cash=$item->Cash - $item->Total_Taxes - $RESIDUAL;
                    $visa=$item->Visa;
                    $later=0;
                    $later_not=0;
                    $install=0;
                    $delv=0;
                    $check=0;
                    $inst_comp=0;
                }elseif($item->Payment_Method == 'Cash_Collection'){
                    $cash=$item->Total_Price - $item->Total_Taxes - $RESIDUAL;
                    $visa=0;
                    $later=0;
                    $later_not=0;
                    $install=0;
                    $delv=0;
                    $check=0;
                    $inst_comp=0;
                }elseif($item->Payment_Method == 'Delivery'){
                    $cash=0;
                    $visa=0;
                    $later=0;
                    $later_not=0;
                    $install=0;
                    $delv=$item->Pay - $item->Total_Taxes - $RESIDUAL;
                    $check=0;
                    $inst_comp=0;
                }elseif($item->Payment_Method == 'InstallmentCompanies'){

                    $cash=0;
                    $visa=0;
                    $later=0;
                    $later_not=0;
                    $install=0;
                    $delv=0;
                    $check=0;
                    $inst_comp=$item->Total_Price - $item->Total_Taxes - $RESIDUAL;
                }elseif($item->Payment_Method == 'Visa'){

                    $cash=0;
                    $visa=$item->Visa2;
                    $later=0;
                    $later_not=0;
                    $install=0;
                    $delv=0;
                    $check=0;
                    $inst_comp=0;
                }




        $tt=$visa - $cash - $later - $install  - $check  - $delv  - $inst_comp  ;
        $shoft['Total_Cash']=$SHIFT->Total_Cash - $cash;
        $shoft['Total_Later']=$SHIFT->Total_Later - $later;
        $shoft['Total_Visa']=$SHIFT->Total_Visa - $visa;
        $shoft['Total']=$SHIFT->Total -  $tt ;
        $shoft['Total_Later_Not_Paid']=$SHIFT->Total_Later_Not_Paid - $later_not;
        $shoft['Total_Later_Paid']=$SHIFT->Total_Later_Paid - $later;
        $shoft['Total_Installment']=$SHIFT->Total_Installment - $install;
        $shoft['Total_Checks']=$SHIFT->Total_Checks - $check;
        $shoft['Total_Delivery']=$SHIFT->Total_Delivery - $delv;
        $shoft['Total_Installment_Companies']=$SHIFT->Total_Installment_Companies - $inst_comp;

                Shifts::where('id',$SHIFT->id)->update($shoft);






    }



//RemoveQtiesGifts
    public function RemoveQtiesGifts($id, $type, $new_code)
    {

        $Products=ProductSalesGifts::where('Gift',$id)->get();
        $def = StoresDefaultData::orderBy('id', 'desc')->first();


        foreach($Products as $prod){

            if($prod->Product()->first()->P_Type == 'Assembly'){

                $Asembs=AssemblyProducts::where('p_id',$prod->Product)->get();

                foreach($Asembs as $ass){

                    $Quantity = $this->ProAvQties($prod->Store, $ass->Product, $ass->Product_Code);


                    if(!empty($Quantity)){
                        $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                        $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                        $newqty=abs($Quantity->Qty) +  $qq ;

                        ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty]);



                        $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                        $newqty=abs($Quantity->Qty) + $qq ;


                        $newQQty=$unit->Rate * ($prod->Qty * $ass->Qty) ;




                    }


                    if(!empty($prod->Exp_Date)){

                        $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();
                        $qq= $unit->Rate *  $prod->Qty * $ass->Qty;
                        $EXPO=ExpireDateQty::find($prod->Exp_Date);
                        $NewExpQty=$EXPO->Qty +  $qq ;
                        ExpireDateQty::where('id',$prod->Exp_Date)->update(['Qty'=>$NewExpQty]);


                    }



                    if($def->Cost_Price == 2){

                        $Fifos=SalesFifoQty::where('Sales_ID',$id)->get();

                        foreach($Fifos as $fi){

                            if($fi->Sales_Qty >= ($prod->Qty * $ass->Qty) ){

                                $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                                $qq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                                $newqty=$fi->Sales_Qty + $qq ;

                                SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                                $fio= FifoQty::find($fi->Fifo_ID);

                                $qqq= $unit->Rate * ($prod->Qty * $ass->Qty) ;

                                $newqtyy=$fio->Qty +  $qqq ;

                                FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                            }else{

                                $unit=ProductUnits::where('Unit',$ass->Unit)->where('Product',$ass->Product)->first();

                                $ressss=($prod->Qty * $ass->Qty) -  $fi->Sales_Qty;
                                $result=($prod->Qty * $ass->Qty) -  $ressss;

                                $qq= $unit->Rate * $result ;

                                $newqty=$fi->Sales_Qty +  $qq ;

                                SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                                $fio= FifoQty::find($fi->Fifo_ID);

                                $newqtyy=$fio->Qty +  $fi->Sales_Qty ;

                                FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                            }





                        }


                    }



                    if ($type == 1) {
                        ProductMoves::where('Type', 'هدايا')
                            ->where('Product', $ass->Product)
                            ->where('P_Code', $ass->Product_Code)
                            ->where('Bill_Num', $prod->Gift()->first()->Code)
                            ->update(['Delete' => 1]);

                    } else {

                        ProductMoves::where('Type', 'هدايا')
                            ->where('Product', $ass->Product)
                            ->where('P_Code', $ass->Product_Code)
                            ->where('Bill_Num', $prod->Gift()->first()->Code)
                            ->update(['Edit' => 1, 'Edit_New_Code' => $new_code]);


                    }




                }

            }


            if($prod->Product()->first()->P_Type != 'Service' or $prod->Product()->first()->P_Type != 'Assembly'){

                $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                $qq= $unit->Rate * $prod->Qty ;

                $PR = $this->ProAvQties($prod->Store, $prod->Product, $prod->Product_Code);

                if(!empty($PR)){
                    $newqty=$PR->Qty + $qq ;

                    ProductsQty::where('id',$PR->id)->update(['Qty'=>$newqty]);

                }



                if(!empty($prod->Exp_Date)){

                    $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();
                    $qq= $unit->Rate *  $prod->Qty;
                    $EXPO=ExpireDateQty::find($prod->Exp_Date);
                    $NewExpQty=$EXPO->Qty +  $qq ;
                    ExpireDateQty::where('id',$prod->Exp_Date)->update(['Qty'=>$NewExpQty]);


                }


                if($def->Cost_Price == 2){

                    $Fifos=SalesFifoQty::where('Sales_ID',$id)->get();

                    foreach($Fifos as $fi){




                        if($fi->Sales_Qty >= $prod->Qty ){

                            $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                            $qq= $unit->Rate * $prod->Qty ;

                            $newqty=$fi->Sales_Qty -  $qq ;

                            SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                            $fio= FifoQty::find($fi->Fifo_ID);

                            $qqq= $unit->Rate * $prod->Qty ;

                            $newqtyy=$fio->Qty +  $qqq ;

                            FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                        }else{

                            $unit=ProductUnits::where('Unit',$prod->Unit)->where('Product',$prod->Product)->first();

                            $ressss=$prod->Qty -  $fi->Sales_Qty;
                            $result=$prod->Qty -  $ressss;

                            $qq= $unit->Rate * $result ;

                            $newqty=$fi->Sales_Qty -  $qq ;

                            SalesFifoQty::where('Sales_ID',$id)->update(['Sales_Qty'=>$newqty]);

                            $fio= FifoQty::find($fi->Fifo_ID);

                            $newqtyy=$fio->Qty +  $fi->Sales_Qty ;

                            FifoQty::where('id',$fi->Fifo_ID)->update(['Qty'=>$newqtyy]);


                        }





                    }


                }


                if ($type == 1) {
                    ProductMoves::where('Type', 'هدايا')
                        ->where('Product', $prod->Product)
                        ->where('P_Code', $prod->Product_Code)
                        ->where('Bill_Num', $prod->Gift()->first()->Code)
                        ->update(['Delete' => 1]);

                } else {

                    ProductMoves::where('Type', 'هدايا')
                        ->where('Product', $prod->Product)
                        ->where('P_Code', $prod->Product_Code)
                        ->where('Bill_Num', $prod->Gift()->first()->Code)
                        ->update(['Edit' => 1, 'Edit_New_Code' => $new_code]);


                }


            }
        }


    }



    // Filters Gifts
    public function ItemsFilterGifts($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }

        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        $hide=$this->ShowHideColumn();
        $show=$hide['show'];
        $dos=$hide['dos'];
        $parO=$hide['parO'];
        $parOO=$hide['parOO'];
        $parOOO=$hide['parOOO'];
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $ProDescShow=$hide['ProDescShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $avqtyShow=$hide['avqtyShow'];
        $Show_Barcode=$hide['Show_Barcode'];
        $Show_Net=$hide['Show_Net'];
        $Show_Unit=$hide['Show_Unit'];
        $Show_Total=$hide['Show_Total'];

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $AvalibleQunatity=$Filter['qty'];

        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['id'].'" onchange="ExpDateQty('.$Filter['id'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['id'].'"   class="form-control">';
        }

        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty']/ $rr->Rate;

        }


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['id'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['id'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();


        $COSTpr = $average->AverageCostGetUnit($Filter['product'], $rr->Barcode, $Filter['store'],$rr->Unit);

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();

        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }

        $Higher=$DES;

        // 1 Complited  2 serial  3 single  4 double

        if ($Filter['type'] == 1) {

            $funUnit = 'onchange="UnitCodePurchh(' . $Filter['id'] . ')"';


        } else{

            $funUnit = 'onchange="UnitCodePurch(' . $Filter['id'] . ')"';
        }

        //lw hw serial
        if(empty($Ser)){
        }

        if($AvalibleQunatity > 0) {
            if($Filter['store']  ==  $Filter['pro_store']) {
                $output .= '

       <tr id="Row' . $Filter['id'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '  ('.$Filter['v_name'] .')  ('.$Filter['vv_name'] .')
 <input type="hidden"  id="P_Ar_Name' . $Filter['id'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['id'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['id'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['id'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['id'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['id'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['id'] . '" value="' . $Filter['vv_name'] . '">
        <input type="hidden"  id="serial' . $Filter['id'] . '" value="' . $Filter['serial'] . '">
        </td>


        <td>
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['id'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

                foreach ($units as $uni) {
                    $nam = Measuerments::find($uni->Unit);


                    if (app()->getLocale() == 'ar') {
                        $UnitNamme = $nam->Name;
                    } else {

                        $UnitNamme = $nam->NameEn;
                    }
                    $output .= '
            <option value="' . $uni->Unit . '"       ';
                    if ($rr->Unit == $uni->Unit) {
                        $output .= '  selected  ';
                    }
                    $output .= ' > ' . $UnitNamme . '</option>
                 ';


                }

                $output .= '

                        </select>
        </td>
        <td>
         <input type="text" id="CodePurch' . $Filter['id'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['id'] . '" value="' . $UniiName . '">
         <input type="hidden" id="UnitDefault' . $Filter['id'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['id'] . '" value="' . $rr->Barcode . '">
        </td>

            <td>

            <input type="text" class="form-control" id="AvQty' . $Filter['id'] . '" value="' . $AvalibleQunatity . '" disabled >

            </td>

        <td>
        <input type="number" step="any" id="Qty' . $Filter['id'] . '"   class="form-control" onkeyup="PurchTotal(' . $Filter['id'] . ')" onclick="PurchTotal(' . $Filter['id'] . ')" >
        <input type="hidden" id="CostPrice' . $Filter['id'] . '"  value="' . $COSTpr . '" >
        <input type="hidden" id="Price' . $Filter['id'] . '"  value="' . $pr . '" >
         <input type="hidden" id="Total' . $Filter['id'] . '"   class="form-control" >
         <input type="hidden" id="TotalCost' . $Filter['id'] . '"   class="form-control" >

        </td>


       ' . $EXPIRE . '

        <td>

 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['id'] . '" onclick="Fun(' . $Filter['id'] . ')">
          <i class="fal fa-plus"></i>
          </button>

          </td>
        </tr>


            ';

            }
        }

        return $output;

    }

    public function ItemsFilterGiftsTwo($Filter)
    {

        $output = '';

        $average = new Average;
        $service = new SalesService;

        $Def=SalesDefaultData::orderBy('id','desc')->first();
        $showw=DefaultDataShowHide::orderBy('id','desc')->first();
        $st = Stores::find($Filter['store']);
        $TAXESS = Taxes::all();
        $Stores = Stores::all();
        $units = ProductUnits::where('Product', $Filter['product'])->get();
        $search=$Filter['search'];
        if(is_numeric($search)){


            $rr = ProductUnits::where('Product', $Filter['product'])->where('Barcode', $search)->first();
        }else {
            $rr = ProductUnits::where('Product', $Filter['product'])->where('Def', 1)->first();
        }


        $plow = ProductUnits::where('Product', $Filter['product'])->where('Rate', 1)->first();

        $hide=$this->ShowHideColumn();
        $show=$hide['show'];
        $dos=$hide['dos'];
        $parO=$hide['parO'];
        $parOO=$hide['parOO'];
        $parOOO=$hide['parOOO'];
        $user=$hide['user'];
        $discShow=$hide['discShow'];
        $ProDescShow=$hide['ProDescShow'];
        $taxShow=$hide['taxShow'];
        $storeShow=$hide['storeShow'];
        $avqtyShow=$hide['avqtyShow'];
        $Show_Barcode=$hide['Show_Barcode'];
        $Show_Net=$hide['Show_Net'];
        $Show_Unit=$hide['Show_Unit'];
        $Show_Total=$hide['Show_Total'];

        $weigh=$Filter['weigh'];
        $maxSa=$Filter['maxSa'];
        $brandd=$Filter['brandd'];
        $ShowGrBr=$Filter['ShowGrBr'];
        $PrrroName=$Filter['PrrroName'];
        $UniiName=$Filter['UniiName'];
        $StoreNemo=$Filter['StoreNemo'];
        $AvalibleQunatity=$Filter['qty'];

        $EXPOOOs=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->get();
        $EXPIRE='';
        if($showw->Expire_Date == 1){

            if(!empty($EXPOOOs)){

                $EXPPPP=ExpireDateQty::orderBy('id','desc')->where('Product',$Filter['product'])->where('Store',$Filter['store'])->where('P_Code',$Filter['P_Code'])->first();
                if(!empty($EXPPPP)){
                    $Exxxxx=$EXPPPP->id;
                }else{
                    $Exxxxx=1;
                }

            }else{
                $Exxxxx=1;
            }


            $EXPIRE='<td>
             <select class="select2 form-control w-100"   id="ExpDate'.$Filter['product'].'" onchange="ExpDateQty('.$Filter['product'].')">
                <option value="">'.trans('admin.Choice_Date').'</option>
              ';

            foreach($EXPOOOs as $exx){


                $EXPIRE .= '
            <option value="'.$exx->id.'"       ';  if($exx->id == $Exxxxx){    $EXPIRE .= '  selected  ';  }   $EXPIRE .= ' > '.$exx->Exp_Date.'</option>
                 ';


            }

            $EXPIRE .= '

                        </select>
        </td>';
        }else{

            $EXPIRE='<input type="hidden" id="ExpDate'.$Filter['product'].'"   class="form-control">';
        }

        if(!empty($Filter['Exp_Date'])){


            $PREX=$this->ExpireAvQtiesCheck($Filter['store'],$Filter['product'],$Filter['P_Code'],$Filter['Exp_Date']);

            if(!empty($PREX)){
                $AvalibleQunatity=$PREX->Qty / $rr->Rate;
            }else{

                $AvalibleQunatity=$Filter['qty'] / $rr->Rate;
            }


        }else{

            $AvalibleQunatity=$Filter['qty']/ $rr->Rate;

        }


        if($showw->Patch_Number == 1){
            $pn='<td><input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">'.$Filter['Patch_Number'].'</td>';
        }else{
            $pn='<input type="hidden" id="PatchNum'.$Filter['product'].'" value="'.$Filter['Patch_Number'].'">';
        }


        $Ser=ProductSalesOrder::where('Product',$Filter['product'])->where('Product_Code',$Filter['P_Code'])->first();



        $COSTpr=$Filter['cost'];

        $pr=$service->PriceLevel($Filter['client'],$rr);

        if($Filter['Original'] != null){

            $pr=0;
        }

        $Cli=Customers::where('Account',$Filter['client'])->first();
        $pro=Products::findOrFail($Filter['product']);
        $ItemsGroupsDiscount=ItemsGroups::findOrFail($pro->Group);
        if(!empty($Cli)){

            if(!empty($Cli->Group)){
                $nwD=CustomersGroup::find($Cli->Group);

                if(!empty($nwD->Discount)){

                    if($nwD->Discount == 0){

                        if(!empty($ItemsGroupsDiscount)){

                            if(!empty($ItemsGroupsDiscount->Discount)){
                                $DES=$ItemsGroupsDiscount->Discount;
                            }else{
                                $DES=0;
                            }

                        }else{

                            $DES=0;
                        }

                    }else{
                        $DES= $nwD->Discount ;
                    }


                }else{


                    if(!empty($ItemsGroupsDiscount)){

                        if(!empty($ItemsGroupsDiscount->Discount)){
                            $DES=$ItemsGroupsDiscount->Discount;
                        }else{
                            $DES=0;
                        }

                    }else{

                        $DES=0;
                    }


                }


            }else{

                if(!empty($ItemsGroupsDiscount)){

                    if(!empty($ItemsGroupsDiscount->Discount)){
                        $DES=$ItemsGroupsDiscount->Discount;
                    }else{
                        $DES=0;
                    }

                }else{

                    $DES=0;
                }

            }

        }else{

            if(!empty($ItemsGroupsDiscount)){

                if(!empty($ItemsGroupsDiscount->Discount)){
                    $DES=$ItemsGroupsDiscount->Discount;
                }else{
                    $DES=0;
                }

            }else{

                $DES=0;
            }

        }

        $Higher=$DES;
        // 1 Assembly  2 service



        $funUnit = 'onchange="UnitCodePurchh(' . $Filter['product'] . ')"';



        //lw hw assembly
        if(  $AvalibleQunatity > 0) {

            $output .= '

       <tr id="Row' . $Filter['product'] . '">
        <td>
        ' . $PrrroName . ' ' . $ShowGrBr . '
 <input type="hidden"  id="P_Ar_Name' . $Filter['product'] . '" value="' . $Filter['name_ar'] . '">
        <input type="hidden"  id="P_En_Name' . $Filter['product'] . '" value="' . $Filter['name_en'] . '">
        <input type="hidden"  id="Product' . $Filter['product'] . '" value="' . $Filter['product'] . '">
        <input type="hidden"  id="VOne' . $Filter['product'] . '" value="' . $Filter['v1'] . '">
        <input type="hidden"  id="VTwo' . $Filter['product'] . '" value="' . $Filter['v2'] . '">
        <input type="hidden"  id="V_Name' . $Filter['product'] . '" value="' . $Filter['v_name'] . '">
        <input type="hidden"  id="VV_Name' . $Filter['product'] . '" value="' . $Filter['vv_name'] . '">
        <input type="hidden"  id="serial' . $Filter['product'] . '" value="' . $Filter['serial'] . '">
        </td>




        <td  >
             <select class="select2 form-control w-100"   id="UnitPurch' . $Filter['product'] . '" ' . $funUnit . '>
                <option value="">' . trans('admin.Choice_Unit') . '</option>
              ';

            foreach ($units as $uni) {
                $nam = Measuerments::find($uni->Unit);


                if (app()->getLocale() == 'ar') {
                    $UnitNamme = $nam->Name;
                } else {

                    $UnitNamme = $nam->NameEn;
                }
                $output .= '
            <option value="' . $uni->Unit . '"       ';
                if ($rr->Unit == $uni->Unit) {
                    $output .= '  selected  ';
                }
                $output .= ' > ' . $UnitNamme . '</option>
                 ';


            }

            $output .= '

                        </select>
        </td>
        <td   >
         <input type="text" id="CodePurch' . $Filter['product'] . '" class="form-control" value="' . $Filter['P_Code'] . '"  disabled>
         <input type="hidden" id="UnitPurchName' . $Filter['product'] . '" value="' . $UniiName . '">
         <input type="hidden" id="UnitDefault' . $Filter['product'] . '" value="' . $rr->Unit . '">
         <input type="hidden" id="CodeDefault' . $Filter['product'] . '" value="' . $rr->Barcode . '">


        </td>


            <td>

            <input type="text" class="form-control" id="AvQty' . $Filter['product'] . '" value="' . $AvalibleQunatity . '" disabled >

            </td>

        <td>
        <input type="number" step="any" id="Qty' . $Filter['product'] . '"   class="form-control" onkeyup="PurchTotal(' . $Filter['product'] . ')" onclick="PurchTotal(' . $Filter['product'] . ')" >
        <input type="hidden" id="CostPrice' . $Filter['product'] . '"  value="' . $COSTpr . '" >
        <input type="hidden" id="Price' . $Filter['product'] . '"  value="' . $pr . '" >
  <input type="hidden" id="Total' . $Filter['product'] . '"   class="form-control" >
    <input type="hidden" id="TotalCost' . $Filter['id'] . '"   class="form-control" >
        </td>


       ' . $EXPIRE . '


        <td>

 <button type="button" class="btn btn-default waves-effect waves-themed" style="display:none" id="AddBtnPur' . $Filter['product'] . '" onclick="Fun(' . $Filter['product'] . ')">
          <i class="fal fa-plus"></i>
          </button>





          </td>
        </tr>


            ';

        }

        return $output;

    }




//LocationCondition
    public function LocationCondition($id,$lat,$lng)
    {


        $address=Addressses::where('Customer',$id)->orderBy('id','asc')->first();


        if(!empty($address)){

            $lat1=$address->Lat;
            $lon1=$address->Lng;
            $lat2=$lat;
            $lon2=$lng;
            $unit=''; //K or N

                $theta = $lon1 - $lon2;
                $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
                $dist = acos($dist);
                $dist = rad2deg($dist);
                $miles = $dist * 60 * 1.1515;
                $unit = strtoupper($unit);

                if ($unit == "K") {
                   $dist= ($miles * 1.609344);
                } else if ($unit == "N") {
                    $dist= ($miles * 0.8684);
                } else {
                    $dist= $miles;
                }

if($dist <= 100){

    return 1;  // 0 or 1

}else{

    return 0;  // 0 or 1
}




        }else{

            return 0;  // 0 or 1
        }





    }



}
