<?php

namespace App\Services;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;    
use App\Models\ExportChecks;    
use App\Models\IncomChecks;    
use DB;



class ChecksService
{
     use GeneralTrait;
    
    public function RefuseExportChecks($data){


    $type_ar='رفض الشيكات الصادرة';
    $type_en='Refuse Exporting Checks';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=$data['Account'];
    $account_debt=42;
    $date=date('Y-m-d');
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Reason'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code=0;
    $Code_Type=$data['Code'];


    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);

    $dataOrder['joun_id']=$joun_id;
    $dataOrder['code']=$new->Code;

    $this->JunDetails($dataOrder);




    $order=[
    'noti_name_ar'=>'رفض شيك صادر',
    'noti_name_en'=>'Refuse Exporting Checks',
    'type_ar'=>'الشيكات الصادرة',
    'type_en'=>'Exporting Checks',
    'type_code'=>$Code_Type,
    'emp'=>null,
    'client'=>$data['Account'],
    'product'=>null,
    'store'=>null,
    'safe'=>null,
    'notify_name'=>trans('admin.RefuseExportingChecks'),
    ];
    $this->CreateNotification($order);






    $dataUser=[
    'screen_ar'=>'الشيكات الصادرة',
    'screen_en'=>'Exporting Checks',
    'type_ar'=>'رفض شيك',
    'type_en'=>'Refuse Checks',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);





    }


    public function PayExportChecks($data){


    $type_ar='دفع شيك صادر';
    $type_en='Pay Exporting Checks';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=$data['BankSafe_Account'];
    $account_debt=42;
    $date=date('Y-m-d');
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Note'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code=0;
    $Code_Type=$data['Code'];


    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);

    $dataOrder['joun_id']=$joun_id;
    $dataOrder['code']=$new->Code;

    $this->JunDetails($dataOrder);




    $order=[
    'noti_name_ar'=>'دفع شيك صادر',
    'noti_name_en'=>'Pay Exporting Checks',
    'type_ar'=>'الشيكات الصادرة',
    'type_en'=>'Exporting Checks',
    'type_code'=>$Code_Type,
    'emp'=>null,
    'client'=>$data['Account'],
    'product'=>null,
    'store'=>null,
    'safe'=>null,
    'notify_name'=>trans('admin.PayExportingChecks'),
    ];
    $this->CreateNotification($order);






    $dataUser=[
    'screen_ar'=>'الشيكات الصادرة',
    'screen_en'=>'Exporting Checks',
    'type_ar'=>'دفع شيك',
    'type_en'=>'Check Payed',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);





    }


    public function RefuseIncomChecks($data){


    $type_ar='رفض الشيكات الواردة';
    $type_en='Refuse Incoming checks';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=35;
    $account_debt=$data['Account'];
    $date=date('Y-m-d');
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Reason'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code=0;
    $Code_Type=$data['Code'];


    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);

    $dataOrder['joun_id']=$joun_id;
    $dataOrder['code']=$new->Code;

    $this->JunDetails($dataOrder);




    $order=[
    'noti_name_ar'=>'رفض شيك وارد',
    'noti_name_en'=>'Refuse incoming Checks',
    'type_ar'=>'الشيكات واردة',
    'type_en'=>'incoming Checks',
    'type_code'=>$Code_Type,
    'emp'=>null,
    'client'=>$data['Account'],
    'product'=>null,
    'store'=>null,
    'safe'=>null,
    'notify_name'=>trans('admin.RefuseIncomingChecks'),
    ];
    $this->CreateNotification($order);



    $dataUser=[
    'screen_ar'=>'الشيكات الواردة',
    'screen_en'=>'Incoming checks',
    'type_ar'=>'رفض شيك',
    'type_en'=>'Refuse Checks',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);


    }


    public function PayIncomChecks($data){


    $type_ar='دفع شيك وارد';
    $type_en='Pay Incoming Checks';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=35;
    $account_debt=$data['BankSafe_Account'];
    $date=date('Y-m-d');
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Note'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code=0;
    $Code_Type=$data['Code'];


    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);

    $dataOrder['joun_id']=$joun_id;
    $dataOrder['code']=$new->Code;

    $this->JunDetails($dataOrder);




    $order=[
    'noti_name_ar'=>'دفع شيك وارد',
    'noti_name_en'=>'Pay Incoming Checks',
    'type_ar'=>'الشيكات واردة',
    'type_en'=>'Incoming Checks',
    'type_code'=>$Code_Type,
    'emp'=>null,
    'client'=>$data['Account'],
    'product'=>null,
    'store'=>null,
    'safe'=>null,
    'notify_name'=>trans('admin.PayIncomingChecks'),
    ];
    $this->CreateNotification($order);



    $dataUser=[
    'screen_ar'=>'الشيكات الواردة',
    'screen_en'=>'Incoming checks',
    'type_ar'=>'دفع شيك',
    'type_en'=>'Check Payed',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);



    }


    public function TransferToExportChecks($data){



    $IDD = DB::table('export_checks')->insertGetId(

    array(

    'Date' => $data['Date'],
    'Draw' => $data['Draw'],
    'Note' =>$data['Note'],
    'Coin' => $data['Coin'],
    'Bank' => $data['Bank'],
    'Cost_Center' => $data['Cost_Center'],
    'Check_Num' =>$data['Check_Num'],
    'Signture_Name' =>$data['Signture_Name'],
    'Bank_Branch' =>$data['Bank_Branch'],
    'Check_Type' =>$data['Check_Type'],
    'Account' =>$data['Bene_Account'],
    'Due_Date' =>$data['Due_Date'],
    'Amount' =>$data['Amount'],
    'Status' =>0,
    'File' => $data['File'],
    'Image' => $data['Image'],
    'User' =>auth()->guard('admin')->user()->id,
    'Pay_Account' =>42,
    'Bene_Account' =>null,
    'Reason' =>null,

    )
    );



    $Code=ExportChecks::findOrFail($IDD);

    //Event

    $dataEvent=[

    'start_date'=>$data['Due_Date'],
    'end_date'=>$data['Due_Date'],
    'event_name_ar'=>'صرف شيك صادر',
    'event_name_en'=>'Cashing an exporting check',
    'type'=>'شيك صادر',
    'type_id'=>null,
    'type_code'=>$Code->Code,
    'emp'=>null,
    'client'=>$data['Bene_Account'],
    'product'=>null,
    'customer'=>null,

    ];


    $this->CreateEvent($dataEvent);


    //Jounralizing
    $type_ar='الشيكات الصادرة';
    $type_en='Exporting Checks';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=42;
    $account_debt=$data['Bene_Account'];
    $date=$data['Date'];
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Note'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code_Type=$Code->Code;
    $Code=0;

    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);
    $dataOrder['code']=$new->Code;
    $dataOrder['joun_id']=$joun_id;

    $this->JunDetails($dataOrder);


    $dataUser=[
    'screen_ar'=>'الشيكات الصادرة',
    'screen_en'=>'Exporting Checks',
    'type_ar'=>'محوله',
    'type_en'=>'Transfered',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);




    }


    public function TransferToIncomChecks($data){


    $IDD = DB::table('incom_checks')->insertGetId(

    array(

    'Date' => $data['Date'],
    'Draw' => $data['Draw'],
    'Note' =>$data['Note'],
    'Coin' => $data['Coin'],
    'Bank' => $data['Bank'],
    'Cost_Center' => $data['Cost_Center'],
    'Check_Num' =>$data['Check_Num'],
    'Signture_Name' =>$data['Signture_Name'],
    'Bank_Branch' =>$data['Bank_Branch'],
    'Check_Type' =>$data['Check_Type'],
    'Account' =>$data['Bene_Account'],
    'Due_Date' =>$data['Due_Date'],
    'Amount' =>$data['Amount'],
    'Status' =>0,
    'Arrest_Account' =>35,
    'File' => $data['File'],
    'Image' => $data['Image'],
    'User' =>auth()->guard('admin')->user()->id,
    'Bene_Account' =>null,
    'Reason' =>null,

    )
    );

    $Code=IncomChecks::findOrFail($IDD);

    //Event

    $dataEvent=[

    'start_date'=>$data['Due_Date'],
    'end_date'=>$data['Due_Date'],
    'event_name_ar'=>'صرف شيك وارد',
    'event_name_en'=>'Cashing an incoming check',
    'type'=>'شيك وارد',
    'type_id'=>null,
    'type_code'=>$Code->Code,
    'emp'=>null,
    'client'=>$data['Bene_Account'],
    'product'=>null,
    'customer'=>null,

    ];


    $this->CreateEvent($dataEvent);


    //Jounralizing
    $type_ar='الشيكات الواردة';
    $type_en='Incoming checks';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=$data['Bene_Account'];
    $account_debt=35;
    $date=$data['Date'];
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Note'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code_Type=$Code->Code;
    $Code=0;

    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);
    $dataOrder['code']=$new->Code;
    $dataOrder['joun_id']=$joun_id;

    $this->JunDetails($dataOrder);



    $dataUser=[
    'screen_ar'=>'الشيكات الواردة',
    'screen_en'=>'Incoming checks',
    'type_ar'=>'محوله',
    'type_en'=>'Transfered',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);




    }


    public function RecivedInsurancePaper($data){


    $type_ar='استلام وصل امانه';
    $type_en='Insurance Paper Recived';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=35;
    $account_debt=$data['Bank'];
    $date=date('Y-m-d');
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Note'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code=0;
    $Code_Type=$data['Code'];


    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);

    $dataOrder['joun_id']=$joun_id;
    $dataOrder['code']=$new->Code;

    $this->JunDetails($dataOrder);

    $order=[
    'noti_name_ar'=>'استلام وصل امانه',
    'noti_name_en'=>'Insurance Paper Recived',
    'type_ar'=>'وصل امانة',
    'type_en'=>'Insurance Paper',
    'type_code'=>$Code_Type,
    'emp'=>null,
    'client'=>$data['Account'],
    'product'=>null,
    'store'=>null,
    'safe'=>null,
    'notify_name'=>trans('admin.InsurancePaperRecived'),
    ];
    $this->CreateNotification($order);



    $dataUser=[
    'screen_ar'=>'استلام وصل امانه',
    'screen_en'=>'Insurance Paper Recived',
    'type_ar'=>'استلام وصل امانه',
    'type_en'=>'Insurance Paper Recived',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);



    }



    public function SureSafeTransfer($data){


    $type_ar='تحويلات الخزائن';
    $type_en='Safes Transfer';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=$data['From_Safe'];
    $account_debt=$data['To_Safe'];
    $date=date('Y-m-d');
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Note'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code=0;
    $Code_Type=$data['Code'];


    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);

    $dataOrder['joun_id']=$joun_id;
    $dataOrder['code']=$new->Code;

    $this->JunDetails($dataOrder);



    $order=[
    'noti_name_ar'=>'تأكيد تحويل خزينة',
    'noti_name_en'=>'Confirm Safe Transfer',
    'type_ar'=>'تحويلات خزائن',
    'type_en'=>'Safe Transfers',
    'type_code'=>$Code_Type,
    'emp'=>$data['Delegate'],
    'client'=>null,
    'product'=>null,
    'store'=>null,
    'safe'=>$data['To_Safe'],
    'notify_name'=>trans('admin.ConfirmationSafeTransfer'),
    ];
    $this->CreateNotification($order);




    $dataUser=[
    'screen_ar'=>'تحويلات خزائن',
    'screen_en'=>'Safes Transfer',
    'type_ar'=>'تأكيد',
    'type_en'=>'Sure',
    'explain_ar'=>$Code_Type,
    'explain_en'=>$Code_Type,
    ];
    $this->UserCustomMoves($dataUser);





    }



    public function AssetsSale($data){


    $type_ar='بيع أصل';
    $type_en='Asset Sale';
    $debitor=$data['Amount'];
    $creditor=$data['Amount'];
    $account_cred=$data['Client'];
    $account_debt=$data['Safe'];
    $date=date('Y-m-d');
    $draw=$data['Draw'];
    $coin=$data['Coin'];
    $cost_center=$data['Cost_Center'];
    $note=$data['Note'];
    $total=$data['Amount'];
    $joun_id=0;
    $Code=0;
    $Code_Type=$data['Code'];


    $dataOrder=[

    'type_ar'=>$type_ar,
    'type_en'=>$type_en,
    'code'=>$Code,
    'code_type'=>$Code_Type,
    'date'=>$date,
    'draw'=>$draw,
    'coin'=>$coin,
    'cost_center'=>$cost_center,
    'note'=>$note,
    'debitor_cred'=>0,
    'creditor_cred'=>$creditor,
    'account_cred'=>$account_cred,
    'debitor_debt'=>$debitor,
    'creditor_debt'=>0,
    'account_debt'=>$account_debt,
    'total'=>$total,
    'joun_id'=>$joun_id,
    ];

    $joun_id=$this->CreateNewJun($dataOrder);
    $new=Journalizing::findOrFail($joun_id);

    $dataOrder['joun_id']=$joun_id;
    $dataOrder['code']=$new->Code;

    $this->JunDetails($dataOrder);


    $dataOrder['account_cred']=48;
    $dataOrder['account_debt']=$data['Client'];

    $this->JunDetails($dataOrder);




    $dataUser=[
    'screen_ar'=>'الاصول',
    'screen_en'=>'Assets',
    'type_ar'=>'بيع أصل',
    'type_en'=>'Asset Sale',
    'explain_ar'=>$data['Name'],
    'explain_en'=>$data['NameEn'],
    ];
    $this->UserCustomMoves($dataUser);



    }
    
    
    
    
    
}
