<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesOrder extends Model
{
    use HasFactory;
     protected $table = 'sales_orders';
      protected $fillable = [

        'Code',
        'Date',
        'Draw',
        'Payment_Method',
        'Status',
        'Refernce_Number',
        'Note',
        'Product_Numbers',
        'Total_Qty',
        'Total_Discount',
        'Total_BF_Taxes',
        'Total_Taxes',
        'Total_Price',
        'Pay',
        'Safe',
        'Client',
        'Executor',
        'Delegate',
        'Store',
        'Coin',
        'Cost_Center',
        'User',
        'presenter',
        'annual_interest',
        'monthly_installment',
        'Years_Number',
        'total',
        'Quote',
        'installment_Num',
        'Date_First_installment',
        'ToSales',
        'Hold',
        'Later_Due',
        'Sale_Date',
        'CuponCode',
        'Shipping',
        'Delivery_Status',
        'Order_Type',
        'Name',
        'Email',
        'Phone',
        'OtherPhone',
        'Address_Name',
        'Special_MarkAdd',
        'StreetAdd',
        'BulidingAdd',
        'FloorAdd',
        'FlatAdd',
        'Governrate',
        'City',
        'Place',
        'LocationAdd',
        'Address_DetailsAdd',
        'ProfitPrecent',
        'InstallCompany',
        'ContractNumber',
        'PayFees',
        'ServiceFee',
        'CompanyPrecent',
        'Time',
        'Delegate_Recived',
        'Delegate_Recived_Time',
        'To_Sales_Time',
        'Cancel_Order',
        'Cancel_Order_Time',
        'Hold_Qty',
        'TakeawayStatus',
       'TakeawayTime',
        'Witer',
        'KitchenEnd',
        'KitchenEndTime',
        'RecivedOrder',
        'RecivedOrderTime',
        'DeliveryTime',
        'ResturantOrderType',
        'Table',
        'Total_Wight_Bill',

          'Ship',
        'TaxBill',
        'TaxCode',
        'TaxOnTotal',
        'TaxOnTotalType',
        'Check_Type',
        'Due_Date',
        'Check_Number',
        'Shift_Code',
        'Client_Address',
        'Delivery',
        'ProfitTax',
        'Branch',
        'CustomerGroup',
        'Total_Cost',
        'File',
        'Edit',
        'Delete',
        'Edit_New_Code',
        'Total_Net',
        'Residual',
          'Current_Credit',
          'DiscountTax',
          'DiscountBill',

    ];

    public function Table()
    {
        return $this->belongsTo(ResturantTables::class,'Table');
    }    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }
    public function Client()
    {
        return $this->belongsTo(AcccountingManual::class,'Client');
    }
    public function Delegate()
    {
        return $this->belongsTo(Employess::class,'Delegate');
    }

    public function Executor()
    {
        return $this->belongsTo(Employess::class,'Executor');
    }
    public function Witer()
    {
        return $this->belongsTo(Employess::class,'Witer');
    }


    public function Store()
    {
        return $this->belongsTo(Stores::class,'Store');
    }
    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }
    public function Cost_Center()
    {
        return $this->belongsTo(CostCenter::class,'Cost_Center');
    }
    public function User()
    {
        return $this->belongsTo(Admin::class,'User');
    }

    public function ProductSales()
    {
        return $this->hasOne(ProductSales::class);
    }

    public function Installment()
    {
        return $this->hasOne(Installment::class);
    }

    public function RecivedSales()
    {
        return $this->hasOne(RecivedSales::class);
    }

    public function ReturnSales()
    {
        return $this->hasOne(ReturnSales::class);
    }

    public function Ship()
    {
        return $this->belongsTo(AcccountingManual::class,'Shipping');
    }

    public function Check_Type()
    {
        return $this->belongsTo(ChecksTypes::class,'Check_Type');
    }

    public function Delivery()
    {
        return $this->belongsTo(Employess::class,'Delivery');
    }

    public function Client_Address()
    {
        return $this->belongsTo(Addressses::class,'Client_Address');
    }

    public function Sale_User()
    {
        return $this->belongsTo(Admin::class,'Sale_User');
    }


    public function TaxOnTotalType()
    {
        return $this->belongsTo(Taxes::class,'TaxOnTotalType');
    }


    public function InstallCompany()
    {
        return $this->belongsTo(InstallmentCompanies::class,'InstallCompany');
    }



    public function Branch()
    {
        return $this->belongsTo(Branches::class,'Branch');
    }


    public function Governrate()
    {
        return $this->belongsTo(Governrate::class,'Governrate');
    }

    public function City()
    {
        return $this->belongsTo(City::class,'City');
    }

    public function Place()
    {
        return $this->belongsTo(Places::class,'Place');
    }


    public function CustomerGroup()
    {
        return $this->belongsTo(CustomersGroup::class,'CustomerGroup');
    }


    public function ProductSalesOrder()
    {
        return $this->hasOne(ProductSalesOrder::class);
    }



    public function scopeType($query){

    if(auth()->guard('admin')->user()->emp != 0){

    return $query->where('Delegate',auth()->guard('admin')->user()->emp)->where('KitchenEnd',1)->where('RecivedOrder',1);

    }else{

          return $query->where('KitchenEnd',1)->where('RecivedOrder',1);

    }

    }


    public function scopeStoreType($query){

        if(auth()->guard('admin')->user()->pos_stores == 0){

            return $query->where('Hold',1)->where('Store',auth()->guard('admin')->user()->store);

        }else{

            return $query->where('Hold',1);

        }

    }

    public function scopeHoldType($query){

        $DEEF=SalesDefaultData::latest('id')->first();
        if($DEEF->SalesOrderType == 1){

            return $query->where('Delegate_Recived',1);


        }

    }

    public function scopeResturantHoldType($query){

        if(auth()->guard('admin')->user()->pos_stores == 0){


            return $query->where('Edit',0)->where('Delete',0)->where('ToSales',0)->where('Hold',1)->where('Order_Type','Resturant')->where('ResturantOrderType','!=','Hall')->where('Store',auth()->guard('admin')->user()->store);


        }else{


            return $query->where('Edit',0)->where('Delete',0)->where('ToSales',0)->where('Hold',1)->where('Order_Type','Resturant')->where('ResturantOrderType','!=','Hall');

        }






    }









}
