<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Investors extends Model
{
    use HasFactory;
    protected $table = 'investors';
    protected $fillable = [
        'Date',
        'Name',
        'Investment_Value',
        'Safe',
        'Draw',
        'Coin',
        'Profit_Precent',
        'Investment_Period',
        'Liquidation_Time',
        'Status',
        'End_Date',
        'Account',
        'Due_Account',
        'Expenses_Account',


    ];

    public function Safe()
    {
        return $this->belongsTo(AcccountingManual::class,'Safe');
    }
    public function Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Account');
    }
    public function Due_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Due_Account');
    }
    public function Expenses_Account()
    {
        return $this->belongsTo(AcccountingManual::class,'Expenses_Account');
    }
    public function Coin()
    {
        return $this->belongsTo(Coins::class,'Coin');
    }

}
