<?php

namespace App\Listeners\StartPeriod;

use App\Events\StartPeriodEvent;
use App\Models\FifoQty;
use App\Models\GeneralDaily;
use App\Models\JournalizingDetails;
use App\Models\ProductsStartPeriods;
use App\Models\StartPeriods;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;

use App\Models\Journalizing;
use App\Models\SubVirables;
use App\Models\ExpireDateQty;
use App\Models\ProductUnits;
use App\Models\ProductMoves;
use App\Models\ProductsQty;
use App\Models\Stores;
use App\Models\StoresDefaultData;
use App\Models\Products;
use DB;
use App\Services\Average;


class StartPeriodListener
{


    use GeneralTrait;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(StartPeriodEvent $event)
    {


        $average = new Average ;

        $Bill=StartPeriods::findOrFail($event->ID);
        $branch=Stores::findOrFail($event->requests['Store']);
        $def=StoresDefaultData::latest('id')->first();




        //Products Details and Qties


        if(!empty($event->requests['Unit'])){

            $P_Ar_Name=$event->requests['P_Ar_Name'];
            $P_En_Name=$event->requests['P_En_Name'];
            $Unit=$event->requests['Unit'];
            $P_Code=$event->requests['P_Code'];
            $Price_Sale=$event->requests['Price_Sale'];
            $Qty=$event->requests['Qty'];
            $Price=$event->requests['Price'];
            $Total=$event->requests['Total'];
            $Exp_Date=$event->requests['Exp_Date'];
            $Product=$event->requests['Product'];
            $VOne=$event->requests['VOne'];
            $VTwo=$event->requests['VTwo'];
            $V_Name=$event->requests['V_Name'];
            $VV_Name=$event->requests['VV_Name'];
            $Patch_Number=$event->requests['Patch_Number'];


            for($i=0 ; $i < count($Unit) ; $i++){


                $pp=ProductUnits::where('Product',$Product[$i])->where('Unit',$Unit[$i])->first();
                $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();


                $uu['P_Code']=$P_Code[$i];
                $uu['SmallCode']=$plow->Barcode;
                $uu['Qty']=$Qty[$i];
                $uu['SmallQty']=$Qty[$i]  * $pp->Rate;
                $uu['Price']=$Price[$i];
                $uu['Total']=$Total[$i];
                $uu['Old_Qty']=$Qty[$i];
                $uu['Exp_Date']=$Exp_Date[$i];
                $uu['SP_ID']=$Bill->id;
                $uu['Date']=$event->requests['Date'] ;
                $uu['Store']=$event->requests['Store'];
                $uu['User']=auth()->guard('admin')->user()->id;
                $uu['Unit']=$Unit[$i];
                $uu['P_Ar_Name']=$P_Ar_Name[$i];
                $uu['P_En_Name']=$P_En_Name[$i];
                $uu['V_Name']=$V_Name[$i];
                $uu['VV_Name']=$VV_Name[$i];
                $uu['Product']=$Product[$i];
                $uu['Patch_Number']=$Patch_Number[$i];


                if( !empty($V_Name[$i]) and  !empty($VV_Name[$i])){

                    $my_value = $V_Name[$i];
                    $first_word = explode(' - ',trim($my_value))[0];
                    $second_word = explode(' - ',trim($my_value))[1];

                    $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                    $vvId=SubVirables::where('Name','like', $second_word.'%')->first();

                    if(empty($vId)){
                        $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                    }

                    if(empty($vvId)){
                        $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                    }

                    $uu['V1']=$vId->id;
                    $uu['V2']=$vvId->id;

                }else{

                    $uu['V1']=$VOne[$i];
                    $uu['V2']=$VTwo[$i];
                }

                ProductsStartPeriods::create($uu);



                $Quantity=$this->ProAvQties($event->requests['Store'],$Product[$i],$P_Code[$i]);


                    if(!empty($Quantity)){

                        //if have old Qty

                        $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                        $plow=ProductUnits::where('Product',$Product[$i])->where('Def',1)->first();

                        $qq= $unit->Rate * $Qty[$i] ;
                        $newqty=$Quantity->Qty + $qq ;

                        $ty=$average->AverageCost($Total[$i],$qq,$Product[$i],$P_Code[$i],$event->requests['Store'],$event->requests['Date'],$Price[$i]);




                        $prooooo=Products::findOrFail($Product[$i]);

                        if($prooooo->P_Type == 'Serial' or $prooooo->P_Type == 'Single_Variable' or $prooooo->P_Type == 'Duble_Variable' ) {
                            $lastOperation=ProductMoves::latest('id')->where('P_Code',$P_Code[$i])->where('Product',$Product[$i])->where('Store',$event->requests['Store'])->first();
                        }else{
                            $lastOperation=ProductMoves::latest('id')->where('Product',$Product[$i])->where('Store',$event->requests['Store'])->first();
                        }





                        $in=$Total[$i];
                        $out=0;
                        if(!empty($lastOperation)){
                            $current=$lastOperation->CostCurrent + ($Total[$i] / $unit->Rate);
                        }else{
                            $current= ($Total[$i] / $unit->Rate);
                        }
                        $cur=$newqty * $ty ;

                        //Add Qty to Store
                        ProductsQty::where('id',$Quantity->id)->update(['Qty'=>$newqty,'Exp_Date'=>$Exp_Date[$i],'Price'=>$ty , 'TotalCost'=>$cur]);

                        $prooooo=Products::find($Product[$i]);

                        //Product Moves
                        $move=[

                            'Date'=>$event->requests['Date'],
                            'Type'=>  'بدايه فتره' ,
                            'TypeEn'=>'Start Period',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$qq,
                            'Outcom'=>0,
                            'Current'=>$newqty,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name[$i],
                            'P_En_Name'=>$P_En_Name[$i],
                            'P_Code'=>$P_Code[$i],
                            'Unit'=>$Unit[$i],
                            'Qty'=>$Qty[$i],
                            'Group'=>$prooooo->Group,
                            'Store'=>$event->requests['Store'],
                            'Product'=>$Product[$i],
                            'V1'=>$VOne[$i],
                            'V2'=>$VTwo[$i],
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>null,
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);



                    }else{


                        //if new Qty in Store

                        if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){
                            $my_value = $V_Name[$i];
                            $first_word = explode(' - ',trim($my_value))[0];
                            $second_word = explode(' - ',trim($my_value))[1];
                            $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                            $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                            if(empty($vId)){
                                $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                            }
                            if(empty($vvId)){
                                $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                            }
                            $sNam=$first_word;
                            $sId=$vId->id;
                            $ssNam=$second_word;
                            $ssId=$vvId->id;
                        }else{
                            $sNam=$V_Name[$i];
                            $ssNam=$VV_Name[$i];
                            $sId=$VOne[$i];
                            $ssId=$VTwo[$i];
                        }

                        $id_store = DB::table('products_stores')->insertGetId(

                            array(

                                'P_Ar_Name' => $P_Ar_Name[$i],
                                'P_En_Name' => $P_En_Name[$i],
                                'P_Code' => $P_Code[$i],
                                'Exp_Date' => $Exp_Date[$i],
                                'Product' => $Product[$i],
                                'Store' =>$event->requests['Store'],
                                'V1' => $sId,
                                'V2' => $ssId,
                                'V_Name' => $sNam,
                                'VV_Name' => $ssNam,

                            )
                        );

                        $prooooo=Products::find($Product[$i]);
                        $PRICE_RATE=$Price[$i]  /  $pp->Rate ;
                        $pqty['P_Ar_Name']=$P_Ar_Name[$i];
                        $pqty['Exp_Date']=$Exp_Date[$i];
                        $pqty['P_En_Name']=$P_En_Name[$i];
                        $pqty['Qty']=$Qty[$i] * $pp->Rate;
                        $pqty['Price']=$PRICE_RATE;
                        $pqty['TotalCost']=$PRICE_RATE * ($Qty[$i] * $pp->Rate);
                        $pqty['Pro_Stores']=$id_store;
                        $pqty['Store']=$event->requests['Store'];
                        $pqty['Unit']=$Unit[$i];
                        $pqty['Low_Unit']=$plow->Unit;
                        $pqty['Product']=$Product[$i];
                        $pqty['Price_Sale']=$Price_Sale[$i];
                        $pqty['SearchCode1']=$prooooo->SearchCode1;
                        $pqty['SearchCode2']=$prooooo->SearchCode2;
                        if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){
                            $my_value = $V_Name[$i];
                            $first_word = explode(' - ',trim($my_value))[0];
                            $second_word = explode(' - ',trim($my_value))[1];
                            $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                            $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                            if(empty($vId)){
                                $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                            }
                            if(empty($vvId)){
                                $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                            }
                            $pqty['V1']=$vId->id;
                            $pqty['V2']=$vvId->id;
                            $pqty['V_Name']=$first_word;
                            $pqty['VV_Name']=$second_word;
                            $pqty['P_Code']=$P_Code[$i];

                        }else{

                            if($prooooo->P_Type == 'Serial'){

                                $pqty['V1']=$VOne[$i];
                                $pqty['V2']=$VTwo[$i];
                                $pqty['V_Name']=$V_Name[$i];
                                $pqty['VV_Name']=$VV_Name[$i];
                                $pqty['P_Code']=$P_Code[$i];

                            }else{


                                if($prooooo->P_Type == 'Single_Variable'){
                                    $pqty['V1']=$VOne[$i];
                                    $pqty['V2']=$VTwo[$i];
                                    $pqty['V_Name']=$V_Name[$i];
                                    $pqty['VV_Name']=$VV_Name[$i];
                                    $pqty['P_Code']=$P_Code[$i];

                                }elseif($prooooo->P_Type == 'Duble_Variable'){

                                    $pqty['P_Code']=$P_Code[$i];

                                }else{

                                    $coco=array();
                                    $CodesPrds=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
                                    foreach($CodesPrds as $cco){

                                        array_push($coco,$cco->Barcode);

                                    }

                                    $pqty['V1']=$VOne[$i];
                                    $pqty['V2']=$VTwo[$i];
                                    $pqty['V_Name']=$V_Name[$i];
                                    $pqty['VV_Name']=$VV_Name[$i];
                                    $pqty['P_Code']=$coco[0];

                                    if(!empty($coco[1])){
                                        $pqty['PP_Code']=$coco[1];
                                    }else{
                                        $pqty['PP_Code']=null;
                                    }

                                    if(!empty($coco[2])){
                                        $pqty['PPP_Code']=$coco[2];
                                    }else{
                                        $pqty['PPP_Code']=null;
                                    }

                                    if(!empty($coco[3])){
                                        $pqty['PPPP_Code']=$coco[3];
                                    }else{
                                        $pqty['PPPP_Code']=null;
                                    }

                                }


                            }


                        }
                        $pqty['Group']=$prooooo->Group;
                        $pqty['Brand']=$prooooo->Brand;
                        $pqty['Branch']=$branch->Branch;
                        ProductsQty::create($pqty);



                        //product Moves
                        $newQQty=$Qty[$i] * $pp->Rate;
                        $ty=$average->AverageCost($Total[$i],$newQQty,$Product[$i],$plow->Barcode,$event->requests['Store'],$event->requests['Date'],$Price[$i]);

                        if($ty != 0){
                            $in=($Qty[$i] * $pp->Rate) * $ty ;
                            $out=0;
                            $current=($Qty[$i] * $pp->Rate) * $ty ;
                        }else{
                            $in=($Qty[$i] * $pp->Rate) * 1;
                            $out=0;
                            $current=($Qty[$i] * $pp->Rate) * 1;
                        }


                        //Product Moves
                        $move=[

                            'Date'=>$event->requests['Date'],
                            'Type'=>  'بدايه فتره' ,
                            'TypeEn'=>'Start Period',
                            'Bill_Num'=>$Bill->Code,
                            'Incom'=>$Qty[$i] * $pp->Rate,
                            'Outcom'=>0,
                            'Current'=>$Qty[$i] * $pp->Rate,
                            'CostIn'=>number_format((float)$in, 2, '.', ''),
                            'CostOut'=>number_format((float)$out, 2, '.', ''),
                            'CostCurrent'=>number_format((float)$current, 2, '.', ''),
                            'P_Ar_Name'=>$P_Ar_Name[$i],
                            'P_En_Name'=>$P_En_Name[$i],
                            'P_Code'=>$P_Code[$i],
                            'Unit'=>$Unit[$i],
                            'Qty'=>$Qty[$i],
                            'Group'=>$prooooo->Group,
                            'Store'=>$event->requests['Store'],
                            'Product'=>$Product[$i],
                            'V1'=>$VOne[$i],
                            'V2'=>$VTwo[$i],
                            'Brand'=>$prooooo->Brand,
                            'Safe'=>null,
                            'Branch'=>$branch->Branch,
                            'SalePrice'=>$plow->Price,
                            'ProductPrice'=>null,
                            'Delegate'=>null,
                            'Payment_Method'=>null,
                            'User'=>auth()->guard('admin')->user()->id,

                        ];

                        $this->ProductMoves($move);


                    }


                    //Expire Date
                    if(!empty($Exp_Date[$i])){


                        $unit=ProductUnits::where('Unit',$Unit[$i])->where('Product',$Product[$i])->first();
                        $EXPO=$this->ExpireAvQties($event->requests['Store'],$Product[$i],$P_Code[$i]);



                        if(!empty($EXPO)){


                            if($EXPO->Exp_Date == $Exp_Date[$i]){

                                $qq= $unit->Rate * $Qty[$i] ;
                                $NewExpQty=$EXPO->Qty + $qq ;
                                ExpireDateQty::where('id',$EXPO->id)->update(['Qty'=>$NewExpQty]);

                            }else{


                                $EXNEW['Qty']=$unit->Rate * $Qty[$i];
                                $EXNEW['P_Ar_Name']=$EXPO->P_Ar_Name;
                                $EXNEW['P_En_Name']=$EXPO->P_En_Name;
                                $EXNEW['P_Code']=$EXPO->P_Code;
                                $EXNEW['PP_Code']=$EXPO->PP_Code;
                                $EXNEW['PPP_Code']=$EXPO->PPP_Code;
                                $EXNEW['PPPP_Code']=$EXPO->PPPP_Code;
                                $EXNEW['V_Name']=$EXPO->V_Name;
                                $EXNEW['VV_Name']=$EXPO->VV_Name;
                                $EXNEW['Store']=$EXPO->Store;
                                $EXNEW['Unit']=$EXPO->Unit;
                                $EXNEW['Product']=$EXPO->Product;
                                $EXNEW['V1']=$EXPO->V1;
                                $EXNEW['V2']=$EXPO->V2;
                                $EXNEW['Low_Unit']=$EXPO->Low_Unit;
                                $EXNEW['Exp_Date']=$Exp_Date[$i];
                                $EXNEW['Group']=$EXPO->Group;
                                $EXNEW['Brand']=$EXPO->Brand;
                                $EXNEW['Branch']=$EXPO->Branch;

                                ExpireDateQty::create($EXNEW);

                            }


                        }else{

                            $CodesProducts=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
                            $prooooo=Products::find($Product[$i]);


                            if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ',trim($my_value))[0];
                                $second_word = explode(' - ',trim($my_value))[1];

                                $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                                $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                                if(empty($vId)){
                                    $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                                }

                                if(empty($vvId)){
                                    $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                                }
                                $sNam=$first_word;
                                $sId=$vId->id;
                                $ssNam=$second_word;
                                $ssId=$vvId->id;

                            }else{

                                $sNam=$V_Name[$i];
                                $ssNam=$VV_Name[$i];
                                $sId=$VOne[$i];
                                $ssId=$VTwo[$i];
                            }

                            $EXNEW['Qty']=$unit->Rate * $Qty[$i];
                            $EXNEW['P_Ar_Name']=$P_Ar_Name[$i];
                            $EXNEW['P_En_Name']=$P_En_Name[$i];
                            $EXNEW['P_Code']=$P_Code[$i];
                            $EXNEW['Store']=$event->requests['Store'];
                            $EXNEW['V1']=$sId;
                            $EXNEW['V2']=$ssId;
                            $EXNEW['Exp_Date']=$Exp_Date[$i];
                            $EXNEW['Unit']=$Unit[$i];
                            $EXNEW['Product']=$Product[$i];
                            $EXNEW['V_Name']=$sNam;
                            $EXNEW['VV_Name']=$ssNam;
                            $cocoSS=array();

                            foreach($CodesProducts as $ccoPro){


                                array_push($cocoSS,$ccoPro->Barcode);

                            }

                            $EXNEW['P_Code']=$cocoSS[0];

                            if(!empty($coco[1])){
                                $EXNEW['PP_Code']=$cocoSS[1];
                            }else{
                                $EXNEW['PP_Code']=null;
                            }

                            if(!empty($coco[2])){
                                $EXNEW['PPP_Code']=$cocoSS[2];
                            }else{
                                $EXNEW['PPP_Code']=null;
                            }

                            if(!empty($coco[3])){
                                $EXNEW['PPPP_Code']=$cocoSS[3];
                            }else{
                                $EXNEW['PPPP_Code']=null;
                            }

                            $EXNEW['Group']=$prooooo->Group;
                            $EXNEW['Brand']=$prooooo->Brand;
                            $EXNEW['Branch']=$branch->Branch;
                            $EXNEW['Low_Unit']=$plow->Unit;
                            ExpireDateQty::create($EXNEW);

                        }



                    }

                    //Fifo
                    if($def->Cost_Price == 2){


                        $fifo=$this->FifoAvQty($event->requests['Store'],$Product[$i],$P_Code[$i],$event->requests['Date']);


                        if(!empty($fifo)){

                            $qq= $pp->Rate * $Qty[$i] ;

                            $newqty=$fifo->Qty + $qq ;

                            FifoQty::where('id',$fifo->id)->update(['Qty'=>$newqty,'Original_Qty'=>$newqty]);

                        }else{


                            if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ',trim($my_value))[0];
                                $second_word = explode(' - ',trim($my_value))[1];

                                $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                                $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                                if(empty($vId)){
                                    $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                                }

                                if(empty($vvId)){
                                    $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                                }
                                $sNam=$first_word;
                                $sId=$vId->id;
                                $ssNam=$second_word;
                                $ssId=$vvId->id;

                            }else{

                                $sNam=$V_Name[$i];
                                $ssNam=$VV_Name[$i];
                                $sId=$VOne[$i];
                                $ssId=$VTwo[$i];
                            }

                            $prooooo=Products::find($Product[$i]);

                            $pqty['P_Ar_Name']=$P_Ar_Name[$i];
                            $pqty['Exp_Date']=$Exp_Date[$i];
                            $pqty['P_En_Name']=$P_En_Name[$i];
                            $pqty['Qty']=$Qty[$i] * $pp->Rate;
                            $pqty['Original_Qty']=$Qty[$i] * $pp->Rate;
                            $pqty['Cost_Price']=$Price[$i];
                            $pqty['Store']=$event->requests['Store'];
                            $pqty['Unit']=$Unit[$i];
                            $pqty['Low_Unit']=$plow->Unit;
                            $pqty['Product']=$Product[$i];
                            $pqty['SearchCode1']=$prooooo->SearchCode1;
                            $pqty['SearchCode2']=$prooooo->SearchCode2;
                            if( !empty($V_Name[$i]) and !empty($VV_Name[$i])){

                                $my_value = $V_Name[$i];
                                $first_word = explode(' - ',trim($my_value))[0];
                                $second_word = explode(' - ',trim($my_value))[1];

                                $vId=SubVirables::where('Name','like', $first_word.'%')->first();
                                $vvId=SubVirables::where('Name','like', $second_word.'%')->first();
                                if(empty($vId)){
                                    $vId=SubVirables::where('NameEn','like', $first_word.'%')->first();
                                }

                                if(empty($vvId)){
                                    $vvId=SubVirables::where('NameEn','like', $second_word.'%')->first();
                                }
                                $pqty['V1']=$vId->id;
                                $pqty['V2']=$vvId->id;
                                $pqty['V_Name']=$first_word;
                                $pqty['VV_Name']=$second_word;
                                $pqty['P_Code']=$P_Code[$i];

                            }else{



                                if($prooooo->P_Type == 'Serial'){

                                    $pqty['V1']=$VOne[$i];
                                    $pqty['V2']=$VTwo[$i];
                                    $pqty['V_Name']=$V_Name[$i];
                                    $pqty['VV_Name']=$VV_Name[$i];
                                    $pqty['P_Code']=$P_Code[$i];

                                }else{


                                    if($prooooo->P_Type == 'Single_Variable'){
                                        $pqty['V1']=$VOne[$i];
                                        $pqty['V2']=$VTwo[$i];
                                        $pqty['V_Name']=$V_Name[$i];
                                        $pqty['VV_Name']=$VV_Name[$i];
                                        $pqty['P_Code']=$P_Code[$i];

                                    }elseif($prooooo->P_Type == 'Duble_Variable'){

                                        $pqty['P_Code']=$P_Code[$i];

                                    }else{



                                        $coco=array();
                                        $CodesPrds=ProductUnits::where('Product',$Product[$i])->select('Barcode')->get();
                                        foreach($CodesPrds as $cco){


                                            array_push($coco,$cco->Barcode);

                                        }

                                        $pqty['V1']=$VOne[$i];
                                        $pqty['V2']=$VTwo[$i];
                                        $pqty['V_Name']=$V_Name[$i];
                                        $pqty['VV_Name']=$VV_Name[$i];
                                        $pqty['P_Code']=$coco[0];

                                        if(!empty($coco[1])){
                                            $pqty['PP_Code']=$coco[1];
                                        }else{
                                            $pqty['PP_Code']=null;
                                        }

                                        if(!empty($coco[2])){
                                            $pqty['PPP_Code']=$coco[2];
                                        }else{
                                            $pqty['PPP_Code']=null;
                                        }

                                        if(!empty($coco[3])){
                                            $pqty['PPPP_Code']=$coco[3];
                                        }else{
                                            $pqty['PPPP_Code']=null;
                                        }

                                    }


                                }


                            }
                            $pqty['Group']=$prooooo->Group;
                            $pqty['Brand']=$prooooo->Brand;
                            $pqty['Branch']=$branch->Branch;
                            $pqty['Purchases_Date']=$event->requests['Date'];
                            FifoQty::create($pqty);

                        }




                    }


            }


        }


        //Joun

        $JunID = DB::table('journalizings')->insertGetId(

            array(


                'Type' => 'اصناف بداية فترة',
                'TypeEn' => 'Start Period Products',
                'Code_Type' => $Bill->Code,
                'Date' =>$event->requests['Date'] ,
                'Draw' =>$event->requests['Draw'],
                'Coin' =>$event->requests['Coin'],
                'Cost_Center' => null,
                'Total_Debaitor' =>$event->requests['TotalPrice'],
                'Total_Creditor' =>$event->requests['TotalPrice'],
                'Note' =>$event->requests['Note'],

            )
        );

        $Code=Journalizing::findOrFail($JunID)->Code;


        $store=Stores::find($event->requests['Store']);
        $s=Stores::find($event->requests['Store']);

        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=$event->requests['TotalPrice'];
        $PRODUCTSS['Creditor']=0;
        $PRODUCTSS['Account']=$store->Account;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$event->requests['Date'];
        $Gen['Type']= 'اصناف بداية فترة';
        $Gen['TypeEn']='Start Period Products';
        $Gen['Debitor']=$event->requests['TotalPrice'];
        $Gen['Creditor']=0;
        $Gen['Statement']=null;
        $Gen['Draw']=$event->requests['Draw'];
        $Gen['Debitor_Coin']= $event->requests['Draw'] * $event->requests['TotalPrice'];
        $Gen['Creditor_Coin']=$event->requests['Draw'] * 0;
        $Gen['Account']=$store->Account;
        $Gen['Coin']= $event->requests['Coin'];
        $Gen['Cost_Center']=null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);


        $PRODUCTSS['Joun_ID']=$JunID;
        $PRODUCTSS['Debitor']=0;
        $PRODUCTSS['Creditor']=$event->requests['TotalPrice'];
        $PRODUCTSS['Account']=45;
        $PRODUCTSS['Statement']=null;


        JournalizingDetails::create($PRODUCTSS);

        $Gen['Code']=$Code;
        $Gen['Code_Type']=$Bill->Code;
        $Gen['Date']=$event->requests['Date'];
        $Gen['Type']= 'اصناف بداية فترة';
        $Gen['TypeEn']='Start Period Products';
        $Gen['Debitor']=0;
        $Gen['Creditor']=$event->requests['TotalPrice'];
        $Gen['Statement']=null;
        $Gen['Draw']=$event->requests['Draw'];
        $Gen['Debitor_Coin']= $event->requests['Draw'] * 0;
        $Gen['Creditor_Coin']=$event->requests['Draw'] * $event->requests['TotalPrice'];
        $Gen['Account']=45;
        $Gen['Coin']= $event->requests['Coin'];
        $Gen['Cost_Center']= null;
        $Gen['userr']= auth()->guard('admin')->user()->id;

        GeneralDaily::create($Gen);



        //Stores Moves
        $totpri=($event->requests['TotalPrice']) ;

        $dataStMove=[

            'Date'=>date('Y-m-d'),
            'Code'=>$Bill->Code ,
            'Time'=>date("h:i:s a", time()),
            'Branch'=>$branch->Branch,
            'Store'=>$event->requests['Store'],
            'Safe'=>null,
            'Type'=>'بدايه فتره',
            'TypeEn'=>'Start Period',
            'Cost_Center'=>null,
            'User'=>auth()->guard('admin')->user()->id,
            'Coin'=>$event->requests['Coin'],
            'Note'=>$event->requests['Note'],
            'Total_Qty'=>$event->requests['TotalQty'],
            'Total_Price'=>$totpri,
            'Account'=>null,
            'Ship'=>null,
            'ID'=>$event->ID,

        ];

        $this->StoresMoves($dataStMove);







    }
}
