<?php

namespace App\Listeners\Products;

use App\Events\AddProductEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\PaymentVoucherDetails;
use App\Models\ProductUnits;
use App\Models\Products;
use App\Models\SubImages;
use App\Events\AddJournalizingEvent;
use DB;
use App\Services\ProductService;

class AddProductListener
{


     use GeneralTrait;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(AddProductEvent $event)
    {

       $service = new ProductService ;



        if(!empty($event->requests['P_En_Name'])){
         $english_name=$event->requests['P_En_Name'];
         }else{
         $english_name=$event->requests['P_Ar_Name'];
         }



     if(!empty($event->requests['Tax'])){

     $tax=$event->requests['Tax'];
     }else{

     $tax=1;

     }

     if(!empty($event->requests['P_En_Name'])){

     $EnName=$event->requests['P_En_Name'];
     }else{

     $EnName=$event->requests['P_Ar_Name'];

     }

     if(!empty($event->requests['Minimum'])){
     $mini=$event->requests['Minimum'] ;
     }else{
     $mini=0;
     }

     if(!empty($event->requests['Maximum_Sales_Qty'])){
     $MAX=$event->requests['Maximum_Sales_Qty'] ;
     }else{
     $MAX=1000000;
     }

        $image=request()->file('Image');
        $img=$this->UploadFile($image);

        $image2=request()->file('Image2');
        $img2=$this->UploadFile($image2);

     $ID = DB::table('products')->insertGetId(

     array(
     'P_Type' => $event->requests['P_Type'],
     'P_Ar_Name' => $event->requests['P_Ar_Name'],
     'P_En_Name' => $english_name,
     'Brand' => $event->requests['Brand'],
     'Group' => $event->requests['Group'],
     'Offer' => $event->requests['Offer'],
     'OfferPrice' => $event->requests['OfferPrice'],
     'Image' =>$img,
     'Image2' =>$img2,
     'Minimum' => $mini,
     'Maximum' => $event->requests['Maximum'],
     'Length' => $event->requests['Length'],
     'Width' => $event->requests['Width'],
     'Height' => $event->requests['Height'],
     'Weight' => $event->requests['Weight'],
     'Saller_Point' => $event->requests['Saller_Point'],
     'Customer_Point' => $event->requests['Customer_Point'],
     'Tax' => $tax,
     'Validity' => $event->requests['Validity'],
     'Days_Notify' => $event->requests['Days_Notify'],
     'Ar_Desc' => $event->requests['Ar_Desc'],
     'En_Desc' => $event->requests['En_Desc'],
     'Ar_Spec' => $event->requests['Ar_Spec'],
     'En_Spec' => $event->requests['En_Spec'],
     'Store_Show' => $event->requests['Store_Show'],
     'Store_Type' => $event->requests['Store_Type'],
     'Sub_Cost' => $event->requests['Sub_Cost'],
     'Cas_No' => $event->requests['Cas_No'],
     'HSN' => $event->requests['HSN'],
     'Code_Type' => $event->requests['Code_Type'],
     'World_Code' => $event->requests['World_Code'],
     'Uni_Code' => $event->requests['Uni_Code'],
     'subscribe_type' => $event->requests['subscribe_type'],
     'Origin_Number' => $event->requests['Origin_Number'],
     'Origin_Country' => $event->requests['Origin_Country'],
     'SearchCode1' => $event->requests['SearchCode1'],
     'SearchCode2' => $event->requests['SearchCode2'],
     'Space' => $event->requests['Space'],
     'Storage' => $event->requests['Storage'],
     'Processor' => $event->requests['Processor'],
     'Camera' => $event->requests['Camera'],
     'Screen' => $event->requests['Screen'],
     'OS' => $event->requests['OS'],
     'Battery' => $event->requests['Battery'],
     'Warranty' => $event->requests['Warranty'],
     'Color' => $event->requests['Color'],
     'Category' => $event->requests['Category'],
     'Model' => $event->requests['Model'],
     'Guess_Price' => $event->requests['Guess_Price'],
     'Offer_Start_Date' => $event->requests['Offer_Start_Date'],
     'Offer_End_Date' => $event->requests['Offer_End_Date'],
     'Arrange' => $event->requests['Arrange'],
     'Show_Other_Store' => $event->requests['Show_Other_Store'],
     'Arabic_Brief_Desc' => $event->requests['Arabic_Brief_Desc'],
     'English_Brief_Desc' => $event->requests['English_Brief_Desc'],
     'Calories' => $event->requests['Calories'],
     'Thickness' => $event->requests['Thickness'],
     'Cost_Price' => $event->requests['Cost_Price'],
     'Maximum_Sales_Qty' => $MAX,
     'Status' => 0,
     )
     );

     if(!empty($event->requests['Unit'])){

     $unit=$event->requests['Unit'];
     $rate=$event->requests['Rate'];
     $barcode=$event->requests['Barcode'];
     $price=$event->requests['Price'];
     $priceTwo=$event->requests['Price_Two'];
     $priceThree=$event->requests['Price_Three'];
     $default=$event->requests['Def'];


     for($i=0 ; $i < count($unit) ; $i++){

         $uu['Rate']=$rate[$i];
         $uu['Barcode']=$barcode[$i];
         $uu['Price']=$price[$i];
         $uu['Price_Two']=$priceTwo[$i];
         $uu['Price_Three']=$priceThree[$i];
         $uu['Def']=$default[$i];
         $uu['P_Ar_Name']=$event->requests['P_Ar_Name'];
         $uu['P_En_Name']=$english_name;
         $uu['P_Type']=$event->requests['P_Type'];
         $uu['Unit']=$unit[$i];
         $uu['Product']=$ID;
         $uu['Brand']=$event->requests['Brand'];
         $uu['Group']=$event->requests['Group'];
         ProductUnits::create($uu);
     }

     }

    $rr=ProductUnits::where('Product',$ID)->where('Def',1)->latest('id')->first();

            //Product Moves
        $move=[

            'Date'=>date('Y-m-d'),
            'Type'=>'رصيد سابق' ,
            'TypeEn'=>'Previous Balance',
            'Bill_Num'=>0,
            'Incom'=>0,
            'Outcom'=>0,
            'Current'=>0,
            'CostIn'=>0,
            'CostOut'=>0,
            'CostCurrent'=>0,
            'P_Ar_Name'=>$event->requests['P_Ar_Name'],
            'P_En_Name'=>$english_name,
            'P_Code'=>$rr->Barcode,
            'Unit'=>$rr->Unit,
            'Qty'=>0,
            'Group'=>$event->requests['Group'],
            'Store'=>null,
            'Product'=>$ID,
            'V1'=>null,
            'V2'=>null,
            'Brand'=>$event->requests['Brand'],
            'Safe'=>null,
            'Branch'=>null,
            'SalePrice'=>$rr->Price,
            'ProductPrice'=>null,
             'Delegate'=>null,
            'Payment_Method'=>null,
            'User'=>auth()->guard('admin')->user()->id,

        ];

    $this->ProductMoves($move);
    $service->ProductAdd($event->requests,$ID);


        if(!empty($event->requests['SubImage'])){
         foreach ($event->requests['SubImage'] as $photo) {
         $filename = $photo->store('ProductImagesCatlouge');
         SubImages::create([
         'Product' => $ID,
         'Image' => $filename
         ]);
         }
         }







    }
}
