<?php

namespace App\Listeners\PaymentVoucher;

use App\Events\SurePaymentVoucherEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\GeneralDaily;
use App\Models\SafesBanks;
use App\Models\PaymentVoucher;
use App\Events\AddJournalizingEvent;  
class SurePaymentVoucherListener
{
    

     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(SurePaymentVoucherEvent $event)
    {
              

          
                  
             $type_ar= 'سند صرف';
             $type_en= 'Payment Voucher';
             $type=0;
             $Status=1;
             $custom=1;
             $Branch=SafesBanks::where('Account',$event->requests['Safe'])->latest('id')->first()->Branch;
        
             $code_type=PaymentVoucher::findOrFail($event->requests['ID']);

             $custom_data=[
             'Debitor'=>0,
             'Creditor'=>$event->requests['Total_Debaitor'],
             'Account'=>$event->requests['Safe'],
             'Statement'=>$event->requests['Note'],
             'Safe'=>$event->requests['Safe'],
             'Branch'=>$Branch,
             'Code_Type'=>$code_type->Code,
             'Date'=>$event->requests['Date'],
             'Draw'=>$event->requests['Draw'],
             'Coin'=>$event->requests['Coin'],
             'Cost_Center'=>$event->requests['Cost_Center'],

             ];

             AddJournalizingEvent::dispatch($event->requests,$Status,$type,$type_ar,$type_en,$custom,$custom_data);       
 
   
                   
        $dataUser=[
        'screen_ar'=>'سند صرف',
        'screen_en'=>'Payment Voucher',
        'type_ar'=>'تأكيد',
        'type_en'=>'Sure',
        'explain_ar'=>$event->requests['Code'],
        'explain_en'=>$event->requests['Code'],
        ];
        $this->UserCustomMoves($dataUser);   
        
        
    
        //Notifications
    
            
              $order=[
                'noti_name_ar'=>'تأكيد سند صرف',
                'noti_name_en'=>'Payment Voucher  Confirmed',
                'type_ar'=>'سند صرف',
                'type_en'=>'Payment Voucher',
                'type_code'=>$event->requests['Code'],
                'emp'=>null,
                'client'=>null,
                'product'=>null,
                'store'=>null,
                'safe'=>null,
                'notify_name'=>trans('admin.Payment_Voucher_Confirmed'),
            ];      
            $this->CreateNotification($order);      
            

    
        
    }
}
