<?php

namespace App\Listeners\OpeningEntries;

use App\Events\AddOpeningEntriesEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\OpeningEntries;
use App\Models\OpeningEntriesDetails;
use App\Models\SafesBanks;
use App\Events\AddJournalizingEvent; 
use DB;

class AddOpeningEntriesListener
{
    

     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(AddOpeningEntriesEvent $event)
    {
        
        if(!empty($event->requests['SecAccount'])){
         $second=$event->requests['SecAccount'];   
        }else{
         $second=null;  
            
        }

        $IDD = DB::table('opening_entries')->insertGetId(
            
        array(
            
  
            'Date' => $event->requests['Date'],
             'Draw' => $event->requests['Draw'],
            'Coin' => $event->requests['Coin'],
            'Capital' => $event->requests['Capital'],
            'SecAccount' => $second,
            'Cost_Center' => $event->requests['Cost_Center'],
            'Total_Debaitor' =>$event->requests['Total_Debaitor'],
            'Total_Creditor' =>$event->requests['Total_Creditor'],
            'Note' =>$event->requests['Note'],
             'Status' => $event->status,
  
        )
    );
         
        
         
             
         $Debitor = $event->requests['Debitor'];
         $Creditor =$event->requests['Creditor'];
         $Account = $event->requests['Account'];
         $Statement = $event->requests['Statement'];


        for($z=0 ; $z < count($Debitor) ; $z++){
            
        $PRODUCTS['OP_ID']=$IDD;
        $PRODUCTS['Debitor']=$Debitor[$z];
        $PRODUCTS['Creditor']=$Creditor[$z];
        $PRODUCTS['Account']=$Account[$z];
        $PRODUCTS['Statement']=$Statement[$z];
            
  
         OpeningEntriesDetails::create($PRODUCTS);      
   
     
             }
          

          
        //Notifications
        if($event->status == 0){
            
              $order=[
                'noti_name_ar'=>'القيد الافتتاحي يحتاج للتأكيد',
                'noti_name_en'=>'Opening Entries Need Confirmation',
                'type_ar'=>'القيد الافتتاحي',
                'type_en'=>'Opening Entries',
                'type_code'=>$event->requests['Code'],
                'emp'=>null,
                'client'=>null,
                'product'=>null,
                'store'=>null,
                'safe'=>null,
                'notify_name'=>trans('admin.OpeningEntries_Need_Confirmation'),
            ];      
            $this->CreateNotification($order);      
            
            
        }
        

      //Recipt Jounralizing
         if($event->status == 1){
             
             $type_ar=   'القيد الإفتتاحي';
             $type_en= 'Opening Entries';
             $type=0;
             $Status=1;
             $custom=1;
             $code_type=OpeningEntries::findOrFail($IDD);

             $Dif=  $event->requests['Total_Debaitor'] - $event->requests['Total_Creditor'] ;
             
            if(!empty($event->requests['SecAccount'])){
             
             $acc=$event->requests['SecAccount'];
         }else{
             $acc=45;
         }
             
             
             if($event->requests['Capital'] < 0){
                 
                $cred=0;
                    $deb=$Dif; 
             }else{
                 
                      $cred=$Dif;
                    $deb=0; 
             }
             
             $custom_data=[
             'Debitor'=>$cred,
             'Creditor'=>$deb,
             'Account'=>$acc,
             'Statement'=>$event->requests['Note'],
             'Safe'=>null,
             'Branch'=>null,
             'Code_Type'=>$code_type->Code,
             'Date'=>$event->requests['Date'],
             'Draw'=>$event->requests['Draw'],
             'Coin'=>$event->requests['Coin'],
             'Cost_Center'=>$event->requests['Cost_Center'],

             ];
             
              

             AddJournalizingEvent::dispatch($event->requests,$Status,$type,$type_ar,$type_en,$custom,$custom_data);       
 
             
         }
        
        
           
   

        
        
    }
}
