<?php

namespace App\Listeners\Journalizing;

use App\Events\AddJournalizingEvent;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
 
class AddJournalizingListener
{
    

     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(AddJournalizingEvent $event)
    {
              

        if(!empty($event->requests['Branch'])){
          $branch=$event->requests['Branch'];  
        }else{
            $branch=null;
        }
        
        if(!empty($event->requests['Total_Debaitor'])){
          $totalll=$event->requests['Total_Debaitor'];  
        }else{
          $totalll=$event->requests['Total_Creditor'];
        }
        
          
        
        
       $data=[
             
             'type_ar'=>$event->type_ar,
             'type_en'=>$event->type_en,
             'code_type'=>$event->requests['Code'],
             'date'=>$event->requests['Date'],
             'draw'=>$event->requests['Draw'],
             'coin'=>$event->requests['Coin'],
             'cost_center'=>$event->requests['Cost_Center'],
             'note'=>$event->requests['Note'],       
             'total'=>$totalll,
             'branch'=>$branch,
             'status'=>$event->status,
         ];
         
             $joun_id=$this->CreateNewJun($data);   

         $type=$event->type;
         $Debitor =$event->requests['Debitor'];
         $Creditor =$event->requests['Creditor'];        
         $Account =$event->requests['Account'];
         $Statement =$event->requests['Statement'];
         $code=Journalizing::findorFail($joun_id);
             
        
     

        for($i=0 ; $i < count($Debitor) ; $i++){
            
            
                $dataDetails=[
             
             'type_ar'=>$event->type_ar,
             'type_en'=>$event->type_en,
             'code_type'=>$event->requests['Code'],
             'date'=>$event->requests['Date'],
             'draw'=>$event->requests['Draw'],
             'coin'=>$event->requests['Coin'],
             'cost_center'=>$event->requests['Cost_Center'],
             'note'=>$Statement[$i],       
             'debitor'=>$Debitor[$i],       
             'creditor'=>$Creditor[$i],       
             'account'=>$Account[$i],       
             'branch'=>$branch,       
             'joun_id'=>$joun_id,
             'code'=>$code->Code,
         ];
            
            


            
            $this->OneJunDetails($dataDetails,$type);     
            
            
     
             }
        
        
        //Notifications
        
        if($type == 1){
            
              $order=[
                'noti_name_ar'=>'قيد يومي يحتاج للتأكيد',
                'noti_name_en'=>'Journalizings Need Confirmation',
                'type_ar'=>'القيد اليومي',
                'type_en'=>'Journalizings',
                'type_code'=>$event->requests['Code'],
                'emp'=>null,
                'client'=>null,
                'product'=>null,
                'store'=>null,
                'safe'=>null,
                'notify_name'=>trans('admin.Journalizings_Need_Confirmation'),
            ];      
            $this->CreateNotification($order);      
            
            
        }
        
        
        if($event->custom != 0){

         $dataDetails=[
             
             'type_ar'=>$event->type_ar,
             'type_en'=>$event->type_en,
             'code_type'=>$event->custom_data['Code_Type'],
             'date'=>$event->custom_data['Date'],
             'draw'=>$event->custom_data['Draw'],
             'coin'=>$event->custom_data['Coin'],
             'cost_center'=>$event->custom_data['Cost_Center'],
             'note'=>$event->custom_data['Statement'],       
             'debitor'=>$event->custom_data['Debitor'],       
             'creditor'=>$event->custom_data['Creditor'],       
             'account'=>$event->custom_data['Account'],       
             'branch'=>$event->custom_data['Branch'],       
             'joun_id'=>$joun_id,
             'code'=>$code->Code,
         ];
            
          
            $this->OneJunDetails($dataDetails,$type);        
             
            
        }
    
       
      

        
        
    }
}
