<?php

namespace App\Listeners\Investors;

use App\Events\InvestorsDue;

use App\Models\GeneralDaily;
use App\Models\Investors;
use App\Models\Journalizing;
use App\Models\JournalizingDetails;
use App\Models\PayProfitInvestors;
use App\Traits\GeneralTrait;
use DB;
use DateTime;

class InvestorsDueListener
{


    use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(InvestorsDue $event)
    {

      $Investors=Investors::where('Status',0)->get();

      foreach ($Investors as $Investor) {

          $Code=$this->ReturnCode(Journalizing::class);

              $Draw=$Investor->Draw;
          $Coin=$Investor->Coin;

          $from=date('Y-m-01', strtotime('-1 MONTH'));
          $to=date('Y-m-01');

          $profit=$this->TOTALPROFIT($from,$to);


$precent=$Investor->Profit_Precent / 100 ;
          $Creditor= $profit * $precent ;
$CreditorAccount=$Investor->Due_Account;
$DebitorAccount=$Investor->Expenses_Account;

          $type_ar= 'القيود اليومية';
          $type_en='Journalizing';

          $ID = DB::table('journalizings')->insertGetId(

          array(


                  'Type' => $type_ar,
                  'TypeEn' => $type_en,
                  'Code_Type' => $Code,
                  'Date' => date('Y-m-d'),
                  'Draw' => $Draw,
                  'Coin' => $Coin,
                  'Cost_Center' => null,
                  'Total_Debaitor' => $Creditor,
                  'Total_Creditor' => $Creditor,
                  'Note' => null,

              )
          );


          $Codee=Journalizing::findOrFail($ID)->Code;

          $PRODUCTSS['Joun_ID']=$ID;
          $PRODUCTSS['Debitor']=0;
          $PRODUCTSS['Creditor']=$Creditor;
          $PRODUCTSS['Account']=$CreditorAccount;
          $PRODUCTSS['Statement']=null;


          JournalizingDetails::create($PRODUCTSS);

          $Gen['Code']=$Codee;
          $Gen['Code_Type']=$Code;
          $Gen['Date']=date('Y-m-d');
          $Gen['Type']= $type_ar;
          $Gen['TypeEn']=$type_en;
          $Gen['Debitor']=0;
          $Gen['Creditor']=$Creditor;
          $Gen['Statement']=null;
          $Gen['Draw']=$Draw;
          $Gen['Debitor_Coin']= $Draw * 0;
          $Gen['Creditor_Coin']=$Draw * $Creditor;
          $Gen['Account']=$CreditorAccount;
          $Gen['Coin']= $Coin;
          $Gen['Cost_Center']= null;
          $Gen['userr']= 1;

          GeneralDaily::create($Gen);


  $PRODUCTSS['Joun_ID']=$ID;
          $PRODUCTSS['Debitor']=$Creditor;
          $PRODUCTSS['Creditor']=0;
          $PRODUCTSS['Account']=$DebitorAccount;
          $PRODUCTSS['Statement']=null;


          JournalizingDetails::create($PRODUCTSS);

          $Gen['Code']=$Codee;
          $Gen['Code_Type']=$Code;
          $Gen['Date']=date('Y-m-d');
          $Gen['Type']= $type_ar;
          $Gen['TypeEn']=$type_en;
          $Gen['Debitor']=$Creditor;
          $Gen['Creditor']=0;
          $Gen['Statement']=null;
          $Gen['Draw']=$Draw;
          $Gen['Debitor_Coin']= $Draw * $Creditor;
          $Gen['Creditor_Coin']=$Draw * 0;
          $Gen['Account']=$DebitorAccount;
          $Gen['Coin']= $Coin;
          $Gen['Cost_Center']= null;
          $Gen['userr']= 1;

          GeneralDaily::create($Gen);



          $prof['Date']=date('Y-m-d');
          $prof['Profit']=$Creditor;
          $prof['Investor']=$Investor->id;

          PayProfitInvestors::create($prof);





      }




    }
}
