<?php

namespace App\Listeners\AccountManual;

use App\Events\CreateAccountManualEvent;
use App\Models\InstallmentCompanies;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Traits\GeneralTrait;
use App\Models\Journalizing;
use App\Models\SafesBanks;
use App\Models\Stores;
use App\Models\Vendors;
use App\Models\Customers;
use App\Models\Taxes;

class CreateAccountManualEventListener
{


     use GeneralTrait;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\TestEvent  $event
     * @return void
     */
    public function handle(CreateAccountManualEvent $event)
    {


    if($event->item->Parent == 28 or $event->item->Parent == 29){

        $Code=$this->ReturnCode(SafesBanks::class);

         $dataa['Code']=$Code;
         $dataa['Date']=date('Y-m-d');
         $dataa['Name']=$event->item->Name;
         $dataa['NameEn']=$event->item->NameEn;
         $dataa['Note']=$event->item->Note;
         $dataa['Account']=$event->item->id;
         $dataa['User']=auth()->guard('admin')->user()->id;
          if($event->item->Parent == 28){
            $dataa['Type']=1;
        }else{
             $dataa['Type']=2;
        }

         SafesBanks::create($dataa);


          }

        if($event->item->Parent == 27){

        $Code=$this->ReturnCode(Stores::class);

         $dataa['Code']=$Code;
         $dataa['Date']=date('Y-m-d');
         $dataa['Time']=date("h:i:s a", time());
         $dataa['Name']=$event->item->Name;
         $dataa['NameEn']=$event->item->NameEn;
         $dataa['Phone']=null;
         $dataa['Address']=null;
         $dataa['Account']=$event->item->id;
         $dataa['User']=auth()->guard('admin')->user()->id;

         Stores::create($dataa);
          }


            if($event->item->Parent == 37){

             $Code=$this->ReturnCode(Vendors::class);

         $dataa['Code']=$Code;
         $dataa['Name']=$event->item->Name;
         $dataa['NameEn']=$event->item->NameEn;
         $dataa['Phone']=null;
         $dataa['Phone2']=null;
         $dataa['Commercial_Register']=null;
         $dataa['Tax_Card']=null;
         $dataa['Price_Level']=1;
         $dataa['Account']=$event->item->id;
         $dataa['User']=auth()->guard('admin')->user()->id;

         Vendors::create($dataa);
          }


           if($event->item->Parent == 24){

            $Code=$this->ReturnCode(Customers::class);

         $dataa['Code']=$Code;
         $dataa['Name']=$event->item->Name;
         $dataa['NameEn']=$event->item->NameEn;
         $dataa['Price_Level']=1;
         $dataa['Account']=$event->item->id;
         $dataa['User']=auth()->guard('admin')->user()->id;

         Customers::create($dataa);
          }

            if($event->item->Parent == 97){

         $dataa['Name']=$event->item->Name;
         $dataa['NameEn']=$event->item->NameEn;
      $dataa['Account']=$event->item->id;

         ShippingCompany::create($dataa);
          }

           if($event->item->Parent == 39){


           $Code=$this->ReturnCode(Taxes::class);

         $data['Code']=$Code;
         $data['Name']=$event->item->Name;
         $data['NameEn']=$event->item->NameEn;
         $data['Rate']=0;
         $data['Type']=2;
         $data['Hide']=0;
         $data['Account']=$event->item->id;

         Taxes::create($data);
          }


        if($event->item->Parent == 888){

            $Acc=$this->CreateAccount('مصاريف'.' '.$event->item->Name,'Expenses'.' '.$event->item->NameEn ,853 ,null);
            $dataInstall['Arabic_Name']=$event->item->Name;
            $dataInstall['English_Name']=$event->item->NameEn;
            $dataInstall['Account']=$event->item->id;
            $dataInstall['NakdyaAccount']=$Acc;
            InstallmentCompanies::create($dataInstall);

        }




    }
}
