<?php

namespace App\Http\Resources;


use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Models\StoresDefaultData;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class TarnsferStoresFilterResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        $pro=ProductsQty::where('Product',$this->Product)->where('Store',$this->Store)->first();
        $plow=ProductUnits::where('Product',$this->Product)->where('Rate',1)->first();
        $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();
        $Def=StoresDefaultData::latest('id')->first();
        $average = new Average();

        if($Def->StoresTarnsferPrice == 0){
            //Cost

            $Price=$average->AverageCostGetUnit($this->Product,$rr->Barcode,$this->Store,$rr->Unit) ;

        }elseif($Def->StoresTarnsferPrice == 1){


            $Price=$rr->Price ;

        }

        $Old=$rr->Price;
$Cost=$average->AverageCostGetUnit($this->Product,$rr->Barcode,$this->Store,$rr->Unit) ;

        if($lang == 'ar'){
            $UName=$rr->Unit()->first()->Name;


        }else{

            $UName=$rr->Unit()->first()->NameEn;

        }

        $barcode='';

        if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'or $this->Product()->first()->P_Type == 'Additions'){


                                    $barcode=$rr->Barcode;



                            }elseif($this->Product()->first()->P_Type == 'Serial'){

            $barcode=$this->P_Code;

                            }elseif($this->Product()->first()->P_Type == 'Single_Variable'){


                                    $barcode=$this->P_Code;


                            }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){



                                    $barcode=$this->P_Code;


                            }

        $service = new SalesService() ;




        if($this->Qty != 0) {

            $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$barcode);
            $data = [

                'product_ar_name'=>$this->P_Ar_Name,
                'product_en_name'=>$this->P_En_Name,
                'product_id'=>$this->Product,
                'virable_one_id'=>$this->V1,
                'virable_two_id'=>$this->V2,
                'virable_one_name'=>$this->V_Name,
                'virable_two_name'=>$this->VV_Name,
                'product_code'=>$barcode,
                'unit_name'=>$UName,
                'unit_id'=>$rr->Unit,
                'units'=>$UNITS,
                'avalible_qty'=>$this->Qty / $rr->Rate,
                'trans_qty'=>1,
                'price'=>$Price,
                'total'=>$Price,
                'qty'=>$this->Qty,
                'OldPrice'=>$Old,
                'CostPrice'=>$Cost,
                'Exp_Date'=>$this->Exp_Date,


            ];
        }









        return $data ;
    }

}
