<?php

namespace App\Http\Resources;


use App\Models\ProductsQty;
use App\Models\ProductUnits;
use App\Services\Average;
use App\Services\SalesService;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class StoresCostResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');
        $average = new Average() ;


            $units=ProductUnits::where('Product',$this->Product)->get();
            $rr=ProductUnits::where('Product',$this->Product)->where('Def',1)->first();
            $plow=ProductUnits::where('Product',$this->Product)->where('Rate',1)->first();

            $AllQty=ProductsQty::where('Product',$this->Product)
                ->get()->sum('Qty');

            $Average = $average->AverageCostGetUnit($this->Product,$rr->Barcode,$this->Store,$rr->Unit)  ;
            $Cost = $Average * ($this->Qty / $rr->Rate)  ;
            if($lang == 'ar'){

                $ProName=$this->P_Ar_Name;
                $UniName=$rr->Unit()->first()->Name;
                $ProVName='';
                $ProVVName='';
                $Barcode='';

                if(!empty($rr->Product()->first()->Group()->first()->Name)){

                    $grouup=$rr->Product()->first()->Group()->first()->Name;
                }else{
                    $grouup='';
                }

                if(!empty($rr->Product()->first()->Brand()->first()->Name)){

                    $brandd=$rr->Product()->first()->Brand()->first()->Name;
                }else{
                    $brandd='';
                }



            }else{

                $ProName=$this->P_En_Name;
                $UniName=$rr->Unit()->first()->NameEn;
                $ProVName='';
                $ProVVName='';
                $Barcode='';

                if(!empty($rr->Product()->first()->Group()->first()->NameEn)){

                    $grouup=$rr->Product()->first()->Group()->first()->NameEn;
                }else{
                    $grouup='';
                }

                if(!empty($rr->Product()->first()->Brand()->first()->NameEn)){

                    $brandd=$rr->Product()->first()->Brand()->first()->NameEn;
                }else{
                    $brandd='';
                }



            }



        if(!empty($rr->Product()->first()->Space)){

            $Space=$rr->Product()->first()->Space;
        }else{
            $Space='';
        }

        if(!empty($rr->Product()->first()->Storage)){

            $Storage=$rr->Product()->first()->Storage;
        }else{
            $Storage='';
        }

        if(!empty($rr->Product()->first()->Processor)){

            $Processor=$rr->Product()->first()->Processor;
        }else{
            $Processor='';
        }

        if(!empty($rr->Product()->first()->Camera)){

            $Camera=$rr->Product()->first()->Camera;
        }else{
            $Camera='';
        }

        if(!empty($rr->Product()->first()->Screen)){

            $Screen=$rr->Product()->first()->Screen;
        }else{
            $Screen='';
        }

        if(!empty($rr->Product()->first()->OS)){

            $OS=$rr->Product()->first()->OS;
        }else{
            $OS='';
        }

        if(!empty($rr->Product()->first()->Battery)){

            $Battery=$rr->Product()->first()->Battery;
        }else{
            $Battery='';
        }

        if(!empty($rr->Product()->first()->Warranty)){

            $Warranty=$rr->Product()->first()->Warranty;
        }else{
            $Warranty='';
        }

        if(!empty($rr->Product()->first()->Color)){

            $Color=$rr->Product()->first()->Color;
        }else{
            $Color='';
        }

        if(!empty($rr->Product()->first()->Category)){

            $Category=$rr->Product()->first()->Category;
        }else{
            $Category='';
        }

        if(!empty($rr->Product()->first()->Model)){

            $Model=$rr->Product()->first()->Model;
        }else{
            $Model='';
        }



            if($this->Product()->first()->P_Type == 'Completed' or $this->Product()->first()->P_Type == 'Raw' or $this->Product()->first()->P_Type == 'Industrial'){

                $Barcode=$rr->Barcode;

            }elseif($this->Product()->first()->P_Type == 'Serial'){

                $Barcode=$this->P_Code;

            }elseif($this->Product()->first()->P_Type == 'Single_Variable'){

                $Barcode=$this->P_Code;
                if($lang == 'ar'){
                    $ProVName=$this->V1()->first()->Name;
                }else{
                    $ProVName=$this->V1()->first()->NameEn;
                }

            }elseif($this->Product()->first()->P_Type == 'Duble_Variable'){

                $Barcode=$this->P_Code;
                if($lang == 'ar'){
                    $ProVName=$this->V1()->first()->Name;
        $ProVVName=$this->V2()->first()->Name;
                }else{
                    $ProVName=$this->V1()->first()->NameEn;
  $ProVVName=$this->V2()->first()->NameEn;
                }
            }


        $service = new SalesService() ;

        $UNITS=$service->ProUnitsDataTwo($this->Product,$this->Store,$Barcode);


        $store = $request->get('store');
        if($this->Store == $store) {
            $data = [

                'barcode' => $Barcode,
                'name' => $ProName,
                'v_name' => $ProVName,
                'vv_name' => $ProVVName,
                'unit' => $UniName,
                'unit_id' => $this->Unit,
                'units' => $UNITS,
                'qty' => $this->Qty / $rr->Rate,
                'average' => number_format((float)($Average), 2, '.', ''),
                'cost' => number_format((float)($Cost), 2, '.', ''),
                'price_one' => $rr->Price,
                'price_two' => $rr->Price_Two,
                'price_three' => $rr->Price_Three,
                'qty_all_stores' => $AllQty,
                'group' => $grouup,
                'brand' => $brandd,
                'space' => $Space,
                'storage' => $Storage,
                'processor' => $Processor,
                'camera' => $Camera,
                'screen' => $Screen,
                'OS' => $OS,
                'battery' => $Battery,
                'warranty' => $Warranty,
                'color' => $Color,
                'category' => $Category,
                'model' => $Model,

            ];


        }

        return $data ;
    }

}
