<?php

namespace App\Http\Resources;
use App\Models\Addressses;
use App\Models\Customers;
use App\Models\ProductSales;
use App\Models\ProductSalesOrder;
use App\Models\ReturnSalesProducts;
use App\Models\Sales;
use Illuminate\Http\Resources\Json\JsonResource;
use DB;
use Auth;

class ReturnSalesResources extends JsonResource
{
    public function toArray($request)
    {

        $lang = $request->header('lang', '');

        if(!empty($this ->Executor()->first()->Name)){

            if($lang == 'ar'){
                $exe=$this ->Executor()->first()->Name;
            }else{
                $exe=$this ->Executor()->first()->NameEn;

            }

        }else{
            $exe='';
        }
        if(!empty($this ->Delegate()->first()->Name)){
            if($lang == 'ar'){
                $dele=$this ->Delegate()->first()->Name;
            }else{

                $dele=$this ->Delegate()->first()->NameEn;
            }
        }else{
            $dele='';
        }

        if($lang == 'ar'){
            $safeName=$this ->Safe()->first()->Name;
            $cliName=$this ->Client()->first()->Name;
            $stName=$this ->Store()->first()->Name;
            $coiName=$this ->Coin()->first()->Arabic_Name;
            $userName=$this ->User()->first()->name;

        }else{
            $safeName=$this ->Safe()->first()->NameEn;
            $cliName=$this ->Client()->first()->NameEn;
            $stName=$this ->Store()->first()->NameEn;
            $coiName=$this ->Coin()->first()->English_Name;
            $userName=$this ->User()->first()->nameEn;

        }

        if(!empty($this ->Cost_Center()->first()->Arabic_Name)){

            if($lang == 'ar'){
                $Cost_Center=$this ->Cost_Center()->first()->Arabic_Name;
            }else{
                $Cost_Center=$this ->Cost_Center()->first()->English_Name;

            }

        }else{
            $Cost_Center='';
        }
        if(!empty($this ->Ship()->first()->Name)){

            if($lang == 'ar'){
                $Ship=$this ->Ship()->first()->Name;
            }else{
                $Ship=$this ->Ship()->first()->NameEn;

            }

        }else{
            $Ship='';
        }


        if($this->Payment_Method == 'Cash'){
            $Payment_Method=trans('admin.Cash');
        }elseif ($this->Payment_Method == 'Later'){

            $Payment_Method=trans('admin.Later');
        }



        $data = [


            'id'=>$this ->id,
            'code'=>$this ->Code,
            'date'=>$this ->Date,
            'time'=>$this ->Time,
            'draw'=>$this ->Draw,
            'payment_method'=>$Payment_Method,
            'refernce_number'=>$this ->Refernce_Number,
            'note'=>$this ->Note,
            'product_numbers'=>$this ->Product_Numbers,
            'total_qty'=>$this ->Total_Return_Qty,
            'total_discount'=>$this ->Total_Discount,
            'total_bf_taxes'=>$this ->Total_BF_Taxes,
            'total_taxes'=>$this ->Total_Taxes,
            'total_price'=>$this ->Total_Return_Value,
            'total_cost'=>$this ->TotalCost,
            'pay'=>$this ->Pay,
            'safe'=>$safeName,
            'client'=>$cliName,
            'executor'=>$exe,
            'delegate'=>$dele,
            'store'=>$stName,
            'coin'=>$coiName,
            'cost_center'=>$Cost_Center,
            'ship'=>$Ship,
            'user'=>$userName,
            'Sales_Code'=>Sales::find($this->Sales)->Code,


            'products'=>$this->when(!empty($this->id), function () {

                $details=ProductReturnSalesResources::collection(ReturnSalesProducts::where('Return',$this->id)->get());

                return $details;
            }),

        ];


        return $data ;
    }

}
